/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import classNames from "classnames";
import React from "react";
import { Divider } from "semantic-ui-react";
import { Heading } from "../typography";
/**
 * Content to define a form section.
 *
 * @param {FormSectionPropsInterface} props - Props injected to the component.
 *
 * @return {React.ReactElement}
 */
export const FormSection = (props) => {
    const { children, className, heading, headingLevel, ["data-testid"]: testId } = props;
    const classes = classNames("form-section", className);
    return (React.createElement("div", { className: classes, "data-testid": testId },
        React.createElement(Divider, { className: "form-section-top-divider" }),
        React.createElement(Heading, { className: "form-section-heading", as: headingLevel }, heading),
        React.createElement(Divider, { className: "form-section-bottom-divider", hidden: true }),
        children));
};
/**
 * Default props for the component.
 */
FormSection.defaultProps = {
    "data-testid": "form-section",
    headingLevel: "h5"
};
//# sourceMappingURL=form-section.js.map