/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import classNames from "classnames";
import React from "react";
import { Icon } from "semantic-ui-react";
import { LinkButton } from "../../button";
import { InfoCard } from "../../card";
import { GenericIcon } from "../../icon";
/**
 * Resource Grid Card component.
 *
 * @param {ResourceGridCardPropsInterface} props - Props injected to the component.
 * @return {React.ReactElement}
 */
export const ResourceGridCard = (props) => {
    const { className, comingSoonRibbonLabel, disabled, editButtonLabel, onDelete, onEdit, isResourceComingSoon, resourceCategory, resourceDescription, resourceImage, resourceName, showActions, showResourceEdit, showResourceDelete, showTooltips, testId } = props, rest = __rest(props, ["className", "comingSoonRibbonLabel", "disabled", "editButtonLabel", "onDelete", "onEdit", "isResourceComingSoon", "resourceCategory", "resourceDescription", "resourceImage", "resourceName", "showActions", "showResourceEdit", "showResourceDelete", "showTooltips", "testId"]);
    const classes = classNames("resource-grid-card", className);
    return (React.createElement(InfoCard, Object.assign({ className: classes, ribbon: isResourceComingSoon && comingSoonRibbonLabel, header: resourceName, subHeader: resourceCategory, description: resourceDescription, image: resourceImage, disabled: isResourceComingSoon || disabled, showTooltips: !(isResourceComingSoon || disabled) && showTooltips, action: showActions && (React.createElement("div", { className: "actions" },
            showResourceEdit && onEdit && (React.createElement(LinkButton, { disabled: isResourceComingSoon || disabled, hoverType: "underline", className: "info-card-inner-action", onClick: onEdit, "data-testid": `${testId}-item-edit-button` },
                editButtonLabel,
                React.createElement(Icon, { name: "caret right" }))),
            showResourceDelete && onDelete && !(isResourceComingSoon || disabled) && (React.createElement(GenericIcon, { square: true, hoverable: true, transparent: true, floated: "right", className: "delete-button", icon: React.createElement(Icon, { name: "trash alternate" }), "data-testid": `${testId}-item-delete-button`, onClick: onDelete })))) }, rest)));
};
/**
 * Default props for the component.
 */
ResourceGridCard.defaultProps = {
    comingSoonRibbonLabel: "Coming Soon",
    "data-testid": "resource-grid-card",
    editButtonLabel: "Configure",
    imageOptions: {
        floated: false,
        inline: true
    },
    imageSize: "micro",
    showTooltips: true
};
//# sourceMappingURL=resource-grid-card.js.map