/**
* Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
*
* WSO2 Inc. licenses this file to you under the Apache License,
* Version 2.0 (the 'License'); you may not use this file except
* in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* 'AS IS' BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied. See the License for the
* specific language governing permissions and limitations
* under the License.
*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { CommonUtils } from "@wso2is/core/utils";
import classNames from "classnames";
import React, { useEffect, useRef, useState } from "react";
import { Button, Icon, Input, Popup } from "semantic-ui-react";
/**
 * Copy to clipboard input field component.
 *
 * @param {CopyInputFieldPropsInterface} props - Props injected to the component.
 *
 * @return {React.ReactElement}
 */
export const CopyInputField = (props) => {
    const { value, className, hideSecretLabel, secret, showSecretLabel, label, ["data-testid"]: testId } = props;
    const classes = classNames("copy-input", className);
    const inputRef = useRef(null);
    const copyButtonRef = useRef(null);
    const [copied, setCopied] = useState(false);
    const [show, setShow] = useState(false);
    useEffect(() => {
        if (copied) {
            copyButtonRef.current.focus();
        }
    }, [copied]);
    /**
     * Copies the value to the users clipboard.
     *
     * @param event {MouseEvent<HTMLButtonElement>)}
     */
    const copyValueToClipboard = (event) => __awaiter(void 0, void 0, void 0, function* () {
        var _a, _b;
        event.stopPropagation();
        /**
         * Since the reference input component is a {@link Input} we can
         * directly get the current value from props itself.
         */
        const _selection = (_b = (_a = inputRef.current) === null || _a === void 0 ? void 0 : _a.props["value"]) !== null && _b !== void 0 ? _b : "";
        yield CommonUtils.copyTextToClipboard(_selection);
        setCopied(true);
    });
    return (React.createElement(Input, { label: label, ref: inputRef, value: value, labelPosition: "right", readOnly: true, action: React.createElement(Popup, { trigger: (React.createElement(Button, { className: "copy-input-action", icon: "copy", type: "button", onMouseEnter: () => {
                    setCopied(false);
                }, ref: copyButtonRef, onClick: copyValueToClipboard })), openOnTriggerFocus: true, closeOnTriggerBlur: true, position: "top center", content: copied ? "Copied!" : "Copy to clipboard", inverted: true }), fluid: true, className: classes, type: !secret
            ? "text"
            : show
                ? "text"
                : "password", icon: secret && (React.createElement(Popup, { trigger: (React.createElement(Icon, { className: "copy-input-eye-icon", name: !show
                    ? "eye"
                    : "eye slash", disabled: !value, link: true, onClick: () => {
                    setShow(!show);
                } })), position: "top center", content: !show
                ? showSecretLabel
                : hideSecretLabel, inverted: true })), "data-testid": `${testId}-wrapper` }));
};
/**
 * Default proptypes for the copy input component.
 */
CopyInputField.defaultProps = {
    "data-testid": "copy-input",
    hideSecretLabel: "Show",
    secret: false,
    showSecretLabel: "Hide"
};
//# sourceMappingURL=copy-input-field.js.map