/*
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import classNames from "classnames";
import React, { useState } from "react";
import { Icon, Input, Label } from "semantic-ui-react";
/**
 * Search box with filter labels.
 *
 * @param {React.PropsWithChildren<SearchWithFilterLabelsPropsInterface>} props - Props injected to the component.
 *
 * @return {React.ReactElement}
 */
export const SearchWithFilterLabels = (props) => {
    const { className, filterLabels, onFilter, onSearch, isLoading, icon, placeholder, searchInput, ["data-testid"]: testId } = props, rest = __rest(props, ["className", "filterLabels", "onFilter", "onSearch", "isLoading", "icon", "placeholder", "searchInput", "data-testid"]);
    const [searchQuery, setSearchQuery] = useState(null);
    const [selectedFilterLabels, setSelectedFilterLabels] = useState([]);
    const classes = classNames("search-with-filter-labels", className);
    /**
     * Handles the Search input onchange.
     *
     * @param {React.ChangeEvent<HTMLInputElement>} e - Change event.
     * @param {string} value - Input value.
     */
    const handleQuerySearch = (e, { value }) => {
        setSearchQuery(value);
        onSearch(value, selectedFilterLabels);
    };
    /**
     * Handles filters on click.
     *
     * @param {string} newFilter - Newly selected label.
     */
    const handleFilter = (newFilter) => {
        let selectedFilters = [];
        if (selectedFilterLabels.includes(newFilter)) {
            selectedFilters = selectedFilterLabels.filter((selectedLabel) => selectedLabel !== newFilter);
        }
        else {
            selectedFilters = [...selectedFilterLabels, newFilter];
        }
        setSelectedFilterLabels(selectedFilters);
        onFilter(searchQuery, selectedFilters);
    };
    return (React.createElement("div", { className: classes, "data-testid": testId },
        searchInput
            ? (React.createElement("div", { className: "search-input-wrapper" }, searchInput))
            : (React.createElement("div", { className: "search-input-wrapper" },
                React.createElement(Input, Object.assign({ fluid: true, loading: isLoading, icon: icon !== null && icon !== void 0 ? icon : React.createElement(Icon, { name: "search" }), value: searchQuery, iconPosition: "left", onChange: handleQuerySearch, placeholder: placeholder }, rest)))),
        (filterLabels && Array.isArray(filterLabels) && filterLabels.length > 0) && (React.createElement(Label.Group, null, filterLabels.map((label, index) => {
            const isSelected = selectedFilterLabels.includes(label);
            return (React.createElement(Label, { basic: true, key: index, as: "a", className: `filter-label ${isSelected ? "active" : ""}`, onClick: () => handleFilter(label) },
                label,
                isSelected && React.createElement(Icon, { name: "check" })));
        })))));
};
/**
 * Default proptypes for the component.
 */
SearchWithFilterLabels.defaultProps = {
    "data-testid": "search-with-filters",
    placeholder: "Search"
};
//# sourceMappingURL=search-with-filter-labels.js.map