/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from "react";
import { Divider, Header, Icon, Message } from "semantic-ui-react";
/**
 * MessageInfo component.
 * @deprecated Use the new `Message` component from `@wso2is/react-components` instead.
 * @param {MessageInfoProps} props - Props injected in to the messageInfo component.
 *
 * @return {React.ReactElement}
 */
export const MessageInfo = (props) => {
    const { header, content, ["data-testid"]: testId } = props;
    const generateContent = () => {
        return (React.createElement(React.Fragment, null,
            React.createElement(Divider, { hidden: true, className: 'message-info-text' }),
            React.createElement("div", null, (content))));
    };
    return (React.createElement(Message, { info: true, header: (React.createElement(Header, { as: "h4" },
            React.createElement(Header.Content, null,
                React.createElement(Icon, { name: "info circle" }),
                (header)))), content: generateContent() }));
};
/**
 * Default proptypes for the message info component.
 */
MessageInfo.defaultProps = {
    header: null,
    content: null,
    "data-testid": "message-info",
};
//# sourceMappingURL=message-info.js.map