/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { AppConstants } from "@wso2is/core/constants";
import React, { useEffect, useState } from "react";
import { Heading } from "../../typography";
import { ConfirmationModal } from "../confirmation-modal";
/**
 * This component listens to the `chunk load error` and pops up a modal
 * when this error is occurred.
 */
export const ChunkErrorModal = (props) => {
    const { heading, description, primaryActionText } = props;
    const [showModal, setShowModal] = useState(false);
    /**
     * Called on mount and unmount to add/remove the event listener.
     */
    useEffect(() => {
        addEventListener(AppConstants.CHUNK_LOAD_ERROR_EVENT, () => setShowModal(true));
        return () => {
            removeEventListener(AppConstants.CHUNK_LOAD_ERROR_EVENT, () => setShowModal(true));
        };
    }, []);
    return (React.createElement(ConfirmationModal, { animated: true, type: "warning", textAlign: "center", primaryAction: primaryActionText, onPrimaryActionClick: () => {
            location.reload();
        }, "data-testid": "chunk-error-modal", open: showModal },
        React.createElement(ConfirmationModal.Content, null,
            React.createElement(Heading, { as: "h3" }, heading),
            React.createElement("p", null, description))));
};
//# sourceMappingURL=chunk-error-modal.js.map