/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { TestableComponentInterface } from "@wso2is/core/models";
import React, { FunctionComponent, PropsWithChildren, ReactNode } from "react";
/**
 * Proptypes transfer component.
 */
export interface TransferComponentPropsInterface extends TestableComponentInterface {
    /**
     * Render segments with basic formatting.
     */
    basic?: boolean;
    /**
     * Add border to segments.
     */
    bordered?: boolean;
    /**
     * Render with compact formatting. i.e. No padding etc.
     */
    compact?: boolean;
    /**
     * Additional CSS classes.
     */
    className?: string;
    handleUnelectedListSearch: (e: React.FormEvent<HTMLInputElement>, { value }: {
        value: string;
    }) => void;
    handleSelectedListSearch?: (e: React.FormEvent<HTMLInputElement>, { value }: {
        value: string;
    }) => void;
    handleHeaderCheckboxChange?: () => void;
    /**
     * position of the search icon
     */
    iconPosition?: "left";
    /**
     * Show loading placeholders.
     */
    isLoading?: boolean;
    isHeaderCheckboxChecked?: boolean;
    addItems?: () => void;
    removeItems?: () => void;
    searchPlaceholder: string;
    selectionComponent?: boolean;
    /**
     * Show/Hide list search.
     */
    showListSearch?: boolean;
    /**
     * Show/Hide select all checkbox.
     */
    showSelectAllCheckbox?: boolean;
    /**
     * Select all checkbox label.
     */
    selectAllCheckboxLabel?: ReactNode;
}
/**
 * Transfer list component.
 *
 * @param {TransferComponentPropsInterface} props - Props injected to the component.
 *
 * @return {React.ReactElement}
 */
export declare const TransferComponent: FunctionComponent<PropsWithChildren<TransferComponentPropsInterface>>;
