import { OctokitResponse } from "../OctokitResponse";
import { RequestHeaders } from "../RequestHeaders";
import { RequestRequestOptions } from "../RequestRequestOptions";
declare type RequiredPreview<T> = {
    mediaType: {
        previews: [T, ...string[]];
    };
};
export interface Endpoints {
    /**
     * @see https://developer.github.com/v3/apps/#delete-an-installation
     */
    "DELETE /app/installations/:installation_id": {
        parameters: AppsDeleteInstallationEndpoint;
        request: AppsDeleteInstallationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#unsuspend-an-installation
     */
    "DELETE /app/installations/:installation_id/suspended": {
        parameters: AppsUnsuspendInstallationEndpoint;
        request: AppsUnsuspendInstallationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#delete-an-app-authorization
     */
    "DELETE /applications/:client_id/grant": {
        parameters: AppsDeleteAuthorizationEndpoint;
        request: AppsDeleteAuthorizationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#revoke-a-grant-for-an-application
     */
    "DELETE /applications/:client_id/grants/:access_token": {
        parameters: AppsRevokeGrantForApplicationEndpoint;
        request: AppsRevokeGrantForApplicationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#delete-an-app-token
     */
    "DELETE /applications/:client_id/token": {
        parameters: AppsDeleteTokenEndpoint;
        request: AppsDeleteTokenRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#revoke-an-authorization-for-an-application
     */
    "DELETE /applications/:client_id/tokens/:access_token": {
        parameters: AppsRevokeAuthorizationForApplicationEndpoint;
        request: AppsRevokeAuthorizationForApplicationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#delete-a-grant
     */
    "DELETE /applications/grants/:grant_id": {
        parameters: OauthAuthorizationsDeleteGrantEndpoint;
        request: OauthAuthorizationsDeleteGrantRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#delete-an-authorization
     */
    "DELETE /authorizations/:authorization_id": {
        parameters: OauthAuthorizationsDeleteAuthorizationEndpoint;
        request: OauthAuthorizationsDeleteAuthorizationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#delete-a-gist
     */
    "DELETE /gists/:gist_id": {
        parameters: GistsDeleteEndpoint;
        request: GistsDeleteRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/gists/comments/#delete-a-comment
     */
    "DELETE /gists/:gist_id/comments/:comment_id": {
        parameters: GistsDeleteCommentEndpoint;
        request: GistsDeleteCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#unstar-a-gist
     */
    "DELETE /gists/:gist_id/star": {
        parameters: GistsUnstarEndpoint;
        request: GistsUnstarRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#revoke-an-installation-token
     */
    "DELETE /installation/token": {
        parameters: AppsRevokeInstallationTokenEndpoint;
        request: AppsRevokeInstallationTokenRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#delete-a-thread-subscription
     */
    "DELETE /notifications/threads/:thread_id/subscription": {
        parameters: ActivityDeleteThreadSubscriptionEndpoint;
        request: ActivityDeleteThreadSubscriptionRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#delete-a-self-hosted-runner-from-an-organization
     */
    "DELETE /orgs/:org/actions/runners/:runner_id": {
        parameters: ActionsDeleteSelfHostedRunnerFromOrgEndpoint;
        request: ActionsDeleteSelfHostedRunnerFromOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/blocking/#unblock-a-user
     */
    "DELETE /orgs/:org/blocks/:username": {
        parameters: OrgsUnblockUserEndpoint;
        request: OrgsUnblockUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#remove-a-credential-authorization-for-an-organization
     */
    "DELETE /orgs/:org/credential-authorizations/:credential_id": {
        parameters: OrgsRemoveCredentialAuthorizationEndpoint;
        request: OrgsRemoveCredentialAuthorizationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/hooks/#delete-a-hook
     */
    "DELETE /orgs/:org/hooks/:hook_id": {
        parameters: OrgsDeleteHookEndpoint;
        request: OrgsDeleteHookRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/interactions/orgs/#remove-interaction-restrictions-for-an-organization
     */
    "DELETE /orgs/:org/interaction-limits": {
        parameters: InteractionsRemoveRestrictionsForOrgEndpoint;
        request: InteractionsRemoveRestrictionsForOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#remove-a-member
     */
    "DELETE /orgs/:org/members/:username": {
        parameters: OrgsRemoveMemberEndpoint;
        request: OrgsRemoveMemberRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#remove-organization-membership
     */
    "DELETE /orgs/:org/memberships/:username": {
        parameters: OrgsRemoveMembershipEndpoint;
        request: OrgsRemoveMembershipRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#delete-an-organization-migration-archive
     */
    "DELETE /orgs/:org/migrations/:migration_id/archive": {
        parameters: MigrationsDeleteArchiveForOrgEndpoint;
        request: MigrationsDeleteArchiveForOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#unlock-an-organization-repository
     */
    "DELETE /orgs/:org/migrations/:migration_id/repos/:repo_name/lock": {
        parameters: MigrationsUnlockRepoForOrgEndpoint;
        request: MigrationsUnlockRepoForOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/outside_collaborators/#remove-outside-collaborator
     */
    "DELETE /orgs/:org/outside_collaborators/:username": {
        parameters: OrgsRemoveOutsideCollaboratorEndpoint;
        request: OrgsRemoveOutsideCollaboratorRequestOptions;
        response: OctokitResponse<OrgsRemoveOutsideCollaboratorResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#conceal-a-users-membership
     */
    "DELETE /orgs/:org/public_members/:username": {
        parameters: OrgsConcealMembershipEndpoint;
        request: OrgsConcealMembershipRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#delete-team
     */
    "DELETE /orgs/:org/teams/:team_slug": {
        parameters: TeamsDeleteInOrgEndpoint;
        request: TeamsDeleteInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#delete-a-discussion
     */
    "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number": {
        parameters: TeamsDeleteDiscussionInOrgEndpoint;
        request: TeamsDeleteDiscussionInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#delete-a-comment
     */
    "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number": {
        parameters: TeamsDeleteDiscussionCommentInOrgEndpoint;
        request: TeamsDeleteDiscussionCommentInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-team-discussion-comment-reaction
     */
    "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id": {
        parameters: ReactionsDeleteForTeamDiscussionCommentEndpoint;
        request: ReactionsDeleteForTeamDiscussionCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-team-discussion-reaction
     */
    "DELETE /orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions/:reaction_id": {
        parameters: ReactionsDeleteForTeamDiscussionEndpoint;
        request: ReactionsDeleteForTeamDiscussionRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#remove-team-membership
     */
    "DELETE /orgs/:org/teams/:team_slug/memberships/:username": {
        parameters: TeamsRemoveMembershipInOrgEndpoint;
        request: TeamsRemoveMembershipInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#remove-team-project
     */
    "DELETE /orgs/:org/teams/:team_slug/projects/:project_id": {
        parameters: TeamsRemoveProjectInOrgEndpoint;
        request: TeamsRemoveProjectInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#remove-team-repository
     */
    "DELETE /orgs/:org/teams/:team_slug/repos/:owner/:repo": {
        parameters: TeamsRemoveRepoInOrgEndpoint;
        request: TeamsRemoveRepoInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#delete-a-project
     */
    "DELETE /projects/:project_id": {
        parameters: ProjectsDeleteEndpoint;
        request: ProjectsDeleteRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/projects/collaborators/#remove-user-as-a-collaborator
     */
    "DELETE /projects/:project_id/collaborators/:username": {
        parameters: ProjectsRemoveCollaboratorEndpoint;
        request: ProjectsRemoveCollaboratorRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/projects/columns/#delete-a-project-column
     */
    "DELETE /projects/columns/:column_id": {
        parameters: ProjectsDeleteColumnEndpoint;
        request: ProjectsDeleteColumnRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/projects/cards/#delete-a-project-card
     */
    "DELETE /projects/columns/cards/:card_id": {
        parameters: ProjectsDeleteCardEndpoint;
        request: ProjectsDeleteCardRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-a-reaction-legacy
     */
    "DELETE /reactions/:reaction_id": {
        parameters: ReactionsDeleteLegacyEndpoint;
        request: ReactionsDeleteLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#delete-a-repository
     */
    "DELETE /repos/:owner/:repo": {
        parameters: ReposDeleteEndpoint;
        request: ReposDeleteRequestOptions;
        response: OctokitResponse<ReposDeleteResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/artifacts/#delete-an-artifact
     */
    "DELETE /repos/:owner/:repo/actions/artifacts/:artifact_id": {
        parameters: ActionsDeleteArtifactEndpoint;
        request: ActionsDeleteArtifactRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#delete-a-self-hosted-runner-from-a-repository
     */
    "DELETE /repos/:owner/:repo/actions/runners/:runner_id": {
        parameters: ActionsDeleteSelfHostedRunnerFromRepoEndpoint;
        request: ActionsDeleteSelfHostedRunnerFromRepoRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#delete-workflow-run-logs
     */
    "DELETE /repos/:owner/:repo/actions/runs/:run_id/logs": {
        parameters: ActionsDeleteWorkflowRunLogsEndpoint;
        request: ActionsDeleteWorkflowRunLogsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#delete-a-secret-from-a-repository
     */
    "DELETE /repos/:owner/:repo/actions/secrets/:name": {
        parameters: ActionsDeleteSecretFromRepoEndpoint;
        request: ActionsDeleteSecretFromRepoRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#disable-automated-security-fixes
     */
    "DELETE /repos/:owner/:repo/automated-security-fixes": {
        parameters: ReposDisableAutomatedSecurityFixesEndpoint;
        request: ReposDisableAutomatedSecurityFixesRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-branch-protection
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection": {
        parameters: ReposRemoveBranchProtectionEndpoint;
        request: ReposRemoveBranchProtectionRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-admin-enforcement-of-protected-branch
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/enforce_admins": {
        parameters: ReposRemoveProtectedBranchAdminEnforcementEndpoint;
        request: ReposRemoveProtectedBranchAdminEnforcementRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-pull-request-review-enforcement-of-protected-branch
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews": {
        parameters: ReposRemoveProtectedBranchPullRequestReviewEnforcementEndpoint;
        request: ReposRemoveProtectedBranchPullRequestReviewEnforcementRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-required-signatures-of-protected-branch
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/required_signatures": {
        parameters: ReposRemoveProtectedBranchRequiredSignaturesEndpoint;
        request: ReposRemoveProtectedBranchRequiredSignaturesRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-required-status-checks-of-protected-branch
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/required_status_checks": {
        parameters: ReposRemoveProtectedBranchRequiredStatusChecksEndpoint;
        request: ReposRemoveProtectedBranchRequiredStatusChecksRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-required-status-checks-contexts-of-protected-branch
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": {
        parameters: ReposRemoveProtectedBranchRequiredStatusChecksContextsEndpoint;
        request: ReposRemoveProtectedBranchRequiredStatusChecksContextsRequestOptions;
        response: OctokitResponse<ReposRemoveProtectedBranchRequiredStatusChecksContextsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-restrictions-of-protected-branch
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions": {
        parameters: ReposRemoveProtectedBranchRestrictionsEndpoint;
        request: ReposRemoveProtectedBranchRestrictionsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-app-restrictions-of-protected-branch
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": {
        parameters: ReposRemoveProtectedBranchAppRestrictionsEndpoint;
        request: ReposRemoveProtectedBranchAppRestrictionsRequestOptions;
        response: OctokitResponse<ReposRemoveProtectedBranchAppRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-team-restrictions-of-protected-branch
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": {
        parameters: ReposRemoveProtectedBranchTeamRestrictionsEndpoint;
        request: ReposRemoveProtectedBranchTeamRestrictionsRequestOptions;
        response: OctokitResponse<ReposRemoveProtectedBranchTeamRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#remove-user-restrictions-of-protected-branch
     */
    "DELETE /repos/:owner/:repo/branches/:branch/protection/restrictions/users": {
        parameters: ReposRemoveProtectedBranchUserRestrictionsEndpoint;
        request: ReposRemoveProtectedBranchUserRestrictionsRequestOptions;
        response: OctokitResponse<ReposRemoveProtectedBranchUserRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/collaborators/#remove-user-as-a-collaborator
     */
    "DELETE /repos/:owner/:repo/collaborators/:username": {
        parameters: ReposRemoveCollaboratorEndpoint;
        request: ReposRemoveCollaboratorRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/comments/#delete-a-commit-comment
     */
    "DELETE /repos/:owner/:repo/comments/:comment_id": {
        parameters: ReposDeleteCommitCommentEndpoint;
        request: ReposDeleteCommitCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-a-commit-comment-reaction
     */
    "DELETE /repos/:owner/:repo/comments/:comment_id/reactions/:reaction_id": {
        parameters: ReactionsDeleteForCommitCommentEndpoint;
        request: ReactionsDeleteForCommitCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/contents/#delete-a-file
     */
    "DELETE /repos/:owner/:repo/contents/:path": {
        parameters: ReposDeleteFileEndpoint;
        request: ReposDeleteFileRequestOptions;
        response: OctokitResponse<ReposDeleteFileResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#delete-a-deployment
     */
    "DELETE /repos/:owner/:repo/deployments/:deployment_id": {
        parameters: ReposDeleteDeploymentEndpoint;
        request: ReposDeleteDeploymentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/downloads/#delete-a-download
     */
    "DELETE /repos/:owner/:repo/downloads/:download_id": {
        parameters: ReposDeleteDownloadEndpoint;
        request: ReposDeleteDownloadRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/git/refs/#delete-a-reference
     */
    "DELETE /repos/:owner/:repo/git/refs/:ref": {
        parameters: GitDeleteRefEndpoint;
        request: GitDeleteRefRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#delete-a-hook
     */
    "DELETE /repos/:owner/:repo/hooks/:hook_id": {
        parameters: ReposDeleteHookEndpoint;
        request: ReposDeleteHookRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#cancel-an-import
     */
    "DELETE /repos/:owner/:repo/import": {
        parameters: MigrationsCancelImportEndpoint;
        request: MigrationsCancelImportRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/interactions/repos/#remove-interaction-restrictions-for-a-repository
     */
    "DELETE /repos/:owner/:repo/interaction-limits": {
        parameters: InteractionsRemoveRestrictionsForRepoEndpoint;
        request: InteractionsRemoveRestrictionsForRepoRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/invitations/#delete-a-repository-invitation
     */
    "DELETE /repos/:owner/:repo/invitations/:invitation_id": {
        parameters: ReposDeleteInvitationEndpoint;
        request: ReposDeleteInvitationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/issues/assignees/#remove-assignees-from-an-issue
     */
    "DELETE /repos/:owner/:repo/issues/:issue_number/assignees": {
        parameters: IssuesRemoveAssigneesEndpoint;
        request: IssuesRemoveAssigneesRequestOptions;
        response: OctokitResponse<IssuesRemoveAssigneesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#remove-all-labels-from-an-issue
     */
    "DELETE /repos/:owner/:repo/issues/:issue_number/labels": {
        parameters: IssuesRemoveAllLabelsEndpoint;
        request: IssuesRemoveAllLabelsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#remove-a-label-from-an-issue
     */
    "DELETE /repos/:owner/:repo/issues/:issue_number/labels/:name": {
        parameters: IssuesRemoveLabelEndpoint;
        request: IssuesRemoveLabelRequestOptions;
        response: OctokitResponse<IssuesRemoveLabelResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#unlock-an-issue
     */
    "DELETE /repos/:owner/:repo/issues/:issue_number/lock": {
        parameters: IssuesUnlockEndpoint;
        request: IssuesUnlockRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-an-issue-reaction
     */
    "DELETE /repos/:owner/:repo/issues/:issue_number/reactions/:reaction_id": {
        parameters: ReactionsDeleteForIssueEndpoint;
        request: ReactionsDeleteForIssueRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/issues/comments/#delete-a-comment
     */
    "DELETE /repos/:owner/:repo/issues/comments/:comment_id": {
        parameters: IssuesDeleteCommentEndpoint;
        request: IssuesDeleteCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-an-issue-comment-reaction
     */
    "DELETE /repos/:owner/:repo/issues/comments/:comment_id/reactions/:reaction_id": {
        parameters: ReactionsDeleteForIssueCommentEndpoint;
        request: ReactionsDeleteForIssueCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/keys/#remove-a-deploy-key
     */
    "DELETE /repos/:owner/:repo/keys/:key_id": {
        parameters: ReposRemoveDeployKeyEndpoint;
        request: ReposRemoveDeployKeyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#delete-a-label
     */
    "DELETE /repos/:owner/:repo/labels/:name": {
        parameters: IssuesDeleteLabelEndpoint;
        request: IssuesDeleteLabelRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/issues/milestones/#delete-a-milestone
     */
    "DELETE /repos/:owner/:repo/milestones/:milestone_number": {
        parameters: IssuesDeleteMilestoneEndpoint;
        request: IssuesDeleteMilestoneRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#disable-a-pages-site
     */
    "DELETE /repos/:owner/:repo/pages": {
        parameters: ReposDisablePagesSiteEndpoint;
        request: ReposDisablePagesSiteRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/review_requests/#delete-a-review-request
     */
    "DELETE /repos/:owner/:repo/pulls/:pull_number/requested_reviewers": {
        parameters: PullsDeleteReviewRequestEndpoint;
        request: PullsDeleteReviewRequestRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#delete-a-pending-review
     */
    "DELETE /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id": {
        parameters: PullsDeletePendingReviewEndpoint;
        request: PullsDeletePendingReviewRequestOptions;
        response: OctokitResponse<PullsDeletePendingReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#delete-a-comment
     */
    "DELETE /repos/:owner/:repo/pulls/comments/:comment_id": {
        parameters: PullsDeleteCommentEndpoint;
        request: PullsDeleteCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#delete-a-pull-request-comment-reaction
     */
    "DELETE /repos/:owner/:repo/pulls/comments/:comment_id/reactions/:reaction_id": {
        parameters: ReactionsDeleteForPullRequestCommentEndpoint;
        request: ReactionsDeleteForPullRequestCommentRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#delete-a-release
     */
    "DELETE /repos/:owner/:repo/releases/:release_id": {
        parameters: ReposDeleteReleaseEndpoint;
        request: ReposDeleteReleaseRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#delete-a-release-asset
     */
    "DELETE /repos/:owner/:repo/releases/assets/:asset_id": {
        parameters: ReposDeleteReleaseAssetEndpoint;
        request: ReposDeleteReleaseAssetRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#delete-a-repository-subscription
     */
    "DELETE /repos/:owner/:repo/subscription": {
        parameters: ActivityDeleteRepoSubscriptionEndpoint;
        request: ActivityDeleteRepoSubscriptionRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#disable-vulnerability-alerts
     */
    "DELETE /repos/:owner/:repo/vulnerability-alerts": {
        parameters: ReposDisableVulnerabilityAlertsEndpoint;
        request: ReposDisableVulnerabilityAlertsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/scim/#remove-a-user-from-the-organization
     */
    "DELETE /scim/v2/organizations/:org/Users/:scim_user_id": {
        parameters: ScimRemoveUserFromOrgEndpoint;
        request: ScimRemoveUserFromOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#delete-team-legacy
     */
    "DELETE /teams/:team_id": {
        parameters: TeamsDeleteLegacyEndpoint;
        request: TeamsDeleteLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#delete-a-discussion-legacy
     */
    "DELETE /teams/:team_id/discussions/:discussion_number": {
        parameters: TeamsDeleteDiscussionLegacyEndpoint;
        request: TeamsDeleteDiscussionLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#delete-a-comment-legacy
     */
    "DELETE /teams/:team_id/discussions/:discussion_number/comments/:comment_number": {
        parameters: TeamsDeleteDiscussionCommentLegacyEndpoint;
        request: TeamsDeleteDiscussionCommentLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#remove-team-member-legacy
     */
    "DELETE /teams/:team_id/members/:username": {
        parameters: TeamsRemoveMemberLegacyEndpoint;
        request: TeamsRemoveMemberLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#remove-team-membership-legacy
     */
    "DELETE /teams/:team_id/memberships/:username": {
        parameters: TeamsRemoveMembershipLegacyEndpoint;
        request: TeamsRemoveMembershipLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#remove-team-project-legacy
     */
    "DELETE /teams/:team_id/projects/:project_id": {
        parameters: TeamsRemoveProjectLegacyEndpoint;
        request: TeamsRemoveProjectLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#remove-team-repository-legacy
     */
    "DELETE /teams/:team_id/repos/:owner/:repo": {
        parameters: TeamsRemoveRepoLegacyEndpoint;
        request: TeamsRemoveRepoLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/blocking/#unblock-a-user
     */
    "DELETE /user/blocks/:username": {
        parameters: UsersUnblockEndpoint;
        request: UsersUnblockRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/emails/#delete-email-addresses
     */
    "DELETE /user/emails": {
        parameters: UsersDeleteEmailsEndpoint;
        request: UsersDeleteEmailsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#unfollow-a-user
     */
    "DELETE /user/following/:username": {
        parameters: UsersUnfollowEndpoint;
        request: UsersUnfollowRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/gpg_keys/#delete-a-gpg-key
     */
    "DELETE /user/gpg_keys/:gpg_key_id": {
        parameters: UsersDeleteGpgKeyEndpoint;
        request: UsersDeleteGpgKeyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#remove-repository-from-installation
     */
    "DELETE /user/installations/:installation_id/repositories/:repository_id": {
        parameters: AppsRemoveRepoFromInstallationEndpoint;
        request: AppsRemoveRepoFromInstallationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/keys/#delete-a-public-key
     */
    "DELETE /user/keys/:key_id": {
        parameters: UsersDeletePublicKeyEndpoint;
        request: UsersDeletePublicKeyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#delete-a-user-migration-archive
     */
    "DELETE /user/migrations/:migration_id/archive": {
        parameters: MigrationsDeleteArchiveForAuthenticatedUserEndpoint;
        request: MigrationsDeleteArchiveForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#unlock-a-user-repository
     */
    "DELETE /user/migrations/:migration_id/repos/:repo_name/lock": {
        parameters: MigrationsUnlockRepoForAuthenticatedUserEndpoint;
        request: MigrationsUnlockRepoForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/invitations/#decline-a-repository-invitation
     */
    "DELETE /user/repository_invitations/:invitation_id": {
        parameters: ReposDeclineInvitationEndpoint;
        request: ReposDeclineInvitationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/starring/#unstar-a-repository-for-the-authenticated-user
     */
    "DELETE /user/starred/:owner/:repo": {
        parameters: ActivityUnstarRepoForAuthenticatedUserEndpoint;
        request: ActivityUnstarRepoForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#stop-watching-a-repository-legacy
     */
    "DELETE /user/subscriptions/:owner/:repo": {
        parameters: ActivityStopWatchingRepoLegacyEndpoint;
        request: ActivityStopWatchingRepoLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#get-the-authenticated-github-app
     */
    "GET /app": {
        parameters: AppsGetAuthenticatedEndpoint;
        request: AppsGetAuthenticatedRequestOptions;
        response: OctokitResponse<AppsGetAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#list-installations
     */
    "GET /app/installations": {
        parameters: AppsListInstallationsEndpoint;
        request: AppsListInstallationsRequestOptions;
        response: OctokitResponse<AppsListInstallationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#get-an-installation
     */
    "GET /app/installations/:installation_id": {
        parameters: AppsGetInstallationEndpoint;
        request: AppsGetInstallationRequestOptions;
        response: OctokitResponse<AppsGetInstallationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#check-an-authorization
     */
    "GET /applications/:client_id/tokens/:access_token": {
        parameters: AppsCheckAuthorizationEndpoint;
        request: AppsCheckAuthorizationRequestOptions;
        response: OctokitResponse<AppsCheckAuthorizationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#list-your-grants
     */
    "GET /applications/grants": {
        parameters: OauthAuthorizationsListGrantsEndpoint;
        request: OauthAuthorizationsListGrantsRequestOptions;
        response: OctokitResponse<OauthAuthorizationsListGrantsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#get-a-single-grant
     */
    "GET /applications/grants/:grant_id": {
        parameters: OauthAuthorizationsGetGrantEndpoint;
        request: OauthAuthorizationsGetGrantRequestOptions;
        response: OctokitResponse<OauthAuthorizationsGetGrantResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#get-a-single-github-app
     */
    "GET /apps/:app_slug": {
        parameters: AppsGetBySlugEndpoint;
        request: AppsGetBySlugRequestOptions;
        response: OctokitResponse<AppsGetBySlugResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#list-your-authorizations
     */
    "GET /authorizations": {
        parameters: OauthAuthorizationsListAuthorizationsEndpoint;
        request: OauthAuthorizationsListAuthorizationsRequestOptions;
        response: OctokitResponse<OauthAuthorizationsListAuthorizationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#get-a-single-authorization
     */
    "GET /authorizations/:authorization_id": {
        parameters: OauthAuthorizationsGetAuthorizationEndpoint;
        request: OauthAuthorizationsGetAuthorizationRequestOptions;
        response: OctokitResponse<OauthAuthorizationsGetAuthorizationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/codes_of_conduct/#list-all-codes-of-conduct
     */
    "GET /codes_of_conduct": {
        parameters: CodesOfConductGetAllCodesOfConductEndpoint;
        request: CodesOfConductGetAllCodesOfConductRequestOptions;
        response: OctokitResponse<CodesOfConductGetAllCodesOfConductResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/codes_of_conduct/#get-an-individual-code-of-conduct
     */
    "GET /codes_of_conduct/:key": {
        parameters: CodesOfConductGetConductCodeEndpoint;
        request: CodesOfConductGetConductCodeRequestOptions;
        response: OctokitResponse<CodesOfConductGetConductCodeResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/emojis/#emojis
     */
    "GET /emojis": {
        parameters: EmojisGetEndpoint;
        request: EmojisGetRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-public-events
     */
    "GET /events": {
        parameters: ActivityListPublicEventsEndpoint;
        request: ActivityListPublicEventsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/feeds/#get-feeds
     */
    "GET /feeds": {
        parameters: ActivityGetFeedsEndpoint;
        request: ActivityGetFeedsRequestOptions;
        response: OctokitResponse<ActivityGetFeedsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#list-gists-for-the-authenticated-user
     */
    "GET /gists": {
        parameters: GistsListEndpoint;
        request: GistsListRequestOptions;
        response: OctokitResponse<GistsListResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#get-a-gist
     */
    "GET /gists/:gist_id": {
        parameters: GistsGetEndpoint;
        request: GistsGetRequestOptions;
        response: OctokitResponse<GistsGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#get-a-specific-revision-of-a-gist
     */
    "GET /gists/:gist_id/:sha": {
        parameters: GistsGetRevisionEndpoint;
        request: GistsGetRevisionRequestOptions;
        response: OctokitResponse<GistsGetRevisionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/comments/#list-comments-on-a-gist
     */
    "GET /gists/:gist_id/comments": {
        parameters: GistsListCommentsEndpoint;
        request: GistsListCommentsRequestOptions;
        response: OctokitResponse<GistsListCommentsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/comments/#get-a-single-comment
     */
    "GET /gists/:gist_id/comments/:comment_id": {
        parameters: GistsGetCommentEndpoint;
        request: GistsGetCommentRequestOptions;
        response: OctokitResponse<GistsGetCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#list-gist-commits
     */
    "GET /gists/:gist_id/commits": {
        parameters: GistsListCommitsEndpoint;
        request: GistsListCommitsRequestOptions;
        response: OctokitResponse<GistsListCommitsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#list-gist-forks
     */
    "GET /gists/:gist_id/forks": {
        parameters: GistsListForksEndpoint;
        request: GistsListForksRequestOptions;
        response: OctokitResponse<GistsListForksResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#check-if-a-gist-is-starred
     */
    "GET /gists/:gist_id/star": {
        parameters: GistsCheckIsStarredEndpoint;
        request: GistsCheckIsStarredRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#list-public-gists
     */
    "GET /gists/public": {
        parameters: GistsListPublicEndpoint;
        request: GistsListPublicRequestOptions;
        response: OctokitResponse<GistsListPublicResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#list-starred-gists
     */
    "GET /gists/starred": {
        parameters: GistsListStarredEndpoint;
        request: GistsListStarredRequestOptions;
        response: OctokitResponse<GistsListStarredResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gitignore/#listing-available-templates
     */
    "GET /gitignore/templates": {
        parameters: GitignoreListTemplatesEndpoint;
        request: GitignoreListTemplatesRequestOptions;
        response: OctokitResponse<GitignoreListTemplatesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gitignore/#get-a-single-template
     */
    "GET /gitignore/templates/:name": {
        parameters: GitignoreGetTemplateEndpoint;
        request: GitignoreGetTemplateRequestOptions;
        response: OctokitResponse<GitignoreGetTemplateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#list-repositories
     */
    "GET /installation/repositories": {
        parameters: AppsListReposEndpoint;
        request: AppsListReposRequestOptions;
        response: OctokitResponse<AppsListReposResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#list-issues-assigned-to-the-authenticated-user
     */
    "GET /issues": {
        parameters: IssuesListEndpoint;
        request: IssuesListRequestOptions;
        response: OctokitResponse<IssuesListResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/legacy/#search-issues
     */
    "GET /legacy/issues/search/:owner/:repository/:state/:keyword": {
        parameters: SearchIssuesLegacyEndpoint;
        request: SearchIssuesLegacyRequestOptions;
        response: OctokitResponse<SearchIssuesLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/legacy/#search-repositories
     */
    "GET /legacy/repos/search/:keyword": {
        parameters: SearchReposLegacyEndpoint;
        request: SearchReposLegacyRequestOptions;
        response: OctokitResponse<SearchReposLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/legacy/#email-search
     */
    "GET /legacy/user/email/:email": {
        parameters: SearchEmailLegacyEndpoint;
        request: SearchEmailLegacyRequestOptions;
        response: OctokitResponse<SearchEmailLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/legacy/#search-users
     */
    "GET /legacy/user/search/:keyword": {
        parameters: SearchUsersLegacyEndpoint;
        request: SearchUsersLegacyRequestOptions;
        response: OctokitResponse<SearchUsersLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/licenses/#list-commonly-used-licenses
     */
    "GET /licenses": {
        parameters: LicensesListCommonlyUsedEndpoint;
        request: LicensesListCommonlyUsedRequestOptions;
        response: OctokitResponse<LicensesListCommonlyUsedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/licenses/#get-an-individual-license
     */
    "GET /licenses/:license": {
        parameters: LicensesGetEndpoint;
        request: LicensesGetRequestOptions;
        response: OctokitResponse<LicensesGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#get-a-subscription-plan-for-an-account
     */
    "GET /marketplace_listing/accounts/:account_id": {
        parameters: AppsGetSubscriptionPlanForAccountEndpoint;
        request: AppsGetSubscriptionPlanForAccountRequestOptions;
        response: OctokitResponse<AppsGetSubscriptionPlanForAccountResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#list-plans
     */
    "GET /marketplace_listing/plans": {
        parameters: AppsListPlansEndpoint;
        request: AppsListPlansRequestOptions;
        response: OctokitResponse<AppsListPlansResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#list-accounts-for-a-plan
     */
    "GET /marketplace_listing/plans/:plan_id/accounts": {
        parameters: AppsListAccountsForPlanEndpoint;
        request: AppsListAccountsForPlanRequestOptions;
        response: OctokitResponse<AppsListAccountsForPlanResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#get-a-subscription-plan-for-an-account-stubbed
     */
    "GET /marketplace_listing/stubbed/accounts/:account_id": {
        parameters: AppsGetSubscriptionPlanForAccountStubbedEndpoint;
        request: AppsGetSubscriptionPlanForAccountStubbedRequestOptions;
        response: OctokitResponse<AppsGetSubscriptionPlanForAccountStubbedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#list-plans-stubbed
     */
    "GET /marketplace_listing/stubbed/plans": {
        parameters: AppsListPlansStubbedEndpoint;
        request: AppsListPlansStubbedRequestOptions;
        response: OctokitResponse<AppsListPlansStubbedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#list-accounts-for-a-plan-stubbed
     */
    "GET /marketplace_listing/stubbed/plans/:plan_id/accounts": {
        parameters: AppsListAccountsForPlanStubbedEndpoint;
        request: AppsListAccountsForPlanStubbedRequestOptions;
        response: OctokitResponse<AppsListAccountsForPlanStubbedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/meta/#meta
     */
    "GET /meta": {
        parameters: MetaGetEndpoint;
        request: MetaGetRequestOptions;
        response: OctokitResponse<MetaGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-public-events-for-a-network-of-repositories
     */
    "GET /networks/:owner/:repo/events": {
        parameters: ActivityListPublicEventsForRepoNetworkEndpoint;
        request: ActivityListPublicEventsForRepoNetworkRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#list-notifications-for-the-authenticated-user
     */
    "GET /notifications": {
        parameters: ActivityListNotificationsForAuthenticatedUserEndpoint;
        request: ActivityListNotificationsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ActivityListNotificationsForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#get-a-thread
     */
    "GET /notifications/threads/:thread_id": {
        parameters: ActivityGetThreadEndpoint;
        request: ActivityGetThreadRequestOptions;
        response: OctokitResponse<ActivityGetThreadResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#get-a-thread-subscription-for-the-authenticated-user
     */
    "GET /notifications/threads/:thread_id/subscription": {
        parameters: ActivityGetThreadSubscriptionForAuthenticatedUserEndpoint;
        request: ActivityGetThreadSubscriptionForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ActivityGetThreadSubscriptionForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#list-all-organizations
     */
    "GET /organizations": {
        parameters: OrgsListEndpoint;
        request: OrgsListRequestOptions;
        response: OctokitResponse<OrgsListResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#get-an-organization
     */
    "GET /orgs/:org": {
        parameters: OrgsGetEndpoint;
        request: OrgsGetRequestOptions;
        response: OctokitResponse<OrgsGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#list-self-hosted-runners-for-an-organization
     */
    "GET /orgs/:org/actions/runners": {
        parameters: ActionsListSelfHostedRunnersForOrgEndpoint;
        request: ActionsListSelfHostedRunnersForOrgRequestOptions;
        response: OctokitResponse<ActionsListSelfHostedRunnersForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#get-a-self-hosted-runner-for-an-organization
     */
    "GET /orgs/:org/actions/runners/:runner_id": {
        parameters: ActionsGetSelfHostedRunnerForOrgEndpoint;
        request: ActionsGetSelfHostedRunnerForOrgRequestOptions;
        response: OctokitResponse<ActionsGetSelfHostedRunnerForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#list-runner-applications-for-an-organization
     */
    "GET /orgs/:org/actions/runners/downloads": {
        parameters: ActionsListRunnerApplicationsForOrgEndpoint;
        request: ActionsListRunnerApplicationsForOrgRequestOptions;
        response: OctokitResponse<ActionsListRunnerApplicationsForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/blocking/#list-blocked-users
     */
    "GET /orgs/:org/blocks": {
        parameters: OrgsListBlockedUsersEndpoint;
        request: OrgsListBlockedUsersRequestOptions;
        response: OctokitResponse<OrgsListBlockedUsersResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/blocking/#check-whether-a-user-is-blocked-from-an-organization
     */
    "GET /orgs/:org/blocks/:username": {
        parameters: OrgsCheckBlockedUserEndpoint;
        request: OrgsCheckBlockedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#list-credential-authorizations-for-an-organization
     */
    "GET /orgs/:org/credential-authorizations": {
        parameters: OrgsListCredentialAuthorizationsEndpoint;
        request: OrgsListCredentialAuthorizationsRequestOptions;
        response: OctokitResponse<OrgsListCredentialAuthorizationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-public-organization-events
     */
    "GET /orgs/:org/events": {
        parameters: ActivityListPublicOrgEventsEndpoint;
        request: ActivityListPublicOrgEventsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/hooks/#list-hooks
     */
    "GET /orgs/:org/hooks": {
        parameters: OrgsListHooksEndpoint;
        request: OrgsListHooksRequestOptions;
        response: OctokitResponse<OrgsListHooksResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/hooks/#get-single-hook
     */
    "GET /orgs/:org/hooks/:hook_id": {
        parameters: OrgsGetHookEndpoint;
        request: OrgsGetHookRequestOptions;
        response: OctokitResponse<OrgsGetHookResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#get-an-organization-installation
     */
    "GET /orgs/:org/installation": {
        parameters: AppsGetOrgInstallationEndpoint;
        request: AppsGetOrgInstallationRequestOptions;
        response: OctokitResponse<AppsGetOrgInstallationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#list-installations-for-an-organization
     */
    "GET /orgs/:org/installations": {
        parameters: OrgsListInstallationsEndpoint;
        request: OrgsListInstallationsRequestOptions;
        response: OctokitResponse<OrgsListInstallationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/interactions/orgs/#get-interaction-restrictions-for-an-organization
     */
    "GET /orgs/:org/interaction-limits": {
        parameters: InteractionsGetRestrictionsForOrgEndpoint;
        request: InteractionsGetRestrictionsForOrgRequestOptions;
        response: OctokitResponse<InteractionsGetRestrictionsForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#list-pending-organization-invitations
     */
    "GET /orgs/:org/invitations": {
        parameters: OrgsListPendingInvitationsEndpoint;
        request: OrgsListPendingInvitationsRequestOptions;
        response: OctokitResponse<OrgsListPendingInvitationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#list-organization-invitation-teams
     */
    "GET /orgs/:org/invitations/:invitation_id/teams": {
        parameters: OrgsListInvitationTeamsEndpoint;
        request: OrgsListInvitationTeamsRequestOptions;
        response: OctokitResponse<OrgsListInvitationTeamsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#list-organization-issues-assigned-to-the-authenticated-user
     */
    "GET /orgs/:org/issues": {
        parameters: IssuesListForOrgEndpoint;
        request: IssuesListForOrgRequestOptions;
        response: OctokitResponse<IssuesListForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#members-list
     */
    "GET /orgs/:org/members": {
        parameters: OrgsListMembersEndpoint;
        request: OrgsListMembersRequestOptions;
        response: OctokitResponse<OrgsListMembersResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#check-membership
     */
    "GET /orgs/:org/members/:username": {
        parameters: OrgsCheckMembershipEndpoint;
        request: OrgsCheckMembershipRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#get-organization-membership
     */
    "GET /orgs/:org/memberships/:username": {
        parameters: OrgsGetMembershipEndpoint;
        request: OrgsGetMembershipRequestOptions;
        response: OctokitResponse<OrgsGetMembershipResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#list-organization-migrations
     */
    "GET /orgs/:org/migrations": {
        parameters: MigrationsListForOrgEndpoint;
        request: MigrationsListForOrgRequestOptions;
        response: OctokitResponse<MigrationsListForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#get-the-status-of-an-organization-migration
     */
    "GET /orgs/:org/migrations/:migration_id": {
        parameters: MigrationsGetStatusForOrgEndpoint;
        request: MigrationsGetStatusForOrgRequestOptions;
        response: OctokitResponse<MigrationsGetStatusForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#download-an-organization-migration-archive
     */
    "GET /orgs/:org/migrations/:migration_id/archive": {
        parameters: MigrationsDownloadArchiveForOrgEndpoint;
        request: MigrationsDownloadArchiveForOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#list-repositories-in-an-organization-migration
     */
    "GET /orgs/:org/migrations/:migration_id/repositories": {
        parameters: MigrationsListReposForOrgEndpoint;
        request: MigrationsListReposForOrgRequestOptions;
        response: OctokitResponse<MigrationsListReposForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/outside_collaborators/#list-outside-collaborators
     */
    "GET /orgs/:org/outside_collaborators": {
        parameters: OrgsListOutsideCollaboratorsEndpoint;
        request: OrgsListOutsideCollaboratorsRequestOptions;
        response: OctokitResponse<OrgsListOutsideCollaboratorsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#list-organization-projects
     */
    "GET /orgs/:org/projects": {
        parameters: ProjectsListForOrgEndpoint;
        request: ProjectsListForOrgRequestOptions;
        response: OctokitResponse<ProjectsListForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#public-members-list
     */
    "GET /orgs/:org/public_members": {
        parameters: OrgsListPublicMembersEndpoint;
        request: OrgsListPublicMembersRequestOptions;
        response: OctokitResponse<OrgsListPublicMembersResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#check-public-membership
     */
    "GET /orgs/:org/public_members/:username": {
        parameters: OrgsCheckPublicMembershipEndpoint;
        request: OrgsCheckPublicMembershipRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-organization-repositories
     */
    "GET /orgs/:org/repos": {
        parameters: ReposListForOrgEndpoint;
        request: ReposListForOrgRequestOptions;
        response: OctokitResponse<ReposListForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/team_sync/#list-idp-groups-in-an-organization
     */
    "GET /orgs/:org/team-sync/groups": {
        parameters: TeamsListIdPGroupsForOrgEndpoint;
        request: TeamsListIdPGroupsForOrgRequestOptions;
        response: OctokitResponse<TeamsListIdPGroupsForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-teams
     */
    "GET /orgs/:org/teams": {
        parameters: TeamsListEndpoint;
        request: TeamsListRequestOptions;
        response: OctokitResponse<TeamsListResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#get-team-by-name
     */
    "GET /orgs/:org/teams/:team_slug": {
        parameters: TeamsGetByNameEndpoint;
        request: TeamsGetByNameRequestOptions;
        response: OctokitResponse<TeamsGetByNameResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#list-discussions
     */
    "GET /orgs/:org/teams/:team_slug/discussions": {
        parameters: TeamsListDiscussionsInOrgEndpoint;
        request: TeamsListDiscussionsInOrgRequestOptions;
        response: OctokitResponse<TeamsListDiscussionsInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#get-a-single-discussion
     */
    "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number": {
        parameters: TeamsGetDiscussionInOrgEndpoint;
        request: TeamsGetDiscussionInOrgRequestOptions;
        response: OctokitResponse<TeamsGetDiscussionInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#list-comments
     */
    "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments": {
        parameters: TeamsListDiscussionCommentsInOrgEndpoint;
        request: TeamsListDiscussionCommentsInOrgRequestOptions;
        response: OctokitResponse<TeamsListDiscussionCommentsInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#get-a-single-comment
     */
    "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number": {
        parameters: TeamsGetDiscussionCommentInOrgEndpoint;
        request: TeamsGetDiscussionCommentInOrgRequestOptions;
        response: OctokitResponse<TeamsGetDiscussionCommentInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-team-discussion-comment
     */
    "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions": {
        parameters: ReactionsListForTeamDiscussionCommentInOrgEndpoint;
        request: ReactionsListForTeamDiscussionCommentInOrgRequestOptions;
        response: OctokitResponse<ReactionsListForTeamDiscussionCommentInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-team-discussion
     */
    "GET /orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions": {
        parameters: ReactionsListForTeamDiscussionInOrgEndpoint;
        request: ReactionsListForTeamDiscussionInOrgRequestOptions;
        response: OctokitResponse<ReactionsListForTeamDiscussionInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#list-pending-team-invitations
     */
    "GET /orgs/:org/teams/:team_slug/invitations": {
        parameters: TeamsListPendingInvitationsInOrgEndpoint;
        request: TeamsListPendingInvitationsInOrgRequestOptions;
        response: OctokitResponse<TeamsListPendingInvitationsInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#list-team-members
     */
    "GET /orgs/:org/teams/:team_slug/members": {
        parameters: TeamsListMembersInOrgEndpoint;
        request: TeamsListMembersInOrgRequestOptions;
        response: OctokitResponse<TeamsListMembersInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#get-team-membership
     */
    "GET /orgs/:org/teams/:team_slug/memberships/:username": {
        parameters: TeamsGetMembershipInOrgEndpoint;
        request: TeamsGetMembershipInOrgRequestOptions;
        response: OctokitResponse<TeamsGetMembershipInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-team-projects
     */
    "GET /orgs/:org/teams/:team_slug/projects": {
        parameters: TeamsListProjectsInOrgEndpoint;
        request: TeamsListProjectsInOrgRequestOptions;
        response: OctokitResponse<TeamsListProjectsInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#review-a-team-project
     */
    "GET /orgs/:org/teams/:team_slug/projects/:project_id": {
        parameters: TeamsReviewProjectInOrgEndpoint;
        request: TeamsReviewProjectInOrgRequestOptions;
        response: OctokitResponse<TeamsReviewProjectInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-team-repos
     */
    "GET /orgs/:org/teams/:team_slug/repos": {
        parameters: TeamsListReposInOrgEndpoint;
        request: TeamsListReposInOrgRequestOptions;
        response: OctokitResponse<TeamsListReposInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#check-if-a-team-manages-a-repository
     */
    "GET /orgs/:org/teams/:team_slug/repos/:owner/:repo": {
        parameters: TeamsCheckManagesRepoInOrgEndpoint;
        request: TeamsCheckManagesRepoInOrgRequestOptions;
        response: OctokitResponse<TeamsCheckManagesRepoInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/team_sync/#list-idp-groups-for-a-team
     */
    "GET /orgs/:org/teams/:team_slug/team-sync/group-mappings": {
        parameters: TeamsListIdPGroupsInOrgEndpoint;
        request: TeamsListIdPGroupsInOrgRequestOptions;
        response: OctokitResponse<TeamsListIdPGroupsInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-child-teams
     */
    "GET /orgs/:org/teams/:team_slug/teams": {
        parameters: TeamsListChildInOrgEndpoint;
        request: TeamsListChildInOrgRequestOptions;
        response: OctokitResponse<TeamsListChildInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#get-a-project
     */
    "GET /projects/:project_id": {
        parameters: ProjectsGetEndpoint;
        request: ProjectsGetRequestOptions;
        response: OctokitResponse<ProjectsGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/collaborators/#list-collaborators
     */
    "GET /projects/:project_id/collaborators": {
        parameters: ProjectsListCollaboratorsEndpoint;
        request: ProjectsListCollaboratorsRequestOptions;
        response: OctokitResponse<ProjectsListCollaboratorsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/collaborators/#review-a-users-permission-level
     */
    "GET /projects/:project_id/collaborators/:username/permission": {
        parameters: ProjectsReviewUserPermissionLevelEndpoint;
        request: ProjectsReviewUserPermissionLevelRequestOptions;
        response: OctokitResponse<ProjectsReviewUserPermissionLevelResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/columns/#list-project-columns
     */
    "GET /projects/:project_id/columns": {
        parameters: ProjectsListColumnsEndpoint;
        request: ProjectsListColumnsRequestOptions;
        response: OctokitResponse<ProjectsListColumnsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/columns/#get-a-project-column
     */
    "GET /projects/columns/:column_id": {
        parameters: ProjectsGetColumnEndpoint;
        request: ProjectsGetColumnRequestOptions;
        response: OctokitResponse<ProjectsGetColumnResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/cards/#list-project-cards
     */
    "GET /projects/columns/:column_id/cards": {
        parameters: ProjectsListCardsEndpoint;
        request: ProjectsListCardsRequestOptions;
        response: OctokitResponse<ProjectsListCardsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/cards/#get-a-project-card
     */
    "GET /projects/columns/cards/:card_id": {
        parameters: ProjectsGetCardEndpoint;
        request: ProjectsGetCardRequestOptions;
        response: OctokitResponse<ProjectsGetCardResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/rate_limit/#get-your-current-rate-limit-status
     */
    "GET /rate_limit": {
        parameters: RateLimitGetEndpoint;
        request: RateLimitGetRequestOptions;
        response: OctokitResponse<RateLimitGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#get-a-repository
     */
    "GET /repos/:owner/:repo": {
        parameters: ReposGetEndpoint;
        request: ReposGetRequestOptions;
        response: OctokitResponse<ReposGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/contents/#get-archive-link
     */
    "GET /repos/:owner/:repo/:archive_format/:ref": {
        parameters: ReposGetArchiveLinkEndpoint;
        request: ReposGetArchiveLinkRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/artifacts/#list-artifacts-for-a-repository
     */
    "GET /repos/:owner/:repo/actions/artifacts": {
        parameters: ActionsListArtifactsForRepoEndpoint;
        request: ActionsListArtifactsForRepoRequestOptions;
        response: OctokitResponse<ActionsListArtifactsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/artifacts/#get-an-artifact
     */
    "GET /repos/:owner/:repo/actions/artifacts/:artifact_id": {
        parameters: ActionsGetArtifactEndpoint;
        request: ActionsGetArtifactRequestOptions;
        response: OctokitResponse<ActionsGetArtifactResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/artifacts/#download-an-artifact
     */
    "GET /repos/:owner/:repo/actions/artifacts/:artifact_id/:archive_format": {
        parameters: ActionsDownloadArtifactEndpoint;
        request: ActionsDownloadArtifactRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-jobs/#get-a-workflow-job
     */
    "GET /repos/:owner/:repo/actions/jobs/:job_id": {
        parameters: ActionsGetWorkflowJobEndpoint;
        request: ActionsGetWorkflowJobRequestOptions;
        response: OctokitResponse<ActionsGetWorkflowJobResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-jobs/#download-workflow-job-logs
     */
    "GET /repos/:owner/:repo/actions/jobs/:job_id/logs": {
        parameters: ActionsDownloadWorkflowJobLogsEndpoint;
        request: ActionsDownloadWorkflowJobLogsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#list-self-hosted-runners-for-a-repository
     */
    "GET /repos/:owner/:repo/actions/runners": {
        parameters: ActionsListSelfHostedRunnersForRepoEndpoint;
        request: ActionsListSelfHostedRunnersForRepoRequestOptions;
        response: OctokitResponse<ActionsListSelfHostedRunnersForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#get-a-self-hosted-runner-for-a-repository
     */
    "GET /repos/:owner/:repo/actions/runners/:runner_id": {
        parameters: ActionsGetSelfHostedRunnerForRepoEndpoint;
        request: ActionsGetSelfHostedRunnerForRepoRequestOptions;
        response: OctokitResponse<ActionsGetSelfHostedRunnerForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#list-runner-applications-for-a-repository
     */
    "GET /repos/:owner/:repo/actions/runners/downloads": {
        parameters: ActionsListRunnerApplicationsForRepoEndpoint;
        request: ActionsListRunnerApplicationsForRepoRequestOptions;
        response: OctokitResponse<ActionsListRunnerApplicationsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#list-repository-workflow-runs
     */
    "GET /repos/:owner/:repo/actions/runs": {
        parameters: ActionsListRepoWorkflowRunsEndpoint;
        request: ActionsListRepoWorkflowRunsRequestOptions;
        response: OctokitResponse<ActionsListRepoWorkflowRunsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#get-a-workflow-run
     */
    "GET /repos/:owner/:repo/actions/runs/:run_id": {
        parameters: ActionsGetWorkflowRunEndpoint;
        request: ActionsGetWorkflowRunRequestOptions;
        response: OctokitResponse<ActionsGetWorkflowRunResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/artifacts/#list-workflow-run-artifacts
     */
    "GET /repos/:owner/:repo/actions/runs/:run_id/artifacts": {
        parameters: ActionsListWorkflowRunArtifactsEndpoint;
        request: ActionsListWorkflowRunArtifactsRequestOptions;
        response: OctokitResponse<ActionsListWorkflowRunArtifactsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-jobs/#list-jobs-for-a-workflow-run
     */
    "GET /repos/:owner/:repo/actions/runs/:run_id/jobs": {
        parameters: ActionsListJobsForWorkflowRunEndpoint;
        request: ActionsListJobsForWorkflowRunRequestOptions;
        response: OctokitResponse<ActionsListJobsForWorkflowRunResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#download-workflow-run-logs
     */
    "GET /repos/:owner/:repo/actions/runs/:run_id/logs": {
        parameters: ActionsDownloadWorkflowRunLogsEndpoint;
        request: ActionsDownloadWorkflowRunLogsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#list-secrets-for-a-repository
     */
    "GET /repos/:owner/:repo/actions/secrets": {
        parameters: ActionsListSecretsForRepoEndpoint;
        request: ActionsListSecretsForRepoRequestOptions;
        response: OctokitResponse<ActionsListSecretsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#get-a-secret
     */
    "GET /repos/:owner/:repo/actions/secrets/:name": {
        parameters: ActionsGetSecretEndpoint;
        request: ActionsGetSecretRequestOptions;
        response: OctokitResponse<ActionsGetSecretResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#get-your-public-key
     */
    "GET /repos/:owner/:repo/actions/secrets/public-key": {
        parameters: ActionsGetPublicKeyEndpoint;
        request: ActionsGetPublicKeyRequestOptions;
        response: OctokitResponse<ActionsGetPublicKeyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflows/#list-repository-workflows
     */
    "GET /repos/:owner/:repo/actions/workflows": {
        parameters: ActionsListRepoWorkflowsEndpoint;
        request: ActionsListRepoWorkflowsRequestOptions;
        response: OctokitResponse<ActionsListRepoWorkflowsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflows/#get-a-workflow
     */
    "GET /repos/:owner/:repo/actions/workflows/:workflow_id": {
        parameters: ActionsGetWorkflowEndpoint;
        request: ActionsGetWorkflowRequestOptions;
        response: OctokitResponse<ActionsGetWorkflowResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#list-workflow-runs
     */
    "GET /repos/:owner/:repo/actions/workflows/:workflow_id/runs": {
        parameters: ActionsListWorkflowRunsEndpoint;
        request: ActionsListWorkflowRunsRequestOptions;
        response: OctokitResponse<ActionsListWorkflowRunsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/assignees/#list-assignees
     */
    "GET /repos/:owner/:repo/assignees": {
        parameters: IssuesListAssigneesEndpoint;
        request: IssuesListAssigneesRequestOptions;
        response: OctokitResponse<IssuesListAssigneesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/assignees/#check-assignee
     */
    "GET /repos/:owner/:repo/assignees/:assignee": {
        parameters: IssuesCheckAssigneeEndpoint;
        request: IssuesCheckAssigneeRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#list-branches
     */
    "GET /repos/:owner/:repo/branches": {
        parameters: ReposListBranchesEndpoint;
        request: ReposListBranchesRequestOptions;
        response: OctokitResponse<ReposListBranchesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-branch
     */
    "GET /repos/:owner/:repo/branches/:branch": {
        parameters: ReposGetBranchEndpoint;
        request: ReposGetBranchRequestOptions;
        response: OctokitResponse<ReposGetBranchResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-branch-protection
     */
    "GET /repos/:owner/:repo/branches/:branch/protection": {
        parameters: ReposGetBranchProtectionEndpoint;
        request: ReposGetBranchProtectionRequestOptions;
        response: OctokitResponse<ReposGetBranchProtectionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-admin-enforcement-of-protected-branch
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/enforce_admins": {
        parameters: ReposGetProtectedBranchAdminEnforcementEndpoint;
        request: ReposGetProtectedBranchAdminEnforcementRequestOptions;
        response: OctokitResponse<ReposGetProtectedBranchAdminEnforcementResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-pull-request-review-enforcement-of-protected-branch
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews": {
        parameters: ReposGetProtectedBranchPullRequestReviewEnforcementEndpoint;
        request: ReposGetProtectedBranchPullRequestReviewEnforcementRequestOptions;
        response: OctokitResponse<ReposGetProtectedBranchPullRequestReviewEnforcementResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-required-signatures-of-protected-branch
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/required_signatures": {
        parameters: ReposGetProtectedBranchRequiredSignaturesEndpoint;
        request: ReposGetProtectedBranchRequiredSignaturesRequestOptions;
        response: OctokitResponse<ReposGetProtectedBranchRequiredSignaturesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-required-status-checks-of-protected-branch
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/required_status_checks": {
        parameters: ReposGetProtectedBranchRequiredStatusChecksEndpoint;
        request: ReposGetProtectedBranchRequiredStatusChecksRequestOptions;
        response: OctokitResponse<ReposGetProtectedBranchRequiredStatusChecksResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#list-required-status-checks-contexts-of-protected-branch
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": {
        parameters: ReposListProtectedBranchRequiredStatusChecksContextsEndpoint;
        request: ReposListProtectedBranchRequiredStatusChecksContextsRequestOptions;
        response: OctokitResponse<ReposListProtectedBranchRequiredStatusChecksContextsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#get-restrictions-of-protected-branch
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/restrictions": {
        parameters: ReposGetProtectedBranchRestrictionsEndpoint;
        request: ReposGetProtectedBranchRestrictionsRequestOptions;
        response: OctokitResponse<ReposGetProtectedBranchRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#list-apps-with-access-to-protected-branch
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": {
        parameters: ReposGetAppsWithAccessToProtectedBranchEndpoint;
        request: ReposGetAppsWithAccessToProtectedBranchRequestOptions;
        response: OctokitResponse<ReposGetAppsWithAccessToProtectedBranchResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#list-teams-with-access-to-protected-branch
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": {
        parameters: ReposGetTeamsWithAccessToProtectedBranchEndpoint;
        request: ReposGetTeamsWithAccessToProtectedBranchRequestOptions;
        response: OctokitResponse<ReposGetTeamsWithAccessToProtectedBranchResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#list-users-with-access-to-protected-branch
     */
    "GET /repos/:owner/:repo/branches/:branch/protection/restrictions/users": {
        parameters: ReposGetUsersWithAccessToProtectedBranchEndpoint;
        request: ReposGetUsersWithAccessToProtectedBranchRequestOptions;
        response: OctokitResponse<ReposGetUsersWithAccessToProtectedBranchResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/runs/#get-a-check-run
     */
    "GET /repos/:owner/:repo/check-runs/:check_run_id": {
        parameters: ChecksGetEndpoint;
        request: ChecksGetRequestOptions;
        response: OctokitResponse<ChecksGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/runs/#list-check-run-annotations
     */
    "GET /repos/:owner/:repo/check-runs/:check_run_id/annotations": {
        parameters: ChecksListAnnotationsEndpoint;
        request: ChecksListAnnotationsRequestOptions;
        response: OctokitResponse<ChecksListAnnotationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/suites/#get-a-check-suite
     */
    "GET /repos/:owner/:repo/check-suites/:check_suite_id": {
        parameters: ChecksGetSuiteEndpoint;
        request: ChecksGetSuiteRequestOptions;
        response: OctokitResponse<ChecksGetSuiteResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/runs/#list-check-runs-in-a-check-suite
     */
    "GET /repos/:owner/:repo/check-suites/:check_suite_id/check-runs": {
        parameters: ChecksListForSuiteEndpoint;
        request: ChecksListForSuiteRequestOptions;
        response: OctokitResponse<ChecksListForSuiteResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/code-scanning/#list-code-scanning-alerts-for-a-repository
     */
    "GET /repos/:owner/:repo/code-scanning/alerts": {
        parameters: CodeScanningListAlertsForRepoEndpoint;
        request: CodeScanningListAlertsForRepoRequestOptions;
        response: OctokitResponse<CodeScanningListAlertsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/code-scanning/#get-a-code-scanning-alert
     */
    "GET /repos/:owner/:repo/code-scanning/alerts/:alert_id": {
        parameters: CodeScanningGetAlertEndpoint;
        request: CodeScanningGetAlertRequestOptions;
        response: OctokitResponse<CodeScanningGetAlertResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/collaborators/#list-collaborators
     */
    "GET /repos/:owner/:repo/collaborators": {
        parameters: ReposListCollaboratorsEndpoint;
        request: ReposListCollaboratorsRequestOptions;
        response: OctokitResponse<ReposListCollaboratorsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/collaborators/#check-if-a-user-is-a-collaborator
     */
    "GET /repos/:owner/:repo/collaborators/:username": {
        parameters: ReposCheckCollaboratorEndpoint;
        request: ReposCheckCollaboratorRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/collaborators/#review-a-users-permission-level
     */
    "GET /repos/:owner/:repo/collaborators/:username/permission": {
        parameters: ReposGetCollaboratorPermissionLevelEndpoint;
        request: ReposGetCollaboratorPermissionLevelRequestOptions;
        response: OctokitResponse<ReposGetCollaboratorPermissionLevelResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/comments/#list-commit-comments-for-a-repository
     */
    "GET /repos/:owner/:repo/comments": {
        parameters: ReposListCommitCommentsEndpoint;
        request: ReposListCommitCommentsRequestOptions;
        response: OctokitResponse<ReposListCommitCommentsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/comments/#get-a-single-commit-comment
     */
    "GET /repos/:owner/:repo/comments/:comment_id": {
        parameters: ReposGetCommitCommentEndpoint;
        request: ReposGetCommitCommentRequestOptions;
        response: OctokitResponse<ReposGetCommitCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-commit-comment
     */
    "GET /repos/:owner/:repo/comments/:comment_id/reactions": {
        parameters: ReactionsListForCommitCommentEndpoint;
        request: ReactionsListForCommitCommentRequestOptions;
        response: OctokitResponse<ReactionsListForCommitCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository
     */
    "GET /repos/:owner/:repo/commits": {
        parameters: ReposListCommitsEndpoint;
        request: ReposListCommitsRequestOptions;
        response: OctokitResponse<ReposListCommitsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/commits/#list-branches-for-head-commit
     */
    "GET /repos/:owner/:repo/commits/:commit_sha/branches-where-head": {
        parameters: ReposListBranchesForHeadCommitEndpoint;
        request: ReposListBranchesForHeadCommitRequestOptions;
        response: OctokitResponse<ReposListBranchesForHeadCommitResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/comments/#list-comments-for-a-single-commit
     */
    "GET /repos/:owner/:repo/commits/:commit_sha/comments": {
        parameters: ReposListCommentsForCommitEndpoint;
        request: ReposListCommentsForCommitRequestOptions;
        response: OctokitResponse<ReposListCommentsForCommitResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/commits/#list-pull-requests-associated-with-commit
     */
    "GET /repos/:owner/:repo/commits/:commit_sha/pulls": {
        parameters: ReposListPullRequestsAssociatedWithCommitEndpoint;
        request: ReposListPullRequestsAssociatedWithCommitRequestOptions;
        response: OctokitResponse<ReposListPullRequestsAssociatedWithCommitResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/commits/#get-a-single-commit
     */
    "GET /repos/:owner/:repo/commits/:ref": {
        parameters: ReposGetCommitEndpoint;
        request: ReposGetCommitRequestOptions;
        response: OctokitResponse<ReposGetCommitResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/runs/#list-check-runs-for-a-git-reference
     */
    "GET /repos/:owner/:repo/commits/:ref/check-runs": {
        parameters: ChecksListForRefEndpoint;
        request: ChecksListForRefRequestOptions;
        response: OctokitResponse<ChecksListForRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/suites/#list-check-suites-for-a-git-reference
     */
    "GET /repos/:owner/:repo/commits/:ref/check-suites": {
        parameters: ChecksListSuitesForRefEndpoint;
        request: ChecksListSuitesForRefRequestOptions;
        response: OctokitResponse<ChecksListSuitesForRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statuses/#get-the-combined-status-for-a-specific-ref
     */
    "GET /repos/:owner/:repo/commits/:ref/status": {
        parameters: ReposGetCombinedStatusForRefEndpoint;
        request: ReposGetCombinedStatusForRefRequestOptions;
        response: OctokitResponse<ReposGetCombinedStatusForRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statuses/#list-statuses-for-a-specific-ref
     */
    "GET /repos/:owner/:repo/commits/:ref/statuses": {
        parameters: ReposListStatusesForRefEndpoint;
        request: ReposListStatusesForRefRequestOptions;
        response: OctokitResponse<ReposListStatusesForRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/codes_of_conduct/#get-the-contents-of-a-repositorys-code-of-conduct
     */
    "GET /repos/:owner/:repo/community/code_of_conduct": {
        parameters: CodesOfConductGetForRepoEndpoint;
        request: CodesOfConductGetForRepoRequestOptions;
        response: OctokitResponse<CodesOfConductGetForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/community/#retrieve-community-profile-metrics
     */
    "GET /repos/:owner/:repo/community/profile": {
        parameters: ReposRetrieveCommunityProfileMetricsEndpoint;
        request: ReposRetrieveCommunityProfileMetricsRequestOptions;
        response: OctokitResponse<ReposRetrieveCommunityProfileMetricsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/commits/#compare-two-commits
     */
    "GET /repos/:owner/:repo/compare/:base...:head": {
        parameters: ReposCompareCommitsEndpoint;
        request: ReposCompareCommitsRequestOptions;
        response: OctokitResponse<ReposCompareCommitsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/contents/#get-contents
     */
    "GET /repos/:owner/:repo/contents/:path": {
        parameters: ReposGetContentsEndpoint;
        request: ReposGetContentsRequestOptions;
        response: OctokitResponse<ReposGetContentsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-contributors
     */
    "GET /repos/:owner/:repo/contributors": {
        parameters: ReposListContributorsEndpoint;
        request: ReposListContributorsRequestOptions;
        response: OctokitResponse<ReposListContributorsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#list-deployments
     */
    "GET /repos/:owner/:repo/deployments": {
        parameters: ReposListDeploymentsEndpoint;
        request: ReposListDeploymentsRequestOptions;
        response: OctokitResponse<ReposListDeploymentsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#get-a-single-deployment
     */
    "GET /repos/:owner/:repo/deployments/:deployment_id": {
        parameters: ReposGetDeploymentEndpoint;
        request: ReposGetDeploymentRequestOptions;
        response: OctokitResponse<ReposGetDeploymentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#list-deployment-statuses
     */
    "GET /repos/:owner/:repo/deployments/:deployment_id/statuses": {
        parameters: ReposListDeploymentStatusesEndpoint;
        request: ReposListDeploymentStatusesRequestOptions;
        response: OctokitResponse<ReposListDeploymentStatusesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#get-a-single-deployment-status
     */
    "GET /repos/:owner/:repo/deployments/:deployment_id/statuses/:status_id": {
        parameters: ReposGetDeploymentStatusEndpoint;
        request: ReposGetDeploymentStatusRequestOptions;
        response: OctokitResponse<ReposGetDeploymentStatusResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/downloads/#list-downloads-for-a-repository
     */
    "GET /repos/:owner/:repo/downloads": {
        parameters: ReposListDownloadsEndpoint;
        request: ReposListDownloadsRequestOptions;
        response: OctokitResponse<ReposListDownloadsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/downloads/#get-a-single-download
     */
    "GET /repos/:owner/:repo/downloads/:download_id": {
        parameters: ReposGetDownloadEndpoint;
        request: ReposGetDownloadRequestOptions;
        response: OctokitResponse<ReposGetDownloadResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-repository-events
     */
    "GET /repos/:owner/:repo/events": {
        parameters: ActivityListRepoEventsEndpoint;
        request: ActivityListRepoEventsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/forks/#list-forks
     */
    "GET /repos/:owner/:repo/forks": {
        parameters: ReposListForksEndpoint;
        request: ReposListForksRequestOptions;
        response: OctokitResponse<ReposListForksResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/blobs/#get-a-blob
     */
    "GET /repos/:owner/:repo/git/blobs/:file_sha": {
        parameters: GitGetBlobEndpoint;
        request: GitGetBlobRequestOptions;
        response: OctokitResponse<GitGetBlobResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/commits/#get-a-commit
     */
    "GET /repos/:owner/:repo/git/commits/:commit_sha": {
        parameters: GitGetCommitEndpoint;
        request: GitGetCommitRequestOptions;
        response: OctokitResponse<GitGetCommitResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/refs/#list-matching-references
     */
    "GET /repos/:owner/:repo/git/matching-refs/:ref": {
        parameters: GitListMatchingRefsEndpoint;
        request: GitListMatchingRefsRequestOptions;
        response: OctokitResponse<GitListMatchingRefsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/refs/#get-a-single-reference
     */
    "GET /repos/:owner/:repo/git/ref/:ref": {
        parameters: GitGetRefEndpoint;
        request: GitGetRefRequestOptions;
        response: OctokitResponse<GitGetRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/tags/#get-a-tag
     */
    "GET /repos/:owner/:repo/git/tags/:tag_sha": {
        parameters: GitGetTagEndpoint;
        request: GitGetTagRequestOptions;
        response: OctokitResponse<GitGetTagResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/trees/#get-a-tree
     */
    "GET /repos/:owner/:repo/git/trees/:tree_sha": {
        parameters: GitGetTreeEndpoint;
        request: GitGetTreeRequestOptions;
        response: OctokitResponse<GitGetTreeResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#list-hooks
     */
    "GET /repos/:owner/:repo/hooks": {
        parameters: ReposListHooksEndpoint;
        request: ReposListHooksRequestOptions;
        response: OctokitResponse<ReposListHooksResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#get-single-hook
     */
    "GET /repos/:owner/:repo/hooks/:hook_id": {
        parameters: ReposGetHookEndpoint;
        request: ReposGetHookRequestOptions;
        response: OctokitResponse<ReposGetHookResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#get-import-progress
     */
    "GET /repos/:owner/:repo/import": {
        parameters: MigrationsGetImportProgressEndpoint;
        request: MigrationsGetImportProgressRequestOptions;
        response: OctokitResponse<MigrationsGetImportProgressResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#get-commit-authors
     */
    "GET /repos/:owner/:repo/import/authors": {
        parameters: MigrationsGetCommitAuthorsEndpoint;
        request: MigrationsGetCommitAuthorsRequestOptions;
        response: OctokitResponse<MigrationsGetCommitAuthorsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#get-large-files
     */
    "GET /repos/:owner/:repo/import/large_files": {
        parameters: MigrationsGetLargeFilesEndpoint;
        request: MigrationsGetLargeFilesRequestOptions;
        response: OctokitResponse<MigrationsGetLargeFilesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#get-a-repository-installation
     */
    "GET /repos/:owner/:repo/installation": {
        parameters: AppsGetRepoInstallationEndpoint;
        request: AppsGetRepoInstallationRequestOptions;
        response: OctokitResponse<AppsGetRepoInstallationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/interactions/repos/#get-interaction-restrictions-for-a-repository
     */
    "GET /repos/:owner/:repo/interaction-limits": {
        parameters: InteractionsGetRestrictionsForRepoEndpoint;
        request: InteractionsGetRestrictionsForRepoRequestOptions;
        response: OctokitResponse<InteractionsGetRestrictionsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/invitations/#list-invitations-for-a-repository
     */
    "GET /repos/:owner/:repo/invitations": {
        parameters: ReposListInvitationsEndpoint;
        request: ReposListInvitationsRequestOptions;
        response: OctokitResponse<ReposListInvitationsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#list-repository-issues
     */
    "GET /repos/:owner/:repo/issues": {
        parameters: IssuesListForRepoEndpoint;
        request: IssuesListForRepoRequestOptions;
        response: OctokitResponse<IssuesListForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#get-an-issue
     */
    "GET /repos/:owner/:repo/issues/:issue_number": {
        parameters: IssuesGetEndpoint;
        request: IssuesGetRequestOptions;
        response: OctokitResponse<IssuesGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/comments/#list-comments-on-an-issue
     */
    "GET /repos/:owner/:repo/issues/:issue_number/comments": {
        parameters: IssuesListCommentsEndpoint;
        request: IssuesListCommentsRequestOptions;
        response: OctokitResponse<IssuesListCommentsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/events/#list-events-for-an-issue
     */
    "GET /repos/:owner/:repo/issues/:issue_number/events": {
        parameters: IssuesListEventsEndpoint;
        request: IssuesListEventsRequestOptions;
        response: OctokitResponse<IssuesListEventsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#list-labels-on-an-issue
     */
    "GET /repos/:owner/:repo/issues/:issue_number/labels": {
        parameters: IssuesListLabelsOnIssueEndpoint;
        request: IssuesListLabelsOnIssueRequestOptions;
        response: OctokitResponse<IssuesListLabelsOnIssueResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-an-issue
     */
    "GET /repos/:owner/:repo/issues/:issue_number/reactions": {
        parameters: ReactionsListForIssueEndpoint;
        request: ReactionsListForIssueRequestOptions;
        response: OctokitResponse<ReactionsListForIssueResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/timeline/#list-events-for-an-issue
     */
    "GET /repos/:owner/:repo/issues/:issue_number/timeline": {
        parameters: IssuesListEventsForTimelineEndpoint;
        request: IssuesListEventsForTimelineRequestOptions;
        response: OctokitResponse<IssuesListEventsForTimelineResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/comments/#list-comments-in-a-repository
     */
    "GET /repos/:owner/:repo/issues/comments": {
        parameters: IssuesListCommentsForRepoEndpoint;
        request: IssuesListCommentsForRepoRequestOptions;
        response: OctokitResponse<IssuesListCommentsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/comments/#get-a-single-comment
     */
    "GET /repos/:owner/:repo/issues/comments/:comment_id": {
        parameters: IssuesGetCommentEndpoint;
        request: IssuesGetCommentRequestOptions;
        response: OctokitResponse<IssuesGetCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-an-issue-comment
     */
    "GET /repos/:owner/:repo/issues/comments/:comment_id/reactions": {
        parameters: ReactionsListForIssueCommentEndpoint;
        request: ReactionsListForIssueCommentRequestOptions;
        response: OctokitResponse<ReactionsListForIssueCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/events/#list-events-for-a-repository
     */
    "GET /repos/:owner/:repo/issues/events": {
        parameters: IssuesListEventsForRepoEndpoint;
        request: IssuesListEventsForRepoRequestOptions;
        response: OctokitResponse<IssuesListEventsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/events/#get-a-single-event
     */
    "GET /repos/:owner/:repo/issues/events/:event_id": {
        parameters: IssuesGetEventEndpoint;
        request: IssuesGetEventRequestOptions;
        response: OctokitResponse<IssuesGetEventResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/keys/#list-deploy-keys
     */
    "GET /repos/:owner/:repo/keys": {
        parameters: ReposListDeployKeysEndpoint;
        request: ReposListDeployKeysRequestOptions;
        response: OctokitResponse<ReposListDeployKeysResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/keys/#get-a-deploy-key
     */
    "GET /repos/:owner/:repo/keys/:key_id": {
        parameters: ReposGetDeployKeyEndpoint;
        request: ReposGetDeployKeyRequestOptions;
        response: OctokitResponse<ReposGetDeployKeyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#list-all-labels-for-this-repository
     */
    "GET /repos/:owner/:repo/labels": {
        parameters: IssuesListLabelsForRepoEndpoint;
        request: IssuesListLabelsForRepoRequestOptions;
        response: OctokitResponse<IssuesListLabelsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#get-a-single-label
     */
    "GET /repos/:owner/:repo/labels/:name": {
        parameters: IssuesGetLabelEndpoint;
        request: IssuesGetLabelRequestOptions;
        response: OctokitResponse<IssuesGetLabelResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-languages
     */
    "GET /repos/:owner/:repo/languages": {
        parameters: ReposListLanguagesEndpoint;
        request: ReposListLanguagesRequestOptions;
        response: OctokitResponse<ReposListLanguagesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/licenses/#get-the-contents-of-a-repositorys-license
     */
    "GET /repos/:owner/:repo/license": {
        parameters: LicensesGetForRepoEndpoint;
        request: LicensesGetForRepoRequestOptions;
        response: OctokitResponse<LicensesGetForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/milestones/#list-milestones-for-a-repository
     */
    "GET /repos/:owner/:repo/milestones": {
        parameters: IssuesListMilestonesForRepoEndpoint;
        request: IssuesListMilestonesForRepoRequestOptions;
        response: OctokitResponse<IssuesListMilestonesForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/milestones/#get-a-single-milestone
     */
    "GET /repos/:owner/:repo/milestones/:milestone_number": {
        parameters: IssuesGetMilestoneEndpoint;
        request: IssuesGetMilestoneRequestOptions;
        response: OctokitResponse<IssuesGetMilestoneResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#get-labels-for-every-issue-in-a-milestone
     */
    "GET /repos/:owner/:repo/milestones/:milestone_number/labels": {
        parameters: IssuesListLabelsForMilestoneEndpoint;
        request: IssuesListLabelsForMilestoneRequestOptions;
        response: OctokitResponse<IssuesListLabelsForMilestoneResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#list-repository-notifications-for-the-authenticated-user
     */
    "GET /repos/:owner/:repo/notifications": {
        parameters: ActivityListRepoNotificationsForAuthenticatedUserEndpoint;
        request: ActivityListRepoNotificationsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ActivityListRepoNotificationsForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#get-information-about-a-pages-site
     */
    "GET /repos/:owner/:repo/pages": {
        parameters: ReposGetPagesEndpoint;
        request: ReposGetPagesRequestOptions;
        response: OctokitResponse<ReposGetPagesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#list-pages-builds
     */
    "GET /repos/:owner/:repo/pages/builds": {
        parameters: ReposListPagesBuildsEndpoint;
        request: ReposListPagesBuildsRequestOptions;
        response: OctokitResponse<ReposListPagesBuildsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#get-a-specific-pages-build
     */
    "GET /repos/:owner/:repo/pages/builds/:build_id": {
        parameters: ReposGetPagesBuildEndpoint;
        request: ReposGetPagesBuildRequestOptions;
        response: OctokitResponse<ReposGetPagesBuildResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#get-latest-pages-build
     */
    "GET /repos/:owner/:repo/pages/builds/latest": {
        parameters: ReposGetLatestPagesBuildEndpoint;
        request: ReposGetLatestPagesBuildRequestOptions;
        response: OctokitResponse<ReposGetLatestPagesBuildResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#list-repository-projects
     */
    "GET /repos/:owner/:repo/projects": {
        parameters: ProjectsListForRepoEndpoint;
        request: ProjectsListForRepoRequestOptions;
        response: OctokitResponse<ProjectsListForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#list-pull-requests
     */
    "GET /repos/:owner/:repo/pulls": {
        parameters: PullsListEndpoint;
        request: PullsListRequestOptions;
        response: OctokitResponse<PullsListResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#get-a-single-pull-request
     */
    "GET /repos/:owner/:repo/pulls/:pull_number": {
        parameters: PullsGetEndpoint;
        request: PullsGetRequestOptions;
        response: OctokitResponse<PullsGetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#list-comments-on-a-pull-request
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/comments": {
        parameters: PullsListCommentsEndpoint;
        request: PullsListCommentsRequestOptions;
        response: OctokitResponse<PullsListCommentsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#list-commits-on-a-pull-request
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/commits": {
        parameters: PullsListCommitsEndpoint;
        request: PullsListCommitsRequestOptions;
        response: OctokitResponse<PullsListCommitsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#list-pull-requests-files
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/files": {
        parameters: PullsListFilesEndpoint;
        request: PullsListFilesRequestOptions;
        response: OctokitResponse<PullsListFilesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#get-if-a-pull-request-has-been-merged
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/merge": {
        parameters: PullsCheckIfMergedEndpoint;
        request: PullsCheckIfMergedRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/review_requests/#list-review-requests
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/requested_reviewers": {
        parameters: PullsListReviewRequestsEndpoint;
        request: PullsListReviewRequestsRequestOptions;
        response: OctokitResponse<PullsListReviewRequestsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#list-reviews-on-a-pull-request
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/reviews": {
        parameters: PullsListReviewsEndpoint;
        request: PullsListReviewsRequestOptions;
        response: OctokitResponse<PullsListReviewsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#get-a-single-review
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id": {
        parameters: PullsGetReviewEndpoint;
        request: PullsGetReviewRequestOptions;
        response: OctokitResponse<PullsGetReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#get-comments-for-a-single-review
     */
    "GET /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/comments": {
        parameters: PullsGetCommentsForReviewEndpoint;
        request: PullsGetCommentsForReviewRequestOptions;
        response: OctokitResponse<PullsGetCommentsForReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#list-comments-in-a-repository
     */
    "GET /repos/:owner/:repo/pulls/comments": {
        parameters: PullsListCommentsForRepoEndpoint;
        request: PullsListCommentsForRepoRequestOptions;
        response: OctokitResponse<PullsListCommentsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#get-a-single-comment
     */
    "GET /repos/:owner/:repo/pulls/comments/:comment_id": {
        parameters: PullsGetCommentEndpoint;
        request: PullsGetCommentRequestOptions;
        response: OctokitResponse<PullsGetCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-pull-request-review-comment
     */
    "GET /repos/:owner/:repo/pulls/comments/:comment_id/reactions": {
        parameters: ReactionsListForPullRequestReviewCommentEndpoint;
        request: ReactionsListForPullRequestReviewCommentRequestOptions;
        response: OctokitResponse<ReactionsListForPullRequestReviewCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/contents/#get-the-readme
     */
    "GET /repos/:owner/:repo/readme": {
        parameters: ReposGetReadmeEndpoint;
        request: ReposGetReadmeRequestOptions;
        response: OctokitResponse<ReposGetReadmeResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#list-releases-for-a-repository
     */
    "GET /repos/:owner/:repo/releases": {
        parameters: ReposListReleasesEndpoint;
        request: ReposListReleasesRequestOptions;
        response: OctokitResponse<ReposListReleasesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#get-a-single-release
     */
    "GET /repos/:owner/:repo/releases/:release_id": {
        parameters: ReposGetReleaseEndpoint;
        request: ReposGetReleaseRequestOptions;
        response: OctokitResponse<ReposGetReleaseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#list-assets-for-a-release
     */
    "GET /repos/:owner/:repo/releases/:release_id/assets": {
        parameters: ReposListAssetsForReleaseEndpoint;
        request: ReposListAssetsForReleaseRequestOptions;
        response: OctokitResponse<ReposListAssetsForReleaseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#get-a-single-release-asset
     */
    "GET /repos/:owner/:repo/releases/assets/:asset_id": {
        parameters: ReposGetReleaseAssetEndpoint;
        request: ReposGetReleaseAssetRequestOptions;
        response: OctokitResponse<ReposGetReleaseAssetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#get-the-latest-release
     */
    "GET /repos/:owner/:repo/releases/latest": {
        parameters: ReposGetLatestReleaseEndpoint;
        request: ReposGetLatestReleaseRequestOptions;
        response: OctokitResponse<ReposGetLatestReleaseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#get-a-release-by-tag-name
     */
    "GET /repos/:owner/:repo/releases/tags/:tag": {
        parameters: ReposGetReleaseByTagEndpoint;
        request: ReposGetReleaseByTagRequestOptions;
        response: OctokitResponse<ReposGetReleaseByTagResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/starring/#list-stargazers
     */
    "GET /repos/:owner/:repo/stargazers": {
        parameters: ActivityListStargazersForRepoEndpoint;
        request: ActivityListStargazersForRepoRequestOptions;
        response: OctokitResponse<ActivityListStargazersForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statistics/#get-the-number-of-additions-and-deletions-per-week
     */
    "GET /repos/:owner/:repo/stats/code_frequency": {
        parameters: ReposGetCodeFrequencyStatsEndpoint;
        request: ReposGetCodeFrequencyStatsRequestOptions;
        response: OctokitResponse<ReposGetCodeFrequencyStatsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statistics/#get-the-last-year-of-commit-activity-data
     */
    "GET /repos/:owner/:repo/stats/commit_activity": {
        parameters: ReposGetCommitActivityStatsEndpoint;
        request: ReposGetCommitActivityStatsRequestOptions;
        response: OctokitResponse<ReposGetCommitActivityStatsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statistics/#get-contributors-list-with-additions-deletions-and-commit-counts
     */
    "GET /repos/:owner/:repo/stats/contributors": {
        parameters: ReposGetContributorsStatsEndpoint;
        request: ReposGetContributorsStatsRequestOptions;
        response: OctokitResponse<ReposGetContributorsStatsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statistics/#get-the-weekly-commit-count-for-the-repository-owner-and-everyone-else
     */
    "GET /repos/:owner/:repo/stats/participation": {
        parameters: ReposGetParticipationStatsEndpoint;
        request: ReposGetParticipationStatsRequestOptions;
        response: OctokitResponse<ReposGetParticipationStatsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statistics/#get-the-number-of-commits-per-hour-in-each-day
     */
    "GET /repos/:owner/:repo/stats/punch_card": {
        parameters: ReposGetPunchCardStatsEndpoint;
        request: ReposGetPunchCardStatsRequestOptions;
        response: OctokitResponse<ReposGetPunchCardStatsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#list-watchers
     */
    "GET /repos/:owner/:repo/subscribers": {
        parameters: ActivityListWatchersForRepoEndpoint;
        request: ActivityListWatchersForRepoRequestOptions;
        response: OctokitResponse<ActivityListWatchersForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#get-a-repository-subscription
     */
    "GET /repos/:owner/:repo/subscription": {
        parameters: ActivityGetRepoSubscriptionEndpoint;
        request: ActivityGetRepoSubscriptionRequestOptions;
        response: OctokitResponse<ActivityGetRepoSubscriptionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-tags
     */
    "GET /repos/:owner/:repo/tags": {
        parameters: ReposListTagsEndpoint;
        request: ReposListTagsRequestOptions;
        response: OctokitResponse<ReposListTagsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-teams
     */
    "GET /repos/:owner/:repo/teams": {
        parameters: ReposListTeamsEndpoint;
        request: ReposListTeamsRequestOptions;
        response: OctokitResponse<ReposListTeamsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#get-all-repository-topics
     */
    "GET /repos/:owner/:repo/topics": {
        parameters: ReposGetAllTopicsEndpoint;
        request: ReposGetAllTopicsRequestOptions;
        response: OctokitResponse<ReposGetAllTopicsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/traffic/#clones
     */
    "GET /repos/:owner/:repo/traffic/clones": {
        parameters: ReposGetClonesEndpoint;
        request: ReposGetClonesRequestOptions;
        response: OctokitResponse<ReposGetClonesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/traffic/#list-paths
     */
    "GET /repos/:owner/:repo/traffic/popular/paths": {
        parameters: ReposGetTopPathsEndpoint;
        request: ReposGetTopPathsRequestOptions;
        response: OctokitResponse<ReposGetTopPathsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/traffic/#list-referrers
     */
    "GET /repos/:owner/:repo/traffic/popular/referrers": {
        parameters: ReposGetTopReferrersEndpoint;
        request: ReposGetTopReferrersRequestOptions;
        response: OctokitResponse<ReposGetTopReferrersResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/traffic/#views
     */
    "GET /repos/:owner/:repo/traffic/views": {
        parameters: ReposGetViewsEndpoint;
        request: ReposGetViewsRequestOptions;
        response: OctokitResponse<ReposGetViewsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#check-if-vulnerability-alerts-are-enabled-for-a-repository
     */
    "GET /repos/:owner/:repo/vulnerability-alerts": {
        parameters: ReposCheckVulnerabilityAlertsEndpoint;
        request: ReposCheckVulnerabilityAlertsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-public-repositories
     */
    "GET /repositories": {
        parameters: ReposListPublicEndpoint;
        request: ReposListPublicRequestOptions;
        response: OctokitResponse<ReposListPublicResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/scim/#get-a-list-of-provisioned-identities
     */
    "GET /scim/v2/organizations/:org/Users": {
        parameters: ScimListProvisionedIdentitiesEndpoint;
        request: ScimListProvisionedIdentitiesRequestOptions;
        response: OctokitResponse<ScimListProvisionedIdentitiesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/scim/#get-provisioning-details-for-a-single-user
     */
    "GET /scim/v2/organizations/:org/Users/:scim_user_id": {
        parameters: ScimGetProvisioningDetailsForUserEndpoint;
        request: ScimGetProvisioningDetailsForUserRequestOptions;
        response: OctokitResponse<ScimGetProvisioningDetailsForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-code
     */
    "GET /search/code": {
        parameters: SearchCodeEndpoint;
        request: SearchCodeRequestOptions;
        response: OctokitResponse<SearchCodeResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-commits
     */
    "GET /search/commits": {
        parameters: SearchCommitsEndpoint;
        request: SearchCommitsRequestOptions;
        response: OctokitResponse<SearchCommitsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-issues-and-pull-requests
     */
    "GET /search/issues": {
        parameters: SearchIssuesAndPullRequestsEndpoint;
        request: SearchIssuesAndPullRequestsRequestOptions;
        response: OctokitResponse<SearchIssuesAndPullRequestsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-labels
     */
    "GET /search/labels": {
        parameters: SearchLabelsEndpoint;
        request: SearchLabelsRequestOptions;
        response: OctokitResponse<SearchLabelsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-repositories
     */
    "GET /search/repositories": {
        parameters: SearchReposEndpoint;
        request: SearchReposRequestOptions;
        response: OctokitResponse<SearchReposResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-topics
     */
    "GET /search/topics": {
        parameters: SearchTopicsEndpoint;
        request: SearchTopicsRequestOptions;
        response: OctokitResponse<SearchTopicsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/search/#search-users
     */
    "GET /search/users": {
        parameters: SearchUsersEndpoint;
        request: SearchUsersRequestOptions;
        response: OctokitResponse<SearchUsersResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#get-team-legacy
     */
    "GET /teams/:team_id": {
        parameters: TeamsGetLegacyEndpoint;
        request: TeamsGetLegacyRequestOptions;
        response: OctokitResponse<TeamsGetLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#list-discussions-legacy
     */
    "GET /teams/:team_id/discussions": {
        parameters: TeamsListDiscussionsLegacyEndpoint;
        request: TeamsListDiscussionsLegacyRequestOptions;
        response: OctokitResponse<TeamsListDiscussionsLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#get-a-single-discussion-legacy
     */
    "GET /teams/:team_id/discussions/:discussion_number": {
        parameters: TeamsGetDiscussionLegacyEndpoint;
        request: TeamsGetDiscussionLegacyRequestOptions;
        response: OctokitResponse<TeamsGetDiscussionLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#list-comments-legacy
     */
    "GET /teams/:team_id/discussions/:discussion_number/comments": {
        parameters: TeamsListDiscussionCommentsLegacyEndpoint;
        request: TeamsListDiscussionCommentsLegacyRequestOptions;
        response: OctokitResponse<TeamsListDiscussionCommentsLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#get-a-single-comment-legacy
     */
    "GET /teams/:team_id/discussions/:discussion_number/comments/:comment_number": {
        parameters: TeamsGetDiscussionCommentLegacyEndpoint;
        request: TeamsGetDiscussionCommentLegacyRequestOptions;
        response: OctokitResponse<TeamsGetDiscussionCommentLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-team-discussion-comment-legacy
     */
    "GET /teams/:team_id/discussions/:discussion_number/comments/:comment_number/reactions": {
        parameters: ReactionsListForTeamDiscussionCommentLegacyEndpoint;
        request: ReactionsListForTeamDiscussionCommentLegacyRequestOptions;
        response: OctokitResponse<ReactionsListForTeamDiscussionCommentLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#list-reactions-for-a-team-discussion-legacy
     */
    "GET /teams/:team_id/discussions/:discussion_number/reactions": {
        parameters: ReactionsListForTeamDiscussionLegacyEndpoint;
        request: ReactionsListForTeamDiscussionLegacyRequestOptions;
        response: OctokitResponse<ReactionsListForTeamDiscussionLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#list-pending-team-invitations-legacy
     */
    "GET /teams/:team_id/invitations": {
        parameters: TeamsListPendingInvitationsLegacyEndpoint;
        request: TeamsListPendingInvitationsLegacyRequestOptions;
        response: OctokitResponse<TeamsListPendingInvitationsLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#list-team-members-legacy
     */
    "GET /teams/:team_id/members": {
        parameters: TeamsListMembersLegacyEndpoint;
        request: TeamsListMembersLegacyRequestOptions;
        response: OctokitResponse<TeamsListMembersLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#get-team-member-legacy
     */
    "GET /teams/:team_id/members/:username": {
        parameters: TeamsGetMemberLegacyEndpoint;
        request: TeamsGetMemberLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#get-team-membership-legacy
     */
    "GET /teams/:team_id/memberships/:username": {
        parameters: TeamsGetMembershipLegacyEndpoint;
        request: TeamsGetMembershipLegacyRequestOptions;
        response: OctokitResponse<TeamsGetMembershipLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-team-projects-legacy
     */
    "GET /teams/:team_id/projects": {
        parameters: TeamsListProjectsLegacyEndpoint;
        request: TeamsListProjectsLegacyRequestOptions;
        response: OctokitResponse<TeamsListProjectsLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#review-a-team-project-legacy
     */
    "GET /teams/:team_id/projects/:project_id": {
        parameters: TeamsReviewProjectLegacyEndpoint;
        request: TeamsReviewProjectLegacyRequestOptions;
        response: OctokitResponse<TeamsReviewProjectLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-team-repos-legacy
     */
    "GET /teams/:team_id/repos": {
        parameters: TeamsListReposLegacyEndpoint;
        request: TeamsListReposLegacyRequestOptions;
        response: OctokitResponse<TeamsListReposLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#check-if-a-team-manages-a-repository-legacy
     */
    "GET /teams/:team_id/repos/:owner/:repo": {
        parameters: TeamsCheckManagesRepoLegacyEndpoint;
        request: TeamsCheckManagesRepoLegacyRequestOptions;
        response: OctokitResponse<TeamsCheckManagesRepoLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/team_sync/#list-idp-groups-for-a-team-legacy
     */
    "GET /teams/:team_id/team-sync/group-mappings": {
        parameters: TeamsListIdPGroupsForLegacyEndpoint;
        request: TeamsListIdPGroupsForLegacyRequestOptions;
        response: OctokitResponse<TeamsListIdPGroupsForLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-child-teams-legacy
     */
    "GET /teams/:team_id/teams": {
        parameters: TeamsListChildLegacyEndpoint;
        request: TeamsListChildLegacyRequestOptions;
        response: OctokitResponse<TeamsListChildLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/#get-the-authenticated-user
     */
    "GET /user": {
        parameters: UsersGetAuthenticatedEndpoint;
        request: UsersGetAuthenticatedRequestOptions;
        response: OctokitResponse<UsersGetAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#list-repositories-for-a-user-migration
     */
    "GET /user/:migration_id/repositories": {
        parameters: MigrationsListReposForUserEndpoint;
        request: MigrationsListReposForUserRequestOptions;
        response: OctokitResponse<MigrationsListReposForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/blocking/#list-blocked-users
     */
    "GET /user/blocks": {
        parameters: UsersListBlockedEndpoint;
        request: UsersListBlockedRequestOptions;
        response: OctokitResponse<UsersListBlockedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/blocking/#check-whether-youve-blocked-a-user
     */
    "GET /user/blocks/:username": {
        parameters: UsersCheckBlockedEndpoint;
        request: UsersCheckBlockedRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/emails/#list-email-addresses-for-a-user
     */
    "GET /user/emails": {
        parameters: UsersListEmailsEndpoint;
        request: UsersListEmailsRequestOptions;
        response: OctokitResponse<UsersListEmailsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#list-followers-of-the-authenticated-user
     */
    "GET /user/followers": {
        parameters: UsersListFollowersForAuthenticatedUserEndpoint;
        request: UsersListFollowersForAuthenticatedUserRequestOptions;
        response: OctokitResponse<UsersListFollowersForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#list-users-followed-by-the-authenticated-user
     */
    "GET /user/following": {
        parameters: UsersListFollowedByAuthenticatedEndpoint;
        request: UsersListFollowedByAuthenticatedRequestOptions;
        response: OctokitResponse<UsersListFollowedByAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#check-if-you-are-following-a-user
     */
    "GET /user/following/:username": {
        parameters: UsersCheckFollowingEndpoint;
        request: UsersCheckFollowingRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/gpg_keys/#list-your-gpg-keys
     */
    "GET /user/gpg_keys": {
        parameters: UsersListGpgKeysEndpoint;
        request: UsersListGpgKeysRequestOptions;
        response: OctokitResponse<UsersListGpgKeysResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/gpg_keys/#get-a-single-gpg-key
     */
    "GET /user/gpg_keys/:gpg_key_id": {
        parameters: UsersGetGpgKeyEndpoint;
        request: UsersGetGpgKeyRequestOptions;
        response: OctokitResponse<UsersGetGpgKeyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#list-installations-for-a-user
     */
    "GET /user/installations": {
        parameters: AppsListInstallationsForAuthenticatedUserEndpoint;
        request: AppsListInstallationsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<AppsListInstallationsForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#list-repositories-accessible-to-the-user-for-an-installation
     */
    "GET /user/installations/:installation_id/repositories": {
        parameters: AppsListInstallationReposForAuthenticatedUserEndpoint;
        request: AppsListInstallationReposForAuthenticatedUserRequestOptions;
        response: OctokitResponse<AppsListInstallationReposForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#list-user-account-issues-assigned-to-the-authenticated-user
     */
    "GET /user/issues": {
        parameters: IssuesListForAuthenticatedUserEndpoint;
        request: IssuesListForAuthenticatedUserRequestOptions;
        response: OctokitResponse<IssuesListForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/keys/#list-your-public-keys
     */
    "GET /user/keys": {
        parameters: UsersListPublicKeysEndpoint;
        request: UsersListPublicKeysRequestOptions;
        response: OctokitResponse<UsersListPublicKeysResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/keys/#get-a-single-public-key
     */
    "GET /user/keys/:key_id": {
        parameters: UsersGetPublicKeyEndpoint;
        request: UsersGetPublicKeyRequestOptions;
        response: OctokitResponse<UsersGetPublicKeyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#list-subscriptions-for-the-authenticated-user
     */
    "GET /user/marketplace_purchases": {
        parameters: AppsListSubscriptionsForAuthenticatedUserEndpoint;
        request: AppsListSubscriptionsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<AppsListSubscriptionsForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/marketplace/#list-subscriptions-for-the-authenticated-user-stubbed
     */
    "GET /user/marketplace_purchases/stubbed": {
        parameters: AppsListSubscriptionsForAuthenticatedUserStubbedEndpoint;
        request: AppsListSubscriptionsForAuthenticatedUserStubbedRequestOptions;
        response: OctokitResponse<AppsListSubscriptionsForAuthenticatedUserStubbedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#list-your-organization-memberships
     */
    "GET /user/memberships/orgs": {
        parameters: OrgsListMembershipsEndpoint;
        request: OrgsListMembershipsRequestOptions;
        response: OctokitResponse<OrgsListMembershipsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#get-your-organization-membership
     */
    "GET /user/memberships/orgs/:org": {
        parameters: OrgsGetMembershipForAuthenticatedUserEndpoint;
        request: OrgsGetMembershipForAuthenticatedUserRequestOptions;
        response: OctokitResponse<OrgsGetMembershipForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#list-user-migrations
     */
    "GET /user/migrations": {
        parameters: MigrationsListForAuthenticatedUserEndpoint;
        request: MigrationsListForAuthenticatedUserRequestOptions;
        response: OctokitResponse<MigrationsListForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#get-the-status-of-a-user-migration
     */
    "GET /user/migrations/:migration_id": {
        parameters: MigrationsGetStatusForAuthenticatedUserEndpoint;
        request: MigrationsGetStatusForAuthenticatedUserRequestOptions;
        response: OctokitResponse<MigrationsGetStatusForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#download-a-user-migration-archive
     */
    "GET /user/migrations/:migration_id/archive": {
        parameters: MigrationsGetArchiveForAuthenticatedUserEndpoint;
        request: MigrationsGetArchiveForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#list-your-organizations
     */
    "GET /user/orgs": {
        parameters: OrgsListForAuthenticatedUserEndpoint;
        request: OrgsListForAuthenticatedUserRequestOptions;
        response: OctokitResponse<OrgsListForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/emails/#list-public-email-addresses-for-a-user
     */
    "GET /user/public_emails": {
        parameters: UsersListPublicEmailsEndpoint;
        request: UsersListPublicEmailsRequestOptions;
        response: OctokitResponse<UsersListPublicEmailsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-repositories-for-the-authenticated-user
     */
    "GET /user/repos": {
        parameters: ReposListForAuthenticatedUserEndpoint;
        request: ReposListForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/invitations/#list-a-users-repository-invitations
     */
    "GET /user/repository_invitations": {
        parameters: ReposListInvitationsForAuthenticatedUserEndpoint;
        request: ReposListInvitationsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ReposListInvitationsForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/starring/#list-repositories-starred-by-the-authenticated-user
     */
    "GET /user/starred": {
        parameters: ActivityListReposStarredByAuthenticatedUserEndpoint;
        request: ActivityListReposStarredByAuthenticatedUserRequestOptions;
        response: OctokitResponse<ActivityListReposStarredByAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/starring/#check-if-a-repository-is-starred-by-the-authenticated-user
     */
    "GET /user/starred/:owner/:repo": {
        parameters: ActivityCheckRepoIsStarredByAuthenticatedUserEndpoint;
        request: ActivityCheckRepoIsStarredByAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#list-repositories-watched-by-the-authenticated-user
     */
    "GET /user/subscriptions": {
        parameters: ActivityListWatchedReposForAuthenticatedUserEndpoint;
        request: ActivityListWatchedReposForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ActivityListWatchedReposForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#check-if-you-are-watching-a-repository-legacy
     */
    "GET /user/subscriptions/:owner/:repo": {
        parameters: ActivityCheckWatchingRepoLegacyEndpoint;
        request: ActivityCheckWatchingRepoLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#list-user-teams
     */
    "GET /user/teams": {
        parameters: TeamsListForAuthenticatedUserEndpoint;
        request: TeamsListForAuthenticatedUserRequestOptions;
        response: OctokitResponse<TeamsListForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/#get-all-users
     */
    "GET /users": {
        parameters: UsersListEndpoint;
        request: UsersListRequestOptions;
        response: OctokitResponse<UsersListResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/#get-a-single-user
     */
    "GET /users/:username": {
        parameters: UsersGetByUsernameEndpoint;
        request: UsersGetByUsernameRequestOptions;
        response: OctokitResponse<UsersGetByUsernameResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-events-for-the-authenticated-user
     */
    "GET /users/:username/events": {
        parameters: ActivityListEventsForAuthenticatedUserEndpoint;
        request: ActivityListEventsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-organization-events-for-the-authenticated-user
     */
    "GET /users/:username/events/orgs/:org": {
        parameters: ActivityListOrgEventsForAuthenticatedUserEndpoint;
        request: ActivityListOrgEventsForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-public-events-for-a-user
     */
    "GET /users/:username/events/public": {
        parameters: ActivityListPublicEventsForUserEndpoint;
        request: ActivityListPublicEventsForUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#list-followers-of-a-user
     */
    "GET /users/:username/followers": {
        parameters: UsersListFollowersForUserEndpoint;
        request: UsersListFollowersForUserRequestOptions;
        response: OctokitResponse<UsersListFollowersForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#list-users-followed-by-another-user
     */
    "GET /users/:username/following": {
        parameters: UsersListFollowingForUserEndpoint;
        request: UsersListFollowingForUserRequestOptions;
        response: OctokitResponse<UsersListFollowingForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#check-if-one-user-follows-another
     */
    "GET /users/:username/following/:target_user": {
        parameters: UsersCheckFollowingForUserEndpoint;
        request: UsersCheckFollowingForUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#list-gists-for-a-user
     */
    "GET /users/:username/gists": {
        parameters: GistsListForUserEndpoint;
        request: GistsListForUserRequestOptions;
        response: OctokitResponse<GistsListForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/gpg_keys/#list-gpg-keys-for-a-user
     */
    "GET /users/:username/gpg_keys": {
        parameters: UsersListGpgKeysForUserEndpoint;
        request: UsersListGpgKeysForUserRequestOptions;
        response: OctokitResponse<UsersListGpgKeysForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/#get-contextual-information-about-a-user
     */
    "GET /users/:username/hovercard": {
        parameters: UsersGetContextForUserEndpoint;
        request: UsersGetContextForUserRequestOptions;
        response: OctokitResponse<UsersGetContextForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#get-a-user-installation
     */
    "GET /users/:username/installation": {
        parameters: AppsGetUserInstallationEndpoint;
        request: AppsGetUserInstallationRequestOptions;
        response: OctokitResponse<AppsGetUserInstallationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/keys/#list-public-keys-for-a-user
     */
    "GET /users/:username/keys": {
        parameters: UsersListPublicKeysForUserEndpoint;
        request: UsersListPublicKeysForUserRequestOptions;
        response: OctokitResponse<UsersListPublicKeysForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#list-user-organizations
     */
    "GET /users/:username/orgs": {
        parameters: OrgsListForUserEndpoint;
        request: OrgsListForUserRequestOptions;
        response: OctokitResponse<OrgsListForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#list-user-projects
     */
    "GET /users/:username/projects": {
        parameters: ProjectsListForUserEndpoint;
        request: ProjectsListForUserRequestOptions;
        response: OctokitResponse<ProjectsListForUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-events-received-by-the-authenticated-user
     */
    "GET /users/:username/received_events": {
        parameters: ActivityListReceivedEventsForUserEndpoint;
        request: ActivityListReceivedEventsForUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/events/#list-public-events-received-by-a-user
     */
    "GET /users/:username/received_events/public": {
        parameters: ActivityListReceivedPublicEventsForUserEndpoint;
        request: ActivityListReceivedPublicEventsForUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#list-repositories-for-a-user
     */
    "GET /users/:username/repos": {
        parameters: ReposListForUserEndpoint;
        request: ReposListForUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/starring/#list-repositories-starred-by-a-user
     */
    "GET /users/:username/starred": {
        parameters: ActivityListReposStarredByUserEndpoint;
        request: ActivityListReposStarredByUserRequestOptions;
        response: OctokitResponse<ActivityListReposStarredByUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#list-repositories-watched-by-a-user
     */
    "GET /users/:username/subscriptions": {
        parameters: ActivityListReposWatchedByUserEndpoint;
        request: ActivityListReposWatchedByUserRequestOptions;
        response: OctokitResponse<ActivityListReposWatchedByUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#reset-a-token
     */
    "PATCH /applications/:client_id/token": {
        parameters: AppsResetTokenEndpoint;
        request: AppsResetTokenRequestOptions;
        response: OctokitResponse<AppsResetTokenResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#update-an-existing-authorization
     */
    "PATCH /authorizations/:authorization_id": {
        parameters: OauthAuthorizationsUpdateAuthorizationEndpoint;
        request: OauthAuthorizationsUpdateAuthorizationRequestOptions;
        response: OctokitResponse<OauthAuthorizationsUpdateAuthorizationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#update-a-gist
     */
    "PATCH /gists/:gist_id": {
        parameters: GistsUpdateEndpoint;
        request: GistsUpdateRequestOptions;
        response: OctokitResponse<GistsUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/comments/#edit-a-comment
     */
    "PATCH /gists/:gist_id/comments/:comment_id": {
        parameters: GistsUpdateCommentEndpoint;
        request: GistsUpdateCommentRequestOptions;
        response: OctokitResponse<GistsUpdateCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#mark-a-thread-as-read
     */
    "PATCH /notifications/threads/:thread_id": {
        parameters: ActivityMarkThreadAsReadEndpoint;
        request: ActivityMarkThreadAsReadRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/#edit-an-organization
     */
    "PATCH /orgs/:org": {
        parameters: OrgsUpdateEndpoint;
        request: OrgsUpdateRequestOptions;
        response: OctokitResponse<OrgsUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/hooks/#edit-a-hook
     */
    "PATCH /orgs/:org/hooks/:hook_id": {
        parameters: OrgsUpdateHookEndpoint;
        request: OrgsUpdateHookRequestOptions;
        response: OctokitResponse<OrgsUpdateHookResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#edit-team
     */
    "PATCH /orgs/:org/teams/:team_slug": {
        parameters: TeamsUpdateInOrgEndpoint;
        request: TeamsUpdateInOrgRequestOptions;
        response: OctokitResponse<TeamsUpdateInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#edit-a-discussion
     */
    "PATCH /orgs/:org/teams/:team_slug/discussions/:discussion_number": {
        parameters: TeamsUpdateDiscussionInOrgEndpoint;
        request: TeamsUpdateDiscussionInOrgRequestOptions;
        response: OctokitResponse<TeamsUpdateDiscussionInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#edit-a-comment
     */
    "PATCH /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number": {
        parameters: TeamsUpdateDiscussionCommentInOrgEndpoint;
        request: TeamsUpdateDiscussionCommentInOrgRequestOptions;
        response: OctokitResponse<TeamsUpdateDiscussionCommentInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/team_sync/#create-or-update-idp-group-connections
     */
    "PATCH /orgs/:org/teams/:team_slug/team-sync/group-mappings": {
        parameters: TeamsCreateOrUpdateIdPGroupConnectionsInOrgEndpoint;
        request: TeamsCreateOrUpdateIdPGroupConnectionsInOrgRequestOptions;
        response: OctokitResponse<TeamsCreateOrUpdateIdPGroupConnectionsInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#update-a-project
     */
    "PATCH /projects/:project_id": {
        parameters: ProjectsUpdateEndpoint;
        request: ProjectsUpdateRequestOptions;
        response: OctokitResponse<ProjectsUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/columns/#update-a-project-column
     */
    "PATCH /projects/columns/:column_id": {
        parameters: ProjectsUpdateColumnEndpoint;
        request: ProjectsUpdateColumnRequestOptions;
        response: OctokitResponse<ProjectsUpdateColumnResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/cards/#update-a-project-card
     */
    "PATCH /projects/columns/cards/:card_id": {
        parameters: ProjectsUpdateCardEndpoint;
        request: ProjectsUpdateCardRequestOptions;
        response: OctokitResponse<ProjectsUpdateCardResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#update-a-repository
     */
    "PATCH /repos/:owner/:repo": {
        parameters: ReposUpdateEndpoint;
        request: ReposUpdateRequestOptions;
        response: OctokitResponse<ReposUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#update-pull-request-review-enforcement-of-protected-branch
     */
    "PATCH /repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews": {
        parameters: ReposUpdateProtectedBranchPullRequestReviewEnforcementEndpoint;
        request: ReposUpdateProtectedBranchPullRequestReviewEnforcementRequestOptions;
        response: OctokitResponse<ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#update-required-status-checks-of-protected-branch
     */
    "PATCH /repos/:owner/:repo/branches/:branch/protection/required_status_checks": {
        parameters: ReposUpdateProtectedBranchRequiredStatusChecksEndpoint;
        request: ReposUpdateProtectedBranchRequiredStatusChecksRequestOptions;
        response: OctokitResponse<ReposUpdateProtectedBranchRequiredStatusChecksResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/runs/#update-a-check-run
     */
    "PATCH /repos/:owner/:repo/check-runs/:check_run_id": {
        parameters: ChecksUpdateEndpoint;
        request: ChecksUpdateRequestOptions;
        response: OctokitResponse<ChecksUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/suites/#update-repository-preferences-for-check-suites
     */
    "PATCH /repos/:owner/:repo/check-suites/preferences": {
        parameters: ChecksSetSuitesPreferencesEndpoint;
        request: ChecksSetSuitesPreferencesRequestOptions;
        response: OctokitResponse<ChecksSetSuitesPreferencesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/comments/#update-a-commit-comment
     */
    "PATCH /repos/:owner/:repo/comments/:comment_id": {
        parameters: ReposUpdateCommitCommentEndpoint;
        request: ReposUpdateCommitCommentRequestOptions;
        response: OctokitResponse<ReposUpdateCommitCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/refs/#update-a-reference
     */
    "PATCH /repos/:owner/:repo/git/refs/:ref": {
        parameters: GitUpdateRefEndpoint;
        request: GitUpdateRefRequestOptions;
        response: OctokitResponse<GitUpdateRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#edit-a-hook
     */
    "PATCH /repos/:owner/:repo/hooks/:hook_id": {
        parameters: ReposUpdateHookEndpoint;
        request: ReposUpdateHookRequestOptions;
        response: OctokitResponse<ReposUpdateHookResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#update-existing-import
     */
    "PATCH /repos/:owner/:repo/import": {
        parameters: MigrationsUpdateImportEndpoint;
        request: MigrationsUpdateImportRequestOptions;
        response: OctokitResponse<MigrationsUpdateImportResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#map-a-commit-author
     */
    "PATCH /repos/:owner/:repo/import/authors/:author_id": {
        parameters: MigrationsMapCommitAuthorEndpoint;
        request: MigrationsMapCommitAuthorRequestOptions;
        response: OctokitResponse<MigrationsMapCommitAuthorResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#set-git-lfs-preference
     */
    "PATCH /repos/:owner/:repo/import/lfs": {
        parameters: MigrationsSetLfsPreferenceEndpoint;
        request: MigrationsSetLfsPreferenceRequestOptions;
        response: OctokitResponse<MigrationsSetLfsPreferenceResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/invitations/#update-a-repository-invitation
     */
    "PATCH /repos/:owner/:repo/invitations/:invitation_id": {
        parameters: ReposUpdateInvitationEndpoint;
        request: ReposUpdateInvitationRequestOptions;
        response: OctokitResponse<ReposUpdateInvitationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#update-an-issue
     */
    "PATCH /repos/:owner/:repo/issues/:issue_number": {
        parameters: IssuesUpdateEndpoint;
        request: IssuesUpdateRequestOptions;
        response: OctokitResponse<IssuesUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/comments/#edit-a-comment
     */
    "PATCH /repos/:owner/:repo/issues/comments/:comment_id": {
        parameters: IssuesUpdateCommentEndpoint;
        request: IssuesUpdateCommentRequestOptions;
        response: OctokitResponse<IssuesUpdateCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#update-a-label
     */
    "PATCH /repos/:owner/:repo/labels/:name": {
        parameters: IssuesUpdateLabelEndpoint;
        request: IssuesUpdateLabelRequestOptions;
        response: OctokitResponse<IssuesUpdateLabelResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/milestones/#update-a-milestone
     */
    "PATCH /repos/:owner/:repo/milestones/:milestone_number": {
        parameters: IssuesUpdateMilestoneEndpoint;
        request: IssuesUpdateMilestoneRequestOptions;
        response: OctokitResponse<IssuesUpdateMilestoneResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#update-a-pull-request
     */
    "PATCH /repos/:owner/:repo/pulls/:pull_number": {
        parameters: PullsUpdateEndpoint;
        request: PullsUpdateRequestOptions;
        response: OctokitResponse<PullsUpdateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#edit-a-comment
     */
    "PATCH /repos/:owner/:repo/pulls/comments/:comment_id": {
        parameters: PullsUpdateCommentEndpoint;
        request: PullsUpdateCommentRequestOptions;
        response: OctokitResponse<PullsUpdateCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#edit-a-release
     */
    "PATCH /repos/:owner/:repo/releases/:release_id": {
        parameters: ReposUpdateReleaseEndpoint;
        request: ReposUpdateReleaseRequestOptions;
        response: OctokitResponse<ReposUpdateReleaseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#edit-a-release-asset
     */
    "PATCH /repos/:owner/:repo/releases/assets/:asset_id": {
        parameters: ReposUpdateReleaseAssetEndpoint;
        request: ReposUpdateReleaseAssetRequestOptions;
        response: OctokitResponse<ReposUpdateReleaseAssetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/scim/#update-a-user-attribute
     */
    "PATCH /scim/v2/organizations/:org/Users/:scim_user_id": {
        parameters: ScimUpdateUserAttributeEndpoint;
        request: ScimUpdateUserAttributeRequestOptions;
        response: OctokitResponse<ScimUpdateUserAttributeResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#edit-team-legacy
     */
    "PATCH /teams/:team_id": {
        parameters: TeamsUpdateLegacyEndpoint;
        request: TeamsUpdateLegacyRequestOptions;
        response: OctokitResponse<TeamsUpdateLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#edit-a-discussion-legacy
     */
    "PATCH /teams/:team_id/discussions/:discussion_number": {
        parameters: TeamsUpdateDiscussionLegacyEndpoint;
        request: TeamsUpdateDiscussionLegacyRequestOptions;
        response: OctokitResponse<TeamsUpdateDiscussionLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#edit-a-comment-legacy
     */
    "PATCH /teams/:team_id/discussions/:discussion_number/comments/:comment_number": {
        parameters: TeamsUpdateDiscussionCommentLegacyEndpoint;
        request: TeamsUpdateDiscussionCommentLegacyRequestOptions;
        response: OctokitResponse<TeamsUpdateDiscussionCommentLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/team_sync/#create-or-update-idp-group-connections-legacy
     */
    "PATCH /teams/:team_id/team-sync/group-mappings": {
        parameters: TeamsCreateOrUpdateIdPGroupConnectionsLegacyEndpoint;
        request: TeamsCreateOrUpdateIdPGroupConnectionsLegacyRequestOptions;
        response: OctokitResponse<TeamsCreateOrUpdateIdPGroupConnectionsLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/#update-the-authenticated-user
     */
    "PATCH /user": {
        parameters: UsersUpdateAuthenticatedEndpoint;
        request: UsersUpdateAuthenticatedRequestOptions;
        response: OctokitResponse<UsersUpdateAuthenticatedResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/emails/#toggle-primary-email-visibility
     */
    "PATCH /user/email/visibility": {
        parameters: UsersTogglePrimaryEmailVisibilityEndpoint;
        request: UsersTogglePrimaryEmailVisibilityRequestOptions;
        response: OctokitResponse<UsersTogglePrimaryEmailVisibilityResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#edit-your-organization-membership
     */
    "PATCH /user/memberships/orgs/:org": {
        parameters: OrgsUpdateMembershipEndpoint;
        request: OrgsUpdateMembershipRequestOptions;
        response: OctokitResponse<OrgsUpdateMembershipResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/invitations/#accept-a-repository-invitation
     */
    "PATCH /user/repository_invitations/:invitation_id": {
        parameters: ReposAcceptInvitationEndpoint;
        request: ReposAcceptInvitationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#create-a-github-app-from-a-manifest
     */
    "POST /app-manifests/:code/conversions": {
        parameters: AppsCreateFromManifestEndpoint;
        request: AppsCreateFromManifestRequestOptions;
        response: OctokitResponse<AppsCreateFromManifestResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#create-a-new-installation-token
     */
    "POST /app/installations/:installation_id/access_tokens": {
        parameters: AppsCreateInstallationTokenEndpoint;
        request: AppsCreateInstallationTokenRequestOptions;
        response: OctokitResponse<AppsCreateInstallationTokenResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#check-a-token
     */
    "POST /applications/:client_id/token": {
        parameters: AppsCheckTokenEndpoint;
        request: AppsCheckTokenRequestOptions;
        response: OctokitResponse<AppsCheckTokenResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/oauth_applications/#reset-an-authorization
     */
    "POST /applications/:client_id/tokens/:access_token": {
        parameters: AppsResetAuthorizationEndpoint;
        request: AppsResetAuthorizationRequestOptions;
        response: OctokitResponse<AppsResetAuthorizationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#create-a-new-authorization
     */
    "POST /authorizations": {
        parameters: OauthAuthorizationsCreateAuthorizationEndpoint;
        request: OauthAuthorizationsCreateAuthorizationRequestOptions;
        response: OctokitResponse<OauthAuthorizationsCreateAuthorizationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#create-a-content-attachment
     */
    "POST /content_references/:content_reference_id/attachments": {
        parameters: AppsCreateContentAttachmentEndpoint;
        request: AppsCreateContentAttachmentRequestOptions;
        response: OctokitResponse<AppsCreateContentAttachmentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#create-a-gist
     */
    "POST /gists": {
        parameters: GistsCreateEndpoint;
        request: GistsCreateRequestOptions;
        response: OctokitResponse<GistsCreateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/comments/#create-a-comment
     */
    "POST /gists/:gist_id/comments": {
        parameters: GistsCreateCommentEndpoint;
        request: GistsCreateCommentRequestOptions;
        response: OctokitResponse<GistsCreateCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#fork-a-gist
     */
    "POST /gists/:gist_id/forks": {
        parameters: GistsForkEndpoint;
        request: GistsForkRequestOptions;
        response: OctokitResponse<GistsForkResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/markdown/#render-an-arbitrary-markdown-document
     */
    "POST /markdown": {
        parameters: MarkdownRenderEndpoint;
        request: MarkdownRenderRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/markdown/#render-a-markdown-document-in-raw-mode
     */
    "POST /markdown/raw": {
        parameters: MarkdownRenderRawEndpoint;
        request: MarkdownRenderRawRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#create-a-registration-token-for-an-organization
     */
    "POST /orgs/:org/actions/runners/registration-token": {
        parameters: ActionsCreateRegistrationTokenForOrgEndpoint;
        request: ActionsCreateRegistrationTokenForOrgRequestOptions;
        response: OctokitResponse<ActionsCreateRegistrationTokenForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#create-a-remove-token-for-an-organization
     */
    "POST /orgs/:org/actions/runners/remove-token": {
        parameters: ActionsCreateRemoveTokenForOrgEndpoint;
        request: ActionsCreateRemoveTokenForOrgRequestOptions;
        response: OctokitResponse<ActionsCreateRemoveTokenForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/hooks/#create-a-hook
     */
    "POST /orgs/:org/hooks": {
        parameters: OrgsCreateHookEndpoint;
        request: OrgsCreateHookRequestOptions;
        response: OctokitResponse<OrgsCreateHookResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/hooks/#ping-a-hook
     */
    "POST /orgs/:org/hooks/:hook_id/pings": {
        parameters: OrgsPingHookEndpoint;
        request: OrgsPingHookRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#create-organization-invitation
     */
    "POST /orgs/:org/invitations": {
        parameters: OrgsCreateInvitationEndpoint;
        request: OrgsCreateInvitationRequestOptions;
        response: OctokitResponse<OrgsCreateInvitationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/orgs/#start-an-organization-migration
     */
    "POST /orgs/:org/migrations": {
        parameters: MigrationsStartForOrgEndpoint;
        request: MigrationsStartForOrgRequestOptions;
        response: OctokitResponse<MigrationsStartForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#create-an-organization-project
     */
    "POST /orgs/:org/projects": {
        parameters: ProjectsCreateForOrgEndpoint;
        request: ProjectsCreateForOrgRequestOptions;
        response: OctokitResponse<ProjectsCreateForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#create-an-organization-repository
     */
    "POST /orgs/:org/repos": {
        parameters: ReposCreateInOrgEndpoint;
        request: ReposCreateInOrgRequestOptions;
        response: OctokitResponse<ReposCreateInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#create-team
     */
    "POST /orgs/:org/teams": {
        parameters: TeamsCreateEndpoint;
        request: TeamsCreateRequestOptions;
        response: OctokitResponse<TeamsCreateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#create-a-discussion
     */
    "POST /orgs/:org/teams/:team_slug/discussions": {
        parameters: TeamsCreateDiscussionInOrgEndpoint;
        request: TeamsCreateDiscussionInOrgRequestOptions;
        response: OctokitResponse<TeamsCreateDiscussionInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#create-a-comment
     */
    "POST /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments": {
        parameters: TeamsCreateDiscussionCommentInOrgEndpoint;
        request: TeamsCreateDiscussionCommentInOrgRequestOptions;
        response: OctokitResponse<TeamsCreateDiscussionCommentInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-team-discussion-comment
     */
    "POST /orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions": {
        parameters: ReactionsCreateForTeamDiscussionCommentInOrgEndpoint;
        request: ReactionsCreateForTeamDiscussionCommentInOrgRequestOptions;
        response: OctokitResponse<ReactionsCreateForTeamDiscussionCommentInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-team-discussion
     */
    "POST /orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions": {
        parameters: ReactionsCreateForTeamDiscussionInOrgEndpoint;
        request: ReactionsCreateForTeamDiscussionInOrgRequestOptions;
        response: OctokitResponse<ReactionsCreateForTeamDiscussionInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/columns/#create-a-project-column
     */
    "POST /projects/:project_id/columns": {
        parameters: ProjectsCreateColumnEndpoint;
        request: ProjectsCreateColumnRequestOptions;
        response: OctokitResponse<ProjectsCreateColumnResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/cards/#create-a-project-card
     */
    "POST /projects/columns/:column_id/cards": {
        parameters: ProjectsCreateCardEndpoint;
        request: ProjectsCreateCardRequestOptions;
        response: OctokitResponse<ProjectsCreateCardResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/columns/#move-a-project-column
     */
    "POST /projects/columns/:column_id/moves": {
        parameters: ProjectsMoveColumnEndpoint;
        request: ProjectsMoveColumnRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/projects/cards/#move-a-project-card
     */
    "POST /projects/columns/cards/:card_id/moves": {
        parameters: ProjectsMoveCardEndpoint;
        request: ProjectsMoveCardRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#create-a-registration-token-for-a-repository
     */
    "POST /repos/:owner/:repo/actions/runners/registration-token": {
        parameters: ActionsCreateRegistrationTokenForRepoEndpoint;
        request: ActionsCreateRegistrationTokenForRepoRequestOptions;
        response: OctokitResponse<ActionsCreateRegistrationTokenForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/self-hosted-runners/#create-a-remove-token-for-a-repository
     */
    "POST /repos/:owner/:repo/actions/runners/remove-token": {
        parameters: ActionsCreateRemoveTokenForRepoEndpoint;
        request: ActionsCreateRemoveTokenForRepoRequestOptions;
        response: OctokitResponse<ActionsCreateRemoveTokenForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#cancel-a-workflow-run
     */
    "POST /repos/:owner/:repo/actions/runs/:run_id/cancel": {
        parameters: ActionsCancelWorkflowRunEndpoint;
        request: ActionsCancelWorkflowRunRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/workflow-runs/#re-run-a-workflow
     */
    "POST /repos/:owner/:repo/actions/runs/:run_id/rerun": {
        parameters: ActionsReRunWorkflowEndpoint;
        request: ActionsReRunWorkflowRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#add-admin-enforcement-of-protected-branch
     */
    "POST /repos/:owner/:repo/branches/:branch/protection/enforce_admins": {
        parameters: ReposAddProtectedBranchAdminEnforcementEndpoint;
        request: ReposAddProtectedBranchAdminEnforcementRequestOptions;
        response: OctokitResponse<ReposAddProtectedBranchAdminEnforcementResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#add-required-signatures-of-protected-branch
     */
    "POST /repos/:owner/:repo/branches/:branch/protection/required_signatures": {
        parameters: ReposAddProtectedBranchRequiredSignaturesEndpoint;
        request: ReposAddProtectedBranchRequiredSignaturesRequestOptions;
        response: OctokitResponse<ReposAddProtectedBranchRequiredSignaturesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#add-required-status-checks-contexts-of-protected-branch
     */
    "POST /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": {
        parameters: ReposAddProtectedBranchRequiredStatusChecksContextsEndpoint;
        request: ReposAddProtectedBranchRequiredStatusChecksContextsRequestOptions;
        response: OctokitResponse<ReposAddProtectedBranchRequiredStatusChecksContextsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#add-app-restrictions-of-protected-branch
     */
    "POST /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": {
        parameters: ReposAddProtectedBranchAppRestrictionsEndpoint;
        request: ReposAddProtectedBranchAppRestrictionsRequestOptions;
        response: OctokitResponse<ReposAddProtectedBranchAppRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#add-team-restrictions-of-protected-branch
     */
    "POST /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": {
        parameters: ReposAddProtectedBranchTeamRestrictionsEndpoint;
        request: ReposAddProtectedBranchTeamRestrictionsRequestOptions;
        response: OctokitResponse<ReposAddProtectedBranchTeamRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#add-user-restrictions-of-protected-branch
     */
    "POST /repos/:owner/:repo/branches/:branch/protection/restrictions/users": {
        parameters: ReposAddProtectedBranchUserRestrictionsEndpoint;
        request: ReposAddProtectedBranchUserRestrictionsRequestOptions;
        response: OctokitResponse<ReposAddProtectedBranchUserRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/runs/#create-a-check-run
     */
    "POST /repos/:owner/:repo/check-runs": {
        parameters: ChecksCreateEndpoint;
        request: ChecksCreateRequestOptions;
        response: OctokitResponse<ChecksCreateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/suites/#create-a-check-suite
     */
    "POST /repos/:owner/:repo/check-suites": {
        parameters: ChecksCreateSuiteEndpoint;
        request: ChecksCreateSuiteRequestOptions;
        response: OctokitResponse<ChecksCreateSuiteResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/checks/suites/#rerequest-a-check-suite
     */
    "POST /repos/:owner/:repo/check-suites/:check_suite_id/rerequest": {
        parameters: ChecksRerequestSuiteEndpoint;
        request: ChecksRerequestSuiteRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-commit-comment
     */
    "POST /repos/:owner/:repo/comments/:comment_id/reactions": {
        parameters: ReactionsCreateForCommitCommentEndpoint;
        request: ReactionsCreateForCommitCommentRequestOptions;
        response: OctokitResponse<ReactionsCreateForCommitCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/comments/#create-a-commit-comment
     */
    "POST /repos/:owner/:repo/commits/:commit_sha/comments": {
        parameters: ReposCreateCommitCommentEndpoint;
        request: ReposCreateCommitCommentRequestOptions;
        response: OctokitResponse<ReposCreateCommitCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#create-a-deployment
     */
    "POST /repos/:owner/:repo/deployments": {
        parameters: ReposCreateDeploymentEndpoint;
        request: ReposCreateDeploymentRequestOptions;
        response: OctokitResponse<ReposCreateDeploymentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/deployments/#create-a-deployment-status
     */
    "POST /repos/:owner/:repo/deployments/:deployment_id/statuses": {
        parameters: ReposCreateDeploymentStatusEndpoint;
        request: ReposCreateDeploymentStatusRequestOptions;
        response: OctokitResponse<ReposCreateDeploymentStatusResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#create-a-repository-dispatch-event
     */
    "POST /repos/:owner/:repo/dispatches": {
        parameters: ReposCreateDispatchEventEndpoint;
        request: ReposCreateDispatchEventRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/forks/#create-a-fork
     */
    "POST /repos/:owner/:repo/forks": {
        parameters: ReposCreateForkEndpoint;
        request: ReposCreateForkRequestOptions;
        response: OctokitResponse<ReposCreateForkResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/blobs/#create-a-blob
     */
    "POST /repos/:owner/:repo/git/blobs": {
        parameters: GitCreateBlobEndpoint;
        request: GitCreateBlobRequestOptions;
        response: OctokitResponse<GitCreateBlobResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/commits/#create-a-commit
     */
    "POST /repos/:owner/:repo/git/commits": {
        parameters: GitCreateCommitEndpoint;
        request: GitCreateCommitRequestOptions;
        response: OctokitResponse<GitCreateCommitResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/refs/#create-a-reference
     */
    "POST /repos/:owner/:repo/git/refs": {
        parameters: GitCreateRefEndpoint;
        request: GitCreateRefRequestOptions;
        response: OctokitResponse<GitCreateRefResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/tags/#create-a-tag-object
     */
    "POST /repos/:owner/:repo/git/tags": {
        parameters: GitCreateTagEndpoint;
        request: GitCreateTagRequestOptions;
        response: OctokitResponse<GitCreateTagResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/git/trees/#create-a-tree
     */
    "POST /repos/:owner/:repo/git/trees": {
        parameters: GitCreateTreeEndpoint;
        request: GitCreateTreeRequestOptions;
        response: OctokitResponse<GitCreateTreeResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#create-a-hook
     */
    "POST /repos/:owner/:repo/hooks": {
        parameters: ReposCreateHookEndpoint;
        request: ReposCreateHookRequestOptions;
        response: OctokitResponse<ReposCreateHookResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#ping-a-hook
     */
    "POST /repos/:owner/:repo/hooks/:hook_id/pings": {
        parameters: ReposPingHookEndpoint;
        request: ReposPingHookRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/hooks/#test-a-push-hook
     */
    "POST /repos/:owner/:repo/hooks/:hook_id/tests": {
        parameters: ReposTestPushHookEndpoint;
        request: ReposTestPushHookRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#create-an-issue
     */
    "POST /repos/:owner/:repo/issues": {
        parameters: IssuesCreateEndpoint;
        request: IssuesCreateRequestOptions;
        response: OctokitResponse<IssuesCreateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/assignees/#add-assignees-to-an-issue
     */
    "POST /repos/:owner/:repo/issues/:issue_number/assignees": {
        parameters: IssuesAddAssigneesEndpoint;
        request: IssuesAddAssigneesRequestOptions;
        response: OctokitResponse<IssuesAddAssigneesResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/comments/#create-a-comment
     */
    "POST /repos/:owner/:repo/issues/:issue_number/comments": {
        parameters: IssuesCreateCommentEndpoint;
        request: IssuesCreateCommentRequestOptions;
        response: OctokitResponse<IssuesCreateCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#add-labels-to-an-issue
     */
    "POST /repos/:owner/:repo/issues/:issue_number/labels": {
        parameters: IssuesAddLabelsEndpoint;
        request: IssuesAddLabelsRequestOptions;
        response: OctokitResponse<IssuesAddLabelsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-an-issue
     */
    "POST /repos/:owner/:repo/issues/:issue_number/reactions": {
        parameters: ReactionsCreateForIssueEndpoint;
        request: ReactionsCreateForIssueRequestOptions;
        response: OctokitResponse<ReactionsCreateForIssueResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-an-issue-comment
     */
    "POST /repos/:owner/:repo/issues/comments/:comment_id/reactions": {
        parameters: ReactionsCreateForIssueCommentEndpoint;
        request: ReactionsCreateForIssueCommentRequestOptions;
        response: OctokitResponse<ReactionsCreateForIssueCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/keys/#add-a-new-deploy-key
     */
    "POST /repos/:owner/:repo/keys": {
        parameters: ReposAddDeployKeyEndpoint;
        request: ReposAddDeployKeyRequestOptions;
        response: OctokitResponse<ReposAddDeployKeyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#create-a-label
     */
    "POST /repos/:owner/:repo/labels": {
        parameters: IssuesCreateLabelEndpoint;
        request: IssuesCreateLabelRequestOptions;
        response: OctokitResponse<IssuesCreateLabelResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/merging/#perform-a-merge
     */
    "POST /repos/:owner/:repo/merges": {
        parameters: ReposMergeEndpoint;
        request: ReposMergeRequestOptions;
        response: OctokitResponse<ReposMergeResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/milestones/#create-a-milestone
     */
    "POST /repos/:owner/:repo/milestones": {
        parameters: IssuesCreateMilestoneEndpoint;
        request: IssuesCreateMilestoneRequestOptions;
        response: OctokitResponse<IssuesCreateMilestoneResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#enable-a-pages-site
     */
    "POST /repos/:owner/:repo/pages": {
        parameters: ReposEnablePagesSiteEndpoint;
        request: ReposEnablePagesSiteRequestOptions;
        response: OctokitResponse<ReposEnablePagesSiteResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#request-a-page-build
     */
    "POST /repos/:owner/:repo/pages/builds": {
        parameters: ReposRequestPageBuildEndpoint;
        request: ReposRequestPageBuildRequestOptions;
        response: OctokitResponse<ReposRequestPageBuildResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#create-a-repository-project
     */
    "POST /repos/:owner/:repo/projects": {
        parameters: ProjectsCreateForRepoEndpoint;
        request: ProjectsCreateForRepoRequestOptions;
        response: OctokitResponse<ProjectsCreateForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#create-a-pull-request
     */
    "POST /repos/:owner/:repo/pulls": {
        parameters: PullsCreateEndpoint;
        request: PullsCreateRequestOptions;
        response: OctokitResponse<PullsCreateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#create-a-comment
     */
    "POST /repos/:owner/:repo/pulls/:pull_number/comments": {
        parameters: PullsCreateCommentEndpoint;
        request: PullsCreateCommentRequestOptions;
        response: OctokitResponse<PullsCreateCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/comments/#create-a-review-comment-reply
     */
    "POST /repos/:owner/:repo/pulls/:pull_number/comments/:comment_id/replies": {
        parameters: PullsCreateReviewCommentReplyEndpoint;
        request: PullsCreateReviewCommentReplyRequestOptions;
        response: OctokitResponse<PullsCreateReviewCommentReplyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/review_requests/#create-a-review-request
     */
    "POST /repos/:owner/:repo/pulls/:pull_number/requested_reviewers": {
        parameters: PullsCreateReviewRequestEndpoint;
        request: PullsCreateReviewRequestRequestOptions;
        response: OctokitResponse<PullsCreateReviewRequestResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#create-a-pull-request-review
     */
    "POST /repos/:owner/:repo/pulls/:pull_number/reviews": {
        parameters: PullsCreateReviewEndpoint;
        request: PullsCreateReviewRequestOptions;
        response: OctokitResponse<PullsCreateReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#submit-a-pull-request-review
     */
    "POST /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/events": {
        parameters: PullsSubmitReviewEndpoint;
        request: PullsSubmitReviewRequestOptions;
        response: OctokitResponse<PullsSubmitReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-pull-request-review-comment
     */
    "POST /repos/:owner/:repo/pulls/comments/:comment_id/reactions": {
        parameters: ReactionsCreateForPullRequestReviewCommentEndpoint;
        request: ReactionsCreateForPullRequestReviewCommentRequestOptions;
        response: OctokitResponse<ReactionsCreateForPullRequestReviewCommentResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#create-a-release
     */
    "POST /repos/:owner/:repo/releases": {
        parameters: ReposCreateReleaseEndpoint;
        request: ReposCreateReleaseRequestOptions;
        response: OctokitResponse<ReposCreateReleaseResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/releases/#upload-a-release-asset
     */
    "POST /repos/:owner/:repo/releases/:release_id/assets{?name,label}": {
        parameters: ReposUploadReleaseAssetEndpoint;
        request: ReposUploadReleaseAssetRequestOptions;
        response: OctokitResponse<ReposUploadReleaseAssetResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/statuses/#create-a-status
     */
    "POST /repos/:owner/:repo/statuses/:sha": {
        parameters: ReposCreateStatusEndpoint;
        request: ReposCreateStatusRequestOptions;
        response: OctokitResponse<ReposCreateStatusResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#transfer-a-repository
     */
    "POST /repos/:owner/:repo/transfer": {
        parameters: ReposTransferEndpoint;
        request: ReposTransferRequestOptions;
        response: OctokitResponse<ReposTransferResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#create-a-repository-using-a-template
     */
    "POST /repos/:template_owner/:template_repo/generate": {
        parameters: ReposCreateUsingTemplateEndpoint;
        request: ReposCreateUsingTemplateRequestOptions;
        response: OctokitResponse<ReposCreateUsingTemplateResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/scim/#provision-and-invite-users
     */
    "POST /scim/v2/organizations/:org/Users": {
        parameters: ScimProvisionAndInviteUsersEndpoint;
        request: ScimProvisionAndInviteUsersRequestOptions;
        response: OctokitResponse<ScimProvisionAndInviteUsersResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussions/#create-a-discussion-legacy
     */
    "POST /teams/:team_id/discussions": {
        parameters: TeamsCreateDiscussionLegacyEndpoint;
        request: TeamsCreateDiscussionLegacyRequestOptions;
        response: OctokitResponse<TeamsCreateDiscussionLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/discussion_comments/#create-a-comment-legacy
     */
    "POST /teams/:team_id/discussions/:discussion_number/comments": {
        parameters: TeamsCreateDiscussionCommentLegacyEndpoint;
        request: TeamsCreateDiscussionCommentLegacyRequestOptions;
        response: OctokitResponse<TeamsCreateDiscussionCommentLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-team-discussion-comment-legacy
     */
    "POST /teams/:team_id/discussions/:discussion_number/comments/:comment_number/reactions": {
        parameters: ReactionsCreateForTeamDiscussionCommentLegacyEndpoint;
        request: ReactionsCreateForTeamDiscussionCommentLegacyRequestOptions;
        response: OctokitResponse<ReactionsCreateForTeamDiscussionCommentLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/reactions/#create-reaction-for-a-team-discussion-legacy
     */
    "POST /teams/:team_id/discussions/:discussion_number/reactions": {
        parameters: ReactionsCreateForTeamDiscussionLegacyEndpoint;
        request: ReactionsCreateForTeamDiscussionLegacyRequestOptions;
        response: OctokitResponse<ReactionsCreateForTeamDiscussionLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/emails/#add-email-addresses
     */
    "POST /user/emails": {
        parameters: UsersAddEmailsEndpoint;
        request: UsersAddEmailsRequestOptions;
        response: OctokitResponse<UsersAddEmailsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/gpg_keys/#create-a-gpg-key
     */
    "POST /user/gpg_keys": {
        parameters: UsersCreateGpgKeyEndpoint;
        request: UsersCreateGpgKeyRequestOptions;
        response: OctokitResponse<UsersCreateGpgKeyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/users/keys/#create-a-public-key
     */
    "POST /user/keys": {
        parameters: UsersCreatePublicKeyEndpoint;
        request: UsersCreatePublicKeyRequestOptions;
        response: OctokitResponse<UsersCreatePublicKeyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/users/#start-a-user-migration
     */
    "POST /user/migrations": {
        parameters: MigrationsStartForAuthenticatedUserEndpoint;
        request: MigrationsStartForAuthenticatedUserRequestOptions;
        response: OctokitResponse<MigrationsStartForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/projects/#create-a-user-project
     */
    "POST /user/projects": {
        parameters: ProjectsCreateForAuthenticatedUserEndpoint;
        request: ProjectsCreateForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ProjectsCreateForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#create-a-repository-for-the-authenticated-user
     */
    "POST /user/repos": {
        parameters: ReposCreateForAuthenticatedUserEndpoint;
        request: ReposCreateForAuthenticatedUserRequestOptions;
        response: OctokitResponse<ReposCreateForAuthenticatedUserResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/apps/#suspend-an-installation
     */
    "PUT /app/installations/:installation_id/suspended": {
        parameters: AppsSuspendInstallationEndpoint;
        request: AppsSuspendInstallationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app
     */
    "PUT /authorizations/clients/:client_id": {
        parameters: OauthAuthorizationsGetOrCreateAuthorizationForAppEndpoint;
        request: OauthAuthorizationsGetOrCreateAuthorizationForAppRequestOptions;
        response: OctokitResponse<OauthAuthorizationsGetOrCreateAuthorizationForAppResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app-and-fingerprint
     */
    "PUT /authorizations/clients/:client_id/:fingerprint": {
        parameters: OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintEndpoint;
        request: OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintRequestOptions;
        response: OctokitResponse<OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/gists/#star-a-gist
     */
    "PUT /gists/:gist_id/star": {
        parameters: GistsStarEndpoint;
        request: GistsStarRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#mark-notifications-as-read
     */
    "PUT /notifications": {
        parameters: ActivityMarkNotificationsAsReadEndpoint;
        request: ActivityMarkNotificationsAsReadRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#set-a-thread-subscription
     */
    "PUT /notifications/threads/:thread_id/subscription": {
        parameters: ActivitySetThreadSubscriptionEndpoint;
        request: ActivitySetThreadSubscriptionRequestOptions;
        response: OctokitResponse<ActivitySetThreadSubscriptionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/blocking/#block-a-user
     */
    "PUT /orgs/:org/blocks/:username": {
        parameters: OrgsBlockUserEndpoint;
        request: OrgsBlockUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/interactions/orgs/#add-or-update-interaction-restrictions-for-an-organization
     */
    "PUT /orgs/:org/interaction-limits": {
        parameters: InteractionsAddOrUpdateRestrictionsForOrgEndpoint;
        request: InteractionsAddOrUpdateRestrictionsForOrgRequestOptions;
        response: OctokitResponse<InteractionsAddOrUpdateRestrictionsForOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#add-or-update-organization-membership
     */
    "PUT /orgs/:org/memberships/:username": {
        parameters: OrgsAddOrUpdateMembershipEndpoint;
        request: OrgsAddOrUpdateMembershipRequestOptions;
        response: OctokitResponse<OrgsAddOrUpdateMembershipResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/outside_collaborators/#convert-member-to-outside-collaborator
     */
    "PUT /orgs/:org/outside_collaborators/:username": {
        parameters: OrgsConvertMemberToOutsideCollaboratorEndpoint;
        request: OrgsConvertMemberToOutsideCollaboratorRequestOptions;
        response: OctokitResponse<OrgsConvertMemberToOutsideCollaboratorResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/orgs/members/#publicize-a-users-membership
     */
    "PUT /orgs/:org/public_members/:username": {
        parameters: OrgsPublicizeMembershipEndpoint;
        request: OrgsPublicizeMembershipRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#add-or-update-team-membership
     */
    "PUT /orgs/:org/teams/:team_slug/memberships/:username": {
        parameters: TeamsAddOrUpdateMembershipInOrgEndpoint;
        request: TeamsAddOrUpdateMembershipInOrgRequestOptions;
        response: OctokitResponse<TeamsAddOrUpdateMembershipInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#add-or-update-team-project
     */
    "PUT /orgs/:org/teams/:team_slug/projects/:project_id": {
        parameters: TeamsAddOrUpdateProjectInOrgEndpoint;
        request: TeamsAddOrUpdateProjectInOrgRequestOptions;
        response: OctokitResponse<TeamsAddOrUpdateProjectInOrgResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#add-or-update-team-repository
     */
    "PUT /orgs/:org/teams/:team_slug/repos/:owner/:repo": {
        parameters: TeamsAddOrUpdateRepoInOrgEndpoint;
        request: TeamsAddOrUpdateRepoInOrgRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/projects/collaborators/#add-user-as-a-collaborator
     */
    "PUT /projects/:project_id/collaborators/:username": {
        parameters: ProjectsAddCollaboratorEndpoint;
        request: ProjectsAddCollaboratorRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/actions/secrets/#create-or-update-a-secret-for-a-repository
     */
    "PUT /repos/:owner/:repo/actions/secrets/:name": {
        parameters: ActionsCreateOrUpdateSecretForRepoEndpoint;
        request: ActionsCreateOrUpdateSecretForRepoRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#enable-automated-security-fixes
     */
    "PUT /repos/:owner/:repo/automated-security-fixes": {
        parameters: ReposEnableAutomatedSecurityFixesEndpoint;
        request: ReposEnableAutomatedSecurityFixesRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#update-branch-protection
     */
    "PUT /repos/:owner/:repo/branches/:branch/protection": {
        parameters: ReposUpdateBranchProtectionEndpoint;
        request: ReposUpdateBranchProtectionRequestOptions;
        response: OctokitResponse<ReposUpdateBranchProtectionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#replace-required-status-checks-contexts-of-protected-branch
     */
    "PUT /repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts": {
        parameters: ReposReplaceProtectedBranchRequiredStatusChecksContextsEndpoint;
        request: ReposReplaceProtectedBranchRequiredStatusChecksContextsRequestOptions;
        response: OctokitResponse<ReposReplaceProtectedBranchRequiredStatusChecksContextsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#replace-app-restrictions-of-protected-branch
     */
    "PUT /repos/:owner/:repo/branches/:branch/protection/restrictions/apps": {
        parameters: ReposReplaceProtectedBranchAppRestrictionsEndpoint;
        request: ReposReplaceProtectedBranchAppRestrictionsRequestOptions;
        response: OctokitResponse<ReposReplaceProtectedBranchAppRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#replace-team-restrictions-of-protected-branch
     */
    "PUT /repos/:owner/:repo/branches/:branch/protection/restrictions/teams": {
        parameters: ReposReplaceProtectedBranchTeamRestrictionsEndpoint;
        request: ReposReplaceProtectedBranchTeamRestrictionsRequestOptions;
        response: OctokitResponse<ReposReplaceProtectedBranchTeamRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/branches/#replace-user-restrictions-of-protected-branch
     */
    "PUT /repos/:owner/:repo/branches/:branch/protection/restrictions/users": {
        parameters: ReposReplaceProtectedBranchUserRestrictionsEndpoint;
        request: ReposReplaceProtectedBranchUserRestrictionsRequestOptions;
        response: OctokitResponse<ReposReplaceProtectedBranchUserRestrictionsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/collaborators/#add-user-as-a-collaborator
     */
    "PUT /repos/:owner/:repo/collaborators/:username": {
        parameters: ReposAddCollaboratorEndpoint;
        request: ReposAddCollaboratorRequestOptions;
        response: OctokitResponse<ReposAddCollaboratorResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/contents/#create-or-update-a-file
     */
    "PUT /repos/:owner/:repo/contents/:path": {
        parameters: ReposCreateOrUpdateFileEndpoint;
        request: ReposCreateOrUpdateFileRequestOptions;
        response: OctokitResponse<ReposCreateOrUpdateFileResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/migrations/source_imports/#start-an-import
     */
    "PUT /repos/:owner/:repo/import": {
        parameters: MigrationsStartImportEndpoint;
        request: MigrationsStartImportRequestOptions;
        response: OctokitResponse<MigrationsStartImportResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/interactions/repos/#add-or-update-interaction-restrictions-for-a-repository
     */
    "PUT /repos/:owner/:repo/interaction-limits": {
        parameters: InteractionsAddOrUpdateRestrictionsForRepoEndpoint;
        request: InteractionsAddOrUpdateRestrictionsForRepoRequestOptions;
        response: OctokitResponse<InteractionsAddOrUpdateRestrictionsForRepoResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/labels/#replace-all-labels-for-an-issue
     */
    "PUT /repos/:owner/:repo/issues/:issue_number/labels": {
        parameters: IssuesReplaceAllLabelsEndpoint;
        request: IssuesReplaceAllLabelsRequestOptions;
        response: OctokitResponse<IssuesReplaceAllLabelsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/issues/#lock-an-issue
     */
    "PUT /repos/:owner/:repo/issues/:issue_number/lock": {
        parameters: IssuesLockEndpoint;
        request: IssuesLockRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/notifications/#mark-repository-notifications-as-read
     */
    "PUT /repos/:owner/:repo/notifications": {
        parameters: ActivityMarkRepoNotificationsAsReadEndpoint;
        request: ActivityMarkRepoNotificationsAsReadRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/repos/pages/#update-information-about-a-pages-site
     */
    "PUT /repos/:owner/:repo/pages": {
        parameters: ReposUpdateInformationAboutPagesSiteEndpoint;
        request: ReposUpdateInformationAboutPagesSiteRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#merge-a-pull-request-merge-button
     */
    "PUT /repos/:owner/:repo/pulls/:pull_number/merge": {
        parameters: PullsMergeEndpoint;
        request: PullsMergeRequestOptions;
        response: OctokitResponse<PullsMergeResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#update-a-pull-request-review
     */
    "PUT /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id": {
        parameters: PullsUpdateReviewEndpoint;
        request: PullsUpdateReviewRequestOptions;
        response: OctokitResponse<PullsUpdateReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/reviews/#dismiss-a-pull-request-review
     */
    "PUT /repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/dismissals": {
        parameters: PullsDismissReviewEndpoint;
        request: PullsDismissReviewRequestOptions;
        response: OctokitResponse<PullsDismissReviewResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/pulls/#update-a-pull-request-branch
     */
    "PUT /repos/:owner/:repo/pulls/:pull_number/update-branch": {
        parameters: PullsUpdateBranchEndpoint;
        request: PullsUpdateBranchRequestOptions;
        response: OctokitResponse<PullsUpdateBranchResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#set-a-repository-subscription
     */
    "PUT /repos/:owner/:repo/subscription": {
        parameters: ActivitySetRepoSubscriptionEndpoint;
        request: ActivitySetRepoSubscriptionRequestOptions;
        response: OctokitResponse<ActivitySetRepoSubscriptionResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#replace-all-repository-topics
     */
    "PUT /repos/:owner/:repo/topics": {
        parameters: ReposReplaceAllTopicsEndpoint;
        request: ReposReplaceAllTopicsRequestOptions;
        response: OctokitResponse<ReposReplaceAllTopicsResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/repos/#enable-vulnerability-alerts
     */
    "PUT /repos/:owner/:repo/vulnerability-alerts": {
        parameters: ReposEnableVulnerabilityAlertsEndpoint;
        request: ReposEnableVulnerabilityAlertsRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/scim/#replace-a-provisioned-users-information
     */
    "PUT /scim/v2/organizations/:org/Users/:scim_user_id": {
        parameters: ScimReplaceProvisionedUserInformationEndpoint;
        request: ScimReplaceProvisionedUserInformationRequestOptions;
        response: OctokitResponse<ScimReplaceProvisionedUserInformationResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#add-team-member-legacy
     */
    "PUT /teams/:team_id/members/:username": {
        parameters: TeamsAddMemberLegacyEndpoint;
        request: TeamsAddMemberLegacyRequestOptions;
        response: OctokitResponse<TeamsAddMemberLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/members/#add-or-update-team-membership-legacy
     */
    "PUT /teams/:team_id/memberships/:username": {
        parameters: TeamsAddOrUpdateMembershipLegacyEndpoint;
        request: TeamsAddOrUpdateMembershipLegacyRequestOptions;
        response: OctokitResponse<TeamsAddOrUpdateMembershipLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#add-or-update-team-project-legacy
     */
    "PUT /teams/:team_id/projects/:project_id": {
        parameters: TeamsAddOrUpdateProjectLegacyEndpoint;
        request: TeamsAddOrUpdateProjectLegacyRequestOptions;
        response: OctokitResponse<TeamsAddOrUpdateProjectLegacyResponseData>;
    };
    /**
     * @see https://developer.github.com/v3/teams/#add-or-update-team-repository-legacy
     */
    "PUT /teams/:team_id/repos/:owner/:repo": {
        parameters: TeamsAddOrUpdateRepoLegacyEndpoint;
        request: TeamsAddOrUpdateRepoLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/blocking/#block-a-user
     */
    "PUT /user/blocks/:username": {
        parameters: UsersBlockEndpoint;
        request: UsersBlockRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/users/followers/#follow-a-user
     */
    "PUT /user/following/:username": {
        parameters: UsersFollowEndpoint;
        request: UsersFollowRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/apps/installations/#add-repository-to-installation
     */
    "PUT /user/installations/:installation_id/repositories/:repository_id": {
        parameters: AppsAddRepoToInstallationEndpoint;
        request: AppsAddRepoToInstallationRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/starring/#star-a-repository-for-the-authenticated-user
     */
    "PUT /user/starred/:owner/:repo": {
        parameters: ActivityStarRepoForAuthenticatedUserEndpoint;
        request: ActivityStarRepoForAuthenticatedUserRequestOptions;
        response: OctokitResponse<any>;
    };
    /**
     * @see https://developer.github.com/v3/activity/watching/#watch-a-repository-legacy
     */
    "PUT /user/subscriptions/:owner/:repo": {
        parameters: ActivityWatchRepoLegacyEndpoint;
        request: ActivityWatchRepoLegacyRequestOptions;
        response: OctokitResponse<any>;
    };
}
declare type AppsGetAuthenticatedEndpoint = {} & RequiredPreview<"machine-man">;
declare type AppsGetAuthenticatedRequestOptions = {
    method: "GET";
    url: "/app";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsGetAuthenticatedResponseDataPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type AppsGetAuthenticatedResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type AppsGetAuthenticatedResponseData = {
    id: number;
    slug: string;
    node_id: string;
    owner: AppsGetAuthenticatedResponseDataOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: AppsGetAuthenticatedResponseDataPermissions;
    events: Array<string>;
    installations_count: number;
};
declare type AppsCreateFromManifestEndpoint = {
    /**
     * code parameter
     */
    code: string;
};
declare type AppsCreateFromManifestRequestOptions = {
    method: "POST";
    url: "/app-manifests/:code/conversions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsCreateFromManifestResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type AppsCreateFromManifestResponseData = {
    id: number;
    node_id: string;
    owner: AppsCreateFromManifestResponseDataOwner;
    name: string;
    description: null;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    client_id: string;
    client_secret: string;
    webhook_secret: string;
    pem: string;
};
declare type AppsListInstallationsEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"machine-man">;
declare type AppsListInstallationsRequestOptions = {
    method: "GET";
    url: "/app/installations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsListInstallationsResponseDataItemPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type AppsListInstallationsResponseDataItemAccount = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type AppsListInstallationsResponseDataItem = {
    id: number;
    account: AppsListInstallationsResponseDataItemAccount;
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: AppsListInstallationsResponseDataItemPermissions;
    events: Array<string>;
    single_file_name: string;
    repository_selection: string;
};
declare type AppsListInstallationsResponseData = Array<AppsListInstallationsResponseDataItem>;
declare type AppsGetInstallationEndpoint = {
    /**
     * installation_id parameter
     */
    installation_id: number;
} & RequiredPreview<"machine-man">;
declare type AppsGetInstallationRequestOptions = {
    method: "GET";
    url: "/app/installations/:installation_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsGetInstallationResponseDataPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type AppsGetInstallationResponseDataAccount = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type AppsGetInstallationResponseData = {
    id: number;
    account: AppsGetInstallationResponseDataAccount;
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: AppsGetInstallationResponseDataPermissions;
    events: Array<string>;
    single_file_name: string;
    repository_selection: string;
};
declare type AppsDeleteInstallationEndpoint = {
    /**
     * installation_id parameter
     */
    installation_id: number;
} & RequiredPreview<"machine-man">;
declare type AppsDeleteInstallationRequestOptions = {
    method: "DELETE";
    url: "/app/installations/:installation_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsCreateInstallationTokenEndpoint = {
    /**
     * installation_id parameter
     */
    installation_id: number;
    /**
     * The `id`s of the repositories that the installation token can access. Providing repository `id`s restricts the access of an installation token to specific repositories. You can use the "[List repositories](https://developer.github.com/v3/apps/installations/#list-repositories)" endpoint to get the `id` of all repositories that an installation can access. For example, you can select specific repositories when creating an installation token to restrict the number of repositories that can be cloned using the token.
     */
    repository_ids?: number[];
    /**
     * The permissions granted to the access token. The permissions object includes the permission names and their access type. For a complete list of permissions and allowable values, see "[GitHub App permissions](https://developer.github.com/apps/building-github-apps/creating-github-apps-using-url-parameters/#github-app-permissions)."
     */
    permissions?: AppsCreateInstallationTokenParamsPermissions;
} & RequiredPreview<"machine-man">;
declare type AppsCreateInstallationTokenRequestOptions = {
    method: "POST";
    url: "/app/installations/:installation_id/access_tokens";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsCreateInstallationTokenResponseDataRepositoriesItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type AppsCreateInstallationTokenResponseDataRepositoriesItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type AppsCreateInstallationTokenResponseDataRepositoriesItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: AppsCreateInstallationTokenResponseDataRepositoriesItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: AppsCreateInstallationTokenResponseDataRepositoriesItemPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type AppsCreateInstallationTokenResponseDataPermissions = {
    issues: string;
    contents: string;
};
declare type AppsCreateInstallationTokenResponseData = {
    token: string;
    expires_at: string;
    permissions: AppsCreateInstallationTokenResponseDataPermissions;
    repositories: Array<AppsCreateInstallationTokenResponseDataRepositoriesItem>;
};
declare type AppsSuspendInstallationEndpoint = {
    /**
     * installation_id parameter
     */
    installation_id: number;
};
declare type AppsSuspendInstallationRequestOptions = {
    method: "PUT";
    url: "/app/installations/:installation_id/suspended";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsUnsuspendInstallationEndpoint = {
    /**
     * installation_id parameter
     */
    installation_id: number;
};
declare type AppsUnsuspendInstallationRequestOptions = {
    method: "DELETE";
    url: "/app/installations/:installation_id/suspended";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OauthAuthorizationsListGrantsEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OauthAuthorizationsListGrantsRequestOptions = {
    method: "GET";
    url: "/applications/grants";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OauthAuthorizationsListGrantsResponseDataItemApp = {
    url: string;
    name: string;
    client_id: string;
};
declare type OauthAuthorizationsListGrantsResponseDataItem = {
    id: number;
    url: string;
    app: OauthAuthorizationsListGrantsResponseDataItemApp;
    created_at: string;
    updated_at: string;
    scopes: Array<string>;
};
declare type OauthAuthorizationsListGrantsResponseData = Array<OauthAuthorizationsListGrantsResponseDataItem>;
declare type OauthAuthorizationsGetGrantEndpoint = {
    /**
     * grant_id parameter
     */
    grant_id: number;
};
declare type OauthAuthorizationsGetGrantRequestOptions = {
    method: "GET";
    url: "/applications/grants/:grant_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OauthAuthorizationsGetGrantResponseDataApp = {
    url: string;
    name: string;
    client_id: string;
};
declare type OauthAuthorizationsGetGrantResponseData = {
    id: number;
    url: string;
    app: OauthAuthorizationsGetGrantResponseDataApp;
    created_at: string;
    updated_at: string;
    scopes: Array<string>;
};
declare type OauthAuthorizationsDeleteGrantEndpoint = {
    /**
     * grant_id parameter
     */
    grant_id: number;
};
declare type OauthAuthorizationsDeleteGrantRequestOptions = {
    method: "DELETE";
    url: "/applications/grants/:grant_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsDeleteAuthorizationEndpoint = {
    /**
     * client_id parameter
     */
    client_id: string;
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;
};
declare type AppsDeleteAuthorizationRequestOptions = {
    method: "DELETE";
    url: "/applications/:client_id/grant";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsRevokeGrantForApplicationEndpoint = {
    /**
     * client_id parameter
     */
    client_id: string;
    /**
     * access_token parameter
     */
    access_token: string;
};
declare type AppsRevokeGrantForApplicationRequestOptions = {
    method: "DELETE";
    url: "/applications/:client_id/grants/:access_token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsCheckTokenEndpoint = {
    /**
     * client_id parameter
     */
    client_id: string;
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;
};
declare type AppsCheckTokenRequestOptions = {
    method: "POST";
    url: "/applications/:client_id/token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsCheckTokenResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type AppsCheckTokenResponseDataApp = {
    url: string;
    name: string;
    client_id: string;
};
declare type AppsCheckTokenResponseData = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: AppsCheckTokenResponseDataApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
    user: AppsCheckTokenResponseDataUser;
};
declare type AppsResetTokenEndpoint = {
    /**
     * client_id parameter
     */
    client_id: string;
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;
};
declare type AppsResetTokenRequestOptions = {
    method: "PATCH";
    url: "/applications/:client_id/token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsResetTokenResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type AppsResetTokenResponseDataApp = {
    url: string;
    name: string;
    client_id: string;
};
declare type AppsResetTokenResponseData = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: AppsResetTokenResponseDataApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
    user: AppsResetTokenResponseDataUser;
};
declare type AppsDeleteTokenEndpoint = {
    /**
     * client_id parameter
     */
    client_id: string;
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;
};
declare type AppsDeleteTokenRequestOptions = {
    method: "DELETE";
    url: "/applications/:client_id/token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsCheckAuthorizationEndpoint = {
    /**
     * client_id parameter
     */
    client_id: string;
    /**
     * access_token parameter
     */
    access_token: string;
};
declare type AppsCheckAuthorizationRequestOptions = {
    method: "GET";
    url: "/applications/:client_id/tokens/:access_token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsCheckAuthorizationResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type AppsCheckAuthorizationResponseDataApp = {
    url: string;
    name: string;
    client_id: string;
};
declare type AppsCheckAuthorizationResponseData = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: AppsCheckAuthorizationResponseDataApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
    user: AppsCheckAuthorizationResponseDataUser;
};
declare type AppsResetAuthorizationEndpoint = {
    /**
     * client_id parameter
     */
    client_id: string;
    /**
     * access_token parameter
     */
    access_token: string;
};
declare type AppsResetAuthorizationRequestOptions = {
    method: "POST";
    url: "/applications/:client_id/tokens/:access_token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsResetAuthorizationResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type AppsResetAuthorizationResponseDataApp = {
    url: string;
    name: string;
    client_id: string;
};
declare type AppsResetAuthorizationResponseData = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: AppsResetAuthorizationResponseDataApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
    user: AppsResetAuthorizationResponseDataUser;
};
declare type AppsRevokeAuthorizationForApplicationEndpoint = {
    /**
     * client_id parameter
     */
    client_id: string;
    /**
     * access_token parameter
     */
    access_token: string;
};
declare type AppsRevokeAuthorizationForApplicationRequestOptions = {
    method: "DELETE";
    url: "/applications/:client_id/tokens/:access_token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsGetBySlugEndpoint = {
    /**
     * app_slug parameter
     */
    app_slug: string;
} & RequiredPreview<"machine-man">;
declare type AppsGetBySlugRequestOptions = {
    method: "GET";
    url: "/apps/:app_slug";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsGetBySlugResponseDataPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type AppsGetBySlugResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type AppsGetBySlugResponseData = {
    id: number;
    slug: string;
    node_id: string;
    owner: AppsGetBySlugResponseDataOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: AppsGetBySlugResponseDataPermissions;
    events: Array<string>;
};
declare type OauthAuthorizationsListAuthorizationsEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OauthAuthorizationsListAuthorizationsRequestOptions = {
    method: "GET";
    url: "/authorizations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OauthAuthorizationsListAuthorizationsResponseDataItemApp = {
    url: string;
    name: string;
    client_id: string;
};
declare type OauthAuthorizationsListAuthorizationsResponseDataItem = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: OauthAuthorizationsListAuthorizationsResponseDataItemApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
};
declare type OauthAuthorizationsListAuthorizationsResponseData = Array<OauthAuthorizationsListAuthorizationsResponseDataItem>;
declare type OauthAuthorizationsCreateAuthorizationEndpoint = {
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
    /**
     * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
     */
    note: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * The 20 character OAuth app client key for which to create the token.
     */
    client_id?: string;
    /**
     * The 40 character OAuth app client secret for which to create the token.
     */
    client_secret?: string;
    /**
     * A unique string to distinguish an authorization from others created for the same client ID and user.
     */
    fingerprint?: string;
};
declare type OauthAuthorizationsCreateAuthorizationRequestOptions = {
    method: "POST";
    url: "/authorizations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OauthAuthorizationsCreateAuthorizationResponseDataApp = {
    url: string;
    name: string;
    client_id: string;
};
declare type OauthAuthorizationsCreateAuthorizationResponseData = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: OauthAuthorizationsCreateAuthorizationResponseDataApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppEndpoint = {
    /**
     * client_id parameter
     */
    client_id: string;
    /**
     * The 40 character OAuth app client secret associated with the client ID specified in the URL.
     */
    client_secret: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
    /**
     * A note to remind you what the OAuth token is for.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A unique string to distinguish an authorization from others created for the same client and user. If provided, this API is functionally equivalent to [Get-or-create an authorization for a specific app and fingerprint](https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app-and-fingerprint).
     */
    fingerprint?: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppRequestOptions = {
    method: "PUT";
    url: "/authorizations/clients/:client_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppResponseDataApp = {
    url: string;
    name: string;
    client_id: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppResponseData = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: OauthAuthorizationsGetOrCreateAuthorizationForAppResponseDataApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintEndpoint = {
    /**
     * client_id parameter
     */
    client_id: string;
    /**
     * fingerprint parameter
     */
    fingerprint: string;
    /**
     * The 40 character OAuth app client secret associated with the client ID specified in the URL.
     */
    client_secret: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
    /**
     * A note to remind you what the OAuth token is for.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintRequestOptions = {
    method: "PUT";
    url: "/authorizations/clients/:client_id/:fingerprint";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseDataApp = {
    url: string;
    name: string;
    client_id: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseData = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseDataApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
};
declare type OauthAuthorizationsGetAuthorizationEndpoint = {
    /**
     * authorization_id parameter
     */
    authorization_id: number;
};
declare type OauthAuthorizationsGetAuthorizationRequestOptions = {
    method: "GET";
    url: "/authorizations/:authorization_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OauthAuthorizationsGetAuthorizationResponseDataApp = {
    url: string;
    name: string;
    client_id: string;
};
declare type OauthAuthorizationsGetAuthorizationResponseData = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: OauthAuthorizationsGetAuthorizationResponseDataApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
};
declare type OauthAuthorizationsUpdateAuthorizationEndpoint = {
    /**
     * authorization_id parameter
     */
    authorization_id: number;
    /**
     * Replaces the authorization scopes with these.
     */
    scopes?: string[];
    /**
     * A list of scopes to add to this authorization.
     */
    add_scopes?: string[];
    /**
     * A list of scopes to remove from this authorization.
     */
    remove_scopes?: string[];
    /**
     * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A unique string to distinguish an authorization from others created for the same client ID and user.
     */
    fingerprint?: string;
};
declare type OauthAuthorizationsUpdateAuthorizationRequestOptions = {
    method: "PATCH";
    url: "/authorizations/:authorization_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OauthAuthorizationsUpdateAuthorizationResponseDataApp = {
    url: string;
    name: string;
    client_id: string;
};
declare type OauthAuthorizationsUpdateAuthorizationResponseData = {
    id: number;
    url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    hashed_token: string;
    app: OauthAuthorizationsUpdateAuthorizationResponseDataApp;
    note: string;
    note_url: string;
    updated_at: string;
    created_at: string;
    fingerprint: string;
};
declare type OauthAuthorizationsDeleteAuthorizationEndpoint = {
    /**
     * authorization_id parameter
     */
    authorization_id: number;
};
declare type OauthAuthorizationsDeleteAuthorizationRequestOptions = {
    method: "DELETE";
    url: "/authorizations/:authorization_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type CodesOfConductGetAllCodesOfConductEndpoint = {} & RequiredPreview<"scarlet-witch">;
declare type CodesOfConductGetAllCodesOfConductRequestOptions = {
    method: "GET";
    url: "/codes_of_conduct";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type CodesOfConductGetAllCodesOfConductResponseDataItem = {
    key: string;
    name: string;
    url: string;
};
declare type CodesOfConductGetAllCodesOfConductResponseData = Array<CodesOfConductGetAllCodesOfConductResponseDataItem>;
declare type CodesOfConductGetConductCodeEndpoint = {
    /**
     * key parameter
     */
    key: string;
} & RequiredPreview<"scarlet-witch">;
declare type CodesOfConductGetConductCodeRequestOptions = {
    method: "GET";
    url: "/codes_of_conduct/:key";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type CodesOfConductGetConductCodeResponseData = {
    key: string;
    name: string;
    url: string;
    body: string;
};
declare type AppsCreateContentAttachmentEndpoint = {
    /**
     * content_reference_id parameter
     */
    content_reference_id: number;
    /**
     * The title of the content attachment displayed in the body or comment of an issue or pull request.
     */
    title: string;
    /**
     * The body text of the content attachment displayed in the body or comment of an issue or pull request. This parameter supports markdown.
     */
    body: string;
} & RequiredPreview<"corsair">;
declare type AppsCreateContentAttachmentRequestOptions = {
    method: "POST";
    url: "/content_references/:content_reference_id/attachments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsCreateContentAttachmentResponseData = {
    id: number;
    title: string;
    body: string;
};
declare type EmojisGetEndpoint = {};
declare type EmojisGetRequestOptions = {
    method: "GET";
    url: "/emojis";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListPublicEventsEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListPublicEventsRequestOptions = {
    method: "GET";
    url: "/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityGetFeedsEndpoint = {};
declare type ActivityGetFeedsRequestOptions = {
    method: "GET";
    url: "/feeds";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityGetFeedsResponseDataLinksSecurityAdvisories = {
    href: string;
    type: string;
};
declare type ActivityGetFeedsResponseDataLinksCurrentUserOrganizationsItem = {
    href: string;
    type: string;
};
declare type ActivityGetFeedsResponseDataLinksCurrentUserOrganization = {
    href: string;
    type: string;
};
declare type ActivityGetFeedsResponseDataLinksCurrentUserActor = {
    href: string;
    type: string;
};
declare type ActivityGetFeedsResponseDataLinksCurrentUser = {
    href: string;
    type: string;
};
declare type ActivityGetFeedsResponseDataLinksCurrentUserPublic = {
    href: string;
    type: string;
};
declare type ActivityGetFeedsResponseDataLinksUser = {
    href: string;
    type: string;
};
declare type ActivityGetFeedsResponseDataLinksTimeline = {
    href: string;
    type: string;
};
declare type ActivityGetFeedsResponseDataLinks = {
    timeline: ActivityGetFeedsResponseDataLinksTimeline;
    user: ActivityGetFeedsResponseDataLinksUser;
    current_user_public: ActivityGetFeedsResponseDataLinksCurrentUserPublic;
    current_user: ActivityGetFeedsResponseDataLinksCurrentUser;
    current_user_actor: ActivityGetFeedsResponseDataLinksCurrentUserActor;
    current_user_organization: ActivityGetFeedsResponseDataLinksCurrentUserOrganization;
    current_user_organizations: Array<ActivityGetFeedsResponseDataLinksCurrentUserOrganizationsItem>;
    security_advisories: ActivityGetFeedsResponseDataLinksSecurityAdvisories;
};
declare type ActivityGetFeedsResponseData = {
    timeline_url: string;
    user_url: string;
    current_user_public_url: string;
    current_user_url: string;
    current_user_actor_url: string;
    current_user_organization_url: string;
    current_user_organization_urls: Array<string>;
    security_advisories_url: string;
    _links: ActivityGetFeedsResponseDataLinks;
};
declare type GistsListEndpoint = {
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GistsListRequestOptions = {
    method: "GET";
    url: "/gists";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsListResponseDataItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsListResponseDataItemFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
};
declare type GistsListResponseDataItemFiles = {
    "hello_world.rb": GistsListResponseDataItemFilesHelloWorldRb;
};
declare type GistsListResponseDataItem = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsListResponseDataItemFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsListResponseDataItemOwner;
    truncated: boolean;
};
declare type GistsListResponseData = Array<GistsListResponseDataItem>;
declare type GistsCreateEndpoint = {
    /**
     * The filenames and content of each file in the gist. The keys in the `files` object represent the filename and have the type `string`.
     */
    files: GistsCreateParamsFiles;
    /**
     * A descriptive name for this gist.
     */
    description?: string;
    /**
     * When `true`, the gist will be public and available for anyone to see.
     */
    public?: boolean;
};
declare type GistsCreateRequestOptions = {
    method: "POST";
    url: "/gists";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsCreateResponseDataHistoryItemChangeStatus = {
    deletions: number;
    additions: number;
    total: number;
};
declare type GistsCreateResponseDataHistoryItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsCreateResponseDataHistoryItem = {
    url: string;
    version: string;
    user: GistsCreateResponseDataHistoryItemUser;
    change_status: GistsCreateResponseDataHistoryItemChangeStatus;
    committed_at: string;
};
declare type GistsCreateResponseDataForksItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsCreateResponseDataForksItem = {
    user: GistsCreateResponseDataForksItemUser;
    url: string;
    id: string;
    created_at: string;
    updated_at: string;
};
declare type GistsCreateResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsCreateResponseDataFilesHelloWorldPythonTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsCreateResponseDataFilesHelloWorldRubyTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsCreateResponseDataFilesHelloWorldPy = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsCreateResponseDataFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsCreateResponseDataFiles = {
    "hello_world.rb": GistsCreateResponseDataFilesHelloWorldRb;
    "hello_world.py": GistsCreateResponseDataFilesHelloWorldPy;
    "hello_world_ruby.txt": GistsCreateResponseDataFilesHelloWorldRubyTxt;
    "hello_world_python.txt": GistsCreateResponseDataFilesHelloWorldPythonTxt;
};
declare type GistsCreateResponseData = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsCreateResponseDataFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsCreateResponseDataOwner;
    truncated: boolean;
    forks: Array<GistsCreateResponseDataForksItem>;
    history: Array<GistsCreateResponseDataHistoryItem>;
};
declare type GistsListPublicEndpoint = {
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GistsListPublicRequestOptions = {
    method: "GET";
    url: "/gists/public";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsListPublicResponseDataItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsListPublicResponseDataItemFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
};
declare type GistsListPublicResponseDataItemFiles = {
    "hello_world.rb": GistsListPublicResponseDataItemFilesHelloWorldRb;
};
declare type GistsListPublicResponseDataItem = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsListPublicResponseDataItemFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsListPublicResponseDataItemOwner;
    truncated: boolean;
};
declare type GistsListPublicResponseData = Array<GistsListPublicResponseDataItem>;
declare type GistsListStarredEndpoint = {
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GistsListStarredRequestOptions = {
    method: "GET";
    url: "/gists/starred";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsListStarredResponseDataItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsListStarredResponseDataItemFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
};
declare type GistsListStarredResponseDataItemFiles = {
    "hello_world.rb": GistsListStarredResponseDataItemFilesHelloWorldRb;
};
declare type GistsListStarredResponseDataItem = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsListStarredResponseDataItemFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsListStarredResponseDataItemOwner;
    truncated: boolean;
};
declare type GistsListStarredResponseData = Array<GistsListStarredResponseDataItem>;
declare type GistsGetEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
};
declare type GistsGetRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsGetResponseDataHistoryItemChangeStatus = {
    deletions: number;
    additions: number;
    total: number;
};
declare type GistsGetResponseDataHistoryItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsGetResponseDataHistoryItem = {
    url: string;
    version: string;
    user: GistsGetResponseDataHistoryItemUser;
    change_status: GistsGetResponseDataHistoryItemChangeStatus;
    committed_at: string;
};
declare type GistsGetResponseDataForksItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsGetResponseDataForksItem = {
    user: GistsGetResponseDataForksItemUser;
    url: string;
    id: string;
    created_at: string;
    updated_at: string;
};
declare type GistsGetResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsGetResponseDataFilesHelloWorldPythonTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsGetResponseDataFilesHelloWorldRubyTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsGetResponseDataFilesHelloWorldPy = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsGetResponseDataFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsGetResponseDataFiles = {
    "hello_world.rb": GistsGetResponseDataFilesHelloWorldRb;
    "hello_world.py": GistsGetResponseDataFilesHelloWorldPy;
    "hello_world_ruby.txt": GistsGetResponseDataFilesHelloWorldRubyTxt;
    "hello_world_python.txt": GistsGetResponseDataFilesHelloWorldPythonTxt;
};
declare type GistsGetResponseData = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsGetResponseDataFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsGetResponseDataOwner;
    truncated: boolean;
    forks: Array<GistsGetResponseDataForksItem>;
    history: Array<GistsGetResponseDataHistoryItem>;
};
declare type GistsUpdateEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
    /**
     * A descriptive name for this gist.
     */
    description?: string;
    /**
     * The filenames and content that make up this gist.
     */
    files?: GistsUpdateParamsFiles;
};
declare type GistsUpdateRequestOptions = {
    method: "PATCH";
    url: "/gists/:gist_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsUpdateResponseDataHistoryItemChangeStatus = {
    deletions: number;
    additions: number;
    total: number;
};
declare type GistsUpdateResponseDataHistoryItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsUpdateResponseDataHistoryItem = {
    url: string;
    version: string;
    user: GistsUpdateResponseDataHistoryItemUser;
    change_status: GistsUpdateResponseDataHistoryItemChangeStatus;
    committed_at: string;
};
declare type GistsUpdateResponseDataForksItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsUpdateResponseDataForksItem = {
    user: GistsUpdateResponseDataForksItemUser;
    url: string;
    id: string;
    created_at: string;
    updated_at: string;
};
declare type GistsUpdateResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsUpdateResponseDataFilesNewFileTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsUpdateResponseDataFilesHelloWorldMd = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsUpdateResponseDataFilesHelloWorldPy = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsUpdateResponseDataFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsUpdateResponseDataFiles = {
    "hello_world.rb": GistsUpdateResponseDataFilesHelloWorldRb;
    "hello_world.py": GistsUpdateResponseDataFilesHelloWorldPy;
    "hello_world.md": GistsUpdateResponseDataFilesHelloWorldMd;
    "new_file.txt": GistsUpdateResponseDataFilesNewFileTxt;
};
declare type GistsUpdateResponseData = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsUpdateResponseDataFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsUpdateResponseDataOwner;
    truncated: boolean;
    forks: Array<GistsUpdateResponseDataForksItem>;
    history: Array<GistsUpdateResponseDataHistoryItem>;
};
declare type GistsDeleteEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
};
declare type GistsDeleteRequestOptions = {
    method: "DELETE";
    url: "/gists/:gist_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsListCommentsEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GistsListCommentsRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsListCommentsResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsListCommentsResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    body: string;
    user: GistsListCommentsResponseDataItemUser;
    created_at: string;
    updated_at: string;
};
declare type GistsListCommentsResponseData = Array<GistsListCommentsResponseDataItem>;
declare type GistsCreateCommentEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
    /**
     * The comment text.
     */
    body: string;
};
declare type GistsCreateCommentRequestOptions = {
    method: "POST";
    url: "/gists/:gist_id/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsCreateCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsCreateCommentResponseData = {
    id: number;
    node_id: string;
    url: string;
    body: string;
    user: GistsCreateCommentResponseDataUser;
    created_at: string;
    updated_at: string;
};
declare type GistsGetCommentEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
};
declare type GistsGetCommentRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsGetCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsGetCommentResponseData = {
    id: number;
    node_id: string;
    url: string;
    body: string;
    user: GistsGetCommentResponseDataUser;
    created_at: string;
    updated_at: string;
};
declare type GistsUpdateCommentEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * The comment text.
     */
    body: string;
};
declare type GistsUpdateCommentRequestOptions = {
    method: "PATCH";
    url: "/gists/:gist_id/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsUpdateCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsUpdateCommentResponseData = {
    id: number;
    node_id: string;
    url: string;
    body: string;
    user: GistsUpdateCommentResponseDataUser;
    created_at: string;
    updated_at: string;
};
declare type GistsDeleteCommentEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
};
declare type GistsDeleteCommentRequestOptions = {
    method: "DELETE";
    url: "/gists/:gist_id/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsListCommitsEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GistsListCommitsRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id/commits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsListCommitsResponseDataItemChangeStatus = {
    deletions: number;
    additions: number;
    total: number;
};
declare type GistsListCommitsResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsListCommitsResponseDataItem = {
    url: string;
    version: string;
    user: GistsListCommitsResponseDataItemUser;
    change_status: GistsListCommitsResponseDataItemChangeStatus;
    committed_at: string;
};
declare type GistsListCommitsResponseData = Array<GistsListCommitsResponseDataItem>;
declare type GistsForkEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
};
declare type GistsForkRequestOptions = {
    method: "POST";
    url: "/gists/:gist_id/forks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsForkResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsForkResponseDataFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
};
declare type GistsForkResponseDataFiles = {
    "hello_world.rb": GistsForkResponseDataFilesHelloWorldRb;
};
declare type GistsForkResponseData = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsForkResponseDataFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsForkResponseDataOwner;
    truncated: boolean;
};
declare type GistsListForksEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GistsListForksRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id/forks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsListForksResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsListForksResponseDataItem = {
    user: GistsListForksResponseDataItemUser;
    url: string;
    id: string;
    created_at: string;
    updated_at: string;
};
declare type GistsListForksResponseData = Array<GistsListForksResponseDataItem>;
declare type GistsStarEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
};
declare type GistsStarRequestOptions = {
    method: "PUT";
    url: "/gists/:gist_id/star";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsUnstarEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
};
declare type GistsUnstarRequestOptions = {
    method: "DELETE";
    url: "/gists/:gist_id/star";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsCheckIsStarredEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
};
declare type GistsCheckIsStarredRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id/star";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsGetRevisionEndpoint = {
    /**
     * gist_id parameter
     */
    gist_id: string;
    /**
     * sha parameter
     */
    sha: string;
};
declare type GistsGetRevisionRequestOptions = {
    method: "GET";
    url: "/gists/:gist_id/:sha";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GistsGetRevisionResponseDataHistoryItemChangeStatus = {
    deletions: number;
    additions: number;
    total: number;
};
declare type GistsGetRevisionResponseDataHistoryItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsGetRevisionResponseDataHistoryItem = {
    url: string;
    version: string;
    user: GistsGetRevisionResponseDataHistoryItemUser;
    change_status: GistsGetRevisionResponseDataHistoryItemChangeStatus;
    committed_at: string;
};
declare type GistsGetRevisionResponseDataForksItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsGetRevisionResponseDataForksItem = {
    user: GistsGetRevisionResponseDataForksItemUser;
    url: string;
    id: string;
    created_at: string;
    updated_at: string;
};
declare type GistsGetRevisionResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type GistsGetRevisionResponseDataFilesHelloWorldPythonTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsGetRevisionResponseDataFilesHelloWorldRubyTxt = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsGetRevisionResponseDataFilesHelloWorldPy = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsGetRevisionResponseDataFilesHelloWorldRb = {
    filename: string;
    type: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    content: string;
};
declare type GistsGetRevisionResponseDataFiles = {
    "hello_world.rb": GistsGetRevisionResponseDataFilesHelloWorldRb;
    "hello_world.py": GistsGetRevisionResponseDataFilesHelloWorldPy;
    "hello_world_ruby.txt": GistsGetRevisionResponseDataFilesHelloWorldRubyTxt;
    "hello_world_python.txt": GistsGetRevisionResponseDataFilesHelloWorldPythonTxt;
};
declare type GistsGetRevisionResponseData = {
    url: string;
    forks_url: string;
    commits_url: string;
    id: string;
    node_id: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    files: GistsGetRevisionResponseDataFiles;
    public: boolean;
    created_at: string;
    updated_at: string;
    description: string;
    comments: number;
    user: null;
    comments_url: string;
    owner: GistsGetRevisionResponseDataOwner;
    truncated: boolean;
    forks: Array<GistsGetRevisionResponseDataForksItem>;
    history: Array<GistsGetRevisionResponseDataHistoryItem>;
};
declare type GitignoreListTemplatesEndpoint = {};
declare type GitignoreListTemplatesRequestOptions = {
    method: "GET";
    url: "/gitignore/templates";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitignoreListTemplatesResponseData = Array<string>;
declare type GitignoreGetTemplateEndpoint = {
    /**
     * name parameter
     */
    name: string;
};
declare type GitignoreGetTemplateRequestOptions = {
    method: "GET";
    url: "/gitignore/templates/:name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitignoreGetTemplateResponseData = {
    name: string;
    source: string;
};
declare type AppsListReposEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"machine-man">;
declare type AppsListReposRequestOptions = {
    method: "GET";
    url: "/installation/repositories";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsListReposResponseDataRepositoriesItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type AppsListReposResponseDataRepositoriesItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: AppsListReposResponseDataRepositoriesItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type AppsListReposResponseData = {
    total_count: number;
    repositories: Array<AppsListReposResponseDataRepositoriesItem>;
};
declare type AppsRevokeInstallationTokenEndpoint = {};
declare type AppsRevokeInstallationTokenRequestOptions = {
    method: "DELETE";
    url: "/installation/token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListEndpoint = {
    /**
     * Indicates which sorts of issues to return. Can be one of:
     * \* `assigned`: Issues assigned to you
     * \* `created`: Issues created by you
     * \* `mentioned`: Issues mentioning you
     * \* `subscribed`: Issues you're subscribed to updates for
     * \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListRequestOptions = {
    method: "GET";
    url: "/issues";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListResponseDataItemRepositoryPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type IssuesListResponseDataItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListResponseDataItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: IssuesListResponseDataItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: IssuesListResponseDataItemRepositoryPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type IssuesListResponseDataItemPullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
};
declare type IssuesListResponseDataItemMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListResponseDataItemMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesListResponseDataItemMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesListResponseDataItemAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListResponseDataItemAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListResponseDataItemLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesListResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesListResponseDataItemUser;
    labels: Array<IssuesListResponseDataItemLabelsItem>;
    assignee: IssuesListResponseDataItemAssignee;
    assignees: Array<IssuesListResponseDataItemAssigneesItem>;
    milestone: IssuesListResponseDataItemMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesListResponseDataItemPullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
    repository: IssuesListResponseDataItemRepository;
};
declare type IssuesListResponseData = Array<IssuesListResponseDataItem>;
declare type SearchIssuesLegacyEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repository parameter
     */
    repository: string;
    /**
     * Indicates the state of the issues to return. Can be either `open` or `closed`.
     */
    state: "open" | "closed";
    /**
     * The search term.
     */
    keyword: string;
};
declare type SearchIssuesLegacyRequestOptions = {
    method: "GET";
    url: "/legacy/issues/search/:owner/:repository/:state/:keyword";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type SearchIssuesLegacyResponseDataIssuesItem = {
    gravatar_id: string;
    position: number;
    number: number;
    votes: number;
    created_at: string;
    comments: number;
    body: string;
    title: string;
    updated_at: string;
    html_url: string;
    user: string;
    labels: Array<string>;
    state: string;
};
declare type SearchIssuesLegacyResponseData = {
    issues: Array<SearchIssuesLegacyResponseDataIssuesItem>;
};
declare type SearchReposLegacyEndpoint = {
    /**
     * The search term.
     */
    keyword: string;
    /**
     * Filter results by language.
     */
    language?: string;
    /**
     * The page number to fetch.
     */
    start_page?: string;
    /**
     * The sort field. One of `stars`, `forks`, or `updated`. Default: results are sorted by best match.
     */
    sort?: "stars" | "forks" | "updated";
    /**
     * The sort field. if `sort` param is provided. Can be either `asc` or `desc`.
     */
    order?: "asc" | "desc";
};
declare type SearchReposLegacyRequestOptions = {
    method: "GET";
    url: "/legacy/repos/search/:keyword";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type SearchReposLegacyResponseDataRepositoriesItem = {
    type: string;
    created: string;
    watchers: number;
    has_downloads: boolean;
    username: string;
    homepage: string;
    url: string;
    fork: boolean;
    has_issues: boolean;
    has_wiki: boolean;
    forks: number;
    size: number;
    private: boolean;
    followers: number;
    name: string;
    owner: string;
    open_issues: number;
    pushed_at: string;
    score: number;
    pushed: string;
    description: string;
    language: string;
    created_at: string;
};
declare type SearchReposLegacyResponseData = {
    repositories: Array<SearchReposLegacyResponseDataRepositoriesItem>;
};
declare type SearchEmailLegacyEndpoint = {
    /**
     * The email address.
     */
    email: string;
};
declare type SearchEmailLegacyRequestOptions = {
    method: "GET";
    url: "/legacy/user/email/:email";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type SearchEmailLegacyResponseDataUser = {
    public_repo_count: number;
    public_gist_count: number;
    followers_count: number;
    following_count: number;
    created: string;
    created_at: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    id: number;
    login: string;
    type: string;
    gravatar_id: string;
};
declare type SearchEmailLegacyResponseData = {
    user: SearchEmailLegacyResponseDataUser;
};
declare type SearchUsersLegacyEndpoint = {
    /**
     * The search term.
     */
    keyword: string;
    /**
     * The page number to fetch.
     */
    start_page?: string;
    /**
     * The sort field. One of `stars`, `forks`, or `updated`. Default: results are sorted by best match.
     */
    sort?: "stars" | "forks" | "updated";
    /**
     * The sort field. if `sort` param is provided. Can be either `asc` or `desc`.
     */
    order?: "asc" | "desc";
};
declare type SearchUsersLegacyRequestOptions = {
    method: "GET";
    url: "/legacy/user/search/:keyword";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type SearchUsersLegacyResponseDataUsersItem = {
    gravatar_id: string;
    name: string;
    created_at: string;
    location: string;
    public_repo_count: number;
    followers: number;
    language: string;
    fullname: string;
    username: string;
    id: string;
    repos: number;
    type: string;
    followers_count: number;
    login: string;
    score: number;
    created: string;
};
declare type SearchUsersLegacyResponseData = {
    users: Array<SearchUsersLegacyResponseDataUsersItem>;
};
declare type LicensesListCommonlyUsedEndpoint = {};
declare type LicensesListCommonlyUsedRequestOptions = {
    method: "GET";
    url: "/licenses";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type LicensesListCommonlyUsedResponseDataItem = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id?: string;
};
declare type LicensesListCommonlyUsedResponseData = Array<LicensesListCommonlyUsedResponseDataItem>;
declare type LicensesGetEndpoint = {
    /**
     * license parameter
     */
    license: string;
};
declare type LicensesGetRequestOptions = {
    method: "GET";
    url: "/licenses/:license";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type LicensesGetResponseData = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
    html_url: string;
    description: string;
    implementation: string;
    permissions: Array<string>;
    conditions: Array<string>;
    limitations: Array<string>;
    body: string;
    featured: boolean;
};
declare type MarkdownRenderEndpoint = {
    /**
     * The Markdown text to render in HTML. Markdown content must be 400 KB or less.
     */
    text: string;
    /**
     * The rendering mode. Can be either:
     * \* `markdown` to render a document in plain Markdown, just like README.md files are rendered.
     * \* `gfm` to render a document in [GitHub Flavored Markdown](https://github.github.com/gfm/), which creates links for user mentions as well as references to SHA-1 hashes, issues, and pull requests.
     */
    mode?: "markdown" | "gfm";
    /**
     * The repository context to use when creating references in `gfm` mode. Omit this parameter when using `markdown` mode.
     */
    context?: string;
};
declare type MarkdownRenderRequestOptions = {
    method: "POST";
    url: "/markdown";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MarkdownRenderRawEndpoint = {
    /**
     * data parameter
     */
    data: string;
} & {
    headers: {
        "content-type": "text/plain; charset=utf-8";
    };
};
declare type MarkdownRenderRawRequestOptions = {
    method: "POST";
    url: "/markdown/raw";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsGetSubscriptionPlanForAccountEndpoint = {
    /**
     * account_id parameter
     */
    account_id: number;
};
declare type AppsGetSubscriptionPlanForAccountRequestOptions = {
    method: "GET";
    url: "/marketplace_listing/accounts/:account_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsGetSubscriptionPlanForAccountResponseDataMarketplacePurchasePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
};
declare type AppsGetSubscriptionPlanForAccountResponseDataMarketplacePurchase = {
    billing_cycle: string;
    next_billing_date: string;
    unit_count: null;
    on_free_trial: boolean;
    free_trial_ends_on: string;
    updated_at: string;
    plan: AppsGetSubscriptionPlanForAccountResponseDataMarketplacePurchasePlan;
};
declare type AppsGetSubscriptionPlanForAccountResponseDataMarketplacePendingChangePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    state: string;
    unit_name: null;
    bullets: Array<string>;
};
declare type AppsGetSubscriptionPlanForAccountResponseDataMarketplacePendingChange = {
    effective_date: string;
    unit_count: null;
    id: number;
    plan: AppsGetSubscriptionPlanForAccountResponseDataMarketplacePendingChangePlan;
};
declare type AppsGetSubscriptionPlanForAccountResponseData = {
    url: string;
    type: string;
    id: number;
    login: string;
    email: null;
    organization_billing_email: string;
    marketplace_pending_change: AppsGetSubscriptionPlanForAccountResponseDataMarketplacePendingChange;
    marketplace_purchase: AppsGetSubscriptionPlanForAccountResponseDataMarketplacePurchase;
};
declare type AppsListPlansEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListPlansRequestOptions = {
    method: "GET";
    url: "/marketplace_listing/plans";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsListPlansResponseDataItem = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
};
declare type AppsListPlansResponseData = Array<AppsListPlansResponseDataItem>;
declare type AppsListAccountsForPlanEndpoint = {
    /**
     * plan_id parameter
     */
    plan_id: number;
    /**
     * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
     */
    sort?: "created" | "updated";
    /**
     * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListAccountsForPlanRequestOptions = {
    method: "GET";
    url: "/marketplace_listing/plans/:plan_id/accounts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsListAccountsForPlanResponseDataItemMarketplacePurchasePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
};
declare type AppsListAccountsForPlanResponseDataItemMarketplacePurchase = {
    billing_cycle: string;
    next_billing_date: string;
    unit_count: null;
    on_free_trial: boolean;
    free_trial_ends_on: string;
    updated_at: string;
    plan: AppsListAccountsForPlanResponseDataItemMarketplacePurchasePlan;
};
declare type AppsListAccountsForPlanResponseDataItemMarketplacePendingChangePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    state: string;
    unit_name: null;
    bullets: Array<string>;
};
declare type AppsListAccountsForPlanResponseDataItemMarketplacePendingChange = {
    effective_date: string;
    unit_count: null;
    id: number;
    plan: AppsListAccountsForPlanResponseDataItemMarketplacePendingChangePlan;
};
declare type AppsListAccountsForPlanResponseDataItem = {
    url: string;
    type: string;
    id: number;
    login: string;
    email: null;
    organization_billing_email: string;
    marketplace_pending_change: AppsListAccountsForPlanResponseDataItemMarketplacePendingChange;
    marketplace_purchase: AppsListAccountsForPlanResponseDataItemMarketplacePurchase;
};
declare type AppsListAccountsForPlanResponseData = Array<AppsListAccountsForPlanResponseDataItem>;
declare type AppsGetSubscriptionPlanForAccountStubbedEndpoint = {
    /**
     * account_id parameter
     */
    account_id: number;
};
declare type AppsGetSubscriptionPlanForAccountStubbedRequestOptions = {
    method: "GET";
    url: "/marketplace_listing/stubbed/accounts/:account_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePurchasePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
};
declare type AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePurchase = {
    billing_cycle: string;
    next_billing_date: string;
    unit_count: null;
    on_free_trial: boolean;
    free_trial_ends_on: string;
    updated_at: string;
    plan: AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePurchasePlan;
};
declare type AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePendingChangePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    state: string;
    unit_name: null;
    bullets: Array<string>;
};
declare type AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePendingChange = {
    effective_date: string;
    unit_count: null;
    id: number;
    plan: AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePendingChangePlan;
};
declare type AppsGetSubscriptionPlanForAccountStubbedResponseData = {
    url: string;
    type: string;
    id: number;
    login: string;
    email: null;
    organization_billing_email: string;
    marketplace_pending_change: AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePendingChange;
    marketplace_purchase: AppsGetSubscriptionPlanForAccountStubbedResponseDataMarketplacePurchase;
};
declare type AppsListPlansStubbedEndpoint = {
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListPlansStubbedRequestOptions = {
    method: "GET";
    url: "/marketplace_listing/stubbed/plans";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsListPlansStubbedResponseDataItem = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
};
declare type AppsListPlansStubbedResponseData = Array<AppsListPlansStubbedResponseDataItem>;
declare type AppsListAccountsForPlanStubbedEndpoint = {
    /**
     * plan_id parameter
     */
    plan_id: number;
    /**
     * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
     */
    sort?: "created" | "updated";
    /**
     * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type AppsListAccountsForPlanStubbedRequestOptions = {
    method: "GET";
    url: "/marketplace_listing/stubbed/plans/:plan_id/accounts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsListAccountsForPlanStubbedResponseDataItemMarketplacePurchasePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: null;
    state: string;
    bullets: Array<string>;
};
declare type AppsListAccountsForPlanStubbedResponseDataItemMarketplacePurchase = {
    billing_cycle: string;
    next_billing_date: string;
    unit_count: null;
    on_free_trial: boolean;
    free_trial_ends_on: string;
    updated_at: string;
    plan: AppsListAccountsForPlanStubbedResponseDataItemMarketplacePurchasePlan;
};
declare type AppsListAccountsForPlanStubbedResponseDataItemMarketplacePendingChangePlan = {
    url: string;
    accounts_url: string;
    id: number;
    number: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    state: string;
    unit_name: null;
    bullets: Array<string>;
};
declare type AppsListAccountsForPlanStubbedResponseDataItemMarketplacePendingChange = {
    effective_date: string;
    unit_count: null;
    id: number;
    plan: AppsListAccountsForPlanStubbedResponseDataItemMarketplacePendingChangePlan;
};
declare type AppsListAccountsForPlanStubbedResponseDataItem = {
    url: string;
    type: string;
    id: number;
    login: string;
    email: null;
    organization_billing_email: string;
    marketplace_pending_change: AppsListAccountsForPlanStubbedResponseDataItemMarketplacePendingChange;
    marketplace_purchase: AppsListAccountsForPlanStubbedResponseDataItemMarketplacePurchase;
};
declare type AppsListAccountsForPlanStubbedResponseData = Array<AppsListAccountsForPlanStubbedResponseDataItem>;
declare type MetaGetEndpoint = {};
declare type MetaGetRequestOptions = {
    method: "GET";
    url: "/meta";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MetaGetResponseDataSshKeyFingerprints = {
    MD5_RSA: string;
    MD5_DSA: string;
    SHA256_RSA: string;
    SHA256_DSA: string;
};
declare type MetaGetResponseData = {
    verifiable_password_authentication: boolean;
    ssh_key_fingerprints: MetaGetResponseDataSshKeyFingerprints;
    hooks: Array<string>;
    web: Array<string>;
    api: Array<string>;
    git: Array<string>;
    pages: Array<string>;
    importer: Array<string>;
};
declare type ActivityListPublicEventsForRepoNetworkEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListPublicEventsForRepoNetworkRequestOptions = {
    method: "GET";
    url: "/networks/:owner/:repo/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListNotificationsForAuthenticatedUserEndpoint = {
    /**
     * If `true`, show notifications marked as read.
     */
    all?: boolean;
    /**
     * If `true`, only shows notifications in which the user is directly participating or mentioned.
     */
    participating?: boolean;
    /**
     * Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    before?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListNotificationsForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/notifications";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListNotificationsForAuthenticatedUserResponseDataItemSubject = {
    title: string;
    url: string;
    latest_comment_url: string;
    type: string;
};
declare type ActivityListNotificationsForAuthenticatedUserResponseDataItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ActivityListNotificationsForAuthenticatedUserResponseDataItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ActivityListNotificationsForAuthenticatedUserResponseDataItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
};
declare type ActivityListNotificationsForAuthenticatedUserResponseDataItem = {
    id: string;
    repository: ActivityListNotificationsForAuthenticatedUserResponseDataItemRepository;
    subject: ActivityListNotificationsForAuthenticatedUserResponseDataItemSubject;
    reason: string;
    unread: boolean;
    updated_at: string;
    last_read_at: string;
    url: string;
};
declare type ActivityListNotificationsForAuthenticatedUserResponseData = Array<ActivityListNotificationsForAuthenticatedUserResponseDataItem>;
declare type ActivityMarkNotificationsAsReadEndpoint = {
    /**
     * Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
     */
    last_read_at?: string;
};
declare type ActivityMarkNotificationsAsReadRequestOptions = {
    method: "PUT";
    url: "/notifications";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityGetThreadEndpoint = {
    /**
     * thread_id parameter
     */
    thread_id: number;
};
declare type ActivityGetThreadRequestOptions = {
    method: "GET";
    url: "/notifications/threads/:thread_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityGetThreadResponseDataSubject = {
    title: string;
    url: string;
    latest_comment_url: string;
    type: string;
};
declare type ActivityGetThreadResponseDataRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ActivityGetThreadResponseDataRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ActivityGetThreadResponseDataRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
};
declare type ActivityGetThreadResponseData = {
    id: string;
    repository: ActivityGetThreadResponseDataRepository;
    subject: ActivityGetThreadResponseDataSubject;
    reason: string;
    unread: boolean;
    updated_at: string;
    last_read_at: string;
    url: string;
};
declare type ActivityMarkThreadAsReadEndpoint = {
    /**
     * thread_id parameter
     */
    thread_id: number;
};
declare type ActivityMarkThreadAsReadRequestOptions = {
    method: "PATCH";
    url: "/notifications/threads/:thread_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityGetThreadSubscriptionForAuthenticatedUserEndpoint = {
    /**
     * thread_id parameter
     */
    thread_id: number;
};
declare type ActivityGetThreadSubscriptionForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/notifications/threads/:thread_id/subscription";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityGetThreadSubscriptionForAuthenticatedUserResponseData = {
    subscribed: boolean;
    ignored: boolean;
    reason: null;
    created_at: string;
    url: string;
    thread_url: string;
};
declare type ActivitySetThreadSubscriptionEndpoint = {
    /**
     * thread_id parameter
     */
    thread_id: number;
    /**
     * Unsubscribes and subscribes you to a conversation. Set `ignored` to `true` to block all notifications from this thread.
     */
    ignored?: boolean;
};
declare type ActivitySetThreadSubscriptionRequestOptions = {
    method: "PUT";
    url: "/notifications/threads/:thread_id/subscription";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivitySetThreadSubscriptionResponseData = {
    subscribed: boolean;
    ignored: boolean;
    reason: null;
    created_at: string;
    url: string;
    thread_url: string;
};
declare type ActivityDeleteThreadSubscriptionEndpoint = {
    /**
     * thread_id parameter
     */
    thread_id: number;
};
declare type ActivityDeleteThreadSubscriptionRequestOptions = {
    method: "DELETE";
    url: "/notifications/threads/:thread_id/subscription";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListEndpoint = {
    /**
     * The integer ID of the last organization that you've seen.
     */
    since?: number;
};
declare type OrgsListRequestOptions = {
    method: "GET";
    url: "/organizations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type OrgsListResponseData = Array<OrgsListResponseDataItem>;
declare type OrgsGetEndpoint = {
    /**
     * org parameter
     */
    org: string;
};
declare type OrgsGetRequestOptions = {
    method: "GET";
    url: "/orgs/:org";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsGetResponseDataPlan = {
    name: string;
    space: number;
    private_repos: number;
    filled_seats?: number;
    seats?: number;
};
declare type OrgsGetResponseData = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    is_verified: boolean;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    html_url: string;
    created_at: string;
    type: string;
    total_private_repos?: number;
    owned_private_repos?: number;
    private_gists?: number;
    disk_usage?: number;
    collaborators?: number;
    billing_email?: string;
    plan: OrgsGetResponseDataPlan;
    default_repository_permission?: string;
    members_can_create_repositories?: boolean;
    two_factor_requirement_enabled?: boolean;
    members_allowed_repository_creation_type?: string;
    members_can_create_public_repositories?: boolean;
    members_can_create_private_repositories?: boolean;
    members_can_create_internal_repositories?: boolean;
};
declare type OrgsUpdateEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Billing email address. This address is not publicized.
     */
    billing_email?: string;
    /**
     * The company name.
     */
    company?: string;
    /**
     * The publicly visible email address.
     */
    email?: string;
    /**
     * The location.
     */
    location?: string;
    /**
     * The shorthand name of the company.
     */
    name?: string;
    /**
     * The description of the company.
     */
    description?: string;
    /**
     * Toggles whether an organization can use organization projects.
     */
    has_organization_projects?: boolean;
    /**
     * Toggles whether repositories that belong to the organization can use repository projects.
     */
    has_repository_projects?: boolean;
    /**
     * Default permission level members have for organization repositories:
     * \* `read` - can pull, but not push to or administer this repository.
     * \* `write` - can pull and push, but not administer this repository.
     * \* `admin` - can pull, push, and administer this repository.
     * \* `none` - no permissions granted by default.
     */
    default_repository_permission?: "read" | "write" | "admin" | "none";
    /**
     * Toggles the ability of non-admin organization members to create repositories. Can be one of:
     * \* `true` - all organization members can create repositories.
     * \* `false` - only organization owners can create repositories.
     * Default: `true`
     * **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.
     */
    members_can_create_repositories?: boolean;
    /**
     * Toggles whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. Can be one of:
     * \* `true` - all organization members can create internal repositories.
     * \* `false` - only organization owners can create internal repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_internal_repositories?: boolean;
    /**
     * Toggles whether organization members can create private repositories, which are visible to organization members with permission. Can be one of:
     * \* `true` - all organization members can create private repositories.
     * \* `false` - only organization owners can create private repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_private_repositories?: boolean;
    /**
     * Toggles whether organization members can create public repositories, which are visible to anyone. Can be one of:
     * \* `true` - all organization members can create public repositories.
     * \* `false` - only organization owners can create public repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_public_repositories?: boolean;
    /**
     * Specifies which types of repositories non-admin organization members can create. Can be one of:
     * \* `all` - all organization members can create public and private repositories.
     * \* `private` - members can create private repositories. This option is only available to repositories that are part of an organization on GitHub Enterprise Cloud.
     * \* `none` - only admin members can create repositories.
     * **Note:** This parameter is deprecated and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See [this note](https://developer.github.com/v3/orgs/#members_can_create_repositories) for details.
     */
    members_allowed_repository_creation_type?: "all" | "private" | "none";
};
declare type OrgsUpdateRequestOptions = {
    method: "PATCH";
    url: "/orgs/:org";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsUpdateResponseDataPlan = {
    name: string;
    space: number;
    private_repos: number;
};
declare type OrgsUpdateResponseData = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    is_verified: boolean;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    html_url: string;
    created_at: string;
    type: string;
    total_private_repos: number;
    owned_private_repos: number;
    private_gists: number;
    disk_usage: number;
    collaborators: number;
    billing_email: string;
    plan: OrgsUpdateResponseDataPlan;
    default_repository_permission: string;
    members_can_create_repositories: boolean;
    two_factor_requirement_enabled: boolean;
    members_allowed_repository_creation_type: string;
    members_can_create_public_repositories: boolean;
    members_can_create_private_repositories: boolean;
    members_can_create_internal_repositories: boolean;
};
declare type ActionsListSelfHostedRunnersForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListSelfHostedRunnersForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/runners";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListSelfHostedRunnersForOrgResponseDataRunnersItem = {
    id: number;
    name: string;
    os: string;
    status: string;
};
declare type ActionsListSelfHostedRunnersForOrgResponseData = {
    total_count: number;
    runners: Array<ActionsListSelfHostedRunnersForOrgResponseDataRunnersItem>;
};
declare type ActionsListRunnerApplicationsForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
};
declare type ActionsListRunnerApplicationsForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/runners/downloads";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListRunnerApplicationsForOrgResponseDataItem = {
    os: string;
    architecture: string;
    download_url: string;
    filename: string;
};
declare type ActionsListRunnerApplicationsForOrgResponseData = Array<ActionsListRunnerApplicationsForOrgResponseDataItem>;
declare type ActionsCreateRegistrationTokenForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
};
declare type ActionsCreateRegistrationTokenForOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/actions/runners/registration-token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsCreateRegistrationTokenForOrgResponseData = {
    token: string;
    expires_at: string;
};
declare type ActionsCreateRemoveTokenForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
};
declare type ActionsCreateRemoveTokenForOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/actions/runners/remove-token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsCreateRemoveTokenForOrgResponseData = {
    token: string;
    expires_at: string;
};
declare type ActionsGetSelfHostedRunnerForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * runner_id parameter
     */
    runner_id: number;
};
declare type ActionsGetSelfHostedRunnerForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/actions/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsGetSelfHostedRunnerForOrgResponseData = {
    id: number;
    name: string;
    os: string;
    status: string;
};
declare type ActionsDeleteSelfHostedRunnerFromOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * runner_id parameter
     */
    runner_id: number;
};
declare type ActionsDeleteSelfHostedRunnerFromOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/actions/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListBlockedUsersEndpoint = {
    /**
     * org parameter
     */
    org: string;
};
declare type OrgsListBlockedUsersRequestOptions = {
    method: "GET";
    url: "/orgs/:org/blocks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListBlockedUsersResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type OrgsListBlockedUsersResponseData = Array<OrgsListBlockedUsersResponseDataItem>;
declare type OrgsCheckBlockedUserEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * username parameter
     */
    username: string;
};
declare type OrgsCheckBlockedUserRequestOptions = {
    method: "GET";
    url: "/orgs/:org/blocks/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsBlockUserEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * username parameter
     */
    username: string;
};
declare type OrgsBlockUserRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/blocks/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsUnblockUserEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * username parameter
     */
    username: string;
};
declare type OrgsUnblockUserRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/blocks/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListCredentialAuthorizationsEndpoint = {
    /**
     * org parameter
     */
    org: string;
};
declare type OrgsListCredentialAuthorizationsRequestOptions = {
    method: "GET";
    url: "/orgs/:org/credential-authorizations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListCredentialAuthorizationsResponseDataItem = {
    login: string;
    credential_id: string;
    credential_type: string;
    token_last_eight: string;
    credential_authorized_at: string;
    scopes: Array<string>;
};
declare type OrgsListCredentialAuthorizationsResponseData = Array<OrgsListCredentialAuthorizationsResponseDataItem>;
declare type OrgsRemoveCredentialAuthorizationEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * credential_id parameter
     */
    credential_id: number;
};
declare type OrgsRemoveCredentialAuthorizationRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/credential-authorizations/:credential_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListPublicOrgEventsEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListPublicOrgEventsRequestOptions = {
    method: "GET";
    url: "/orgs/:org/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListHooksEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListHooksRequestOptions = {
    method: "GET";
    url: "/orgs/:org/hooks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListHooksResponseDataItemConfig = {
    url: string;
    content_type: string;
};
declare type OrgsListHooksResponseDataItem = {
    id: number;
    url: string;
    ping_url: string;
    name: string;
    events: Array<string>;
    active: boolean;
    config: OrgsListHooksResponseDataItemConfig;
    updated_at: string;
    created_at: string;
};
declare type OrgsListHooksResponseData = Array<OrgsListHooksResponseDataItem>;
declare type OrgsCreateHookEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Must be passed as "web".
     */
    name: string;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/orgs/hooks/#create-hook-config-params).
     */
    config: OrgsCreateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
     */
    events?: string[];
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
};
declare type OrgsCreateHookRequestOptions = {
    method: "POST";
    url: "/orgs/:org/hooks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsCreateHookResponseDataConfig = {
    url: string;
    content_type: string;
};
declare type OrgsCreateHookResponseData = {
    id: number;
    url: string;
    ping_url: string;
    name: string;
    events: Array<string>;
    active: boolean;
    config: OrgsCreateHookResponseDataConfig;
    updated_at: string;
    created_at: string;
};
declare type OrgsGetHookEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * hook_id parameter
     */
    hook_id: number;
};
declare type OrgsGetHookRequestOptions = {
    method: "GET";
    url: "/orgs/:org/hooks/:hook_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsGetHookResponseDataConfig = {
    url: string;
    content_type: string;
};
declare type OrgsGetHookResponseData = {
    id: number;
    url: string;
    ping_url: string;
    name: string;
    events: Array<string>;
    active: boolean;
    config: OrgsGetHookResponseDataConfig;
    updated_at: string;
    created_at: string;
};
declare type OrgsUpdateHookEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * hook_id parameter
     */
    hook_id: number;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/orgs/hooks/#update-hook-config-params).
     */
    config?: OrgsUpdateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
     */
    events?: string[];
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
};
declare type OrgsUpdateHookRequestOptions = {
    method: "PATCH";
    url: "/orgs/:org/hooks/:hook_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsUpdateHookResponseDataConfig = {
    url: string;
    content_type: string;
};
declare type OrgsUpdateHookResponseData = {
    id: number;
    url: string;
    ping_url: string;
    name: string;
    events: Array<string>;
    active: boolean;
    config: OrgsUpdateHookResponseDataConfig;
    updated_at: string;
    created_at: string;
};
declare type OrgsDeleteHookEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * hook_id parameter
     */
    hook_id: number;
};
declare type OrgsDeleteHookRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/hooks/:hook_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsPingHookEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * hook_id parameter
     */
    hook_id: number;
};
declare type OrgsPingHookRequestOptions = {
    method: "POST";
    url: "/orgs/:org/hooks/:hook_id/pings";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsGetOrgInstallationEndpoint = {
    /**
     * org parameter
     */
    org: string;
} & RequiredPreview<"machine-man">;
declare type AppsGetOrgInstallationRequestOptions = {
    method: "GET";
    url: "/orgs/:org/installation";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsGetOrgInstallationResponseDataPermissions = {
    checks: string;
    metadata: string;
    contents: string;
};
declare type AppsGetOrgInstallationResponseDataAccount = {
    login: string;
    id: number;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type AppsGetOrgInstallationResponseData = {
    id: number;
    account: AppsGetOrgInstallationResponseDataAccount;
    repository_selection: string;
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: AppsGetOrgInstallationResponseDataPermissions;
    events: Array<string>;
    created_at: string;
    updated_at: string;
    single_file_name: null;
};
declare type OrgsListInstallationsEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"machine-man">;
declare type OrgsListInstallationsRequestOptions = {
    method: "GET";
    url: "/orgs/:org/installations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListInstallationsResponseDataInstallationsItemPermissions = {
    deployments: string;
    metadata: string;
    pull_requests: string;
    statuses: string;
};
declare type OrgsListInstallationsResponseDataInstallationsItemAccount = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type OrgsListInstallationsResponseDataInstallationsItem = {
    id: number;
    account: OrgsListInstallationsResponseDataInstallationsItemAccount;
    repository_selection: string;
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: OrgsListInstallationsResponseDataInstallationsItemPermissions;
    events: Array<string>;
    created_at: string;
    updated_at: string;
    single_file_name: null;
};
declare type OrgsListInstallationsResponseData = {
    total_count: number;
    installations: Array<OrgsListInstallationsResponseDataInstallationsItem>;
};
declare type InteractionsGetRestrictionsForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
} & RequiredPreview<"sombra">;
declare type InteractionsGetRestrictionsForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/interaction-limits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type InteractionsGetRestrictionsForOrgResponseData = {
    limit: string;
    origin: string;
    expires_at: string;
};
declare type InteractionsAddOrUpdateRestrictionsForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Specifies the group of GitHub users who can comment, open issues, or create pull requests in public repositories for the given organization. Must be one of: `existing_users`, `contributors_only`, or `collaborators_only`.
     */
    limit: "existing_users" | "contributors_only" | "collaborators_only";
} & RequiredPreview<"sombra">;
declare type InteractionsAddOrUpdateRestrictionsForOrgRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/interaction-limits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type InteractionsAddOrUpdateRestrictionsForOrgResponseData = {
    limit: string;
    origin: string;
    expires_at: string;
};
declare type InteractionsRemoveRestrictionsForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
} & RequiredPreview<"sombra">;
declare type InteractionsRemoveRestrictionsForOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/interaction-limits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListPendingInvitationsEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListPendingInvitationsRequestOptions = {
    method: "GET";
    url: "/orgs/:org/invitations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListPendingInvitationsResponseDataItemInviter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type OrgsListPendingInvitationsResponseDataItem = {
    id: number;
    login: string;
    email: string;
    role: string;
    created_at: string;
    inviter: OrgsListPendingInvitationsResponseDataItemInviter;
    team_count: number;
    invitation_team_url: string;
};
declare type OrgsListPendingInvitationsResponseData = Array<OrgsListPendingInvitationsResponseDataItem>;
declare type OrgsCreateInvitationEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * **Required unless you provide `email`**. GitHub user ID for the person you are inviting.
     */
    invitee_id?: number;
    /**
     * **Required unless you provide `invitee_id`**. Email address of the person you are inviting, which can be an existing GitHub user.
     */
    email?: string;
    /**
     * Specify role for new member. Can be one of:
     * \* `admin` - Organization owners with full administrative rights to the organization and complete access to all repositories and teams.
     * \* `direct_member` - Non-owner organization members with ability to see other members and join teams by invitation.
     * \* `billing_manager` - Non-owner organization members with ability to manage the billing settings of your organization.
     */
    role?: "admin" | "direct_member" | "billing_manager";
    /**
     * Specify IDs for the teams you want to invite new members to.
     */
    team_ids?: number[];
};
declare type OrgsCreateInvitationRequestOptions = {
    method: "POST";
    url: "/orgs/:org/invitations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsCreateInvitationResponseDataInviter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type OrgsCreateInvitationResponseData = {
    id: number;
    login: string;
    email: string;
    role: string;
    created_at: string;
    inviter: OrgsCreateInvitationResponseDataInviter;
    team_count: number;
    invitation_team_url: string;
};
declare type OrgsListInvitationTeamsEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * invitation_id parameter
     */
    invitation_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListInvitationTeamsRequestOptions = {
    method: "GET";
    url: "/orgs/:org/invitations/:invitation_id/teams";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListInvitationTeamsResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type OrgsListInvitationTeamsResponseData = Array<OrgsListInvitationTeamsResponseDataItem>;
declare type IssuesListForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Indicates which sorts of issues to return. Can be one of:
     * \* `assigned`: Issues assigned to you
     * \* `created`: Issues created by you
     * \* `mentioned`: Issues mentioning you
     * \* `subscribed`: Issues you're subscribed to updates for
     * \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/issues";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListForOrgResponseDataItemRepositoryPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type IssuesListForOrgResponseDataItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListForOrgResponseDataItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: IssuesListForOrgResponseDataItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: IssuesListForOrgResponseDataItemRepositoryPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type IssuesListForOrgResponseDataItemPullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
};
declare type IssuesListForOrgResponseDataItemMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListForOrgResponseDataItemMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesListForOrgResponseDataItemMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesListForOrgResponseDataItemAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListForOrgResponseDataItemAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListForOrgResponseDataItemLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesListForOrgResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListForOrgResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesListForOrgResponseDataItemUser;
    labels: Array<IssuesListForOrgResponseDataItemLabelsItem>;
    assignee: IssuesListForOrgResponseDataItemAssignee;
    assignees: Array<IssuesListForOrgResponseDataItemAssigneesItem>;
    milestone: IssuesListForOrgResponseDataItemMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesListForOrgResponseDataItemPullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
    repository: IssuesListForOrgResponseDataItemRepository;
};
declare type IssuesListForOrgResponseData = Array<IssuesListForOrgResponseDataItem>;
declare type OrgsListMembersEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Filter members returned in the list. Can be one of:
     * \* `2fa_disabled` - Members without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled. Available for organization owners.
     * \* `all` - All members the authenticated user can see.
     */
    filter?: "2fa_disabled" | "all";
    /**
     * Filter members returned by their role. Can be one of:
     * \* `all` - All members of the organization, regardless of role.
     * \* `admin` - Organization owners.
     * \* `member` - Non-owner organization members.
     */
    role?: "all" | "admin" | "member";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListMembersRequestOptions = {
    method: "GET";
    url: "/orgs/:org/members";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListMembersResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type OrgsListMembersResponseData = Array<OrgsListMembersResponseDataItem>;
declare type OrgsCheckMembershipEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * username parameter
     */
    username: string;
};
declare type OrgsCheckMembershipRequestOptions = {
    method: "GET";
    url: "/orgs/:org/members/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsRemoveMemberEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * username parameter
     */
    username: string;
};
declare type OrgsRemoveMemberRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/members/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsGetMembershipEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * username parameter
     */
    username: string;
};
declare type OrgsGetMembershipRequestOptions = {
    method: "GET";
    url: "/orgs/:org/memberships/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsGetMembershipResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type OrgsGetMembershipResponseDataOrganization = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type OrgsGetMembershipResponseData = {
    url: string;
    state: string;
    role: string;
    organization_url: string;
    organization: OrgsGetMembershipResponseDataOrganization;
    user: OrgsGetMembershipResponseDataUser;
};
declare type OrgsAddOrUpdateMembershipEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * username parameter
     */
    username: string;
    /**
     * The role to give the user in the organization. Can be one of:
     * \* `admin` - The user will become an owner of the organization.
     * \* `member` - The user will become a non-owner member of the organization.
     */
    role?: "admin" | "member";
};
declare type OrgsAddOrUpdateMembershipRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/memberships/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsAddOrUpdateMembershipResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type OrgsAddOrUpdateMembershipResponseDataOrganization = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type OrgsAddOrUpdateMembershipResponseData = {
    url: string;
    state: string;
    role: string;
    organization_url: string;
    organization: OrgsAddOrUpdateMembershipResponseDataOrganization;
    user: OrgsAddOrUpdateMembershipResponseDataUser;
};
declare type OrgsRemoveMembershipEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * username parameter
     */
    username: string;
};
declare type OrgsRemoveMembershipRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/memberships/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsStartForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * A list of arrays indicating which repositories should be migrated.
     */
    repositories: string[];
    /**
     * Indicates whether repositories should be locked (to prevent manipulation) while migrating data.
     */
    lock_repositories?: boolean;
    /**
     * Indicates whether attachments should be excluded from the migration (to reduce migration archive file size).
     */
    exclude_attachments?: boolean;
};
declare type MigrationsStartForOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/migrations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsStartForOrgResponseDataRepositoriesItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type MigrationsStartForOrgResponseDataRepositoriesItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type MigrationsStartForOrgResponseDataRepositoriesItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: MigrationsStartForOrgResponseDataRepositoriesItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: MigrationsStartForOrgResponseDataRepositoriesItemPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type MigrationsStartForOrgResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type MigrationsStartForOrgResponseData = {
    id: number;
    owner: MigrationsStartForOrgResponseDataOwner;
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: Array<MigrationsStartForOrgResponseDataRepositoriesItem>;
    url: string;
    created_at: string;
    updated_at: string;
};
declare type MigrationsListForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsListForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/migrations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsListForOrgResponseDataItemRepositoriesItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type MigrationsListForOrgResponseDataItemRepositoriesItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type MigrationsListForOrgResponseDataItemRepositoriesItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: MigrationsListForOrgResponseDataItemRepositoriesItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: MigrationsListForOrgResponseDataItemRepositoriesItemPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type MigrationsListForOrgResponseDataItemOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type MigrationsListForOrgResponseDataItem = {
    id: number;
    owner: MigrationsListForOrgResponseDataItemOwner;
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: Array<MigrationsListForOrgResponseDataItemRepositoriesItem>;
    url: string;
    created_at: string;
    updated_at: string;
};
declare type MigrationsListForOrgResponseData = Array<MigrationsListForOrgResponseDataItem>;
declare type MigrationsGetStatusForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * migration_id parameter
     */
    migration_id: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsGetStatusForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/migrations/:migration_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsGetStatusForOrgResponseDataRepositoriesItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type MigrationsGetStatusForOrgResponseDataRepositoriesItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type MigrationsGetStatusForOrgResponseDataRepositoriesItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: MigrationsGetStatusForOrgResponseDataRepositoriesItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: MigrationsGetStatusForOrgResponseDataRepositoriesItemPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type MigrationsGetStatusForOrgResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type MigrationsGetStatusForOrgResponseData = {
    id: number;
    owner: MigrationsGetStatusForOrgResponseDataOwner;
    guid: string;
    state: string;
    lock_repositories: boolean;
    exclude_attachments: boolean;
    repositories: Array<MigrationsGetStatusForOrgResponseDataRepositoriesItem>;
    url: string;
    created_at: string;
    updated_at: string;
};
declare type MigrationsDownloadArchiveForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * migration_id parameter
     */
    migration_id: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsDownloadArchiveForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/migrations/:migration_id/archive";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsDeleteArchiveForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * migration_id parameter
     */
    migration_id: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsDeleteArchiveForOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/migrations/:migration_id/archive";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsUnlockRepoForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * migration_id parameter
     */
    migration_id: number;
    /**
     * repo_name parameter
     */
    repo_name: string;
} & RequiredPreview<"wyandotte">;
declare type MigrationsUnlockRepoForOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/migrations/:migration_id/repos/:repo_name/lock";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsListReposForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * migration_id parameter
     */
    migration_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"wyandotte">;
declare type MigrationsListReposForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/migrations/:migration_id/repositories";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsListReposForOrgResponseDataItemLicense = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
};
declare type MigrationsListReposForOrgResponseDataItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type MigrationsListReposForOrgResponseDataItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type MigrationsListReposForOrgResponseDataItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: MigrationsListReposForOrgResponseDataItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: MigrationsListReposForOrgResponseDataItemPermissions;
    template_repository: null;
    temp_clone_token: string;
    subscribers_count: number;
    network_count: number;
    license: MigrationsListReposForOrgResponseDataItemLicense;
};
declare type MigrationsListReposForOrgResponseData = Array<MigrationsListReposForOrgResponseDataItem>;
declare type OrgsListOutsideCollaboratorsEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Filter the list of outside collaborators. Can be one of:
     * \* `2fa_disabled`: Outside collaborators without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled.
     * \* `all`: All outside collaborators.
     */
    filter?: "2fa_disabled" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListOutsideCollaboratorsRequestOptions = {
    method: "GET";
    url: "/orgs/:org/outside_collaborators";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListOutsideCollaboratorsResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type OrgsListOutsideCollaboratorsResponseData = Array<OrgsListOutsideCollaboratorsResponseDataItem>;
declare type OrgsRemoveOutsideCollaboratorEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * username parameter
     */
    username: string;
};
declare type OrgsRemoveOutsideCollaboratorRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/outside_collaborators/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsRemoveOutsideCollaboratorResponseData = {
    message: string;
    documentation_url: string;
};
declare type OrgsConvertMemberToOutsideCollaboratorEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * username parameter
     */
    username: string;
};
declare type OrgsConvertMemberToOutsideCollaboratorRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/outside_collaborators/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsConvertMemberToOutsideCollaboratorResponseData = {
    message: string;
    documentation_url: string;
};
declare type ProjectsListForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"inertia">;
declare type ProjectsListForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/projects";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsListForOrgResponseDataItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ProjectsListForOrgResponseDataItem = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: ProjectsListForOrgResponseDataItemCreator;
    created_at: string;
    updated_at: string;
};
declare type ProjectsListForOrgResponseData = Array<ProjectsListForOrgResponseDataItem>;
declare type ProjectsCreateForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * The name of the project.
     */
    name: string;
    /**
     * The description of the project.
     */
    body?: string;
} & RequiredPreview<"inertia">;
declare type ProjectsCreateForOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/projects";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsCreateForOrgResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ProjectsCreateForOrgResponseData = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: ProjectsCreateForOrgResponseDataCreator;
    created_at: string;
    updated_at: string;
};
declare type OrgsListPublicMembersEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type OrgsListPublicMembersRequestOptions = {
    method: "GET";
    url: "/orgs/:org/public_members";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsListPublicMembersResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type OrgsListPublicMembersResponseData = Array<OrgsListPublicMembersResponseDataItem>;
declare type OrgsCheckPublicMembershipEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * username parameter
     */
    username: string;
};
declare type OrgsCheckPublicMembershipRequestOptions = {
    method: "GET";
    url: "/orgs/:org/public_members/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsPublicizeMembershipEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * username parameter
     */
    username: string;
};
declare type OrgsPublicizeMembershipRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/public_members/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type OrgsConcealMembershipEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * username parameter
     */
    username: string;
};
declare type OrgsConcealMembershipRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/public_members/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Specifies the types of repositories you want returned. Can be one of `all`, `public`, `private`, `forks`, `sources`, `member`, `internal`. Default: `all`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `type` can also be `internal`.
     */
    type?: "all" | "public" | "private" | "forks" | "sources" | "member" | "internal";
    /**
     * Can be one of `created`, `updated`, `pushed`, `full_name`.
     */
    sort?: "created" | "updated" | "pushed" | "full_name";
    /**
     * Can be one of `asc` or `desc`. Default: when using `full_name`: `asc`, otherwise `desc`
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/repos";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListForOrgResponseDataItemLicense = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
};
declare type ReposListForOrgResponseDataItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ReposListForOrgResponseDataItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListForOrgResponseDataItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposListForOrgResponseDataItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposListForOrgResponseDataItemPermissions;
    template_repository: null;
    temp_clone_token: string;
    subscribers_count: number;
    network_count: number;
    license: ReposListForOrgResponseDataItemLicense;
};
declare type ReposListForOrgResponseData = Array<ReposListForOrgResponseDataItem>;
declare type ReposCreateInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * The name of the repository.
     */
    name: string;
    /**
     * A short description of the repository.
     */
    description?: string;
    /**
     * A URL with more information about the repository.
     */
    homepage?: string;
    /**
     * Either `true` to create a private repository or `false` to create a public one.
     */
    private?: boolean;
    /**
     * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `visibility` can also be `internal`. For more information, see "[Creating an internal repository](https://help.github.com/en/github/creating-cloning-and-archiving-repositories/about-repository-visibility#about-internal-repositories)" in the GitHub Help documentation.
     * The `visibility` parameter overrides the `private` parameter when you use both parameters with the `nebula-preview` preview header.
     */
    visibility?: "public" | "private" | "visibility" | "internal";
    /**
     * Either `true` to enable issues for this repository or `false` to disable them.
     */
    has_issues?: boolean;
    /**
     * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
     */
    has_projects?: boolean;
    /**
     * Either `true` to enable the wiki for this repository or `false` to disable it.
     */
    has_wiki?: boolean;
    /**
     * Either `true` to make this repo available as a template repository or `false` to prevent it.
     */
    is_template?: boolean;
    /**
     * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
     */
    team_id?: number;
    /**
     * Pass `true` to create an initial commit with empty README.
     */
    auto_init?: boolean;
    /**
     * Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".
     */
    gitignore_template?: string;
    /**
     * Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://help.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".
     */
    license_template?: string;
    /**
     * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
     */
    allow_squash_merge?: boolean;
    /**
     * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
     */
    allow_merge_commit?: boolean;
    /**
     * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
     */
    allow_rebase_merge?: boolean;
    /**
     * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
     */
    delete_branch_on_merge?: boolean;
};
declare type ReposCreateInOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/repos";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposCreateInOrgResponseDataPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ReposCreateInOrgResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposCreateInOrgResponseData = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposCreateInOrgResponseDataOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposCreateInOrgResponseDataPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type TeamsListIdPGroupsForOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type TeamsListIdPGroupsForOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/team-sync/groups";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListIdPGroupsForOrgResponseDataGroupsItem = {
    group_id: string;
    group_name: string;
    group_description: string;
};
declare type TeamsListIdPGroupsForOrgResponseData = {
    groups: Array<TeamsListIdPGroupsForOrgResponseDataGroupsItem>;
};
declare type TeamsListEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type TeamsListRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type TeamsListResponseData = Array<TeamsListResponseDataItem>;
declare type TeamsCreateEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * The name of the team.
     */
    name: string;
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * List GitHub IDs for organization members who will become team maintainers.
     */
    maintainers?: string[];
    /**
     * The full name (e.g., "organization-name/repository-name") of repositories to add the team to.
     */
    repo_names?: string[];
    /**
     * The level of privacy this team should have. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * Default: `secret`
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     * Default for child team: `closed`
     */
    privacy?: "secret" | "closed";
    /**
     * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
     * \* `push` - team members can pull and push, but not administer newly-added repositories.
     * \* `admin` - team members can pull, push and administer newly-added repositories.
     */
    permission?: "pull" | "push" | "admin";
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
};
declare type TeamsCreateRequestOptions = {
    method: "POST";
    url: "/orgs/:org/teams";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsCreateResponseDataOrganization = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    is_verified: boolean;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    html_url: string;
    created_at: string;
    type: string;
};
declare type TeamsCreateResponseData = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
    members_count: number;
    repos_count: number;
    created_at: string;
    updated_at: string;
    organization: TeamsCreateResponseDataOrganization;
};
declare type TeamsGetByNameEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
};
declare type TeamsGetByNameRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsGetByNameResponseDataOrganization = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    is_verified: boolean;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    html_url: string;
    created_at: string;
    type: string;
};
declare type TeamsGetByNameResponseData = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
    members_count: number;
    repos_count: number;
    created_at: string;
    updated_at: string;
    organization: TeamsGetByNameResponseDataOrganization;
};
declare type TeamsUpdateInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * The name of the team.
     */
    name: string;
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     */
    privacy?: "secret" | "closed";
    /**
     * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
     * \* `push` - team members can pull and push, but not administer newly-added repositories.
     * \* `admin` - team members can pull, push and administer newly-added repositories.
     */
    permission?: "pull" | "push" | "admin";
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
};
declare type TeamsUpdateInOrgRequestOptions = {
    method: "PATCH";
    url: "/orgs/:org/teams/:team_slug";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsUpdateInOrgResponseDataOrganization = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
    name: string;
    company: string;
    blog: string;
    location: string;
    email: string;
    is_verified: boolean;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    public_repos: number;
    public_gists: number;
    followers: number;
    following: number;
    html_url: string;
    created_at: string;
    type: string;
};
declare type TeamsUpdateInOrgResponseData = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
    members_count: number;
    repos_count: number;
    created_at: string;
    updated_at: string;
    organization: TeamsUpdateInOrgResponseDataOrganization;
};
declare type TeamsDeleteInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
};
declare type TeamsDeleteInOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/teams/:team_slug";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListDiscussionsInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type TeamsListDiscussionsInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/discussions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListDiscussionsInOrgResponseDataItemReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
};
declare type TeamsListDiscussionsInOrgResponseDataItemAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsListDiscussionsInOrgResponseDataItem = {
    author: TeamsListDiscussionsInOrgResponseDataItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    last_edited_at: null;
    html_url: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
    reactions: TeamsListDiscussionsInOrgResponseDataItemReactions;
};
declare type TeamsListDiscussionsInOrgResponseData = Array<TeamsListDiscussionsInOrgResponseDataItem>;
declare type TeamsCreateDiscussionInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * The discussion post's title.
     */
    title: string;
    /**
     * The discussion post's body text.
     */
    body: string;
    /**
     * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
     */
    private?: boolean;
};
declare type TeamsCreateDiscussionInOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/teams/:team_slug/discussions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsCreateDiscussionInOrgResponseDataReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
};
declare type TeamsCreateDiscussionInOrgResponseDataAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsCreateDiscussionInOrgResponseData = {
    author: TeamsCreateDiscussionInOrgResponseDataAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    last_edited_at: null;
    html_url: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
    reactions: TeamsCreateDiscussionInOrgResponseDataReactions;
};
declare type TeamsGetDiscussionInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
};
declare type TeamsGetDiscussionInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsGetDiscussionInOrgResponseDataReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
};
declare type TeamsGetDiscussionInOrgResponseDataAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsGetDiscussionInOrgResponseData = {
    author: TeamsGetDiscussionInOrgResponseDataAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    last_edited_at: null;
    html_url: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
    reactions: TeamsGetDiscussionInOrgResponseDataReactions;
};
declare type TeamsUpdateDiscussionInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
    /**
     * The discussion post's title.
     */
    title?: string;
    /**
     * The discussion post's body text.
     */
    body?: string;
};
declare type TeamsUpdateDiscussionInOrgRequestOptions = {
    method: "PATCH";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsUpdateDiscussionInOrgResponseDataReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
};
declare type TeamsUpdateDiscussionInOrgResponseDataAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsUpdateDiscussionInOrgResponseData = {
    author: TeamsUpdateDiscussionInOrgResponseDataAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    last_edited_at: string;
    html_url: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
    reactions: TeamsUpdateDiscussionInOrgResponseDataReactions;
};
declare type TeamsDeleteDiscussionInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
};
declare type TeamsDeleteDiscussionInOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListDiscussionCommentsInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type TeamsListDiscussionCommentsInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListDiscussionCommentsInOrgResponseDataItemReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
};
declare type TeamsListDiscussionCommentsInOrgResponseDataItemAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsListDiscussionCommentsInOrgResponseDataItem = {
    author: TeamsListDiscussionCommentsInOrgResponseDataItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    last_edited_at: null;
    discussion_url: string;
    html_url: string;
    node_id: string;
    number: number;
    updated_at: string;
    url: string;
    reactions: TeamsListDiscussionCommentsInOrgResponseDataItemReactions;
};
declare type TeamsListDiscussionCommentsInOrgResponseData = Array<TeamsListDiscussionCommentsInOrgResponseDataItem>;
declare type TeamsCreateDiscussionCommentInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
    /**
     * The discussion comment's body text.
     */
    body: string;
};
declare type TeamsCreateDiscussionCommentInOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsCreateDiscussionCommentInOrgResponseDataReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
};
declare type TeamsCreateDiscussionCommentInOrgResponseDataAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsCreateDiscussionCommentInOrgResponseData = {
    author: TeamsCreateDiscussionCommentInOrgResponseDataAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    last_edited_at: null;
    discussion_url: string;
    html_url: string;
    node_id: string;
    number: number;
    updated_at: string;
    url: string;
    reactions: TeamsCreateDiscussionCommentInOrgResponseDataReactions;
};
declare type TeamsGetDiscussionCommentInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
    /**
     * comment_number parameter
     */
    comment_number: number;
};
declare type TeamsGetDiscussionCommentInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsGetDiscussionCommentInOrgResponseDataReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
};
declare type TeamsGetDiscussionCommentInOrgResponseDataAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsGetDiscussionCommentInOrgResponseData = {
    author: TeamsGetDiscussionCommentInOrgResponseDataAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    last_edited_at: null;
    discussion_url: string;
    html_url: string;
    node_id: string;
    number: number;
    updated_at: string;
    url: string;
    reactions: TeamsGetDiscussionCommentInOrgResponseDataReactions;
};
declare type TeamsUpdateDiscussionCommentInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
    /**
     * comment_number parameter
     */
    comment_number: number;
    /**
     * The discussion comment's body text.
     */
    body: string;
};
declare type TeamsUpdateDiscussionCommentInOrgRequestOptions = {
    method: "PATCH";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsUpdateDiscussionCommentInOrgResponseDataReactions = {
    url: string;
    total_count: number;
    "+1": number;
    "-1": number;
    laugh: number;
    confused: number;
    heart: number;
    hooray: number;
};
declare type TeamsUpdateDiscussionCommentInOrgResponseDataAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsUpdateDiscussionCommentInOrgResponseData = {
    author: TeamsUpdateDiscussionCommentInOrgResponseDataAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    last_edited_at: string;
    discussion_url: string;
    html_url: string;
    node_id: string;
    number: number;
    updated_at: string;
    url: string;
    reactions: TeamsUpdateDiscussionCommentInOrgResponseDataReactions;
};
declare type TeamsDeleteDiscussionCommentInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
    /**
     * comment_number parameter
     */
    comment_number: number;
};
declare type TeamsDeleteDiscussionCommentInOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsListForTeamDiscussionCommentInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
    /**
     * comment_number parameter
     */
    comment_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForTeamDiscussionCommentInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsListForTeamDiscussionCommentInOrgResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReactionsListForTeamDiscussionCommentInOrgResponseDataItem = {
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionCommentInOrgResponseDataItemUser;
    content: string;
    created_at: string;
};
declare type ReactionsListForTeamDiscussionCommentInOrgResponseData = Array<ReactionsListForTeamDiscussionCommentInOrgResponseDataItem>;
declare type ReactionsCreateForTeamDiscussionCommentInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
    /**
     * comment_number parameter
     */
    comment_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForTeamDiscussionCommentInOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsCreateForTeamDiscussionCommentInOrgResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReactionsCreateForTeamDiscussionCommentInOrgResponseData = {
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionCommentInOrgResponseDataUser;
    content: string;
    created_at: string;
};
declare type ReactionsDeleteForTeamDiscussionCommentEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
    /**
     * comment_number parameter
     */
    comment_number: number;
    /**
     * reaction_id parameter
     */
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteForTeamDiscussionCommentRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsListForTeamDiscussionInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForTeamDiscussionInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsListForTeamDiscussionInOrgResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReactionsListForTeamDiscussionInOrgResponseDataItem = {
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionInOrgResponseDataItemUser;
    content: string;
    created_at: string;
};
declare type ReactionsListForTeamDiscussionInOrgResponseData = Array<ReactionsListForTeamDiscussionInOrgResponseDataItem>;
declare type ReactionsCreateForTeamDiscussionInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForTeamDiscussionInOrgRequestOptions = {
    method: "POST";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsCreateForTeamDiscussionInOrgResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReactionsCreateForTeamDiscussionInOrgResponseData = {
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionInOrgResponseDataUser;
    content: string;
    created_at: string;
};
declare type ReactionsDeleteForTeamDiscussionEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * discussion_number parameter
     */
    discussion_number: number;
    /**
     * reaction_id parameter
     */
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteForTeamDiscussionRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/teams/:team_slug/discussions/:discussion_number/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListPendingInvitationsInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type TeamsListPendingInvitationsInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/invitations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListPendingInvitationsInOrgResponseDataItemInviter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsListPendingInvitationsInOrgResponseDataItem = {
    id: number;
    login: string;
    email: string;
    role: string;
    created_at: string;
    inviter: TeamsListPendingInvitationsInOrgResponseDataItemInviter;
    team_count: number;
    invitation_team_url: string;
};
declare type TeamsListPendingInvitationsInOrgResponseData = Array<TeamsListPendingInvitationsInOrgResponseDataItem>;
declare type TeamsListMembersInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * Filters members returned by their role in the team. Can be one of:
     * \* `member` - normal members of the team.
     * \* `maintainer` - team maintainers.
     * \* `all` - all members of the team.
     */
    role?: "member" | "maintainer" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type TeamsListMembersInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/members";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListMembersInOrgResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsListMembersInOrgResponseData = Array<TeamsListMembersInOrgResponseDataItem>;
declare type TeamsGetMembershipInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * username parameter
     */
    username: string;
};
declare type TeamsGetMembershipInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/memberships/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsGetMembershipInOrgResponseData = {
    url: string;
    role: string;
    state: string;
};
declare type TeamsAddOrUpdateMembershipInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * username parameter
     */
    username: string;
    /**
     * The role that this user should have in the team. Can be one of:
     * \* `member` - a normal member of the team.
     * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
     */
    role?: "member" | "maintainer";
};
declare type TeamsAddOrUpdateMembershipInOrgRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/teams/:team_slug/memberships/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsAddOrUpdateMembershipInOrgResponseData = {
    url: string;
    role: string;
    state: string;
};
declare type TeamsRemoveMembershipInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * username parameter
     */
    username: string;
};
declare type TeamsRemoveMembershipInOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/teams/:team_slug/memberships/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListProjectsInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"inertia">;
declare type TeamsListProjectsInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/projects";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListProjectsInOrgResponseDataItemPermissions = {
    read: boolean;
    write: boolean;
    admin: boolean;
};
declare type TeamsListProjectsInOrgResponseDataItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsListProjectsInOrgResponseDataItem = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: TeamsListProjectsInOrgResponseDataItemCreator;
    created_at: string;
    updated_at: string;
    organization_permission: string;
    private: boolean;
    permissions: TeamsListProjectsInOrgResponseDataItemPermissions;
};
declare type TeamsListProjectsInOrgResponseData = Array<TeamsListProjectsInOrgResponseDataItem>;
declare type TeamsReviewProjectInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * project_id parameter
     */
    project_id: number;
} & RequiredPreview<"inertia">;
declare type TeamsReviewProjectInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/projects/:project_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsReviewProjectInOrgResponseDataPermissions = {
    read: boolean;
    write: boolean;
    admin: boolean;
};
declare type TeamsReviewProjectInOrgResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsReviewProjectInOrgResponseData = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: TeamsReviewProjectInOrgResponseDataCreator;
    created_at: string;
    updated_at: string;
    organization_permission: string;
    private: boolean;
    permissions: TeamsReviewProjectInOrgResponseDataPermissions;
};
declare type TeamsAddOrUpdateProjectInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * project_id parameter
     */
    project_id: number;
    /**
     * The permission to grant to the team for this project. Can be one of:
     * \* `read` - team members can read, but not write to or administer this project.
     * \* `write` - team members can read and write, but not administer this project.
     * \* `admin` - team members can read, write and administer this project.
     * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    permission?: "read" | "write" | "admin";
} & RequiredPreview<"inertia">;
declare type TeamsAddOrUpdateProjectInOrgRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/teams/:team_slug/projects/:project_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsAddOrUpdateProjectInOrgResponseData = {
    message: string;
    documentation_url: string;
};
declare type TeamsRemoveProjectInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * project_id parameter
     */
    project_id: number;
};
declare type TeamsRemoveProjectInOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/teams/:team_slug/projects/:project_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListReposInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type TeamsListReposInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/repos";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListReposInOrgResponseDataItemLicense = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
};
declare type TeamsListReposInOrgResponseDataItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type TeamsListReposInOrgResponseDataItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsListReposInOrgResponseDataItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: TeamsListReposInOrgResponseDataItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: TeamsListReposInOrgResponseDataItemPermissions;
    template_repository: null;
    temp_clone_token: string;
    subscribers_count: number;
    network_count: number;
    license: TeamsListReposInOrgResponseDataItemLicense;
};
declare type TeamsListReposInOrgResponseData = Array<TeamsListReposInOrgResponseDataItem>;
declare type TeamsCheckManagesRepoInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type TeamsCheckManagesRepoInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/repos/:owner/:repo";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsCheckManagesRepoInOrgResponseDataPermissions = {
    pull: boolean;
    triage: boolean;
    push: boolean;
    maintain: boolean;
    admin: boolean;
};
declare type TeamsCheckManagesRepoInOrgResponseDataSourcePermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type TeamsCheckManagesRepoInOrgResponseDataSourceOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsCheckManagesRepoInOrgResponseDataSource = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: TeamsCheckManagesRepoInOrgResponseDataSourceOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: TeamsCheckManagesRepoInOrgResponseDataSourcePermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type TeamsCheckManagesRepoInOrgResponseDataParentPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type TeamsCheckManagesRepoInOrgResponseDataParentOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsCheckManagesRepoInOrgResponseDataParent = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: TeamsCheckManagesRepoInOrgResponseDataParentOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: TeamsCheckManagesRepoInOrgResponseDataParentPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type TeamsCheckManagesRepoInOrgResponseDataOrganization = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type TeamsCheckManagesRepoInOrgResponseData = {
    organization: TeamsCheckManagesRepoInOrgResponseDataOrganization;
    parent: TeamsCheckManagesRepoInOrgResponseDataParent;
    source: TeamsCheckManagesRepoInOrgResponseDataSource;
    permissions: TeamsCheckManagesRepoInOrgResponseDataPermissions;
};
declare type TeamsAddOrUpdateRepoInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The permission to grant the team on this repository. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer this repository.
     * \* `push` - team members can pull and push, but not administer this repository.
     * \* `admin` - team members can pull, push and administer this repository.
     * \* `maintain` - team members can manage the repository without access to sensitive or destructive actions. Recommended for project managers. Only applies to repositories owned by organizations.
     * \* `triage` - team members can proactively manage issues and pull requests without write access. Recommended for contributors who triage a repository. Only applies to repositories owned by organizations.
     *
     * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
     */
    permission?: "pull" | "push" | "admin" | "maintain" | "triage";
};
declare type TeamsAddOrUpdateRepoInOrgRequestOptions = {
    method: "PUT";
    url: "/orgs/:org/teams/:team_slug/repos/:owner/:repo";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsRemoveRepoInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type TeamsRemoveRepoInOrgRequestOptions = {
    method: "DELETE";
    url: "/orgs/:org/teams/:team_slug/repos/:owner/:repo";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListIdPGroupsInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
};
declare type TeamsListIdPGroupsInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/team-sync/group-mappings";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListIdPGroupsInOrgResponseDataGroupsItem = {
    group_id: string;
    group_name: string;
    group_description: string;
};
declare type TeamsListIdPGroupsInOrgResponseData = {
    groups: Array<TeamsListIdPGroupsInOrgResponseDataGroupsItem>;
};
declare type TeamsCreateOrUpdateIdPGroupConnectionsInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * The IdP groups you want to connect to a GitHub team. When updating, the new `groups` object will replace the original one. You must include any existing groups that you don't want to remove.
     */
    groups: TeamsCreateOrUpdateIdPGroupConnectionsInOrgParamsGroups[];
};
declare type TeamsCreateOrUpdateIdPGroupConnectionsInOrgRequestOptions = {
    method: "PATCH";
    url: "/orgs/:org/teams/:team_slug/team-sync/group-mappings";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsCreateOrUpdateIdPGroupConnectionsInOrgResponseDataGroups = {
    group_id: string;
    group_name: string;
    group_description: string;
};
declare type TeamsCreateOrUpdateIdPGroupConnectionsInOrgResponseData = {
    groups: TeamsCreateOrUpdateIdPGroupConnectionsInOrgResponseDataGroups;
};
declare type TeamsListChildInOrgEndpoint = {
    /**
     * org parameter
     */
    org: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type TeamsListChildInOrgRequestOptions = {
    method: "GET";
    url: "/orgs/:org/teams/:team_slug/teams";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type TeamsListChildInOrgResponseDataItemParent = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
};
declare type TeamsListChildInOrgResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: TeamsListChildInOrgResponseDataItemParent;
};
declare type TeamsListChildInOrgResponseData = Array<TeamsListChildInOrgResponseDataItem>;
declare type ProjectsGetCardEndpoint = {
    /**
     * card_id parameter
     */
    card_id: number;
} & RequiredPreview<"inertia">;
declare type ProjectsGetCardRequestOptions = {
    method: "GET";
    url: "/projects/columns/cards/:card_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsGetCardResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ProjectsGetCardResponseData = {
    url: string;
    id: number;
    node_id: string;
    note: string;
    creator: ProjectsGetCardResponseDataCreator;
    created_at: string;
    updated_at: string;
    archived: boolean;
    column_url: string;
    content_url: string;
    project_url: string;
};
declare type ProjectsUpdateCardEndpoint = {
    /**
     * card_id parameter
     */
    card_id: number;
    /**
     * The card's note content. Only valid for cards without another type of content, so this cannot be specified if the card already has a `content_id` and `content_type`.
     */
    note?: string;
    /**
     * Use `true` to archive a project card. Specify `false` if you need to restore a previously archived project card.
     */
    archived?: boolean;
} & RequiredPreview<"inertia">;
declare type ProjectsUpdateCardRequestOptions = {
    method: "PATCH";
    url: "/projects/columns/cards/:card_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsUpdateCardResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ProjectsUpdateCardResponseData = {
    url: string;
    id: number;
    node_id: string;
    note: string;
    creator: ProjectsUpdateCardResponseDataCreator;
    created_at: string;
    updated_at: string;
    archived: boolean;
    column_url: string;
    content_url: string;
    project_url: string;
};
declare type ProjectsDeleteCardEndpoint = {
    /**
     * card_id parameter
     */
    card_id: number;
} & RequiredPreview<"inertia">;
declare type ProjectsDeleteCardRequestOptions = {
    method: "DELETE";
    url: "/projects/columns/cards/:card_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsMoveCardEndpoint = {
    /**
     * card_id parameter
     */
    card_id: number;
    /**
     * Can be one of `top`, `bottom`, or `after:<card_id>`, where `<card_id>` is the `id` value of a card in the same column, or in the new column specified by `column_id`.
     */
    position: string;
    /**
     * The `id` value of a column in the same project.
     */
    column_id?: number;
} & RequiredPreview<"inertia">;
declare type ProjectsMoveCardRequestOptions = {
    method: "POST";
    url: "/projects/columns/cards/:card_id/moves";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsGetColumnEndpoint = {
    /**
     * column_id parameter
     */
    column_id: number;
} & RequiredPreview<"inertia">;
declare type ProjectsGetColumnRequestOptions = {
    method: "GET";
    url: "/projects/columns/:column_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsGetColumnResponseData = {
    url: string;
    project_url: string;
    cards_url: string;
    id: number;
    node_id: string;
    name: string;
    created_at: string;
    updated_at: string;
};
declare type ProjectsUpdateColumnEndpoint = {
    /**
     * column_id parameter
     */
    column_id: number;
    /**
     * The new name of the column.
     */
    name: string;
} & RequiredPreview<"inertia">;
declare type ProjectsUpdateColumnRequestOptions = {
    method: "PATCH";
    url: "/projects/columns/:column_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsUpdateColumnResponseData = {
    url: string;
    project_url: string;
    cards_url: string;
    id: number;
    node_id: string;
    name: string;
    created_at: string;
    updated_at: string;
};
declare type ProjectsDeleteColumnEndpoint = {
    /**
     * column_id parameter
     */
    column_id: number;
} & RequiredPreview<"inertia">;
declare type ProjectsDeleteColumnRequestOptions = {
    method: "DELETE";
    url: "/projects/columns/:column_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsListCardsEndpoint = {
    /**
     * column_id parameter
     */
    column_id: number;
    /**
     * Filters the project cards that are returned by the card's state. Can be one of `all`,`archived`, or `not_archived`.
     */
    archived_state?: "all" | "archived" | "not_archived";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"inertia">;
declare type ProjectsListCardsRequestOptions = {
    method: "GET";
    url: "/projects/columns/:column_id/cards";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsListCardsResponseDataItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ProjectsListCardsResponseDataItem = {
    url: string;
    id: number;
    node_id: string;
    note: string;
    creator: ProjectsListCardsResponseDataItemCreator;
    created_at: string;
    updated_at: string;
    archived: boolean;
    column_url: string;
    content_url: string;
    project_url: string;
};
declare type ProjectsListCardsResponseData = Array<ProjectsListCardsResponseDataItem>;
declare type ProjectsCreateCardEndpoint = {
    /**
     * column_id parameter
     */
    column_id: number;
    /**
     * The card's note content. Only valid for cards without another type of content, so you must omit when specifying `content_id` and `content_type`.
     */
    note?: string;
    /**
     * The issue or pull request id you want to associate with this card. You can use the [List repository issues](https://developer.github.com/v3/issues/#list-repository-issues) and [List pull requests](https://developer.github.com/v3/pulls/#list-pull-requests) endpoints to find this id.
     * **Note:** Depending on whether you use the issue id or pull request id, you will need to specify `Issue` or `PullRequest` as the `content_type`.
     */
    content_id?: number;
    /**
     * **Required if you provide `content_id`**. The type of content you want to associate with this card. Use `Issue` when `content_id` is an issue id and use `PullRequest` when `content_id` is a pull request id.
     */
    content_type?: string;
} & RequiredPreview<"inertia">;
declare type ProjectsCreateCardRequestOptions = {
    method: "POST";
    url: "/projects/columns/:column_id/cards";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsCreateCardResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ProjectsCreateCardResponseData = {
    url: string;
    id: number;
    node_id: string;
    note: string;
    creator: ProjectsCreateCardResponseDataCreator;
    created_at: string;
    updated_at: string;
    archived: boolean;
    column_url: string;
    content_url: string;
    project_url: string;
};
declare type ProjectsMoveColumnEndpoint = {
    /**
     * column_id parameter
     */
    column_id: number;
    /**
     * Can be one of `first`, `last`, or `after:<column_id>`, where `<column_id>` is the `id` value of a column in the same project.
     */
    position: string;
} & RequiredPreview<"inertia">;
declare type ProjectsMoveColumnRequestOptions = {
    method: "POST";
    url: "/projects/columns/:column_id/moves";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsGetEndpoint = {
    /**
     * project_id parameter
     */
    project_id: number;
} & RequiredPreview<"inertia">;
declare type ProjectsGetRequestOptions = {
    method: "GET";
    url: "/projects/:project_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsGetResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ProjectsGetResponseData = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: ProjectsGetResponseDataCreator;
    created_at: string;
    updated_at: string;
};
declare type ProjectsUpdateEndpoint = {
    /**
     * project_id parameter
     */
    project_id: number;
    /**
     * The name of the project.
     */
    name?: string;
    /**
     * The description of the project.
     */
    body?: string;
    /**
     * State of the project. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The permission level that determines whether all members of the project's organization can see and/or make changes to the project. Setting `organization_permission` is only available for organization projects. If an organization member belongs to a team with a higher level of access or is a collaborator with a higher level of access, their permission level is not lowered by `organization_permission`. For information on changing access for a team or collaborator, see [Add or update team project](https://developer.github.com/v3/teams/#add-or-update-team-project) or [Add user as a collaborator](https://developer.github.com/v3/projects/collaborators/#add-user-as-a-collaborator).
     *
     * **Note:** Updating a project's `organization_permission` requires `admin` access to the project.
     *
     * Can be one of:
     * \* `read` - Organization members can read, but not write to or administer this project.
     * \* `write` - Organization members can read and write, but not administer this project.
     * \* `admin` - Organization members can read, write and administer this project.
     * \* `none` - Organization members can only see this project if it is public.
     */
    organization_permission?: string;
    /**
     * Sets the visibility of a project board. Setting `private` is only available for organization and user projects. **Note:** Updating a project's visibility requires `admin` access to the project.
     *
     * Can be one of:
     * \* `false` - Anyone can see the project.
     * \* `true` - Only the user can view a project board created on a user account. Organization members with the appropriate `organization_permission` can see project boards in an organization account.
     */
    private?: boolean;
} & RequiredPreview<"inertia">;
declare type ProjectsUpdateRequestOptions = {
    method: "PATCH";
    url: "/projects/:project_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsUpdateResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ProjectsUpdateResponseData = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: ProjectsUpdateResponseDataCreator;
    created_at: string;
    updated_at: string;
};
declare type ProjectsDeleteEndpoint = {
    /**
     * project_id parameter
     */
    project_id: number;
} & RequiredPreview<"inertia">;
declare type ProjectsDeleteRequestOptions = {
    method: "DELETE";
    url: "/projects/:project_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsListCollaboratorsEndpoint = {
    /**
     * project_id parameter
     */
    project_id: number;
    /**
     * Filters the collaborators by their affiliation. Can be one of:
     * \* `outside`: Outside collaborators of a project that are not a member of the project's organization.
     * \* `direct`: Collaborators with permissions to a project, regardless of organization membership status.
     * \* `all`: All collaborators the authenticated user can see.
     */
    affiliation?: "outside" | "direct" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"inertia">;
declare type ProjectsListCollaboratorsRequestOptions = {
    method: "GET";
    url: "/projects/:project_id/collaborators";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsListCollaboratorsResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ProjectsListCollaboratorsResponseData = Array<ProjectsListCollaboratorsResponseDataItem>;
declare type ProjectsAddCollaboratorEndpoint = {
    /**
     * project_id parameter
     */
    project_id: number;
    /**
     * username parameter
     */
    username: string;
    /**
     * The permission to grant the collaborator. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)." Can be one of:
     * \* `read` - can read, but not write to or administer this project.
     * \* `write` - can read and write, but not administer this project.
     * \* `admin` - can read, write and administer this project.
     */
    permission?: "read" | "write" | "admin";
} & RequiredPreview<"inertia">;
declare type ProjectsAddCollaboratorRequestOptions = {
    method: "PUT";
    url: "/projects/:project_id/collaborators/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsRemoveCollaboratorEndpoint = {
    /**
     * project_id parameter
     */
    project_id: number;
    /**
     * username parameter
     */
    username: string;
} & RequiredPreview<"inertia">;
declare type ProjectsRemoveCollaboratorRequestOptions = {
    method: "DELETE";
    url: "/projects/:project_id/collaborators/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsReviewUserPermissionLevelEndpoint = {
    /**
     * project_id parameter
     */
    project_id: number;
    /**
     * username parameter
     */
    username: string;
} & RequiredPreview<"inertia">;
declare type ProjectsReviewUserPermissionLevelRequestOptions = {
    method: "GET";
    url: "/projects/:project_id/collaborators/:username/permission";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsReviewUserPermissionLevelResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ProjectsReviewUserPermissionLevelResponseData = {
    permission: string;
    user: ProjectsReviewUserPermissionLevelResponseDataUser;
};
declare type ProjectsListColumnsEndpoint = {
    /**
     * project_id parameter
     */
    project_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"inertia">;
declare type ProjectsListColumnsRequestOptions = {
    method: "GET";
    url: "/projects/:project_id/columns";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsListColumnsResponseDataItem = {
    url: string;
    project_url: string;
    cards_url: string;
    id: number;
    node_id: string;
    name: string;
    created_at: string;
    updated_at: string;
};
declare type ProjectsListColumnsResponseData = Array<ProjectsListColumnsResponseDataItem>;
declare type ProjectsCreateColumnEndpoint = {
    /**
     * project_id parameter
     */
    project_id: number;
    /**
     * The name of the column.
     */
    name: string;
} & RequiredPreview<"inertia">;
declare type ProjectsCreateColumnRequestOptions = {
    method: "POST";
    url: "/projects/:project_id/columns";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsCreateColumnResponseData = {
    url: string;
    project_url: string;
    cards_url: string;
    id: number;
    node_id: string;
    name: string;
    created_at: string;
    updated_at: string;
};
declare type RateLimitGetEndpoint = {};
declare type RateLimitGetRequestOptions = {
    method: "GET";
    url: "/rate_limit";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type RateLimitGetResponseDataRate = {
    limit: number;
    remaining: number;
    reset: number;
};
declare type RateLimitGetResponseDataResourcesIntegrationManifest = {
    limit: number;
    remaining: number;
    reset: number;
};
declare type RateLimitGetResponseDataResourcesGraphql = {
    limit: number;
    remaining: number;
    reset: number;
};
declare type RateLimitGetResponseDataResourcesSearch = {
    limit: number;
    remaining: number;
    reset: number;
};
declare type RateLimitGetResponseDataResourcesCore = {
    limit: number;
    remaining: number;
    reset: number;
};
declare type RateLimitGetResponseDataResources = {
    core: RateLimitGetResponseDataResourcesCore;
    search: RateLimitGetResponseDataResourcesSearch;
    graphql: RateLimitGetResponseDataResourcesGraphql;
    integration_manifest: RateLimitGetResponseDataResourcesIntegrationManifest;
};
declare type RateLimitGetResponseData = {
    resources: RateLimitGetResponseDataResources;
    rate: RateLimitGetResponseDataRate;
};
declare type ReactionsDeleteLegacyEndpoint = {
    /**
     * reaction_id parameter
     */
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteLegacyRequestOptions = {
    method: "DELETE";
    url: "/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposGetRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetResponseDataCodeOfConduct = {
    key: string;
    name: string;
    url: string;
};
declare type ReposGetResponseDataSourcePermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ReposGetResponseDataSourceOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetResponseDataSource = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposGetResponseDataSourceOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposGetResponseDataSourcePermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type ReposGetResponseDataParentPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ReposGetResponseDataParentOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetResponseDataParent = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposGetResponseDataParentOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposGetResponseDataParentPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type ReposGetResponseDataOrganization = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetResponseDataLicense = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
};
declare type ReposGetResponseDataPermissions = {
    pull: boolean;
    triage: boolean;
    push: boolean;
    maintain: boolean;
    admin: boolean;
};
declare type ReposGetResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetResponseData = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposGetResponseDataOwner;
    private: boolean;
    html_url: string;
    description: string | null;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string | null;
    hooks_url: string;
    svn_url: string;
    homepage: string | null;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template?: boolean;
    topics?: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived?: boolean;
    disabled?: boolean;
    visibility?: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions?: ReposGetResponseDataPermissions;
    allow_rebase_merge?: boolean;
    template_repository?: null;
    temp_clone_token?: string;
    allow_squash_merge?: boolean;
    allow_merge_commit?: boolean;
    subscribers_count: number;
    network_count: number;
    license?: ReposGetResponseDataLicense;
    organization?: ReposGetResponseDataOrganization;
    parent?: ReposGetResponseDataParent;
    source?: ReposGetResponseDataSource;
    forks?: number;
    open_issues?: number;
    watchers?: number;
    code_of_conduct?: ReposGetResponseDataCodeOfConduct;
};
declare type ReposUpdateEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The name of the repository.
     */
    name?: string;
    /**
     * A short description of the repository.
     */
    description?: string;
    /**
     * A URL with more information about the repository.
     */
    homepage?: string;
    /**
     * Either `true` to make the repository private or `false` to make it public. Default: `false`.
     * **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private. **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private.
     */
    private?: boolean;
    /**
     * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `visibility` can also be `internal`. The `visibility` parameter overrides the `private` parameter when you use both along with the `nebula-preview` preview header.
     */
    visibility?: "public" | "private" | "visibility" | "internal";
    /**
     * Either `true` to enable issues for this repository or `false` to disable them.
     */
    has_issues?: boolean;
    /**
     * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
     */
    has_projects?: boolean;
    /**
     * Either `true` to enable the wiki for this repository or `false` to disable it.
     */
    has_wiki?: boolean;
    /**
     * Either `true` to make this repo available as a template repository or `false` to prevent it.
     */
    is_template?: boolean;
    /**
     * Updates the default branch for this repository.
     */
    default_branch?: string;
    /**
     * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
     */
    allow_squash_merge?: boolean;
    /**
     * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
     */
    allow_merge_commit?: boolean;
    /**
     * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
     */
    allow_rebase_merge?: boolean;
    /**
     * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
     */
    delete_branch_on_merge?: boolean;
    /**
     * `true` to archive this repository. **Note**: You cannot unarchive repositories through the API.
     */
    archived?: boolean;
};
declare type ReposUpdateRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposUpdateResponseDataSourcePermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ReposUpdateResponseDataSourceOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateResponseDataSource = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposUpdateResponseDataSourceOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposUpdateResponseDataSourcePermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type ReposUpdateResponseDataParentPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ReposUpdateResponseDataParentOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateResponseDataParent = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposUpdateResponseDataParentOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposUpdateResponseDataParentPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type ReposUpdateResponseDataOrganization = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateResponseDataPermissions = {
    pull: boolean;
    triage: boolean;
    push: boolean;
    maintain: boolean;
    admin: boolean;
};
declare type ReposUpdateResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateResponseData = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposUpdateResponseDataOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposUpdateResponseDataPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
    organization: ReposUpdateResponseDataOrganization;
    parent: ReposUpdateResponseDataParent;
    source: ReposUpdateResponseDataSource;
};
declare type ReposDeleteEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposDeleteRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeleteResponseData = {
    message: string;
    documentation_url: string;
};
declare type ActionsListArtifactsForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListArtifactsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/artifacts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListArtifactsForRepoResponseDataArtifactsItem = {
    id: number;
    node_id: string;
    name: string;
    size_in_bytes: number;
    url: string;
    archive_download_url: string;
    expired: boolean;
    created_at: string;
    expires_at: string;
};
declare type ActionsListArtifactsForRepoResponseData = {
    total_count: number;
    artifacts: Array<ActionsListArtifactsForRepoResponseDataArtifactsItem>;
};
declare type ActionsGetArtifactEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * artifact_id parameter
     */
    artifact_id: number;
};
declare type ActionsGetArtifactRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/artifacts/:artifact_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsGetArtifactResponseData = {
    id: number;
    node_id: string;
    name: string;
    size_in_bytes: number;
    url: string;
    archive_download_url: string;
    expired: boolean;
    created_at: string;
    expires_at: string;
};
declare type ActionsDeleteArtifactEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * artifact_id parameter
     */
    artifact_id: number;
};
declare type ActionsDeleteArtifactRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/actions/artifacts/:artifact_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDownloadArtifactEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * artifact_id parameter
     */
    artifact_id: number;
    /**
     * archive_format parameter
     */
    archive_format: string;
};
declare type ActionsDownloadArtifactRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/artifacts/:artifact_id/:archive_format";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsGetWorkflowJobEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * job_id parameter
     */
    job_id: number;
};
declare type ActionsGetWorkflowJobRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/jobs/:job_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsGetWorkflowJobResponseDataStepsItem = {
    name: string;
    status: string;
    conclusion: string;
    number: number;
    started_at: string;
    completed_at: string;
};
declare type ActionsGetWorkflowJobResponseData = {
    id: number;
    run_id: number;
    run_url: string;
    node_id: string;
    head_sha: string;
    url: string;
    html_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    name: string;
    steps: Array<ActionsGetWorkflowJobResponseDataStepsItem>;
    check_run_url: string;
};
declare type ActionsDownloadWorkflowJobLogsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * job_id parameter
     */
    job_id: number;
};
declare type ActionsDownloadWorkflowJobLogsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/jobs/:job_id/logs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListSelfHostedRunnersForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListSelfHostedRunnersForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runners";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListSelfHostedRunnersForRepoResponseDataRunnersItem = {
    id: number;
    name: string;
    os: string;
    status: string;
};
declare type ActionsListSelfHostedRunnersForRepoResponseData = {
    total_count: number;
    runners: Array<ActionsListSelfHostedRunnersForRepoResponseDataRunnersItem>;
};
declare type ActionsListRunnerApplicationsForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ActionsListRunnerApplicationsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runners/downloads";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListRunnerApplicationsForRepoResponseDataItem = {
    os: string;
    architecture: string;
    download_url: string;
    filename: string;
};
declare type ActionsListRunnerApplicationsForRepoResponseData = Array<ActionsListRunnerApplicationsForRepoResponseDataItem>;
declare type ActionsCreateRegistrationTokenForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ActionsCreateRegistrationTokenForRepoRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/actions/runners/registration-token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsCreateRegistrationTokenForRepoResponseData = {
    token: string;
    expires_at: string;
};
declare type ActionsCreateRemoveTokenForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ActionsCreateRemoveTokenForRepoRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/actions/runners/remove-token";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsCreateRemoveTokenForRepoResponseData = {
    token: string;
    expires_at: string;
};
declare type ActionsGetSelfHostedRunnerForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * runner_id parameter
     */
    runner_id: number;
};
declare type ActionsGetSelfHostedRunnerForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsGetSelfHostedRunnerForRepoResponseData = {
    id: number;
    name: string;
    os: string;
    status: string;
};
declare type ActionsDeleteSelfHostedRunnerFromRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * runner_id parameter
     */
    runner_id: number;
};
declare type ActionsDeleteSelfHostedRunnerFromRepoRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/actions/runners/:runner_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListRepoWorkflowRunsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
     */
    actor?: string;
    /**
     * Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
     */
    branch?: string;
    /**
     * Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://help.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)" in the GitHub Help documentation.
     */
    event?: string;
    /**
     * Returns workflow runs associated with the check run `status` or `conclusion` you specify. For example, a conclusion can be `success` or a status can be `completed`. For more information, see the `status` and `conclusion` options available in "[Create a check run](https://developer.github.com/v3/checks/runs/#create-a-check-run)."
     */
    status?: "completed" | "status" | "conclusion";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListRepoWorkflowRunsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    private: boolean;
    owner: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadRepositoryOwner;
    html_url: string;
    description: null;
    fork: boolean;
    url: string;
    forks_url: string;
    keys_url: string;
    collaborators_url: string;
    teams_url: string;
    hooks_url: string;
    issue_events_url: string;
    events_url: string;
    assignees_url: string;
    branches_url: string;
    tags_url: string;
    blobs_url: string;
    git_tags_url: string;
    git_refs_url: string;
    trees_url: string;
    statuses_url: string;
    languages_url: string;
    stargazers_url: string;
    contributors_url: string;
    subscribers_url: string;
    subscription_url: string;
    commits_url: string;
    git_commits_url: string;
    comments_url: string;
    issue_comment_url: string;
    contents_url: string;
    compare_url: string;
    merges_url: string;
    archive_url: string;
    downloads_url: string;
    issues_url: string;
    pulls_url: string;
    milestones_url: string;
    notifications_url: string;
    labels_url: string;
    releases_url: string;
    deployments_url: string;
};
declare type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
};
declare type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadCommitCommitter = {
    name: string;
    email: string;
};
declare type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadCommitAuthor = {
    name: string;
    email: string;
};
declare type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadCommit = {
    id: string;
    tree_id: string;
    message: string;
    timestamp: string;
    author: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadCommitAuthor;
    committer: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadCommitCommitter;
};
declare type ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItem = {
    id: number;
    node_id: string;
    head_branch: string;
    head_sha: string;
    run_number: number;
    event: string;
    status: string;
    conclusion: null;
    url: string;
    html_url: string;
    pull_requests: Array<any>;
    created_at: string;
    updated_at: string;
    jobs_url: string;
    logs_url: string;
    check_suite_url: string;
    artifacts_url: string;
    cancel_url: string;
    rerun_url: string;
    workflow_url: string;
    head_commit: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadCommit;
    repository: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemRepository;
    head_repository: ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItemHeadRepository;
};
declare type ActionsListRepoWorkflowRunsResponseData = {
    total_count: number;
    workflow_runs: Array<ActionsListRepoWorkflowRunsResponseDataWorkflowRunsItem>;
};
declare type ActionsGetWorkflowRunEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * run_id parameter
     */
    run_id: number;
};
declare type ActionsGetWorkflowRunRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runs/:run_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsGetWorkflowRunResponseDataHeadRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ActionsGetWorkflowRunResponseDataHeadRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    private: boolean;
    owner: ActionsGetWorkflowRunResponseDataHeadRepositoryOwner;
    html_url: string;
    description: null;
    fork: boolean;
    url: string;
    forks_url: string;
    keys_url: string;
    collaborators_url: string;
    teams_url: string;
    hooks_url: string;
    issue_events_url: string;
    events_url: string;
    assignees_url: string;
    branches_url: string;
    tags_url: string;
    blobs_url: string;
    git_tags_url: string;
    git_refs_url: string;
    trees_url: string;
    statuses_url: string;
    languages_url: string;
    stargazers_url: string;
    contributors_url: string;
    subscribers_url: string;
    subscription_url: string;
    commits_url: string;
    git_commits_url: string;
    comments_url: string;
    issue_comment_url: string;
    contents_url: string;
    compare_url: string;
    merges_url: string;
    archive_url: string;
    downloads_url: string;
    issues_url: string;
    pulls_url: string;
    milestones_url: string;
    notifications_url: string;
    labels_url: string;
    releases_url: string;
    deployments_url: string;
};
declare type ActionsGetWorkflowRunResponseDataRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ActionsGetWorkflowRunResponseDataRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ActionsGetWorkflowRunResponseDataRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
};
declare type ActionsGetWorkflowRunResponseDataHeadCommitCommitter = {
    name: string;
    email: string;
};
declare type ActionsGetWorkflowRunResponseDataHeadCommitAuthor = {
    name: string;
    email: string;
};
declare type ActionsGetWorkflowRunResponseDataHeadCommit = {
    id: string;
    tree_id: string;
    message: string;
    timestamp: string;
    author: ActionsGetWorkflowRunResponseDataHeadCommitAuthor;
    committer: ActionsGetWorkflowRunResponseDataHeadCommitCommitter;
};
declare type ActionsGetWorkflowRunResponseData = {
    id: number;
    node_id: string;
    head_branch: string;
    head_sha: string;
    run_number: number;
    event: string;
    status: string;
    conclusion: null;
    url: string;
    html_url: string;
    pull_requests: Array<any>;
    created_at: string;
    updated_at: string;
    jobs_url: string;
    logs_url: string;
    check_suite_url: string;
    artifacts_url: string;
    cancel_url: string;
    rerun_url: string;
    workflow_url: string;
    head_commit: ActionsGetWorkflowRunResponseDataHeadCommit;
    repository: ActionsGetWorkflowRunResponseDataRepository;
    head_repository: ActionsGetWorkflowRunResponseDataHeadRepository;
};
declare type ActionsListWorkflowRunArtifactsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * run_id parameter
     */
    run_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListWorkflowRunArtifactsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runs/:run_id/artifacts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListWorkflowRunArtifactsResponseDataArtifactsItem = {
    id: number;
    node_id: string;
    name: string;
    size_in_bytes: number;
    url: string;
    archive_download_url: string;
    expired: boolean;
    created_at: string;
    expires_at: string;
};
declare type ActionsListWorkflowRunArtifactsResponseData = {
    total_count: number;
    artifacts: Array<ActionsListWorkflowRunArtifactsResponseDataArtifactsItem>;
};
declare type ActionsCancelWorkflowRunEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * run_id parameter
     */
    run_id: number;
};
declare type ActionsCancelWorkflowRunRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/actions/runs/:run_id/cancel";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListJobsForWorkflowRunEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * run_id parameter
     */
    run_id: number;
    /**
     * Filters jobs by their `completed_at` timestamp. Can be one of:
     * \* `latest`: Returns jobs from the most recent execution of the workflow run.
     * \* `all`: Returns all jobs for a workflow run, including from old executions of the workflow run.
     */
    filter?: "latest" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListJobsForWorkflowRunRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runs/:run_id/jobs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListJobsForWorkflowRunResponseDataJobsItemStepsItem = {
    name: string;
    status: string;
    conclusion: string;
    number: number;
    started_at: string;
    completed_at: string;
};
declare type ActionsListJobsForWorkflowRunResponseDataJobsItem = {
    id: number;
    run_id: number;
    run_url: string;
    node_id: string;
    head_sha: string;
    url: string;
    html_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    name: string;
    steps: Array<ActionsListJobsForWorkflowRunResponseDataJobsItemStepsItem>;
    check_run_url: string;
};
declare type ActionsListJobsForWorkflowRunResponseData = {
    total_count: number;
    jobs: Array<ActionsListJobsForWorkflowRunResponseDataJobsItem>;
};
declare type ActionsDownloadWorkflowRunLogsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * run_id parameter
     */
    run_id: number;
};
declare type ActionsDownloadWorkflowRunLogsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/runs/:run_id/logs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDeleteWorkflowRunLogsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * run_id parameter
     */
    run_id: number;
};
declare type ActionsDeleteWorkflowRunLogsRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/actions/runs/:run_id/logs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsReRunWorkflowEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * run_id parameter
     */
    run_id: number;
};
declare type ActionsReRunWorkflowRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/actions/runs/:run_id/rerun";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListSecretsForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListSecretsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/secrets";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListSecretsForRepoResponseDataSecretsItem = {
    name: string;
    created_at: string;
    updated_at: string;
};
declare type ActionsListSecretsForRepoResponseData = {
    total_count: number;
    secrets: Array<ActionsListSecretsForRepoResponseDataSecretsItem>;
};
declare type ActionsGetPublicKeyEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ActionsGetPublicKeyRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/secrets/public-key";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsGetPublicKeyResponseData = {
    key_id: string;
    key: string;
};
declare type ActionsGetSecretEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * name parameter
     */
    name: string;
};
declare type ActionsGetSecretRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/secrets/:name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsGetSecretResponseData = {
    name: string;
    created_at: string;
    updated_at: string;
};
declare type ActionsCreateOrUpdateSecretForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * name parameter
     */
    name: string;
    /**
     * Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get your public key](https://developer.github.com/v3/actions/secrets/#get-your-public-key) endpoint.
     */
    encrypted_value?: string;
    /**
     * ID of the key you used to encrypt the secret.
     */
    key_id?: string;
};
declare type ActionsCreateOrUpdateSecretForRepoRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/actions/secrets/:name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsDeleteSecretFromRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * name parameter
     */
    name: string;
};
declare type ActionsDeleteSecretFromRepoRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/actions/secrets/:name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListRepoWorkflowsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListRepoWorkflowsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/workflows";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListRepoWorkflowsResponseDataWorkflowsItem = {
    id: number;
    node_id: string;
    name: string;
    path: string;
    state: string;
    created_at: string;
    updated_at: string;
    url: string;
    html_url: string;
    badge_url: string;
};
declare type ActionsListRepoWorkflowsResponseData = {
    total_count: number;
    workflows: Array<ActionsListRepoWorkflowsResponseDataWorkflowsItem>;
};
declare type ActionsGetWorkflowEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * workflow_id parameter
     */
    workflow_id: number;
};
declare type ActionsGetWorkflowRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/workflows/:workflow_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsGetWorkflowResponseData = {
    id: number;
    node_id: string;
    name: string;
    path: string;
    state: string;
    created_at: string;
    updated_at: string;
    url: string;
    html_url: string;
    badge_url: string;
};
declare type ActionsListWorkflowRunsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * workflow_id parameter
     */
    workflow_id: number;
    /**
     * Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
     */
    actor?: string;
    /**
     * Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
     */
    branch?: string;
    /**
     * Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://help.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)" in the GitHub Help documentation.
     */
    event?: string;
    /**
     * Returns workflow runs associated with the check run `status` or `conclusion` you specify. For example, a conclusion can be `success` or a status can be `completed`. For more information, see the `status` and `conclusion` options available in "[Create a check run](https://developer.github.com/v3/checks/runs/#create-a-check-run)."
     */
    status?: "completed" | "status" | "conclusion";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActionsListWorkflowRunsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/actions/workflows/:workflow_id/runs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    private: boolean;
    owner: ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadRepositoryOwner;
    html_url: string;
    description: null;
    fork: boolean;
    url: string;
    forks_url: string;
    keys_url: string;
    collaborators_url: string;
    teams_url: string;
    hooks_url: string;
    issue_events_url: string;
    events_url: string;
    assignees_url: string;
    branches_url: string;
    tags_url: string;
    blobs_url: string;
    git_tags_url: string;
    git_refs_url: string;
    trees_url: string;
    statuses_url: string;
    languages_url: string;
    stargazers_url: string;
    contributors_url: string;
    subscribers_url: string;
    subscription_url: string;
    commits_url: string;
    git_commits_url: string;
    comments_url: string;
    issue_comment_url: string;
    contents_url: string;
    compare_url: string;
    merges_url: string;
    archive_url: string;
    downloads_url: string;
    issues_url: string;
    pulls_url: string;
    milestones_url: string;
    notifications_url: string;
    labels_url: string;
    releases_url: string;
    deployments_url: string;
};
declare type ActionsListWorkflowRunsResponseDataWorkflowRunsItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ActionsListWorkflowRunsResponseDataWorkflowRunsItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ActionsListWorkflowRunsResponseDataWorkflowRunsItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
};
declare type ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadCommitCommitter = {
    name: string;
    email: string;
};
declare type ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadCommitAuthor = {
    name: string;
    email: string;
};
declare type ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadCommit = {
    id: string;
    tree_id: string;
    message: string;
    timestamp: string;
    author: ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadCommitAuthor;
    committer: ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadCommitCommitter;
};
declare type ActionsListWorkflowRunsResponseDataWorkflowRunsItem = {
    id: number;
    node_id: string;
    head_branch: string;
    head_sha: string;
    run_number: number;
    event: string;
    status: string;
    conclusion: null;
    url: string;
    html_url: string;
    pull_requests: Array<any>;
    created_at: string;
    updated_at: string;
    jobs_url: string;
    logs_url: string;
    check_suite_url: string;
    artifacts_url: string;
    cancel_url: string;
    rerun_url: string;
    workflow_url: string;
    head_commit: ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadCommit;
    repository: ActionsListWorkflowRunsResponseDataWorkflowRunsItemRepository;
    head_repository: ActionsListWorkflowRunsResponseDataWorkflowRunsItemHeadRepository;
};
declare type ActionsListWorkflowRunsResponseData = {
    total_count: number;
    workflow_runs: Array<ActionsListWorkflowRunsResponseDataWorkflowRunsItem>;
};
declare type IssuesListAssigneesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListAssigneesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/assignees";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListAssigneesResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListAssigneesResponseData = Array<IssuesListAssigneesResponseDataItem>;
declare type IssuesCheckAssigneeEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * assignee parameter
     */
    assignee: string;
};
declare type IssuesCheckAssigneeRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/assignees/:assignee";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposEnableAutomatedSecurityFixesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
} & RequiredPreview<"london">;
declare type ReposEnableAutomatedSecurityFixesRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/automated-security-fixes";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDisableAutomatedSecurityFixesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
} & RequiredPreview<"london">;
declare type ReposDisableAutomatedSecurityFixesRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/automated-security-fixes";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListBranchesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Setting to `true` returns only protected branches. When set to `false`, only unprotected branches are returned. Omitting this parameter returns all branches.
     */
    protected?: boolean;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListBranchesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListBranchesResponseDataItemProtectionRequiredStatusChecks = {
    enforcement_level: string;
    contexts: Array<string>;
};
declare type ReposListBranchesResponseDataItemProtection = {
    enabled: boolean;
    required_status_checks: ReposListBranchesResponseDataItemProtectionRequiredStatusChecks;
};
declare type ReposListBranchesResponseDataItemCommit = {
    sha: string;
    url: string;
};
declare type ReposListBranchesResponseDataItem = {
    name: string;
    commit: ReposListBranchesResponseDataItemCommit;
    protected: boolean;
    protection: ReposListBranchesResponseDataItemProtection;
    protection_url: string;
};
declare type ReposListBranchesResponseData = Array<ReposListBranchesResponseDataItem>;
declare type ReposGetBranchEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposGetBranchRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetBranchResponseDataProtectionRequiredStatusChecks = {
    enforcement_level: string;
    contexts: Array<string>;
};
declare type ReposGetBranchResponseDataProtection = {
    enabled: boolean;
    required_status_checks: ReposGetBranchResponseDataProtectionRequiredStatusChecks;
};
declare type ReposGetBranchResponseDataLinks = {
    html: string;
    self: string;
};
declare type ReposGetBranchResponseDataCommitCommitter = {
    gravatar_id: string;
    avatar_url: string;
    url: string;
    id: number;
    login: string;
};
declare type ReposGetBranchResponseDataCommitParentsItem = {
    sha: string;
    url: string;
};
declare type ReposGetBranchResponseDataCommitAuthor = {
    gravatar_id: string;
    avatar_url: string;
    url: string;
    id: number;
    login: string;
};
declare type ReposGetBranchResponseDataCommitCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type ReposGetBranchResponseDataCommitCommitCommitter = {
    name: string;
    date: string;
    email: string;
};
declare type ReposGetBranchResponseDataCommitCommitTree = {
    sha: string;
    url: string;
};
declare type ReposGetBranchResponseDataCommitCommitAuthor = {
    name: string;
    date: string;
    email: string;
};
declare type ReposGetBranchResponseDataCommitCommit = {
    author: ReposGetBranchResponseDataCommitCommitAuthor;
    url: string;
    message: string;
    tree: ReposGetBranchResponseDataCommitCommitTree;
    committer: ReposGetBranchResponseDataCommitCommitCommitter;
    verification: ReposGetBranchResponseDataCommitCommitVerification;
};
declare type ReposGetBranchResponseDataCommit = {
    sha: string;
    node_id: string;
    commit: ReposGetBranchResponseDataCommitCommit;
    author: ReposGetBranchResponseDataCommitAuthor;
    parents: Array<ReposGetBranchResponseDataCommitParentsItem>;
    url: string;
    committer: ReposGetBranchResponseDataCommitCommitter;
};
declare type ReposGetBranchResponseData = {
    name: string;
    commit: ReposGetBranchResponseDataCommit;
    _links: ReposGetBranchResponseDataLinks;
    protected: boolean;
    protection: ReposGetBranchResponseDataProtection;
    protection_url: string;
};
declare type ReposGetBranchProtectionEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposGetBranchProtectionRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetBranchProtectionResponseDataAllowDeletions = {
    enabled: boolean;
};
declare type ReposGetBranchProtectionResponseDataAllowForcePushes = {
    enabled: boolean;
};
declare type ReposGetBranchProtectionResponseDataRequiredLinearHistory = {
    enabled: boolean;
};
declare type ReposGetBranchProtectionResponseDataRestrictionsAppsItemPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ReposGetBranchProtectionResponseDataRestrictionsAppsItemOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ReposGetBranchProtectionResponseDataRestrictionsAppsItem = {
    id: number;
    slug: string;
    node_id: string;
    owner: ReposGetBranchProtectionResponseDataRestrictionsAppsItemOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ReposGetBranchProtectionResponseDataRestrictionsAppsItemPermissions;
    events: Array<string>;
};
declare type ReposGetBranchProtectionResponseDataRestrictionsTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type ReposGetBranchProtectionResponseDataRestrictionsUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetBranchProtectionResponseDataRestrictions = {
    url: string;
    users_url: string;
    teams_url: string;
    apps_url: string;
    users: Array<ReposGetBranchProtectionResponseDataRestrictionsUsersItem>;
    teams: Array<ReposGetBranchProtectionResponseDataRestrictionsTeamsItem>;
    apps: Array<ReposGetBranchProtectionResponseDataRestrictionsAppsItem>;
};
declare type ReposGetBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type ReposGetBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictions = {
    url: string;
    users_url: string;
    teams_url: string;
    users: Array<ReposGetBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsUsersItem>;
    teams: Array<ReposGetBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsTeamsItem>;
};
declare type ReposGetBranchProtectionResponseDataRequiredPullRequestReviews = {
    url: string;
    dismissal_restrictions: ReposGetBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictions;
    dismiss_stale_reviews: boolean;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
};
declare type ReposGetBranchProtectionResponseDataEnforceAdmins = {
    url: string;
    enabled: boolean;
};
declare type ReposGetBranchProtectionResponseDataRequiredStatusChecks = {
    url: string;
    strict: boolean;
    contexts: Array<string>;
    contexts_url: string;
};
declare type ReposGetBranchProtectionResponseData = {
    url: string;
    required_status_checks: ReposGetBranchProtectionResponseDataRequiredStatusChecks;
    enforce_admins: ReposGetBranchProtectionResponseDataEnforceAdmins;
    required_pull_request_reviews: ReposGetBranchProtectionResponseDataRequiredPullRequestReviews;
    restrictions: ReposGetBranchProtectionResponseDataRestrictions;
    required_linear_history: ReposGetBranchProtectionResponseDataRequiredLinearHistory;
    allow_force_pushes: ReposGetBranchProtectionResponseDataAllowForcePushes;
    allow_deletions: ReposGetBranchProtectionResponseDataAllowDeletions;
};
declare type ReposUpdateBranchProtectionEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * Require status checks to pass before merging. Set to `null` to disable.
     */
    required_status_checks: ReposUpdateBranchProtectionParamsRequiredStatusChecks | null;
    /**
     * Enforce all configured restrictions for administrators. Set to `true` to enforce required status checks for repository administrators. Set to `null` to disable.
     */
    enforce_admins: boolean | null;
    /**
     * Require at least one approving review on a pull request, before merging. Set to `null` to disable.
     */
    required_pull_request_reviews: ReposUpdateBranchProtectionParamsRequiredPullRequestReviews | null;
    /**
     * Restrict who can push to the protected branch. User, app, and team `restrictions` are only available for organization-owned repositories. Set to `null` to disable.
     */
    restrictions: ReposUpdateBranchProtectionParamsRestrictions | null;
    /**
     * Enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch. Set to `true` to enforce a linear commit history. Set to `false` to disable a linear commit Git history. Your repository must allow squash merging or rebase merging before you can enable a linear commit history. Default: `false`. For more information, see "[Requiring a linear commit history](https://help.github.com/github/administering-a-repository/requiring-a-linear-commit-history)" in the GitHub Help documentation.
     */
    required_linear_history?: boolean;
    /**
     * Permits force pushes to the protected branch by anyone with write access to the repository. Set to `true` to allow force pushes. Set to `false` or `null` to block force pushes. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation."
     */
    allow_force_pushes?: boolean | null;
    /**
     * Allows deletion of the protected branch by anyone with write access to the repository. Set to `false` to prevent deletion of the protected branch. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation.
     */
    allow_deletions?: boolean;
};
declare type ReposUpdateBranchProtectionRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/branches/:branch/protection";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposUpdateBranchProtectionResponseDataAllowDeletions = {
    enabled: boolean;
};
declare type ReposUpdateBranchProtectionResponseDataAllowForcePushes = {
    enabled: boolean;
};
declare type ReposUpdateBranchProtectionResponseDataRequiredLinearHistory = {
    enabled: boolean;
};
declare type ReposUpdateBranchProtectionResponseDataRestrictionsAppsItemPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ReposUpdateBranchProtectionResponseDataRestrictionsAppsItemOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ReposUpdateBranchProtectionResponseDataRestrictionsAppsItem = {
    id: number;
    slug: string;
    node_id: string;
    owner: ReposUpdateBranchProtectionResponseDataRestrictionsAppsItemOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ReposUpdateBranchProtectionResponseDataRestrictionsAppsItemPermissions;
    events: Array<string>;
};
declare type ReposUpdateBranchProtectionResponseDataRestrictionsTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type ReposUpdateBranchProtectionResponseDataRestrictionsUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateBranchProtectionResponseDataRestrictions = {
    url: string;
    users_url: string;
    teams_url: string;
    apps_url: string;
    users: Array<ReposUpdateBranchProtectionResponseDataRestrictionsUsersItem>;
    teams: Array<ReposUpdateBranchProtectionResponseDataRestrictionsTeamsItem>;
    apps: Array<ReposUpdateBranchProtectionResponseDataRestrictionsAppsItem>;
};
declare type ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictions = {
    url: string;
    users_url: string;
    teams_url: string;
    users: Array<ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsUsersItem>;
    teams: Array<ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictionsTeamsItem>;
};
declare type ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviews = {
    url: string;
    dismissal_restrictions: ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviewsDismissalRestrictions;
    dismiss_stale_reviews: boolean;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
};
declare type ReposUpdateBranchProtectionResponseDataEnforceAdmins = {
    url: string;
    enabled: boolean;
};
declare type ReposUpdateBranchProtectionResponseDataRequiredStatusChecks = {
    url: string;
    strict: boolean;
    contexts: Array<string>;
    contexts_url: string;
};
declare type ReposUpdateBranchProtectionResponseData = {
    url: string;
    required_status_checks: ReposUpdateBranchProtectionResponseDataRequiredStatusChecks;
    enforce_admins: ReposUpdateBranchProtectionResponseDataEnforceAdmins;
    required_pull_request_reviews: ReposUpdateBranchProtectionResponseDataRequiredPullRequestReviews;
    restrictions: ReposUpdateBranchProtectionResponseDataRestrictions;
    required_linear_history: ReposUpdateBranchProtectionResponseDataRequiredLinearHistory;
    allow_force_pushes: ReposUpdateBranchProtectionResponseDataAllowForcePushes;
    allow_deletions: ReposUpdateBranchProtectionResponseDataAllowDeletions;
};
declare type ReposRemoveBranchProtectionEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposRemoveBranchProtectionRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetProtectedBranchAdminEnforcementEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposGetProtectedBranchAdminEnforcementRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/enforce_admins";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetProtectedBranchAdminEnforcementResponseData = {
    url: string;
    enabled: boolean;
};
declare type ReposAddProtectedBranchAdminEnforcementEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposAddProtectedBranchAdminEnforcementRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/branches/:branch/protection/enforce_admins";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposAddProtectedBranchAdminEnforcementResponseData = {
    url: string;
    enabled: boolean;
};
declare type ReposRemoveProtectedBranchAdminEnforcementEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposRemoveProtectedBranchAdminEnforcementRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection/enforce_admins";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetProtectedBranchPullRequestReviewEnforcementEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposGetProtectedBranchPullRequestReviewEnforcementRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type ReposGetProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictions = {
    url: string;
    users_url: string;
    teams_url: string;
    users: Array<ReposGetProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsUsersItem>;
    teams: Array<ReposGetProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsTeamsItem>;
};
declare type ReposGetProtectedBranchPullRequestReviewEnforcementResponseData = {
    url: string;
    dismissal_restrictions: ReposGetProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictions;
    dismiss_stale_reviews: boolean;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
};
declare type ReposUpdateProtectedBranchPullRequestReviewEnforcementEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * Specify which users and teams can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.
     */
    dismissal_restrictions?: ReposUpdateProtectedBranchPullRequestReviewEnforcementParamsDismissalRestrictions;
    /**
     * Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.
     */
    dismiss_stale_reviews?: boolean;
    /**
     * Blocks merging pull requests until [code owners](https://help.github.com/articles/about-code-owners/) have reviewed.
     */
    require_code_owner_reviews?: boolean;
    /**
     * Specifies the number of reviewers required to approve pull requests. Use a number between 1 and 6.
     */
    required_approving_review_count?: number;
};
declare type ReposUpdateProtectedBranchPullRequestReviewEnforcementRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictions = {
    url: string;
    users_url: string;
    teams_url: string;
    users: Array<ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsUsersItem>;
    teams: Array<ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictionsTeamsItem>;
};
declare type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseData = {
    url: string;
    dismissal_restrictions: ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDataDismissalRestrictions;
    dismiss_stale_reviews: boolean;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
};
declare type ReposRemoveProtectedBranchPullRequestReviewEnforcementEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposRemoveProtectedBranchPullRequestReviewEnforcementRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_pull_request_reviews";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetProtectedBranchRequiredSignaturesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
} & RequiredPreview<"zzzax">;
declare type ReposGetProtectedBranchRequiredSignaturesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_signatures";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetProtectedBranchRequiredSignaturesResponseData = {
    url: string;
    enabled: boolean;
};
declare type ReposAddProtectedBranchRequiredSignaturesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
} & RequiredPreview<"zzzax">;
declare type ReposAddProtectedBranchRequiredSignaturesRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_signatures";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposAddProtectedBranchRequiredSignaturesResponseData = {
    url: string;
    enabled: boolean;
};
declare type ReposRemoveProtectedBranchRequiredSignaturesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
} & RequiredPreview<"zzzax">;
declare type ReposRemoveProtectedBranchRequiredSignaturesRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_signatures";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetProtectedBranchRequiredStatusChecksEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposGetProtectedBranchRequiredStatusChecksRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetProtectedBranchRequiredStatusChecksResponseData = {
    url: string;
    strict: boolean;
    contexts: Array<string>;
    contexts_url: string;
};
declare type ReposUpdateProtectedBranchRequiredStatusChecksEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * Require branches to be up to date before merging.
     */
    strict?: boolean;
    /**
     * The list of status checks to require in order to merge into this branch
     */
    contexts?: string[];
};
declare type ReposUpdateProtectedBranchRequiredStatusChecksRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposUpdateProtectedBranchRequiredStatusChecksResponseData = {
    url: string;
    strict: boolean;
    contexts: Array<string>;
    contexts_url: string;
};
declare type ReposRemoveProtectedBranchRequiredStatusChecksEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposRemoveProtectedBranchRequiredStatusChecksRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListProtectedBranchRequiredStatusChecksContextsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposListProtectedBranchRequiredStatusChecksContextsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListProtectedBranchRequiredStatusChecksContextsResponseData = Array<string>;
declare type ReposReplaceProtectedBranchRequiredStatusChecksContextsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * contexts parameter
     */
    contexts: string[];
};
declare type ReposReplaceProtectedBranchRequiredStatusChecksContextsRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposReplaceProtectedBranchRequiredStatusChecksContextsResponseData = Array<string>;
declare type ReposAddProtectedBranchRequiredStatusChecksContextsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * contexts parameter
     */
    contexts: string[];
};
declare type ReposAddProtectedBranchRequiredStatusChecksContextsRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposAddProtectedBranchRequiredStatusChecksContextsResponseData = Array<string>;
declare type ReposRemoveProtectedBranchRequiredStatusChecksContextsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * contexts parameter
     */
    contexts: string[];
};
declare type ReposRemoveProtectedBranchRequiredStatusChecksContextsRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection/required_status_checks/contexts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposRemoveProtectedBranchRequiredStatusChecksContextsResponseData = Array<string>;
declare type ReposGetProtectedBranchRestrictionsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposGetProtectedBranchRestrictionsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetProtectedBranchRestrictionsResponseDataAppsItemPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ReposGetProtectedBranchRestrictionsResponseDataAppsItemOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ReposGetProtectedBranchRestrictionsResponseDataAppsItem = {
    id: number;
    slug: string;
    node_id: string;
    owner: ReposGetProtectedBranchRestrictionsResponseDataAppsItemOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ReposGetProtectedBranchRestrictionsResponseDataAppsItemPermissions;
    events: Array<string>;
};
declare type ReposGetProtectedBranchRestrictionsResponseDataTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type ReposGetProtectedBranchRestrictionsResponseDataUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetProtectedBranchRestrictionsResponseData = {
    url: string;
    users_url: string;
    teams_url: string;
    apps_url: string;
    users: Array<ReposGetProtectedBranchRestrictionsResponseDataUsersItem>;
    teams: Array<ReposGetProtectedBranchRestrictionsResponseDataTeamsItem>;
    apps: Array<ReposGetProtectedBranchRestrictionsResponseDataAppsItem>;
};
declare type ReposRemoveProtectedBranchRestrictionsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposRemoveProtectedBranchRestrictionsRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetAppsWithAccessToProtectedBranchEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposGetAppsWithAccessToProtectedBranchRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/apps";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetAppsWithAccessToProtectedBranchResponseDataItemPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ReposGetAppsWithAccessToProtectedBranchResponseDataItemOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ReposGetAppsWithAccessToProtectedBranchResponseDataItem = {
    id: number;
    slug: string;
    node_id: string;
    owner: ReposGetAppsWithAccessToProtectedBranchResponseDataItemOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ReposGetAppsWithAccessToProtectedBranchResponseDataItemPermissions;
    events: Array<string>;
};
declare type ReposGetAppsWithAccessToProtectedBranchResponseData = Array<ReposGetAppsWithAccessToProtectedBranchResponseDataItem>;
declare type ReposReplaceProtectedBranchAppRestrictionsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * apps parameter
     */
    apps: string[];
};
declare type ReposReplaceProtectedBranchAppRestrictionsRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/apps";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposReplaceProtectedBranchAppRestrictionsResponseDataItemPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ReposReplaceProtectedBranchAppRestrictionsResponseDataItemOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ReposReplaceProtectedBranchAppRestrictionsResponseDataItem = {
    id: number;
    slug: string;
    node_id: string;
    owner: ReposReplaceProtectedBranchAppRestrictionsResponseDataItemOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ReposReplaceProtectedBranchAppRestrictionsResponseDataItemPermissions;
    events: Array<string>;
};
declare type ReposReplaceProtectedBranchAppRestrictionsResponseData = Array<ReposReplaceProtectedBranchAppRestrictionsResponseDataItem>;
declare type ReposAddProtectedBranchAppRestrictionsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * apps parameter
     */
    apps: string[];
};
declare type ReposAddProtectedBranchAppRestrictionsRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/apps";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposAddProtectedBranchAppRestrictionsResponseDataItemPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ReposAddProtectedBranchAppRestrictionsResponseDataItemOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ReposAddProtectedBranchAppRestrictionsResponseDataItem = {
    id: number;
    slug: string;
    node_id: string;
    owner: ReposAddProtectedBranchAppRestrictionsResponseDataItemOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ReposAddProtectedBranchAppRestrictionsResponseDataItemPermissions;
    events: Array<string>;
};
declare type ReposAddProtectedBranchAppRestrictionsResponseData = Array<ReposAddProtectedBranchAppRestrictionsResponseDataItem>;
declare type ReposRemoveProtectedBranchAppRestrictionsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * apps parameter
     */
    apps: string[];
};
declare type ReposRemoveProtectedBranchAppRestrictionsRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/apps";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposRemoveProtectedBranchAppRestrictionsResponseDataItemPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ReposRemoveProtectedBranchAppRestrictionsResponseDataItemOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ReposRemoveProtectedBranchAppRestrictionsResponseDataItem = {
    id: number;
    slug: string;
    node_id: string;
    owner: ReposRemoveProtectedBranchAppRestrictionsResponseDataItemOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ReposRemoveProtectedBranchAppRestrictionsResponseDataItemPermissions;
    events: Array<string>;
};
declare type ReposRemoveProtectedBranchAppRestrictionsResponseData = Array<ReposRemoveProtectedBranchAppRestrictionsResponseDataItem>;
declare type ReposGetTeamsWithAccessToProtectedBranchEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposGetTeamsWithAccessToProtectedBranchRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/teams";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetTeamsWithAccessToProtectedBranchResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type ReposGetTeamsWithAccessToProtectedBranchResponseData = Array<ReposGetTeamsWithAccessToProtectedBranchResponseDataItem>;
declare type ReposReplaceProtectedBranchTeamRestrictionsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * teams parameter
     */
    teams: string[];
};
declare type ReposReplaceProtectedBranchTeamRestrictionsRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/teams";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposReplaceProtectedBranchTeamRestrictionsResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type ReposReplaceProtectedBranchTeamRestrictionsResponseData = Array<ReposReplaceProtectedBranchTeamRestrictionsResponseDataItem>;
declare type ReposAddProtectedBranchTeamRestrictionsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * teams parameter
     */
    teams: string[];
};
declare type ReposAddProtectedBranchTeamRestrictionsRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/teams";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposAddProtectedBranchTeamRestrictionsResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type ReposAddProtectedBranchTeamRestrictionsResponseData = Array<ReposAddProtectedBranchTeamRestrictionsResponseDataItem>;
declare type ReposRemoveProtectedBranchTeamRestrictionsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * teams parameter
     */
    teams: string[];
};
declare type ReposRemoveProtectedBranchTeamRestrictionsRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/teams";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposRemoveProtectedBranchTeamRestrictionsResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type ReposRemoveProtectedBranchTeamRestrictionsResponseData = Array<ReposRemoveProtectedBranchTeamRestrictionsResponseDataItem>;
declare type ReposGetUsersWithAccessToProtectedBranchEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
};
declare type ReposGetUsersWithAccessToProtectedBranchRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/users";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetUsersWithAccessToProtectedBranchResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetUsersWithAccessToProtectedBranchResponseData = Array<ReposGetUsersWithAccessToProtectedBranchResponseDataItem>;
declare type ReposReplaceProtectedBranchUserRestrictionsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * users parameter
     */
    users: string[];
};
declare type ReposReplaceProtectedBranchUserRestrictionsRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/users";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposReplaceProtectedBranchUserRestrictionsResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposReplaceProtectedBranchUserRestrictionsResponseData = Array<ReposReplaceProtectedBranchUserRestrictionsResponseDataItem>;
declare type ReposAddProtectedBranchUserRestrictionsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * users parameter
     */
    users: string[];
};
declare type ReposAddProtectedBranchUserRestrictionsRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/users";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposAddProtectedBranchUserRestrictionsResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposAddProtectedBranchUserRestrictionsResponseData = Array<ReposAddProtectedBranchUserRestrictionsResponseDataItem>;
declare type ReposRemoveProtectedBranchUserRestrictionsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * branch parameter
     */
    branch: string;
    /**
     * users parameter
     */
    users: string[];
};
declare type ReposRemoveProtectedBranchUserRestrictionsRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/branches/:branch/protection/restrictions/users";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposRemoveProtectedBranchUserRestrictionsResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposRemoveProtectedBranchUserRestrictionsResponseData = Array<ReposRemoveProtectedBranchUserRestrictionsResponseDataItem>;
declare type ChecksCreateEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The name of the check. For example, "code-coverage".
     */
    name: string;
    /**
     * The SHA of the commit.
     */
    head_sha: string;
    /**
     * The URL of the integrator's site that has the full details of the check. If the integrator does not provide this, then the homepage of the GitHub app is used.
     */
    details_url?: string;
    /**
     * A reference for the run on the integrator's system.
     */
    external_id?: string;
    /**
     * The current status. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
    /**
     * The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at?: string;
    /**
     * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `skipped`, `timed_out`, or `action_required`. When the conclusion is `action_required`, additional details should be provided on the site specified by `details_url`.
     * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. Only GitHub can change a check run conclusion to `stale`.
     */
    conclusion?: "success" | "failure" | "neutral" | "cancelled" | "skipped" | "timed_out" | "action_required";
    /**
     * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at?: string;
    /**
     * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://developer.github.com/v3/checks/runs/#output-object) description.
     */
    output?: ChecksCreateParamsOutput;
    /**
     * Displays a button on GitHub that can be clicked to alert your app to do additional tasks. For example, a code linting app can display a button that automatically fixes detected errors. The button created in this object is displayed after the check run completes. When a user clicks the button, GitHub sends the [`check_run.requested_action` webhook](https://developer.github.com/v3/activity/events/types/#checkrunevent) to your app. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://developer.github.com/v3/checks/runs/#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)." To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)."
     */
    actions?: ChecksCreateParamsActions[];
} & RequiredPreview<"antiope">;
declare type ChecksCreateRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/check-runs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ChecksCreateResponseDataPullRequestsItemBaseRepo = {
    id: number;
    url: string;
    name: string;
};
declare type ChecksCreateResponseDataPullRequestsItemBase = {
    ref: string;
    sha: string;
    repo: ChecksCreateResponseDataPullRequestsItemBaseRepo;
};
declare type ChecksCreateResponseDataPullRequestsItemHeadRepo = {
    id: number;
    url: string;
    name: string;
};
declare type ChecksCreateResponseDataPullRequestsItemHead = {
    ref: string;
    sha: string;
    repo: ChecksCreateResponseDataPullRequestsItemHeadRepo;
};
declare type ChecksCreateResponseDataPullRequestsItem = {
    url: string;
    id: number;
    number: number;
    head: ChecksCreateResponseDataPullRequestsItemHead;
    base: ChecksCreateResponseDataPullRequestsItemBase;
};
declare type ChecksCreateResponseDataAppPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ChecksCreateResponseDataAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ChecksCreateResponseDataApp = {
    id: number;
    slug: string;
    node_id: string;
    owner: ChecksCreateResponseDataAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksCreateResponseDataAppPermissions;
    events: Array<string>;
};
declare type ChecksCreateResponseDataCheckSuite = {
    id: number;
};
declare type ChecksCreateResponseDataOutput = {
    title: string;
    summary: string;
    text: string;
    annotations_count?: number;
    annotations_url?: string;
};
declare type ChecksCreateResponseData = {
    id: number;
    head_sha: string;
    node_id: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    status: string;
    conclusion: null | string;
    started_at: string;
    completed_at: null | string;
    output: ChecksCreateResponseDataOutput;
    name: string;
    check_suite: ChecksCreateResponseDataCheckSuite;
    app: ChecksCreateResponseDataApp;
    pull_requests: Array<ChecksCreateResponseDataPullRequestsItem>;
};
declare type ChecksUpdateEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * check_run_id parameter
     */
    check_run_id: number;
    /**
     * The name of the check. For example, "code-coverage".
     */
    name?: string;
    /**
     * The URL of the integrator's site that has the full details of the check.
     */
    details_url?: string;
    /**
     * A reference for the run on the integrator's system.
     */
    external_id?: string;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at?: string;
    /**
     * The current status. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
    /**
     * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `skipped`, `timed_out`, or `action_required`.
     * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. Only GitHub can change a check run conclusion to `stale`.
     */
    conclusion?: "success" | "failure" | "neutral" | "cancelled" | "skipped" | "timed_out" | "action_required";
    /**
     * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at?: string;
    /**
     * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://developer.github.com/v3/checks/runs/#output-object-1) description.
     */
    output?: ChecksUpdateParamsOutput;
    /**
     * Possible further actions the integrator can perform, which a user may trigger. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://developer.github.com/v3/checks/runs/#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)."
     */
    actions?: ChecksUpdateParamsActions[];
} & RequiredPreview<"antiope">;
declare type ChecksUpdateRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/check-runs/:check_run_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ChecksUpdateResponseDataPullRequestsItemBaseRepo = {
    id: number;
    url: string;
    name: string;
};
declare type ChecksUpdateResponseDataPullRequestsItemBase = {
    ref: string;
    sha: string;
    repo: ChecksUpdateResponseDataPullRequestsItemBaseRepo;
};
declare type ChecksUpdateResponseDataPullRequestsItemHeadRepo = {
    id: number;
    url: string;
    name: string;
};
declare type ChecksUpdateResponseDataPullRequestsItemHead = {
    ref: string;
    sha: string;
    repo: ChecksUpdateResponseDataPullRequestsItemHeadRepo;
};
declare type ChecksUpdateResponseDataPullRequestsItem = {
    url: string;
    id: number;
    number: number;
    head: ChecksUpdateResponseDataPullRequestsItemHead;
    base: ChecksUpdateResponseDataPullRequestsItemBase;
};
declare type ChecksUpdateResponseDataAppPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ChecksUpdateResponseDataAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ChecksUpdateResponseDataApp = {
    id: number;
    slug: string;
    node_id: string;
    owner: ChecksUpdateResponseDataAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksUpdateResponseDataAppPermissions;
    events: Array<string>;
};
declare type ChecksUpdateResponseDataCheckSuite = {
    id: number;
};
declare type ChecksUpdateResponseDataOutput = {
    title: string;
    summary: string;
    text: string;
    annotations_count: number;
    annotations_url: string;
};
declare type ChecksUpdateResponseData = {
    id: number;
    head_sha: string;
    node_id: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    output: ChecksUpdateResponseDataOutput;
    name: string;
    check_suite: ChecksUpdateResponseDataCheckSuite;
    app: ChecksUpdateResponseDataApp;
    pull_requests: Array<ChecksUpdateResponseDataPullRequestsItem>;
};
declare type ChecksGetEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * check_run_id parameter
     */
    check_run_id: number;
} & RequiredPreview<"antiope">;
declare type ChecksGetRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/check-runs/:check_run_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ChecksGetResponseDataPullRequestsItemBaseRepo = {
    id: number;
    url: string;
    name: string;
};
declare type ChecksGetResponseDataPullRequestsItemBase = {
    ref: string;
    sha: string;
    repo: ChecksGetResponseDataPullRequestsItemBaseRepo;
};
declare type ChecksGetResponseDataPullRequestsItemHeadRepo = {
    id: number;
    url: string;
    name: string;
};
declare type ChecksGetResponseDataPullRequestsItemHead = {
    ref: string;
    sha: string;
    repo: ChecksGetResponseDataPullRequestsItemHeadRepo;
};
declare type ChecksGetResponseDataPullRequestsItem = {
    url: string;
    id: number;
    number: number;
    head: ChecksGetResponseDataPullRequestsItemHead;
    base: ChecksGetResponseDataPullRequestsItemBase;
};
declare type ChecksGetResponseDataAppPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ChecksGetResponseDataAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ChecksGetResponseDataApp = {
    id: number;
    slug: string;
    node_id: string;
    owner: ChecksGetResponseDataAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksGetResponseDataAppPermissions;
    events: Array<string>;
};
declare type ChecksGetResponseDataCheckSuite = {
    id: number;
};
declare type ChecksGetResponseDataOutput = {
    title: string;
    summary: string;
    text: string;
    annotations_count: number;
    annotations_url: string;
};
declare type ChecksGetResponseData = {
    id: number;
    head_sha: string;
    node_id: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    output: ChecksGetResponseDataOutput;
    name: string;
    check_suite: ChecksGetResponseDataCheckSuite;
    app: ChecksGetResponseDataApp;
    pull_requests: Array<ChecksGetResponseDataPullRequestsItem>;
};
declare type ChecksListAnnotationsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * check_run_id parameter
     */
    check_run_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"antiope">;
declare type ChecksListAnnotationsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/check-runs/:check_run_id/annotations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ChecksListAnnotationsResponseDataItem = {
    path: string;
    start_line: number;
    end_line: number;
    start_column: number;
    end_column: number;
    annotation_level: string;
    title: string;
    message: string;
    raw_details: string;
};
declare type ChecksListAnnotationsResponseData = Array<ChecksListAnnotationsResponseDataItem>;
declare type ChecksCreateSuiteEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The sha of the head commit.
     */
    head_sha: string;
} & RequiredPreview<"antiope">;
declare type ChecksCreateSuiteRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/check-suites";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ChecksCreateSuiteResponseDataRepositoryPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ChecksCreateSuiteResponseDataRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ChecksCreateSuiteResponseDataRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ChecksCreateSuiteResponseDataRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksCreateSuiteResponseDataRepositoryPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type ChecksCreateSuiteResponseDataAppPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ChecksCreateSuiteResponseDataAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ChecksCreateSuiteResponseDataApp = {
    id: number;
    slug: string;
    node_id: string;
    owner: ChecksCreateSuiteResponseDataAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksCreateSuiteResponseDataAppPermissions;
    events: Array<string>;
};
declare type ChecksCreateSuiteResponseData = {
    id: number;
    node_id: string;
    head_branch: string;
    head_sha: string;
    status: string;
    conclusion: string;
    url: string;
    before: string;
    after: string;
    pull_requests: Array<any>;
    app: ChecksCreateSuiteResponseDataApp;
    repository: ChecksCreateSuiteResponseDataRepository;
};
declare type ChecksSetSuitesPreferencesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default. See the [`auto_trigger_checks` object](https://developer.github.com/v3/checks/suites/#auto_trigger_checks-object) description for details.
     */
    auto_trigger_checks?: ChecksSetSuitesPreferencesParamsAutoTriggerChecks[];
} & RequiredPreview<"antiope">;
declare type ChecksSetSuitesPreferencesRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/check-suites/preferences";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ChecksSetSuitesPreferencesResponseDataRepositoryPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ChecksSetSuitesPreferencesResponseDataRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ChecksSetSuitesPreferencesResponseDataRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ChecksSetSuitesPreferencesResponseDataRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksSetSuitesPreferencesResponseDataRepositoryPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type ChecksSetSuitesPreferencesResponseDataPreferencesAutoTriggerChecksItem = {
    app_id: number;
    setting: boolean;
};
declare type ChecksSetSuitesPreferencesResponseDataPreferences = {
    auto_trigger_checks: Array<ChecksSetSuitesPreferencesResponseDataPreferencesAutoTriggerChecksItem>;
};
declare type ChecksSetSuitesPreferencesResponseData = {
    preferences: ChecksSetSuitesPreferencesResponseDataPreferences;
    repository: ChecksSetSuitesPreferencesResponseDataRepository;
};
declare type ChecksGetSuiteEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * check_suite_id parameter
     */
    check_suite_id: number;
} & RequiredPreview<"antiope">;
declare type ChecksGetSuiteRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/check-suites/:check_suite_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ChecksGetSuiteResponseDataRepositoryPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ChecksGetSuiteResponseDataRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ChecksGetSuiteResponseDataRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ChecksGetSuiteResponseDataRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksGetSuiteResponseDataRepositoryPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type ChecksGetSuiteResponseDataAppPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ChecksGetSuiteResponseDataAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ChecksGetSuiteResponseDataApp = {
    id: number;
    slug: string;
    node_id: string;
    owner: ChecksGetSuiteResponseDataAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksGetSuiteResponseDataAppPermissions;
    events: Array<string>;
};
declare type ChecksGetSuiteResponseData = {
    id: number;
    node_id: string;
    head_branch: string;
    head_sha: string;
    status: string;
    conclusion: string;
    url: string;
    before: string;
    after: string;
    pull_requests: Array<any>;
    app: ChecksGetSuiteResponseDataApp;
    repository: ChecksGetSuiteResponseDataRepository;
};
declare type ChecksListForSuiteEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * check_suite_id parameter
     */
    check_suite_id: number;
    /**
     * Returns check runs with the specified `name`.
     */
    check_name?: string;
    /**
     * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
    /**
     * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
     */
    filter?: "latest" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"antiope">;
declare type ChecksListForSuiteRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/check-suites/:check_suite_id/check-runs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemBaseRepo = {
    id: number;
    url: string;
    name: string;
};
declare type ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemBase = {
    ref: string;
    sha: string;
    repo: ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemBaseRepo;
};
declare type ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemHeadRepo = {
    id: number;
    url: string;
    name: string;
};
declare type ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemHead = {
    ref: string;
    sha: string;
    repo: ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemHeadRepo;
};
declare type ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItem = {
    url: string;
    id: number;
    number: number;
    head: ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemHead;
    base: ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItemBase;
};
declare type ChecksListForSuiteResponseDataCheckRunsItemAppPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ChecksListForSuiteResponseDataCheckRunsItemAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ChecksListForSuiteResponseDataCheckRunsItemApp = {
    id: number;
    slug: string;
    node_id: string;
    owner: ChecksListForSuiteResponseDataCheckRunsItemAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksListForSuiteResponseDataCheckRunsItemAppPermissions;
    events: Array<string>;
};
declare type ChecksListForSuiteResponseDataCheckRunsItemCheckSuite = {
    id: number;
};
declare type ChecksListForSuiteResponseDataCheckRunsItemOutput = {
    title: string;
    summary: string;
    text: string;
    annotations_count: number;
    annotations_url: string;
};
declare type ChecksListForSuiteResponseDataCheckRunsItem = {
    id: number;
    head_sha: string;
    node_id: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    output: ChecksListForSuiteResponseDataCheckRunsItemOutput;
    name: string;
    check_suite: ChecksListForSuiteResponseDataCheckRunsItemCheckSuite;
    app: ChecksListForSuiteResponseDataCheckRunsItemApp;
    pull_requests: Array<ChecksListForSuiteResponseDataCheckRunsItemPullRequestsItem>;
};
declare type ChecksListForSuiteResponseData = {
    total_count: number;
    check_runs: Array<ChecksListForSuiteResponseDataCheckRunsItem>;
};
declare type ChecksRerequestSuiteEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * check_suite_id parameter
     */
    check_suite_id: number;
} & RequiredPreview<"antiope">;
declare type ChecksRerequestSuiteRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/check-suites/:check_suite_id/rerequest";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type CodeScanningListAlertsForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Set to `closed` to list only closed code scanning alerts.
     */
    state?: string;
    /**
     * Returns a list of code scanning alerts for a specific brach reference. The `ref` must be formatted as `heads/<branch name>`.
     */
    ref?: string;
};
declare type CodeScanningListAlertsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/code-scanning/alerts";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type CodeScanningListAlertsForRepoResponseDataItem = {
    rule_id: string;
    rule_severity: string;
    rule_description: string;
    tool: string;
    created_at: string;
    open: boolean;
    closed_by: null;
    closed_at: null;
    url: string;
    html_url: string;
};
declare type CodeScanningListAlertsForRepoResponseData = Array<CodeScanningListAlertsForRepoResponseDataItem>;
declare type CodeScanningGetAlertEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * alert_id parameter
     */
    alert_id: number;
};
declare type CodeScanningGetAlertRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/code-scanning/alerts/:alert_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type CodeScanningGetAlertResponseData = {
    rule_id: string;
    rule_severity: string;
    rule_description: string;
    tool: string;
    created_at: string;
    open: boolean;
    closed_by: null;
    closed_at: null;
    url: string;
    html_url: string;
};
declare type ReposListCollaboratorsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Filter collaborators returned by their affiliation. Can be one of:
     * \* `outside`: All outside collaborators of an organization-owned repository.
     * \* `direct`: All collaborators with permissions to an organization-owned repository, regardless of organization membership status.
     * \* `all`: All collaborators the authenticated user can see.
     */
    affiliation?: "outside" | "direct" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListCollaboratorsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/collaborators";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListCollaboratorsResponseDataItemPermissions = {
    pull: boolean;
    push: boolean;
    admin: boolean;
};
declare type ReposListCollaboratorsResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
    permissions: ReposListCollaboratorsResponseDataItemPermissions;
};
declare type ReposListCollaboratorsResponseData = Array<ReposListCollaboratorsResponseDataItem>;
declare type ReposCheckCollaboratorEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * username parameter
     */
    username: string;
};
declare type ReposCheckCollaboratorRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/collaborators/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposAddCollaboratorEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * username parameter
     */
    username: string;
    /**
     * The permission to grant the collaborator. **Only valid on organization-owned repositories.** Can be one of:
     * \* `pull` - can pull, but not push to or administer this repository.
     * \* `push` - can pull and push, but not administer this repository.
     * \* `admin` - can pull, push and administer this repository.
     * \* `maintain` - Recommended for project managers who need to manage the repository without access to sensitive or destructive actions.
     * \* `triage` - Recommended for contributors who need to proactively manage issues and pull requests without write access.
     */
    permission?: "pull" | "push" | "admin" | "maintain" | "triage";
};
declare type ReposAddCollaboratorRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/collaborators/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposAddCollaboratorResponseDataInviter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposAddCollaboratorResponseDataInvitee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposAddCollaboratorResponseDataRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposAddCollaboratorResponseDataRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposAddCollaboratorResponseDataRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
};
declare type ReposAddCollaboratorResponseData = {
    id: number;
    repository: ReposAddCollaboratorResponseDataRepository;
    invitee: ReposAddCollaboratorResponseDataInvitee;
    inviter: ReposAddCollaboratorResponseDataInviter;
    permissions: string;
    created_at: string;
    url: string;
    html_url: string;
};
declare type ReposRemoveCollaboratorEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * username parameter
     */
    username: string;
};
declare type ReposRemoveCollaboratorRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/collaborators/:username";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetCollaboratorPermissionLevelEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * username parameter
     */
    username: string;
};
declare type ReposGetCollaboratorPermissionLevelRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/collaborators/:username/permission";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetCollaboratorPermissionLevelResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetCollaboratorPermissionLevelResponseData = {
    permission: string;
    user: ReposGetCollaboratorPermissionLevelResponseDataUser;
};
declare type ReposListCommitCommentsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListCommitCommentsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListCommitCommentsResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListCommitCommentsResponseDataItem = {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: ReposListCommitCommentsResponseDataItemUser;
    created_at: string;
    updated_at: string;
};
declare type ReposListCommitCommentsResponseData = Array<ReposListCommitCommentsResponseDataItem>;
declare type ReposGetCommitCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
};
declare type ReposGetCommitCommentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetCommitCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetCommitCommentResponseData = {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: ReposGetCommitCommentResponseDataUser;
    created_at: string;
    updated_at: string;
};
declare type ReposUpdateCommitCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * The contents of the comment
     */
    body: string;
};
declare type ReposUpdateCommitCommentRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposUpdateCommitCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateCommitCommentResponseData = {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: ReposUpdateCommitCommentResponseDataUser;
    created_at: string;
    updated_at: string;
};
declare type ReposDeleteCommitCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
};
declare type ReposDeleteCommitCommentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsListForCommitCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a commit comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForCommitCommentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/comments/:comment_id/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsListForCommitCommentResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReactionsListForCommitCommentResponseDataItem = {
    id: number;
    node_id: string;
    user: ReactionsListForCommitCommentResponseDataItemUser;
    content: string;
    created_at: string;
};
declare type ReactionsListForCommitCommentResponseData = Array<ReactionsListForCommitCommentResponseDataItem>;
declare type ReactionsCreateForCommitCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the commit comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForCommitCommentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/comments/:comment_id/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsCreateForCommitCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReactionsCreateForCommitCommentResponseData = {
    id: number;
    node_id: string;
    user: ReactionsCreateForCommitCommentResponseDataUser;
    content: string;
    created_at: string;
};
declare type ReactionsDeleteForCommitCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * reaction_id parameter
     */
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteForCommitCommentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/comments/:comment_id/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListCommitsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * SHA or branch to start listing commits from. Default: the repository’s default branch (usually `master`).
     */
    sha?: string;
    /**
     * Only commits containing this file path will be returned.
     */
    path?: string;
    /**
     * GitHub login or email address by which to filter by commit author.
     */
    author?: string;
    /**
     * Only commits after this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Only commits before this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    until?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListCommitsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListCommitsResponseDataItemParentsItem = {
    url: string;
    sha: string;
};
declare type ReposListCommitsResponseDataItemCommitter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListCommitsResponseDataItemAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListCommitsResponseDataItemCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type ReposListCommitsResponseDataItemCommitTree = {
    url: string;
    sha: string;
};
declare type ReposListCommitsResponseDataItemCommitCommitter = {
    name: string;
    email: string;
    date: string;
};
declare type ReposListCommitsResponseDataItemCommitAuthor = {
    name: string;
    email: string;
    date: string;
};
declare type ReposListCommitsResponseDataItemCommit = {
    url: string;
    author: ReposListCommitsResponseDataItemCommitAuthor;
    committer: ReposListCommitsResponseDataItemCommitCommitter;
    message: string;
    tree: ReposListCommitsResponseDataItemCommitTree;
    comment_count: number;
    verification: ReposListCommitsResponseDataItemCommitVerification;
};
declare type ReposListCommitsResponseDataItem = {
    url: string;
    sha: string;
    node_id: string;
    html_url: string;
    comments_url: string;
    commit: ReposListCommitsResponseDataItemCommit;
    author: ReposListCommitsResponseDataItemAuthor;
    committer: ReposListCommitsResponseDataItemCommitter;
    parents: Array<ReposListCommitsResponseDataItemParentsItem>;
};
declare type ReposListCommitsResponseData = Array<ReposListCommitsResponseDataItem>;
declare type ReposListBranchesForHeadCommitEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * commit_sha parameter
     */
    commit_sha: string;
} & RequiredPreview<"groot">;
declare type ReposListBranchesForHeadCommitRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:commit_sha/branches-where-head";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListBranchesForHeadCommitResponseDataItemCommit = {
    sha: string;
    url: string;
};
declare type ReposListBranchesForHeadCommitResponseDataItem = {
    name: string;
    commit: ReposListBranchesForHeadCommitResponseDataItemCommit;
    protected: boolean;
};
declare type ReposListBranchesForHeadCommitResponseData = Array<ReposListBranchesForHeadCommitResponseDataItem>;
declare type ReposListCommentsForCommitEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * commit_sha parameter
     */
    commit_sha: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListCommentsForCommitRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:commit_sha/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListCommentsForCommitResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListCommentsForCommitResponseDataItem = {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: ReposListCommentsForCommitResponseDataItemUser;
    created_at: string;
    updated_at: string;
};
declare type ReposListCommentsForCommitResponseData = Array<ReposListCommentsForCommitResponseDataItem>;
declare type ReposCreateCommitCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * commit_sha parameter
     */
    commit_sha: string;
    /**
     * The contents of the comment.
     */
    body: string;
    /**
     * Relative path of the file to comment on.
     */
    path?: string;
    /**
     * Line index in the diff to comment on.
     */
    position?: number;
    /**
     * **Deprecated**. Use **position** parameter instead. Line number in the file to comment on.
     */
    line?: number;
};
declare type ReposCreateCommitCommentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/commits/:commit_sha/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposCreateCommitCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposCreateCommitCommentResponseData = {
    html_url: string;
    url: string;
    id: number;
    node_id: string;
    body: string;
    path: string;
    position: number;
    line: number;
    commit_id: string;
    user: ReposCreateCommitCommentResponseDataUser;
    created_at: string;
    updated_at: string;
};
declare type ReposListPullRequestsAssociatedWithCommitEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * commit_sha parameter
     */
    commit_sha: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"groot">;
declare type ReposListPullRequestsAssociatedWithCommitRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:commit_sha/pulls";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksStatuses = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksCommits = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksReviewComment = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksReviewComments = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksComments = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksIssue = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksHtml = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksSelf = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemLinks = {
    self: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksSelf;
    html: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksHtml;
    issue: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksIssue;
    comments: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksComments;
    review_comments: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksReviewComments;
    review_comment: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksReviewComment;
    commits: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksCommits;
    statuses: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinksStatuses;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseRepoPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemBase = {
    label: string;
    ref: string;
    sha: string;
    user: ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseUser;
    repo: ReposListPullRequestsAssociatedWithCommitResponseDataItemBaseRepo;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadRepoPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemHead = {
    label: string;
    ref: string;
    sha: string;
    user: ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadUser;
    repo: ReposListPullRequestsAssociatedWithCommitResponseDataItemHeadRepo;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemRequestedTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemRequestedReviewersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: ReposListPullRequestsAssociatedWithCommitResponseDataItemMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseDataItem = {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    locked: boolean;
    title: string;
    user: ReposListPullRequestsAssociatedWithCommitResponseDataItemUser;
    body: string;
    labels: Array<ReposListPullRequestsAssociatedWithCommitResponseDataItemLabelsItem>;
    milestone: ReposListPullRequestsAssociatedWithCommitResponseDataItemMilestone;
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    merge_commit_sha: string;
    assignee: ReposListPullRequestsAssociatedWithCommitResponseDataItemAssignee;
    assignees: Array<ReposListPullRequestsAssociatedWithCommitResponseDataItemAssigneesItem>;
    requested_reviewers: Array<ReposListPullRequestsAssociatedWithCommitResponseDataItemRequestedReviewersItem>;
    requested_teams: Array<ReposListPullRequestsAssociatedWithCommitResponseDataItemRequestedTeamsItem>;
    head: ReposListPullRequestsAssociatedWithCommitResponseDataItemHead;
    base: ReposListPullRequestsAssociatedWithCommitResponseDataItemBase;
    _links: ReposListPullRequestsAssociatedWithCommitResponseDataItemLinks;
    author_association: string;
    draft: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseData = Array<ReposListPullRequestsAssociatedWithCommitResponseDataItem>;
declare type ReposGetCommitEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * ref parameter
     */
    ref: string;
};
declare type ReposGetCommitRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:ref";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetCommitResponseDataFilesItem = {
    filename: string;
    additions: number;
    deletions: number;
    changes: number;
    status: string;
    raw_url: string;
    blob_url: string;
    patch: string;
};
declare type ReposGetCommitResponseDataStats = {
    additions: number;
    deletions: number;
    total: number;
};
declare type ReposGetCommitResponseDataParentsItem = {
    url: string;
    sha: string;
};
declare type ReposGetCommitResponseDataCommitter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetCommitResponseDataAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetCommitResponseDataCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type ReposGetCommitResponseDataCommitTree = {
    url: string;
    sha: string;
};
declare type ReposGetCommitResponseDataCommitCommitter = {
    name: string;
    email: string;
    date: string;
};
declare type ReposGetCommitResponseDataCommitAuthor = {
    name: string;
    email: string;
    date: string;
};
declare type ReposGetCommitResponseDataCommit = {
    url: string;
    author: ReposGetCommitResponseDataCommitAuthor;
    committer: ReposGetCommitResponseDataCommitCommitter;
    message: string;
    tree: ReposGetCommitResponseDataCommitTree;
    comment_count: number;
    verification: ReposGetCommitResponseDataCommitVerification;
};
declare type ReposGetCommitResponseData = {
    url: string;
    sha: string;
    node_id: string;
    html_url: string;
    comments_url: string;
    commit: ReposGetCommitResponseDataCommit;
    author: ReposGetCommitResponseDataAuthor;
    committer: ReposGetCommitResponseDataCommitter;
    parents: Array<ReposGetCommitResponseDataParentsItem>;
    stats: ReposGetCommitResponseDataStats;
    files: Array<ReposGetCommitResponseDataFilesItem>;
};
declare type ChecksListForRefEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * ref parameter
     */
    ref: string;
    /**
     * Returns check runs with the specified `name`.
     */
    check_name?: string;
    /**
     * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
    /**
     * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
     */
    filter?: "latest" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"antiope">;
declare type ChecksListForRefRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:ref/check-runs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ChecksListForRefResponseDataCheckRunsItemPullRequestsItemBaseRepo = {
    id: number;
    url: string;
    name: string;
};
declare type ChecksListForRefResponseDataCheckRunsItemPullRequestsItemBase = {
    ref: string;
    sha: string;
    repo: ChecksListForRefResponseDataCheckRunsItemPullRequestsItemBaseRepo;
};
declare type ChecksListForRefResponseDataCheckRunsItemPullRequestsItemHeadRepo = {
    id: number;
    url: string;
    name: string;
};
declare type ChecksListForRefResponseDataCheckRunsItemPullRequestsItemHead = {
    ref: string;
    sha: string;
    repo: ChecksListForRefResponseDataCheckRunsItemPullRequestsItemHeadRepo;
};
declare type ChecksListForRefResponseDataCheckRunsItemPullRequestsItem = {
    url: string;
    id: number;
    number: number;
    head: ChecksListForRefResponseDataCheckRunsItemPullRequestsItemHead;
    base: ChecksListForRefResponseDataCheckRunsItemPullRequestsItemBase;
};
declare type ChecksListForRefResponseDataCheckRunsItemAppPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ChecksListForRefResponseDataCheckRunsItemAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ChecksListForRefResponseDataCheckRunsItemApp = {
    id: number;
    slug: string;
    node_id: string;
    owner: ChecksListForRefResponseDataCheckRunsItemAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksListForRefResponseDataCheckRunsItemAppPermissions;
    events: Array<string>;
};
declare type ChecksListForRefResponseDataCheckRunsItemCheckSuite = {
    id: number;
};
declare type ChecksListForRefResponseDataCheckRunsItemOutput = {
    title: string;
    summary: string;
    text: string;
    annotations_count: number;
    annotations_url: string;
};
declare type ChecksListForRefResponseDataCheckRunsItem = {
    id: number;
    head_sha: string;
    node_id: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    status: string;
    conclusion: string;
    started_at: string;
    completed_at: string;
    output: ChecksListForRefResponseDataCheckRunsItemOutput;
    name: string;
    check_suite: ChecksListForRefResponseDataCheckRunsItemCheckSuite;
    app: ChecksListForRefResponseDataCheckRunsItemApp;
    pull_requests: Array<ChecksListForRefResponseDataCheckRunsItemPullRequestsItem>;
};
declare type ChecksListForRefResponseData = {
    total_count: number;
    check_runs: Array<ChecksListForRefResponseDataCheckRunsItem>;
};
declare type ChecksListSuitesForRefEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * ref parameter
     */
    ref: string;
    /**
     * Filters check suites by GitHub App `id`.
     */
    app_id?: number;
    /**
     * Filters checks suites by the name of the [check run](https://developer.github.com/v3/checks/runs/).
     */
    check_name?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"antiope">;
declare type ChecksListSuitesForRefRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:ref/check-suites";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ChecksListSuitesForRefResponseDataCheckSuitesItemRepositoryPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ChecksListSuitesForRefResponseDataCheckSuitesItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ChecksListSuitesForRefResponseDataCheckSuitesItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ChecksListSuitesForRefResponseDataCheckSuitesItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksListSuitesForRefResponseDataCheckSuitesItemRepositoryPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type ChecksListSuitesForRefResponseDataCheckSuitesItemAppPermissions = {
    metadata: string;
    contents: string;
    issues: string;
    single_file: string;
};
declare type ChecksListSuitesForRefResponseDataCheckSuitesItemAppOwner = {
    login: string;
    id: number;
    node_id: string;
    url: string;
    repos_url: string;
    events_url: string;
    hooks_url: string;
    issues_url: string;
    members_url: string;
    public_members_url: string;
    avatar_url: string;
    description: string;
};
declare type ChecksListSuitesForRefResponseDataCheckSuitesItemApp = {
    id: number;
    slug: string;
    node_id: string;
    owner: ChecksListSuitesForRefResponseDataCheckSuitesItemAppOwner;
    name: string;
    description: string;
    external_url: string;
    html_url: string;
    created_at: string;
    updated_at: string;
    permissions: ChecksListSuitesForRefResponseDataCheckSuitesItemAppPermissions;
    events: Array<string>;
};
declare type ChecksListSuitesForRefResponseDataCheckSuitesItem = {
    id: number;
    node_id: string;
    head_branch: string;
    head_sha: string;
    status: string;
    conclusion: string;
    url: string;
    before: string;
    after: string;
    pull_requests: Array<any>;
    app: ChecksListSuitesForRefResponseDataCheckSuitesItemApp;
    repository: ChecksListSuitesForRefResponseDataCheckSuitesItemRepository;
};
declare type ChecksListSuitesForRefResponseData = {
    total_count: number;
    check_suites: Array<ChecksListSuitesForRefResponseDataCheckSuitesItem>;
};
declare type ReposGetCombinedStatusForRefEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * ref parameter
     */
    ref: string;
};
declare type ReposGetCombinedStatusForRefRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:ref/status";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetCombinedStatusForRefResponseDataRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetCombinedStatusForRefResponseDataRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposGetCombinedStatusForRefResponseDataRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
};
declare type ReposGetCombinedStatusForRefResponseDataStatusesItem = {
    url: string;
    avatar_url: string;
    id: number;
    node_id: string;
    state: string;
    description: string;
    target_url: string;
    context: string;
    created_at: string;
    updated_at: string;
};
declare type ReposGetCombinedStatusForRefResponseData = {
    state: string;
    statuses: Array<ReposGetCombinedStatusForRefResponseDataStatusesItem>;
    sha: string;
    total_count: number;
    repository: ReposGetCombinedStatusForRefResponseDataRepository;
    commit_url: string;
    url: string;
};
declare type ReposListStatusesForRefEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * ref parameter
     */
    ref: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListStatusesForRefRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/commits/:ref/statuses";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListStatusesForRefResponseDataItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListStatusesForRefResponseDataItem = {
    url: string;
    avatar_url: string;
    id: number;
    node_id: string;
    state: string;
    description: string;
    target_url: string;
    context: string;
    created_at: string;
    updated_at: string;
    creator: ReposListStatusesForRefResponseDataItemCreator;
};
declare type ReposListStatusesForRefResponseData = Array<ReposListStatusesForRefResponseDataItem>;
declare type CodesOfConductGetForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
} & RequiredPreview<"scarlet-witch">;
declare type CodesOfConductGetForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/community/code_of_conduct";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type CodesOfConductGetForRepoResponseData = {
    key: string;
    name: string;
    url: string;
    body: string;
};
declare type ReposRetrieveCommunityProfileMetricsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposRetrieveCommunityProfileMetricsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/community/profile";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposRetrieveCommunityProfileMetricsResponseDataFilesReadme = {
    url: string;
    html_url: string;
};
declare type ReposRetrieveCommunityProfileMetricsResponseDataFilesLicense = {
    name: string;
    key: string;
    spdx_id: string;
    url: string;
    html_url: string;
};
declare type ReposRetrieveCommunityProfileMetricsResponseDataFilesPullRequestTemplate = {
    url: string;
    html_url: string;
};
declare type ReposRetrieveCommunityProfileMetricsResponseDataFilesIssueTemplate = {
    url: string;
    html_url: string;
};
declare type ReposRetrieveCommunityProfileMetricsResponseDataFilesContributing = {
    url: string;
    html_url: string;
};
declare type ReposRetrieveCommunityProfileMetricsResponseDataFilesCodeOfConduct = {
    name: string;
    key: string;
    url: string;
    html_url: string;
};
declare type ReposRetrieveCommunityProfileMetricsResponseDataFiles = {
    code_of_conduct: ReposRetrieveCommunityProfileMetricsResponseDataFilesCodeOfConduct;
    contributing: ReposRetrieveCommunityProfileMetricsResponseDataFilesContributing;
    issue_template: ReposRetrieveCommunityProfileMetricsResponseDataFilesIssueTemplate;
    pull_request_template: ReposRetrieveCommunityProfileMetricsResponseDataFilesPullRequestTemplate;
    license: ReposRetrieveCommunityProfileMetricsResponseDataFilesLicense;
    readme: ReposRetrieveCommunityProfileMetricsResponseDataFilesReadme;
};
declare type ReposRetrieveCommunityProfileMetricsResponseData = {
    health_percentage: number;
    description: string;
    documentation: boolean;
    files: ReposRetrieveCommunityProfileMetricsResponseDataFiles;
    updated_at: string;
};
declare type ReposCompareCommitsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * base parameter
     */
    base: string;
    /**
     * head parameter
     */
    head: string;
};
declare type ReposCompareCommitsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/compare/:base...:head";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposCompareCommitsResponseDataFilesItem = {
    sha: string;
    filename: string;
    status: string;
    additions: number;
    deletions: number;
    changes: number;
    blob_url: string;
    raw_url: string;
    contents_url: string;
    patch: string;
};
declare type ReposCompareCommitsResponseDataCommitsItemParentsItem = {
    url: string;
    sha: string;
};
declare type ReposCompareCommitsResponseDataCommitsItemCommitter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposCompareCommitsResponseDataCommitsItemAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposCompareCommitsResponseDataCommitsItemCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type ReposCompareCommitsResponseDataCommitsItemCommitTree = {
    url: string;
    sha: string;
};
declare type ReposCompareCommitsResponseDataCommitsItemCommitCommitter = {
    name: string;
    email: string;
    date: string;
};
declare type ReposCompareCommitsResponseDataCommitsItemCommitAuthor = {
    name: string;
    email: string;
    date: string;
};
declare type ReposCompareCommitsResponseDataCommitsItemCommit = {
    url: string;
    author: ReposCompareCommitsResponseDataCommitsItemCommitAuthor;
    committer: ReposCompareCommitsResponseDataCommitsItemCommitCommitter;
    message: string;
    tree: ReposCompareCommitsResponseDataCommitsItemCommitTree;
    comment_count: number;
    verification: ReposCompareCommitsResponseDataCommitsItemCommitVerification;
};
declare type ReposCompareCommitsResponseDataCommitsItem = {
    url: string;
    sha: string;
    node_id: string;
    html_url: string;
    comments_url: string;
    commit: ReposCompareCommitsResponseDataCommitsItemCommit;
    author: ReposCompareCommitsResponseDataCommitsItemAuthor;
    committer: ReposCompareCommitsResponseDataCommitsItemCommitter;
    parents: Array<ReposCompareCommitsResponseDataCommitsItemParentsItem>;
};
declare type ReposCompareCommitsResponseDataMergeBaseCommitParentsItem = {
    url: string;
    sha: string;
};
declare type ReposCompareCommitsResponseDataMergeBaseCommitCommitter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposCompareCommitsResponseDataMergeBaseCommitAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposCompareCommitsResponseDataMergeBaseCommitCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type ReposCompareCommitsResponseDataMergeBaseCommitCommitTree = {
    url: string;
    sha: string;
};
declare type ReposCompareCommitsResponseDataMergeBaseCommitCommitCommitter = {
    name: string;
    email: string;
    date: string;
};
declare type ReposCompareCommitsResponseDataMergeBaseCommitCommitAuthor = {
    name: string;
    email: string;
    date: string;
};
declare type ReposCompareCommitsResponseDataMergeBaseCommitCommit = {
    url: string;
    author: ReposCompareCommitsResponseDataMergeBaseCommitCommitAuthor;
    committer: ReposCompareCommitsResponseDataMergeBaseCommitCommitCommitter;
    message: string;
    tree: ReposCompareCommitsResponseDataMergeBaseCommitCommitTree;
    comment_count: number;
    verification: ReposCompareCommitsResponseDataMergeBaseCommitCommitVerification;
};
declare type ReposCompareCommitsResponseDataMergeBaseCommit = {
    url: string;
    sha: string;
    node_id: string;
    html_url: string;
    comments_url: string;
    commit: ReposCompareCommitsResponseDataMergeBaseCommitCommit;
    author: ReposCompareCommitsResponseDataMergeBaseCommitAuthor;
    committer: ReposCompareCommitsResponseDataMergeBaseCommitCommitter;
    parents: Array<ReposCompareCommitsResponseDataMergeBaseCommitParentsItem>;
};
declare type ReposCompareCommitsResponseDataBaseCommitParentsItem = {
    url: string;
    sha: string;
};
declare type ReposCompareCommitsResponseDataBaseCommitCommitter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposCompareCommitsResponseDataBaseCommitAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposCompareCommitsResponseDataBaseCommitCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type ReposCompareCommitsResponseDataBaseCommitCommitTree = {
    url: string;
    sha: string;
};
declare type ReposCompareCommitsResponseDataBaseCommitCommitCommitter = {
    name: string;
    email: string;
    date: string;
};
declare type ReposCompareCommitsResponseDataBaseCommitCommitAuthor = {
    name: string;
    email: string;
    date: string;
};
declare type ReposCompareCommitsResponseDataBaseCommitCommit = {
    url: string;
    author: ReposCompareCommitsResponseDataBaseCommitCommitAuthor;
    committer: ReposCompareCommitsResponseDataBaseCommitCommitCommitter;
    message: string;
    tree: ReposCompareCommitsResponseDataBaseCommitCommitTree;
    comment_count: number;
    verification: ReposCompareCommitsResponseDataBaseCommitCommitVerification;
};
declare type ReposCompareCommitsResponseDataBaseCommit = {
    url: string;
    sha: string;
    node_id: string;
    html_url: string;
    comments_url: string;
    commit: ReposCompareCommitsResponseDataBaseCommitCommit;
    author: ReposCompareCommitsResponseDataBaseCommitAuthor;
    committer: ReposCompareCommitsResponseDataBaseCommitCommitter;
    parents: Array<ReposCompareCommitsResponseDataBaseCommitParentsItem>;
};
declare type ReposCompareCommitsResponseData = {
    url: string;
    html_url: string;
    permalink_url: string;
    diff_url: string;
    patch_url: string;
    base_commit: ReposCompareCommitsResponseDataBaseCommit;
    merge_base_commit: ReposCompareCommitsResponseDataMergeBaseCommit;
    status: string;
    ahead_by: number;
    behind_by: number;
    total_commits: number;
    commits: Array<ReposCompareCommitsResponseDataCommitsItem>;
    files: Array<ReposCompareCommitsResponseDataFilesItem>;
};
declare type ReposGetContentsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * path parameter
     */
    path: string;
    /**
     * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
     */
    ref?: string;
};
declare type ReposGetContentsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/contents/:path";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetContentsResponseDataItemLinks = {
    self: string;
    git: string;
    html: string;
};
declare type ReposGetContentsResponseDataItem = {
    type: string;
    size: number;
    name: string;
    path: string;
    sha: string;
    url: string;
    git_url: string;
    html_url: string;
    download_url: string | null;
    _links: ReposGetContentsResponseDataItemLinks;
};
declare type ReposGetContentsResponseDataLinks = {
    git: string;
    self: string;
    html: string;
};
declare type ReposGetContentsResponseData = {
    type: string;
    encoding?: string;
    size: number;
    name: string;
    path: string;
    content?: string;
    sha: string;
    url: string;
    git_url: string;
    html_url: string;
    download_url: string | null;
    _links: ReposGetContentsResponseDataLinks;
    target?: string;
    submodule_git_url?: string;
} | Array<ReposGetContentsResponseDataItem>;
declare type ReposCreateOrUpdateFileEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * path parameter
     */
    path: string;
    /**
     * The commit message.
     */
    message: string;
    /**
     * The new file content, using Base64 encoding.
     */
    content: string;
    /**
     * **Required if you are updating a file**. The blob SHA of the file being replaced.
     */
    sha?: string;
    /**
     * The branch name. Default: the repository’s default branch (usually `master`)
     */
    branch?: string;
    /**
     * The person that committed the file. Default: the authenticated user.
     */
    committer?: ReposCreateOrUpdateFileParamsCommitter;
    /**
     * The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
     */
    author?: ReposCreateOrUpdateFileParamsAuthor;
};
declare type ReposCreateOrUpdateFileRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/contents/:path";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposCreateOrUpdateFileResponseDataCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type ReposCreateOrUpdateFileResponseDataCommitParentsItem = {
    url: string;
    html_url: string;
    sha: string;
};
declare type ReposCreateOrUpdateFileResponseDataCommitTree = {
    url: string;
    sha: string;
};
declare type ReposCreateOrUpdateFileResponseDataCommitCommitter = {
    date: string;
    name: string;
    email: string;
};
declare type ReposCreateOrUpdateFileResponseDataCommitAuthor = {
    date: string;
    name: string;
    email: string;
};
declare type ReposCreateOrUpdateFileResponseDataCommit = {
    sha: string;
    node_id: string;
    url: string;
    html_url: string;
    author: ReposCreateOrUpdateFileResponseDataCommitAuthor;
    committer: ReposCreateOrUpdateFileResponseDataCommitCommitter;
    message: string;
    tree: ReposCreateOrUpdateFileResponseDataCommitTree;
    parents: Array<ReposCreateOrUpdateFileResponseDataCommitParentsItem>;
    verification: ReposCreateOrUpdateFileResponseDataCommitVerification;
};
declare type ReposCreateOrUpdateFileResponseDataContentLinks = {
    self: string;
    git: string;
    html: string;
};
declare type ReposCreateOrUpdateFileResponseDataContent = {
    name: string;
    path: string;
    sha: string;
    size: number;
    url: string;
    html_url: string;
    git_url: string;
    download_url: string;
    type: string;
    _links: ReposCreateOrUpdateFileResponseDataContentLinks;
};
declare type ReposCreateOrUpdateFileResponseData = {
    content: ReposCreateOrUpdateFileResponseDataContent;
    commit: ReposCreateOrUpdateFileResponseDataCommit;
};
declare type ReposDeleteFileEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * path parameter
     */
    path: string;
    /**
     * The commit message.
     */
    message: string;
    /**
     * The blob SHA of the file being replaced.
     */
    sha: string;
    /**
     * The branch name. Default: the repository’s default branch (usually `master`)
     */
    branch?: string;
    /**
     * object containing information about the committer.
     */
    committer?: ReposDeleteFileParamsCommitter;
    /**
     * object containing information about the author.
     */
    author?: ReposDeleteFileParamsAuthor;
};
declare type ReposDeleteFileRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/contents/:path";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposDeleteFileResponseDataCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type ReposDeleteFileResponseDataCommitParentsItem = {
    url: string;
    html_url: string;
    sha: string;
};
declare type ReposDeleteFileResponseDataCommitTree = {
    url: string;
    sha: string;
};
declare type ReposDeleteFileResponseDataCommitCommitter = {
    date: string;
    name: string;
    email: string;
};
declare type ReposDeleteFileResponseDataCommitAuthor = {
    date: string;
    name: string;
    email: string;
};
declare type ReposDeleteFileResponseDataCommit = {
    sha: string;
    node_id: string;
    url: string;
    html_url: string;
    author: ReposDeleteFileResponseDataCommitAuthor;
    committer: ReposDeleteFileResponseDataCommitCommitter;
    message: string;
    tree: ReposDeleteFileResponseDataCommitTree;
    parents: Array<ReposDeleteFileResponseDataCommitParentsItem>;
    verification: ReposDeleteFileResponseDataCommitVerification;
};
declare type ReposDeleteFileResponseData = {
    content: null;
    commit: ReposDeleteFileResponseDataCommit;
};
declare type ReposListContributorsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Set to `1` or `true` to include anonymous contributors in results.
     */
    anon?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListContributorsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/contributors";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListContributorsResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
    contributions: number;
};
declare type ReposListContributorsResponseData = Array<ReposListContributorsResponseDataItem>;
declare type ReposListDeploymentsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The SHA recorded at creation time.
     */
    sha?: string;
    /**
     * The name of the ref. This can be a branch, tag, or SHA.
     */
    ref?: string;
    /**
     * The name of the task for the deployment (e.g., `deploy` or `deploy:migrations`).
     */
    task?: string;
    /**
     * The name of the environment that was deployed to (e.g., `staging` or `production`).
     */
    environment?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListDeploymentsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/deployments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListDeploymentsResponseDataItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListDeploymentsResponseDataItemPayload = {
    deploy: string;
};
declare type ReposListDeploymentsResponseDataItem = {
    url: string;
    id: number;
    node_id: string;
    sha: string;
    ref: string;
    task: string;
    payload: ReposListDeploymentsResponseDataItemPayload;
    original_environment: string;
    environment: string;
    description: string;
    creator: ReposListDeploymentsResponseDataItemCreator;
    created_at: string;
    updated_at: string;
    statuses_url: string;
    repository_url: string;
    transient_environment: boolean;
    production_environment: boolean;
};
declare type ReposListDeploymentsResponseData = Array<ReposListDeploymentsResponseDataItem>;
declare type ReposCreateDeploymentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The ref to deploy. This can be a branch, tag, or SHA.
     */
    ref: string;
    /**
     * Specifies a task to execute (e.g., `deploy` or `deploy:migrations`).
     */
    task?: string;
    /**
     * Attempts to automatically merge the default branch into the requested ref, if it's behind the default branch.
     */
    auto_merge?: boolean;
    /**
     * The [status](https://developer.github.com/v3/repos/statuses/) contexts to verify against commit status checks. If you omit this parameter, GitHub verifies all unique contexts before creating a deployment. To bypass checking entirely, pass an empty array. Defaults to all unique contexts.
     */
    required_contexts?: string[];
    /**
     * JSON payload with extra information about the deployment.
     */
    payload?: string;
    /**
     * Name for the target deployment environment (e.g., `production`, `staging`, `qa`).
     */
    environment?: string;
    /**
     * Short description of the deployment.
     */
    description?: string;
    /**
     * Specifies if the given environment is specific to the deployment and will no longer exist at some point in the future. Default: `false`
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    transient_environment?: boolean;
    /**
     * Specifies if the given environment is one that end-users directly interact with. Default: `true` when `environment` is `production` and `false` otherwise.
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    production_environment?: boolean;
};
declare type ReposCreateDeploymentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/deployments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposCreateDeploymentResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposCreateDeploymentResponseDataPayload = {
    deploy: string;
};
declare type ReposCreateDeploymentResponseData = {
    url: string;
    id: number;
    node_id: string;
    sha: string;
    ref: string;
    task: string;
    payload: ReposCreateDeploymentResponseDataPayload;
    original_environment: string;
    environment: string;
    description: string;
    creator: ReposCreateDeploymentResponseDataCreator;
    created_at: string;
    updated_at: string;
    statuses_url: string;
    repository_url: string;
    transient_environment: boolean;
    production_environment: boolean;
};
declare type ReposGetDeploymentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * deployment_id parameter
     */
    deployment_id: number;
};
declare type ReposGetDeploymentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/deployments/:deployment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetDeploymentResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetDeploymentResponseDataPayload = {
    deploy: string;
};
declare type ReposGetDeploymentResponseData = {
    url: string;
    id: number;
    node_id: string;
    sha: string;
    ref: string;
    task: string;
    payload: ReposGetDeploymentResponseDataPayload;
    original_environment: string;
    environment: string;
    description: string;
    creator: ReposGetDeploymentResponseDataCreator;
    created_at: string;
    updated_at: string;
    statuses_url: string;
    repository_url: string;
    transient_environment: boolean;
    production_environment: boolean;
};
declare type ReposDeleteDeploymentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * deployment_id parameter
     */
    deployment_id: number;
};
declare type ReposDeleteDeploymentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/deployments/:deployment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListDeploymentStatusesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * deployment_id parameter
     */
    deployment_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListDeploymentStatusesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/deployments/:deployment_id/statuses";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListDeploymentStatusesResponseDataItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListDeploymentStatusesResponseDataItem = {
    url: string;
    id: number;
    node_id: string;
    state: string;
    creator: ReposListDeploymentStatusesResponseDataItemCreator;
    description: string;
    environment: string;
    target_url: string;
    created_at: string;
    updated_at: string;
    deployment_url: string;
    repository_url: string;
    environment_url: string;
    log_url: string;
};
declare type ReposListDeploymentStatusesResponseData = Array<ReposListDeploymentStatusesResponseDataItem>;
declare type ReposCreateDeploymentStatusEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * deployment_id parameter
     */
    deployment_id: number;
    /**
     * The state of the status. Can be one of `error`, `failure`, `inactive`, `in_progress`, `queued` `pending`, or `success`. **Note:** To use the `inactive` state, you must provide the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. To use the `in_progress` and `queued` states, you must provide the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     */
    state: "error" | "failure" | "inactive" | "in_progress" | "queued" | "pending" | "success";
    /**
     * The target URL to associate with this status. This URL should contain output to keep the user updated while the task is running or serve as historical information for what happened in the deployment. **Note:** It's recommended to use the `log_url` parameter, which replaces `target_url`.
     */
    target_url?: string;
    /**
     * The full URL of the deployment's output. This parameter replaces `target_url`. We will continue to accept `target_url` to support legacy uses, but we recommend replacing `target_url` with `log_url`. Setting `log_url` will automatically set `target_url` to the same value. Default: `""`
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    log_url?: string;
    /**
     * A short description of the status. The maximum description length is 140 characters.
     */
    description?: string;
    /**
     * Name for the target deployment environment, which can be changed when setting a deploy status. For example, `production`, `staging`, or `qa`. **Note:** This parameter requires you to use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     */
    environment?: "production" | "staging" | "qa";
    /**
     * Sets the URL for accessing your environment. Default: `""`
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    environment_url?: string;
    /**
     * Adds a new `inactive` status to all prior non-transient, non-production environment deployments with the same repository and `environment` name as the created status's deployment. An `inactive` status is only added to deployments that had a `success` state. Default: `true`
     * **Note:** To add an `inactive` status to `production` environments, you must use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    auto_inactive?: boolean;
};
declare type ReposCreateDeploymentStatusRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/deployments/:deployment_id/statuses";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposCreateDeploymentStatusResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposCreateDeploymentStatusResponseData = {
    url: string;
    id: number;
    node_id: string;
    state: string;
    creator: ReposCreateDeploymentStatusResponseDataCreator;
    description: string;
    environment: string;
    target_url: string;
    created_at: string;
    updated_at: string;
    deployment_url: string;
    repository_url: string;
    environment_url: string;
    log_url: string;
};
declare type ReposGetDeploymentStatusEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * deployment_id parameter
     */
    deployment_id: number;
    /**
     * status_id parameter
     */
    status_id: number;
};
declare type ReposGetDeploymentStatusRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/deployments/:deployment_id/statuses/:status_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetDeploymentStatusResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetDeploymentStatusResponseData = {
    url: string;
    id: number;
    node_id: string;
    state: string;
    creator: ReposGetDeploymentStatusResponseDataCreator;
    description: string;
    environment: string;
    target_url: string;
    created_at: string;
    updated_at: string;
    deployment_url: string;
    repository_url: string;
    environment_url: string;
    log_url: string;
};
declare type ReposCreateDispatchEventEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * **Required:** A custom webhook event name.
     */
    event_type?: string;
    /**
     * JSON payload with extra information about the webhook event that your action or worklow may use.
     */
    client_payload?: ReposCreateDispatchEventParamsClientPayload;
};
declare type ReposCreateDispatchEventRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/dispatches";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListDownloadsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListDownloadsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/downloads";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListDownloadsResponseDataItem = {
    url: string;
    html_url: string;
    id: number;
    name: string;
    description: string;
    size: number;
    download_count: number;
    content_type: string;
};
declare type ReposListDownloadsResponseData = Array<ReposListDownloadsResponseDataItem>;
declare type ReposGetDownloadEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * download_id parameter
     */
    download_id: number;
};
declare type ReposGetDownloadRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/downloads/:download_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetDownloadResponseData = {
    url: string;
    html_url: string;
    id: number;
    name: string;
    description: string;
    size: number;
    download_count: number;
    content_type: string;
};
declare type ReposDeleteDownloadEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * download_id parameter
     */
    download_id: number;
};
declare type ReposDeleteDownloadRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/downloads/:download_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListRepoEventsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListRepoEventsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListForksEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The sort order. Can be either `newest`, `oldest`, or `stargazers`.
     */
    sort?: "newest" | "oldest" | "stargazers";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListForksRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/forks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListForksResponseDataItemLicense = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
};
declare type ReposListForksResponseDataItemPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ReposListForksResponseDataItemOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListForksResponseDataItem = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposListForksResponseDataItemOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposListForksResponseDataItemPermissions;
    template_repository: null;
    temp_clone_token: string;
    subscribers_count: number;
    network_count: number;
    license: ReposListForksResponseDataItemLicense;
};
declare type ReposListForksResponseData = Array<ReposListForksResponseDataItem>;
declare type ReposCreateForkEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Optional parameter to specify the organization name if forking into an organization.
     */
    organization?: string;
};
declare type ReposCreateForkRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/forks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposCreateForkResponseDataPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ReposCreateForkResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposCreateForkResponseData = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposCreateForkResponseDataOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: ReposCreateForkResponseDataPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type GitCreateBlobEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The new blob's content.
     */
    content: string;
    /**
     * The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
     */
    encoding?: string;
};
declare type GitCreateBlobRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/git/blobs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitCreateBlobResponseData = {
    url: string;
    sha: string;
};
declare type GitGetBlobEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * file_sha parameter
     */
    file_sha: string;
};
declare type GitGetBlobRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/git/blobs/:file_sha";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitGetBlobResponseData = {
    content: string;
    encoding: string;
    url: string;
    sha: string;
    size: number;
};
declare type GitCreateCommitEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The commit message
     */
    message: string;
    /**
     * The SHA of the tree object this commit points to
     */
    tree: string;
    /**
     * The SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be written as a root commit. For a single parent, an array of one SHA should be provided; for a merge commit, an array of more than one should be provided.
     */
    parents: string[];
    /**
     * Information about the author of the commit. By default, the `author` will be the authenticated user and the current date. See the `author` and `committer` object below for details.
     */
    author?: GitCreateCommitParamsAuthor;
    /**
     * Information about the person who is making the commit. By default, `committer` will use the information set in `author`. See the `author` and `committer` object below for details.
     */
    committer?: GitCreateCommitParamsCommitter;
    /**
     * The [PGP signature](https://en.wikipedia.org/wiki/Pretty_Good_Privacy) of the commit. GitHub adds the signature to the `gpgsig` header of the created commit. For a commit signature to be verifiable by Git or GitHub, it must be an ASCII-armored detached PGP signature over the string commit as it would be written to the object database. To pass a `signature` parameter, you need to first manually create a valid PGP signature, which can be complicated. You may find it easier to [use the command line](https://git-scm.com/book/id/v2/Git-Tools-Signing-Your-Work) to create signed commits.
     */
    signature?: string;
};
declare type GitCreateCommitRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/git/commits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitCreateCommitResponseDataVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type GitCreateCommitResponseDataParentsItem = {
    url: string;
    sha: string;
};
declare type GitCreateCommitResponseDataTree = {
    url: string;
    sha: string;
};
declare type GitCreateCommitResponseDataCommitter = {
    date: string;
    name: string;
    email: string;
};
declare type GitCreateCommitResponseDataAuthor = {
    date: string;
    name: string;
    email: string;
};
declare type GitCreateCommitResponseData = {
    sha: string;
    node_id: string;
    url: string;
    author: GitCreateCommitResponseDataAuthor;
    committer: GitCreateCommitResponseDataCommitter;
    message: string;
    tree: GitCreateCommitResponseDataTree;
    parents: Array<GitCreateCommitResponseDataParentsItem>;
    verification: GitCreateCommitResponseDataVerification;
};
declare type GitGetCommitEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * commit_sha parameter
     */
    commit_sha: string;
};
declare type GitGetCommitRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/git/commits/:commit_sha";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitGetCommitResponseDataVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type GitGetCommitResponseDataParentsItem = {
    url: string;
    sha: string;
};
declare type GitGetCommitResponseDataTree = {
    url: string;
    sha: string;
};
declare type GitGetCommitResponseDataCommitter = {
    date: string;
    name: string;
    email: string;
};
declare type GitGetCommitResponseDataAuthor = {
    date: string;
    name: string;
    email: string;
};
declare type GitGetCommitResponseData = {
    sha: string;
    url: string;
    author: GitGetCommitResponseDataAuthor;
    committer: GitGetCommitResponseDataCommitter;
    message: string;
    tree: GitGetCommitResponseDataTree;
    parents: Array<GitGetCommitResponseDataParentsItem>;
    verification: GitGetCommitResponseDataVerification;
};
declare type GitListMatchingRefsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * ref parameter
     */
    ref: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type GitListMatchingRefsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/git/matching-refs/:ref";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitListMatchingRefsResponseDataItemObject = {
    type: string;
    sha: string;
    url: string;
};
declare type GitListMatchingRefsResponseDataItem = {
    ref: string;
    node_id: string;
    url: string;
    object: GitListMatchingRefsResponseDataItemObject;
};
declare type GitListMatchingRefsResponseData = Array<GitListMatchingRefsResponseDataItem>;
declare type GitGetRefEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * ref parameter
     */
    ref: string;
};
declare type GitGetRefRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/git/ref/:ref";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitGetRefResponseDataObject = {
    type: string;
    sha: string;
    url: string;
};
declare type GitGetRefResponseData = {
    ref: string;
    node_id: string;
    url: string;
    object: GitGetRefResponseDataObject;
};
declare type GitCreateRefEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The name of the fully qualified reference (ie: `refs/heads/master`). If it doesn't start with 'refs' and have at least two slashes, it will be rejected.
     */
    ref: string;
    /**
     * The SHA1 value for this reference.
     */
    sha: string;
};
declare type GitCreateRefRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/git/refs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitCreateRefResponseDataObject = {
    type: string;
    sha: string;
    url: string;
};
declare type GitCreateRefResponseData = {
    ref: string;
    node_id: string;
    url: string;
    object: GitCreateRefResponseDataObject;
};
declare type GitUpdateRefEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * ref parameter
     */
    ref: string;
    /**
     * The SHA1 value to set this reference to
     */
    sha: string;
    /**
     * Indicates whether to force the update or to make sure the update is a fast-forward update. Leaving this out or setting it to `false` will make sure you're not overwriting work.
     */
    force?: boolean;
};
declare type GitUpdateRefRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/git/refs/:ref";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitUpdateRefResponseDataObject = {
    type: string;
    sha: string;
    url: string;
};
declare type GitUpdateRefResponseData = {
    ref: string;
    node_id: string;
    url: string;
    object: GitUpdateRefResponseDataObject;
};
declare type GitDeleteRefEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * ref parameter
     */
    ref: string;
};
declare type GitDeleteRefRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/git/refs/:ref";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitCreateTagEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The tag's name. This is typically a version (e.g., "v0.0.1").
     */
    tag: string;
    /**
     * The tag message.
     */
    message: string;
    /**
     * The SHA of the git object this is tagging.
     */
    object: string;
    /**
     * The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.
     */
    type: "commit" | "tree" | "blob";
    /**
     * An object with information about the individual creating the tag.
     */
    tagger?: GitCreateTagParamsTagger;
};
declare type GitCreateTagRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/git/tags";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitCreateTagResponseDataVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type GitCreateTagResponseDataObject = {
    type: string;
    sha: string;
    url: string;
};
declare type GitCreateTagResponseDataTagger = {
    name: string;
    email: string;
    date: string;
};
declare type GitCreateTagResponseData = {
    node_id: string;
    tag: string;
    sha: string;
    url: string;
    message: string;
    tagger: GitCreateTagResponseDataTagger;
    object: GitCreateTagResponseDataObject;
    verification: GitCreateTagResponseDataVerification;
};
declare type GitGetTagEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * tag_sha parameter
     */
    tag_sha: string;
};
declare type GitGetTagRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/git/tags/:tag_sha";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitGetTagResponseDataVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type GitGetTagResponseDataObject = {
    type: string;
    sha: string;
    url: string;
};
declare type GitGetTagResponseDataTagger = {
    name: string;
    email: string;
    date: string;
};
declare type GitGetTagResponseData = {
    node_id: string;
    tag: string;
    sha: string;
    url: string;
    message: string;
    tagger: GitGetTagResponseDataTagger;
    object: GitGetTagResponseDataObject;
    verification: GitGetTagResponseDataVerification;
};
declare type GitCreateTreeEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure.
     */
    tree: GitCreateTreeParamsTree[];
    /**
     * The SHA1 of the tree you want to update with new data. If you don't set this, the commit will be created on top of everything; however, it will only contain your change, the rest of your files will show up as deleted.
     */
    base_tree?: string;
};
declare type GitCreateTreeRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/git/trees";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitCreateTreeResponseDataTreeItem = {
    path: string;
    mode: string;
    type: string;
    size: number;
    sha: string;
    url: string;
};
declare type GitCreateTreeResponseData = {
    sha: string;
    url: string;
    tree: Array<GitCreateTreeResponseDataTreeItem>;
};
declare type GitGetTreeEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * tree_sha parameter
     */
    tree_sha: string;
    /**
     * recursive parameter
     */
    recursive?: "1";
};
declare type GitGetTreeRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/git/trees/:tree_sha";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type GitGetTreeResponseDataTreeItem = {
    path: string;
    mode: string;
    type: string;
    size?: number;
    sha: string;
    url: string;
};
declare type GitGetTreeResponseData = {
    sha: string;
    url: string;
    tree: Array<GitGetTreeResponseDataTreeItem>;
    truncated: boolean;
};
declare type ReposListHooksEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListHooksRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/hooks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListHooksResponseDataItemLastResponse = {
    code: null;
    status: string;
    message: null;
};
declare type ReposListHooksResponseDataItemConfig = {
    content_type: string;
    insecure_ssl: string;
    url: string;
};
declare type ReposListHooksResponseDataItem = {
    type: string;
    id: number;
    name: string;
    active: boolean;
    events: Array<string>;
    config: ReposListHooksResponseDataItemConfig;
    updated_at: string;
    created_at: string;
    url: string;
    test_url: string;
    ping_url: string;
    last_response: ReposListHooksResponseDataItemLastResponse;
};
declare type ReposListHooksResponseData = Array<ReposListHooksResponseDataItem>;
declare type ReposCreateHookEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Use `web` to create a webhook. Default: `web`. This parameter only accepts the value `web`.
     */
    name?: string;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/repos/hooks/#create-hook-config-params).
     */
    config: ReposCreateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
     */
    events?: string[];
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
};
declare type ReposCreateHookRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/hooks";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposCreateHookResponseDataLastResponse = {
    code: null;
    status: string;
    message: null;
};
declare type ReposCreateHookResponseDataConfig = {
    content_type: string;
    insecure_ssl: string;
    url: string;
};
declare type ReposCreateHookResponseData = {
    type: string;
    id: number;
    name: string;
    active: boolean;
    events: Array<string>;
    config: ReposCreateHookResponseDataConfig;
    updated_at: string;
    created_at: string;
    url: string;
    test_url: string;
    ping_url: string;
    last_response: ReposCreateHookResponseDataLastResponse;
};
declare type ReposGetHookEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * hook_id parameter
     */
    hook_id: number;
};
declare type ReposGetHookRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/hooks/:hook_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetHookResponseDataLastResponse = {
    code: null;
    status: string;
    message: null;
};
declare type ReposGetHookResponseDataConfig = {
    content_type: string;
    insecure_ssl: string;
    url: string;
};
declare type ReposGetHookResponseData = {
    type: string;
    id: number;
    name: string;
    active: boolean;
    events: Array<string>;
    config: ReposGetHookResponseDataConfig;
    updated_at: string;
    created_at: string;
    url: string;
    test_url: string;
    ping_url: string;
    last_response: ReposGetHookResponseDataLastResponse;
};
declare type ReposUpdateHookEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * hook_id parameter
     */
    hook_id: number;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/repos/hooks/#create-hook-config-params).
     */
    config?: ReposUpdateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for. This replaces the entire array of events.
     */
    events?: string[];
    /**
     * Determines a list of events to be added to the list of events that the Hook triggers for.
     */
    add_events?: string[];
    /**
     * Determines a list of events to be removed from the list of events that the Hook triggers for.
     */
    remove_events?: string[];
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
};
declare type ReposUpdateHookRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/hooks/:hook_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposUpdateHookResponseDataLastResponse = {
    code: null;
    status: string;
    message: null;
};
declare type ReposUpdateHookResponseDataConfig = {
    content_type: string;
    insecure_ssl: string;
    url: string;
};
declare type ReposUpdateHookResponseData = {
    type: string;
    id: number;
    name: string;
    active: boolean;
    events: Array<string>;
    config: ReposUpdateHookResponseDataConfig;
    updated_at: string;
    created_at: string;
    url: string;
    test_url: string;
    ping_url: string;
    last_response: ReposUpdateHookResponseDataLastResponse;
};
declare type ReposDeleteHookEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * hook_id parameter
     */
    hook_id: number;
};
declare type ReposDeleteHookRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/hooks/:hook_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposPingHookEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * hook_id parameter
     */
    hook_id: number;
};
declare type ReposPingHookRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/hooks/:hook_id/pings";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposTestPushHookEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * hook_id parameter
     */
    hook_id: number;
};
declare type ReposTestPushHookRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/hooks/:hook_id/tests";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsStartImportEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The URL of the originating repository.
     */
    vcs_url: string;
    /**
     * The originating VCS type. Can be one of `subversion`, `git`, `mercurial`, or `tfvc`. Please be aware that without this parameter, the import job will take additional time to detect the VCS type before beginning the import. This detection step will be reflected in the response.
     */
    vcs?: "subversion" | "git" | "mercurial" | "tfvc";
    /**
     * If authentication is required, the username to provide to `vcs_url`.
     */
    vcs_username?: string;
    /**
     * If authentication is required, the password to provide to `vcs_url`.
     */
    vcs_password?: string;
    /**
     * For a tfvc import, the name of the project that is being imported.
     */
    tfvc_project?: string;
};
declare type MigrationsStartImportRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/import";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsStartImportResponseData = {
    vcs: string;
    use_lfs: string;
    vcs_url: string;
    status: string;
    status_text: string;
    has_large_files: boolean;
    large_files_size: number;
    large_files_count: number;
    authors_count: number;
    percent: number;
    commit_count: number;
    url: string;
    html_url: string;
    authors_url: string;
    repository_url: string;
};
declare type MigrationsGetImportProgressEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type MigrationsGetImportProgressRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/import";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsGetImportProgressResponseData = {
    vcs: string;
    use_lfs: string;
    vcs_url: string;
    status: string;
    status_text: string;
    has_large_files: boolean;
    large_files_size: number;
    large_files_count: number;
    authors_count: number;
    url: string;
    html_url: string;
    authors_url: string;
    repository_url: string;
};
declare type MigrationsUpdateImportEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The username to provide to the originating repository.
     */
    vcs_username?: string;
    /**
     * The password to provide to the originating repository.
     */
    vcs_password?: string;
};
declare type MigrationsUpdateImportRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/import";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsUpdateImportResponseData = {
    vcs: string;
    use_lfs: string;
    vcs_url: string;
    status: string;
    url: string;
    html_url: string;
    authors_url: string;
    repository_url: string;
    tfvc_project?: string;
    status_text?: string;
    has_large_files?: boolean;
    large_files_size?: number;
    large_files_count?: number;
    authors_count?: number;
    percent?: number;
    commit_count?: number;
};
declare type MigrationsCancelImportEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type MigrationsCancelImportRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/import";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsGetCommitAuthorsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Only authors found after this id are returned. Provide the highest author ID you've seen so far. New authors may be added to the list at any point while the importer is performing the `raw` step.
     */
    since?: string;
};
declare type MigrationsGetCommitAuthorsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/import/authors";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsGetCommitAuthorsResponseDataItem = {
    id: number;
    remote_id: string;
    remote_name: string;
    email: string;
    name: string;
    url: string;
    import_url: string;
};
declare type MigrationsGetCommitAuthorsResponseData = Array<MigrationsGetCommitAuthorsResponseDataItem>;
declare type MigrationsMapCommitAuthorEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * author_id parameter
     */
    author_id: number;
    /**
     * The new Git author email.
     */
    email?: string;
    /**
     * The new Git author name.
     */
    name?: string;
};
declare type MigrationsMapCommitAuthorRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/import/authors/:author_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsMapCommitAuthorResponseData = {
    id: number;
    remote_id: string;
    remote_name: string;
    email: string;
    name: string;
    url: string;
    import_url: string;
};
declare type MigrationsGetLargeFilesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type MigrationsGetLargeFilesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/import/large_files";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsGetLargeFilesResponseDataItem = {
    ref_name: string;
    path: string;
    oid: string;
    size: number;
};
declare type MigrationsGetLargeFilesResponseData = Array<MigrationsGetLargeFilesResponseDataItem>;
declare type MigrationsSetLfsPreferenceEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Can be one of `opt_in` (large files will be stored using Git LFS) or `opt_out` (large files will be removed during the import).
     */
    use_lfs: "opt_in" | "opt_out";
};
declare type MigrationsSetLfsPreferenceRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/import/lfs";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type MigrationsSetLfsPreferenceResponseData = {
    vcs: string;
    use_lfs: string;
    vcs_url: string;
    status: string;
    status_text: string;
    has_large_files: boolean;
    large_files_size: number;
    large_files_count: number;
    authors_count: number;
    url: string;
    html_url: string;
    authors_url: string;
    repository_url: string;
};
declare type AppsGetRepoInstallationEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
} & RequiredPreview<"machine-man">;
declare type AppsGetRepoInstallationRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/installation";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type AppsGetRepoInstallationResponseDataPermissions = {
    checks: string;
    metadata: string;
    contents: string;
};
declare type AppsGetRepoInstallationResponseDataAccount = {
    login: string;
    id: number;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type AppsGetRepoInstallationResponseData = {
    id: number;
    account: AppsGetRepoInstallationResponseDataAccount;
    repository_selection: string;
    access_tokens_url: string;
    repositories_url: string;
    html_url: string;
    app_id: number;
    target_id: number;
    target_type: string;
    permissions: AppsGetRepoInstallationResponseDataPermissions;
    events: Array<string>;
    created_at: string;
    updated_at: string;
    single_file_name: null;
};
declare type InteractionsGetRestrictionsForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
} & RequiredPreview<"sombra">;
declare type InteractionsGetRestrictionsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/interaction-limits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type InteractionsGetRestrictionsForRepoResponseData = {
    limit: string;
    origin: string;
    expires_at: string;
};
declare type InteractionsAddOrUpdateRestrictionsForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Specifies the group of GitHub users who can comment, open issues, or create pull requests for the given repository. Must be one of: `existing_users`, `contributors_only`, or `collaborators_only`.
     */
    limit: "existing_users" | "contributors_only" | "collaborators_only";
} & RequiredPreview<"sombra">;
declare type InteractionsAddOrUpdateRestrictionsForRepoRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/interaction-limits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type InteractionsAddOrUpdateRestrictionsForRepoResponseData = {
    limit: string;
    origin: string;
    expires_at: string;
};
declare type InteractionsRemoveRestrictionsForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
} & RequiredPreview<"sombra">;
declare type InteractionsRemoveRestrictionsForRepoRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/interaction-limits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListInvitationsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListInvitationsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/invitations";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListInvitationsResponseDataItemInviter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListInvitationsResponseDataItemInvitee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListInvitationsResponseDataItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListInvitationsResponseDataItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposListInvitationsResponseDataItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
};
declare type ReposListInvitationsResponseDataItem = {
    id: number;
    repository: ReposListInvitationsResponseDataItemRepository;
    invitee: ReposListInvitationsResponseDataItemInvitee;
    inviter: ReposListInvitationsResponseDataItemInviter;
    permissions: string;
    created_at: string;
    url: string;
    html_url: string;
};
declare type ReposListInvitationsResponseData = Array<ReposListInvitationsResponseDataItem>;
declare type ReposDeleteInvitationEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * invitation_id parameter
     */
    invitation_id: number;
};
declare type ReposDeleteInvitationRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/invitations/:invitation_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposUpdateInvitationEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * invitation_id parameter
     */
    invitation_id: number;
    /**
     * The permissions that the associated user will have on the repository. Valid values are `read`, `write`, `maintain`, `triage`, and `admin`.
     */
    permissions?: "read" | "write" | "maintain" | "triage" | "admin";
};
declare type ReposUpdateInvitationRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/invitations/:invitation_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposUpdateInvitationResponseDataInviter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateInvitationResponseDataInvitee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateInvitationResponseDataRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateInvitationResponseDataRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ReposUpdateInvitationResponseDataRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
};
declare type ReposUpdateInvitationResponseData = {
    id: number;
    repository: ReposUpdateInvitationResponseDataRepository;
    invitee: ReposUpdateInvitationResponseDataInvitee;
    inviter: ReposUpdateInvitationResponseDataInviter;
    permissions: string;
    created_at: string;
    url: string;
    html_url: string;
};
declare type IssuesListForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * If an `integer` is passed, it should refer to a milestone by its `number` field. If the string `*` is passed, issues with any milestone are accepted. If the string `none` is passed, issues without milestones are returned.
     */
    milestone?: string;
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * Can be the name of a user. Pass in `none` for issues with no assigned user, and `*` for issues assigned to any user.
     */
    assignee?: string;
    /**
     * The user that created the issue.
     */
    creator?: string;
    /**
     * A user that's mentioned in the issue.
     */
    mentioned?: string;
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListForRepoResponseDataItemPullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
};
declare type IssuesListForRepoResponseDataItemMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListForRepoResponseDataItemMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesListForRepoResponseDataItemMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesListForRepoResponseDataItemAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListForRepoResponseDataItemAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListForRepoResponseDataItemLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesListForRepoResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListForRepoResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesListForRepoResponseDataItemUser;
    labels: Array<IssuesListForRepoResponseDataItemLabelsItem>;
    assignee: IssuesListForRepoResponseDataItemAssignee;
    assignees: Array<IssuesListForRepoResponseDataItemAssigneesItem>;
    milestone: IssuesListForRepoResponseDataItemMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesListForRepoResponseDataItemPullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
};
declare type IssuesListForRepoResponseData = Array<IssuesListForRepoResponseDataItem>;
declare type IssuesCreateEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The title of the issue.
     */
    title: string;
    /**
     * The contents of the issue.
     */
    body?: string;
    /**
     * Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is deprecated.**_
     */
    assignee?: string;
    /**
     * The `number` of the milestone to associate this issue with. _NOTE: Only users with push access can set the milestone for new issues. The milestone is silently dropped otherwise._
     */
    milestone?: number;
    /**
     * Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
};
declare type IssuesCreateRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/issues";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesCreateResponseDataClosedBy = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesCreateResponseDataPullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
};
declare type IssuesCreateResponseDataMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesCreateResponseDataMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesCreateResponseDataMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesCreateResponseDataAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesCreateResponseDataAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesCreateResponseDataLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesCreateResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesCreateResponseData = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesCreateResponseDataUser;
    labels: Array<IssuesCreateResponseDataLabelsItem>;
    assignee: IssuesCreateResponseDataAssignee;
    assignees: Array<IssuesCreateResponseDataAssigneesItem>;
    milestone: IssuesCreateResponseDataMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesCreateResponseDataPullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
    closed_by: IssuesCreateResponseDataClosedBy;
};
declare type IssuesListCommentsForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Either `created` or `updated`.
     */
    sort?: "created" | "updated";
    /**
     * Either `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListCommentsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListCommentsForRepoResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListCommentsForRepoResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: IssuesListCommentsForRepoResponseDataItemUser;
    created_at: string;
    updated_at: string;
};
declare type IssuesListCommentsForRepoResponseData = Array<IssuesListCommentsForRepoResponseDataItem>;
declare type IssuesGetCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
};
declare type IssuesGetCommentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesGetCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesGetCommentResponseData = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: IssuesGetCommentResponseDataUser;
    created_at: string;
    updated_at: string;
};
declare type IssuesUpdateCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * The contents of the comment.
     */
    body: string;
};
declare type IssuesUpdateCommentRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/issues/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesUpdateCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesUpdateCommentResponseData = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: IssuesUpdateCommentResponseDataUser;
    created_at: string;
    updated_at: string;
};
declare type IssuesDeleteCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
};
declare type IssuesDeleteCommentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsListForIssueCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForIssueCommentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/comments/:comment_id/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsListForIssueCommentResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReactionsListForIssueCommentResponseDataItem = {
    id: number;
    node_id: string;
    user: ReactionsListForIssueCommentResponseDataItemUser;
    content: string;
    created_at: string;
};
declare type ReactionsListForIssueCommentResponseData = Array<ReactionsListForIssueCommentResponseDataItem>;
declare type ReactionsCreateForIssueCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForIssueCommentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/issues/comments/:comment_id/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsCreateForIssueCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReactionsCreateForIssueCommentResponseData = {
    id: number;
    node_id: string;
    user: ReactionsCreateForIssueCommentResponseDataUser;
    content: string;
    created_at: string;
};
declare type ReactionsDeleteForIssueCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * reaction_id parameter
     */
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteForIssueCommentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/comments/:comment_id/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListEventsForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListEventsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListEventsForRepoResponseDataItemIssuePullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
};
declare type IssuesListEventsForRepoResponseDataItemIssueMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListEventsForRepoResponseDataItemIssueMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesListEventsForRepoResponseDataItemIssueMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesListEventsForRepoResponseDataItemIssueAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListEventsForRepoResponseDataItemIssueAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListEventsForRepoResponseDataItemIssueLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesListEventsForRepoResponseDataItemIssueUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListEventsForRepoResponseDataItemIssue = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesListEventsForRepoResponseDataItemIssueUser;
    labels: Array<IssuesListEventsForRepoResponseDataItemIssueLabelsItem>;
    assignee: IssuesListEventsForRepoResponseDataItemIssueAssignee;
    assignees: Array<IssuesListEventsForRepoResponseDataItemIssueAssigneesItem>;
    milestone: IssuesListEventsForRepoResponseDataItemIssueMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesListEventsForRepoResponseDataItemIssuePullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
};
declare type IssuesListEventsForRepoResponseDataItemActor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListEventsForRepoResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    actor: IssuesListEventsForRepoResponseDataItemActor;
    event: string;
    commit_id: string;
    commit_url: string;
    created_at: string;
    issue: IssuesListEventsForRepoResponseDataItemIssue;
};
declare type IssuesListEventsForRepoResponseData = Array<IssuesListEventsForRepoResponseDataItem>;
declare type IssuesGetEventEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * event_id parameter
     */
    event_id: number;
};
declare type IssuesGetEventRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/events/:event_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesGetEventResponseDataIssuePullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
};
declare type IssuesGetEventResponseDataIssueMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesGetEventResponseDataIssueMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesGetEventResponseDataIssueMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesGetEventResponseDataIssueAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesGetEventResponseDataIssueAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesGetEventResponseDataIssueLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesGetEventResponseDataIssueUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesGetEventResponseDataIssue = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesGetEventResponseDataIssueUser;
    labels: Array<IssuesGetEventResponseDataIssueLabelsItem>;
    assignee: IssuesGetEventResponseDataIssueAssignee;
    assignees: Array<IssuesGetEventResponseDataIssueAssigneesItem>;
    milestone: IssuesGetEventResponseDataIssueMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesGetEventResponseDataIssuePullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
};
declare type IssuesGetEventResponseDataActor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesGetEventResponseData = {
    id: number;
    node_id: string;
    url: string;
    actor: IssuesGetEventResponseDataActor;
    event: string;
    commit_id: string;
    commit_url: string;
    created_at: string;
    issue: IssuesGetEventResponseDataIssue;
};
declare type IssuesGetEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
};
declare type IssuesGetRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/:issue_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesGetResponseDataClosedBy = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesGetResponseDataPullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
};
declare type IssuesGetResponseDataMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesGetResponseDataMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesGetResponseDataMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesGetResponseDataAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesGetResponseDataAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesGetResponseDataLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesGetResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesGetResponseData = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesGetResponseDataUser;
    labels: Array<IssuesGetResponseDataLabelsItem>;
    assignee: IssuesGetResponseDataAssignee;
    assignees: Array<IssuesGetResponseDataAssigneesItem>;
    milestone: IssuesGetResponseDataMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesGetResponseDataPullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
    closed_by: IssuesGetResponseDataClosedBy;
};
declare type IssuesUpdateEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * The title of the issue.
     */
    title?: string;
    /**
     * The contents of the issue.
     */
    body?: string;
    /**
     * Login for the user that this issue should be assigned to. **This field is deprecated.**
     */
    assignee?: string;
    /**
     * State of the issue. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The `number` of the milestone to associate this issue with or `null` to remove current. _NOTE: Only users with push access can set the milestone for issues. The milestone is silently dropped otherwise._
     */
    milestone?: number | null;
    /**
     * Labels to associate with this issue. Pass one or more Labels to _replace_ the set of Labels on this Issue. Send an empty array (`[]`) to clear all Labels from the Issue. _NOTE: Only users with push access can set labels for issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * Logins for Users to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this Issue. Send an empty array (`[]`) to clear all assignees from the Issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
};
declare type IssuesUpdateRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/issues/:issue_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesUpdateResponseDataClosedBy = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesUpdateResponseDataPullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
};
declare type IssuesUpdateResponseDataMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesUpdateResponseDataMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesUpdateResponseDataMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesUpdateResponseDataAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesUpdateResponseDataAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesUpdateResponseDataLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesUpdateResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesUpdateResponseData = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesUpdateResponseDataUser;
    labels: Array<IssuesUpdateResponseDataLabelsItem>;
    assignee: IssuesUpdateResponseDataAssignee;
    assignees: Array<IssuesUpdateResponseDataAssigneesItem>;
    milestone: IssuesUpdateResponseDataMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesUpdateResponseDataPullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
    closed_by: IssuesUpdateResponseDataClosedBy;
};
declare type IssuesAddAssigneesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];
};
declare type IssuesAddAssigneesRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/issues/:issue_number/assignees";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesAddAssigneesResponseDataPullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
};
declare type IssuesAddAssigneesResponseDataMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesAddAssigneesResponseDataMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesAddAssigneesResponseDataMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesAddAssigneesResponseDataAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesAddAssigneesResponseDataAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesAddAssigneesResponseDataLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesAddAssigneesResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesAddAssigneesResponseData = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesAddAssigneesResponseDataUser;
    labels: Array<IssuesAddAssigneesResponseDataLabelsItem>;
    assignee: IssuesAddAssigneesResponseDataAssignee;
    assignees: Array<IssuesAddAssigneesResponseDataAssigneesItem>;
    milestone: IssuesAddAssigneesResponseDataMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesAddAssigneesResponseDataPullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
};
declare type IssuesRemoveAssigneesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];
};
declare type IssuesRemoveAssigneesRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/:issue_number/assignees";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesRemoveAssigneesResponseDataPullRequest = {
    url: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
};
declare type IssuesRemoveAssigneesResponseDataMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesRemoveAssigneesResponseDataMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesRemoveAssigneesResponseDataMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesRemoveAssigneesResponseDataAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesRemoveAssigneesResponseDataAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesRemoveAssigneesResponseDataLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesRemoveAssigneesResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesRemoveAssigneesResponseData = {
    id: number;
    node_id: string;
    url: string;
    repository_url: string;
    labels_url: string;
    comments_url: string;
    events_url: string;
    html_url: string;
    number: number;
    state: string;
    title: string;
    body: string;
    user: IssuesRemoveAssigneesResponseDataUser;
    labels: Array<IssuesRemoveAssigneesResponseDataLabelsItem>;
    assignee: IssuesRemoveAssigneesResponseDataAssignee;
    assignees: Array<IssuesRemoveAssigneesResponseDataAssigneesItem>;
    milestone: IssuesRemoveAssigneesResponseDataMilestone;
    locked: boolean;
    active_lock_reason: string;
    comments: number;
    pull_request: IssuesRemoveAssigneesResponseDataPullRequest;
    closed_at: null;
    created_at: string;
    updated_at: string;
};
declare type IssuesListCommentsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListCommentsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/:issue_number/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListCommentsResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListCommentsResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: IssuesListCommentsResponseDataItemUser;
    created_at: string;
    updated_at: string;
};
declare type IssuesListCommentsResponseData = Array<IssuesListCommentsResponseDataItem>;
declare type IssuesCreateCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * The contents of the comment.
     */
    body: string;
};
declare type IssuesCreateCommentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/issues/:issue_number/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesCreateCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesCreateCommentResponseData = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    body: string;
    user: IssuesCreateCommentResponseDataUser;
    created_at: string;
    updated_at: string;
};
declare type IssuesListEventsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListEventsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/:issue_number/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListEventsResponseDataItemActor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListEventsResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    actor: IssuesListEventsResponseDataItemActor;
    event: string;
    commit_id: string;
    commit_url: string;
    created_at: string;
};
declare type IssuesListEventsResponseData = Array<IssuesListEventsResponseDataItem>;
declare type IssuesListLabelsOnIssueEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListLabelsOnIssueRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/:issue_number/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListLabelsOnIssueResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesListLabelsOnIssueResponseData = Array<IssuesListLabelsOnIssueResponseDataItem>;
declare type IssuesAddLabelsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * The name of the label to add to the issue. Must contain at least one label. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels: string[];
};
declare type IssuesAddLabelsRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/issues/:issue_number/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesAddLabelsResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesAddLabelsResponseData = Array<IssuesAddLabelsResponseDataItem>;
declare type IssuesReplaceAllLabelsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * The names of the labels to add to the issue. You can pass an empty array to remove all labels. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels?: string[];
};
declare type IssuesReplaceAllLabelsRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/issues/:issue_number/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesReplaceAllLabelsResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesReplaceAllLabelsResponseData = Array<IssuesReplaceAllLabelsResponseDataItem>;
declare type IssuesRemoveAllLabelsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
};
declare type IssuesRemoveAllLabelsRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/:issue_number/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesRemoveLabelEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * name parameter
     */
    name: string;
};
declare type IssuesRemoveLabelRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/:issue_number/labels/:name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesRemoveLabelResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesRemoveLabelResponseData = Array<IssuesRemoveLabelResponseDataItem>;
declare type IssuesLockEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:
     * \* `off-topic`
     * \* `too heated`
     * \* `resolved`
     * \* `spam`
     */
    lock_reason?: "off-topic" | "too heated" | "resolved" | "spam";
};
declare type IssuesLockRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/issues/:issue_number/lock";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesUnlockEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
};
declare type IssuesUnlockRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/:issue_number/lock";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsListForIssueEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForIssueRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/:issue_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsListForIssueResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReactionsListForIssueResponseDataItem = {
    id: number;
    node_id: string;
    user: ReactionsListForIssueResponseDataItemUser;
    content: string;
    created_at: string;
};
declare type ReactionsListForIssueResponseData = Array<ReactionsListForIssueResponseDataItem>;
declare type ReactionsCreateForIssueEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForIssueRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/issues/:issue_number/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsCreateForIssueResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReactionsCreateForIssueResponseData = {
    id: number;
    node_id: string;
    user: ReactionsCreateForIssueResponseDataUser;
    content: string;
    created_at: string;
};
declare type ReactionsDeleteForIssueEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * reaction_id parameter
     */
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteForIssueRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/issues/:issue_number/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListEventsForTimelineEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"mockingbird">;
declare type IssuesListEventsForTimelineRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/issues/:issue_number/timeline";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListEventsForTimelineResponseDataItemActor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListEventsForTimelineResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    actor: IssuesListEventsForTimelineResponseDataItemActor;
    event: string;
    commit_id: string;
    commit_url: string;
    created_at: string;
};
declare type IssuesListEventsForTimelineResponseData = Array<IssuesListEventsForTimelineResponseDataItem>;
declare type ReposListDeployKeysEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListDeployKeysRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/keys";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListDeployKeysResponseDataItem = {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
};
declare type ReposListDeployKeysResponseData = Array<ReposListDeployKeysResponseDataItem>;
declare type ReposAddDeployKeyEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * A name for the key.
     */
    title?: string;
    /**
     * The contents of the key.
     */
    key: string;
    /**
     * If `true`, the key will only be able to read repository contents. Otherwise, the key will be able to read and write.
     *
     * Deploy keys with write access can perform the same actions as an organization member with admin access, or a collaborator on a personal repository. For more information, see "[Repository permission levels for an organization](https://help.github.com/articles/repository-permission-levels-for-an-organization/)" and "[Permission levels for a user account repository](https://help.github.com/articles/permission-levels-for-a-user-account-repository/)."
     */
    read_only?: boolean;
};
declare type ReposAddDeployKeyRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/keys";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposAddDeployKeyResponseData = {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
};
declare type ReposGetDeployKeyEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * key_id parameter
     */
    key_id: number;
};
declare type ReposGetDeployKeyRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/keys/:key_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetDeployKeyResponseData = {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
};
declare type ReposRemoveDeployKeyEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * key_id parameter
     */
    key_id: number;
};
declare type ReposRemoveDeployKeyRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/keys/:key_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListLabelsForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListLabelsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListLabelsForRepoResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesListLabelsForRepoResponseData = Array<IssuesListLabelsForRepoResponseDataItem>;
declare type IssuesCreateLabelEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
     */
    name: string;
    /**
     * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
     */
    color: string;
    /**
     * A short description of the label.
     */
    description?: string;
};
declare type IssuesCreateLabelRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesCreateLabelResponseData = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesGetLabelEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * name parameter
     */
    name: string;
};
declare type IssuesGetLabelRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/labels/:name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesGetLabelResponseData = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesUpdateLabelEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * name parameter
     */
    name: string;
    /**
     * The new name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
     */
    new_name?: string;
    /**
     * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
     */
    color?: string;
    /**
     * A short description of the label.
     */
    description?: string;
};
declare type IssuesUpdateLabelRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/labels/:name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesUpdateLabelResponseData = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesDeleteLabelEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * name parameter
     */
    name: string;
};
declare type IssuesDeleteLabelRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/labels/:name";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListLanguagesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposListLanguagesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/languages";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListLanguagesResponseData = {
    C: number;
    Python: number;
};
declare type LicensesGetForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type LicensesGetForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/license";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type LicensesGetForRepoResponseDataLicense = {
    key: string;
    name: string;
    spdx_id: string;
    url: string;
    node_id: string;
};
declare type LicensesGetForRepoResponseDataLinks = {
    self: string;
    git: string;
    html: string;
};
declare type LicensesGetForRepoResponseData = {
    name: string;
    path: string;
    sha: string;
    size: number;
    url: string;
    html_url: string;
    git_url: string;
    download_url: string;
    type: string;
    content: string;
    encoding: string;
    _links: LicensesGetForRepoResponseDataLinks;
    license: LicensesGetForRepoResponseDataLicense;
};
declare type ReposMergeEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The name of the base branch that the head will be merged into.
     */
    base: string;
    /**
     * The head to merge. This can be a branch name or a commit SHA1.
     */
    head: string;
    /**
     * Commit message to use for the merge commit. If omitted, a default message will be used.
     */
    commit_message?: string;
};
declare type ReposMergeRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/merges";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposMergeResponseDataParentsItem = {
    sha: string;
    url: string;
};
declare type ReposMergeResponseDataCommitter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposMergeResponseDataAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposMergeResponseDataCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type ReposMergeResponseDataCommitTree = {
    sha: string;
    url: string;
};
declare type ReposMergeResponseDataCommitCommitter = {
    name: string;
    date: string;
    email: string;
};
declare type ReposMergeResponseDataCommitAuthor = {
    name: string;
    date: string;
    email: string;
};
declare type ReposMergeResponseDataCommit = {
    author: ReposMergeResponseDataCommitAuthor;
    committer: ReposMergeResponseDataCommitCommitter;
    message: string;
    tree: ReposMergeResponseDataCommitTree;
    url: string;
    comment_count: number;
    verification: ReposMergeResponseDataCommitVerification;
};
declare type ReposMergeResponseData = {
    sha: string;
    node_id: string;
    commit: ReposMergeResponseDataCommit;
    url: string;
    html_url: string;
    comments_url: string;
    author: ReposMergeResponseDataAuthor;
    committer: ReposMergeResponseDataCommitter;
    parents: Array<ReposMergeResponseDataParentsItem>;
};
declare type IssuesListMilestonesForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The state of the milestone. Either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * What to sort results by. Either `due_on` or `completeness`.
     */
    sort?: "due_on" | "completeness";
    /**
     * The direction of the sort. Either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListMilestonesForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/milestones";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListMilestonesForRepoResponseDataItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesListMilestonesForRepoResponseDataItem = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesListMilestonesForRepoResponseDataItemCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesListMilestonesForRepoResponseData = Array<IssuesListMilestonesForRepoResponseDataItem>;
declare type IssuesCreateMilestoneEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The title of the milestone.
     */
    title: string;
    /**
     * The state of the milestone. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * A description of the milestone.
     */
    description?: string;
    /**
     * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    due_on?: string;
};
declare type IssuesCreateMilestoneRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/milestones";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesCreateMilestoneResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesCreateMilestoneResponseData = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesCreateMilestoneResponseDataCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesGetMilestoneEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * milestone_number parameter
     */
    milestone_number: number;
};
declare type IssuesGetMilestoneRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/milestones/:milestone_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesGetMilestoneResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesGetMilestoneResponseData = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesGetMilestoneResponseDataCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesUpdateMilestoneEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * milestone_number parameter
     */
    milestone_number: number;
    /**
     * The title of the milestone.
     */
    title?: string;
    /**
     * The state of the milestone. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * A description of the milestone.
     */
    description?: string;
    /**
     * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    due_on?: string;
};
declare type IssuesUpdateMilestoneRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/milestones/:milestone_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesUpdateMilestoneResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type IssuesUpdateMilestoneResponseData = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: IssuesUpdateMilestoneResponseDataCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type IssuesDeleteMilestoneEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * milestone_number parameter
     */
    milestone_number: number;
};
declare type IssuesDeleteMilestoneRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/milestones/:milestone_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListLabelsForMilestoneEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * milestone_number parameter
     */
    milestone_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type IssuesListLabelsForMilestoneRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/milestones/:milestone_number/labels";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type IssuesListLabelsForMilestoneResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type IssuesListLabelsForMilestoneResponseData = Array<IssuesListLabelsForMilestoneResponseDataItem>;
declare type ActivityListRepoNotificationsForAuthenticatedUserEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * If `true`, show notifications marked as read.
     */
    all?: boolean;
    /**
     * If `true`, only shows notifications in which the user is directly participating or mentioned.
     */
    participating?: boolean;
    /**
     * Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    before?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListRepoNotificationsForAuthenticatedUserRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/notifications";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListRepoNotificationsForAuthenticatedUserResponseDataItemSubject = {
    title: string;
    url: string;
    latest_comment_url: string;
    type: string;
};
declare type ActivityListRepoNotificationsForAuthenticatedUserResponseDataItemRepositoryOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ActivityListRepoNotificationsForAuthenticatedUserResponseDataItemRepository = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: ActivityListRepoNotificationsForAuthenticatedUserResponseDataItemRepositoryOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
};
declare type ActivityListRepoNotificationsForAuthenticatedUserResponseDataItem = {
    id: string;
    repository: ActivityListRepoNotificationsForAuthenticatedUserResponseDataItemRepository;
    subject: ActivityListRepoNotificationsForAuthenticatedUserResponseDataItemSubject;
    reason: string;
    unread: boolean;
    updated_at: string;
    last_read_at: string;
    url: string;
};
declare type ActivityListRepoNotificationsForAuthenticatedUserResponseData = Array<ActivityListRepoNotificationsForAuthenticatedUserResponseDataItem>;
declare type ActivityMarkRepoNotificationsAsReadEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
     */
    last_read_at?: string;
};
declare type ActivityMarkRepoNotificationsAsReadRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/notifications";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetPagesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposGetPagesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pages";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetPagesResponseDataSource = {
    branch: string;
    directory: string;
};
declare type ReposGetPagesResponseData = {
    url: string;
    status: string;
    cname: string;
    custom_404: boolean;
    html_url: string;
    source: ReposGetPagesResponseDataSource;
};
declare type ReposEnablePagesSiteEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * source parameter
     */
    source?: ReposEnablePagesSiteParamsSource;
} & RequiredPreview<"switcheroo">;
declare type ReposEnablePagesSiteRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pages";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposEnablePagesSiteResponseDataSource = {
    branch: string;
    directory: string;
};
declare type ReposEnablePagesSiteResponseData = {
    url: string;
    status: string;
    cname: string;
    custom_404: boolean;
    html_url: string;
    source: ReposEnablePagesSiteResponseDataSource;
};
declare type ReposDisablePagesSiteEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
} & RequiredPreview<"switcheroo">;
declare type ReposDisablePagesSiteRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/pages";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposUpdateInformationAboutPagesSiteEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Specify a custom domain for the repository. Sending a `null` value will remove the custom domain. For more about custom domains, see "[Using a custom domain with GitHub Pages](https://help.github.com/articles/using-a-custom-domain-with-github-pages/)."
     */
    cname?: string;
    /**
     * Update the source for the repository. Must include the branch name, and may optionally specify the subdirectory `/docs`. Possible values are `"gh-pages"`, `"master"`, and `"master /docs"`.
     */
    source?: '"gh-pages"' | '"master"' | '"master /docs"';
};
declare type ReposUpdateInformationAboutPagesSiteRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/pages";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposRequestPageBuildEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposRequestPageBuildRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pages/builds";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposRequestPageBuildResponseData = {
    url: string;
    status: string;
};
declare type ReposListPagesBuildsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListPagesBuildsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pages/builds";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListPagesBuildsResponseDataItemPusher = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListPagesBuildsResponseDataItemError = {
    message: null;
};
declare type ReposListPagesBuildsResponseDataItem = {
    url: string;
    status: string;
    error: ReposListPagesBuildsResponseDataItemError;
    pusher: ReposListPagesBuildsResponseDataItemPusher;
    commit: string;
    duration: number;
    created_at: string;
    updated_at: string;
};
declare type ReposListPagesBuildsResponseData = Array<ReposListPagesBuildsResponseDataItem>;
declare type ReposGetLatestPagesBuildEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposGetLatestPagesBuildRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pages/builds/latest";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetLatestPagesBuildResponseDataPusher = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetLatestPagesBuildResponseDataError = {
    message: null;
};
declare type ReposGetLatestPagesBuildResponseData = {
    url: string;
    status: string;
    error: ReposGetLatestPagesBuildResponseDataError;
    pusher: ReposGetLatestPagesBuildResponseDataPusher;
    commit: string;
    duration: number;
    created_at: string;
    updated_at: string;
};
declare type ReposGetPagesBuildEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * build_id parameter
     */
    build_id: number;
};
declare type ReposGetPagesBuildRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pages/builds/:build_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetPagesBuildResponseDataPusher = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetPagesBuildResponseDataError = {
    message: null;
};
declare type ReposGetPagesBuildResponseData = {
    url: string;
    status: string;
    error: ReposGetPagesBuildResponseDataError;
    pusher: ReposGetPagesBuildResponseDataPusher;
    commit: string;
    duration: number;
    created_at: string;
    updated_at: string;
};
declare type ProjectsListForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"inertia">;
declare type ProjectsListForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/projects";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsListForRepoResponseDataItemCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ProjectsListForRepoResponseDataItem = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: ProjectsListForRepoResponseDataItemCreator;
    created_at: string;
    updated_at: string;
};
declare type ProjectsListForRepoResponseData = Array<ProjectsListForRepoResponseDataItem>;
declare type ProjectsCreateForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The name of the project.
     */
    name: string;
    /**
     * The description of the project.
     */
    body?: string;
} & RequiredPreview<"inertia">;
declare type ProjectsCreateForRepoRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/projects";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ProjectsCreateForRepoResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ProjectsCreateForRepoResponseData = {
    owner_url: string;
    url: string;
    html_url: string;
    columns_url: string;
    id: number;
    node_id: string;
    name: string;
    body: string;
    number: number;
    state: string;
    creator: ProjectsCreateForRepoResponseDataCreator;
    created_at: string;
    updated_at: string;
};
declare type PullsListEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Either `open`, `closed`, or `all` to filter by state.
     */
    state?: "open" | "closed" | "all";
    /**
     * Filter pulls by head user or head organization and branch name in the format of `user:ref-name` or `organization:ref-name`. For example: `github:new-script-format` or `octocat:test-branch`.
     */
    head?: string;
    /**
     * Filter pulls by base branch name. Example: `gh-pages`.
     */
    base?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `popularity` (comment count) or `long-running` (age, filtering by pulls updated in the last month).
     */
    sort?: "created" | "updated" | "popularity" | "long-running";
    /**
     * The direction of the sort. Can be either `asc` or `desc`. Default: `desc` when sort is `created` or sort is not specified, otherwise `asc`.
     */
    direction?: "asc" | "desc";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsListResponseDataItemLinksStatuses = {
    href: string;
};
declare type PullsListResponseDataItemLinksCommits = {
    href: string;
};
declare type PullsListResponseDataItemLinksReviewComment = {
    href: string;
};
declare type PullsListResponseDataItemLinksReviewComments = {
    href: string;
};
declare type PullsListResponseDataItemLinksComments = {
    href: string;
};
declare type PullsListResponseDataItemLinksIssue = {
    href: string;
};
declare type PullsListResponseDataItemLinksHtml = {
    href: string;
};
declare type PullsListResponseDataItemLinksSelf = {
    href: string;
};
declare type PullsListResponseDataItemLinks = {
    self: PullsListResponseDataItemLinksSelf;
    html: PullsListResponseDataItemLinksHtml;
    issue: PullsListResponseDataItemLinksIssue;
    comments: PullsListResponseDataItemLinksComments;
    review_comments: PullsListResponseDataItemLinksReviewComments;
    review_comment: PullsListResponseDataItemLinksReviewComment;
    commits: PullsListResponseDataItemLinksCommits;
    statuses: PullsListResponseDataItemLinksStatuses;
};
declare type PullsListResponseDataItemBaseRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type PullsListResponseDataItemBaseRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListResponseDataItemBaseRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullsListResponseDataItemBaseRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullsListResponseDataItemBaseRepoPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type PullsListResponseDataItemBaseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListResponseDataItemBase = {
    label: string;
    ref: string;
    sha: string;
    user: PullsListResponseDataItemBaseUser;
    repo: PullsListResponseDataItemBaseRepo;
};
declare type PullsListResponseDataItemHeadRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type PullsListResponseDataItemHeadRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListResponseDataItemHeadRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullsListResponseDataItemHeadRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullsListResponseDataItemHeadRepoPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type PullsListResponseDataItemHeadUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListResponseDataItemHead = {
    label: string;
    ref: string;
    sha: string;
    user: PullsListResponseDataItemHeadUser;
    repo: PullsListResponseDataItemHeadRepo;
};
declare type PullsListResponseDataItemRequestedTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type PullsListResponseDataItemRequestedReviewersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListResponseDataItemAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListResponseDataItemAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListResponseDataItemMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListResponseDataItemMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: PullsListResponseDataItemMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type PullsListResponseDataItemLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type PullsListResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListResponseDataItem = {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    locked: boolean;
    title: string;
    user: PullsListResponseDataItemUser;
    body: string;
    labels: Array<PullsListResponseDataItemLabelsItem>;
    milestone: PullsListResponseDataItemMilestone;
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    merge_commit_sha: string;
    assignee: PullsListResponseDataItemAssignee;
    assignees: Array<PullsListResponseDataItemAssigneesItem>;
    requested_reviewers: Array<PullsListResponseDataItemRequestedReviewersItem>;
    requested_teams: Array<PullsListResponseDataItemRequestedTeamsItem>;
    head: PullsListResponseDataItemHead;
    base: PullsListResponseDataItemBase;
    _links: PullsListResponseDataItemLinks;
    author_association: string;
    draft: boolean;
};
declare type PullsListResponseData = Array<PullsListResponseDataItem>;
declare type PullsCreateEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The title of the new pull request.
     */
    title: string;
    /**
     * The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head` with a user like this: `username:branch`.
     */
    head: string;
    /**
     * The name of the branch you want the changes pulled into. This should be an existing branch on the current repository. You cannot submit a pull request to one repository that requests a merge to a base of another repository.
     */
    base: string;
    /**
     * The contents of the pull request.
     */
    body?: string;
    /**
     * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
     */
    maintainer_can_modify?: boolean;
    /**
     * Indicates whether the pull request is a draft. See "[Draft Pull Requests](https://help.github.com/en/articles/about-pull-requests#draft-pull-requests)" in the GitHub Help documentation to learn more.
     */
    draft?: boolean;
};
declare type PullsCreateRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsCreateResponseDataMergedBy = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateResponseDataLinksStatuses = {
    href: string;
};
declare type PullsCreateResponseDataLinksCommits = {
    href: string;
};
declare type PullsCreateResponseDataLinksReviewComment = {
    href: string;
};
declare type PullsCreateResponseDataLinksReviewComments = {
    href: string;
};
declare type PullsCreateResponseDataLinksComments = {
    href: string;
};
declare type PullsCreateResponseDataLinksIssue = {
    href: string;
};
declare type PullsCreateResponseDataLinksHtml = {
    href: string;
};
declare type PullsCreateResponseDataLinksSelf = {
    href: string;
};
declare type PullsCreateResponseDataLinks = {
    self: PullsCreateResponseDataLinksSelf;
    html: PullsCreateResponseDataLinksHtml;
    issue: PullsCreateResponseDataLinksIssue;
    comments: PullsCreateResponseDataLinksComments;
    review_comments: PullsCreateResponseDataLinksReviewComments;
    review_comment: PullsCreateResponseDataLinksReviewComment;
    commits: PullsCreateResponseDataLinksCommits;
    statuses: PullsCreateResponseDataLinksStatuses;
};
declare type PullsCreateResponseDataBaseRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type PullsCreateResponseDataBaseRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateResponseDataBaseRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullsCreateResponseDataBaseRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullsCreateResponseDataBaseRepoPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type PullsCreateResponseDataBaseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateResponseDataBase = {
    label: string;
    ref: string;
    sha: string;
    user: PullsCreateResponseDataBaseUser;
    repo: PullsCreateResponseDataBaseRepo;
};
declare type PullsCreateResponseDataHeadRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type PullsCreateResponseDataHeadRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateResponseDataHeadRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullsCreateResponseDataHeadRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullsCreateResponseDataHeadRepoPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type PullsCreateResponseDataHeadUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateResponseDataHead = {
    label: string;
    ref: string;
    sha: string;
    user: PullsCreateResponseDataHeadUser;
    repo: PullsCreateResponseDataHeadRepo;
};
declare type PullsCreateResponseDataRequestedTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type PullsCreateResponseDataRequestedReviewersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateResponseDataAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateResponseDataAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateResponseDataMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateResponseDataMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: PullsCreateResponseDataMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type PullsCreateResponseDataLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type PullsCreateResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateResponseData = {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    locked: boolean;
    title: string;
    user: PullsCreateResponseDataUser;
    body: string;
    labels: Array<PullsCreateResponseDataLabelsItem>;
    milestone: PullsCreateResponseDataMilestone;
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    merge_commit_sha: string;
    assignee: PullsCreateResponseDataAssignee;
    assignees: Array<PullsCreateResponseDataAssigneesItem>;
    requested_reviewers: Array<PullsCreateResponseDataRequestedReviewersItem>;
    requested_teams: Array<PullsCreateResponseDataRequestedTeamsItem>;
    head: PullsCreateResponseDataHead;
    base: PullsCreateResponseDataBase;
    _links: PullsCreateResponseDataLinks;
    author_association: string;
    draft: boolean;
    merged: boolean;
    mergeable: boolean;
    rebaseable: boolean;
    mergeable_state: string;
    merged_by: PullsCreateResponseDataMergedBy;
    comments: number;
    review_comments: number;
    maintainer_can_modify: boolean;
    commits: number;
    additions: number;
    deletions: number;
    changed_files: number;
};
declare type PullsListCommentsForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Can be either `created` or `updated` comments.
     */
    sort?: "created" | "updated";
    /**
     * Can be either `asc` or `desc`. Ignored without `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListCommentsForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsListCommentsForRepoResponseDataItemLinksPullRequest = {
    href: string;
};
declare type PullsListCommentsForRepoResponseDataItemLinksHtml = {
    href: string;
};
declare type PullsListCommentsForRepoResponseDataItemLinksSelf = {
    href: string;
};
declare type PullsListCommentsForRepoResponseDataItemLinks = {
    self: PullsListCommentsForRepoResponseDataItemLinksSelf;
    html: PullsListCommentsForRepoResponseDataItemLinksHtml;
    pull_request: PullsListCommentsForRepoResponseDataItemLinksPullRequest;
};
declare type PullsListCommentsForRepoResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListCommentsForRepoResponseDataItem = {
    url: string;
    id: number;
    node_id: string;
    pull_request_review_id: number;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: PullsListCommentsForRepoResponseDataItemUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: PullsListCommentsForRepoResponseDataItemLinks;
    start_line: number;
    original_start_line: number;
    start_side: string;
    line: number;
    original_line: number;
    side: string;
};
declare type PullsListCommentsForRepoResponseData = Array<PullsListCommentsForRepoResponseDataItem>;
declare type PullsGetCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
};
declare type PullsGetCommentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsGetCommentResponseDataLinksPullRequest = {
    href: string;
};
declare type PullsGetCommentResponseDataLinksHtml = {
    href: string;
};
declare type PullsGetCommentResponseDataLinksSelf = {
    href: string;
};
declare type PullsGetCommentResponseDataLinks = {
    self: PullsGetCommentResponseDataLinksSelf;
    html: PullsGetCommentResponseDataLinksHtml;
    pull_request: PullsGetCommentResponseDataLinksPullRequest;
};
declare type PullsGetCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsGetCommentResponseData = {
    url: string;
    id: number;
    node_id: string;
    pull_request_review_id: number;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: PullsGetCommentResponseDataUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: PullsGetCommentResponseDataLinks;
    start_line: number;
    original_start_line: number;
    start_side: string;
    line: number;
    original_line: number;
    side: string;
};
declare type PullsUpdateCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * The text of the reply to the review comment.
     */
    body: string;
};
declare type PullsUpdateCommentRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/pulls/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsUpdateCommentResponseDataLinksPullRequest = {
    href: string;
};
declare type PullsUpdateCommentResponseDataLinksHtml = {
    href: string;
};
declare type PullsUpdateCommentResponseDataLinksSelf = {
    href: string;
};
declare type PullsUpdateCommentResponseDataLinks = {
    self: PullsUpdateCommentResponseDataLinksSelf;
    html: PullsUpdateCommentResponseDataLinksHtml;
    pull_request: PullsUpdateCommentResponseDataLinksPullRequest;
};
declare type PullsUpdateCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsUpdateCommentResponseData = {
    url: string;
    id: number;
    node_id: string;
    pull_request_review_id: number;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: PullsUpdateCommentResponseDataUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: PullsUpdateCommentResponseDataLinks;
    start_line: number;
    original_start_line: number;
    start_side: string;
    line: number;
    original_line: number;
    side: string;
};
declare type PullsDeleteCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
};
declare type PullsDeleteCommentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/pulls/comments/:comment_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsListForPullRequestReviewCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a pull request review comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsListForPullRequestReviewCommentRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/comments/:comment_id/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsListForPullRequestReviewCommentResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReactionsListForPullRequestReviewCommentResponseDataItem = {
    id: number;
    node_id: string;
    user: ReactionsListForPullRequestReviewCommentResponseDataItemUser;
    content: string;
    created_at: string;
};
declare type ReactionsListForPullRequestReviewCommentResponseData = Array<ReactionsListForPullRequestReviewCommentResponseDataItem>;
declare type ReactionsCreateForPullRequestReviewCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the pull request review comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsCreateForPullRequestReviewCommentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls/comments/:comment_id/reactions";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReactionsCreateForPullRequestReviewCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReactionsCreateForPullRequestReviewCommentResponseData = {
    id: number;
    node_id: string;
    user: ReactionsCreateForPullRequestReviewCommentResponseDataUser;
    content: string;
    created_at: string;
};
declare type ReactionsDeleteForPullRequestCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * reaction_id parameter
     */
    reaction_id: number;
} & RequiredPreview<"squirrel-girl">;
declare type ReactionsDeleteForPullRequestCommentRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/pulls/comments/:comment_id/reactions/:reaction_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsGetEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
};
declare type PullsGetRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsGetResponseDataMergedBy = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsGetResponseDataLinksStatuses = {
    href: string;
};
declare type PullsGetResponseDataLinksCommits = {
    href: string;
};
declare type PullsGetResponseDataLinksReviewComment = {
    href: string;
};
declare type PullsGetResponseDataLinksReviewComments = {
    href: string;
};
declare type PullsGetResponseDataLinksComments = {
    href: string;
};
declare type PullsGetResponseDataLinksIssue = {
    href: string;
};
declare type PullsGetResponseDataLinksHtml = {
    href: string;
};
declare type PullsGetResponseDataLinksSelf = {
    href: string;
};
declare type PullsGetResponseDataLinks = {
    self: PullsGetResponseDataLinksSelf;
    html: PullsGetResponseDataLinksHtml;
    issue: PullsGetResponseDataLinksIssue;
    comments: PullsGetResponseDataLinksComments;
    review_comments: PullsGetResponseDataLinksReviewComments;
    review_comment: PullsGetResponseDataLinksReviewComment;
    commits: PullsGetResponseDataLinksCommits;
    statuses: PullsGetResponseDataLinksStatuses;
};
declare type PullsGetResponseDataBaseRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type PullsGetResponseDataBaseRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsGetResponseDataBaseRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullsGetResponseDataBaseRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullsGetResponseDataBaseRepoPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type PullsGetResponseDataBaseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsGetResponseDataBase = {
    label: string;
    ref: string;
    sha: string;
    user: PullsGetResponseDataBaseUser;
    repo: PullsGetResponseDataBaseRepo;
};
declare type PullsGetResponseDataHeadRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type PullsGetResponseDataHeadRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsGetResponseDataHeadRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullsGetResponseDataHeadRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullsGetResponseDataHeadRepoPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type PullsGetResponseDataHeadUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsGetResponseDataHead = {
    label: string;
    ref: string;
    sha: string;
    user: PullsGetResponseDataHeadUser;
    repo: PullsGetResponseDataHeadRepo;
};
declare type PullsGetResponseDataRequestedTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type PullsGetResponseDataRequestedReviewersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsGetResponseDataAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsGetResponseDataAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsGetResponseDataMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsGetResponseDataMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: PullsGetResponseDataMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type PullsGetResponseDataLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type PullsGetResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsGetResponseData = {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    locked: boolean;
    title: string;
    user: PullsGetResponseDataUser;
    body: string;
    labels: Array<PullsGetResponseDataLabelsItem>;
    milestone: PullsGetResponseDataMilestone;
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    merge_commit_sha: string;
    assignee: PullsGetResponseDataAssignee;
    assignees: Array<PullsGetResponseDataAssigneesItem>;
    requested_reviewers: Array<PullsGetResponseDataRequestedReviewersItem>;
    requested_teams: Array<PullsGetResponseDataRequestedTeamsItem>;
    head: PullsGetResponseDataHead;
    base: PullsGetResponseDataBase;
    _links: PullsGetResponseDataLinks;
    author_association: string;
    draft: boolean;
    merged: boolean;
    mergeable: boolean;
    rebaseable: boolean;
    mergeable_state: string;
    merged_by: PullsGetResponseDataMergedBy;
    comments: number;
    review_comments: number;
    maintainer_can_modify: boolean;
    commits: number;
    additions: number;
    deletions: number;
    changed_files: number;
};
declare type PullsUpdateEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * The title of the pull request.
     */
    title?: string;
    /**
     * The contents of the pull request.
     */
    body?: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.
     */
    base?: string;
    /**
     * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
     */
    maintainer_can_modify?: boolean;
};
declare type PullsUpdateRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/pulls/:pull_number";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsUpdateResponseDataMergedBy = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsUpdateResponseDataLinksStatuses = {
    href: string;
};
declare type PullsUpdateResponseDataLinksCommits = {
    href: string;
};
declare type PullsUpdateResponseDataLinksReviewComment = {
    href: string;
};
declare type PullsUpdateResponseDataLinksReviewComments = {
    href: string;
};
declare type PullsUpdateResponseDataLinksComments = {
    href: string;
};
declare type PullsUpdateResponseDataLinksIssue = {
    href: string;
};
declare type PullsUpdateResponseDataLinksHtml = {
    href: string;
};
declare type PullsUpdateResponseDataLinksSelf = {
    href: string;
};
declare type PullsUpdateResponseDataLinks = {
    self: PullsUpdateResponseDataLinksSelf;
    html: PullsUpdateResponseDataLinksHtml;
    issue: PullsUpdateResponseDataLinksIssue;
    comments: PullsUpdateResponseDataLinksComments;
    review_comments: PullsUpdateResponseDataLinksReviewComments;
    review_comment: PullsUpdateResponseDataLinksReviewComment;
    commits: PullsUpdateResponseDataLinksCommits;
    statuses: PullsUpdateResponseDataLinksStatuses;
};
declare type PullsUpdateResponseDataBaseRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type PullsUpdateResponseDataBaseRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsUpdateResponseDataBaseRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullsUpdateResponseDataBaseRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullsUpdateResponseDataBaseRepoPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type PullsUpdateResponseDataBaseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsUpdateResponseDataBase = {
    label: string;
    ref: string;
    sha: string;
    user: PullsUpdateResponseDataBaseUser;
    repo: PullsUpdateResponseDataBaseRepo;
};
declare type PullsUpdateResponseDataHeadRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type PullsUpdateResponseDataHeadRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsUpdateResponseDataHeadRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullsUpdateResponseDataHeadRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullsUpdateResponseDataHeadRepoPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type PullsUpdateResponseDataHeadUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsUpdateResponseDataHead = {
    label: string;
    ref: string;
    sha: string;
    user: PullsUpdateResponseDataHeadUser;
    repo: PullsUpdateResponseDataHeadRepo;
};
declare type PullsUpdateResponseDataRequestedTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type PullsUpdateResponseDataRequestedReviewersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsUpdateResponseDataAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsUpdateResponseDataAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsUpdateResponseDataMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsUpdateResponseDataMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: PullsUpdateResponseDataMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type PullsUpdateResponseDataLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type PullsUpdateResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsUpdateResponseData = {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    locked: boolean;
    title: string;
    user: PullsUpdateResponseDataUser;
    body: string;
    labels: Array<PullsUpdateResponseDataLabelsItem>;
    milestone: PullsUpdateResponseDataMilestone;
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    merge_commit_sha: string;
    assignee: PullsUpdateResponseDataAssignee;
    assignees: Array<PullsUpdateResponseDataAssigneesItem>;
    requested_reviewers: Array<PullsUpdateResponseDataRequestedReviewersItem>;
    requested_teams: Array<PullsUpdateResponseDataRequestedTeamsItem>;
    head: PullsUpdateResponseDataHead;
    base: PullsUpdateResponseDataBase;
    _links: PullsUpdateResponseDataLinks;
    author_association: string;
    draft: boolean;
    merged: boolean;
    mergeable: boolean;
    rebaseable: boolean;
    mergeable_state: string;
    merged_by: PullsUpdateResponseDataMergedBy;
    comments: number;
    review_comments: number;
    maintainer_can_modify: boolean;
    commits: number;
    additions: number;
    deletions: number;
    changed_files: number;
};
declare type PullsListCommentsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * Can be either `created` or `updated` comments.
     */
    sort?: "created" | "updated";
    /**
     * Can be either `asc` or `desc`. Ignored without `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
     */
    since?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListCommentsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsListCommentsResponseDataItemLinksPullRequest = {
    href: string;
};
declare type PullsListCommentsResponseDataItemLinksHtml = {
    href: string;
};
declare type PullsListCommentsResponseDataItemLinksSelf = {
    href: string;
};
declare type PullsListCommentsResponseDataItemLinks = {
    self: PullsListCommentsResponseDataItemLinksSelf;
    html: PullsListCommentsResponseDataItemLinksHtml;
    pull_request: PullsListCommentsResponseDataItemLinksPullRequest;
};
declare type PullsListCommentsResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListCommentsResponseDataItem = {
    url: string;
    id: number;
    node_id: string;
    pull_request_review_id: number;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: PullsListCommentsResponseDataItemUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: PullsListCommentsResponseDataItemLinks;
    start_line: number;
    original_start_line: number;
    start_side: string;
    line: number;
    original_line: number;
    side: string;
};
declare type PullsListCommentsResponseData = Array<PullsListCommentsResponseDataItem>;
declare type PullsCreateCommentEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
};
declare type PullsCreateCommentRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls/:pull_number/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsCreateCommentResponseDataLinksPullRequest = {
    href: string;
};
declare type PullsCreateCommentResponseDataLinksHtml = {
    href: string;
};
declare type PullsCreateCommentResponseDataLinksSelf = {
    href: string;
};
declare type PullsCreateCommentResponseDataLinks = {
    self: PullsCreateCommentResponseDataLinksSelf;
    html: PullsCreateCommentResponseDataLinksHtml;
    pull_request: PullsCreateCommentResponseDataLinksPullRequest;
};
declare type PullsCreateCommentResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateCommentResponseData = {
    url: string;
    id: number;
    node_id: string;
    pull_request_review_id: number;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: PullsCreateCommentResponseDataUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: PullsCreateCommentResponseDataLinks;
    start_line: number;
    original_start_line: number;
    start_side: string;
    line: number;
    original_line: number;
    side: string;
};
declare type PullsCreateReviewCommentReplyEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * The text of the review comment.
     */
    body: string;
};
declare type PullsCreateReviewCommentReplyRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls/:pull_number/comments/:comment_id/replies";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsCreateReviewCommentReplyResponseDataLinksPullRequest = {
    href: string;
};
declare type PullsCreateReviewCommentReplyResponseDataLinksHtml = {
    href: string;
};
declare type PullsCreateReviewCommentReplyResponseDataLinksSelf = {
    href: string;
};
declare type PullsCreateReviewCommentReplyResponseDataLinks = {
    self: PullsCreateReviewCommentReplyResponseDataLinksSelf;
    html: PullsCreateReviewCommentReplyResponseDataLinksHtml;
    pull_request: PullsCreateReviewCommentReplyResponseDataLinksPullRequest;
};
declare type PullsCreateReviewCommentReplyResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateReviewCommentReplyResponseData = {
    url: string;
    pull_request_review_id: number;
    id: number;
    node_id: string;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    user: PullsCreateReviewCommentReplyResponseDataUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: PullsCreateReviewCommentReplyResponseDataLinks;
};
declare type PullsListCommitsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListCommitsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/commits";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsListCommitsResponseDataItemParentsItem = {
    url: string;
    sha: string;
};
declare type PullsListCommitsResponseDataItemCommitter = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListCommitsResponseDataItemAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListCommitsResponseDataItemCommitVerification = {
    verified: boolean;
    reason: string;
    signature: null;
    payload: null;
};
declare type PullsListCommitsResponseDataItemCommitTree = {
    url: string;
    sha: string;
};
declare type PullsListCommitsResponseDataItemCommitCommitter = {
    name: string;
    email: string;
    date: string;
};
declare type PullsListCommitsResponseDataItemCommitAuthor = {
    name: string;
    email: string;
    date: string;
};
declare type PullsListCommitsResponseDataItemCommit = {
    url: string;
    author: PullsListCommitsResponseDataItemCommitAuthor;
    committer: PullsListCommitsResponseDataItemCommitCommitter;
    message: string;
    tree: PullsListCommitsResponseDataItemCommitTree;
    comment_count: number;
    verification: PullsListCommitsResponseDataItemCommitVerification;
};
declare type PullsListCommitsResponseDataItem = {
    url: string;
    sha: string;
    node_id: string;
    html_url: string;
    comments_url: string;
    commit: PullsListCommitsResponseDataItemCommit;
    author: PullsListCommitsResponseDataItemAuthor;
    committer: PullsListCommitsResponseDataItemCommitter;
    parents: Array<PullsListCommitsResponseDataItemParentsItem>;
};
declare type PullsListCommitsResponseData = Array<PullsListCommitsResponseDataItem>;
declare type PullsListFilesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListFilesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/files";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsListFilesResponseDataItem = {
    sha: string;
    filename: string;
    status: string;
    additions: number;
    deletions: number;
    changes: number;
    blob_url: string;
    raw_url: string;
    contents_url: string;
    patch: string;
};
declare type PullsListFilesResponseData = Array<PullsListFilesResponseDataItem>;
declare type PullsCheckIfMergedEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
};
declare type PullsCheckIfMergedRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/merge";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsMergeEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * Title for the automatic commit message.
     */
    commit_title?: string;
    /**
     * Extra detail to append to automatic commit message.
     */
    commit_message?: string;
    /**
     * SHA that pull request head must match to allow merge.
     */
    sha?: string;
    /**
     * Merge method to use. Possible values are `merge`, `squash` or `rebase`. Default is `merge`.
     */
    merge_method?: "merge" | "squash" | "rebase";
};
declare type PullsMergeRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/pulls/:pull_number/merge";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsMergeResponseData = {
    sha: string;
    merged: boolean;
    message: string;
};
declare type PullsListReviewRequestsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListReviewRequestsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/requested_reviewers";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsListReviewRequestsResponseDataTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type PullsListReviewRequestsResponseDataUsersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListReviewRequestsResponseData = {
    users: Array<PullsListReviewRequestsResponseDataUsersItem>;
    teams: Array<PullsListReviewRequestsResponseDataTeamsItem>;
};
declare type PullsCreateReviewRequestEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * An array of user `login`s that will be requested.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be requested.
     */
    team_reviewers?: string[];
};
declare type PullsCreateReviewRequestRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls/:pull_number/requested_reviewers";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsCreateReviewRequestResponseDataLinksStatuses = {
    href: string;
};
declare type PullsCreateReviewRequestResponseDataLinksCommits = {
    href: string;
};
declare type PullsCreateReviewRequestResponseDataLinksReviewComment = {
    href: string;
};
declare type PullsCreateReviewRequestResponseDataLinksReviewComments = {
    href: string;
};
declare type PullsCreateReviewRequestResponseDataLinksComments = {
    href: string;
};
declare type PullsCreateReviewRequestResponseDataLinksIssue = {
    href: string;
};
declare type PullsCreateReviewRequestResponseDataLinksHtml = {
    href: string;
};
declare type PullsCreateReviewRequestResponseDataLinksSelf = {
    href: string;
};
declare type PullsCreateReviewRequestResponseDataLinks = {
    self: PullsCreateReviewRequestResponseDataLinksSelf;
    html: PullsCreateReviewRequestResponseDataLinksHtml;
    issue: PullsCreateReviewRequestResponseDataLinksIssue;
    comments: PullsCreateReviewRequestResponseDataLinksComments;
    review_comments: PullsCreateReviewRequestResponseDataLinksReviewComments;
    review_comment: PullsCreateReviewRequestResponseDataLinksReviewComment;
    commits: PullsCreateReviewRequestResponseDataLinksCommits;
    statuses: PullsCreateReviewRequestResponseDataLinksStatuses;
};
declare type PullsCreateReviewRequestResponseDataBaseRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type PullsCreateReviewRequestResponseDataBaseRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateReviewRequestResponseDataBaseRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullsCreateReviewRequestResponseDataBaseRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullsCreateReviewRequestResponseDataBaseRepoPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type PullsCreateReviewRequestResponseDataBaseUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateReviewRequestResponseDataBase = {
    label: string;
    ref: string;
    sha: string;
    user: PullsCreateReviewRequestResponseDataBaseUser;
    repo: PullsCreateReviewRequestResponseDataBaseRepo;
};
declare type PullsCreateReviewRequestResponseDataHeadRepoPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type PullsCreateReviewRequestResponseDataHeadRepoOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateReviewRequestResponseDataHeadRepo = {
    id: number;
    node_id: string;
    name: string;
    full_name: string;
    owner: PullsCreateReviewRequestResponseDataHeadRepoOwner;
    private: boolean;
    html_url: string;
    description: string;
    fork: boolean;
    url: string;
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    downloads_url: string;
    events_url: string;
    forks_url: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    notifications_url: string;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    clone_url: string;
    mirror_url: string;
    hooks_url: string;
    svn_url: string;
    homepage: string;
    language: null;
    forks_count: number;
    stargazers_count: number;
    watchers_count: number;
    size: number;
    default_branch: string;
    open_issues_count: number;
    is_template: boolean;
    topics: Array<string>;
    has_issues: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    has_pages: boolean;
    has_downloads: boolean;
    archived: boolean;
    disabled: boolean;
    visibility: string;
    pushed_at: string;
    created_at: string;
    updated_at: string;
    permissions: PullsCreateReviewRequestResponseDataHeadRepoPermissions;
    allow_rebase_merge: boolean;
    template_repository: null;
    temp_clone_token: string;
    allow_squash_merge: boolean;
    allow_merge_commit: boolean;
    subscribers_count: number;
    network_count: number;
};
declare type PullsCreateReviewRequestResponseDataHeadUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateReviewRequestResponseDataHead = {
    label: string;
    ref: string;
    sha: string;
    user: PullsCreateReviewRequestResponseDataHeadUser;
    repo: PullsCreateReviewRequestResponseDataHeadRepo;
};
declare type PullsCreateReviewRequestResponseDataRequestedTeamsItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type PullsCreateReviewRequestResponseDataRequestedReviewersItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateReviewRequestResponseDataAssigneesItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateReviewRequestResponseDataAssignee = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateReviewRequestResponseDataMilestoneCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateReviewRequestResponseDataMilestone = {
    url: string;
    html_url: string;
    labels_url: string;
    id: number;
    node_id: string;
    number: number;
    state: string;
    title: string;
    description: string;
    creator: PullsCreateReviewRequestResponseDataMilestoneCreator;
    open_issues: number;
    closed_issues: number;
    created_at: string;
    updated_at: string;
    closed_at: string;
    due_on: string;
};
declare type PullsCreateReviewRequestResponseDataLabelsItem = {
    id: number;
    node_id: string;
    url: string;
    name: string;
    description: string;
    color: string;
    default: boolean;
};
declare type PullsCreateReviewRequestResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateReviewRequestResponseData = {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    number: number;
    state: string;
    locked: boolean;
    title: string;
    user: PullsCreateReviewRequestResponseDataUser;
    body: string;
    labels: Array<PullsCreateReviewRequestResponseDataLabelsItem>;
    milestone: PullsCreateReviewRequestResponseDataMilestone;
    active_lock_reason: string;
    created_at: string;
    updated_at: string;
    closed_at: string;
    merged_at: string;
    merge_commit_sha: string;
    assignee: PullsCreateReviewRequestResponseDataAssignee;
    assignees: Array<PullsCreateReviewRequestResponseDataAssigneesItem>;
    requested_reviewers: Array<PullsCreateReviewRequestResponseDataRequestedReviewersItem>;
    requested_teams: Array<PullsCreateReviewRequestResponseDataRequestedTeamsItem>;
    head: PullsCreateReviewRequestResponseDataHead;
    base: PullsCreateReviewRequestResponseDataBase;
    _links: PullsCreateReviewRequestResponseDataLinks;
    author_association: string;
    draft: boolean;
};
declare type PullsDeleteReviewRequestEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * An array of user `login`s that will be removed.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be removed.
     */
    team_reviewers?: string[];
};
declare type PullsDeleteReviewRequestRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/pulls/:pull_number/requested_reviewers";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsListReviewsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsListReviewsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsListReviewsResponseDataItemLinksPullRequest = {
    href: string;
};
declare type PullsListReviewsResponseDataItemLinksHtml = {
    href: string;
};
declare type PullsListReviewsResponseDataItemLinks = {
    html: PullsListReviewsResponseDataItemLinksHtml;
    pull_request: PullsListReviewsResponseDataItemLinksPullRequest;
};
declare type PullsListReviewsResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsListReviewsResponseDataItem = {
    id: number;
    node_id: string;
    user: PullsListReviewsResponseDataItemUser;
    body: string;
    submitted_at: string;
    commit_id: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: PullsListReviewsResponseDataItemLinks;
};
declare type PullsListReviewsResponseData = Array<PullsListReviewsResponseDataItem>;
declare type PullsCreateReviewEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.
     */
    commit_id?: string;
    /**
     * **Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.
     */
    body?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://developer.github.com/v3/pulls/reviews/#submit-a-pull-request-review) when you are ready.
     */
    event?: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
    /**
     * Use the following table to specify the location, destination, and contents of the draft review comment.
     */
    comments?: PullsCreateReviewParamsComments[];
};
declare type PullsCreateReviewRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsCreateReviewResponseDataLinksPullRequest = {
    href: string;
};
declare type PullsCreateReviewResponseDataLinksHtml = {
    href: string;
};
declare type PullsCreateReviewResponseDataLinks = {
    html: PullsCreateReviewResponseDataLinksHtml;
    pull_request: PullsCreateReviewResponseDataLinksPullRequest;
};
declare type PullsCreateReviewResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsCreateReviewResponseData = {
    id: number;
    node_id: string;
    user: PullsCreateReviewResponseDataUser;
    body: string;
    commit_id: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: PullsCreateReviewResponseDataLinks;
};
declare type PullsGetReviewEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * review_id parameter
     */
    review_id: number;
};
declare type PullsGetReviewRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsGetReviewResponseDataLinksPullRequest = {
    href: string;
};
declare type PullsGetReviewResponseDataLinksHtml = {
    href: string;
};
declare type PullsGetReviewResponseDataLinks = {
    html: PullsGetReviewResponseDataLinksHtml;
    pull_request: PullsGetReviewResponseDataLinksPullRequest;
};
declare type PullsGetReviewResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsGetReviewResponseData = {
    id: number;
    node_id: string;
    user: PullsGetReviewResponseDataUser;
    body: string;
    submitted_at: string;
    commit_id: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: PullsGetReviewResponseDataLinks;
};
declare type PullsDeletePendingReviewEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * review_id parameter
     */
    review_id: number;
};
declare type PullsDeletePendingReviewRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsDeletePendingReviewResponseDataLinksPullRequest = {
    href: string;
};
declare type PullsDeletePendingReviewResponseDataLinksHtml = {
    href: string;
};
declare type PullsDeletePendingReviewResponseDataLinks = {
    html: PullsDeletePendingReviewResponseDataLinksHtml;
    pull_request: PullsDeletePendingReviewResponseDataLinksPullRequest;
};
declare type PullsDeletePendingReviewResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsDeletePendingReviewResponseData = {
    id: number;
    node_id: string;
    user: PullsDeletePendingReviewResponseDataUser;
    body: string;
    commit_id: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: PullsDeletePendingReviewResponseDataLinks;
};
declare type PullsUpdateReviewEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * review_id parameter
     */
    review_id: number;
    /**
     * The body text of the pull request review.
     */
    body: string;
};
declare type PullsUpdateReviewRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsUpdateReviewResponseDataLinksPullRequest = {
    href: string;
};
declare type PullsUpdateReviewResponseDataLinksHtml = {
    href: string;
};
declare type PullsUpdateReviewResponseDataLinks = {
    html: PullsUpdateReviewResponseDataLinksHtml;
    pull_request: PullsUpdateReviewResponseDataLinksPullRequest;
};
declare type PullsUpdateReviewResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsUpdateReviewResponseData = {
    id: number;
    node_id: string;
    user: PullsUpdateReviewResponseDataUser;
    body: string;
    commit_id: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: PullsUpdateReviewResponseDataLinks;
};
declare type PullsGetCommentsForReviewEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * review_id parameter
     */
    review_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type PullsGetCommentsForReviewRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/comments";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsGetCommentsForReviewResponseDataItemLinksPullRequest = {
    href: string;
};
declare type PullsGetCommentsForReviewResponseDataItemLinksHtml = {
    href: string;
};
declare type PullsGetCommentsForReviewResponseDataItemLinksSelf = {
    href: string;
};
declare type PullsGetCommentsForReviewResponseDataItemLinks = {
    self: PullsGetCommentsForReviewResponseDataItemLinksSelf;
    html: PullsGetCommentsForReviewResponseDataItemLinksHtml;
    pull_request: PullsGetCommentsForReviewResponseDataItemLinksPullRequest;
};
declare type PullsGetCommentsForReviewResponseDataItemUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsGetCommentsForReviewResponseDataItem = {
    url: string;
    id: number;
    node_id: string;
    pull_request_review_id: number;
    diff_hunk: string;
    path: string;
    position: number;
    original_position: number;
    commit_id: string;
    original_commit_id: string;
    in_reply_to_id: number;
    user: PullsGetCommentsForReviewResponseDataItemUser;
    body: string;
    created_at: string;
    updated_at: string;
    html_url: string;
    pull_request_url: string;
    author_association: string;
    _links: PullsGetCommentsForReviewResponseDataItemLinks;
};
declare type PullsGetCommentsForReviewResponseData = Array<PullsGetCommentsForReviewResponseDataItem>;
declare type PullsDismissReviewEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * review_id parameter
     */
    review_id: number;
    /**
     * The message for the pull request review dismissal
     */
    message: string;
};
declare type PullsDismissReviewRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/dismissals";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsDismissReviewResponseDataLinksPullRequest = {
    href: string;
};
declare type PullsDismissReviewResponseDataLinksHtml = {
    href: string;
};
declare type PullsDismissReviewResponseDataLinks = {
    html: PullsDismissReviewResponseDataLinksHtml;
    pull_request: PullsDismissReviewResponseDataLinksPullRequest;
};
declare type PullsDismissReviewResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsDismissReviewResponseData = {
    id: number;
    node_id: string;
    user: PullsDismissReviewResponseDataUser;
    body: string;
    commit_id: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: PullsDismissReviewResponseDataLinks;
};
declare type PullsSubmitReviewEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * review_id parameter
     */
    review_id: number;
    /**
     * The body text of the pull request review
     */
    body?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
     */
    event: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
};
declare type PullsSubmitReviewRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/pulls/:pull_number/reviews/:review_id/events";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsSubmitReviewResponseDataLinksPullRequest = {
    href: string;
};
declare type PullsSubmitReviewResponseDataLinksHtml = {
    href: string;
};
declare type PullsSubmitReviewResponseDataLinks = {
    html: PullsSubmitReviewResponseDataLinksHtml;
    pull_request: PullsSubmitReviewResponseDataLinksPullRequest;
};
declare type PullsSubmitReviewResponseDataUser = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type PullsSubmitReviewResponseData = {
    id: number;
    node_id: string;
    user: PullsSubmitReviewResponseDataUser;
    body: string;
    submitted_at: string;
    commit_id: string;
    state: string;
    html_url: string;
    pull_request_url: string;
    _links: PullsSubmitReviewResponseDataLinks;
};
declare type PullsUpdateBranchEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * pull_number parameter
     */
    pull_number: number;
    /**
     * The expected SHA of the pull request's HEAD ref. This is the most recent commit on the pull request's branch. If the expected SHA does not match the pull request's HEAD, you will receive a `422 Unprocessable Entity` status. You can use the "[List commits on a repository](https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository)" endpoint to find the most recent commit SHA. Default: SHA of the pull request's current HEAD ref.
     */
    expected_head_sha?: string;
} & RequiredPreview<"lydian">;
declare type PullsUpdateBranchRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/pulls/:pull_number/update-branch";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type PullsUpdateBranchResponseData = {
    message: string;
    url: string;
};
declare type ReposGetReadmeEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
     */
    ref?: string;
};
declare type ReposGetReadmeRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/readme";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetReadmeResponseDataLinks = {
    git: string;
    self: string;
    html: string;
};
declare type ReposGetReadmeResponseData = {
    type: string;
    encoding: string;
    size: number;
    name: string;
    path: string;
    content: string;
    sha: string;
    url: string;
    git_url: string;
    html_url: string;
    download_url: string;
    _links: ReposGetReadmeResponseDataLinks;
};
declare type ReposListReleasesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListReleasesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/releases";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListReleasesResponseDataItemAssetsItemUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListReleasesResponseDataItemAssetsItem = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposListReleasesResponseDataItemAssetsItemUploader;
};
declare type ReposListReleasesResponseDataItemAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListReleasesResponseDataItem = {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: ReposListReleasesResponseDataItemAuthor;
    assets: Array<ReposListReleasesResponseDataItemAssetsItem>;
};
declare type ReposListReleasesResponseData = Array<ReposListReleasesResponseDataItem>;
declare type ReposCreateReleaseEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * The name of the tag.
     */
    tag_name: string;
    /**
     * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
     */
    target_commitish?: string;
    /**
     * The name of the release.
     */
    name?: string;
    /**
     * Text describing the contents of the tag.
     */
    body?: string;
    /**
     * `true` to create a draft (unpublished) release, `false` to create a published one.
     */
    draft?: boolean;
    /**
     * `true` to identify the release as a prerelease. `false` to identify the release as a full release.
     */
    prerelease?: boolean;
};
declare type ReposCreateReleaseRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/releases";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposCreateReleaseResponseDataAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposCreateReleaseResponseData = {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: ReposCreateReleaseResponseDataAuthor;
    assets: Array<any>;
};
declare type ReposGetReleaseAssetEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * asset_id parameter
     */
    asset_id: number;
};
declare type ReposGetReleaseAssetRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/releases/assets/:asset_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetReleaseAssetResponseDataUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetReleaseAssetResponseData = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposGetReleaseAssetResponseDataUploader;
};
declare type ReposUpdateReleaseAssetEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * asset_id parameter
     */
    asset_id: number;
    /**
     * The file name of the asset.
     */
    name?: string;
    /**
     * An alternate short description of the asset. Used in place of the filename.
     */
    label?: string;
};
declare type ReposUpdateReleaseAssetRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/releases/assets/:asset_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposUpdateReleaseAssetResponseDataUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateReleaseAssetResponseData = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposUpdateReleaseAssetResponseDataUploader;
};
declare type ReposDeleteReleaseAssetEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * asset_id parameter
     */
    asset_id: number;
};
declare type ReposDeleteReleaseAssetRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/releases/assets/:asset_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetLatestReleaseEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposGetLatestReleaseRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/releases/latest";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetLatestReleaseResponseDataAssetsItemUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetLatestReleaseResponseDataAssetsItem = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposGetLatestReleaseResponseDataAssetsItemUploader;
};
declare type ReposGetLatestReleaseResponseDataAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetLatestReleaseResponseData = {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: ReposGetLatestReleaseResponseDataAuthor;
    assets: Array<ReposGetLatestReleaseResponseDataAssetsItem>;
};
declare type ReposGetReleaseByTagEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * tag parameter
     */
    tag: string;
};
declare type ReposGetReleaseByTagRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/releases/tags/:tag";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetReleaseByTagResponseDataAssetsItemUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetReleaseByTagResponseDataAssetsItem = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposGetReleaseByTagResponseDataAssetsItemUploader;
};
declare type ReposGetReleaseByTagResponseDataAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetReleaseByTagResponseData = {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: ReposGetReleaseByTagResponseDataAuthor;
    assets: Array<ReposGetReleaseByTagResponseDataAssetsItem>;
};
declare type ReposGetReleaseEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * release_id parameter
     */
    release_id: number;
};
declare type ReposGetReleaseRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/releases/:release_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetReleaseResponseDataAssetsItemUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetReleaseResponseDataAssetsItem = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposGetReleaseResponseDataAssetsItemUploader;
};
declare type ReposGetReleaseResponseDataAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetReleaseResponseData = {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: ReposGetReleaseResponseDataAuthor;
    assets: Array<ReposGetReleaseResponseDataAssetsItem>;
};
declare type ReposUpdateReleaseEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * release_id parameter
     */
    release_id: number;
    /**
     * The name of the tag.
     */
    tag_name?: string;
    /**
     * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
     */
    target_commitish?: string;
    /**
     * The name of the release.
     */
    name?: string;
    /**
     * Text describing the contents of the tag.
     */
    body?: string;
    /**
     * `true` makes the release a draft, and `false` publishes the release.
     */
    draft?: boolean;
    /**
     * `true` to identify the release as a prerelease, `false` to identify the release as a full release.
     */
    prerelease?: boolean;
};
declare type ReposUpdateReleaseRequestOptions = {
    method: "PATCH";
    url: "/repos/:owner/:repo/releases/:release_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposUpdateReleaseResponseDataAssetsItemUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateReleaseResponseDataAssetsItem = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposUpdateReleaseResponseDataAssetsItemUploader;
};
declare type ReposUpdateReleaseResponseDataAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUpdateReleaseResponseData = {
    url: string;
    html_url: string;
    assets_url: string;
    upload_url: string;
    tarball_url: string;
    zipball_url: string;
    id: number;
    node_id: string;
    tag_name: string;
    target_commitish: string;
    name: string;
    body: string;
    draft: boolean;
    prerelease: boolean;
    created_at: string;
    published_at: string;
    author: ReposUpdateReleaseResponseDataAuthor;
    assets: Array<ReposUpdateReleaseResponseDataAssetsItem>;
};
declare type ReposDeleteReleaseEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * release_id parameter
     */
    release_id: number;
};
declare type ReposDeleteReleaseRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/releases/:release_id";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListAssetsForReleaseEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * release_id parameter
     */
    release_id: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListAssetsForReleaseRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/releases/:release_id/assets";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListAssetsForReleaseResponseDataItemUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposListAssetsForReleaseResponseDataItem = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposListAssetsForReleaseResponseDataItemUploader;
};
declare type ReposListAssetsForReleaseResponseData = Array<ReposListAssetsForReleaseResponseDataItem>;
declare type ReposUploadReleaseAssetEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * release_id parameter
     */
    release_id: number;
    /**
     * name parameter
     */
    name?: string;
    /**
     * label parameter
     */
    label?: string;
    /**
     * The raw file data
     */
    data: string;
    /**
     * The URL origin (protocol + host name + port) is included in `upload_url` returned in the response of the "Create a release" endpoint
     */
    origin?: string;
    /**
     * For https://api.github.com, set `baseUrl` to `https://uploads.github.com`. For GitHub Enterprise Server, set it to `<your hostname>/api/uploads`
     */
    baseUrl: string;
} & {
    headers: {
        "content-type": string;
    };
};
declare type ReposUploadReleaseAssetRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/releases/:release_id/assets{?name,label}";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposUploadReleaseAssetResponseDataUploader = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposUploadReleaseAssetResponseData = {
    url: string;
    browser_download_url: string;
    id: number;
    node_id: string;
    name: string;
    label: string;
    state: string;
    content_type: string;
    size: number;
    download_count: number;
    created_at: string;
    updated_at: string;
    uploader: ReposUploadReleaseAssetResponseDataUploader;
};
declare type ActivityListStargazersForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListStargazersForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/stargazers";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListStargazersForRepoResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ActivityListStargazersForRepoResponseData = Array<ActivityListStargazersForRepoResponseDataItem>;
declare type ReposGetCodeFrequencyStatsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposGetCodeFrequencyStatsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/stats/code_frequency";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetCodeFrequencyStatsResponseData = Array<Array<number>>;
declare type ReposGetCommitActivityStatsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposGetCommitActivityStatsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/stats/commit_activity";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetCommitActivityStatsResponseDataItem = {
    days: Array<number>;
    total: number;
    week: number;
};
declare type ReposGetCommitActivityStatsResponseData = Array<ReposGetCommitActivityStatsResponseDataItem>;
declare type ReposGetContributorsStatsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposGetContributorsStatsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/stats/contributors";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetContributorsStatsResponseDataItemWeeksItem = {
    w: string;
    a: number;
    d: number;
    c: number;
};
declare type ReposGetContributorsStatsResponseDataItemAuthor = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposGetContributorsStatsResponseDataItem = {
    author: ReposGetContributorsStatsResponseDataItemAuthor;
    total: number;
    weeks: Array<ReposGetContributorsStatsResponseDataItemWeeksItem>;
};
declare type ReposGetContributorsStatsResponseData = Array<ReposGetContributorsStatsResponseDataItem>;
declare type ReposGetParticipationStatsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposGetParticipationStatsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/stats/participation";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetParticipationStatsResponseData = {
    all: Array<number>;
    owner: Array<number>;
};
declare type ReposGetPunchCardStatsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposGetPunchCardStatsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/stats/punch_card";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetPunchCardStatsResponseData = Array<Array<number>>;
declare type ReposCreateStatusEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * sha parameter
     */
    sha: string;
    /**
     * The state of the status. Can be one of `error`, `failure`, `pending`, or `success`.
     */
    state: "error" | "failure" | "pending" | "success";
    /**
     * The target URL to associate with this status. This URL will be linked from the GitHub UI to allow users to easily see the source of the status.
     * For example, if your continuous integration system is posting build status, you would want to provide the deep link for the build output for this specific SHA:
     * `http://ci.example.com/user/repo/build/sha`
     */
    target_url?: string;
    /**
     * A short description of the status.
     */
    description?: string;
    /**
     * A string label to differentiate this status from the status of other systems.
     */
    context?: string;
};
declare type ReposCreateStatusRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/statuses/:sha";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposCreateStatusResponseDataCreator = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposCreateStatusResponseData = {
    url: string;
    avatar_url: string;
    id: number;
    node_id: string;
    state: string;
    description: string;
    target_url: string;
    context: string;
    created_at: string;
    updated_at: string;
    creator: ReposCreateStatusResponseDataCreator;
};
declare type ActivityListWatchersForRepoEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ActivityListWatchersForRepoRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/subscribers";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityListWatchersForRepoResponseDataItem = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ActivityListWatchersForRepoResponseData = Array<ActivityListWatchersForRepoResponseDataItem>;
declare type ActivityGetRepoSubscriptionEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ActivityGetRepoSubscriptionRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/subscription";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivityGetRepoSubscriptionResponseData = {
    subscribed: boolean;
    ignored: boolean;
    reason: null;
    created_at: string;
    url: string;
    repository_url: string;
};
declare type ActivitySetRepoSubscriptionEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Determines if notifications should be received from this repository.
     */
    subscribed?: boolean;
    /**
     * Determines if all notifications should be blocked from this repository.
     */
    ignored?: boolean;
};
declare type ActivitySetRepoSubscriptionRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/subscription";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ActivitySetRepoSubscriptionResponseData = {
    subscribed: boolean;
    ignored: boolean;
    reason: null;
    created_at: string;
    url: string;
    repository_url: string;
};
declare type ActivityDeleteRepoSubscriptionEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ActivityDeleteRepoSubscriptionRequestOptions = {
    method: "DELETE";
    url: "/repos/:owner/:repo/subscription";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListTagsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListTagsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/tags";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListTagsResponseDataItemCommit = {
    sha: string;
    url: string;
};
declare type ReposListTagsResponseDataItem = {
    name: string;
    commit: ReposListTagsResponseDataItemCommit;
    zipball_url: string;
    tarball_url: string;
};
declare type ReposListTagsResponseData = Array<ReposListTagsResponseDataItem>;
declare type ReposListTeamsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
};
declare type ReposListTeamsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/teams";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposListTeamsResponseDataItem = {
    id: number;
    node_id: string;
    url: string;
    html_url: string;
    name: string;
    slug: string;
    description: string;
    privacy: string;
    permission: string;
    members_url: string;
    repositories_url: string;
    parent: null;
};
declare type ReposListTeamsResponseData = Array<ReposListTeamsResponseDataItem>;
declare type ReposGetAllTopicsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
} & RequiredPreview<"mercy">;
declare type ReposGetAllTopicsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/topics";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetAllTopicsResponseData = {
    names: Array<string>;
};
declare type ReposReplaceAllTopicsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * An array of topics to add to the repository. Pass one or more topics to _replace_ the set of existing topics. Send an empty array (`[]`) to clear all topics from the repository. **Note:** Topic `names` cannot contain uppercase letters.
     */
    names: string[];
} & RequiredPreview<"mercy">;
declare type ReposReplaceAllTopicsRequestOptions = {
    method: "PUT";
    url: "/repos/:owner/:repo/topics";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposReplaceAllTopicsResponseData = {
    names: Array<string>;
};
declare type ReposGetClonesEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Must be one of: `day`, `week`.
     */
    per?: "day" | "week";
};
declare type ReposGetClonesRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/traffic/clones";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetClonesResponseDataClonesItem = {
    timestamp: string;
    count: number;
    uniques: number;
};
declare type ReposGetClonesResponseData = {
    count: number;
    uniques: number;
    clones: Array<ReposGetClonesResponseDataClonesItem>;
};
declare type ReposGetTopPathsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposGetTopPathsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/traffic/popular/paths";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetTopPathsResponseDataItem = {
    path: string;
    title: string;
    count: number;
    uniques: number;
};
declare type ReposGetTopPathsResponseData = Array<ReposGetTopPathsResponseDataItem>;
declare type ReposGetTopReferrersEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
};
declare type ReposGetTopReferrersRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/traffic/popular/referrers";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetTopReferrersResponseDataItem = {
    referrer: string;
    count: number;
    uniques: number;
};
declare type ReposGetTopReferrersResponseData = Array<ReposGetTopReferrersResponseDataItem>;
declare type ReposGetViewsEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * Must be one of: `day`, `week`.
     */
    per?: "day" | "week";
};
declare type ReposGetViewsRequestOptions = {
    method: "GET";
    url: "/repos/:owner/:repo/traffic/views";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposGetViewsResponseDataViewsItem = {
    timestamp: string;
    count: number;
    uniques: number;
};
declare type ReposGetViewsResponseData = {
    count: number;
    uniques: number;
    views: Array<ReposGetViewsResponseDataViewsItem>;
};
declare type ReposTransferEndpoint = {
    /**
     * owner parameter
     */
    owner: string;
    /**
     * repo parameter
     */
    repo: string;
    /**
     * **Required:** The username or organization name the repository will be transferred to.
     */
    new_owner?: string;
    /**
     * ID of the team or teams to add to the repository. Teams can only be added to organization-owned repositories.
     */
    team_ids?: number[];
};
declare type ReposTransferRequestOptions = {
    method: "POST";
    url: "/repos/:owner/:repo/transfer";
    headers: RequestHeaders;
    request: RequestRequestOptions;
};
declare type ReposTransferResponseDataPermissions = {
    admin: boolean;
    push: boolean;
    pull: boolean;
};
declare type ReposTransferResponseDataOwner = {
    login: string;
    id: number;
    node_id: string;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
};
declare type ReposTransferResponseData = {
    id: number;
    node_id: strin