"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.array.find");

require("core-js/modules/es.array.map");

require("core-js/modules/es.array.some");

require("core-js/modules/es.function.name");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractComponentDescription = exports.extractProps = exports.getJSONDoc = exports.setJSONDoc = void 0;

/* eslint-disable no-underscore-dangle */

/* global window */
var setJSONDoc = function setJSONDoc(jsondoc) {
  window.__EMBER_GENERATED_DOC_JSON__ = jsondoc;
};

exports.setJSONDoc = setJSONDoc;

var getJSONDoc = function getJSONDoc() {
  return window.__EMBER_GENERATED_DOC_JSON__;
};

exports.getJSONDoc = getJSONDoc;

var extractProps = function extractProps(componentName) {
  var json = getJSONDoc();
  var componentDoc = json.included.find(function (doc) {
    return doc.attributes.name === componentName;
  });
  var rows = componentDoc.attributes.arguments.map(function (prop) {
    return {
      name: prop.name,
      type: prop.type,
      required: prop.tags.length ? prop.tags.some(function (tag) {
        return tag.name === 'required';
      }) : false,
      defaultValue: prop.defaultValue,
      description: prop.description
    };
  });
  return {
    rows: rows
  };
};

exports.extractProps = extractProps;

var extractComponentDescription = function extractComponentDescription(componentName) {
  var json = getJSONDoc();
  var componentDoc = json.included.find(function (doc) {
    return doc.attributes.name === componentName;
  });
  return componentDoc.attributes.description;
};

exports.extractComponentDescription = extractComponentDescription;