"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.find");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.array.map");

require("core-js/modules/es.function.name");

require("core-js/modules/es.object.create");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.entries");

require("core-js/modules/es.object.get-prototype-of");

require("core-js/modules/es.object.set-prototype-of");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.string.iterator");

require("core-js/modules/web.dom-collections.iterator");

var _clientApi = require("@storybook/client-api");

var _webComponents = require("@storybook/web-components");

var _react = _interopRequireDefault(require("react"));

var _litHtml = require("lit-html");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function mapData(data) {
  return data.map(function (item) {
    return {
      name: item.name,
      type: {
        summary: item.type
      },
      required: '',
      description: item.description,
      defaultValue: {
        summary: item["default"] !== undefined ? item["default"] : item.defaultValue
      }
    };
  });
}

function isEmpty(obj) {
  return Object.entries(obj).length === 0 && obj.constructor === Object;
}

(0, _clientApi.addParameters)({
  docs: {
    extractProps: function extractProps(tagName) {
      var customElements = (0, _webComponents.getCustomElements)();

      if ((0, _webComponents.isValidComponent)(tagName) && (0, _webComponents.isValidMetaData)(customElements)) {
        var metaData = customElements.tags.find(function (tag) {
          return tag.name.toUpperCase() === tagName.toUpperCase();
        });
        var sections = {};

        if (metaData.attributes) {
          sections.attributes = mapData(metaData.attributes);
        }

        if (metaData.properties) {
          sections.properties = mapData(metaData.properties);
        }

        if (metaData.events) {
          sections.events = mapData(metaData.events);
        }

        if (metaData.slots) {
          sections.slots = mapData(metaData.slots);
        }

        if (metaData.cssProperties) {
          sections.css = mapData(metaData.cssProperties);
        }

        return isEmpty(sections) ? false : {
          sections: sections
        };
      }

      return false;
    },
    extractComponentDescription: function extractComponentDescription(tagName) {
      var customElements = (0, _webComponents.getCustomElements)();

      if ((0, _webComponents.isValidComponent)(tagName) && (0, _webComponents.isValidMetaData)(customElements)) {
        var metaData = customElements.tags.find(function (tag) {
          return tag.name.toUpperCase() === tagName.toUpperCase();
        });

        if (metaData && metaData.description) {
          return metaData.description;
        }
      }

      return false;
    },
    inlineStories: true,
    prepareForInline: function prepareForInline(storyFn) {
      var Story =
      /*#__PURE__*/
      function (_React$Component) {
        _inherits(Story, _React$Component);

        function Story(props) {
          var _this;

          _classCallCheck(this, Story);

          _this = _possibleConstructorReturn(this, _getPrototypeOf(Story).call(this, props));
          _this.wrapperRef = _react["default"].createRef();
          return _this;
        }

        _createClass(Story, [{
          key: "componentDidMount",
          value: function componentDidMount() {
            (0, _litHtml.render)(storyFn(), this.wrapperRef.current);
          }
        }, {
          key: "render",
          value: function render() {
            return _react["default"].createElement('div', {
              ref: this.wrapperRef
            });
          }
        }]);

        return Story;
      }(_react["default"].Component);

      return _react["default"].createElement(Story);
    }
  }
});