import { ReactElement } from 'react';
import { Channel } from '@storybook/channels';
import { API } from '@storybook/api';
import { Types } from './types';
export interface RenderOptions {
    active: boolean;
    key: string;
}
export interface RouteOptions {
    storyId: string;
}
export interface MatchOptions {
    viewMode: string;
}
export interface Addon {
    title: string;
    type?: Types;
    id?: string;
    route?: (routeOptions: RouteOptions) => string;
    match?: (matchOptions: MatchOptions) => boolean;
    render: (renderOptions: RenderOptions) => ReactElement<any>;
    paramKey?: string;
}
export declare type Loader = (api: API) => void;
export interface Collection {
    [key: string]: Addon;
}
interface Config {
    [key: string]: any;
}
export declare class AddonStore {
    constructor();
    private loaders;
    private elements;
    private config;
    private channel;
    private promise;
    private resolve;
    getChannel: () => Channel;
    ready: () => Promise<Channel>;
    hasChannel: () => boolean;
    setChannel: (channel: Channel) => void;
    getElements: (type: string) => Collection;
    addPanel: (name: string, options: Addon) => void;
    add: (name: string, addon: Addon) => void;
    setConfig: (value: Config) => void;
    getConfig: () => Config;
    register: (name: string, registerCallback: (api: API) => void) => void;
    loadAddons: (api: any) => void;
}
export declare const addons: AddonStore;
export {};
