"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.index-of");

require("core-js/modules/es.array.is-array");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.array.map");

require("core-js/modules/es.date.to-string");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.keys");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.regexp.to-string");

require("core-js/modules/es.string.iterator");

require("core-js/modules/web.dom-collections.iterator");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Preview = void 0;

var _react = _interopRequireWildcard(require("react"));

var _theming = require("@storybook/theming");

var _polished = require("polished");

var _clientLogger = require("@storybook/client-logger");

var _BlockBackgroundStyles = require("./BlockBackgroundStyles");

var _Source = require("./Source");

var _ActionBar = require("../ActionBar/ActionBar");

var _Toolbar = require("./Toolbar");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var ChildrenContainer = _theming.styled.div(function (_ref) {
  var isColumn = _ref.isColumn,
      columns = _ref.columns;
  return {
    display: 'flex',
    position: 'relative',
    flexWrap: 'wrap',
    padding: '10px 20px 30px 20px',
    overflow: 'auto',
    flexDirection: isColumn ? 'column' : 'row',
    '> *': {
      flex: columns ? "1 1 calc(100%/".concat(columns, " - 20px)") : "1 1 0%",
      marginTop: 20,
      maxWidth: '100%'
    }
  };
});

var StyledSource = (0, _theming.styled)(_Source.Source)(function (_ref2) {
  var theme = _ref2.theme;
  return {
    margin: 0,
    borderTopLeftRadius: 0,
    borderTopRightRadius: 0,
    borderBottomLeftRadius: theme.appBorderRadius,
    borderBottomRightRadius: theme.appBorderRadius,
    border: 'none',
    background: theme.base === 'light' ? 'rgba(0, 0, 0, 0.85)' : (0, _polished.darken)(0.05, theme.background.content),
    color: theme.color.lightest,
    button: {
      background: theme.base === 'light' ? 'rgba(0, 0, 0, 0.85)' : (0, _polished.darken)(0.05, theme.background.content)
    }
  };
});

var PreviewContainer = _theming.styled.div(function (_ref3) {
  var theme = _ref3.theme,
      withSource = _ref3.withSource,
      isExpanded = _ref3.isExpanded;
  return Object.assign({
    position: 'relative',
    overflow: 'hidden',
    margin: '25px 0 40px'
  }, (0, _BlockBackgroundStyles.getBlockBackgroundStyle)(theme), {
    borderBottomLeftRadius: withSource && isExpanded && 0,
    borderBottomRightRadius: withSource && isExpanded && 0,
    borderBottomWidth: isExpanded && 0
  });
}, function (_ref4) {
  var withToolbar = _ref4.withToolbar;
  return withToolbar && {
    paddingTop: 40
  };
});

var getSource = function getSource(withSource, expanded, setExpanded) {
  switch (true) {
    case !!(withSource && withSource.error):
      {
        return {
          source: null,
          actionItem: {
            title: 'No code available',
            disabled: true,
            onClick: function onClick() {
              return setExpanded(false);
            }
          }
        };
      }

    case expanded:
      {
        return {
          source: _react["default"].createElement(StyledSource, _extends({}, withSource, {
            dark: true
          })),
          actionItem: {
            title: 'Hide code',
            onClick: function onClick() {
              return setExpanded(false);
            }
          }
        };
      }

    default:
      {
        return {
          source: null,
          actionItem: {
            title: 'Show code',
            onClick: function onClick() {
              return setExpanded(true);
            }
          }
        };
      }
  }
};

function getStoryId(children) {
  if (_react.Children.count(children) === 1) {
    var elt = children;

    if (elt.props) {
      return elt.props.id;
    }
  }

  return null;
}

var Relative = _theming.styled.div({
  position: 'relative'
});

var Scale = _theming.styled.div({
  position: 'relative'
}, function (_ref5) {
  var scale = _ref5.scale;
  return scale ? {
    transform: "scale(".concat(1 / scale, ")"),
    transformOrigin: 'top left'
  } : {};
});

var PositionedToolbar = (0, _theming.styled)(_Toolbar.Toolbar)({
  position: 'absolute',
  top: 0,
  left: 0,
  right: 0,
  height: 40
});
/**
 * A preview component for showing one or more component `Story`
 * items. The preview also shows the source for the component
 * as a drop-down.
 */

var Preview = function Preview(_ref6) {
  var isColumn = _ref6.isColumn,
      columns = _ref6.columns,
      children = _ref6.children,
      withSource = _ref6.withSource,
      _ref6$withToolbar = _ref6.withToolbar,
      withToolbar = _ref6$withToolbar === void 0 ? false : _ref6$withToolbar,
      _ref6$isExpanded = _ref6.isExpanded,
      isExpanded = _ref6$isExpanded === void 0 ? false : _ref6$isExpanded,
      className = _ref6.className,
      props = _objectWithoutProperties(_ref6, ["isColumn", "columns", "children", "withSource", "withToolbar", "isExpanded", "className"]);

  var _useState = (0, _react.useState)(isExpanded),
      _useState2 = _slicedToArray(_useState, 2),
      expanded = _useState2[0],
      setExpanded = _useState2[1];

  var _getSource = getSource(withSource, expanded, setExpanded),
      source = _getSource.source,
      actionItem = _getSource.actionItem;

  var _useState3 = (0, _react.useState)(1),
      _useState4 = _slicedToArray(_useState3, 2),
      scale = _useState4[0],
      setScale = _useState4[1];

  var previewClasses = className ? "".concat(className, " sbdocs sbdocs-preview") : 'sbdocs sbdocs-preview';

  if (withToolbar && Array.isArray(children)) {
    _clientLogger.logger.warn('Cannot use toolbar with multiple preview children, disabling');
  }

  var showToolbar = withToolbar && !Array.isArray(children);
  return _react["default"].createElement(PreviewContainer, _extends({
    withSource: withSource,
    withToolbar: showToolbar
  }, props, {
    className: previewClasses
  }), showToolbar && _react["default"].createElement(PositionedToolbar, {
    border: true,
    zoom: function zoom(z) {
      return setScale(scale * z);
    },
    resetZoom: function resetZoom() {
      return setScale(1);
    },
    storyId: getStoryId(children),
    baseUrl: "./iframe.html"
  }), _react["default"].createElement(Relative, null, _react["default"].createElement(ChildrenContainer, {
    isColumn: isColumn,
    columns: columns
  }, Array.isArray(children) ? children.map(function (child, i) {
    return _react["default"].createElement("div", {
      key: i.toString()
    }, child);
  }) : _react["default"].createElement(Scale, {
    scale: scale
  }, children)), withSource && _react["default"].createElement(_ActionBar.ActionBar, {
    actionItems: [actionItem]
  })), withSource && source);
};

exports.Preview = Preview;
Preview.displayName = "Preview";