/**
 * Copyright (c) 2019, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { ConfigInterface, WebWorkerConfigInterface } from "../models";
/**
 * Execute user sign out request
 *
 * @param {object} requestParams
 * @param {function} callback
 * @returns {Promise<any>} sign out request status
 */
export declare function sendSignOutRequest(requestParams: ConfigInterface | WebWorkerConfigInterface): Promise<any>;
/**
 * Handle sign out requests
 *
 * @param {object} requestParams
 * @param {function} callback
 * @returns {Promise<any>} sign out status
 */
export declare function handleSignOut(requestParams: ConfigInterface | WebWorkerConfigInterface): Promise<any>;
/**
 * Checks if the user has logged out and returns true if the logout is successful.
 *
 * @return {boolean} isLoggedOut - Specifies if a user has logged out or not.
 */
export declare const isLoggedOut: () => boolean;
//# sourceMappingURL=sign-out.d.ts.map