function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Encapsulates all logging behaviour and provides the ability to specify the level
 * of logging desired.
 * @class
 */
var Logger =
/*#__PURE__*/
function () {
  _createClass(Logger, [{
    key: "noop",

    /**
     * Icons prefixed to the start of logging statements that cycled through each
     * time a focus tree changes, making it easier to quickly spot events related
     * to the same focus tree.
     */

    /**
     * Icons prefixed to the start of logging statements that cycled through each
     * time a component ID changes, making it easier to quickly spot events related
     * to the same component.
     */

    /**
     * Icons prefixed to the start of logging statements that cycled through each
     * time an event ID changes, making it easier to quickly trace the path of KeyEvent
     * objects as they propagate through multiple components.
     */

    /**
     * The level of logging to perform
     * @typedef {'none'|'error'|'warn'|'info'|'debug'|'verbose'} LogLevel
     */

    /**
     * Levels of log severity - the higher the log level, the greater the amount (and
     * lesser the importance) of information logged to the console about React HotKey's
     * behaviour
     * @enum {number} LogLevel
     */
    value: function noop() {}
    /**
     * By default, calls to all log severities are a no-operation. It's only when the
     * user specifies a log level, are they replaced with logging statements
     * @type {Logger.noop}
     */

  }]);

  function Logger() {
    var _this = this;

    var logLevel = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'warn';

    _classCallCheck(this, Logger);

    _defineProperty(this, "verbose", this.noop);

    _defineProperty(this, "debug", this.noop);

    _defineProperty(this, "info", this.noop);

    _defineProperty(this, "warn", this.noop);

    _defineProperty(this, "error", this.noop);

    this.logLevel = this.constructor.levels[logLevel];

    if (this.logLevel >= this.constructor.levels.error) {
      this.error = console.error;
    } else {
      return;
    }

    if (this.logLevel >= this.constructor.levels.warn) {
      this.warn = console.warn;
    } else {
      return;
    }

    ['info', 'debug', 'verbose'].some(function (logLevel) {
      if (_this.logLevel >= _this.constructor.levels[logLevel]) {
        _this[logLevel] = console.log;
        return false;
      }

      return true;
    });
  }

  return Logger;
}();

_defineProperty(Logger, "logIcons", ['📕', '📗', '📘', '📙']);

_defineProperty(Logger, "componentIcons", ['🔺', '⭐️', '🔷', '🔶', '⬛️']);

_defineProperty(Logger, "eventIcons", ['❤️', '💚', '💙', '💛', '💜', '🧡']);

_defineProperty(Logger, "levels", {
  none: 0,
  error: 1,
  warn: 2,
  info: 3,
  debug: 4,
  verbose: 5
});

export default Logger;