(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('react'), require('prop-types')) :
    typeof define === 'function' && define.amd ? define(['react', 'prop-types'], factory) :
    (global.ReactTopLoadingBar = factory(global.React,global.PropTypes));
}(this, (function (React,PropTypes) { 'use strict';

    var React__default = 'default' in React ? React['default'] : React;
    PropTypes = PropTypes && PropTypes.hasOwnProperty('default') ? PropTypes['default'] : PropTypes;

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    /* global Reflect, Promise */

    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };

    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }

    function styleInject(css, ref) {
      if ( ref === void 0 ) ref = {};
      var insertAt = ref.insertAt;

      if (!css || typeof document === 'undefined') { return; }

      var head = document.head || document.getElementsByTagName('head')[0];
      var style = document.createElement('style');
      style.type = 'text/css';

      if (insertAt === 'top') {
        if (head.firstChild) {
          head.insertBefore(style, head.firstChild);
        } else {
          head.appendChild(style);
        }
      } else {
        head.appendChild(style);
      }

      if (style.styleSheet) {
        style.styleSheet.cssText = css;
      } else {
        style.appendChild(document.createTextNode(css));
      }
    }

    var css = ".styles_loading-bar__13vNf {\n  position: fixed;\n  top: 0;\n  left: 0;\n  height: inherit;\n  background-color: #f11946;\n  opacity: 1;\n  transition: all 0.5s ease;\n  -moz-transition: all 0.5s ease;\n  -webkit-transition: all 0.5s ease;\n  -o-transition: all 0.5s ease;\n  z-index: 999999;\n}\n\n.styles_loading-bar-full__3as_j {\n  position: fixed;\n  top: 0;\n  left: 0;\n  opacity: 0;\n  height: inherit;\n  transition: opacity 0.1s ease-out;\n  -moz-transition: opacity 0.1s ease-out;\n  -webkit-transition: opacity 0.1s ease-out;\n  -o-transition: opacity 0.1s ease-out;\n  z-index: 999999;\n}\n";
    var styles = { "loading-bar": "styles_loading-bar__13vNf", "loading-bar-full": "styles_loading-bar-full__3as_j" };
    styleInject(css);

    var LoadingBar = /** @class */function (_super) {
        __extends(LoadingBar, _super);
        function LoadingBar() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.state = {
                show: true,
                full: false,
                progress: 0,
                wait: false,
                interval: null
            };
            _this.add = function (value) {
                _this.setState({ progress: _this.state.progress + value }, function () {
                    _this.onProgressChange();
                });
            };
            _this.onProgressChange = function () {
                if (_this.props.onProgressChange) _this.props.onProgressChange(_this.state.progress);
                _this.checkIfFull();
            };
            _this.decrease = function (value) {
                _this.setState({ progress: _this.state.progress - value }, function () {
                    _this.onProgressChange();
                });
            };
            /** @deprecated this method contains a typo, use continuousStart */
            _this.continousStart = function (startingValue) {
                if (_this.state.interval) {
                    clearInterval(_this.state.interval);
                }
                var random = startingValue || _this.randomInt(20, 30);
                _this.setState({ progress: random });
                var interval = setInterval(function () {
                    if (_this.state.progress < 90) {
                        var random_1 = _this.randomInt(2, 10);
                        if (!_this.mounted) return false;
                        _this.setState({ progress: _this.state.progress + random_1 }, function () {
                            _this.onProgressChange();
                        });
                    } else {
                        clearInterval(interval);
                    }
                }, 1000);
                _this.setState({ interval: interval });
            };
            _this.continuousStart = function (startingValue) {
                if (_this.state.interval) {
                    clearInterval(_this.state.interval);
                }
                var random = startingValue || _this.randomInt(20, 30);
                _this.setState({ progress: random });
                var interval = setInterval(function () {
                    if (_this.state.progress < 90) {
                        var random_2 = _this.randomInt(2, 10);
                        if (!_this.mounted) return false;
                        _this.setState({ progress: _this.state.progress + random_2 }, function () {
                            _this.onProgressChange();
                        });
                    } else {
                        clearInterval(interval);
                    }
                }, 1000);
                _this.setState({ interval: interval });
            };
            _this.staticStart = function (startingValue) {
                if (_this.state.interval) {
                    clearInterval(_this.state.interval);
                }
                var random = startingValue || _this.randomInt(30, 50);
                _this.setState({ progress: random, interval: null }, function () {
                    _this.onProgressChange();
                });
            };
            _this.complete = function () {
                if (_this.state.interval) {
                    clearInterval(_this.state.interval);
                }
                _this.setState({ progress: 100, interval: null }, function () {
                    _this.onProgressChange();
                });
            };
            _this.onLoaderFinished = function () {
                if (_this.props.onLoaderFinished) _this.props.onLoaderFinished();
                _this.setState({ progress: 0 }, function () {
                    _this.onProgressChange();
                });
            };
            // Check whether the progress is full
            _this.checkIfFull = function () {
                if (!_this.mounted) return false;
                if (_this.state.progress >= 100) {
                    // Prevent new progress change
                    _this.setState({ wait: true });
                    // Start animate it
                    setTimeout(function () {
                        if (!_this.mounted) return false;
                        // animate when element removed
                        _this.setState({
                            full: true
                        });
                        setTimeout(function () {
                            if (!_this.mounted) return false;
                            _this.setState({
                                // remove bar element
                                show: false,
                                progress: 0,
                                wait: false
                            });
                            setTimeout(function () {
                                if (!_this.mounted) return false;
                                _this.setState({
                                    // Show Bar
                                    full: false,
                                    show: true
                                });
                                _this.onLoaderFinished();
                            });
                            // Duration to Waiting for hiding animation
                        }, 250);
                        // Duration is depend on css animation-duration of loading-bar
                    }, 700);
                }
            };
            return _this;
        }
        LoadingBar.prototype.randomInt = function (low, high) {
            return Math.floor(Math.random() * (high - low) + low);
        };
        LoadingBar.prototype.render = function () {
            var _a = this.props,
                className = _a.className,
                height = _a.height;
            var _b = this.state,
                show = _b.show,
                full = _b.full;
            return React__default.createElement(
                'div',
                { style: { height: height } },
                show ? React__default.createElement('div', { className: styles['loading-bar'] + ' ' + (className || '') + ' ' + (full ? styles['loading-bar-full'] : ''), style: this.barStyle() }) : null
            );
        };
        LoadingBar.prototype.UNSAFE_componentWillReceiveProps = function (nextProps) {
            var _this = this;
            // Watching Progress Changes
            if (nextProps.progress !== this.props.progress) {
                this.setState({ progress: nextProps.progress }, function () {
                    if (_this.props.onProgressChange != null) {
                        _this.props.onProgressChange();
                    }
                    _this.checkIfFull();
                });
            }
        };
        LoadingBar.prototype.componentDidMount = function () {
            this.mounted = true;
            if (this.props.onRef) this.props.onRef(this);
            if (this.state.progress !== this.props.progress) {
                this.setState({ progress: this.props.progress });
            }
        };
        LoadingBar.prototype.componentWillUnmount = function () {
            this.mounted = false;
            if (this.props.onRef) this.props.onRef(undefined);
        };
        // apply width style to our element as inline style
        LoadingBar.prototype.barStyle = function () {
            // When loading bar still in progress
            var _a = this.props,
                color = _a.color,
                background = _a.background;
            if (background || background !== '') {
                console.warn("react-top-loading-bar: Please don't use background property as a property since it's deprecated. Please use 'color' since it now haves the same function as background.");
            }
            if (!this.state.wait) {
                return {
                    width: this.state.progress + "%",
                    background: background || color
                };
            } else {
                return { width: '100%', background: background || color };
            }
        };
        LoadingBar.propTypes = {
            progress: PropTypes.number,
            color: PropTypes.string,
            background: PropTypes.string,
            height: PropTypes.number,
            onLoaderFinished: PropTypes.func,
            onProgressChange: PropTypes.func,
            className: PropTypes.string,
            onRef: PropTypes.func
        };
        LoadingBar.defaultProps = {
            progress: 0,
            color: '#f11946',
            height: 3,
            className: '',
            background: ''
        };
        return LoadingBar;
    }(React.Component);

    return LoadingBar;

})));
//# sourceMappingURL=index.umd.js.map
