"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var equal = require("fast-deep-equal");
var index_1 = require("./index");
function useTreeChanges(value) {
    var previousValue = react_1.useRef(value);
    var isEqual = equal(previousValue.current, value);
    var previousIsEqual = react_1.useRef(isEqual);
    var instance = react_1.useRef(index_1.default(previousValue.current, value));
    react_1.useEffect(function () {
        previousValue.current = value;
    });
    if (previousIsEqual.current !== isEqual || !isEqual) {
        previousIsEqual.current = isEqual;
        instance.current = index_1.default(previousValue.current, value);
    }
    return instance.current;
}
exports.default = useTreeChanges;
//# sourceMappingURL=hook.js.map