/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
/**
 * Class containing Applications Templates Page constants.
 */
export declare class ApplicationTemplatesPageConstants {
    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     *
     * @hideconstructor
     */
    private constructor();
    static readonly PAGE_URL_MATCHER: string;
    static readonly PAGE_LAYOUT_HEADER_DATA_ATTR: string;
    static readonly PAGE_LAYOUT_HEADER_TITLE_DATA_ATTR: string;
    static readonly PAGE_LAYOUT_HEADER_SUB_TITLE_DATA_ATTR: string;
    static readonly PAGE_LAYOUT_HEADER_BACK_BUTTON_DATA_ATTR: string;
    static readonly SEARCH_INPUT_DATA_ATTR: string;
    static readonly SORT_DROPDOWN_DATA_ATTR: string;
    static readonly QUICK_START_TEMPLATE_GRID: string;
    static readonly VENDOR_TEMPLATE_GRID: string;
    static readonly WEB_APP_TEMPLATE_CARD_DATA_ATTR: string;
    static readonly SPA_TEMPLATE_CARD_DATA_ATTR: string;
    static readonly DESKTOP_APP_TEMPLATE_CARD_DATA_ATTR: string;
    static readonly MOBILE_APP_TEMPLATE_CARD_DATA_ATTR: string;
    static readonly BOX_APP_TEMPLATE_CARD_DATA_ATTR: string;
    static readonly SLACK_APP_TEMPLATE_CARD_DATA_ATTR: string;
    static readonly WORKDAY_APP_TEMPLATE_CARD_DATA_ATTR: string;
    static readonly ZOOM_APP_TEMPLATE_CARD_DATA_ATTR: string;
    static readonly MINIMAL_CREATION_WIZARD_DATA_ATTR: string;
    static readonly MINIMAL_CREATION_WIZARD_APP_NAME_INPUT_DATA_ATTR: string;
    static readonly MINIMAL_CREATION_WIZARD_OIDC_CARD_DATA_ATTR: string;
    static readonly MINIMAL_CREATION_WIZARD_SAML_CARD_DATA_ATTR: string;
    static readonly MINIMAL_CREATION_WIZARD_REDIRECT_URL_INPUT_DATA_ATTR: string;
    static readonly MINIMAL_CREATION_WIZARD_REDIRECT_URL_ADD_BUTTON_DATA_ATTR: string;
    static readonly MINIMAL_CREATION_WIZARD_SUBMIT_BUTTON_DATA_ATTR: string;
}
