/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Features key.
 * @constant
 * @type {string}
 * @default
 */
export const FEATURES = "features";

/**
 * Overview key.
 * @constant
 * @type {string}
 * @default
 */
export const OVERVIEW = "overview";

/**
 * Personal info key.
 * @constant
 * @type {string}
 * @default
 */
export const PERSONAL_INFO = "personalInfo";

/**
 * Profile key.
 * @constant
 * @type {string}
 * @default
 */
export const PROFILE = "profile";

/**
 * Linked Accounts key.
 * @constant
 * @type {string}
 * @default
 */
export const LINKED_ACCOUNTS = "linkedAccounts";

/**
 * Export Profile key.
 * @constant
 * @type {string}
 * @default
 */
export const EXPORT_PROFILE = "exportProfile";

/**
 * Applications key.
 * @constant
 * @type {string}
 * @default
 */
export const APPLICATIONS = "applications";

/**
 * Security key.
 * @constant
 * @type {string}
 * @default
 */
export const SECURITY = "security";

/**
 * Change password key.
 * @constant
 * @type {string}
 * @default
 */
export const CHANGE_PASSWORD = "changePassword";

/**
 * Account Recovery key.
 * @constant
 * @type {string}
 * @default
 */
export const ACCOUNT_RECOVERY = "accountRecovery";

/**
 * Security Questions key.
 * @constant
 * @type {string}
 * @default
 */
export const SECURITY_QUESTIONS = "securityQuestions";

/**
 * Email Recovery.
 * @constant
 * @type {string}
 * @default
 */
export const EMAIL_RECOVERY = "emailRecovery";

/**
 * MFA key.
 * @constant
 * @type {string}
 * @default
 */
export const MULTI_FACTOR_AUTHENTICATION = "multiFactorAuthentication";

/**
 * SMS OTP key.
 * @constant
 * @type {string}
 * @default
 */
export const SMS = "sms";

/**
 * FIDO key.
 * @constant
 * @type {string}
 * @default
 */
export const FIDO = "fido";

/**
 * Authenticator app.
 * @constant
 * @type {string}
 * @default
 */
export const AUTHENTICATOR_APP = "authenticatorApp";

/**
 * Active Sessions key.
 * @constant
 * @type {string}
 * @default
 */
export const ACTIVE_SESSIONS = "activeSessions";

/**
 * Manage Consents key.
 * @constant
 * @type {string}
 * @default
 */
export const MANAGE_CONSENTS = "manageConsents";

/**
 * Account Status.
 * @constant
 * @type {string}
 * @default
 */
export const ACCOUNT_STATUS = "accountStatus";

/**
 * Account Activity.
 * @constant
 * @type {string}
 * @default
 */
export const ACCOUNT_ACTIVITY = "accountActivity";

/**
 * Account Security.
 * @constant
 * @type {string}
 * @default
 */
export const ACCOUNT_SECURITY = "accountSecurity";

/**
 * Consents Control key.
 * @constant
 * @type {string}
 * @default
 */
export const CONSENTS_CONTROL = "consentsControl";

/**
 * External Logins key.
 * @constant
 * @type {string}
 * @default
 */
export const EXTERNAL_LOGINS = "externalLogins";
