/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { Hint, MessageWithIcon } from "@wso2is/react-components";
import React from "react";
import { Field as FinalFormField } from "react-final-form";
import { SelectAdapter } from "./adapters";
import { getValidation } from "../utils";
/**
 * Implementation of the Dropdown Field component.
 * @param props
 */
export const FieldDropdown = (props) => {
    const { ["data-testid"]: testId, initialValue } = props, rest = __rest(props, ["data-testid", "initialValue"]);
    const resolveInputFieldMessage = () => {
        switch (props.message.type) {
            case "info":
                return (React.createElement(MessageWithIcon, { type: props.message.type, content: props.message.content, header: props.message.header }));
            case "warning":
                return (React.createElement(MessageWithIcon, { type: props.message.type, content: props.message.content, header: props.message.header }));
            case "error":
                return (React.createElement(MessageWithIcon, { type: props.message.type, content: props.message.content, header: props.message.header }));
        }
    };
    return (React.createElement(React.Fragment, null,
        React.createElement(FinalFormField, Object.assign({ key: testId, type: "dropdown", name: props.name, parse: value => value, component: SelectAdapter, validate: (value, allValues, meta) => getValidation(value, meta, props.type, props.required) }, rest)),
        (props.hint && typeof props.hint === "string")
            ? (React.createElement(Hint, { compact: true }, props.hint)) : (React.createElement(React.Fragment, null, props.hint)),
        props.message && (resolveInputFieldMessage())));
};
//# sourceMappingURL=field-dropdown.js.map