/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { useState, useEffect } from "react";
import { Form } from ".";
import { WizardPage } from "./wizardPage";
/**
 * Implementation of wizard component.
 * @param props Wizard form based on react froms
 * @returns
 */
export const Wizard = (props) => {
    const { children, onSubmit, triggerPrevious, changePage, setTotalPage } = props, rest = __rest(props, ["children", "onSubmit", "triggerPrevious", "changePage", "setTotalPage"]);
    const [page, setPage] = useState(0);
    const [values, setValues] = useState({});
    /**
     * Loads the identity provider authenticators on initial component load.
     */
    useEffect(() => {
        if (setTotalPage) {
            setTotalPage(React.Children.count(children));
        }
    }, []);
    const handlNext = (values) => {
        setPage(Math.min(page + 1, children.length - 1));
        setValues(values);
        changePage(Math.min(page + 1, children.length - 1));
    };
    const handlPrevious = () => {
        setPage(Math.max(page - 1, 0));
        changePage(Math.max(page - 1, 0));
    };
    const passPageNumber = () => {
        return page;
    };
    const handleSubmit = (values, form) => {
        const isLastPage = page === React.Children.count(children) - 1;
        if (isLastPage) {
            return onSubmit(values, form);
        }
        else {
            handlNext(values);
        }
    };
    if (triggerPrevious && typeof triggerPrevious === "function") {
        triggerPrevious(handlPrevious);
    }
    const validate = values => {
        const activePage = React.Children.toArray(children)[page];
        return activePage.props.validate ? activePage.props.validate(values) : {};
    };
    const activePage = React.Children.toArray(children)[page];
    const isLastPage = page === React.Children.count(children) - 1;
    return (React.createElement(Form, Object.assign({ initialValues: values, validate: validate, onSubmit: handleSubmit, keepDirtyOnReinitialize: true, uncontrolledForm: true }, rest), activePage));
};
Wizard.Page = WizardPage;
//# sourceMappingURL=wizard.js.map