/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { ReactElement } from "react";
import { CheckboxAdapterPropsInterface } from "../models";
export declare const TextFieldAdapter: (props: any) => ReactElement;
export declare const PasswordFieldAdapter: (props: any) => ReactElement;
export declare const CopyFieldAdapter: (props: any) => ReactElement;
export declare const TextAreaAdapter: (props: any) => ReactElement;
/**
 * Toggle adapter.
 * @deprecated Use `CheckboxAdapter` instead.
 *
 * @param props - Props injected to the component. props - Props injected to the component.
 *
 * @return {React.ReactElement}
 */
export declare const ToggleAdapter: (props: any) => ReactElement;
/**
 * Semantic Checkbox adapter.
 * @see {@link https://codesandbox.io/s/react-final-form-simple-example-3we74?fontsize=14&file=/index.js}
 *
 * @param {CheckboxAdapterPropsInterface} props - Props injected to the component.
 *
 * @return {React.ReactElement}
 */
export declare const CheckboxAdapter: (props: CheckboxAdapterPropsInterface) => ReactElement;
export declare const SelectAdapter: (props: any) => ReactElement;
export declare const ButtonAdapter: ({ childFieldProps }: {
    childFieldProps: any;
}) => ReactElement;
export declare const QueryParamsAdapter: ({ input, childFieldProps }: {
    input: any;
    childFieldProps: any;
}) => ReactElement;
