"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports.Ref = void 0;

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var React = _interopRequireWildcard(require("react"));

var ReactIs = _interopRequireWildcard(require("react-is"));

var _RefFindNode = require("./RefFindNode");

var _RefForward = require("./RefForward");

var Ref = function Ref(props) {
  var children = props.children,
      innerRef = props.innerRef,
      rest = (0, _objectWithoutPropertiesLoose2.default)(props, ["children", "innerRef"]);
  var child = React.Children.only(children);
  var ElementType = ReactIs.isForwardRef(child) ? _RefForward.RefForward : _RefFindNode.RefFindNode;
  var childWithProps = child && rest && Object.keys(rest).length > 0 ? /*#__PURE__*/React.cloneElement(child, rest) : child;
  return /*#__PURE__*/React.createElement(ElementType, {
    innerRef: innerRef
  }, childWithProps);
};

exports.Ref = Ref;
//# sourceMappingURL=Ref.js.map
