"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var React = require("react");
var ReactIs = require("react-is");
var RefFindNode_1 = require("./RefFindNode");
var RefForward_1 = require("./RefForward");
exports.Ref = function (props) {
    var children = props.children, innerRef = props.innerRef, rest = tslib_1.__rest(props, ["children", "innerRef"]);
    var child = React.Children.only(children);
    var ElementType = ReactIs.isForwardRef(child) ? RefForward_1.RefForward : RefFindNode_1.RefFindNode;
    var childWithProps = child && rest && Object.keys(rest).length > 0 ? React.cloneElement(child, rest) : child;
    return React.createElement(ElementType, { innerRef: innerRef }, childWithProps);
};
