import * as React from 'react';
export interface RefProps {
    children: React.ReactElement;
    /**
     * Called when a child component will be mounted or updated.
     *
     * @param node - Referred node.
     */
    innerRef: React.Ref<HTMLElement>;
}
/**
 * The function that correctly handles passing refs.
 *
 * @param ref - An ref object or function
 * @param node - A node that should be passed by ref
 */
export declare const handleRef: <N>(ref: ((instance: N | null) => void) | React.RefObject<N> | null | undefined, node: N) => void;
/** Checks that the passed object is a valid React ref object. */
export declare const isRefObject: (ref: any) => ref is React.RefObject<any>;
