import _inheritsLoose from "@babel/runtime/helpers/esm/inheritsLoose";
import * as React from 'react';
import { handleRef } from './utils';
export var RefForward = /*#__PURE__*/function (_React$Component) {
  _inheritsLoose(RefForward, _React$Component);

  function RefForward() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
    _this.currentNode = null;

    _this.handleRefOverride = function (node) {
      var _this$props = _this.props,
          children = _this$props.children,
          innerRef = _this$props.innerRef;
      handleRef(children.ref, node);
      handleRef(innerRef, node);
      _this.currentNode = node;
    };

    return _this;
  }

  var _proto = RefForward.prototype;

  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
    if (prevProps.innerRef !== this.props.innerRef) {
      handleRef(this.props.innerRef, this.currentNode);
    }
  };

  _proto.componentWillUnmount = function componentWillUnmount() {
    delete this.currentNode;
  };

  _proto.render = function render() {
    var children = this.props.children;
    return /*#__PURE__*/React.cloneElement(children, {
      ref: this.handleRefOverride
    });
  };

  return RefForward;
}(React.Component);
//# sourceMappingURL=RefForward.js.map
