"use strict";
/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.I18nModuleConstants = void 0;
/**
 * Class containing i18n module constants.
 */
class I18nModuleConstants {
    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     *
     * @hideconstructor
     */
    // eslint-disable-next-line @typescript-eslint/no-empty-function
    constructor() { }
}
exports.I18nModuleConstants = I18nModuleConstants;
/**
 * Name of the i18n module.
 * @constant
 * @type {string}
 * @default
 */
I18nModuleConstants.MODULE_NAME = "@wso2is/i18n";
/**
 * Common namespace.
 * @constant
 * @type {string}
 * @default
 */
I18nModuleConstants.COMMON_NAMESPACE = "common";
/**
 * User portal namespace.
 * @constant
 * @type {string}
 * @default
 */
I18nModuleConstants.MY_ACCOUNT_NAMESPACE = "myAccount";
/**
 * Console portal namespace.
 * @constant
 * @type {string}
 * @default
 */
I18nModuleConstants.CONSOLE_PORTAL_NAMESPACE = "console";
/**
 * Extensions namespace.
 * @constant
 * @type {string}
 * @default
 */
I18nModuleConstants.EXTENSIONS_NAMESPACE = "extensions";
/**
 * Default fallback language.
 * @constant
 * @type {string}
 * @default
 */
I18nModuleConstants.DEFAULT_FALLBACK_LANGUAGE = "en-US";
/**
 * Metadata file name.
 * @constant
 * @type {string}
 * @default
 */
I18nModuleConstants.META_FILENAME = "meta.json";
//# sourceMappingURL=constants.js.map