/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { CommonNS } from "../../../models";

export const common: CommonNS = {
    access: "Access",
    actions: "Actions",
    activate: "Activate",
    active: "Active",
    add: "Add",
    addURL: "Add value",
    all: "All",
    applicationName: "Application name",
    applications: "Applications",
    approvalStatus: "Approval Status",
    approve: "Approve",
    assignees: "Assignees",
    authentication: "Authentication",
    authenticator: "Authenticator",
    // eslint-disable-next-line @typescript-eslint/camelcase
    authenticator_plural: "Authenticators",
    back: "Back",
    browser: "Browser",
    cancel: "Cancel",
    challengeQuestionNumber: "Challenge Question {{number}}",
    change: "Change",
    chunkLoadErrorMessage: {
        description: "An error occurred when serving the requested application. Please try reloading the app.",
        heading: "Something went wrong",
        primaryActionText: "Reload the App"
    },
    claim: "Claim",
    clear: "Clear",
    close: "Close",
    comingSoon: "Coming soon",
    completed: "Completed",
    configure: "Configure",
    confirm: "Confirm",
    contains: "Contains",
    continue: "Continue",
    copyToClipboard: "Copy to clipboard",
    create: "Create",
    createdOn: "Created on",
    dangerZone: "Danger Zone",
    darkMode: "Dark mode",
    delete: "Delete",
    description: "Description",
    deviceModel: "Device model",
    disable: "Disable",
    disabled: "Disabled",
    docs: "Docs",
    documentation: "Documentation",
    done: "Done",
    download: "Download",
    drag: "Drag",
    duplicateURLError: "This value is already added",
    edit: "Edit",
    enable: "Enable",
    enabled: "Enabled",
    endsWith: "Ends with",
    equals: "Equals",
    exitFullScreen: "Exit full-screen",
    explore: "Explore",
    export: "Export",
    featureAvailable: "This feature will be available soon!",
    filter: "Filter",
    finish: "Finish",
    generatePassword: "Generate password",
    goBackHome: "Go back home",
    goFullScreen: "Go full-screen",
    good: "Good",
    help: "Help",
    hide: "Hide",
    hidePassword: "Hide password",
    identityProviders: "Identity Providers",
    import: "Import",
    initiator: "Initiator",
    ipAddress: "IP address",
    lastAccessed: "Last accessed",
    lastModified: "Last modified",
    lastSeen: "Last seen",
    lastUpdatedOn: "Last updated on",
    lightMode: "Light mode",
    loading: "Loading",
    loginTime: "Login time",
    logout: "Logout",
    maximize: "Maximize",
    minimize: "Minimize",
    more: "More",
    myAccount: "My Account",
    name: "Name",
    networkErrorMessage: {
        description: "Please try reloading the app.",
        heading: "Something went wrong",
        primaryActionText: "Reload the App"
    },
    next: "Next",
    okay: "Okay",
    operatingSystem: "Operating System",
    operations: "Operations",
    overview: "Overview",
    personalInfo: "Personal Info",
    pin: "Pin",
    pinned: "Pinned",
    previous: "Previous",
    priority: "Priority",
    privacy: "Privacy",
    properties: "Properties",
    ready: "Ready",
    regenerate: "Regenerate",
    register: "Register",
    reject: "Reject",
    release: "Release",
    remove: "Remove",
    removeAll: "Remove all",
    required: "This is required.",
    reserved: "Reserved",
    resetFilters: "Reset filters",
    retry: "Retry",
    revoke: "Revoke",
    revokeAll: "Revoke all",
    samples: "Samples",
    save: "Save",
    sdks: "SDKs",
    search: "Search",
    security: "Security",
    services: "Services",
    setup: "Setup",
    show: "Show",
    showAll: "Show all",
    showLess: "Show less",
    showMore: "Show more",
    showPassword: "Show password",
    skip: "Skip",
    startsWith: "Starts with",
    step: "Step",
    strong: "Strong",
    submit: "Submit",
    switch: "Switch",
    technologies: "Technologies",
    terminate: "Terminate",
    terminateAll: "Terminate all",
    terminateSession: "Terminate session",
    tooShort: "Too short",
    type: "Type",
    unpin: "Unpin",
    unpinned: "Unpinned",
    update: "Update",
    user: "User",
    verify: "Verify",
    view: "View",
    weak: "Weak",
    weakPassword: "The password strength should at least be good."
};
