/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { CommonNS } from "../../../models";

export const common: CommonNS = {
    access: "Accès",
    actions: "Actions",
    activate: "Activer",
    active: "Actif",
    add: "Ajouter",
    addURL: "Ajouter la valeur",
    all: "Tous",
    applicationName: "Nom de l'application",
    applications: "Applications",
    approvalStatus: "Statut d'approbation",
    approve: "Approuver",
    assignees: "Contrôleurs",
    authenticator: "Authentificateur",
    authentication: "Authentification",
    // eslint-disable-next-line @typescript-eslint/camelcase
    authenticator_plural: "Authentificateurs",
    back: "Dos",
    browser: "Navigateur",
    cancel: "Annuler",
    challengeQuestionNumber: "Question de sécurité {{number}}",
    change: "Modifier",
    chunkLoadErrorMessage: {
        description: "Une erreur s'est produite lors de la diffusion de l'application demandée. Veuillez essayer " +
            "de recharger l'application.",
        heading: "Quelque chose s'est mal passé",
        primaryActionText: "Recharger l'application"
    },
    claim: "Claim",
    clear: "Effacer",
    close: "Fermer",
    comingSoon: "Bientôt disponible",
    completed: "Terminé",
    configure: "Configurer",
    confirm: "Confirmer",
    contains: "Contient",
    continue: "Continuer",
    copyToClipboard: "Copier dans le presse-papier",
    createdOn: "Créé le",
    create: "Créer",
    dangerZone: "Zone de danger",
    darkMode: "Mode sombre",
    delete: "Supprimer",
    description: "Description",
    deviceModel: "Modèle d'appareil",
    disable: "désactiver",
    disabled: "désactivé",
    docs: "Docs",
    documentation: "Documentation",
    done: "Fait",
    download: "Télécharger",
    drag: "Glisser",
    duplicateURLError: "Cette valeur a déjà été ajoutée",
    edit: "Éditer",
    enable: "Activer",
    enabled: "Activée",
    endsWith: "Se termine par",
    equals: "Est égal à",
    exitFullScreen: "Quitter le mode plein écran",
    explore: "Explorer",
    export: "Exporter",
    featureAvailable: "Cette fonctionnalité sera bientôt disponible!",
    filter: "Filtrer",
    finish: "Terminer",
    generatePassword: "Générer un mot de passe",
    goBackHome: "Revenir à l'accueil",
    goFullScreen: "Ouvrir en plein écran",
    good: "Bien",
    help: "Aide",
    hide: "Cacher",
    hidePassword: "Cacher le mot de passe",
    identityProviders: "Fournisseurs d'identité",
    import: "Importer",
    initiator: "Initiateur",
    ipAddress: "Addresse IP",
    lastAccessed: "Dernier accès",
    lastModified: "Dernière modification",
    lastSeen: "Dernier vu",
    lastUpdatedOn: "Dernière mise à jour le",
    lightMode: "Mode lumière",
    loading: "Chargement",
    loginTime: "Heure de connexion",
    logout: "Déconnexion",
    maximize: "Maximiser",
    minimize: "Minimiser",
    more: "Plus",
    myAccount: "Mon compte",
    name: "Nom",
    networkErrorMessage:{
        description: "Veuillez essayer de recharger l'application.",
        heading: "Quelque chose s'est mal passé",
        primaryActionText: "Recharger l'application"
    },
    next: "Suivant",
    okay: "d'accord",
    operatingSystem: "Système d'exploitation",
    operations: "Opérations",
    overview: "Vue d'ensemble",
    personalInfo: "Informations personnelles",
    pin: "Épingler",
    pinned: "Épinglé",
    previous: "Précédent",
    priority: "Priorité",
    privacy: "Vie privée",
    properties: "Propriétés",
    ready: "Prêt",
    regenerate: "Régénérer",
    register: "Inscrire",
    reject: "Rejeter",
    release: "Version",
    remove: "Retirer",
    removeAll: "Tout retirer",
    required: "Ceci est nécessaire",
    reserved: "Réservé",
    resetFilters: "Réinitialiser les filtres",
    retry: "Réessayer",
    revoke: "Révoquer",
    revokeAll: "Tout révoquer",
    samples: "Exemples",
    save: "Sauvegarder",
    sdks: "SDKs",
    search: "Rechercher",
    security: "Sécurité",
    services: "Services",
    setup: "Installer",
    show: "Afficher",
    showAll: "Tout afficher",
    showLess: "Afficher moins",
    showMore: "Afficher plus",
    showPassword: "Afficher le mot de passe",
    skip: "sauter",
    startsWith: "Commence par",
    step: "Étape",
    strong: "Fort",
    submit: "Valider",
    switch: "Changer",
    technologies: "Technologies",
    terminate: "Terminer",
    terminateAll: "Tout terminer",
    terminateSession: "Terminer la session",
    tooShort: "Trop court",
    type: "Type",
    unpin: "Détacher",
    unpinned: "Détaché",
    update: "Mettre à jour",
    user: "Utilisateur",
    verify: "Vérifier",
    view: "Voir",
    weak: "Faible",
    weakPassword: "La force du mot de passe doit au moins être bonne."
};
