/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import classNames from "classnames";
import React from "react";
import { Divider, Header, Icon, Message } from "semantic-ui-react";
/**
 * Message with icon component.
 *
 * @param {MessageWithIconProps} props - Props injected in to the message with icon component.
 *
 * @return {React.ReactElement}
 */
export const MessageWithIcon = (props) => {
    const { className, type, header, content, visible, ["data-testid"]: testId } = props;
    const classes = classNames("info-message-with-icon", className);
    const generateContent = () => {
        return (React.createElement(React.Fragment, null,
            React.createElement(Divider, { hidden: true, className: "message-info-text" }),
            React.createElement("div", null, (content))));
    };
    const resolveMessage = () => {
        switch (type) {
            case "info":
                return (React.createElement(Message, { className: classes, info: true, visible: visible, header: header
                        ? (React.createElement(Header, { as: "h4" },
                            React.createElement(Header.Content, null,
                                React.createElement(Icon, { name: "info circle" }),
                                (header)))) : undefined, content: header
                        ? generateContent()
                        : (React.createElement("div", null,
                            React.createElement(Icon, { name: "info circle" }),
                            content)) }));
            case "error":
                return (React.createElement(Message, { error: true, visible: visible, header: header
                        ? (React.createElement(Header, { as: "h4" },
                            React.createElement(Header.Content, null,
                                React.createElement(Icon, { name: "times circle" }),
                                (header)))) : undefined, content: header
                        ? generateContent()
                        : (React.createElement("div", null,
                            React.createElement(Icon, { name: "times circle" }),
                            content)) }));
            case "success":
                return (React.createElement(Message, { success: true, visible: visible, header: header
                        ? (React.createElement(Header, { as: "h4" },
                            React.createElement(Header.Content, null,
                                React.createElement(Icon, { name: "check circle" }),
                                (header)))) : undefined, content: header
                        ? generateContent()
                        : (React.createElement("div", null,
                            React.createElement(Icon, { name: "check circle" }),
                            content)) }));
            case "warning":
                return (React.createElement(Message, { warning: true, visible: visible, header: header
                        ? (React.createElement(Header, { as: "h4" },
                            React.createElement(Header.Content, null,
                                React.createElement(Icon, { name: "warning circle" }),
                                (header)))) : undefined, content: header
                        ? generateContent()
                        : (React.createElement("div", null,
                            React.createElement(Icon, { name: "warning circle" }),
                            content)) }));
            default:
                return (React.createElement(Message, { visible: visible, content: generateContent(), header: header }));
        }
    };
    return (React.createElement(React.Fragment, null, resolveMessage()));
};
/**
 * Default proptypes for the message with icon component.
 */
MessageWithIcon.defaultProps = {
    "data-testid": "message-info",
    visible: true
};
//# sourceMappingURL=message-with-icon.js.map