/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { TestableComponentInterface } from "@wso2is/core/models";
import { FunctionComponent, MouseEvent, ReactNode } from "react";
import { ButtonProps } from "semantic-ui-react";
import { InfoCardPropsInterface } from "../../card";
/**
 * Interface for the Resource Grid Card component.
 */
export interface ResourceGridCardPropsInterface extends InfoCardPropsInterface, TestableComponentInterface {
    /**
     * Is resource disabled.
     */
    disabled?: boolean;
    /**
     * Edit button label.
     */
    editButtonLabel?: ReactNode;
    /**
     * On resource delete callback.
     * @param {React.MouseEvent<HTMLDivElement>} e - Click event.
     */
    onDelete?: (e: MouseEvent<HTMLDivElement>) => void;
    /**
     * On resource edit callback.
     * @param {React.MouseEvent<HTMLButtonElement>} e - Click event.
     * @param {ButtonProps} data - Button data.
     */
    onEdit?: (e: MouseEvent<HTMLButtonElement>, data: ButtonProps) => void;
    /**
     * Name of the resource.
     */
    resourceCategory?: InfoCardPropsInterface["subHeader"];
    /**
     * Description of the resource.
     */
    resourceDescription?: InfoCardPropsInterface["description"];
    /**
     * Description of the resource.
     */
    resourceImage?: InfoCardPropsInterface["image"];
    /**
     * Name of the resource.
     */
    resourceName?: InfoCardPropsInterface["header"];
    /**
     * Should show actions panel.
     */
    showActions?: boolean;
    /**
     * Should show resource delete option.
     */
    showResourceDelete?: boolean;
    /**
     * Should show resource edit option.
     */
    showResourceEdit?: boolean;
    /**
     * Is resource a coming soon feature?.
     */
    isResourceComingSoon?: boolean;
    /**
     * Coming soon ribbon label.
     */
    comingSoonRibbonLabel?: ReactNode;
}
/**
 * Resource Grid Card component.
 *
 * @param {ResourceGridCardPropsInterface} props - Props injected to the component.
 * @return {React.ReactElement}
 */
export declare const ResourceGridCard: FunctionComponent<ResourceGridCardPropsInterface>;
