import { LoadableComponentInterface, TestableComponentInterface } from "@wso2is/core/models";
import { FunctionComponent, PropsWithChildren, ReactElement } from "react";
import { InputProps } from "semantic-ui-react";
/**
 *
 * Proptypes for the advanced search component.
 */
export interface SearchWithFilterLabelsPropsInterface extends InputProps, TestableComponentInterface, LoadableComponentInterface {
    /**
     * Set of filter labels.
     */
    filterLabels: string[];
    /**
     * Filter labels' on click callback.
     * @param {string} query - Search query.
     * @param {string[]} selectedFilters - Set of selected filters.
     */
    onFilter?: (query: string, selectedFilters: string[]) => void;
    /**
     * Search query onchange callback.
     * @param {string} query - Search query.
     * @param {string[]} selectedFilters - Set of already selected filters.
     */
    onSearch?: (query: string, selectedFilters: string[]) => void;
    /**
     * Externally provided search input.
     */
    searchInput?: ReactElement;
}
/**
 * Search box with filter labels.
 *
 * @param {React.PropsWithChildren<SearchWithFilterLabelsPropsInterface>} props - Props injected to the component.
 *
 * @return {React.ReactElement}
 */
export declare const SearchWithFilterLabels: FunctionComponent<PropsWithChildren<SearchWithFilterLabelsPropsInterface>>;
