/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
/// <reference types="cypress" />
/**
 * Abstract Class containing common listing page objects.
 */
var ListPage = /** @class */ (function () {
    function ListPage() {
    }
    /**
     * Get the table first element.
     * @return {Cypress.Chainable<Element>}
     */
    ListPage.prototype.getTableFirstElement = function () {
        return this.getTable()
            .within(function () {
            cy.dataTestId("data-table-row")
                .eq(0);
        });
    };
    /**
     * Click on the table first element's edit button.
     */
    ListPage.prototype.clickOnTableFirstElementEditButton = function () {
        var _this = this;
        this.getTableFirstElement()
            .within(function () {
            _this.getTableItemEditButton().trigger("mouseover").click();
        });
    };
    /**
     * Click on the table first element's view button.
     */
    ListPage.prototype.clickOnTableFirstElementViewButton = function () {
        var _this = this;
        this.getTableFirstElement()
            .within(function () {
            _this.getTableItemViewButton().trigger("mouseover").click();
        });
    };
    /**
     * Click on the new button.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    ListPage.prototype.clickOnNewButton = function (options) {
        this.getPageLayoutHeaderAction().click(options);
    };
    return ListPage;
}());
export { ListPage };
//# sourceMappingURL=list-page.js.map