'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.conflictResolvers = undefined;
exports.default = mergeDirs;

var _nodeFs = require('node-fs');

var _nodeFs2 = _interopRequireDefault(_nodeFs);

var _inquirer = require('inquirer');

var _inquirer2 = _interopRequireDefault(_inquirer);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var conflictResolvers = exports.conflictResolvers = {
  ask: 'ask',
  skip: 'skip',
  overwrite: 'overwrite'
}; /*
   
     (The MIT License)
   
     Copyright (C) 2005-2013 Kai Davenport
   
     Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the 'Software'), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
   
     The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
   
     THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
   
    */

function copyFile(file, location) {
  _nodeFs2.default.mkdirSync(file.split('/').slice(0, -1).join('/'), 0x1ed, true);
  _nodeFs2.default.writeFileSync(file, _nodeFs2.default.readFileSync(location));
}

function renameQuestionFactory(dest) {
  var defaultNewName = 'conflict-' + dest.split(_path2.default.sep).pop();
  return {
    type: 'input',
    name: 'fileName',
    message: 'What do you want to name the second file?',
    default: defaultNewName
  };
}

function conflictQuestionFactory(f1, f2) {
  return {
    type: 'list',
    name: 'resolution',
    message: 'conflict: ' + f1 + ' - ' + f2,
    choices: ['skip', new _inquirer2.default.Separator(), 'overwrite', new _inquirer2.default.Separator(), 'keep both']
  };
}

function saveRenamedFile(src, dest) {
  return function (answer) {
    var newName = answer.fileName;
    var newDest = dest.split(_path2.default.sep).slice(0, -1).join(_path2.default.sep) + _path2.default.sep + newName;
    copyFile(newDest, src);
  };
}

function resolveConflict(src, dest) {
  return function (answer) {
    switch (answer.resolution) {
      case 'overwrite':
        copyFile(src, dest);
        break;
      case 'keep both':
        _inquirer2.default.prompt([renameQuestionFactory(dest)], saveRenamedFile(src, dest));
        break;
      default:

    }
  };
}

function fileAsk(src, dest) {
  var question = conflictQuestionFactory(src, dest);
  _inquirer2.default.prompt([question], resolveConflict(src, dest));
}

function mergeDirs(src, dest) {
  var conflictResolver = arguments.length <= 2 || arguments[2] === undefined ? conflictResolvers.skip : arguments[2];

  // handle false, for backward compatability
  if (conflictResolver === false) {
    conflictResolver = conflictResolvers.skip;
  } else if (conflictResolver === true) {
    conflictResolver = conflictResolvers.overwrite;
  }
  var files = _nodeFs2.default.readdirSync(src);

  files.forEach(function (file) {
    var srcFile = '' + src + '/' + file;
    var destFile = '' + dest + '/' + file;
    var stats = _nodeFs2.default.lstatSync(srcFile);

    if (stats.isDirectory()) {
      mergeDirs(srcFile, destFile, conflictResolver);
    } else {
      // console.log({srcFile, destFile}, 'conflict?', fs.existsSync(destFile))
      if (!_nodeFs2.default.existsSync(destFile)) {
        copyFile(destFile, srcFile);
      } else {
        switch (conflictResolver) {
          case conflictResolvers.ask:
            fileAsk(srcFile, destFile);
            break;
          case conflictResolvers.overwrite:
            copyFile(destFile, srcFile);
            break;
          case conflictResolvers.skip:
            console.log(destFile + ' exists, skipping...');
        }
      }
    }
  });
}