"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports["default"] = generateValidator;

var _plain = _interopRequireDefault(require("./structure/plain"));

var toArray = function toArray(value) {
  return Array.isArray(value) ? value : [value];
};

var getError = function getError(value, values, props, validators, name) {
  var array = toArray(validators);

  for (var i = 0; i < array.length; i++) {
    var error = array[i](value, values, props, name);

    if (error) {
      return error;
    }
  }
};

function generateValidator(validators, _ref) {
  var getIn = _ref.getIn;
  return function (values, props) {
    var errors = {};
    Object.keys(validators).forEach(function (name) {
      var value = getIn(values, name);
      var error = getError(value, values, props, validators[name], name);

      if (error) {
        errors = _plain["default"].setIn(errors, name, error);
      }
    });
    return errors;
  };
}