"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var resolveAliases_1 = __importDefault(require("../utils/resolveAliases"));
var resolvePathFrom_1 = __importDefault(require("../utils/resolvePathFrom"));
function makePathResolver(refDirName, aliases, modules) {
    return function (filePath, originalDirNameOverride) {
        return resolvePathFrom_1.default(resolveAliases_1.default(filePath, aliases || {}), __spreadArray([
            originalDirNameOverride || refDirName
        ], (modules || [])));
    };
}
exports.default = makePathResolver;
