/**
 * Copyright (c) 2022, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { ReactElement } from "react";
import { FieldRenderProps } from "react-final-form";
import { CheckboxAdapterPropsInterface, ColorPickerAdapterPropsInterface, RadioAdapterPropsInterface } from "../models";
export declare const TextFieldAdapter: (props: FieldRenderProps<any>) => ReactElement;
export declare const ScopeFieldAdapter: (props: FieldRenderProps<any>) => ReactElement;
export declare const PasswordFieldAdapter: (props: FieldRenderProps<any>) => ReactElement;
export declare const CopyFieldAdapter: (props: FieldRenderProps<any>) => ReactElement;
export declare const TextAreaAdapter: (props: FieldRenderProps<any>) => ReactElement;
/**
 * Toggle adapter.
 * @deprecated Use `CheckboxAdapter` instead.
 *
 * @param props - Props injected to the component. props - Props injected to the component.
 *
 * @returns
 */
export declare const ToggleAdapter: (props: FieldRenderProps<any>) => ReactElement;
/**
 * Semantic Checkbox adapter.
 * @see {@link https://codesandbox.io/s/react-final-form-simple-example-3we74?fontsize=14&file=/index.js}
 *
 * @param props - Props injected to the component.
 *
 * @returns
 */
export declare const CheckboxAdapter: (props: CheckboxAdapterPropsInterface) => ReactElement;
/**
 * Semantic UI Radio Adapter.
 *
 * @param props - Props injected to the component.
 *
 * @returns
 */
export declare const RadioAdapter: (props: RadioAdapterPropsInterface) => ReactElement;
export declare const SelectAdapter: (props: FieldRenderProps<any>) => ReactElement;
export declare const ButtonAdapter: ({ childFieldProps }: FieldRenderProps<any>) => ReactElement;
export declare const QueryParamsAdapter: ({ input, childFieldProps }: FieldRenderProps<any>) => ReactElement;
/**
 * Color Picker Adapter implemented with `react-color`.
 *
 * @param props - Props injected to the component.
 *
 * @returns
 */
export declare const ColorPickerAdapter: (props: ColorPickerAdapterPropsInterface) => ReactElement;
