/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IdentifiableComponentInterface, TestableComponentInterface } from "@wso2is/core/models";
import { FunctionComponent, PropsWithChildren, ReactNode } from "react";
import { SegmentProps } from "semantic-ui-react";
/**
 * Proptypes for the Cookie Consent Banner.
 */
export interface CookieConsentBannerPropsInterface extends SegmentProps, IdentifiableComponentInterface, TestableComponentInterface {
    /**
     * Confirm button text.
     */
    confirmButtonText: string;
    /**
     * Cookie domain.
     */
    domain?: string;
    /**
     * Store the cookie as a domain cookie.
     */
    domainCookie?: boolean;
    /**
     * ID for the component.
     */
    id?: string;
    /**
     * Inverted mode.
     */
    inverted?: boolean;
    /**
     * Callback to be triggered on confirm button click.
     */
    onConfirmButtonClick?: () => void;
    /**
     * Position of the banner.
     */
    position?: "left" | "right";
    /**
     * Consent persistence strategy.
     */
    storageStrategy?: "cookie";
    /**
     * Custom style object.
     */
    style?: Record<string, any>;
    /**
     * Banner title.
     */
    title: ReactNode;
}
/**
 * Cookie consent cookie name.
 */
export declare const COOKIE_CONSENT_COOKIE_NAME: string;
/**
 * Banner to get consent for Cookie usage.
 *
 * @param props - Props injected to the components.
 *
 * @returns CookieConsentBanner React Component
 */
export declare const CookieConsentBanner: FunctionComponent<PropsWithChildren<CookieConsentBannerPropsInterface>>;
