/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IdentifiableComponentInterface } from "@wso2is/core/models";
import { CSSProperties, FunctionComponent, IframeHTMLAttributes, PropsWithChildren } from "react";
/**
 * Iframe component Prop types.
 */
export interface IframeProps extends IframeHTMLAttributes<HTMLIFrameElement>, IdentifiableComponentInterface {
    /**
     * Should the parent's stylesheets be copied to the iframe.
     */
    cloneParentStyleSheets?: boolean;
    /**
     * Additional CSS Classes
     */
    className?: string;
    /**
     * Should the iframe behave responsively?
     */
    responsive?: boolean;
    /**
     * Styles to be injected in to a style tag.
     */
    styles?: string;
    /**
     * Whether to add the style node to the begining of the `head` element or to the end of the `head` element.
     */
    styleNodeInjectionStrategy?: "append" | "prepend";
    /**
     * Should the style node be injected after the parent stylesheets have been cloned.
     */
    injectStyleNodeAfterParentStyles?: boolean;
    /**
     * External style sheets to be injected in to the iframe.
     */
    stylesheets?: string[];
    /**
     * Is the iframe ready.
     */
    isReady?: (status: boolean) => void;
    /**
     * Is the iframe loading.
     */
    isLoading?: boolean;
    /**
     * The zoom percentage. By default will be 100%.
     */
    zoom?: number;
    /**
     * These styles will be applied to the warpper of the iframe when the responsive is true.
     */
    wrapperStyle?: CSSProperties;
}
/**
 * React Wrapper for HTML iframe element.
 *
 * @param props - Props injected to the danger zone component.
 *
 * @returns the React Wrapper component for HTML iframe element.
 */
export declare const Iframe: FunctionComponent<PropsWithChildren<IframeProps>>;
