import { FormInputLabel, Popup, Password, CopyInputField, PrimaryButton, LinkButton, DangerButton, Button as Button$1, ColorPicker, Hint, Message as Message$1 } from '@wso2is/react-components';
import omit from 'lodash-es/omit';
import React, { useState, useEffect, Fragment, cloneElement, forwardRef, useRef, useImperativeHandle } from 'react';
import { Form as Form$1, Button, Message, Label, Icon, Input, Checkbox, Select, Grid } from 'semantic-ui-react';
import filter from 'lodash-es/filter';
import isEmpty from 'lodash-es/isEmpty';
import isEqual from 'lodash-es/isEqual';
import classNames from 'classnames';
import { Field as Field$1, Form as Form$2 } from 'react-final-form';
import { FormValidation } from '@wso2is/validation';

/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Type guard to check if an input element is a text field
 * @param toBeDetermined
 */
const isTextField = toBeDetermined => {
  return toBeDetermined.type === "email" || toBeDetermined.type === "password" || toBeDetermined.type === "number" || toBeDetermined.type === "text" || toBeDetermined.type === "textarea";
};
/**
 * Type guard to check if an input element is of the type Radio
 * @param toBeDetermined
 */

const isRadioField = toBeDetermined => {
  return toBeDetermined.type === "radio";
};
/**
 * Type guard to check if an input element is of the type Password
 * @param toBeDetermined
 */

const isPasswordField = toBeDetermined => {
  return toBeDetermined.type === "password";
};
/**
 * Type guard to check if an input element is of the type Radio
 * @param toBeDetermined
 */

const isDropdownField = toBeDetermined => {
  return toBeDetermined.type === "dropdown";
};
/**
 * Type guard to check if an input element is of the type Radio
 * @param toBeDetermined
 */

const isCheckBoxField = toBeDetermined => {
  return toBeDetermined.type === "checkbox";
};
/**
 * Type guard to check if an input element is of the type Query Parameters
 * @param toBeDetermined
 */

const isQueryParamsField = toBeDetermined => {
  return toBeDetermined.type === "queryParams";
};
/**
 * Type guard to check if an input element is of the type Radio
 * @param toBeDetermined
 */

const isToggleField = toBeDetermined => {
  return toBeDetermined.type === "toggle";
};
/**
 * Type guard to check if an input element is of the type Radio
 * @param toBeDetermined
 */

const isSubmitField = toBeDetermined => {
  return toBeDetermined.type === "submit";
};
/**
 * Type guard to check if an input element is of the type Radio
 * @param toBeDetermined
 */

const isResetField = toBeDetermined => {
  return toBeDetermined.type === "reset";
};
/**
 * Type guard to check if an input element is of the type Radio
 * @param toBeDetermined
 */

const isButtonField = toBeDetermined => {
  return toBeDetermined.type === "button";
};
/**
 * Type guard to check if an input element is of the type Radio
 * @param toBeDetermined
 */

const isDivider = toBeDetermined => {
  return toBeDetermined.type === "divider";
};
/**
 * Type guard to check if an input element is of the type Radio
 * @param toBeDetermined
 */

const isCustomField = toBeDetermined => {
  return toBeDetermined.type === "custom";
};
/**
 * Checks if the field is an input/checkbox/dropdown/radio/password field
 * @param toBeDetermined
 */

const isInputField = toBeDetermined => {
  return isTextField(toBeDetermined) || isCheckBoxField(toBeDetermined) || isDropdownField(toBeDetermined) || isRadioField(toBeDetermined) || isPasswordField(toBeDetermined) || isToggleField(toBeDetermined) || isQueryParamsField(toBeDetermined);
};

/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var FieldInputTypes;

(function (FieldInputTypes) {
  FieldInputTypes["INPUT_DEFAULT"] = "default";
  FieldInputTypes["INPUT_IDENTIFIER"] = "identifier";
  FieldInputTypes["INPUT_PHONE_NUMBER"] = "phone_number";
  FieldInputTypes["INPUT_NAME"] = "name";
  FieldInputTypes["INPUT_NUMBER"] = "number";
  FieldInputTypes["INPUT_RESOURCE_NAME"] = "resource_name";
  FieldInputTypes["INPUT_CLIENT_ID"] = "client_id";
  FieldInputTypes["INPUT_DESCRIPTION"] = "description";
  FieldInputTypes["INPUT_EMAIL"] = "email";
  FieldInputTypes["INPUT_URL"] = "url";
  FieldInputTypes["INPUT_COPY"] = "copy_input";
  FieldInputTypes["INPUT_PASSWORD"] = "password";
})(FieldInputTypes || (FieldInputTypes = {}));

var FieldButtonTypes;

(function (FieldButtonTypes) {
  FieldButtonTypes["BUTTON_PRIMARY"] = "primary_btn";
  FieldButtonTypes["BUTTON_CANCEL"] = "cancel_btn";
  FieldButtonTypes["BUTTON_LINK"] = "link_btn";
  FieldButtonTypes["BUTTON_DANGER"] = "danger_btn";
  FieldButtonTypes["BUTTON_DEFAULT"] = "default_btn";
})(FieldButtonTypes || (FieldButtonTypes = {}));

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

var check = function (it) {
  return it && it.Math == Math && it;
};

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global$m =
  // eslint-disable-next-line es-x/no-global-this -- safe
  check(typeof globalThis == 'object' && globalThis) ||
  check(typeof window == 'object' && window) ||
  // eslint-disable-next-line no-restricted-globals -- safe
  check(typeof self == 'object' && self) ||
  check(typeof commonjsGlobal == 'object' && commonjsGlobal) ||
  // eslint-disable-next-line no-new-func -- fallback
  (function () { return this; })() || Function('return this')();

var objectGetOwnPropertyDescriptor = {};

var fails$l = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};

var fails$k = fails$l;

// Detect IE8's incomplete defineProperty implementation
var descriptors = !fails$k(function () {
  // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] != 7;
});

var fails$j = fails$l;

var functionBindNative = !fails$j(function () {
  // eslint-disable-next-line es-x/no-function-prototype-bind -- safe
  var test = (function () { /* empty */ }).bind();
  // eslint-disable-next-line no-prototype-builtins -- safe
  return typeof test != 'function' || test.hasOwnProperty('prototype');
});

var NATIVE_BIND$3 = functionBindNative;

var call$i = Function.prototype.call;

var functionCall = NATIVE_BIND$3 ? call$i.bind(call$i) : function () {
  return call$i.apply(call$i, arguments);
};

var objectPropertyIsEnumerable = {};

var $propertyIsEnumerable = {}.propertyIsEnumerable;
// eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor$2 = Object.getOwnPropertyDescriptor;

// Nashorn ~ JDK8 bug
var NASHORN_BUG = getOwnPropertyDescriptor$2 && !$propertyIsEnumerable.call({ 1: 2 }, 1);

// `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
objectPropertyIsEnumerable.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor$2(this, V);
  return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;

var createPropertyDescriptor$4 = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};

var NATIVE_BIND$2 = functionBindNative;

var FunctionPrototype$2 = Function.prototype;
var bind$5 = FunctionPrototype$2.bind;
var call$h = FunctionPrototype$2.call;
var uncurryThis$k = NATIVE_BIND$2 && bind$5.bind(call$h, call$h);

var functionUncurryThis = NATIVE_BIND$2 ? function (fn) {
  return fn && uncurryThis$k(fn);
} : function (fn) {
  return fn && function () {
    return call$h.apply(fn, arguments);
  };
};

var uncurryThis$j = functionUncurryThis;

var toString$7 = uncurryThis$j({}.toString);
var stringSlice$3 = uncurryThis$j(''.slice);

var classofRaw$1 = function (it) {
  return stringSlice$3(toString$7(it), 8, -1);
};

var uncurryThis$i = functionUncurryThis;
var fails$i = fails$l;
var classof$7 = classofRaw$1;

var $Object$4 = Object;
var split = uncurryThis$i(''.split);

// fallback for non-array-like ES3 and non-enumerable old V8 strings
var indexedObject = fails$i(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins -- safe
  return !$Object$4('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof$7(it) == 'String' ? split(it, '') : $Object$4(it);
} : $Object$4;

// we can't use just `it == null` since of `document.all` special case
// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot-aec
var isNullOrUndefined$5 = function (it) {
  return it === null || it === undefined;
};

var isNullOrUndefined$4 = isNullOrUndefined$5;

var $TypeError$e = TypeError;

// `RequireObjectCoercible` abstract operation
// https://tc39.es/ecma262/#sec-requireobjectcoercible
var requireObjectCoercible$6 = function (it) {
  if (isNullOrUndefined$4(it)) throw $TypeError$e("Can't call method on " + it);
  return it;
};

// toObject with fallback for non-array-like ES3 strings
var IndexedObject$1 = indexedObject;
var requireObjectCoercible$5 = requireObjectCoercible$6;

var toIndexedObject$5 = function (it) {
  return IndexedObject$1(requireObjectCoercible$5(it));
};

// `IsCallable` abstract operation
// https://tc39.es/ecma262/#sec-iscallable
var isCallable$l = function (argument) {
  return typeof argument == 'function';
};

var isCallable$k = isCallable$l;

var documentAll = typeof document == 'object' && document.all;

// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot
var SPECIAL_DOCUMENT_ALL = typeof documentAll == 'undefined' && documentAll !== undefined;

var isObject$9 = SPECIAL_DOCUMENT_ALL ? function (it) {
  return typeof it == 'object' ? it !== null : isCallable$k(it) || it === documentAll;
} : function (it) {
  return typeof it == 'object' ? it !== null : isCallable$k(it);
};

var global$l = global$m;
var isCallable$j = isCallable$l;

var aFunction = function (argument) {
  return isCallable$j(argument) ? argument : undefined;
};

var getBuiltIn$8 = function (namespace, method) {
  return arguments.length < 2 ? aFunction(global$l[namespace]) : global$l[namespace] && global$l[namespace][method];
};

var uncurryThis$h = functionUncurryThis;

var objectIsPrototypeOf = uncurryThis$h({}.isPrototypeOf);

var getBuiltIn$7 = getBuiltIn$8;

var engineUserAgent = getBuiltIn$7('navigator', 'userAgent') || '';

var global$k = global$m;
var userAgent$3 = engineUserAgent;

var process$3 = global$k.process;
var Deno$1 = global$k.Deno;
var versions = process$3 && process$3.versions || Deno$1 && Deno$1.version;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  // in old Chrome, versions of V8 isn't V8 = Chrome / 10
  // but their correct versions are not interesting for us
  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
}

// BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
// so check `userAgent` even if `.v8` exists, but 0
if (!version && userAgent$3) {
  match = userAgent$3.match(/Edge\/(\d+)/);
  if (!match || match[1] >= 74) {
    match = userAgent$3.match(/Chrome\/(\d+)/);
    if (match) version = +match[1];
  }
}

var engineV8Version = version;

/* eslint-disable es-x/no-symbol -- required for testing */

var V8_VERSION$1 = engineV8Version;
var fails$h = fails$l;

// eslint-disable-next-line es-x/no-object-getownpropertysymbols -- required for testing
var symbolConstructorDetection = !!Object.getOwnPropertySymbols && !fails$h(function () {
  var symbol = Symbol();
  // Chrome 38 Symbol has incorrect toString conversion
  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
  return !String(symbol) || !(Object(symbol) instanceof Symbol) ||
    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
    !Symbol.sham && V8_VERSION$1 && V8_VERSION$1 < 41;
});

/* eslint-disable es-x/no-symbol -- required for testing */

var NATIVE_SYMBOL$1 = symbolConstructorDetection;

var useSymbolAsUid = NATIVE_SYMBOL$1
  && !Symbol.sham
  && typeof Symbol.iterator == 'symbol';

var getBuiltIn$6 = getBuiltIn$8;
var isCallable$i = isCallable$l;
var isPrototypeOf$3 = objectIsPrototypeOf;
var USE_SYMBOL_AS_UID$1 = useSymbolAsUid;

var $Object$3 = Object;

var isSymbol$2 = USE_SYMBOL_AS_UID$1 ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  var $Symbol = getBuiltIn$6('Symbol');
  return isCallable$i($Symbol) && isPrototypeOf$3($Symbol.prototype, $Object$3(it));
};

var $String$3 = String;

var tryToString$4 = function (argument) {
  try {
    return $String$3(argument);
  } catch (error) {
    return 'Object';
  }
};

var isCallable$h = isCallable$l;
var tryToString$3 = tryToString$4;

var $TypeError$d = TypeError;

// `Assert: IsCallable(argument) is true`
var aCallable$7 = function (argument) {
  if (isCallable$h(argument)) return argument;
  throw $TypeError$d(tryToString$3(argument) + ' is not a function');
};

var aCallable$6 = aCallable$7;
var isNullOrUndefined$3 = isNullOrUndefined$5;

// `GetMethod` abstract operation
// https://tc39.es/ecma262/#sec-getmethod
var getMethod$4 = function (V, P) {
  var func = V[P];
  return isNullOrUndefined$3(func) ? undefined : aCallable$6(func);
};

var call$g = functionCall;
var isCallable$g = isCallable$l;
var isObject$8 = isObject$9;

var $TypeError$c = TypeError;

// `OrdinaryToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-ordinarytoprimitive
var ordinaryToPrimitive$1 = function (input, pref) {
  var fn, val;
  if (pref === 'string' && isCallable$g(fn = input.toString) && !isObject$8(val = call$g(fn, input))) return val;
  if (isCallable$g(fn = input.valueOf) && !isObject$8(val = call$g(fn, input))) return val;
  if (pref !== 'string' && isCallable$g(fn = input.toString) && !isObject$8(val = call$g(fn, input))) return val;
  throw $TypeError$c("Can't convert object to primitive value");
};

var shared$4 = {exports: {}};

var global$j = global$m;

// eslint-disable-next-line es-x/no-object-defineproperty -- safe
var defineProperty$5 = Object.defineProperty;

var defineGlobalProperty$3 = function (key, value) {
  try {
    defineProperty$5(global$j, key, { value: value, configurable: true, writable: true });
  } catch (error) {
    global$j[key] = value;
  } return value;
};

var global$i = global$m;
var defineGlobalProperty$2 = defineGlobalProperty$3;

var SHARED = '__core-js_shared__';
var store$3 = global$i[SHARED] || defineGlobalProperty$2(SHARED, {});

var sharedStore = store$3;

var store$2 = sharedStore;

(shared$4.exports = function (key, value) {
  return store$2[key] || (store$2[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: '3.25.0',
  mode: 'global',
  copyright: '© 2014-2022 Denis Pushkarev (zloirock.ru)',
  license: 'https://github.com/zloirock/core-js/blob/v3.25.0/LICENSE',
  source: 'https://github.com/zloirock/core-js'
});

var requireObjectCoercible$4 = requireObjectCoercible$6;

var $Object$2 = Object;

// `ToObject` abstract operation
// https://tc39.es/ecma262/#sec-toobject
var toObject$3 = function (argument) {
  return $Object$2(requireObjectCoercible$4(argument));
};

var uncurryThis$g = functionUncurryThis;
var toObject$2 = toObject$3;

var hasOwnProperty = uncurryThis$g({}.hasOwnProperty);

// `HasOwnProperty` abstract operation
// https://tc39.es/ecma262/#sec-hasownproperty
// eslint-disable-next-line es-x/no-object-hasown -- safe
var hasOwnProperty_1 = Object.hasOwn || function hasOwn(it, key) {
  return hasOwnProperty(toObject$2(it), key);
};

var uncurryThis$f = functionUncurryThis;

var id = 0;
var postfix = Math.random();
var toString$6 = uncurryThis$f(1.0.toString);

var uid$2 = function (key) {
  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString$6(++id + postfix, 36);
};

var global$h = global$m;
var shared$3 = shared$4.exports;
var hasOwn$a = hasOwnProperty_1;
var uid$1 = uid$2;
var NATIVE_SYMBOL = symbolConstructorDetection;
var USE_SYMBOL_AS_UID = useSymbolAsUid;

var WellKnownSymbolsStore = shared$3('wks');
var Symbol$1 = global$h.Symbol;
var symbolFor = Symbol$1 && Symbol$1['for'];
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol$1 : Symbol$1 && Symbol$1.withoutSetter || uid$1;

var wellKnownSymbol$h = function (name) {
  if (!hasOwn$a(WellKnownSymbolsStore, name) || !(NATIVE_SYMBOL || typeof WellKnownSymbolsStore[name] == 'string')) {
    var description = 'Symbol.' + name;
    if (NATIVE_SYMBOL && hasOwn$a(Symbol$1, name)) {
      WellKnownSymbolsStore[name] = Symbol$1[name];
    } else if (USE_SYMBOL_AS_UID && symbolFor) {
      WellKnownSymbolsStore[name] = symbolFor(description);
    } else {
      WellKnownSymbolsStore[name] = createWellKnownSymbol(description);
    }
  } return WellKnownSymbolsStore[name];
};

var call$f = functionCall;
var isObject$7 = isObject$9;
var isSymbol$1 = isSymbol$2;
var getMethod$3 = getMethod$4;
var ordinaryToPrimitive = ordinaryToPrimitive$1;
var wellKnownSymbol$g = wellKnownSymbol$h;

var $TypeError$b = TypeError;
var TO_PRIMITIVE = wellKnownSymbol$g('toPrimitive');

// `ToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-toprimitive
var toPrimitive$1 = function (input, pref) {
  if (!isObject$7(input) || isSymbol$1(input)) return input;
  var exoticToPrim = getMethod$3(input, TO_PRIMITIVE);
  var result;
  if (exoticToPrim) {
    if (pref === undefined) pref = 'default';
    result = call$f(exoticToPrim, input, pref);
    if (!isObject$7(result) || isSymbol$1(result)) return result;
    throw $TypeError$b("Can't convert object to primitive value");
  }
  if (pref === undefined) pref = 'number';
  return ordinaryToPrimitive(input, pref);
};

var toPrimitive = toPrimitive$1;
var isSymbol = isSymbol$2;

// `ToPropertyKey` abstract operation
// https://tc39.es/ecma262/#sec-topropertykey
var toPropertyKey$3 = function (argument) {
  var key = toPrimitive(argument, 'string');
  return isSymbol(key) ? key : key + '';
};

var global$g = global$m;
var isObject$6 = isObject$9;

var document$3 = global$g.document;
// typeof document.createElement is 'object' in old IE
var EXISTS$1 = isObject$6(document$3) && isObject$6(document$3.createElement);

var documentCreateElement$2 = function (it) {
  return EXISTS$1 ? document$3.createElement(it) : {};
};

var DESCRIPTORS$a = descriptors;
var fails$g = fails$l;
var createElement$1 = documentCreateElement$2;

// Thanks to IE8 for its funny defineProperty
var ie8DomDefine = !DESCRIPTORS$a && !fails$g(function () {
  // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
  return Object.defineProperty(createElement$1('div'), 'a', {
    get: function () { return 7; }
  }).a != 7;
});

var DESCRIPTORS$9 = descriptors;
var call$e = functionCall;
var propertyIsEnumerableModule$1 = objectPropertyIsEnumerable;
var createPropertyDescriptor$3 = createPropertyDescriptor$4;
var toIndexedObject$4 = toIndexedObject$5;
var toPropertyKey$2 = toPropertyKey$3;
var hasOwn$9 = hasOwnProperty_1;
var IE8_DOM_DEFINE$1 = ie8DomDefine;

// eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
objectGetOwnPropertyDescriptor.f = DESCRIPTORS$9 ? $getOwnPropertyDescriptor$1 : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject$4(O);
  P = toPropertyKey$2(P);
  if (IE8_DOM_DEFINE$1) try {
    return $getOwnPropertyDescriptor$1(O, P);
  } catch (error) { /* empty */ }
  if (hasOwn$9(O, P)) return createPropertyDescriptor$3(!call$e(propertyIsEnumerableModule$1.f, O, P), O[P]);
};

var objectDefineProperty = {};

var DESCRIPTORS$8 = descriptors;
var fails$f = fails$l;

// V8 ~ Chrome 36-
// https://bugs.chromium.org/p/v8/issues/detail?id=3334
var v8PrototypeDefineBug = DESCRIPTORS$8 && fails$f(function () {
  // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
  return Object.defineProperty(function () { /* empty */ }, 'prototype', {
    value: 42,
    writable: false
  }).prototype != 42;
});

var isObject$5 = isObject$9;

var $String$2 = String;
var $TypeError$a = TypeError;

// `Assert: Type(argument) is Object`
var anObject$e = function (argument) {
  if (isObject$5(argument)) return argument;
  throw $TypeError$a($String$2(argument) + ' is not an object');
};

var DESCRIPTORS$7 = descriptors;
var IE8_DOM_DEFINE = ie8DomDefine;
var V8_PROTOTYPE_DEFINE_BUG$1 = v8PrototypeDefineBug;
var anObject$d = anObject$e;
var toPropertyKey$1 = toPropertyKey$3;

var $TypeError$9 = TypeError;
// eslint-disable-next-line es-x/no-object-defineproperty -- safe
var $defineProperty = Object.defineProperty;
// eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var ENUMERABLE = 'enumerable';
var CONFIGURABLE$1 = 'configurable';
var WRITABLE = 'writable';

// `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty
objectDefineProperty.f = DESCRIPTORS$7 ? V8_PROTOTYPE_DEFINE_BUG$1 ? function defineProperty(O, P, Attributes) {
  anObject$d(O);
  P = toPropertyKey$1(P);
  anObject$d(Attributes);
  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
    var current = $getOwnPropertyDescriptor(O, P);
    if (current && current[WRITABLE]) {
      O[P] = Attributes.value;
      Attributes = {
        configurable: CONFIGURABLE$1 in Attributes ? Attributes[CONFIGURABLE$1] : current[CONFIGURABLE$1],
        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
        writable: false
      };
    }
  } return $defineProperty(O, P, Attributes);
} : $defineProperty : function defineProperty(O, P, Attributes) {
  anObject$d(O);
  P = toPropertyKey$1(P);
  anObject$d(Attributes);
  if (IE8_DOM_DEFINE) try {
    return $defineProperty(O, P, Attributes);
  } catch (error) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw $TypeError$9('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};

var DESCRIPTORS$6 = descriptors;
var definePropertyModule$5 = objectDefineProperty;
var createPropertyDescriptor$2 = createPropertyDescriptor$4;

var createNonEnumerableProperty$5 = DESCRIPTORS$6 ? function (object, key, value) {
  return definePropertyModule$5.f(object, key, createPropertyDescriptor$2(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};

var makeBuiltIn$2 = {exports: {}};

var DESCRIPTORS$5 = descriptors;
var hasOwn$8 = hasOwnProperty_1;

var FunctionPrototype$1 = Function.prototype;
// eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
var getDescriptor = DESCRIPTORS$5 && Object.getOwnPropertyDescriptor;

var EXISTS = hasOwn$8(FunctionPrototype$1, 'name');
// additional protection from minified / mangled / dropped function names
var PROPER = EXISTS && (function something() { /* empty */ }).name === 'something';
var CONFIGURABLE = EXISTS && (!DESCRIPTORS$5 || (DESCRIPTORS$5 && getDescriptor(FunctionPrototype$1, 'name').configurable));

var functionName = {
  EXISTS: EXISTS,
  PROPER: PROPER,
  CONFIGURABLE: CONFIGURABLE
};

var uncurryThis$e = functionUncurryThis;
var isCallable$f = isCallable$l;
var store$1 = sharedStore;

var functionToString = uncurryThis$e(Function.toString);

// this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper
if (!isCallable$f(store$1.inspectSource)) {
  store$1.inspectSource = function (it) {
    return functionToString(it);
  };
}

var inspectSource$3 = store$1.inspectSource;

var global$f = global$m;
var isCallable$e = isCallable$l;

var WeakMap$1 = global$f.WeakMap;

var weakMapBasicDetection = isCallable$e(WeakMap$1) && /native code/.test(String(WeakMap$1));

var shared$2 = shared$4.exports;
var uid = uid$2;

var keys = shared$2('keys');

var sharedKey$3 = function (key) {
  return keys[key] || (keys[key] = uid(key));
};

var hiddenKeys$4 = {};

var NATIVE_WEAK_MAP = weakMapBasicDetection;
var global$e = global$m;
var uncurryThis$d = functionUncurryThis;
var isObject$4 = isObject$9;
var createNonEnumerableProperty$4 = createNonEnumerableProperty$5;
var hasOwn$7 = hasOwnProperty_1;
var shared$1 = sharedStore;
var sharedKey$2 = sharedKey$3;
var hiddenKeys$3 = hiddenKeys$4;

var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var TypeError$2 = global$e.TypeError;
var WeakMap = global$e.WeakMap;
var set$1, get, has;

var enforce = function (it) {
  return has(it) ? get(it) : set$1(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;
    if (!isObject$4(it) || (state = get(it)).type !== TYPE) {
      throw TypeError$2('Incompatible receiver, ' + TYPE + ' required');
    } return state;
  };
};

if (NATIVE_WEAK_MAP || shared$1.state) {
  var store = shared$1.state || (shared$1.state = new WeakMap());
  var wmget = uncurryThis$d(store.get);
  var wmhas = uncurryThis$d(store.has);
  var wmset = uncurryThis$d(store.set);
  set$1 = function (it, metadata) {
    if (wmhas(store, it)) throw TypeError$2(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    wmset(store, it, metadata);
    return metadata;
  };
  get = function (it) {
    return wmget(store, it) || {};
  };
  has = function (it) {
    return wmhas(store, it);
  };
} else {
  var STATE = sharedKey$2('state');
  hiddenKeys$3[STATE] = true;
  set$1 = function (it, metadata) {
    if (hasOwn$7(it, STATE)) throw TypeError$2(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    createNonEnumerableProperty$4(it, STATE, metadata);
    return metadata;
  };
  get = function (it) {
    return hasOwn$7(it, STATE) ? it[STATE] : {};
  };
  has = function (it) {
    return hasOwn$7(it, STATE);
  };
}

var internalState = {
  set: set$1,
  get: get,
  has: has,
  enforce: enforce,
  getterFor: getterFor
};

var fails$e = fails$l;
var isCallable$d = isCallable$l;
var hasOwn$6 = hasOwnProperty_1;
var DESCRIPTORS$4 = descriptors;
var CONFIGURABLE_FUNCTION_NAME$1 = functionName.CONFIGURABLE;
var inspectSource$2 = inspectSource$3;
var InternalStateModule$2 = internalState;

var enforceInternalState = InternalStateModule$2.enforce;
var getInternalState$2 = InternalStateModule$2.get;
// eslint-disable-next-line es-x/no-object-defineproperty -- safe
var defineProperty$4 = Object.defineProperty;

var CONFIGURABLE_LENGTH = DESCRIPTORS$4 && !fails$e(function () {
  return defineProperty$4(function () { /* empty */ }, 'length', { value: 8 }).length !== 8;
});

var TEMPLATE = String(String).split('String');

var makeBuiltIn$1 = makeBuiltIn$2.exports = function (value, name, options) {
  if (String(name).slice(0, 7) === 'Symbol(') {
    name = '[' + String(name).replace(/^Symbol\(([^)]*)\)/, '$1') + ']';
  }
  if (options && options.getter) name = 'get ' + name;
  if (options && options.setter) name = 'set ' + name;
  if (!hasOwn$6(value, 'name') || (CONFIGURABLE_FUNCTION_NAME$1 && value.name !== name)) {
    if (DESCRIPTORS$4) defineProperty$4(value, 'name', { value: name, configurable: true });
    else value.name = name;
  }
  if (CONFIGURABLE_LENGTH && options && hasOwn$6(options, 'arity') && value.length !== options.arity) {
    defineProperty$4(value, 'length', { value: options.arity });
  }
  try {
    if (options && hasOwn$6(options, 'constructor') && options.constructor) {
      if (DESCRIPTORS$4) defineProperty$4(value, 'prototype', { writable: false });
    // in V8 ~ Chrome 53, prototypes of some methods, like `Array.prototype.values`, are non-writable
    } else if (value.prototype) value.prototype = undefined;
  } catch (error) { /* empty */ }
  var state = enforceInternalState(value);
  if (!hasOwn$6(state, 'source')) {
    state.source = TEMPLATE.join(typeof name == 'string' ? name : '');
  } return value;
};

// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
// eslint-disable-next-line no-extend-native -- required
Function.prototype.toString = makeBuiltIn$1(function toString() {
  return isCallable$d(this) && getInternalState$2(this).source || inspectSource$2(this);
}, 'toString');

var isCallable$c = isCallable$l;
var definePropertyModule$4 = objectDefineProperty;
var makeBuiltIn = makeBuiltIn$2.exports;
var defineGlobalProperty$1 = defineGlobalProperty$3;

var defineBuiltIn$7 = function (O, key, value, options) {
  if (!options) options = {};
  var simple = options.enumerable;
  var name = options.name !== undefined ? options.name : key;
  if (isCallable$c(value)) makeBuiltIn(value, name, options);
  if (options.global) {
    if (simple) O[key] = value;
    else defineGlobalProperty$1(key, value);
  } else {
    try {
      if (!options.unsafe) delete O[key];
      else if (O[key]) simple = true;
    } catch (error) { /* empty */ }
    if (simple) O[key] = value;
    else definePropertyModule$4.f(O, key, {
      value: value,
      enumerable: false,
      configurable: !options.nonConfigurable,
      writable: !options.nonWritable
    });
  } return O;
};

var objectGetOwnPropertyNames = {};

var ceil = Math.ceil;
var floor = Math.floor;

// `Math.trunc` method
// https://tc39.es/ecma262/#sec-math.trunc
// eslint-disable-next-line es-x/no-math-trunc -- safe
var mathTrunc = Math.trunc || function trunc(x) {
  var n = +x;
  return (n > 0 ? floor : ceil)(n);
};

var trunc = mathTrunc;

// `ToIntegerOrInfinity` abstract operation
// https://tc39.es/ecma262/#sec-tointegerorinfinity
var toIntegerOrInfinity$3 = function (argument) {
  var number = +argument;
  // eslint-disable-next-line no-self-compare -- NaN check
  return number !== number || number === 0 ? 0 : trunc(number);
};

var toIntegerOrInfinity$2 = toIntegerOrInfinity$3;

var max$1 = Math.max;
var min$2 = Math.min;

// Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
var toAbsoluteIndex$2 = function (index, length) {
  var integer = toIntegerOrInfinity$2(index);
  return integer < 0 ? max$1(integer + length, 0) : min$2(integer, length);
};

var toIntegerOrInfinity$1 = toIntegerOrInfinity$3;

var min$1 = Math.min;

// `ToLength` abstract operation
// https://tc39.es/ecma262/#sec-tolength
var toLength$2 = function (argument) {
  return argument > 0 ? min$1(toIntegerOrInfinity$1(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};

var toLength$1 = toLength$2;

// `LengthOfArrayLike` abstract operation
// https://tc39.es/ecma262/#sec-lengthofarraylike
var lengthOfArrayLike$3 = function (obj) {
  return toLength$1(obj.length);
};

var toIndexedObject$3 = toIndexedObject$5;
var toAbsoluteIndex$1 = toAbsoluteIndex$2;
var lengthOfArrayLike$2 = lengthOfArrayLike$3;

// `Array.prototype.{ indexOf, includes }` methods implementation
var createMethod$2 = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject$3($this);
    var length = lengthOfArrayLike$2(O);
    var index = toAbsoluteIndex$1(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare -- NaN check
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare -- NaN check
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

var arrayIncludes = {
  // `Array.prototype.includes` method
  // https://tc39.es/ecma262/#sec-array.prototype.includes
  includes: createMethod$2(true),
  // `Array.prototype.indexOf` method
  // https://tc39.es/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod$2(false)
};

var uncurryThis$c = functionUncurryThis;
var hasOwn$5 = hasOwnProperty_1;
var toIndexedObject$2 = toIndexedObject$5;
var indexOf$1 = arrayIncludes.indexOf;
var hiddenKeys$2 = hiddenKeys$4;

var push$1 = uncurryThis$c([].push);

var objectKeysInternal = function (object, names) {
  var O = toIndexedObject$2(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) !hasOwn$5(hiddenKeys$2, key) && hasOwn$5(O, key) && push$1(result, key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (hasOwn$5(O, key = names[i++])) {
    ~indexOf$1(result, key) || push$1(result, key);
  }
  return result;
};

// IE8- don't enum bug keys
var enumBugKeys$3 = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];

var internalObjectKeys$1 = objectKeysInternal;
var enumBugKeys$2 = enumBugKeys$3;

var hiddenKeys$1 = enumBugKeys$2.concat('length', 'prototype');

// `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
// eslint-disable-next-line es-x/no-object-getownpropertynames -- safe
objectGetOwnPropertyNames.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys$1(O, hiddenKeys$1);
};

var objectGetOwnPropertySymbols = {};

// eslint-disable-next-line es-x/no-object-getownpropertysymbols -- safe
objectGetOwnPropertySymbols.f = Object.getOwnPropertySymbols;

var getBuiltIn$5 = getBuiltIn$8;
var uncurryThis$b = functionUncurryThis;
var getOwnPropertyNamesModule = objectGetOwnPropertyNames;
var getOwnPropertySymbolsModule$1 = objectGetOwnPropertySymbols;
var anObject$c = anObject$e;

var concat$1 = uncurryThis$b([].concat);

// all object keys, includes non-enumerable and symbols
var ownKeys$1 = getBuiltIn$5('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule.f(anObject$c(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule$1.f;
  return getOwnPropertySymbols ? concat$1(keys, getOwnPropertySymbols(it)) : keys;
};

var hasOwn$4 = hasOwnProperty_1;
var ownKeys = ownKeys$1;
var getOwnPropertyDescriptorModule = objectGetOwnPropertyDescriptor;
var definePropertyModule$3 = objectDefineProperty;

var copyConstructorProperties$1 = function (target, source, exceptions) {
  var keys = ownKeys(source);
  var defineProperty = definePropertyModule$3.f;
  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!hasOwn$4(target, key) && !(exceptions && hasOwn$4(exceptions, key))) {
      defineProperty(target, key, getOwnPropertyDescriptor(source, key));
    }
  }
};

var fails$d = fails$l;
var isCallable$b = isCallable$l;

var replacement = /#|\.prototype\./;

var isForced$2 = function (feature, detection) {
  var value = data[normalize(feature)];
  return value == POLYFILL ? true
    : value == NATIVE ? false
    : isCallable$b(detection) ? fails$d(detection)
    : !!detection;
};

var normalize = isForced$2.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced$2.data = {};
var NATIVE = isForced$2.NATIVE = 'N';
var POLYFILL = isForced$2.POLYFILL = 'P';

var isForced_1 = isForced$2;

var global$d = global$m;
var getOwnPropertyDescriptor$1 = objectGetOwnPropertyDescriptor.f;
var createNonEnumerableProperty$3 = createNonEnumerableProperty$5;
var defineBuiltIn$6 = defineBuiltIn$7;
var defineGlobalProperty = defineGlobalProperty$3;
var copyConstructorProperties = copyConstructorProperties$1;
var isForced$1 = isForced_1;

/*
  options.target         - name of the target object
  options.global         - target is the global object
  options.stat           - export as static methods of target
  options.proto          - export as prototype methods of target
  options.real           - real prototype method for the `pure` version
  options.forced         - export even if the native feature is available
  options.bind           - bind methods to the target, required for the `pure` version
  options.wrap           - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe         - use the simple assignment of property instead of delete + defineProperty
  options.sham           - add a flag to not completely full polyfills
  options.enumerable     - export as enumerable property
  options.dontCallGetSet - prevent calling a getter on target
  options.name           - the .name of the function if it does not match the key
*/
var _export = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var FORCED, target, key, targetProperty, sourceProperty, descriptor;
  if (GLOBAL) {
    target = global$d;
  } else if (STATIC) {
    target = global$d[TARGET] || defineGlobalProperty(TARGET, {});
  } else {
    target = (global$d[TARGET] || {}).prototype;
  }
  if (target) for (key in source) {
    sourceProperty = source[key];
    if (options.dontCallGetSet) {
      descriptor = getOwnPropertyDescriptor$1(target, key);
      targetProperty = descriptor && descriptor.value;
    } else targetProperty = target[key];
    FORCED = isForced$1(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    // contained in target
    if (!FORCED && targetProperty !== undefined) {
      if (typeof sourceProperty == typeof targetProperty) continue;
      copyConstructorProperties(sourceProperty, targetProperty);
    }
    // add a flag to not completely full polyfills
    if (options.sham || (targetProperty && targetProperty.sham)) {
      createNonEnumerableProperty$3(sourceProperty, 'sham', true);
    }
    defineBuiltIn$6(target, key, sourceProperty, options);
  }
};

var internalObjectKeys = objectKeysInternal;
var enumBugKeys$1 = enumBugKeys$3;

// `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
// eslint-disable-next-line es-x/no-object-keys -- safe
var objectKeys$2 = Object.keys || function keys(O) {
  return internalObjectKeys(O, enumBugKeys$1);
};

var DESCRIPTORS$3 = descriptors;
var uncurryThis$a = functionUncurryThis;
var call$d = functionCall;
var fails$c = fails$l;
var objectKeys$1 = objectKeys$2;
var getOwnPropertySymbolsModule = objectGetOwnPropertySymbols;
var propertyIsEnumerableModule = objectPropertyIsEnumerable;
var toObject$1 = toObject$3;
var IndexedObject = indexedObject;

// eslint-disable-next-line es-x/no-object-assign -- safe
var $assign = Object.assign;
// eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
var defineProperty$3 = Object.defineProperty;
var concat = uncurryThis$a([].concat);

// `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign
var objectAssign = !$assign || fails$c(function () {
  // should have correct order of operations (Edge bug)
  if (DESCRIPTORS$3 && $assign({ b: 1 }, $assign(defineProperty$3({}, 'a', {
    enumerable: true,
    get: function () {
      defineProperty$3(this, 'b', {
        value: 3,
        enumerable: false
      });
    }
  }), { b: 2 })).b !== 1) return true;
  // should work with symbols and should have deterministic property order (V8 bug)
  var A = {};
  var B = {};
  // eslint-disable-next-line es-x/no-symbol -- safe
  var symbol = Symbol();
  var alphabet = 'abcdefghijklmnopqrst';
  A[symbol] = 7;
  alphabet.split('').forEach(function (chr) { B[chr] = chr; });
  return $assign({}, A)[symbol] != 7 || objectKeys$1($assign({}, B)).join('') != alphabet;
}) ? function assign(target, source) { // eslint-disable-line no-unused-vars -- required for `.length`
  var T = toObject$1(target);
  var argumentsLength = arguments.length;
  var index = 1;
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  var propertyIsEnumerable = propertyIsEnumerableModule.f;
  while (argumentsLength > index) {
    var S = IndexedObject(arguments[index++]);
    var keys = getOwnPropertySymbols ? concat(objectKeys$1(S), getOwnPropertySymbols(S)) : objectKeys$1(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) {
      key = keys[j++];
      if (!DESCRIPTORS$3 || call$d(propertyIsEnumerable, S, key)) T[key] = S[key];
    }
  } return T;
} : $assign;

var $$b = _export;
var assign = objectAssign;

// `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign
// eslint-disable-next-line es-x/no-object-assign -- required for testing
$$b({ target: 'Object', stat: true, arity: 2, forced: Object.assign !== assign }, {
  assign: assign
});

var objectDefineProperties = {};

var DESCRIPTORS$2 = descriptors;
var V8_PROTOTYPE_DEFINE_BUG = v8PrototypeDefineBug;
var definePropertyModule$2 = objectDefineProperty;
var anObject$b = anObject$e;
var toIndexedObject$1 = toIndexedObject$5;
var objectKeys = objectKeys$2;

// `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
// eslint-disable-next-line es-x/no-object-defineproperties -- safe
objectDefineProperties.f = DESCRIPTORS$2 && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject$b(O);
  var props = toIndexedObject$1(Properties);
  var keys = objectKeys(Properties);
  var length = keys.length;
  var index = 0;
  var key;
  while (length > index) definePropertyModule$2.f(O, key = keys[index++], props[key]);
  return O;
};

var getBuiltIn$4 = getBuiltIn$8;

var html$2 = getBuiltIn$4('document', 'documentElement');

/* global ActiveXObject -- old IE, WSH */

var anObject$a = anObject$e;
var definePropertiesModule = objectDefineProperties;
var enumBugKeys = enumBugKeys$3;
var hiddenKeys = hiddenKeys$4;
var html$1 = html$2;
var documentCreateElement$1 = documentCreateElement$2;
var sharedKey$1 = sharedKey$3;

var GT = '>';
var LT = '<';
var PROTOTYPE = 'prototype';
var SCRIPT = 'script';
var IE_PROTO$1 = sharedKey$1('IE_PROTO');

var EmptyConstructor = function () { /* empty */ };

var scriptTag = function (content) {
  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
};

// Create object with fake `null` prototype: use ActiveX Object with cleared prototype
var NullProtoObjectViaActiveX = function (activeXDocument) {
  activeXDocument.write(scriptTag(''));
  activeXDocument.close();
  var temp = activeXDocument.parentWindow.Object;
  activeXDocument = null; // avoid memory leak
  return temp;
};

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var NullProtoObjectViaIFrame = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = documentCreateElement$1('iframe');
  var JS = 'java' + SCRIPT + ':';
  var iframeDocument;
  iframe.style.display = 'none';
  html$1.appendChild(iframe);
  // https://github.com/zloirock/core-js/issues/475
  iframe.src = String(JS);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(scriptTag('document.F=Object'));
  iframeDocument.close();
  return iframeDocument.F;
};

// Check for document.domain and active x support
// No need to use active x approach when document.domain is not set
// see https://github.com/es-shims/es5-shim/issues/150
// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
// avoid IE GC bug
var activeXDocument;
var NullProtoObject = function () {
  try {
    activeXDocument = new ActiveXObject('htmlfile');
  } catch (error) { /* ignore */ }
  NullProtoObject = typeof document != 'undefined'
    ? document.domain && activeXDocument
      ? NullProtoObjectViaActiveX(activeXDocument) // old IE
      : NullProtoObjectViaIFrame()
    : NullProtoObjectViaActiveX(activeXDocument); // WSH
  var length = enumBugKeys.length;
  while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
  return NullProtoObject();
};

hiddenKeys[IE_PROTO$1] = true;

// `Object.create` method
// https://tc39.es/ecma262/#sec-object.create
// eslint-disable-next-line es-x/no-object-create -- safe
var objectCreate = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    EmptyConstructor[PROTOTYPE] = anObject$a(O);
    result = new EmptyConstructor();
    EmptyConstructor[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO$1] = O;
  } else result = NullProtoObject();
  return Properties === undefined ? result : definePropertiesModule.f(result, Properties);
};

var wellKnownSymbol$f = wellKnownSymbol$h;
var create$2 = objectCreate;
var defineProperty$2 = objectDefineProperty.f;

var UNSCOPABLES = wellKnownSymbol$f('unscopables');
var ArrayPrototype$1 = Array.prototype;

// Array.prototype[@@unscopables]
// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
if (ArrayPrototype$1[UNSCOPABLES] == undefined) {
  defineProperty$2(ArrayPrototype$1, UNSCOPABLES, {
    configurable: true,
    value: create$2(null)
  });
}

// add a key to Array.prototype[@@unscopables]
var addToUnscopables$2 = function (key) {
  ArrayPrototype$1[UNSCOPABLES][key] = true;
};

var iterators = {};

var fails$b = fails$l;

var correctPrototypeGetter = !fails$b(function () {
  function F() { /* empty */ }
  F.prototype.constructor = null;
  // eslint-disable-next-line es-x/no-object-getprototypeof -- required for testing
  return Object.getPrototypeOf(new F()) !== F.prototype;
});

var hasOwn$3 = hasOwnProperty_1;
var isCallable$a = isCallable$l;
var toObject = toObject$3;
var sharedKey = sharedKey$3;
var CORRECT_PROTOTYPE_GETTER = correctPrototypeGetter;

var IE_PROTO = sharedKey('IE_PROTO');
var $Object$1 = Object;
var ObjectPrototype = $Object$1.prototype;

// `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof
// eslint-disable-next-line es-x/no-object-getprototypeof -- safe
var objectGetPrototypeOf = CORRECT_PROTOTYPE_GETTER ? $Object$1.getPrototypeOf : function (O) {
  var object = toObject(O);
  if (hasOwn$3(object, IE_PROTO)) return object[IE_PROTO];
  var constructor = object.constructor;
  if (isCallable$a(constructor) && object instanceof constructor) {
    return constructor.prototype;
  } return object instanceof $Object$1 ? ObjectPrototype : null;
};

var fails$a = fails$l;
var isCallable$9 = isCallable$l;
var isObject$3 = isObject$9;
var getPrototypeOf$1 = objectGetPrototypeOf;
var defineBuiltIn$5 = defineBuiltIn$7;
var wellKnownSymbol$e = wellKnownSymbol$h;

var ITERATOR$5 = wellKnownSymbol$e('iterator');
var BUGGY_SAFARI_ITERATORS$1 = false;

// `%IteratorPrototype%` object
// https://tc39.es/ecma262/#sec-%iteratorprototype%-object
var IteratorPrototype$2, PrototypeOfArrayIteratorPrototype, arrayIterator;

/* eslint-disable es-x/no-array-prototype-keys -- safe */
if ([].keys) {
  arrayIterator = [].keys();
  // Safari 8 has buggy iterators w/o `next`
  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS$1 = true;
  else {
    PrototypeOfArrayIteratorPrototype = getPrototypeOf$1(getPrototypeOf$1(arrayIterator));
    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype$2 = PrototypeOfArrayIteratorPrototype;
  }
}

var NEW_ITERATOR_PROTOTYPE = !isObject$3(IteratorPrototype$2) || fails$a(function () {
  var test = {};
  // FF44- legacy iterators case
  return IteratorPrototype$2[ITERATOR$5].call(test) !== test;
});

if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype$2 = {};

// `%IteratorPrototype%[@@iterator]()` method
// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator
if (!isCallable$9(IteratorPrototype$2[ITERATOR$5])) {
  defineBuiltIn$5(IteratorPrototype$2, ITERATOR$5, function () {
    return this;
  });
}

var iteratorsCore = {
  IteratorPrototype: IteratorPrototype$2,
  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS$1
};

var defineProperty$1 = objectDefineProperty.f;
var hasOwn$2 = hasOwnProperty_1;
var wellKnownSymbol$d = wellKnownSymbol$h;

var TO_STRING_TAG$3 = wellKnownSymbol$d('toStringTag');

var setToStringTag$3 = function (target, TAG, STATIC) {
  if (target && !STATIC) target = target.prototype;
  if (target && !hasOwn$2(target, TO_STRING_TAG$3)) {
    defineProperty$1(target, TO_STRING_TAG$3, { configurable: true, value: TAG });
  }
};

var IteratorPrototype$1 = iteratorsCore.IteratorPrototype;
var create$1 = objectCreate;
var createPropertyDescriptor$1 = createPropertyDescriptor$4;
var setToStringTag$2 = setToStringTag$3;
var Iterators$4 = iterators;

var returnThis$1 = function () { return this; };

var iteratorCreateConstructor = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
  var TO_STRING_TAG = NAME + ' Iterator';
  IteratorConstructor.prototype = create$1(IteratorPrototype$1, { next: createPropertyDescriptor$1(+!ENUMERABLE_NEXT, next) });
  setToStringTag$2(IteratorConstructor, TO_STRING_TAG, false);
  Iterators$4[TO_STRING_TAG] = returnThis$1;
  return IteratorConstructor;
};

var isCallable$8 = isCallable$l;

var $String$1 = String;
var $TypeError$8 = TypeError;

var aPossiblePrototype$1 = function (argument) {
  if (typeof argument == 'object' || isCallable$8(argument)) return argument;
  throw $TypeError$8("Can't set " + $String$1(argument) + ' as a prototype');
};

/* eslint-disable no-proto -- safe */

var uncurryThis$9 = functionUncurryThis;
var anObject$9 = anObject$e;
var aPossiblePrototype = aPossiblePrototype$1;

// `Object.setPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.setprototypeof
// Works with __proto__ only. Old v8 can't work with null proto objects.
// eslint-disable-next-line es-x/no-object-setprototypeof -- safe
var objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
  var CORRECT_SETTER = false;
  var test = {};
  var setter;
  try {
    // eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
    setter = uncurryThis$9(Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set);
    setter(test, []);
    CORRECT_SETTER = test instanceof Array;
  } catch (error) { /* empty */ }
  return function setPrototypeOf(O, proto) {
    anObject$9(O);
    aPossiblePrototype(proto);
    if (CORRECT_SETTER) setter(O, proto);
    else O.__proto__ = proto;
    return O;
  };
}() : undefined);

var $$a = _export;
var call$c = functionCall;
var FunctionName = functionName;
var isCallable$7 = isCallable$l;
var createIteratorConstructor = iteratorCreateConstructor;
var getPrototypeOf = objectGetPrototypeOf;
var setPrototypeOf$1 = objectSetPrototypeOf;
var setToStringTag$1 = setToStringTag$3;
var createNonEnumerableProperty$2 = createNonEnumerableProperty$5;
var defineBuiltIn$4 = defineBuiltIn$7;
var wellKnownSymbol$c = wellKnownSymbol$h;
var Iterators$3 = iterators;
var IteratorsCore = iteratorsCore;

var PROPER_FUNCTION_NAME$2 = FunctionName.PROPER;
var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
var IteratorPrototype = IteratorsCore.IteratorPrototype;
var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
var ITERATOR$4 = wellKnownSymbol$c('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';

var returnThis = function () { return this; };

var iteratorDefine = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
  createIteratorConstructor(IteratorConstructor, NAME, next);

  var getIterationMethod = function (KIND) {
    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
    if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];
    switch (KIND) {
      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
    } return function () { return new IteratorConstructor(this); };
  };

  var TO_STRING_TAG = NAME + ' Iterator';
  var INCORRECT_VALUES_NAME = false;
  var IterablePrototype = Iterable.prototype;
  var nativeIterator = IterablePrototype[ITERATOR$4]
    || IterablePrototype['@@iterator']
    || DEFAULT && IterablePrototype[DEFAULT];
  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
  var CurrentIteratorPrototype, methods, KEY;

  // fix native
  if (anyNativeIterator) {
    CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
    if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
      if (getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
        if (setPrototypeOf$1) {
          setPrototypeOf$1(CurrentIteratorPrototype, IteratorPrototype);
        } else if (!isCallable$7(CurrentIteratorPrototype[ITERATOR$4])) {
          defineBuiltIn$4(CurrentIteratorPrototype, ITERATOR$4, returnThis);
        }
      }
      // Set @@toStringTag to native iterators
      setToStringTag$1(CurrentIteratorPrototype, TO_STRING_TAG, true);
    }
  }

  // fix Array.prototype.{ values, @@iterator }.name in V8 / FF
  if (PROPER_FUNCTION_NAME$2 && DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
    if (CONFIGURABLE_FUNCTION_NAME) {
      createNonEnumerableProperty$2(IterablePrototype, 'name', VALUES);
    } else {
      INCORRECT_VALUES_NAME = true;
      defaultIterator = function values() { return call$c(nativeIterator, this); };
    }
  }

  // export additional methods
  if (DEFAULT) {
    methods = {
      values: getIterationMethod(VALUES),
      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
      entries: getIterationMethod(ENTRIES)
    };
    if (FORCED) for (KEY in methods) {
      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
        defineBuiltIn$4(IterablePrototype, KEY, methods[KEY]);
      }
    } else $$a({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
  }

  // define iterator
  if (IterablePrototype[ITERATOR$4] !== defaultIterator) {
    defineBuiltIn$4(IterablePrototype, ITERATOR$4, defaultIterator, { name: DEFAULT });
  }
  Iterators$3[NAME] = defaultIterator;

  return methods;
};

var toIndexedObject = toIndexedObject$5;
var addToUnscopables$1 = addToUnscopables$2;
var Iterators$2 = iterators;
var InternalStateModule$1 = internalState;
var defineProperty = objectDefineProperty.f;
var defineIterator = iteratorDefine;
var DESCRIPTORS$1 = descriptors;

var ARRAY_ITERATOR = 'Array Iterator';
var setInternalState$1 = InternalStateModule$1.set;
var getInternalState$1 = InternalStateModule$1.getterFor(ARRAY_ITERATOR);

// `Array.prototype.entries` method
// https://tc39.es/ecma262/#sec-array.prototype.entries
// `Array.prototype.keys` method
// https://tc39.es/ecma262/#sec-array.prototype.keys
// `Array.prototype.values` method
// https://tc39.es/ecma262/#sec-array.prototype.values
// `Array.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
// `CreateArrayIterator` internal method
// https://tc39.es/ecma262/#sec-createarrayiterator
var es_array_iterator = defineIterator(Array, 'Array', function (iterated, kind) {
  setInternalState$1(this, {
    type: ARRAY_ITERATOR,
    target: toIndexedObject(iterated), // target
    index: 0,                          // next index
    kind: kind                         // kind
  });
// `%ArrayIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
}, function () {
  var state = getInternalState$1(this);
  var target = state.target;
  var kind = state.kind;
  var index = state.index++;
  if (!target || index >= target.length) {
    state.target = undefined;
    return { value: undefined, done: true };
  }
  if (kind == 'keys') return { value: index, done: false };
  if (kind == 'values') return { value: target[index], done: false };
  return { value: [index, target[index]], done: false };
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values%
// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
// https://tc39.es/ecma262/#sec-createmappedargumentsobject
var values = Iterators$2.Arguments = Iterators$2.Array;

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables$1('keys');
addToUnscopables$1('values');
addToUnscopables$1('entries');

// V8 ~ Chrome 45- bug
if (DESCRIPTORS$1 && values.name !== 'values') try {
  defineProperty(values, 'name', { value: 'values' });
} catch (error) { /* empty */ }

// iterable DOM collections
// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
var domIterables = {
  CSSRuleList: 0,
  CSSStyleDeclaration: 0,
  CSSValueList: 0,
  ClientRectList: 0,
  DOMRectList: 0,
  DOMStringList: 0,
  DOMTokenList: 1,
  DataTransferItemList: 0,
  FileList: 0,
  HTMLAllCollection: 0,
  HTMLCollection: 0,
  HTMLFormElement: 0,
  HTMLSelectElement: 0,
  MediaList: 0,
  MimeTypeArray: 0,
  NamedNodeMap: 0,
  NodeList: 1,
  PaintRequestList: 0,
  Plugin: 0,
  PluginArray: 0,
  SVGLengthList: 0,
  SVGNumberList: 0,
  SVGPathSegList: 0,
  SVGPointList: 0,
  SVGStringList: 0,
  SVGTransformList: 0,
  SourceBufferList: 0,
  StyleSheetList: 0,
  TextTrackCueList: 0,
  TextTrackList: 0,
  TouchList: 0
};

// in old WebKit versions, `element.classList` is not an instance of global `DOMTokenList`
var documentCreateElement = documentCreateElement$2;

var classList = documentCreateElement('span').classList;
var DOMTokenListPrototype$1 = classList && classList.constructor && classList.constructor.prototype;

var domTokenListPrototype = DOMTokenListPrototype$1 === Object.prototype ? undefined : DOMTokenListPrototype$1;

var global$c = global$m;
var DOMIterables = domIterables;
var DOMTokenListPrototype = domTokenListPrototype;
var ArrayIteratorMethods = es_array_iterator;
var createNonEnumerableProperty$1 = createNonEnumerableProperty$5;
var wellKnownSymbol$b = wellKnownSymbol$h;

var ITERATOR$3 = wellKnownSymbol$b('iterator');
var TO_STRING_TAG$2 = wellKnownSymbol$b('toStringTag');
var ArrayValues = ArrayIteratorMethods.values;

var handlePrototype = function (CollectionPrototype, COLLECTION_NAME) {
  if (CollectionPrototype) {
    // some Chrome versions have non-configurable methods on DOMTokenList
    if (CollectionPrototype[ITERATOR$3] !== ArrayValues) try {
      createNonEnumerableProperty$1(CollectionPrototype, ITERATOR$3, ArrayValues);
    } catch (error) {
      CollectionPrototype[ITERATOR$3] = ArrayValues;
    }
    if (!CollectionPrototype[TO_STRING_TAG$2]) {
      createNonEnumerableProperty$1(CollectionPrototype, TO_STRING_TAG$2, COLLECTION_NAME);
    }
    if (DOMIterables[COLLECTION_NAME]) for (var METHOD_NAME in ArrayIteratorMethods) {
      // some Chrome versions have non-configurable methods on DOMTokenList
      if (CollectionPrototype[METHOD_NAME] !== ArrayIteratorMethods[METHOD_NAME]) try {
        createNonEnumerableProperty$1(CollectionPrototype, METHOD_NAME, ArrayIteratorMethods[METHOD_NAME]);
      } catch (error) {
        CollectionPrototype[METHOD_NAME] = ArrayIteratorMethods[METHOD_NAME];
      }
    }
  }
};

for (var COLLECTION_NAME in DOMIterables) {
  handlePrototype(global$c[COLLECTION_NAME] && global$c[COLLECTION_NAME].prototype, COLLECTION_NAME);
}

handlePrototype(DOMTokenListPrototype, 'DOMTokenList');

var wellKnownSymbol$a = wellKnownSymbol$h;

var TO_STRING_TAG$1 = wellKnownSymbol$a('toStringTag');
var test = {};

test[TO_STRING_TAG$1] = 'z';

var toStringTagSupport = String(test) === '[object z]';

var TO_STRING_TAG_SUPPORT = toStringTagSupport;
var isCallable$6 = isCallable$l;
var classofRaw = classofRaw$1;
var wellKnownSymbol$9 = wellKnownSymbol$h;

var TO_STRING_TAG = wellKnownSymbol$9('toStringTag');
var $Object = Object;

// ES3 wrong here
var CORRECT_ARGUMENTS = classofRaw(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (error) { /* empty */ }
};

// getting tag from ES6+ `Object.prototype.toString`
var classof$6 = TO_STRING_TAG_SUPPORT ? classofRaw : function (it) {
  var O, tag, result;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (tag = tryGet(O = $Object(it), TO_STRING_TAG)) == 'string' ? tag
    // builtinTag case
    : CORRECT_ARGUMENTS ? classofRaw(O)
    // ES3 arguments fallback
    : (result = classofRaw(O)) == 'Object' && isCallable$6(O.callee) ? 'Arguments' : result;
};

var classof$5 = classof$6;

var $String = String;

var toString$5 = function (argument) {
  if (classof$5(argument) === 'Symbol') throw TypeError('Cannot convert a Symbol value to a string');
  return $String(argument);
};

var anObject$8 = anObject$e;

// `RegExp.prototype.flags` getter implementation
// https://tc39.es/ecma262/#sec-get-regexp.prototype.flags
var regexpFlags$1 = function () {
  var that = anObject$8(this);
  var result = '';
  if (that.hasIndices) result += 'd';
  if (that.global) result += 'g';
  if (that.ignoreCase) result += 'i';
  if (that.multiline) result += 'm';
  if (that.dotAll) result += 's';
  if (that.unicode) result += 'u';
  if (that.unicodeSets) result += 'v';
  if (that.sticky) result += 'y';
  return result;
};

var fails$9 = fails$l;
var global$b = global$m;

// babel-minify and Closure Compiler transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError
var $RegExp$2 = global$b.RegExp;

var UNSUPPORTED_Y$2 = fails$9(function () {
  var re = $RegExp$2('a', 'y');
  re.lastIndex = 2;
  return re.exec('abcd') != null;
});

// UC Browser bug
// https://github.com/zloirock/core-js/issues/1008
var MISSED_STICKY = UNSUPPORTED_Y$2 || fails$9(function () {
  return !$RegExp$2('a', 'y').sticky;
});

var BROKEN_CARET = UNSUPPORTED_Y$2 || fails$9(function () {
  // https://bugzilla.mozilla.org/show_bug.cgi?id=773687
  var re = $RegExp$2('^r', 'gy');
  re.lastIndex = 2;
  return re.exec('str') != null;
});

var regexpStickyHelpers = {
  BROKEN_CARET: BROKEN_CARET,
  MISSED_STICKY: MISSED_STICKY,
  UNSUPPORTED_Y: UNSUPPORTED_Y$2
};

var fails$8 = fails$l;
var global$a = global$m;

// babel-minify and Closure Compiler transpiles RegExp('.', 's') -> /./s and it causes SyntaxError
var $RegExp$1 = global$a.RegExp;

var regexpUnsupportedDotAll = fails$8(function () {
  var re = $RegExp$1('.', 's');
  return !(re.dotAll && re.exec('\n') && re.flags === 's');
});

var fails$7 = fails$l;
var global$9 = global$m;

// babel-minify and Closure Compiler transpiles RegExp('(?<a>b)', 'g') -> /(?<a>b)/g and it causes SyntaxError
var $RegExp = global$9.RegExp;

var regexpUnsupportedNcg = fails$7(function () {
  var re = $RegExp('(?<a>b)', 'g');
  return re.exec('b').groups.a !== 'b' ||
    'b'.replace(re, '$<a>c') !== 'bc';
});

/* eslint-disable regexp/no-empty-capturing-group, regexp/no-empty-group, regexp/no-lazy-ends -- testing */
/* eslint-disable regexp/no-useless-quantifier -- testing */
var call$b = functionCall;
var uncurryThis$8 = functionUncurryThis;
var toString$4 = toString$5;
var regexpFlags = regexpFlags$1;
var stickyHelpers$1 = regexpStickyHelpers;
var shared = shared$4.exports;
var create = objectCreate;
var getInternalState = internalState.get;
var UNSUPPORTED_DOT_ALL = regexpUnsupportedDotAll;
var UNSUPPORTED_NCG = regexpUnsupportedNcg;

var nativeReplace = shared('native-string-replace', String.prototype.replace);
var nativeExec = RegExp.prototype.exec;
var patchedExec = nativeExec;
var charAt$2 = uncurryThis$8(''.charAt);
var indexOf = uncurryThis$8(''.indexOf);
var replace$1 = uncurryThis$8(''.replace);
var stringSlice$2 = uncurryThis$8(''.slice);

var UPDATES_LAST_INDEX_WRONG = (function () {
  var re1 = /a/;
  var re2 = /b*/g;
  call$b(nativeExec, re1, 'a');
  call$b(nativeExec, re2, 'a');
  return re1.lastIndex !== 0 || re2.lastIndex !== 0;
})();

var UNSUPPORTED_Y$1 = stickyHelpers$1.BROKEN_CARET;

// nonparticipating capturing group, copied from es5-shim's String#split patch.
var NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;

var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y$1 || UNSUPPORTED_DOT_ALL || UNSUPPORTED_NCG;

if (PATCH) {
  patchedExec = function exec(string) {
    var re = this;
    var state = getInternalState(re);
    var str = toString$4(string);
    var raw = state.raw;
    var result, reCopy, lastIndex, match, i, object, group;

    if (raw) {
      raw.lastIndex = re.lastIndex;
      result = call$b(patchedExec, raw, str);
      re.lastIndex = raw.lastIndex;
      return result;
    }

    var groups = state.groups;
    var sticky = UNSUPPORTED_Y$1 && re.sticky;
    var flags = call$b(regexpFlags, re);
    var source = re.source;
    var charsAdded = 0;
    var strCopy = str;

    if (sticky) {
      flags = replace$1(flags, 'y', '');
      if (indexOf(flags, 'g') === -1) {
        flags += 'g';
      }

      strCopy = stringSlice$2(str, re.lastIndex);
      // Support anchored sticky behavior.
      if (re.lastIndex > 0 && (!re.multiline || re.multiline && charAt$2(str, re.lastIndex - 1) !== '\n')) {
        source = '(?: ' + source + ')';
        strCopy = ' ' + strCopy;
        charsAdded++;
      }
      // ^(? + rx + ) is needed, in combination with some str slicing, to
      // simulate the 'y' flag.
      reCopy = new RegExp('^(?:' + source + ')', flags);
    }

    if (NPCG_INCLUDED) {
      reCopy = new RegExp('^' + source + '$(?!\\s)', flags);
    }
    if (UPDATES_LAST_INDEX_WRONG) lastIndex = re.lastIndex;

    match = call$b(nativeExec, sticky ? reCopy : re, strCopy);

    if (sticky) {
      if (match) {
        match.input = stringSlice$2(match.input, charsAdded);
        match[0] = stringSlice$2(match[0], charsAdded);
        match.index = re.lastIndex;
        re.lastIndex += match[0].length;
      } else re.lastIndex = 0;
    } else if (UPDATES_LAST_INDEX_WRONG && match) {
      re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
    }
    if (NPCG_INCLUDED && match && match.length > 1) {
      // Fix browsers whose `exec` methods don't consistently return `undefined`
      // for NPCG, like IE8. NOTE: This doesn't work for /(.?)?/
      call$b(nativeReplace, match[0], reCopy, function () {
        for (i = 1; i < arguments.length - 2; i++) {
          if (arguments[i] === undefined) match[i] = undefined;
        }
      });
    }

    if (match && groups) {
      match.groups = object = create(null);
      for (i = 0; i < groups.length; i++) {
        group = groups[i];
        object[group[0]] = match[group[1]];
      }
    }

    return match;
  };
}

var regexpExec$3 = patchedExec;

var $$9 = _export;
var exec$2 = regexpExec$3;

// `RegExp.prototype.exec` method
// https://tc39.es/ecma262/#sec-regexp.prototype.exec
$$9({ target: 'RegExp', proto: true, forced: /./.exec !== exec$2 }, {
  exec: exec$2
});

var call$a = functionCall;
var hasOwn$1 = hasOwnProperty_1;
var isPrototypeOf$2 = objectIsPrototypeOf;
var regExpFlags = regexpFlags$1;

var RegExpPrototype$2 = RegExp.prototype;

var regexpGetFlags = function (R) {
  var flags = R.flags;
  return flags === undefined && !('flags' in RegExpPrototype$2) && !hasOwn$1(R, 'flags') && isPrototypeOf$2(RegExpPrototype$2, R)
    ? call$a(regExpFlags, R) : flags;
};

var PROPER_FUNCTION_NAME$1 = functionName.PROPER;
var defineBuiltIn$3 = defineBuiltIn$7;
var anObject$7 = anObject$e;
var $toString = toString$5;
var fails$6 = fails$l;
var getRegExpFlags = regexpGetFlags;

var TO_STRING = 'toString';
var RegExpPrototype$1 = RegExp.prototype;
var nativeToString = RegExpPrototype$1[TO_STRING];

var NOT_GENERIC = fails$6(function () { return nativeToString.call({ source: 'a', flags: 'b' }) != '/a/b'; });
// FF44- RegExp#toString has a wrong name
var INCORRECT_NAME = PROPER_FUNCTION_NAME$1 && nativeToString.name != TO_STRING;

// `RegExp.prototype.toString` method
// https://tc39.es/ecma262/#sec-regexp.prototype.tostring
if (NOT_GENERIC || INCORRECT_NAME) {
  defineBuiltIn$3(RegExp.prototype, TO_STRING, function toString() {
    var R = anObject$7(this);
    var pattern = $toString(R.source);
    var flags = $toString(getRegExpFlags(R));
    return '/' + pattern + '/' + flags;
  }, { unsafe: true });
}

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

var NATIVE_BIND$1 = functionBindNative;

var FunctionPrototype = Function.prototype;
var apply$2 = FunctionPrototype.apply;
var call$9 = FunctionPrototype.call;

// eslint-disable-next-line es-x/no-reflect -- safe
var functionApply = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND$1 ? call$9.bind(apply$2) : function () {
  return call$9.apply(apply$2, arguments);
});

// TODO: Remove from `core-js@4` since it's moved to entry points

var uncurryThis$7 = functionUncurryThis;
var defineBuiltIn$2 = defineBuiltIn$7;
var regexpExec$2 = regexpExec$3;
var fails$5 = fails$l;
var wellKnownSymbol$8 = wellKnownSymbol$h;
var createNonEnumerableProperty = createNonEnumerableProperty$5;

var SPECIES$3 = wellKnownSymbol$8('species');
var RegExpPrototype = RegExp.prototype;

var fixRegexpWellKnownSymbolLogic = function (KEY, exec, FORCED, SHAM) {
  var SYMBOL = wellKnownSymbol$8(KEY);

  var DELEGATES_TO_SYMBOL = !fails$5(function () {
    // String methods call symbol-named RegEp methods
    var O = {};
    O[SYMBOL] = function () { return 7; };
    return ''[KEY](O) != 7;
  });

  var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL && !fails$5(function () {
    // Symbol-named RegExp methods call .exec
    var execCalled = false;
    var re = /a/;

    if (KEY === 'split') {
      // We can't use real regex here since it causes deoptimization
      // and serious performance degradation in V8
      // https://github.com/zloirock/core-js/issues/306
      re = {};
      // RegExp[@@split] doesn't call the regex's exec method, but first creates
      // a new one. We need to return the patched regex when creating the new one.
      re.constructor = {};
      re.constructor[SPECIES$3] = function () { return re; };
      re.flags = '';
      re[SYMBOL] = /./[SYMBOL];
    }

    re.exec = function () { execCalled = true; return null; };

    re[SYMBOL]('');
    return !execCalled;
  });

  if (
    !DELEGATES_TO_SYMBOL ||
    !DELEGATES_TO_EXEC ||
    FORCED
  ) {
    var uncurriedNativeRegExpMethod = uncurryThis$7(/./[SYMBOL]);
    var methods = exec(SYMBOL, ''[KEY], function (nativeMethod, regexp, str, arg2, forceStringMethod) {
      var uncurriedNativeMethod = uncurryThis$7(nativeMethod);
      var $exec = regexp.exec;
      if ($exec === regexpExec$2 || $exec === RegExpPrototype.exec) {
        if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
          // The native String method already delegates to @@method (this
          // polyfilled function), leasing to infinite recursion.
          // We avoid it by directly calling the native @@method method.
          return { done: true, value: uncurriedNativeRegExpMethod(regexp, str, arg2) };
        }
        return { done: true, value: uncurriedNativeMethod(str, regexp, arg2) };
      }
      return { done: false };
    });

    defineBuiltIn$2(String.prototype, KEY, methods[0]);
    defineBuiltIn$2(RegExpPrototype, SYMBOL, methods[1]);
  }

  if (SHAM) createNonEnumerableProperty(RegExpPrototype[SYMBOL], 'sham', true);
};

var isObject$2 = isObject$9;
var classof$4 = classofRaw$1;
var wellKnownSymbol$7 = wellKnownSymbol$h;

var MATCH$1 = wellKnownSymbol$7('match');

// `IsRegExp` abstract operation
// https://tc39.es/ecma262/#sec-isregexp
var isRegexp = function (it) {
  var isRegExp;
  return isObject$2(it) && ((isRegExp = it[MATCH$1]) !== undefined ? !!isRegExp : classof$4(it) == 'RegExp');
};

var uncurryThis$6 = functionUncurryThis;
var fails$4 = fails$l;
var isCallable$5 = isCallable$l;
var classof$3 = classof$6;
var getBuiltIn$3 = getBuiltIn$8;
var inspectSource$1 = inspectSource$3;

var noop = function () { /* empty */ };
var empty = [];
var construct = getBuiltIn$3('Reflect', 'construct');
var constructorRegExp = /^\s*(?:class|function)\b/;
var exec$1 = uncurryThis$6(constructorRegExp.exec);
var INCORRECT_TO_STRING = !constructorRegExp.exec(noop);

var isConstructorModern = function isConstructor(argument) {
  if (!isCallable$5(argument)) return false;
  try {
    construct(noop, empty, argument);
    return true;
  } catch (error) {
    return false;
  }
};

var isConstructorLegacy = function isConstructor(argument) {
  if (!isCallable$5(argument)) return false;
  switch (classof$3(argument)) {
    case 'AsyncFunction':
    case 'GeneratorFunction':
    case 'AsyncGeneratorFunction': return false;
  }
  try {
    // we can't check .prototype since constructors produced by .bind haven't it
    // `Function#toString` throws on some built-it function in some legacy engines
    // (for example, `DOMQuad` and similar in FF41-)
    return INCORRECT_TO_STRING || !!exec$1(constructorRegExp, inspectSource$1(argument));
  } catch (error) {
    return true;
  }
};

isConstructorLegacy.sham = true;

// `IsConstructor` abstract operation
// https://tc39.es/ecma262/#sec-isconstructor
var isConstructor$1 = !construct || fails$4(function () {
  var called;
  return isConstructorModern(isConstructorModern.call)
    || !isConstructorModern(Object)
    || !isConstructorModern(function () { called = true; })
    || called;
}) ? isConstructorLegacy : isConstructorModern;

var isConstructor = isConstructor$1;
var tryToString$2 = tryToString$4;

var $TypeError$7 = TypeError;

// `Assert: IsConstructor(argument) is true`
var aConstructor$1 = function (argument) {
  if (isConstructor(argument)) return argument;
  throw $TypeError$7(tryToString$2(argument) + ' is not a constructor');
};

var anObject$6 = anObject$e;
var aConstructor = aConstructor$1;
var isNullOrUndefined$2 = isNullOrUndefined$5;
var wellKnownSymbol$6 = wellKnownSymbol$h;

var SPECIES$2 = wellKnownSymbol$6('species');

// `SpeciesConstructor` abstract operation
// https://tc39.es/ecma262/#sec-speciesconstructor
var speciesConstructor$2 = function (O, defaultConstructor) {
  var C = anObject$6(O).constructor;
  var S;
  return C === undefined || isNullOrUndefined$2(S = anObject$6(C)[SPECIES$2]) ? defaultConstructor : aConstructor(S);
};

var uncurryThis$5 = functionUncurryThis;
var toIntegerOrInfinity = toIntegerOrInfinity$3;
var toString$3 = toString$5;
var requireObjectCoercible$3 = requireObjectCoercible$6;

var charAt$1 = uncurryThis$5(''.charAt);
var charCodeAt = uncurryThis$5(''.charCodeAt);
var stringSlice$1 = uncurryThis$5(''.slice);

var createMethod$1 = function (CONVERT_TO_STRING) {
  return function ($this, pos) {
    var S = toString$3(requireObjectCoercible$3($this));
    var position = toIntegerOrInfinity(pos);
    var size = S.length;
    var first, second;
    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
    first = charCodeAt(S, position);
    return first < 0xD800 || first > 0xDBFF || position + 1 === size
      || (second = charCodeAt(S, position + 1)) < 0xDC00 || second > 0xDFFF
        ? CONVERT_TO_STRING
          ? charAt$1(S, position)
          : first
        : CONVERT_TO_STRING
          ? stringSlice$1(S, position, position + 2)
          : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
  };
};

var stringMultibyte = {
  // `String.prototype.codePointAt` method
  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
  codeAt: createMethod$1(false),
  // `String.prototype.at` method
  // https://github.com/mathiasbynens/String.prototype.at
  charAt: createMethod$1(true)
};

var charAt = stringMultibyte.charAt;

// `AdvanceStringIndex` abstract operation
// https://tc39.es/ecma262/#sec-advancestringindex
var advanceStringIndex$1 = function (S, index, unicode) {
  return index + (unicode ? charAt(S, index).length : 1);
};

var toPropertyKey = toPropertyKey$3;
var definePropertyModule$1 = objectDefineProperty;
var createPropertyDescriptor = createPropertyDescriptor$4;

var createProperty$1 = function (object, key, value) {
  var propertyKey = toPropertyKey(key);
  if (propertyKey in object) definePropertyModule$1.f(object, propertyKey, createPropertyDescriptor(0, value));
  else object[propertyKey] = value;
};

var toAbsoluteIndex = toAbsoluteIndex$2;
var lengthOfArrayLike$1 = lengthOfArrayLike$3;
var createProperty = createProperty$1;

var $Array = Array;
var max = Math.max;

var arraySliceSimple = function (O, start, end) {
  var length = lengthOfArrayLike$1(O);
  var k = toAbsoluteIndex(start, length);
  var fin = toAbsoluteIndex(end === undefined ? length : end, length);
  var result = $Array(max(fin - k, 0));
  for (var n = 0; k < fin; k++, n++) createProperty(result, n, O[k]);
  result.length = n;
  return result;
};

var call$8 = functionCall;
var anObject$5 = anObject$e;
var isCallable$4 = isCallable$l;
var classof$2 = classofRaw$1;
var regexpExec$1 = regexpExec$3;

var $TypeError$6 = TypeError;

// `RegExpExec` abstract operation
// https://tc39.es/ecma262/#sec-regexpexec
var regexpExecAbstract = function (R, S) {
  var exec = R.exec;
  if (isCallable$4(exec)) {
    var result = call$8(exec, R, S);
    if (result !== null) anObject$5(result);
    return result;
  }
  if (classof$2(R) === 'RegExp') return call$8(regexpExec$1, R, S);
  throw $TypeError$6('RegExp#exec called on incompatible receiver');
};

var apply$1 = functionApply;
var call$7 = functionCall;
var uncurryThis$4 = functionUncurryThis;
var fixRegExpWellKnownSymbolLogic = fixRegexpWellKnownSymbolLogic;
var anObject$4 = anObject$e;
var isNullOrUndefined$1 = isNullOrUndefined$5;
var isRegExp$1 = isRegexp;
var requireObjectCoercible$2 = requireObjectCoercible$6;
var speciesConstructor$1 = speciesConstructor$2;
var advanceStringIndex = advanceStringIndex$1;
var toLength = toLength$2;
var toString$2 = toString$5;
var getMethod$2 = getMethod$4;
var arraySlice$2 = arraySliceSimple;
var callRegExpExec = regexpExecAbstract;
var regexpExec = regexpExec$3;
var stickyHelpers = regexpStickyHelpers;
var fails$3 = fails$l;

var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y;
var MAX_UINT32 = 0xFFFFFFFF;
var min = Math.min;
var $push = [].push;
var exec = uncurryThis$4(/./.exec);
var push = uncurryThis$4($push);
var stringSlice = uncurryThis$4(''.slice);

// Chrome 51 has a buggy "split" implementation when RegExp#exec !== nativeExec
// Weex JS has frozen built-in prototypes, so use try / catch wrapper
var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = !fails$3(function () {
  // eslint-disable-next-line regexp/no-empty-group -- required for testing
  var re = /(?:)/;
  var originalExec = re.exec;
  re.exec = function () { return originalExec.apply(this, arguments); };
  var result = 'ab'.split(re);
  return result.length !== 2 || result[0] !== 'a' || result[1] !== 'b';
});

// @@split logic
fixRegExpWellKnownSymbolLogic('split', function (SPLIT, nativeSplit, maybeCallNative) {
  var internalSplit;
  if (
    'abbc'.split(/(b)*/)[1] == 'c' ||
    // eslint-disable-next-line regexp/no-empty-group -- required for testing
    'test'.split(/(?:)/, -1).length != 4 ||
    'ab'.split(/(?:ab)*/).length != 2 ||
    '.'.split(/(.?)(.?)/).length != 4 ||
    // eslint-disable-next-line regexp/no-empty-capturing-group, regexp/no-empty-group -- required for testing
    '.'.split(/()()/).length > 1 ||
    ''.split(/.?/).length
  ) {
    // based on es5-shim implementation, need to rework it
    internalSplit = function (separator, limit) {
      var string = toString$2(requireObjectCoercible$2(this));
      var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
      if (lim === 0) return [];
      if (separator === undefined) return [string];
      // If `separator` is not a regex, use native split
      if (!isRegExp$1(separator)) {
        return call$7(nativeSplit, string, separator, lim);
      }
      var output = [];
      var flags = (separator.ignoreCase ? 'i' : '') +
                  (separator.multiline ? 'm' : '') +
                  (separator.unicode ? 'u' : '') +
                  (separator.sticky ? 'y' : '');
      var lastLastIndex = 0;
      // Make `global` and avoid `lastIndex` issues by working with a copy
      var separatorCopy = new RegExp(separator.source, flags + 'g');
      var match, lastIndex, lastLength;
      while (match = call$7(regexpExec, separatorCopy, string)) {
        lastIndex = separatorCopy.lastIndex;
        if (lastIndex > lastLastIndex) {
          push(output, stringSlice(string, lastLastIndex, match.index));
          if (match.length > 1 && match.index < string.length) apply$1($push, output, arraySlice$2(match, 1));
          lastLength = match[0].length;
          lastLastIndex = lastIndex;
          if (output.length >= lim) break;
        }
        if (separatorCopy.lastIndex === match.index) separatorCopy.lastIndex++; // Avoid an infinite loop
      }
      if (lastLastIndex === string.length) {
        if (lastLength || !exec(separatorCopy, '')) push(output, '');
      } else push(output, stringSlice(string, lastLastIndex));
      return output.length > lim ? arraySlice$2(output, 0, lim) : output;
    };
  // Chakra, V8
  } else if ('0'.split(undefined, 0).length) {
    internalSplit = function (separator, limit) {
      return separator === undefined && limit === 0 ? [] : call$7(nativeSplit, this, separator, limit);
    };
  } else internalSplit = nativeSplit;

  return [
    // `String.prototype.split` method
    // https://tc39.es/ecma262/#sec-string.prototype.split
    function split(separator, limit) {
      var O = requireObjectCoercible$2(this);
      var splitter = isNullOrUndefined$1(separator) ? undefined : getMethod$2(separator, SPLIT);
      return splitter
        ? call$7(splitter, separator, O, limit)
        : call$7(internalSplit, toString$2(O), separator, limit);
    },
    // `RegExp.prototype[@@split]` method
    // https://tc39.es/ecma262/#sec-regexp.prototype-@@split
    //
    // NOTE: This cannot be properly polyfilled in engines that don't support
    // the 'y' flag.
    function (string, limit) {
      var rx = anObject$4(this);
      var S = toString$2(string);
      var res = maybeCallNative(internalSplit, rx, S, limit, internalSplit !== nativeSplit);

      if (res.done) return res.value;

      var C = speciesConstructor$1(rx, RegExp);

      var unicodeMatching = rx.unicode;
      var flags = (rx.ignoreCase ? 'i' : '') +
                  (rx.multiline ? 'm' : '') +
                  (rx.unicode ? 'u' : '') +
                  (UNSUPPORTED_Y ? 'g' : 'y');

      // ^(? + rx + ) is needed, in combination with some S slicing, to
      // simulate the 'y' flag.
      var splitter = new C(UNSUPPORTED_Y ? '^(?:' + rx.source + ')' : rx, flags);
      var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
      if (lim === 0) return [];
      if (S.length === 0) return callRegExpExec(splitter, S) === null ? [S] : [];
      var p = 0;
      var q = 0;
      var A = [];
      while (q < S.length) {
        splitter.lastIndex = UNSUPPORTED_Y ? 0 : q;
        var z = callRegExpExec(splitter, UNSUPPORTED_Y ? stringSlice(S, q) : S);
        var e;
        if (
          z === null ||
          (e = min(toLength(splitter.lastIndex + (UNSUPPORTED_Y ? q : 0)), S.length)) === p
        ) {
          q = advanceStringIndex(S, q, unicodeMatching);
        } else {
          push(A, stringSlice(S, p, q));
          if (A.length === lim) return A;
          for (var i = 1; i <= z.length - 1; i++) {
            push(A, z[i]);
            if (A.length === lim) return A;
          }
          q = p = e;
        }
      }
      push(A, stringSlice(S, p));
      return A;
    }
  ];
}, !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC, UNSUPPORTED_Y);

var $$8 = _export;
var $includes = arrayIncludes.includes;
var fails$2 = fails$l;
var addToUnscopables = addToUnscopables$2;

// FF99+ bug
var BROKEN_ON_SPARSE = fails$2(function () {
  return !Array(1).includes();
});

// `Array.prototype.includes` method
// https://tc39.es/ecma262/#sec-array.prototype.includes
$$8({ target: 'Array', proto: true, forced: BROKEN_ON_SPARSE }, {
  includes: function includes(el /* , fromIndex = 0 */) {
    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
  }
});

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables('includes');

var isRegExp = isRegexp;

var $TypeError$5 = TypeError;

var notARegexp = function (it) {
  if (isRegExp(it)) {
    throw $TypeError$5("The method doesn't accept regular expressions");
  } return it;
};

var wellKnownSymbol$5 = wellKnownSymbol$h;

var MATCH = wellKnownSymbol$5('match');

var correctIsRegexpLogic = function (METHOD_NAME) {
  var regexp = /./;
  try {
    '/./'[METHOD_NAME](regexp);
  } catch (error1) {
    try {
      regexp[MATCH] = false;
      return '/./'[METHOD_NAME](regexp);
    } catch (error2) { /* empty */ }
  } return false;
};

var $$7 = _export;
var uncurryThis$3 = functionUncurryThis;
var notARegExp = notARegexp;
var requireObjectCoercible$1 = requireObjectCoercible$6;
var toString$1 = toString$5;
var correctIsRegExpLogic = correctIsRegexpLogic;

var stringIndexOf = uncurryThis$3(''.indexOf);

// `String.prototype.includes` method
// https://tc39.es/ecma262/#sec-string.prototype.includes
$$7({ target: 'String', proto: true, forced: !correctIsRegExpLogic('includes') }, {
  includes: function includes(searchString /* , position = 0 */) {
    return !!~stringIndexOf(
      toString$1(requireObjectCoercible$1(this)),
      toString$1(notARegExp(searchString)),
      arguments.length > 1 ? arguments[1] : undefined
    );
  }
});

const QueryParameters = props => {
  const {
    label,
    name,
    value,
    onChange
  } = props;
  const QUERY_PARAMETER_SEPARATOR = "&";
  const SPECIAL_CHARACTERS = [",", "&", "=", "?"];
  const [queryParamName, setQueryParamName] = useState("");
  const [queryParamValue, setQueryParamValue] = useState("");
  const [errorMessage, setErrorMessage] = useState("");
  const [queryParams, setQueryParams] = useState([]);
  /**
   * Called when `queryParams` is changed.
   */

  useEffect(() => {
    fireOnChangeEvent(queryParams, onChange);
  }, [queryParams]);
  /**
   * Build query parameter object from the given string form.
   * @param  Query - parameter in the string form.
   */

  const buildQueryParameter = queryParameter => {
    return {
      name: queryParameter === null || queryParameter === void 0 ? void 0 : queryParameter.split("=")[0],
      value: queryParameter === null || queryParameter === void 0 ? void 0 : queryParameter.split("=")[1]
    };
  };
  /**
   * Build query parameter string value, from it's object form.
   */


  const buildQueryParameterString = queryParam => queryParam.name + "=" + queryParam.value;
  /**
   * Build query parameters string value, from it's object form.
   */


  const buildQueryParametersString = queryParams => {
    var _a;

    return (_a = queryParams === null || queryParams === void 0 ? void 0 : queryParams.map(buildQueryParameterString)) === null || _a === void 0 ? void 0 : _a.join("&");
  };
  /**
   * Trigger provided onChange handler with provided query parameters.
   *
   * @param queryParams - QueryParameters.
   * @param onChange - onChange handler.
   */


  const fireOnChangeEvent = (queryParams, onChange) => {
    onChange({
      target: {
        value: buildQueryParametersString(queryParams)
      }
    });
  };
  /**
   * Update input field values for query parameter.
   *
   * @param queryParam - QueryParameter.
   */


  const updateQueryParameterInputFields = queryParam => {
    setQueryParamName(queryParam === null || queryParam === void 0 ? void 0 : queryParam.name);
    setQueryParamValue(queryParam === null || queryParam === void 0 ? void 0 : queryParam.value);
  };
  /**
   * Called when `initialValue` is changed.
   */


  useEffect(() => {
    var _a;

    if (isEmpty(value)) return;
    setQueryParams((_a = value.split(QUERY_PARAMETER_SEPARATOR)) === null || _a === void 0 ? void 0 : _a.map(buildQueryParameter));
  }, [value]);
  /**
   * Enter button option.
   *
   * @param e - keypress event.
   */

  const keyPressed = e => {
    const key = e.which || e.charCode || e.keyCode;

    if (key === 13) {
      handleQueryParameterAdd(e);
    }
  };

  const handleQueryParameterAdd = event => {
    event.preventDefault();

    if (isEmpty(queryParamName) || isEmpty(queryParamValue)) {
      return;
    }

    setErrorMessage("");
    let isError = false;
    SPECIAL_CHARACTERS.map(c => {
      if (queryParamValue.includes(c) || queryParamName.includes(c)) {
        setErrorMessage("Cannot include \"" + c + "\" as a query parameter.");
        isError = true;
      }
    });
    if (isError) return;
    const output = [{
      name: queryParamName,
      value: queryParamValue
    }];
    queryParams.forEach(function (queryParam) {
      const existing = output.filter(item => {
        return item.name == queryParam.name;
      });

      if (existing.length) {
        const existingIndex = output.indexOf(existing[0]);
        output[existingIndex].value = queryParam.value + " " + output[existingIndex].value;
      } else {
        output.push(queryParam);
      }
    });
    setQueryParams(output);
    updateQueryParameterInputFields({
      name: "",
      value: ""
    });
  };

  const handleLabelRemove = queryParameter => {
    if (isEmpty(queryParameter)) {
      return;
    }

    setQueryParams(filter(queryParams, queryParam => !isEqual(queryParam, buildQueryParameter(queryParameter))));
  };

  return /*#__PURE__*/React.createElement(React.Fragment, null, label ? /*#__PURE__*/React.createElement(FormInputLabel, {
    htmlFor: name
  }, /*#__PURE__*/React.createElement("span", {
    style: {
      display: "flex",
      marginBottom: 10
    }
  }, label)) : null, /*#__PURE__*/React.createElement(Form$1.Group, {
    inline: true,
    widths: "equal",
    unstackable: true
  }, /*#__PURE__*/React.createElement(Form$1.Input, {
    fluid: true,
    value: queryParamName,
    focus: true,
    placeholder: "name",
    onChange: (_event, data) => setQueryParamName(data.value),
    onKeyDown: keyPressed
  }), /*#__PURE__*/React.createElement(Form$1.Input, {
    fluid: true,
    value: queryParamValue,
    focus: true,
    placeholder: "value",
    onChange: (_event, data) => setQueryParamValue(data.value),
    onKeyDown: keyPressed
  }), /*#__PURE__*/React.createElement(Popup, {
    trigger: /*#__PURE__*/React.createElement(Button, {
      onClick: e => handleQueryParameterAdd(e),
      icon: "add",
      type: "button",
      disabled: false
    }),
    position: "top center",
    content: "Add key value pair",
    inverted: true
  })), /*#__PURE__*/React.createElement(Message, {
    visible: errorMessage !== "",
    error: true,
    content: errorMessage
  }), queryParams && (queryParams === null || queryParams === void 0 ? void 0 : queryParams.map((eachQueryParam, index) => {
    const queryParameter = eachQueryParam.name + "=" + eachQueryParam.value;
    return /*#__PURE__*/React.createElement(Label, {
      key: index
    }, queryParameter, /*#__PURE__*/React.createElement(Icon, {
      name: "delete",
      onClick: () => handleLabelRemove(queryParameter)
    }));
  })));
};

// a string of all valid unicode whitespaces
var whitespaces$2 = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' +
  '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

var uncurryThis$2 = functionUncurryThis;
var requireObjectCoercible = requireObjectCoercible$6;
var toString = toString$5;
var whitespaces$1 = whitespaces$2;

var replace = uncurryThis$2(''.replace);
var whitespace = '[' + whitespaces$1 + ']';
var ltrim = RegExp('^' + whitespace + whitespace + '*');
var rtrim = RegExp(whitespace + whitespace + '*$');

// `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation
var createMethod = function (TYPE) {
  return function ($this) {
    var string = toString(requireObjectCoercible($this));
    if (TYPE & 1) string = replace(string, ltrim, '');
    if (TYPE & 2) string = replace(string, rtrim, '');
    return string;
  };
};

var stringTrim = {
  // `String.prototype.{ trimLeft, trimStart }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimstart
  start: createMethod(1),
  // `String.prototype.{ trimRight, trimEnd }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimend
  end: createMethod(2),
  // `String.prototype.trim` method
  // https://tc39.es/ecma262/#sec-string.prototype.trim
  trim: createMethod(3)
};

var PROPER_FUNCTION_NAME = functionName.PROPER;
var fails$1 = fails$l;
var whitespaces = whitespaces$2;

var non = '\u200B\u0085\u180E';

// check that a method works with the correct list
// of whitespaces and has a correct name
var stringTrimForced = function (METHOD_NAME) {
  return fails$1(function () {
    return !!whitespaces[METHOD_NAME]()
      || non[METHOD_NAME]() !== non
      || (PROPER_FUNCTION_NAME && whitespaces[METHOD_NAME].name !== METHOD_NAME);
  });
};

var $$6 = _export;
var $trim = stringTrim.trim;
var forcedStringTrimMethod = stringTrimForced;

// `String.prototype.trim` method
// https://tc39.es/ecma262/#sec-string.prototype.trim
$$6({ target: 'String', proto: true, forced: forcedStringTrimMethod('trim') }, {
  trim: function trim() {
    return $trim(this);
  }
});

/**
 * Implementation of the Scopes component.
 * @param props- ScopesPropsInterface
 */

const Scopes = props => {
  const {
    defaultValue,
    label,
    value,
    required,
    onChange,
    onBlur,
    placeholder
  } = props;
  const SCOPE_SEPARATOR = " ";
  const [scopeValue, setScopeValue] = useState("");
  const [scopes, setScopes] = useState([]);
  const [errorMessage, setErrorMessage] = useState("");
  /**
    * Called when `initialValue` is changed.
    */

  useEffect(() => {
    var _a;

    if (isEmpty(value)) {
      return;
    }

    setScopes((_a = value.split(SCOPE_SEPARATOR)) === null || _a === void 0 ? void 0 : _a.map(buildScope));
  }, [value]);
  /**
    * Called when `scopes` is changed.
    */

  useEffect(() => {
    fireOnChangeEvent(scopes, onChange);
  }, [scopes]);
  /**
    * Build scope object from the given string form.
    *
    * @param scope - Scope in the string form.
    * @returns Scope as an object.
    */

  const buildScope = scope => {
    return {
      value: scope
    };
  };
  /**
    * Build scope string value, from it's object form.
    */


  const buildScopeString = scope => scope.value;
  /**
    * Build scopes string value, from scopes object list.
    */


  const buildScopesString = scopes => {
    var _a;

    return (_a = scopes === null || scopes === void 0 ? void 0 : scopes.map(buildScopeString)) === null || _a === void 0 ? void 0 : _a.join(SCOPE_SEPARATOR);
  };
  /**
    * Trigger provided onChange handler with provided scopes.
    *
    * @param scopes - Scopes.
    * @param onChange - onChange handler.
    */


  const fireOnChangeEvent = (scopes, onChange) => {
    onChange({
      target: {
        value: buildScopesString(scopes)
      }
    });
  };
  /**
    * Update input field values for scope.
    *
    * @param scope - Scope.
    */


  const updateScopeInputFields = scope => {
    setScopeValue(scope === null || scope === void 0 ? void 0 : scope.value);
  };
  /**
   * Enter button option.
   * @param e - keypress event.
   */


  const keyPressed = e => {
    if (e.key === "Enter") {
      handleScopeAdd(e);
    }
  };

  const handleScopeAdd = event => {
    event.preventDefault();

    if (isEmpty(scopeValue)) {
      return;
    }

    setErrorMessage("");
    const output = [{
      value: scopeValue
    }];
    scopes.forEach(function (scope) {
      const existing = output.filter(item => {
        return item.value == scope.value;
      });

      if (existing.length) {
        return;
      } else {
        output.push(scope);
      }
    });
    setScopes(output);
    updateScopeInputFields({
      value: ""
    });
  };

  const handleLabelRemove = scopeParam => {
    if (isEmpty(scopeParam)) {
      return;
    }

    setScopes(filter(scopes, scope => !isEqual(scope, buildScope(scopeParam))));
  };

  return /*#__PURE__*/React.createElement(Form$1.Group, {
    grouped: true
  }, label && /*#__PURE__*/React.createElement("div", {
    className: `field ${required ? "required" : ""}`
  }, /*#__PURE__*/React.createElement("label", null, label)), /*#__PURE__*/React.createElement(Form$1.Group, {
    inline: true,
    widths: "equal",
    unstackable: true
  }, /*#__PURE__*/React.createElement(Form$1.Input, {
    fluid: true,
    value: scopeValue,
    onBlur: onBlur,
    focus: true,
    onChange: (_event, data) => {
      setScopeValue(data.value.trim());
    },
    onKeyDown: keyPressed,
    placeholder: placeholder
  }), /*#__PURE__*/React.createElement(Popup, {
    trigger: /*#__PURE__*/React.createElement(Button, {
      onClick: e => handleScopeAdd(e),
      icon: "add",
      type: "button",
      disabled: false
    }),
    position: "top center",
    content: "Add scope",
    inverted: true
  })), /*#__PURE__*/React.createElement(Message, {
    visible: errorMessage != "",
    error: true,
    content: errorMessage
  }), scopes && (scopes === null || scopes === void 0 ? void 0 : scopes.map((eachScope, index) => {
    const scope = eachScope.value;

    if (scope === defaultValue) {
      return /*#__PURE__*/React.createElement(Label, {
        key: index
      }, scope);
    } else {
      return /*#__PURE__*/React.createElement(Label, {
        key: index
      }, scope, /*#__PURE__*/React.createElement(Icon, {
        name: "delete",
        onClick: () => handleLabelRemove(scope)
      }));
    }
  })));
};

/**
 * The enter key.
 */

const ENTER_KEY = "Enter";
const TextFieldAdapter = props => {
  const {
    childFieldProps,
    input,
    meta,
    parentFormProps
  } = props;
  return /*#__PURE__*/React.createElement(Form$1.Input, Object.assign({
    "aria-label": childFieldProps.ariaLabel,
    key: childFieldProps.testId,
    required: childFieldProps.required,
    "data-testid": childFieldProps.testId,
    label: childFieldProps.label !== "" ? childFieldProps.label : null,
    onKeyPress: (event, data) => {
      event.key === ENTER_KEY && input.onBlur(data === null || data === void 0 ? void 0 : data.name);
    },
    onChange: (_event, data) => {
      if (childFieldProps.listen && typeof childFieldProps.listen === "function") {
        childFieldProps.listen(data === null || data === void 0 ? void 0 : data.value);
      }

      input.onChange(data === null || data === void 0 ? void 0 : data.value);
    },
    onBlur: event => input.onBlur(event),
    control: Input,
    autoFocus: childFieldProps.autoFocus || false,
    value: meta.modified ? input.value : (childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value) ? childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value : (parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name]) ? parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name] : ""
  }, omit(childFieldProps, ["value", "listen"]), {
    type: childFieldProps.inputType === "number" ? "number" : "text",
    error: (meta.error || meta.submitError) && meta.touched ? meta.error || meta.submitError : null,
    onKeyDown: // Restrict typing non-numeric characters in the "number" input fields.
    // Setting `type=number` is not sufficient to support firefox & IE.
    // Port fix from https://github.com/wso2/identity-apps/pull/2035
    childFieldProps.inputType === "number" ? event => {
      const isNumber = /^[0-9]$/i.test(event.key);
      const isAllowed = (event.key === "a" || event.key === "v" || event.key === "c" || event.key === "x") && (event.ctrlKey === true || event.metaKey === true) || event.key === "ArrowRight" || event.key == "ArrowLeft" || event.key === "Delete" || event.key === "Backspace";
      !isNumber && !isAllowed && event.preventDefault();
    } : () => {
      return;
    },
    onPaste: // Restrict pasting non-numeric characters in the "number" input fields
    // Setting `type=number` is not sufficient to support firefox & IE.
    // Port fix from https://github.com/wso2/identity-apps/pull/2035
    childFieldProps.inputType === "number" ? event => {
      const data = event.clipboardData.getData("Text");
      const isNumber = /^[0-9]+$/i.test(data);
      !isNumber && event.preventDefault();
    } : () => {
      return;
    }
  }));
};
const ScopeFieldAdapter = props => {
  const {
    childFieldProps,
    input
  } = props;
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Scopes, {
    defaultValue: childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.defaultValue,
    label: childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.label,
    value: childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value,
    required: childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.required,
    onChange: input === null || input === void 0 ? void 0 : input.onChange,
    onBlur: input === null || input === void 0 ? void 0 : input.onBlur,
    placeholder: childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.placeholder
  }));
};
const PasswordFieldAdapter = props => {
  const {
    childFieldProps,
    input,
    meta,
    parentFormProps
  } = props;
  return /*#__PURE__*/React.createElement(Password, Object.assign({
    key: childFieldProps.testId,
    "data-testid": childFieldProps.testId,
    hidePassword: "Hide password",
    label: childFieldProps.label !== "" ? childFieldProps.label : null,
    name: "newPassword",
    required: true,
    showPassword: "Show password",
    onKeyPress: (event, data) => {
      event.key === ENTER_KEY && input.onBlur(data === null || data === void 0 ? void 0 : data.name);
    },
    onChange: (event, data) => input.onChange(data === null || data === void 0 ? void 0 : data.value),
    onBlur: event => input.onBlur(event),
    error: (meta.error || meta.submitError) && meta.touched ? meta.error || meta.submitError : null,
    autoFocus: childFieldProps.autoFocus || false
  }, childFieldProps, {
    value: meta.modified ? input.value : (childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value) ? childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value : (parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name]) ? parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name] : ""
  }));
};
const CopyFieldAdapter = props => {
  const {
    childFieldProps,
    parentFormProps
  } = props;

  const {
    label
  } = childFieldProps,
        filteredChildFieldProps = __rest(childFieldProps, ["label"]);

  return /*#__PURE__*/React.createElement(Form$1.Group, {
    grouped: true
  }, label && /*#__PURE__*/React.createElement("div", {
    className: `field ${filteredChildFieldProps.required ? "required" : ""}`
  }, /*#__PURE__*/React.createElement("label", null, label)), /*#__PURE__*/React.createElement(Form$1.Field, null, /*#__PURE__*/React.createElement(CopyInputField, Object.assign({
    key: filteredChildFieldProps.testId,
    "data-testid": filteredChildFieldProps.testId,
    autoFocus: filteredChildFieldProps.autoFocus || false
  }, filteredChildFieldProps, {
    value: (filteredChildFieldProps === null || filteredChildFieldProps === void 0 ? void 0 : filteredChildFieldProps.value) ? filteredChildFieldProps === null || filteredChildFieldProps === void 0 ? void 0 : filteredChildFieldProps.value : (parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[filteredChildFieldProps === null || filteredChildFieldProps === void 0 ? void 0 : filteredChildFieldProps.name]) ? parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[filteredChildFieldProps === null || filteredChildFieldProps === void 0 ? void 0 : filteredChildFieldProps.name] : ""
  }))));
};
const TextAreaAdapter = props => {
  const {
    childFieldProps,
    input,
    meta,
    parentFormProps
  } = props;
  return /*#__PURE__*/React.createElement(Form$1.TextArea, Object.assign({
    label: childFieldProps.label !== "" ? childFieldProps.label : null,
    width: input.width,
    placeholder: input.placeholder,
    name: input.name,
    onBlur: event => input.onBlur(event),
    onChange: (_event, data) => {
      if (childFieldProps.listen && typeof childFieldProps.listen === "function") {
        childFieldProps.listen(data === null || data === void 0 ? void 0 : data.value);
      }

      input.onChange(data === null || data === void 0 ? void 0 : data.value);
    },
    autoFocus: childFieldProps.autoFocus || false,
    readOnly: input.readOnly,
    disabled: input.disabled,
    required: input.required,
    onKeyPress: (event, data) => {
      event.key === ENTER_KEY && input.onBlur(data.name);
    },
    type: "textarea"
  }, omit(childFieldProps, ["value", "listen"]), {
    value: meta.modified ? input.value : (childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value) ? childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value : (parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name]) ? parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name] : "",
    error: (meta.error || meta.submitError) && meta.touched ? meta.error || meta.submitError : null
  }));
};
/**
 * Toggle adapter.
 * @deprecated Use `CheckboxAdapter` instead.
 *
 * @param props - Props injected to the component. props - Props injected to the component.
 *
 * @returns
 */

const ToggleAdapter = props => {
  const {
    childFieldProps,
    input
  } = props;
  return /*#__PURE__*/React.createElement(Form$1.Checkbox, Object.assign({
    label: childFieldProps.label,
    name: childFieldProps.name,
    children: childFieldProps.children,
    onChange: (event, data) => {
      if (childFieldProps.listen && typeof childFieldProps.listen === "function") {
        childFieldProps.listen(data === null || data === void 0 ? void 0 : data.checked);
      }

      input.onChange(data === null || data === void 0 ? void 0 : data.checked);
    },
    control: Checkbox,
    readOnly: childFieldProps.readOnly,
    disabled: childFieldProps.disabled,
    defaultChecked: !(childFieldProps.value.length == 0),
    autoFocus: childFieldProps.autoFocus || false
  }, childFieldProps));
};
/**
 * Semantic Checkbox adapter.
 * @see {@link https://codesandbox.io/s/react-final-form-simple-example-3we74?fontsize=14&file=/index.js}
 *
 * @param props - Props injected to the component.
 *
 * @returns
 */

const CheckboxAdapter = props => {
  const {
    childFieldProps
  } = props,
        _a = props.input,
        {
    value
  } = _a,
        input = __rest(_a, ["value"]),
        rest = __rest(props, ["childFieldProps", "input"]); // unused, just don't pass it along with the ...rest


  const /* eslint-enable @typescript-eslint/no-unused-vars */
  filteredRest = __rest(rest, ["type", "meta", "hint", "children", "parentFormProps", "render", "width"]);

  return /*#__PURE__*/React.createElement(Form$1.Checkbox, Object.assign({}, input, filteredRest, {
    label: childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.label,
    name: childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name,
    onChange: (event, {
      checked
    }) => {
      if ((childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.listen) && typeof childFieldProps.listen === "function") {
        childFieldProps.listen(checked);
      }

      input.onChange({
        target: {
          checked,
          type: "checkbox",
          value
        }
      });
    }
  }));
};
/**
 * Semantic UI Radio Adapter.
 *
 * @param props - Props injected to the component.
 *
 * @returns
 */

const RadioAdapter = props => {
  const {
    childFieldProps
  } = props,
        _a = props.input,
        {
    value
  } = _a,
        input = __rest(_a, ["value"]),
        rest = __rest(props, ["childFieldProps", "input"]); // unused, just don't pass it along with the ...rest


  const /* eslint-enable @typescript-eslint/no-unused-vars */
  filteredRest = __rest(rest, ["type", "meta", "hint", "children", "parentFormProps", "render", "width"]);

  return /*#__PURE__*/React.createElement(Form$1.Radio, Object.assign({}, input, filteredRest, {
    label: childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.label,
    name: childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name,
    onChange: (event, {
      checked
    }) => {
      if ((childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.listen) && typeof childFieldProps.listen === "function") {
        childFieldProps.listen(checked);
      }

      input.onChange({
        target: {
          checked,
          type: "radio",
          value
        }
      });
    }
  }));
};
const SelectAdapter = props => {
  const {
    childFieldProps,
    input,
    meta
  } = props;
  return /*#__PURE__*/React.createElement(Form$1.Select, Object.assign({
    label: childFieldProps.label,
    name: childFieldProps.name,
    options: childFieldProps.children,
    onChange: (event, data) => {
      if (childFieldProps.listen && typeof childFieldProps.listen === "function") {
        childFieldProps.listen(data.value.toString());
      }

      input.onChange(data.value.toString());
    },
    onBlur: event => input.onBlur(event),
    autoFocus: childFieldProps.autoFocus || false,
    disabled: childFieldProps.disabled,
    required: childFieldProps.required,
    onKeyPress: (event, data) => {
      event.key === ENTER_KEY && input.onBlur(data === null || data === void 0 ? void 0 : data.name);
    },
    control: Select
  }, omit(childFieldProps, ["value", "children"]), {
    error: (meta.error || meta.submitError) && meta.touched ? meta.error || meta.submitError : null,
    value: meta.modified ? input.value : (childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value) ? childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value : ""
  }));
};
const ButtonAdapter = ({
  childFieldProps
}) => {
  if (childFieldProps.buttonType === FieldButtonTypes.BUTTON_PRIMARY) {
    return /*#__PURE__*/React.createElement(PrimaryButton, Object.assign({}, omit(childFieldProps, ["label"]), {
      disabled: childFieldProps.disabled,
      key: childFieldProps.testId,
      type: "submit"
    }), childFieldProps.label);
  } else if (childFieldProps.buttonType === FieldButtonTypes.BUTTON_CANCEL) {
    return /*#__PURE__*/React.createElement(LinkButton, Object.assign({}, omit(childFieldProps, ["label"]), {
      disabled: childFieldProps.disabled,
      key: childFieldProps.testId
    }), "Cancel");
  } else if (childFieldProps.buttonType === FieldButtonTypes.BUTTON_LINK) {
    return /*#__PURE__*/React.createElement(LinkButton, Object.assign({}, omit(childFieldProps, ["label"]), {
      disabled: childFieldProps.disabled,
      key: childFieldProps.testId
    }), childFieldProps.label);
  } else if (childFieldProps.buttonType === FieldButtonTypes.BUTTON_DANGER) {
    return /*#__PURE__*/React.createElement(DangerButton, Object.assign({}, omit(childFieldProps, ["label"]), {
      disabled: childFieldProps.disabled,
      key: childFieldProps.testId
    }), childFieldProps.label);
  } else {
    return /*#__PURE__*/React.createElement(Button$1, Object.assign({}, omit(childFieldProps, ["label"]), {
      disabled: childFieldProps.disabled,
      key: childFieldProps.testId
    }), childFieldProps.label);
  }
};
const QueryParamsAdapter = ({
  input,
  childFieldProps
}) => {
  const {
    label,
    name
  } = childFieldProps;
  if (!label) throw new Error("QueryParamsAdapter: required child prop 'label'");
  if (!name) throw new Error("QueryParamsAdapter: required child prop 'name'");
  return /*#__PURE__*/React.createElement(QueryParameters, {
    label: childFieldProps.label,
    name: childFieldProps.name,
    value: input.value,
    onChange: input.onChange
  });
};
/**
 * Color Picker Adapter implemented with `react-color`.
 *
 * @param props - Props injected to the component.
 *
 * @returns
 */

const ColorPickerAdapter = props => {
  const {
    childFieldProps
  } = props,
        _a = props.input,
        {
    value
  } = _a,
        input = __rest(_a, ["value"]),
        rest = __rest(props, ["childFieldProps", "input"]); // unused, just don't pass it along with the ...rest


  const {
    /* eslint-disable @typescript-eslint/no-unused-vars */
    editableInput,
    type,
    meta,
    hint,
    children,
    parentFormProps,
    render,
    width,
    readOnly
  } = rest,

  /* eslint-enable @typescript-eslint/no-unused-vars */
  filteredRest = __rest(rest, ["editableInput", "type", "meta", "hint", "children", "parentFormProps", "render", "width", "readOnly"]);

  return /*#__PURE__*/React.createElement(Popup, {
    on: "click",
    positionFixed: true,
    hoverable: true,
    className: "color-picker-popup",
    trigger: /*#__PURE__*/React.createElement(Form$1.Field, null, /*#__PURE__*/React.createElement("label", null, childFieldProps.label !== "" ? childFieldProps.label : null), /*#__PURE__*/React.createElement(Input, Object.assign({
      className: `color-picker-input ${readOnly ? "readonly" : ""} ${editableInput ? "editable" : ""}`,
      "aria-label": childFieldProps.ariaLabel,
      key: childFieldProps.testId,
      required: childFieldProps.required,
      "data-componentid": childFieldProps.componentId,
      onChange: (_event, data) => {
        if (!editableInput) {
          return;
        }

        if (childFieldProps.listen && typeof childFieldProps.listen === "function") {
          childFieldProps.listen(data === null || data === void 0 ? void 0 : data.value);
        }

        input.onChange(data === null || data === void 0 ? void 0 : data.value);
      },
      onBlur: event => input.onBlur(event),
      control: Input,
      autoFocus: childFieldProps.autoFocus || false,
      value: meta.modified ? value : (childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value) ? childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.value : (parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name]) ? parentFormProps === null || parentFormProps === void 0 ? void 0 : parentFormProps.values[childFieldProps === null || childFieldProps === void 0 ? void 0 : childFieldProps.name] : ""
    }, omit(childFieldProps, ["value", "listen", "label"]), {
      type: "text",
      error: (meta.error || meta.submitError) && meta.touched ? meta.error || meta.submitError : null
    }), /*#__PURE__*/React.createElement("div", {
      className: "color-swatch"
    }, /*#__PURE__*/React.createElement("div", {
      className: "color-swatch-inner",
      style: {
        background: value
      }
    }, !value && /*#__PURE__*/React.createElement(Icon, {
      name: "question"
    }))), /*#__PURE__*/React.createElement("input", {
      readOnly: !editableInput
    }))),
    disabled: readOnly,
    content: /*#__PURE__*/React.createElement(ColorPicker, Object.assign({
      show: true,
      popup: true,
      color: value,
      onChangeComplete: color => {
        // Workaround for https://github.com/casesandberg/react-color/issues/655
        // TODO: Remove once the issue is resolved on the lib.
        const a = Math.round(color.rgb.a * 255);
        const moderatedHex = color.hex + (a === 255 ? "" : Math.floor(a / 16).toString(16) + (a % 16).toString(16));

        if (childFieldProps.listen && typeof childFieldProps.listen === "function") {
          childFieldProps.listen(moderatedHex);
        }

        input.onChange(moderatedHex);
      }
    }, filteredRest))
  });
};

var classof$1 = classofRaw$1;
var global$8 = global$m;

var engineIsNode = classof$1(global$8.process) == 'process';

var getBuiltIn$2 = getBuiltIn$8;
var definePropertyModule = objectDefineProperty;
var wellKnownSymbol$4 = wellKnownSymbol$h;
var DESCRIPTORS = descriptors;

var SPECIES$1 = wellKnownSymbol$4('species');

var setSpecies$1 = function (CONSTRUCTOR_NAME) {
  var Constructor = getBuiltIn$2(CONSTRUCTOR_NAME);
  var defineProperty = definePropertyModule.f;

  if (DESCRIPTORS && Constructor && !Constructor[SPECIES$1]) {
    defineProperty(Constructor, SPECIES$1, {
      configurable: true,
      get: function () { return this; }
    });
  }
};

var isPrototypeOf$1 = objectIsPrototypeOf;

var $TypeError$4 = TypeError;

var anInstance$1 = function (it, Prototype) {
  if (isPrototypeOf$1(Prototype, it)) return it;
  throw $TypeError$4('Incorrect invocation');
};

var uncurryThis$1 = functionUncurryThis;
var aCallable$5 = aCallable$7;
var NATIVE_BIND = functionBindNative;

var bind$4 = uncurryThis$1(uncurryThis$1.bind);

// optional / simple context binding
var functionBindContext = function (fn, that) {
  aCallable$5(fn);
  return that === undefined ? fn : NATIVE_BIND ? bind$4(fn, that) : function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};

var uncurryThis = functionUncurryThis;

var arraySlice$1 = uncurryThis([].slice);

var $TypeError$3 = TypeError;

var validateArgumentsLength$1 = function (passed, required) {
  if (passed < required) throw $TypeError$3('Not enough arguments');
  return passed;
};

var userAgent$2 = engineUserAgent;

var engineIsIos = /(?:ipad|iphone|ipod).*applewebkit/i.test(userAgent$2);

var global$7 = global$m;
var apply = functionApply;
var bind$3 = functionBindContext;
var isCallable$3 = isCallable$l;
var hasOwn = hasOwnProperty_1;
var fails = fails$l;
var html = html$2;
var arraySlice = arraySlice$1;
var createElement = documentCreateElement$2;
var validateArgumentsLength = validateArgumentsLength$1;
var IS_IOS$1 = engineIsIos;
var IS_NODE$3 = engineIsNode;

var set = global$7.setImmediate;
var clear = global$7.clearImmediate;
var process$2 = global$7.process;
var Dispatch = global$7.Dispatch;
var Function$1 = global$7.Function;
var MessageChannel = global$7.MessageChannel;
var String$1 = global$7.String;
var counter = 0;
var queue$1 = {};
var ONREADYSTATECHANGE = 'onreadystatechange';
var location, defer, channel, port;

try {
  // Deno throws a ReferenceError on `location` access without `--location` flag
  location = global$7.location;
} catch (error) { /* empty */ }

var run = function (id) {
  if (hasOwn(queue$1, id)) {
    var fn = queue$1[id];
    delete queue$1[id];
    fn();
  }
};

var runner = function (id) {
  return function () {
    run(id);
  };
};

var listener = function (event) {
  run(event.data);
};

var post = function (id) {
  // old engines have not location.origin
  global$7.postMessage(String$1(id), location.protocol + '//' + location.host);
};

// Node.js 0.9+ & IE10+ has setImmediate, otherwise:
if (!set || !clear) {
  set = function setImmediate(handler) {
    validateArgumentsLength(arguments.length, 1);
    var fn = isCallable$3(handler) ? handler : Function$1(handler);
    var args = arraySlice(arguments, 1);
    queue$1[++counter] = function () {
      apply(fn, undefined, args);
    };
    defer(counter);
    return counter;
  };
  clear = function clearImmediate(id) {
    delete queue$1[id];
  };
  // Node.js 0.8-
  if (IS_NODE$3) {
    defer = function (id) {
      process$2.nextTick(runner(id));
    };
  // Sphere (JS game engine) Dispatch API
  } else if (Dispatch && Dispatch.now) {
    defer = function (id) {
      Dispatch.now(runner(id));
    };
  // Browsers with MessageChannel, includes WebWorkers
  // except iOS - https://github.com/zloirock/core-js/issues/624
  } else if (MessageChannel && !IS_IOS$1) {
    channel = new MessageChannel();
    port = channel.port2;
    channel.port1.onmessage = listener;
    defer = bind$3(port.postMessage, port);
  // Browsers with postMessage, skip WebWorkers
  // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
  } else if (
    global$7.addEventListener &&
    isCallable$3(global$7.postMessage) &&
    !global$7.importScripts &&
    location && location.protocol !== 'file:' &&
    !fails(post)
  ) {
    defer = post;
    global$7.addEventListener('message', listener, false);
  // IE8-
  } else if (ONREADYSTATECHANGE in createElement('script')) {
    defer = function (id) {
      html.appendChild(createElement('script'))[ONREADYSTATECHANGE] = function () {
        html.removeChild(this);
        run(id);
      };
    };
  // Rest old browsers
  } else {
    defer = function (id) {
      setTimeout(runner(id), 0);
    };
  }
}

var task$1 = {
  set: set,
  clear: clear
};

var userAgent$1 = engineUserAgent;
var global$6 = global$m;

var engineIsIosPebble = /ipad|iphone|ipod/i.test(userAgent$1) && global$6.Pebble !== undefined;

var userAgent = engineUserAgent;

var engineIsWebosWebkit = /web0s(?!.*chrome)/i.test(userAgent);

var global$5 = global$m;
var bind$2 = functionBindContext;
var getOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
var macrotask = task$1.set;
var IS_IOS = engineIsIos;
var IS_IOS_PEBBLE = engineIsIosPebble;
var IS_WEBOS_WEBKIT = engineIsWebosWebkit;
var IS_NODE$2 = engineIsNode;

var MutationObserver = global$5.MutationObserver || global$5.WebKitMutationObserver;
var document$2 = global$5.document;
var process$1 = global$5.process;
var Promise$1 = global$5.Promise;
// Node.js 11 shows ExperimentalWarning on getting `queueMicrotask`
var queueMicrotaskDescriptor = getOwnPropertyDescriptor(global$5, 'queueMicrotask');
var queueMicrotask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;

var flush, head, last, notify$1, toggle, node, promise, then;

// modern engines have queueMicrotask method
if (!queueMicrotask) {
  flush = function () {
    var parent, fn;
    if (IS_NODE$2 && (parent = process$1.domain)) parent.exit();
    while (head) {
      fn = head.fn;
      head = head.next;
      try {
        fn();
      } catch (error) {
        if (head) notify$1();
        else last = undefined;
        throw error;
      }
    } last = undefined;
    if (parent) parent.enter();
  };

  // browsers with MutationObserver, except iOS - https://github.com/zloirock/core-js/issues/339
  // also except WebOS Webkit https://github.com/zloirock/core-js/issues/898
  if (!IS_IOS && !IS_NODE$2 && !IS_WEBOS_WEBKIT && MutationObserver && document$2) {
    toggle = true;
    node = document$2.createTextNode('');
    new MutationObserver(flush).observe(node, { characterData: true });
    notify$1 = function () {
      node.data = toggle = !toggle;
    };
  // environments with maybe non-completely correct, but existent Promise
  } else if (!IS_IOS_PEBBLE && Promise$1 && Promise$1.resolve) {
    // Promise.resolve without an argument throws an error in LG WebOS 2
    promise = Promise$1.resolve(undefined);
    // workaround of WebKit ~ iOS Safari 10.1 bug
    promise.constructor = Promise$1;
    then = bind$2(promise.then, promise);
    notify$1 = function () {
      then(flush);
    };
  // Node.js without promises
  } else if (IS_NODE$2) {
    notify$1 = function () {
      process$1.nextTick(flush);
    };
  // for other environments - macrotask based on:
  // - setImmediate
  // - MessageChannel
  // - window.postMessage
  // - onreadystatechange
  // - setTimeout
  } else {
    // strange IE + webpack dev server bug - use .bind(global)
    macrotask = bind$2(macrotask, global$5);
    notify$1 = function () {
      macrotask(flush);
    };
  }
}

var microtask$1 = queueMicrotask || function (fn) {
  var task = { fn: fn, next: undefined };
  if (last) last.next = task;
  if (!head) {
    head = task;
    notify$1();
  } last = task;
};

var global$4 = global$m;

var hostReportErrors$1 = function (a, b) {
  var console = global$4.console;
  if (console && console.error) {
    arguments.length == 1 ? console.error(a) : console.error(a, b);
  }
};

var perform$3 = function (exec) {
  try {
    return { error: false, value: exec() };
  } catch (error) {
    return { error: true, value: error };
  }
};

var Queue$1 = function () {
  this.head = null;
  this.tail = null;
};

Queue$1.prototype = {
  add: function (item) {
    var entry = { item: item, next: null };
    if (this.head) this.tail.next = entry;
    else this.head = entry;
    this.tail = entry;
  },
  get: function () {
    var entry = this.head;
    if (entry) {
      this.head = entry.next;
      if (this.tail === entry) this.tail = null;
      return entry.item;
    }
  }
};

var queue = Queue$1;

var global$3 = global$m;

var promiseNativeConstructor = global$3.Promise;

/* global Deno -- Deno case */

var engineIsDeno = typeof Deno == 'object' && Deno && typeof Deno.version == 'object';

var IS_DENO$1 = engineIsDeno;
var IS_NODE$1 = engineIsNode;

var engineIsBrowser = !IS_DENO$1 && !IS_NODE$1
  && typeof window == 'object'
  && typeof document == 'object';

var global$2 = global$m;
var NativePromiseConstructor$3 = promiseNativeConstructor;
var isCallable$2 = isCallable$l;
var isForced = isForced_1;
var inspectSource = inspectSource$3;
var wellKnownSymbol$3 = wellKnownSymbol$h;
var IS_BROWSER = engineIsBrowser;
var IS_DENO = engineIsDeno;
var V8_VERSION = engineV8Version;

NativePromiseConstructor$3 && NativePromiseConstructor$3.prototype;
var SPECIES = wellKnownSymbol$3('species');
var SUBCLASSING = false;
var NATIVE_PROMISE_REJECTION_EVENT$1 = isCallable$2(global$2.PromiseRejectionEvent);

var FORCED_PROMISE_CONSTRUCTOR$5 = isForced('Promise', function () {
  var PROMISE_CONSTRUCTOR_SOURCE = inspectSource(NativePromiseConstructor$3);
  var GLOBAL_CORE_JS_PROMISE = PROMISE_CONSTRUCTOR_SOURCE !== String(NativePromiseConstructor$3);
  // V8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
  // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
  // We can't detect it synchronously, so just check versions
  if (!GLOBAL_CORE_JS_PROMISE && V8_VERSION === 66) return true;
  // We can't use @@species feature detection in V8 since it causes
  // deoptimization and performance degradation
  // https://github.com/zloirock/core-js/issues/679
  if (!V8_VERSION || V8_VERSION < 51 || !/native code/.test(PROMISE_CONSTRUCTOR_SOURCE)) {
    // Detect correctness of subclassing with @@species support
    var promise = new NativePromiseConstructor$3(function (resolve) { resolve(1); });
    var FakePromise = function (exec) {
      exec(function () { /* empty */ }, function () { /* empty */ });
    };
    var constructor = promise.constructor = {};
    constructor[SPECIES] = FakePromise;
    SUBCLASSING = promise.then(function () { /* empty */ }) instanceof FakePromise;
    if (!SUBCLASSING) return true;
  // Unhandled rejections tracking support, NodeJS Promise without it fails @@species test
  } return !GLOBAL_CORE_JS_PROMISE && (IS_BROWSER || IS_DENO) && !NATIVE_PROMISE_REJECTION_EVENT$1;
});

var promiseConstructorDetection = {
  CONSTRUCTOR: FORCED_PROMISE_CONSTRUCTOR$5,
  REJECTION_EVENT: NATIVE_PROMISE_REJECTION_EVENT$1,
  SUBCLASSING: SUBCLASSING
};

var newPromiseCapability$2 = {};

var aCallable$4 = aCallable$7;

var $TypeError$2 = TypeError;

var PromiseCapability = function (C) {
  var resolve, reject;
  this.promise = new C(function ($$resolve, $$reject) {
    if (resolve !== undefined || reject !== undefined) throw $TypeError$2('Bad Promise constructor');
    resolve = $$resolve;
    reject = $$reject;
  });
  this.resolve = aCallable$4(resolve);
  this.reject = aCallable$4(reject);
};

// `NewPromiseCapability` abstract operation
// https://tc39.es/ecma262/#sec-newpromisecapability
newPromiseCapability$2.f = function (C) {
  return new PromiseCapability(C);
};

var $$5 = _export;
var IS_NODE = engineIsNode;
var global$1 = global$m;
var call$6 = functionCall;
var defineBuiltIn$1 = defineBuiltIn$7;
var setPrototypeOf = objectSetPrototypeOf;
var setToStringTag = setToStringTag$3;
var setSpecies = setSpecies$1;
var aCallable$3 = aCallable$7;
var isCallable$1 = isCallable$l;
var isObject$1 = isObject$9;
var anInstance = anInstance$1;
var speciesConstructor = speciesConstructor$2;
var task = task$1.set;
var microtask = microtask$1;
var hostReportErrors = hostReportErrors$1;
var perform$2 = perform$3;
var Queue = queue;
var InternalStateModule = internalState;
var NativePromiseConstructor$2 = promiseNativeConstructor;
var PromiseConstructorDetection = promiseConstructorDetection;
var newPromiseCapabilityModule$3 = newPromiseCapability$2;

var PROMISE = 'Promise';
var FORCED_PROMISE_CONSTRUCTOR$4 = PromiseConstructorDetection.CONSTRUCTOR;
var NATIVE_PROMISE_REJECTION_EVENT = PromiseConstructorDetection.REJECTION_EVENT;
var NATIVE_PROMISE_SUBCLASSING = PromiseConstructorDetection.SUBCLASSING;
var getInternalPromiseState = InternalStateModule.getterFor(PROMISE);
var setInternalState = InternalStateModule.set;
var NativePromisePrototype$1 = NativePromiseConstructor$2 && NativePromiseConstructor$2.prototype;
var PromiseConstructor = NativePromiseConstructor$2;
var PromisePrototype = NativePromisePrototype$1;
var TypeError$1 = global$1.TypeError;
var document$1 = global$1.document;
var process = global$1.process;
var newPromiseCapability$1 = newPromiseCapabilityModule$3.f;
var newGenericPromiseCapability = newPromiseCapability$1;

var DISPATCH_EVENT = !!(document$1 && document$1.createEvent && global$1.dispatchEvent);
var UNHANDLED_REJECTION = 'unhandledrejection';
var REJECTION_HANDLED = 'rejectionhandled';
var PENDING = 0;
var FULFILLED = 1;
var REJECTED = 2;
var HANDLED = 1;
var UNHANDLED = 2;

var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;

// helpers
var isThenable = function (it) {
  var then;
  return isObject$1(it) && isCallable$1(then = it.then) ? then : false;
};

var callReaction = function (reaction, state) {
  var value = state.value;
  var ok = state.state == FULFILLED;
  var handler = ok ? reaction.ok : reaction.fail;
  var resolve = reaction.resolve;
  var reject = reaction.reject;
  var domain = reaction.domain;
  var result, then, exited;
  try {
    if (handler) {
      if (!ok) {
        if (state.rejection === UNHANDLED) onHandleUnhandled(state);
        state.rejection = HANDLED;
      }
      if (handler === true) result = value;
      else {
        if (domain) domain.enter();
        result = handler(value); // can throw
        if (domain) {
          domain.exit();
          exited = true;
        }
      }
      if (result === reaction.promise) {
        reject(TypeError$1('Promise-chain cycle'));
      } else if (then = isThenable(result)) {
        call$6(then, result, resolve, reject);
      } else resolve(result);
    } else reject(value);
  } catch (error) {
    if (domain && !exited) domain.exit();
    reject(error);
  }
};

var notify = function (state, isReject) {
  if (state.notified) return;
  state.notified = true;
  microtask(function () {
    var reactions = state.reactions;
    var reaction;
    while (reaction = reactions.get()) {
      callReaction(reaction, state);
    }
    state.notified = false;
    if (isReject && !state.rejection) onUnhandled(state);
  });
};

var dispatchEvent = function (name, promise, reason) {
  var event, handler;
  if (DISPATCH_EVENT) {
    event = document$1.createEvent('Event');
    event.promise = promise;
    event.reason = reason;
    event.initEvent(name, false, true);
    global$1.dispatchEvent(event);
  } else event = { promise: promise, reason: reason };
  if (!NATIVE_PROMISE_REJECTION_EVENT && (handler = global$1['on' + name])) handler(event);
  else if (name === UNHANDLED_REJECTION) hostReportErrors('Unhandled promise rejection', reason);
};

var onUnhandled = function (state) {
  call$6(task, global$1, function () {
    var promise = state.facade;
    var value = state.value;
    var IS_UNHANDLED = isUnhandled(state);
    var result;
    if (IS_UNHANDLED) {
      result = perform$2(function () {
        if (IS_NODE) {
          process.emit('unhandledRejection', value, promise);
        } else dispatchEvent(UNHANDLED_REJECTION, promise, value);
      });
      // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should
      state.rejection = IS_NODE || isUnhandled(state) ? UNHANDLED : HANDLED;
      if (result.error) throw result.value;
    }
  });
};

var isUnhandled = function (state) {
  return state.rejection !== HANDLED && !state.parent;
};

var onHandleUnhandled = function (state) {
  call$6(task, global$1, function () {
    var promise = state.facade;
    if (IS_NODE) {
      process.emit('rejectionHandled', promise);
    } else dispatchEvent(REJECTION_HANDLED, promise, state.value);
  });
};

var bind$1 = function (fn, state, unwrap) {
  return function (value) {
    fn(state, value, unwrap);
  };
};

var internalReject = function (state, value, unwrap) {
  if (state.done) return;
  state.done = true;
  if (unwrap) state = unwrap;
  state.value = value;
  state.state = REJECTED;
  notify(state, true);
};

var internalResolve = function (state, value, unwrap) {
  if (state.done) return;
  state.done = true;
  if (unwrap) state = unwrap;
  try {
    if (state.facade === value) throw TypeError$1("Promise can't be resolved itself");
    var then = isThenable(value);
    if (then) {
      microtask(function () {
        var wrapper = { done: false };
        try {
          call$6(then, value,
            bind$1(internalResolve, wrapper, state),
            bind$1(internalReject, wrapper, state)
          );
        } catch (error) {
          internalReject(wrapper, error, state);
        }
      });
    } else {
      state.value = value;
      state.state = FULFILLED;
      notify(state, false);
    }
  } catch (error) {
    internalReject({ done: false }, error, state);
  }
};

// constructor polyfill
if (FORCED_PROMISE_CONSTRUCTOR$4) {
  // 25.4.3.1 Promise(executor)
  PromiseConstructor = function Promise(executor) {
    anInstance(this, PromisePrototype);
    aCallable$3(executor);
    call$6(Internal, this);
    var state = getInternalPromiseState(this);
    try {
      executor(bind$1(internalResolve, state), bind$1(internalReject, state));
    } catch (error) {
      internalReject(state, error);
    }
  };

  PromisePrototype = PromiseConstructor.prototype;

  // eslint-disable-next-line no-unused-vars -- required for `.length`
  Internal = function Promise(executor) {
    setInternalState(this, {
      type: PROMISE,
      done: false,
      notified: false,
      parent: false,
      reactions: new Queue(),
      rejection: false,
      state: PENDING,
      value: undefined
    });
  };

  // `Promise.prototype.then` method
  // https://tc39.es/ecma262/#sec-promise.prototype.then
  Internal.prototype = defineBuiltIn$1(PromisePrototype, 'then', function then(onFulfilled, onRejected) {
    var state = getInternalPromiseState(this);
    var reaction = newPromiseCapability$1(speciesConstructor(this, PromiseConstructor));
    state.parent = true;
    reaction.ok = isCallable$1(onFulfilled) ? onFulfilled : true;
    reaction.fail = isCallable$1(onRejected) && onRejected;
    reaction.domain = IS_NODE ? process.domain : undefined;
    if (state.state == PENDING) state.reactions.add(reaction);
    else microtask(function () {
      callReaction(reaction, state);
    });
    return reaction.promise;
  });

  OwnPromiseCapability = function () {
    var promise = new Internal();
    var state = getInternalPromiseState(promise);
    this.promise = promise;
    this.resolve = bind$1(internalResolve, state);
    this.reject = bind$1(internalReject, state);
  };

  newPromiseCapabilityModule$3.f = newPromiseCapability$1 = function (C) {
    return C === PromiseConstructor || C === PromiseWrapper
      ? new OwnPromiseCapability(C)
      : newGenericPromiseCapability(C);
  };

  if (isCallable$1(NativePromiseConstructor$2) && NativePromisePrototype$1 !== Object.prototype) {
    nativeThen = NativePromisePrototype$1.then;

    if (!NATIVE_PROMISE_SUBCLASSING) {
      // make `Promise#then` return a polyfilled `Promise` for native promise-based APIs
      defineBuiltIn$1(NativePromisePrototype$1, 'then', function then(onFulfilled, onRejected) {
        var that = this;
        return new PromiseConstructor(function (resolve, reject) {
          call$6(nativeThen, that, resolve, reject);
        }).then(onFulfilled, onRejected);
      // https://github.com/zloirock/core-js/issues/640
      }, { unsafe: true });
    }

    // make `.constructor === Promise` work for native promise-based APIs
    try {
      delete NativePromisePrototype$1.constructor;
    } catch (error) { /* empty */ }

    // make `instanceof Promise` work for native promise-based APIs
    if (setPrototypeOf) {
      setPrototypeOf(NativePromisePrototype$1, PromisePrototype);
    }
  }
}

$$5({ global: true, constructor: true, wrap: true, forced: FORCED_PROMISE_CONSTRUCTOR$4 }, {
  Promise: PromiseConstructor
});

setToStringTag(PromiseConstructor, PROMISE, false);
setSpecies(PROMISE);

var wellKnownSymbol$2 = wellKnownSymbol$h;
var Iterators$1 = iterators;

var ITERATOR$2 = wellKnownSymbol$2('iterator');
var ArrayPrototype = Array.prototype;

// check on default Array iterator
var isArrayIteratorMethod$1 = function (it) {
  return it !== undefined && (Iterators$1.Array === it || ArrayPrototype[ITERATOR$2] === it);
};

var classof = classof$6;
var getMethod$1 = getMethod$4;
var isNullOrUndefined = isNullOrUndefined$5;
var Iterators = iterators;
var wellKnownSymbol$1 = wellKnownSymbol$h;

var ITERATOR$1 = wellKnownSymbol$1('iterator');

var getIteratorMethod$2 = function (it) {
  if (!isNullOrUndefined(it)) return getMethod$1(it, ITERATOR$1)
    || getMethod$1(it, '@@iterator')
    || Iterators[classof(it)];
};

var call$5 = functionCall;
var aCallable$2 = aCallable$7;
var anObject$3 = anObject$e;
var tryToString$1 = tryToString$4;
var getIteratorMethod$1 = getIteratorMethod$2;

var $TypeError$1 = TypeError;

var getIterator$1 = function (argument, usingIterator) {
  var iteratorMethod = arguments.length < 2 ? getIteratorMethod$1(argument) : usingIterator;
  if (aCallable$2(iteratorMethod)) return anObject$3(call$5(iteratorMethod, argument));
  throw $TypeError$1(tryToString$1(argument) + ' is not iterable');
};

var call$4 = functionCall;
var anObject$2 = anObject$e;
var getMethod = getMethod$4;

var iteratorClose$1 = function (iterator, kind, value) {
  var innerResult, innerError;
  anObject$2(iterator);
  try {
    innerResult = getMethod(iterator, 'return');
    if (!innerResult) {
      if (kind === 'throw') throw value;
      return value;
    }
    innerResult = call$4(innerResult, iterator);
  } catch (error) {
    innerError = true;
    innerResult = error;
  }
  if (kind === 'throw') throw value;
  if (innerError) throw innerResult;
  anObject$2(innerResult);
  return value;
};

var bind = functionBindContext;
var call$3 = functionCall;
var anObject$1 = anObject$e;
var tryToString = tryToString$4;
var isArrayIteratorMethod = isArrayIteratorMethod$1;
var lengthOfArrayLike = lengthOfArrayLike$3;
var isPrototypeOf = objectIsPrototypeOf;
var getIterator = getIterator$1;
var getIteratorMethod = getIteratorMethod$2;
var iteratorClose = iteratorClose$1;

var $TypeError = TypeError;

var Result = function (stopped, result) {
  this.stopped = stopped;
  this.result = result;
};

var ResultPrototype = Result.prototype;

var iterate$2 = function (iterable, unboundFunction, options) {
  var that = options && options.that;
  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
  var IS_RECORD = !!(options && options.IS_RECORD);
  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
  var INTERRUPTED = !!(options && options.INTERRUPTED);
  var fn = bind(unboundFunction, that);
  var iterator, iterFn, index, length, result, next, step;

  var stop = function (condition) {
    if (iterator) iteratorClose(iterator, 'normal', condition);
    return new Result(true, condition);
  };

  var callFn = function (value) {
    if (AS_ENTRIES) {
      anObject$1(value);
      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
    } return INTERRUPTED ? fn(value, stop) : fn(value);
  };

  if (IS_RECORD) {
    iterator = iterable.iterator;
  } else if (IS_ITERATOR) {
    iterator = iterable;
  } else {
    iterFn = getIteratorMethod(iterable);
    if (!iterFn) throw $TypeError(tryToString(iterable) + ' is not iterable');
    // optimisation for array iterators
    if (isArrayIteratorMethod(iterFn)) {
      for (index = 0, length = lengthOfArrayLike(iterable); length > index; index++) {
        result = callFn(iterable[index]);
        if (result && isPrototypeOf(ResultPrototype, result)) return result;
      } return new Result(false);
    }
    iterator = getIterator(iterable, iterFn);
  }

  next = IS_RECORD ? iterable.next : iterator.next;
  while (!(step = call$3(next, iterator)).done) {
    try {
      result = callFn(step.value);
    } catch (error) {
      iteratorClose(iterator, 'throw', error);
    }
    if (typeof result == 'object' && result && isPrototypeOf(ResultPrototype, result)) return result;
  } return new Result(false);
};

var wellKnownSymbol = wellKnownSymbol$h;

var ITERATOR = wellKnownSymbol('iterator');
var SAFE_CLOSING = false;

try {
  var called = 0;
  var iteratorWithReturn = {
    next: function () {
      return { done: !!called++ };
    },
    'return': function () {
      SAFE_CLOSING = true;
    }
  };
  iteratorWithReturn[ITERATOR] = function () {
    return this;
  };
  // eslint-disable-next-line es-x/no-array-from, no-throw-literal -- required for testing
  Array.from(iteratorWithReturn, function () { throw 2; });
} catch (error) { /* empty */ }

var checkCorrectnessOfIteration$1 = function (exec, SKIP_CLOSING) {
  if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
  var ITERATION_SUPPORT = false;
  try {
    var object = {};
    object[ITERATOR] = function () {
      return {
        next: function () {
          return { done: ITERATION_SUPPORT = true };
        }
      };
    };
    exec(object);
  } catch (error) { /* empty */ }
  return ITERATION_SUPPORT;
};

var NativePromiseConstructor$1 = promiseNativeConstructor;
var checkCorrectnessOfIteration = checkCorrectnessOfIteration$1;
var FORCED_PROMISE_CONSTRUCTOR$3 = promiseConstructorDetection.CONSTRUCTOR;

var promiseStaticsIncorrectIteration = FORCED_PROMISE_CONSTRUCTOR$3 || !checkCorrectnessOfIteration(function (iterable) {
  NativePromiseConstructor$1.all(iterable).then(undefined, function () { /* empty */ });
});

var $$4 = _export;
var call$2 = functionCall;
var aCallable$1 = aCallable$7;
var newPromiseCapabilityModule$2 = newPromiseCapability$2;
var perform$1 = perform$3;
var iterate$1 = iterate$2;
var PROMISE_STATICS_INCORRECT_ITERATION$1 = promiseStaticsIncorrectIteration;

// `Promise.all` method
// https://tc39.es/ecma262/#sec-promise.all
$$4({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION$1 }, {
  all: function all(iterable) {
    var C = this;
    var capability = newPromiseCapabilityModule$2.f(C);
    var resolve = capability.resolve;
    var reject = capability.reject;
    var result = perform$1(function () {
      var $promiseResolve = aCallable$1(C.resolve);
      var values = [];
      var counter = 0;
      var remaining = 1;
      iterate$1(iterable, function (promise) {
        var index = counter++;
        var alreadyCalled = false;
        remaining++;
        call$2($promiseResolve, C, promise).then(function (value) {
          if (alreadyCalled) return;
          alreadyCalled = true;
          values[index] = value;
          --remaining || resolve(values);
        }, reject);
      });
      --remaining || resolve(values);
    });
    if (result.error) reject(result.value);
    return capability.promise;
  }
});

var $$3 = _export;
var FORCED_PROMISE_CONSTRUCTOR$2 = promiseConstructorDetection.CONSTRUCTOR;
var NativePromiseConstructor = promiseNativeConstructor;
var getBuiltIn$1 = getBuiltIn$8;
var isCallable = isCallable$l;
var defineBuiltIn = defineBuiltIn$7;

var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;

// `Promise.prototype.catch` method
// https://tc39.es/ecma262/#sec-promise.prototype.catch
$$3({ target: 'Promise', proto: true, forced: FORCED_PROMISE_CONSTRUCTOR$2, real: true }, {
  'catch': function (onRejected) {
    return this.then(undefined, onRejected);
  }
});

// makes sure that native promise-based APIs `Promise#catch` properly works with patched `Promise#then`
if (isCallable(NativePromiseConstructor)) {
  var method = getBuiltIn$1('Promise').prototype['catch'];
  if (NativePromisePrototype['catch'] !== method) {
    defineBuiltIn(NativePromisePrototype, 'catch', method, { unsafe: true });
  }
}

var $$2 = _export;
var call$1 = functionCall;
var aCallable = aCallable$7;
var newPromiseCapabilityModule$1 = newPromiseCapability$2;
var perform = perform$3;
var iterate = iterate$2;
var PROMISE_STATICS_INCORRECT_ITERATION = promiseStaticsIncorrectIteration;

// `Promise.race` method
// https://tc39.es/ecma262/#sec-promise.race
$$2({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION }, {
  race: function race(iterable) {
    var C = this;
    var capability = newPromiseCapabilityModule$1.f(C);
    var reject = capability.reject;
    var result = perform(function () {
      var $promiseResolve = aCallable(C.resolve);
      iterate(iterable, function (promise) {
        call$1($promiseResolve, C, promise).then(capability.resolve, reject);
      });
    });
    if (result.error) reject(result.value);
    return capability.promise;
  }
});

var $$1 = _export;
var call = functionCall;
var newPromiseCapabilityModule = newPromiseCapability$2;
var FORCED_PROMISE_CONSTRUCTOR$1 = promiseConstructorDetection.CONSTRUCTOR;

// `Promise.reject` method
// https://tc39.es/ecma262/#sec-promise.reject
$$1({ target: 'Promise', stat: true, forced: FORCED_PROMISE_CONSTRUCTOR$1 }, {
  reject: function reject(r) {
    var capability = newPromiseCapabilityModule.f(this);
    call(capability.reject, undefined, r);
    return capability.promise;
  }
});

var anObject = anObject$e;
var isObject = isObject$9;
var newPromiseCapability = newPromiseCapability$2;

var promiseResolve$1 = function (C, x) {
  anObject(C);
  if (isObject(x) && x.constructor === C) return x;
  var promiseCapability = newPromiseCapability.f(C);
  var resolve = promiseCapability.resolve;
  resolve(x);
  return promiseCapability.promise;
};

var $ = _export;
var getBuiltIn = getBuiltIn$8;
var FORCED_PROMISE_CONSTRUCTOR = promiseConstructorDetection.CONSTRUCTOR;
var promiseResolve = promiseResolve$1;

getBuiltIn('Promise');

// `Promise.resolve` method
// https://tc39.es/ecma262/#sec-promise.resolve
$({ target: 'Promise', stat: true, forced: FORCED_PROMISE_CONSTRUCTOR }, {
  resolve: function resolve(x) {
    return promiseResolve(this, x);
  }
});

/**
 * Implementation of the Button Field component.
 *
 * @param props - Props injected to the component.
 * @returns Functional component.
 */

const FieldButton = props => {
  const {
    form,
    ["data-testid"]: testId
  } = props;
  return /*#__PURE__*/React.createElement(Field$1, Object.assign({
    form: form,
    key: testId,
    name: props.name,
    component: ButtonAdapter
  }, props));
};
/**
 * Default props for the component.
 */

FieldButton.defaultProps = {
  type: FieldButtonTypes.BUTTON_DEFAULT
};

/**
 * Implementation of the Checkbox Field component.
 *
 * @param props - Props injected to the component.
 *
 * @returns
 */

const FieldCheckbox = props => {
  const {
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["data-testid"]);

  const resolveInputFieldMessage = () => {
    switch (props.message.type) {
      case "info":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: props.message.type,
          content: props.message.content,
          header: props.message.header
        });

      case "warning":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: props.message.type,
          content: props.message.content,
          header: props.message.header
        });

      case "error":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: props.message.type,
          content: props.message.content,
          header: props.message.header
        });
    }
  };

  return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(Field$1, Object.assign({
    key: testId,
    type: "checkbox",
    name: props.name,
    component: CheckboxAdapter,
    "data-testid": testId
  }, rest)), props.hint && /*#__PURE__*/React.createElement(Hint, {
    compact: true
  }, props.hint), props.message && resolveInputFieldMessage());
};
/**
 * Default props for the component.
 */

FieldCheckbox.defaultProps = {
  "data-testid": "checkbox-field"
};

/**
 * Implementation of the Checkbox Field component.
 * @deprecated Use `Field.Checkbox` instead.
 *
 * @param props - Props injected to the component.
 *
 * @returns
 */

const FieldCheckboxLegacy = props => {
  var _a, _b;

  const {
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["data-testid"]);

  const [checkboxValue, setCheckboxValue] = useState(!(((_b = (_a = props === null || props === void 0 ? void 0 : props.childFieldProps) === null || _a === void 0 ? void 0 : _a.value) === null || _b === void 0 ? void 0 : _b.length) == 0));

  const resolveInputFieldMessage = () => {
    switch (props.message.type) {
      case "info":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: props.message.type,
          content: props.message.content,
          header: props.message.header
        });
    }
  };

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Field$1, Object.assign({
    key: testId,
    parse: value => {
      var _a, _b;

      return value === undefined ? setCheckboxValue(!(((_b = (_a = props === null || props === void 0 ? void 0 : props.childFieldProps) === null || _a === void 0 ? void 0 : _a.value) === null || _b === void 0 ? void 0 : _b.length) == 0)) : setCheckboxValue(value);
    },
    type: "checkbox",
    name: props.name,
    defaultValue: checkboxValue,
    component: ToggleAdapter
  }, rest)), props.hint && /*#__PURE__*/React.createElement(Hint, {
    compact: true
  }, props.hint), props.message && resolveInputFieldMessage());
};

/**
 * Implementation of the Color Picker component.
 *
 * @param props - Props injected to the component.
 *
 * @returns
 */

const FieldColorPicker = props => {
  const {
    hint,
    message,
    name,
    ["data-testid"]: testId
  } = props;
  /**
   * Resolves the input message.
   *
   * @returns
   */

  const resolveInputFieldMessage = () => {
    switch (message.type) {
      case "info":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: message.type,
          content: message.content,
          header: message.header
        });

      case "warning":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: message.type,
          content: message.content,
          header: message.header
        });

      case "error":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: message.type,
          content: message.content,
          header: message.header
        });
    }
  };

  return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(Field$1, Object.assign({
    key: testId,
    type: "text",
    name: name,
    parse: value => value,
    component: ColorPickerAdapter
  }, props)), hint && /*#__PURE__*/React.createElement(Hint, {
    compact: true
  }, hint), message && resolveInputFieldMessage());
};
/**
 * Default props for the component.
 */

FieldColorPicker.defaultProps = {
  "data-componentid": "color-picker-field",
  editableInput: false
};

/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Class containing Form Field constants.
 */
class FieldConstants {
  /**
   * Private constructor to avoid object instantiation from outside
   * the class.
   *
   */

  /* eslint-disable @typescript-eslint/no-empty-function */
  constructor() {}

}
/**
 * Form field validation errors.
 */

FieldConstants.INVALID_EMAIL_ERROR = "Please enter a valid email";
FieldConstants.INVALID_URL_ERROR = "Please enter a valid URL";
FieldConstants.INVALID_NAME_ERROR = "Please enter a valid name";
FieldConstants.INVALID_RESOURCE_ERROR = "Please enter a valid input";
FieldConstants.INVALID_SECRET_NAME_ERROR = "Please enter a valid secret name. " + "You can only use alphanumeric characters, underscores (_), dashes (-)";
FieldConstants.INVALID_CLIENT_ID_ERROR = "Please enter a valid Client ID";
FieldConstants.INVALID_DESCRIPTION_ERROR = "Please enter a valid description";
FieldConstants.INVALID_PHONE_NUMBER_ERROR = "Please enter a valid phone number";
FieldConstants.INVALID_SCOPES_ERROR = "Please include 'openid' scope";
FieldConstants.FIELD_REQUIRED_ERROR = "This field cannot be empty";

/**
 * Util method to apply default validations to the fields.
 *
 * @param field - string - HTML input type of the field.
 * @param fieldType - string - Usage type of the field
 * @param value - value of the field.
 */

const getDefaultValidation = (field, fieldType, value) => {
  if (field === "text") {
    switch (fieldType) {
      case "identifier":
        if (!FormValidation.identifier(value)) {
          return FieldConstants.INVALID_NAME_ERROR;
        }

        break;

      case "resource_name":
        if (!FormValidation.isValidResourceName(value)) {
          return FieldConstants.INVALID_RESOURCE_ERROR;
        }

        break;

      case "client_id":
        if (!FormValidation.isValidClientId(value)) {
          return FieldConstants.INVALID_CLIENT_ID_ERROR;
        }

        break;

      case "description":
        if (!FormValidation.isValidDescription(value)) {
          return FieldConstants.INVALID_DESCRIPTION_ERROR;
        }

        break;

      case "email":
        if (!FormValidation.email(value)) {
          return FieldConstants.INVALID_EMAIL_ERROR;
        }

        break;

      case "phoneNumber":
        if (!FormValidation.mobileNumber(value)) {
          return FieldConstants.INVALID_PHONE_NUMBER_ERROR;
        }

        break;

      case "url":
        if (!FormValidation.url(value)) {
          return FieldConstants.INVALID_URL_ERROR;
        }

        break;

      case "scopes":
        if (!FormValidation.scopes(value)) {
          return FieldConstants.INVALID_SCOPES_ERROR;
        }

        break;
    }
  }
};
/**
 * @returns Corresponding default validation.
 */

const getValidation = (value, allValues, meta, field, required, fieldType, validation) => {
  if (!meta.modified) {
    return;
  }

  if (meta.modified && required && !value) {
    return FieldConstants.FIELD_REQUIRED_ERROR;
  }

  if (!value) {
    return;
  }

  if (validation instanceof Promise) {
    validation(value, allValues).then(message => {
      return message;
    });
  }

  if (typeof validation === "function") {
    return validation(value, allValues);
  }

  return getDefaultValidation(field, fieldType, value);
};

/**
 * Implementation of the Dropdown Field component.
 *
 * @param props - Props injected to the component.
 */

const FieldDropdown = props => {
  const {
    ["data-testid"]: testId,
    _initialValue
  } = props,
        rest = __rest(props, ["data-testid", "_initialValue"]);

  const resolveInputFieldMessage = () => {
    switch (props.message.type) {
      case "info":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: props.message.type,
          content: props.message.content,
          header: props.message.header
        });

      case "warning":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: props.message.type,
          content: props.message.content,
          header: props.message.header
        });

      case "error":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: props.message.type,
          content: props.message.content,
          header: props.message.header
        });
    }
  };

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Field$1, Object.assign({
    key: testId,
    type: "dropdown",
    name: props.name,
    parse: value => value,
    component: SelectAdapter,
    validate: (value, allValues, meta) => getValidation(value, allValues, meta, props.type, props.required)
  }, rest)), props.hint && typeof props.hint === "string" ? /*#__PURE__*/React.createElement(Hint, {
    compact: true
  }, props.hint) : /*#__PURE__*/React.createElement(React.Fragment, null, props.hint), props.message && resolveInputFieldMessage());
};

/**
 * Implementation of the Input Field component.
 * @param props - Props injected to the component.
 */

const FieldInput = props => {
  const {
    inputType,
    validation,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["inputType", "validation", "data-testid"]);

  const inputFieldGenerator = () => {
    if (inputType == FieldInputTypes.INPUT_PASSWORD) {
      return /*#__PURE__*/React.createElement(Field$1, Object.assign({
        key: testId,
        type: "password",
        name: props.name,
        parse: value => value,
        component: PasswordFieldAdapter,
        validate: (value, allValues, meta) => getValidation(value, allValues, meta, "password", props.required, inputType, validation)
      }, rest));
    } else if (inputType == FieldInputTypes.INPUT_COPY) {
      return /*#__PURE__*/React.createElement(Field$1, Object.assign({
        key: testId,
        type: "text",
        name: props.name,
        parse: value => value,
        component: CopyFieldAdapter,
        validate: (value, allValues, meta) => getValidation(value, allValues, meta, "text", props.required, inputType, validation)
      }, rest));
    } else if (inputType == FieldInputTypes.INPUT_NUMBER) {
      return /*#__PURE__*/React.createElement(Field$1, Object.assign({
        key: testId,
        type: "number",
        name: props.name,
        parse: value => value,
        component: TextFieldAdapter,
        validate: (value, allValues, meta) => getValidation(value, allValues, meta, "text", props.required, inputType, validation)
      }, rest));
    } else {
      return /*#__PURE__*/React.createElement(Field$1, Object.assign({
        key: testId,
        type: "text",
        name: props.name,
        parse: value => value,
        component: TextFieldAdapter,
        validate: (value, allValues, meta) => getValidation(value, allValues, meta, "text", props.required, inputType, validation)
      }, props));
    }
  };

  const resolveInputFieldMessage = () => {
    switch (props.message.type) {
      case "info":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: props.message.type,
          content: props.message.content,
          header: props.message.header
        });

      case "warning":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: props.message.type,
          content: props.message.content,
          header: props.message.header
        });

      case "error":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: props.message.type,
          content: props.message.content,
          header: props.message.header
        });
    }
  };

  return /*#__PURE__*/React.createElement(React.Fragment, null, inputFieldGenerator(), props.hint && /*#__PURE__*/React.createElement(Hint, {
    compact: true
  }, props.hint), props.message && resolveInputFieldMessage());
};
/**
 * Default props for the component.
 */

FieldInput.defaultProps = {
  inputType: "default",
  maxLength: 50,
  minLength: 3,
  type: FieldInputTypes.INPUT_DEFAULT,
  width: 16
};

/**
 * @param props - Props injected to the component.
 *
 * @returns
 */

const FieldQueryParams = props => {
  const {
    ["data-testid"]: testId,
    value
  } = props,
        rest = __rest(props, ["data-testid", "value"]);

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Field$1, Object.assign({
    key: testId,
    name: props.name,
    value: value !== null && value !== void 0 ? value : "",
    component: QueryParamsAdapter
  }, rest)), props.hint && /*#__PURE__*/React.createElement(Hint, {
    compact: true
  }, props.hint));
};

/**
 * Implementation of the Radio Field component.
 *
 * @param props - Props injected to the component.
 *
 * @returns
 */

const FieldRadio = props => {
  const {
    ["data-componentid"]: componentId,
    hint,
    message
  } = props,
        rest = __rest(props, ["data-componentid", "hint", "message"]);

  const resolveInputFieldMessage = () => {
    const {
      type,
      content,
      header
    } = message;

    switch (type) {
      case "info":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: type,
          content: content,
          header: header
        });

      case "warning":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: type,
          content: content,
          header: header
        });

      case "error":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: type,
          content: content,
          header: header
        });
    }
  };

  return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(Field$1, Object.assign({
    key: componentId,
    type: "radio",
    component: RadioAdapter,
    "data-componentid": componentId
  }, rest)), hint && /*#__PURE__*/React.createElement(Hint, {
    compact: true
  }, hint), message && resolveInputFieldMessage());
};
/**
 * Default props for the component.
 */

FieldRadio.defaultProps = {
  "data-testid": "radio-field"
};

/**
 * Implementation of the Scopes Field component.
 * @param props- FieldInputPropsInterface
 */

const FieldScopes = props => {
  const {
    defaultValue,
    inputType,
    hint,
    message,
    validation,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["defaultValue", "inputType", "hint", "message", "validation", "data-testid"]);

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Field$1, Object.assign({
    key: testId,
    type: "text",
    name: props.name,
    parse: value => value,
    component: ScopeFieldAdapter,
    validate: (value, meta) => getValidation(value, null, meta, "text", props.required, inputType, validation),
    defaultValue: defaultValue,
    hint: hint,
    message: message
  }, rest)), props.hint && /*#__PURE__*/React.createElement(Hint, {
    compact: true
  }, props.hint));
};
/**
 * Default props for the component.
 */

FieldScopes.defaultProps = {
  defaultValue: "openid",
  inputType: "default",
  maxLength: 50,
  minLength: 3,
  type: FieldInputTypes.INPUT_DEFAULT,
  width: 16
};

/**
 * Implementation of the Textarea Field component.
 * @param props - Props injected to the component.
 */

const FieldTextarea = props => {
  const {
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["data-testid"]);

  const resolveInputFieldMessage = () => {
    switch (props.message.type) {
      case "info":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: props.message.type,
          content: props.message.content,
          header: props.message.header
        });

      case "warning":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: props.message.type,
          content: props.message.content,
          header: props.message.header
        });

      case "error":
        return /*#__PURE__*/React.createElement(Message$1, {
          type: props.message.type,
          content: props.message.content,
          header: props.message.header
        });
    }
  };

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Field$1, Object.assign({
    key: testId,
    type: "textarea",
    name: props.name,
    parse: value => value,
    component: TextAreaAdapter,
    validate: (value, allValues, meta) => getValidation(value, allValues, meta, "textarea", props.required, props.type, props.validation)
  }, rest)), props.hint && /*#__PURE__*/React.createElement(Hint, {
    compact: true
  }, props.hint), props.message && resolveInputFieldMessage());
};

/**
 * Implementation of the Form Field component.
 * @param props - Props injected to the component.
 * @returns Field component.
 */

const Field = props => {
  const {
    children,
    className,
    style
  } = props;
  const classes = classNames("fields", className);
  const childNodes = React.Children.toArray(children);
  return /*#__PURE__*/React.createElement("div", {
    className: classes,
    style: style
  }, childNodes.map(child => {
    if (!child) {
      return null;
    }

    const childProps = Object.assign({}, child.props);
    return /*#__PURE__*/cloneElement(child, childProps);
  }));
};
Field.Input = FieldInput;
Field.Button = FieldButton;
Field.Textarea = FieldTextarea;
Field.CheckboxLegacy = FieldCheckboxLegacy;
Field.Checkbox = FieldCheckbox;
Field.Dropdown = FieldDropdown;
Field.QueryParams = FieldQueryParams;
Field.ColorPicker = FieldColorPicker;
Field.Radio = FieldRadio;
Field.Scopes = FieldScopes;

/**
 * Implementation of the Form component.
 * @param props - Props injected to the component.
 */

const Form = /*#__PURE__*/forwardRef((props, ref) => {
  const {
    id,
    noValidate,
    triggerSubmit
  } = props,
        other = __rest(props, ["id", "noValidate", "triggerSubmit"]);

  const {
    children,
    onSubmit,
    uncontrolledForm
  } = other,
        rest = __rest(other, ["children", "onSubmit", "uncontrolledForm"]);

  const formRef = useRef(null);
  const childNodes = React.Children.toArray(children);

  const skipFinalTypes = type => {
    const typeToBeSkipped = ["FieldDropdown"];
    return typeToBeSkipped.some(skipType => {
      return type === skipType;
    });
  };

  useImperativeHandle(ref, () => ({
    triggerSubmit: () => {
      var _a;
      /**
       * What is this?
       *
       * Below this line we have the logic to trigger the native
       * form's submit event. Currently we don't maintain UI for
       * submit button, neither previous buttons.
       *
       * The parent wizard is only responsible for changing it's wizard
       * pages based on the current index. To facilitate external
       * submit handling we expose a imperative handler that uses
       * a react ref to trigger the onSubmit manually. This is
       * because, inherently react-final-form uses its form submission
       * to properly keep track of the redux state.
       *
       * We should be able to synthetically tell react final form
       * that a page has been changed and please trigger {@link handleSubmit}
       * to make sure values are saved.
       *
       * @see {@link onSubmit}
       * @see {@link https://final-form.org/docs/react-final-form/faq}
       */


      if (formRef) {
        const submission = new Event("submit", {
          bubbles: true,
          cancelable: true
        });
        (_a = formRef.current) === null || _a === void 0 ? void 0 : _a.dispatchEvent(submission);
      }
    }
  }));

  const addPropsToChild = (childNodes, formRenderProps) => {
    return childNodes.map(child => {
      var _a, _b, _c, _d; // Safety pre-conditions


      if (!child) return null;
      if (!child.type) return child;
      const {
        form,
        handleSubmit,
        pristine,
        submitting,
        values,
        initialValues
      } = formRenderProps;
      const parentFormProps = {
        form,
        handleSubmit,
        initialValues,
        pristine,
        submitting,
        values
      };
      const childFieldProps = child.props;
      const childProps = {
        childFieldProps,
        parentFormProps
      }; // Check whether children of this element is valid
      // and is type array.

      const hasChildrenAndIsValid = Array.isArray((_a = child.props) === null || _a === void 0 ? void 0 : _a.children) && ((_b = child.props) === null || _b === void 0 ? void 0 : _b.children.every(React.isValidElement)) && child.props.children.length > 0; // If the react element has only 1 child, the react top level
      // API parses the children as a single object instead of type
      // array.

      const hasOnlyOneChild = typeof ((_c = child.props) === null || _c === void 0 ? void 0 : _c.children) === "object";

      if (uncontrolledForm) {
        if ((hasChildrenAndIsValid || hasOnlyOneChild) && !skipFinalTypes(child.type.name)) {
          return /*#__PURE__*/React.createElement(child.type, Object.assign(Object.assign({}, child.props), {
            children: addPropsToChild(React.Children.toArray((_d = child.props) === null || _d === void 0 ? void 0 : _d.children), formRenderProps)
          }));
        }
      }

      return /*#__PURE__*/cloneElement(child, childProps);
    });
  };

  const renderComponents = (childNodes, formRenderProps) => {
    const modifiedChildNodes = addPropsToChild(childNodes, formRenderProps);
    return modifiedChildNodes.map((child, index) => {
      var _a, _b, _c;

      if (!child) {
        return null;
      }

      if (child.props.childFieldProps && ((_b = (_a = child.props) === null || _a === void 0 ? void 0 : _a.childFieldProps) === null || _b === void 0 ? void 0 : _b.hidden)) {
        return null;
      }

      return /*#__PURE__*/React.createElement(Grid.Row, {
        key: index
      }, /*#__PURE__*/React.createElement(Grid.Column, {
        width: (_c = child.props.childFieldProps) === null || _c === void 0 ? void 0 : _c.width
      }, child));
    });
  };

  return /*#__PURE__*/React.createElement(Form$2, Object.assign({
    onSubmit: (values, form) => onSubmit(values, form),
    keepDirtyOnReinitialize: true,
    render: formRenderProps => {
      const {
        handleSubmit
      } = formRenderProps;

      if (triggerSubmit && typeof triggerSubmit === "function") {
        triggerSubmit(handleSubmit);
      }

      return /*#__PURE__*/React.createElement("form", {
        id: id,
        noValidate: noValidate,
        onSubmit: handleSubmit,
        ref: formRef
      }, /*#__PURE__*/React.createElement(Form$1, {
        noValidate: noValidate
      }, /*#__PURE__*/React.createElement(Grid, {
        className: "form-container with-max-width"
      }, renderComponents(childNodes, formRenderProps))));
    }
  }, rest));
});
/**
 * Default props for the component.
 */

Form.defaultProps = {
  noValidate: true
};

/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Implementation of the WizardPage component.
 * @param props - Props injected to the component.
 */

const WizardPage = props => {
  const {
    children
  } = props;
  return /*#__PURE__*/React.createElement(React.Fragment, null, children);
};

/**
 * Implementation of wizard component.
 *
 * @param props - Wizard form based on react froms
 * @returns Functional component.
 */

const Wizard = props => {
  const {
    id,
    children,
    onSubmit,
    triggerPrevious,
    changePage,
    setTotalPage
  } = props,
        rest = __rest(props, ["id", "children", "onSubmit", "triggerPrevious", "changePage", "setTotalPage"]);

  const [page, setPage] = useState(0);
  const [values, setValues] = useState({});
  /**
   * Loads the identity provider authenticators on initial component load.
   */

  useEffect(() => {
    if (setTotalPage) {
      setTotalPage(React.Children.count(children));
    }
  }, []);

  const handlNext = values => {
    setPage(Math.min(page + 1, children.length - 1));
    setValues(values);
    changePage(Math.min(page + 1, children.length - 1));
  };

  const handlPrevious = () => {
    setPage(Math.max(page - 1, 0));
    changePage(Math.max(page - 1, 0));
  };

  const handleSubmit = (values, form) => {
    const isLastPage = page === React.Children.count(children) - 1;

    if (isLastPage) {
      return onSubmit(values, form);
    } else {
      handlNext(values);
    }
  };

  if (triggerPrevious && typeof triggerPrevious === "function") {
    triggerPrevious(handlPrevious);
  }

  const validate = values => {
    const activePage = React.Children.toArray(children)[page];
    return activePage.props.validate ? activePage.props.validate(values) : {};
  };

  const activePage = React.Children.toArray(children)[page];
  return /*#__PURE__*/React.createElement(Form, Object.assign({
    id: id,
    initialValues: values,
    validate: validate,
    onSubmit: handleSubmit,
    keepDirtyOnReinitialize: true,
    uncontrolledForm: true
  }, rest), activePage);
};
Wizard.Page = WizardPage;

/**
 * Wizard Component.
 * TODO: If working on a refactor, consider exporting one wizard type.
 *
 * @param props - Props injected to the component.
 * @param ref - Component ref.
 * @returns Functional component.
 */

const ImperativeWizard = (props, ref) => {
  const {
    id,
    children,
    onSubmit,
    setTotalPages,
    pageChanged,
    initialValues,
    uncontrolledForm
  } = props,
        rest = __rest(props, ["id", "children", "onSubmit", "setTotalPages", "pageChanged", "initialValues", "uncontrolledForm"]); // Form reference to trigger the form submit externally
  // on each page submission.


  const formRef = useRef(null);
  const absoluteChildCount = React.Children.count(children);
  const lastPageIndex = absoluteChildCount - 1;
  const [currentPageIndex, setCurrentPageIndex] = useState(0);
  const [values, setValues] = useState();
  useImperativeHandle(ref, () => ({
    getCurrentPageNumber: getCurrentPageNumber,
    getValues: getValues,
    gotoNextPage: gotoNextPage,
    gotoPreviousPage: gotoPreviousPage
  }));
  useEffect(() => {
    if (pageChanged) pageChanged(currentPageIndex);
  });
  useEffect(() => {
    if (setTotalPages) {
      setTotalPages(absoluteChildCount);
    }
  }, []);

  const getValues = () => {
    return values;
  };

  const gotoNextPage = () => {
    const nextIndex = Math.min(currentPageIndex + 1, lastPageIndex);
    setCurrentPageIndex(nextIndex);

    if (formRef) {
      formRef.current.triggerSubmit();
    }
  };

  const gotoPreviousPage = () => {
    setCurrentPageIndex(Math.max(currentPageIndex - 1, 0));
  };

  const getCurrentPageNumber = () => currentPageIndex;

  const handleSubmit = (values, form) => {
    if (currentPageIndex === lastPageIndex) {
      return onSubmit(values, form);
    } else {
      setValues(values);
    }
  };

  const validate = values => {
    var _a;

    const activePage = React.Children.toArray(children)[currentPageIndex];

    if ((_a = activePage === null || activePage === void 0 ? void 0 : activePage.props) === null || _a === void 0 ? void 0 : _a.validate) {
      return activePage.props.validate(values);
    }

    return {};
  };

  return /*#__PURE__*/React.createElement(Form, Object.assign({
    id: id,
    ref: formRef,
    initialValues: initialValues,
    validate: validate,
    onSubmit: handleSubmit,
    keepDirtyOnReinitialize: true,
    uncontrolledForm: uncontrolledForm !== null && uncontrolledForm !== void 0 ? uncontrolledForm : false
  }, rest), React.Children.toArray(children)[currentPageIndex]);
};

ImperativeWizard.Page = WizardPage;
const Wizard2 = /*#__PURE__*/forwardRef(ImperativeWizard);

export { ButtonAdapter, CheckboxAdapter, ColorPickerAdapter, CopyFieldAdapter, Field, FieldButton, FieldButtonTypes, FieldCheckbox, FieldCheckboxLegacy, FieldColorPicker, FieldConstants, FieldDropdown, FieldInput, FieldInputTypes, FieldQueryParams, FieldRadio, FieldTextarea, Form, PasswordFieldAdapter, QueryParamsAdapter, RadioAdapter, ScopeFieldAdapter, SelectAdapter, TextAreaAdapter, TextFieldAdapter, ToggleAdapter, Wizard, Wizard2, WizardPage, getDefaultValidation, getValidation, isButtonField, isCheckBoxField, isCustomField, isDivider, isDropdownField, isInputField, isPasswordField, isQueryParamsField, isRadioField, isResetField, isSubmitField, isTextField, isToggleField };
