/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Enum for common authenticate action types.
 *
 * @readonly
 * @enum {string}
 */
export var CommonAuthenticateActionTypes;
(function (CommonAuthenticateActionTypes) {
    /**
     * Redux action type to handle the reset authentication requests.
     *
     * @type {string}
     */
    CommonAuthenticateActionTypes["RESET_AUTHENTICATION"] = "RESET_AUTHENTICATION";
    /**
     * Redux action type to handle the sign in requests.
     *
     * @type {string}
     */
    CommonAuthenticateActionTypes["SET_SIGN_IN"] = "SET_SIGN_IN";
    /**
     * Redux action type to handle the sign out requests.
     *
     * @type {string}
     */
    CommonAuthenticateActionTypes["SET_SIGN_OUT"] = "SET_SIGN_OUT";
    /**
     * Redux action type to set initialized.
     *
     * @type {string}
     */
    CommonAuthenticateActionTypes["SET_INITIALIZED"] = "SET_INITIALIZED";
    /**
     * Redux action type to set default tenant.
     *
     * @type {string}
     */
    CommonAuthenticateActionTypes["SET_DEFAULT_TENANT"] = "SET_DEFAULT_TENANT";
    /**
     * Redux action type to set tenants.
     *
     * @type {string}
     */
    CommonAuthenticateActionTypes["SET_TENANTS"] = "SET_TENANTS";
})(CommonAuthenticateActionTypes || (CommonAuthenticateActionTypes = {}));
//# sourceMappingURL=authenticate.js.map