'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var semanticUiReact = require('semantic-ui-react');
var classNames = require('classnames');
var filter = require('lodash-es/filter');
var isEmpty = require('lodash-es/isEmpty');
var isEqual = require('lodash-es/isEqual');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
var classNames__default = /*#__PURE__*/_interopDefaultLegacy(classNames);
var filter__default = /*#__PURE__*/_interopDefaultLegacy(filter);
var isEmpty__default = /*#__PURE__*/_interopDefaultLegacy(isEmpty);
var isEqual__default = /*#__PURE__*/_interopDefaultLegacy(isEqual);

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

var fails$k = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};

var fails$j = fails$k;

var functionBindNative = !fails$j(function () {
  // eslint-disable-next-line es-x/no-function-prototype-bind -- safe
  var test = (function () { /* empty */ }).bind();
  // eslint-disable-next-line no-prototype-builtins -- safe
  return typeof test != 'function' || test.hasOwnProperty('prototype');
});

var NATIVE_BIND$2 = functionBindNative;

var FunctionPrototype$2 = Function.prototype;
var bind = FunctionPrototype$2.bind;
var call$b = FunctionPrototype$2.call;
var uncurryThis$i = NATIVE_BIND$2 && bind.bind(call$b, call$b);

var functionUncurryThis = NATIVE_BIND$2 ? function (fn) {
  return fn && uncurryThis$i(fn);
} : function (fn) {
  return fn && function () {
    return call$b.apply(fn, arguments);
  };
};

var uncurryThis$h = functionUncurryThis;

var toString$7 = uncurryThis$h({}.toString);
var stringSlice$3 = uncurryThis$h(''.slice);

var classofRaw$1 = function (it) {
  return stringSlice$3(toString$7(it), 8, -1);
};

var uncurryThis$g = functionUncurryThis;
var fails$i = fails$k;
var classof$5 = classofRaw$1;

var $Object$4 = Object;
var split = uncurryThis$g(''.split);

// fallback for non-array-like ES3 and non-enumerable old V8 strings
var indexedObject = fails$i(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins -- safe
  return !$Object$4('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof$5(it) == 'String' ? split(it, '') : $Object$4(it);
} : $Object$4;

// we can't use just `it == null` since of `document.all` special case
// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot-aec
var isNullOrUndefined$4 = function (it) {
  return it === null || it === undefined;
};

var isNullOrUndefined$3 = isNullOrUndefined$4;

var $TypeError$9 = TypeError;

// `RequireObjectCoercible` abstract operation
// https://tc39.es/ecma262/#sec-requireobjectcoercible
var requireObjectCoercible$6 = function (it) {
  if (isNullOrUndefined$3(it)) throw $TypeError$9("Can't call method on " + it);
  return it;
};

// toObject with fallback for non-array-like ES3 strings
var IndexedObject$1 = indexedObject;
var requireObjectCoercible$5 = requireObjectCoercible$6;

var toIndexedObject$5 = function (it) {
  return IndexedObject$1(requireObjectCoercible$5(it));
};

var check = function (it) {
  return it && it.Math == Math && it;
};

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global$e =
  // eslint-disable-next-line es-x/no-global-this -- safe
  check(typeof globalThis == 'object' && globalThis) ||
  check(typeof window == 'object' && window) ||
  // eslint-disable-next-line no-restricted-globals -- safe
  check(typeof self == 'object' && self) ||
  check(typeof commonjsGlobal == 'object' && commonjsGlobal) ||
  // eslint-disable-next-line no-new-func -- fallback
  (function () { return this; })() || Function('return this')();

var shared$4 = {exports: {}};

var global$d = global$e;

// eslint-disable-next-line es-x/no-object-defineproperty -- safe
var defineProperty$5 = Object.defineProperty;

var defineGlobalProperty$3 = function (key, value) {
  try {
    defineProperty$5(global$d, key, { value: value, configurable: true, writable: true });
  } catch (error) {
    global$d[key] = value;
  } return value;
};

var global$c = global$e;
var defineGlobalProperty$2 = defineGlobalProperty$3;

var SHARED = '__core-js_shared__';
var store$3 = global$c[SHARED] || defineGlobalProperty$2(SHARED, {});

var sharedStore = store$3;

var store$2 = sharedStore;

(shared$4.exports = function (key, value) {
  return store$2[key] || (store$2[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: '3.25.0',
  mode: 'global',
  copyright: '© 2014-2022 Denis Pushkarev (zloirock.ru)',
  license: 'https://github.com/zloirock/core-js/blob/v3.25.0/LICENSE',
  source: 'https://github.com/zloirock/core-js'
});

var requireObjectCoercible$4 = requireObjectCoercible$6;

var $Object$3 = Object;

// `ToObject` abstract operation
// https://tc39.es/ecma262/#sec-toobject
var toObject$3 = function (argument) {
  return $Object$3(requireObjectCoercible$4(argument));
};

var uncurryThis$f = functionUncurryThis;
var toObject$2 = toObject$3;

var hasOwnProperty = uncurryThis$f({}.hasOwnProperty);

// `HasOwnProperty` abstract operation
// https://tc39.es/ecma262/#sec-hasownproperty
// eslint-disable-next-line es-x/no-object-hasown -- safe
var hasOwnProperty_1 = Object.hasOwn || function hasOwn(it, key) {
  return hasOwnProperty(toObject$2(it), key);
};

var uncurryThis$e = functionUncurryThis;

var id = 0;
var postfix = Math.random();
var toString$6 = uncurryThis$e(1.0.toString);

var uid$2 = function (key) {
  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString$6(++id + postfix, 36);
};

// `IsCallable` abstract operation
// https://tc39.es/ecma262/#sec-iscallable
var isCallable$h = function (argument) {
  return typeof argument == 'function';
};

var global$b = global$e;
var isCallable$g = isCallable$h;

var aFunction = function (argument) {
  return isCallable$g(argument) ? argument : undefined;
};

var getBuiltIn$5 = function (namespace, method) {
  return arguments.length < 2 ? aFunction(global$b[namespace]) : global$b[namespace] && global$b[namespace][method];
};

var getBuiltIn$4 = getBuiltIn$5;

var engineUserAgent = getBuiltIn$4('navigator', 'userAgent') || '';

var global$a = global$e;
var userAgent = engineUserAgent;

var process = global$a.process;
var Deno = global$a.Deno;
var versions = process && process.versions || Deno && Deno.version;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  // in old Chrome, versions of V8 isn't V8 = Chrome / 10
  // but their correct versions are not interesting for us
  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
}

// BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
// so check `userAgent` even if `.v8` exists, but 0
if (!version && userAgent) {
  match = userAgent.match(/Edge\/(\d+)/);
  if (!match || match[1] >= 74) {
    match = userAgent.match(/Chrome\/(\d+)/);
    if (match) version = +match[1];
  }
}

var engineV8Version = version;

/* eslint-disable es-x/no-symbol -- required for testing */

var V8_VERSION = engineV8Version;
var fails$h = fails$k;

// eslint-disable-next-line es-x/no-object-getownpropertysymbols -- required for testing
var symbolConstructorDetection = !!Object.getOwnPropertySymbols && !fails$h(function () {
  var symbol = Symbol();
  // Chrome 38 Symbol has incorrect toString conversion
  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
  return !String(symbol) || !(Object(symbol) instanceof Symbol) ||
    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
    !Symbol.sham && V8_VERSION && V8_VERSION < 41;
});

/* eslint-disable es-x/no-symbol -- required for testing */

var NATIVE_SYMBOL$1 = symbolConstructorDetection;

var useSymbolAsUid = NATIVE_SYMBOL$1
  && !Symbol.sham
  && typeof Symbol.iterator == 'symbol';

var global$9 = global$e;
var shared$3 = shared$4.exports;
var hasOwn$9 = hasOwnProperty_1;
var uid$1 = uid$2;
var NATIVE_SYMBOL = symbolConstructorDetection;
var USE_SYMBOL_AS_UID$1 = useSymbolAsUid;

var WellKnownSymbolsStore = shared$3('wks');
var Symbol$1 = global$9.Symbol;
var symbolFor = Symbol$1 && Symbol$1['for'];
var createWellKnownSymbol = USE_SYMBOL_AS_UID$1 ? Symbol$1 : Symbol$1 && Symbol$1.withoutSetter || uid$1;

var wellKnownSymbol$c = function (name) {
  if (!hasOwn$9(WellKnownSymbolsStore, name) || !(NATIVE_SYMBOL || typeof WellKnownSymbolsStore[name] == 'string')) {
    var description = 'Symbol.' + name;
    if (NATIVE_SYMBOL && hasOwn$9(Symbol$1, name)) {
      WellKnownSymbolsStore[name] = Symbol$1[name];
    } else if (USE_SYMBOL_AS_UID$1 && symbolFor) {
      WellKnownSymbolsStore[name] = symbolFor(description);
    } else {
      WellKnownSymbolsStore[name] = createWellKnownSymbol(description);
    }
  } return WellKnownSymbolsStore[name];
};

var isCallable$f = isCallable$h;

var documentAll = typeof document == 'object' && document.all;

// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot
var SPECIAL_DOCUMENT_ALL = typeof documentAll == 'undefined' && documentAll !== undefined;

var isObject$7 = SPECIAL_DOCUMENT_ALL ? function (it) {
  return typeof it == 'object' ? it !== null : isCallable$f(it) || it === documentAll;
} : function (it) {
  return typeof it == 'object' ? it !== null : isCallable$f(it);
};

var isObject$6 = isObject$7;

var $String$3 = String;
var $TypeError$8 = TypeError;

// `Assert: Type(argument) is Object`
var anObject$a = function (argument) {
  if (isObject$6(argument)) return argument;
  throw $TypeError$8($String$3(argument) + ' is not an object');
};

var objectDefineProperties = {};

var fails$g = fails$k;

// Detect IE8's incomplete defineProperty implementation
var descriptors = !fails$g(function () {
  // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] != 7;
});

var DESCRIPTORS$9 = descriptors;
var fails$f = fails$k;

// V8 ~ Chrome 36-
// https://bugs.chromium.org/p/v8/issues/detail?id=3334
var v8PrototypeDefineBug = DESCRIPTORS$9 && fails$f(function () {
  // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
  return Object.defineProperty(function () { /* empty */ }, 'prototype', {
    value: 42,
    writable: false
  }).prototype != 42;
});

var objectDefineProperty = {};

var global$8 = global$e;
var isObject$5 = isObject$7;

var document$1 = global$8.document;
// typeof document.createElement is 'object' in old IE
var EXISTS$1 = isObject$5(document$1) && isObject$5(document$1.createElement);

var documentCreateElement$2 = function (it) {
  return EXISTS$1 ? document$1.createElement(it) : {};
};

var DESCRIPTORS$8 = descriptors;
var fails$e = fails$k;
var createElement = documentCreateElement$2;

// Thanks to IE8 for its funny defineProperty
var ie8DomDefine = !DESCRIPTORS$8 && !fails$e(function () {
  // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
  return Object.defineProperty(createElement('div'), 'a', {
    get: function () { return 7; }
  }).a != 7;
});

var NATIVE_BIND$1 = functionBindNative;

var call$a = Function.prototype.call;

var functionCall = NATIVE_BIND$1 ? call$a.bind(call$a) : function () {
  return call$a.apply(call$a, arguments);
};

var uncurryThis$d = functionUncurryThis;

var objectIsPrototypeOf = uncurryThis$d({}.isPrototypeOf);

var getBuiltIn$3 = getBuiltIn$5;
var isCallable$e = isCallable$h;
var isPrototypeOf$1 = objectIsPrototypeOf;
var USE_SYMBOL_AS_UID = useSymbolAsUid;

var $Object$2 = Object;

var isSymbol$2 = USE_SYMBOL_AS_UID ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  var $Symbol = getBuiltIn$3('Symbol');
  return isCallable$e($Symbol) && isPrototypeOf$1($Symbol.prototype, $Object$2(it));
};

var $String$2 = String;

var tryToString$2 = function (argument) {
  try {
    return $String$2(argument);
  } catch (error) {
    return 'Object';
  }
};

var isCallable$d = isCallable$h;
var tryToString$1 = tryToString$2;

var $TypeError$7 = TypeError;

// `Assert: IsCallable(argument) is true`
var aCallable$1 = function (argument) {
  if (isCallable$d(argument)) return argument;
  throw $TypeError$7(tryToString$1(argument) + ' is not a function');
};

var aCallable = aCallable$1;
var isNullOrUndefined$2 = isNullOrUndefined$4;

// `GetMethod` abstract operation
// https://tc39.es/ecma262/#sec-getmethod
var getMethod$2 = function (V, P) {
  var func = V[P];
  return isNullOrUndefined$2(func) ? undefined : aCallable(func);
};

var call$9 = functionCall;
var isCallable$c = isCallable$h;
var isObject$4 = isObject$7;

var $TypeError$6 = TypeError;

// `OrdinaryToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-ordinarytoprimitive
var ordinaryToPrimitive$1 = function (input, pref) {
  var fn, val;
  if (pref === 'string' && isCallable$c(fn = input.toString) && !isObject$4(val = call$9(fn, input))) return val;
  if (isCallable$c(fn = input.valueOf) && !isObject$4(val = call$9(fn, input))) return val;
  if (pref !== 'string' && isCallable$c(fn = input.toString) && !isObject$4(val = call$9(fn, input))) return val;
  throw $TypeError$6("Can't convert object to primitive value");
};

var call$8 = functionCall;
var isObject$3 = isObject$7;
var isSymbol$1 = isSymbol$2;
var getMethod$1 = getMethod$2;
var ordinaryToPrimitive = ordinaryToPrimitive$1;
var wellKnownSymbol$b = wellKnownSymbol$c;

var $TypeError$5 = TypeError;
var TO_PRIMITIVE = wellKnownSymbol$b('toPrimitive');

// `ToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-toprimitive
var toPrimitive$1 = function (input, pref) {
  if (!isObject$3(input) || isSymbol$1(input)) return input;
  var exoticToPrim = getMethod$1(input, TO_PRIMITIVE);
  var result;
  if (exoticToPrim) {
    if (pref === undefined) pref = 'default';
    result = call$8(exoticToPrim, input, pref);
    if (!isObject$3(result) || isSymbol$1(result)) return result;
    throw $TypeError$5("Can't convert object to primitive value");
  }
  if (pref === undefined) pref = 'number';
  return ordinaryToPrimitive(input, pref);
};

var toPrimitive = toPrimitive$1;
var isSymbol = isSymbol$2;

// `ToPropertyKey` abstract operation
// https://tc39.es/ecma262/#sec-topropertykey
var toPropertyKey$3 = function (argument) {
  var key = toPrimitive(argument, 'string');
  return isSymbol(key) ? key : key + '';
};

var DESCRIPTORS$7 = descriptors;
var IE8_DOM_DEFINE$1 = ie8DomDefine;
var V8_PROTOTYPE_DEFINE_BUG$1 = v8PrototypeDefineBug;
var anObject$9 = anObject$a;
var toPropertyKey$2 = toPropertyKey$3;

var $TypeError$4 = TypeError;
// eslint-disable-next-line es-x/no-object-defineproperty -- safe
var $defineProperty = Object.defineProperty;
// eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor;
var ENUMERABLE = 'enumerable';
var CONFIGURABLE$1 = 'configurable';
var WRITABLE = 'writable';

// `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty
objectDefineProperty.f = DESCRIPTORS$7 ? V8_PROTOTYPE_DEFINE_BUG$1 ? function defineProperty(O, P, Attributes) {
  anObject$9(O);
  P = toPropertyKey$2(P);
  anObject$9(Attributes);
  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
    var current = $getOwnPropertyDescriptor$1(O, P);
    if (current && current[WRITABLE]) {
      O[P] = Attributes.value;
      Attributes = {
        configurable: CONFIGURABLE$1 in Attributes ? Attributes[CONFIGURABLE$1] : current[CONFIGURABLE$1],
        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
        writable: false
      };
    }
  } return $defineProperty(O, P, Attributes);
} : $defineProperty : function defineProperty(O, P, Attributes) {
  anObject$9(O);
  P = toPropertyKey$2(P);
  anObject$9(Attributes);
  if (IE8_DOM_DEFINE$1) try {
    return $defineProperty(O, P, Attributes);
  } catch (error) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw $TypeError$4('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};

var ceil = Math.ceil;
var floor = Math.floor;

// `Math.trunc` method
// https://tc39.es/ecma262/#sec-math.trunc
// eslint-disable-next-line es-x/no-math-trunc -- safe
var mathTrunc = Math.trunc || function trunc(x) {
  var n = +x;
  return (n > 0 ? floor : ceil)(n);
};

var trunc = mathTrunc;

// `ToIntegerOrInfinity` abstract operation
// https://tc39.es/ecma262/#sec-tointegerorinfinity
var toIntegerOrInfinity$3 = function (argument) {
  var number = +argument;
  // eslint-disable-next-line no-self-compare -- NaN check
  return number !== number || number === 0 ? 0 : trunc(number);
};

var toIntegerOrInfinity$2 = toIntegerOrInfinity$3;

var max$1 = Math.max;
var min$2 = Math.min;

// Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
var toAbsoluteIndex$2 = function (index, length) {
  var integer = toIntegerOrInfinity$2(index);
  return integer < 0 ? max$1(integer + length, 0) : min$2(integer, length);
};

var toIntegerOrInfinity$1 = toIntegerOrInfinity$3;

var min$1 = Math.min;

// `ToLength` abstract operation
// https://tc39.es/ecma262/#sec-tolength
var toLength$2 = function (argument) {
  return argument > 0 ? min$1(toIntegerOrInfinity$1(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};

var toLength$1 = toLength$2;

// `LengthOfArrayLike` abstract operation
// https://tc39.es/ecma262/#sec-lengthofarraylike
var lengthOfArrayLike$2 = function (obj) {
  return toLength$1(obj.length);
};

var toIndexedObject$4 = toIndexedObject$5;
var toAbsoluteIndex$1 = toAbsoluteIndex$2;
var lengthOfArrayLike$1 = lengthOfArrayLike$2;

// `Array.prototype.{ indexOf, includes }` methods implementation
var createMethod$2 = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject$4($this);
    var length = lengthOfArrayLike$1(O);
    var index = toAbsoluteIndex$1(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare -- NaN check
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare -- NaN check
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

var arrayIncludes = {
  // `Array.prototype.includes` method
  // https://tc39.es/ecma262/#sec-array.prototype.includes
  includes: createMethod$2(true),
  // `Array.prototype.indexOf` method
  // https://tc39.es/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod$2(false)
};

var hiddenKeys$4 = {};

var uncurryThis$c = functionUncurryThis;
var hasOwn$8 = hasOwnProperty_1;
var toIndexedObject$3 = toIndexedObject$5;
var indexOf$1 = arrayIncludes.indexOf;
var hiddenKeys$3 = hiddenKeys$4;

var push$1 = uncurryThis$c([].push);

var objectKeysInternal = function (object, names) {
  var O = toIndexedObject$3(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) !hasOwn$8(hiddenKeys$3, key) && hasOwn$8(O, key) && push$1(result, key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (hasOwn$8(O, key = names[i++])) {
    ~indexOf$1(result, key) || push$1(result, key);
  }
  return result;
};

// IE8- don't enum bug keys
var enumBugKeys$3 = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];

var internalObjectKeys$1 = objectKeysInternal;
var enumBugKeys$2 = enumBugKeys$3;

// `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
// eslint-disable-next-line es-x/no-object-keys -- safe
var objectKeys$2 = Object.keys || function keys(O) {
  return internalObjectKeys$1(O, enumBugKeys$2);
};

var DESCRIPTORS$6 = descriptors;
var V8_PROTOTYPE_DEFINE_BUG = v8PrototypeDefineBug;
var definePropertyModule$4 = objectDefineProperty;
var anObject$8 = anObject$a;
var toIndexedObject$2 = toIndexedObject$5;
var objectKeys$1 = objectKeys$2;

// `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
// eslint-disable-next-line es-x/no-object-defineproperties -- safe
objectDefineProperties.f = DESCRIPTORS$6 && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject$8(O);
  var props = toIndexedObject$2(Properties);
  var keys = objectKeys$1(Properties);
  var length = keys.length;
  var index = 0;
  var key;
  while (length > index) definePropertyModule$4.f(O, key = keys[index++], props[key]);
  return O;
};

var getBuiltIn$2 = getBuiltIn$5;

var html$1 = getBuiltIn$2('document', 'documentElement');

var shared$2 = shared$4.exports;
var uid = uid$2;

var keys = shared$2('keys');

var sharedKey$3 = function (key) {
  return keys[key] || (keys[key] = uid(key));
};

/* global ActiveXObject -- old IE, WSH */

var anObject$7 = anObject$a;
var definePropertiesModule = objectDefineProperties;
var enumBugKeys$1 = enumBugKeys$3;
var hiddenKeys$2 = hiddenKeys$4;
var html = html$1;
var documentCreateElement$1 = documentCreateElement$2;
var sharedKey$2 = sharedKey$3;

var GT = '>';
var LT = '<';
var PROTOTYPE = 'prototype';
var SCRIPT = 'script';
var IE_PROTO$1 = sharedKey$2('IE_PROTO');

var EmptyConstructor = function () { /* empty */ };

var scriptTag = function (content) {
  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
};

// Create object with fake `null` prototype: use ActiveX Object with cleared prototype
var NullProtoObjectViaActiveX = function (activeXDocument) {
  activeXDocument.write(scriptTag(''));
  activeXDocument.close();
  var temp = activeXDocument.parentWindow.Object;
  activeXDocument = null; // avoid memory leak
  return temp;
};

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var NullProtoObjectViaIFrame = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = documentCreateElement$1('iframe');
  var JS = 'java' + SCRIPT + ':';
  var iframeDocument;
  iframe.style.display = 'none';
  html.appendChild(iframe);
  // https://github.com/zloirock/core-js/issues/475
  iframe.src = String(JS);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(scriptTag('document.F=Object'));
  iframeDocument.close();
  return iframeDocument.F;
};

// Check for document.domain and active x support
// No need to use active x approach when document.domain is not set
// see https://github.com/es-shims/es5-shim/issues/150
// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
// avoid IE GC bug
var activeXDocument;
var NullProtoObject = function () {
  try {
    activeXDocument = new ActiveXObject('htmlfile');
  } catch (error) { /* ignore */ }
  NullProtoObject = typeof document != 'undefined'
    ? document.domain && activeXDocument
      ? NullProtoObjectViaActiveX(activeXDocument) // old IE
      : NullProtoObjectViaIFrame()
    : NullProtoObjectViaActiveX(activeXDocument); // WSH
  var length = enumBugKeys$1.length;
  while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys$1[length]];
  return NullProtoObject();
};

hiddenKeys$2[IE_PROTO$1] = true;

// `Object.create` method
// https://tc39.es/ecma262/#sec-object.create
// eslint-disable-next-line es-x/no-object-create -- safe
var objectCreate = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    EmptyConstructor[PROTOTYPE] = anObject$7(O);
    result = new EmptyConstructor();
    EmptyConstructor[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO$1] = O;
  } else result = NullProtoObject();
  return Properties === undefined ? result : definePropertiesModule.f(result, Properties);
};

var wellKnownSymbol$a = wellKnownSymbol$c;
var create$2 = objectCreate;
var defineProperty$4 = objectDefineProperty.f;

var UNSCOPABLES = wellKnownSymbol$a('unscopables');
var ArrayPrototype = Array.prototype;

// Array.prototype[@@unscopables]
// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
if (ArrayPrototype[UNSCOPABLES] == undefined) {
  defineProperty$4(ArrayPrototype, UNSCOPABLES, {
    configurable: true,
    value: create$2(null)
  });
}

// add a key to Array.prototype[@@unscopables]
var addToUnscopables$2 = function (key) {
  ArrayPrototype[UNSCOPABLES][key] = true;
};

var iterators = {};

var global$7 = global$e;
var isCallable$b = isCallable$h;

var WeakMap$1 = global$7.WeakMap;

var weakMapBasicDetection = isCallable$b(WeakMap$1) && /native code/.test(String(WeakMap$1));

var createPropertyDescriptor$4 = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};

var DESCRIPTORS$5 = descriptors;
var definePropertyModule$3 = objectDefineProperty;
var createPropertyDescriptor$3 = createPropertyDescriptor$4;

var createNonEnumerableProperty$5 = DESCRIPTORS$5 ? function (object, key, value) {
  return definePropertyModule$3.f(object, key, createPropertyDescriptor$3(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};

var NATIVE_WEAK_MAP = weakMapBasicDetection;
var global$6 = global$e;
var uncurryThis$b = functionUncurryThis;
var isObject$2 = isObject$7;
var createNonEnumerableProperty$4 = createNonEnumerableProperty$5;
var hasOwn$7 = hasOwnProperty_1;
var shared$1 = sharedStore;
var sharedKey$1 = sharedKey$3;
var hiddenKeys$1 = hiddenKeys$4;

var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var TypeError$1 = global$6.TypeError;
var WeakMap = global$6.WeakMap;
var set, get, has;

var enforce = function (it) {
  return has(it) ? get(it) : set(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;
    if (!isObject$2(it) || (state = get(it)).type !== TYPE) {
      throw TypeError$1('Incompatible receiver, ' + TYPE + ' required');
    } return state;
  };
};

if (NATIVE_WEAK_MAP || shared$1.state) {
  var store$1 = shared$1.state || (shared$1.state = new WeakMap());
  var wmget = uncurryThis$b(store$1.get);
  var wmhas = uncurryThis$b(store$1.has);
  var wmset = uncurryThis$b(store$1.set);
  set = function (it, metadata) {
    if (wmhas(store$1, it)) throw TypeError$1(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    wmset(store$1, it, metadata);
    return metadata;
  };
  get = function (it) {
    return wmget(store$1, it) || {};
  };
  has = function (it) {
    return wmhas(store$1, it);
  };
} else {
  var STATE = sharedKey$1('state');
  hiddenKeys$1[STATE] = true;
  set = function (it, metadata) {
    if (hasOwn$7(it, STATE)) throw TypeError$1(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    createNonEnumerableProperty$4(it, STATE, metadata);
    return metadata;
  };
  get = function (it) {
    return hasOwn$7(it, STATE) ? it[STATE] : {};
  };
  has = function (it) {
    return hasOwn$7(it, STATE);
  };
}

var internalState = {
  set: set,
  get: get,
  has: has,
  enforce: enforce,
  getterFor: getterFor
};

var objectGetOwnPropertyDescriptor = {};

var objectPropertyIsEnumerable = {};

var $propertyIsEnumerable = {}.propertyIsEnumerable;
// eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor;

// Nashorn ~ JDK8 bug
var NASHORN_BUG = getOwnPropertyDescriptor$1 && !$propertyIsEnumerable.call({ 1: 2 }, 1);

// `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
objectPropertyIsEnumerable.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor$1(this, V);
  return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;

var DESCRIPTORS$4 = descriptors;
var call$7 = functionCall;
var propertyIsEnumerableModule$1 = objectPropertyIsEnumerable;
var createPropertyDescriptor$2 = createPropertyDescriptor$4;
var toIndexedObject$1 = toIndexedObject$5;
var toPropertyKey$1 = toPropertyKey$3;
var hasOwn$6 = hasOwnProperty_1;
var IE8_DOM_DEFINE = ie8DomDefine;

// eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
objectGetOwnPropertyDescriptor.f = DESCRIPTORS$4 ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject$1(O);
  P = toPropertyKey$1(P);
  if (IE8_DOM_DEFINE) try {
    return $getOwnPropertyDescriptor(O, P);
  } catch (error) { /* empty */ }
  if (hasOwn$6(O, P)) return createPropertyDescriptor$2(!call$7(propertyIsEnumerableModule$1.f, O, P), O[P]);
};

var makeBuiltIn$2 = {exports: {}};

var DESCRIPTORS$3 = descriptors;
var hasOwn$5 = hasOwnProperty_1;

var FunctionPrototype$1 = Function.prototype;
// eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
var getDescriptor = DESCRIPTORS$3 && Object.getOwnPropertyDescriptor;

var EXISTS = hasOwn$5(FunctionPrototype$1, 'name');
// additional protection from minified / mangled / dropped function names
var PROPER = EXISTS && (function something() { /* empty */ }).name === 'something';
var CONFIGURABLE = EXISTS && (!DESCRIPTORS$3 || (DESCRIPTORS$3 && getDescriptor(FunctionPrototype$1, 'name').configurable));

var functionName = {
  EXISTS: EXISTS,
  PROPER: PROPER,
  CONFIGURABLE: CONFIGURABLE
};

var uncurryThis$a = functionUncurryThis;
var isCallable$a = isCallable$h;
var store = sharedStore;

var functionToString = uncurryThis$a(Function.toString);

// this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper
if (!isCallable$a(store.inspectSource)) {
  store.inspectSource = function (it) {
    return functionToString(it);
  };
}

var inspectSource$2 = store.inspectSource;

var fails$d = fails$k;
var isCallable$9 = isCallable$h;
var hasOwn$4 = hasOwnProperty_1;
var DESCRIPTORS$2 = descriptors;
var CONFIGURABLE_FUNCTION_NAME$1 = functionName.CONFIGURABLE;
var inspectSource$1 = inspectSource$2;
var InternalStateModule$1 = internalState;

var enforceInternalState = InternalStateModule$1.enforce;
var getInternalState$2 = InternalStateModule$1.get;
// eslint-disable-next-line es-x/no-object-defineproperty -- safe
var defineProperty$3 = Object.defineProperty;

var CONFIGURABLE_LENGTH = DESCRIPTORS$2 && !fails$d(function () {
  return defineProperty$3(function () { /* empty */ }, 'length', { value: 8 }).length !== 8;
});

var TEMPLATE = String(String).split('String');

var makeBuiltIn$1 = makeBuiltIn$2.exports = function (value, name, options) {
  if (String(name).slice(0, 7) === 'Symbol(') {
    name = '[' + String(name).replace(/^Symbol\(([^)]*)\)/, '$1') + ']';
  }
  if (options && options.getter) name = 'get ' + name;
  if (options && options.setter) name = 'set ' + name;
  if (!hasOwn$4(value, 'name') || (CONFIGURABLE_FUNCTION_NAME$1 && value.name !== name)) {
    if (DESCRIPTORS$2) defineProperty$3(value, 'name', { value: name, configurable: true });
    else value.name = name;
  }
  if (CONFIGURABLE_LENGTH && options && hasOwn$4(options, 'arity') && value.length !== options.arity) {
    defineProperty$3(value, 'length', { value: options.arity });
  }
  try {
    if (options && hasOwn$4(options, 'constructor') && options.constructor) {
      if (DESCRIPTORS$2) defineProperty$3(value, 'prototype', { writable: false });
    // in V8 ~ Chrome 53, prototypes of some methods, like `Array.prototype.values`, are non-writable
    } else if (value.prototype) value.prototype = undefined;
  } catch (error) { /* empty */ }
  var state = enforceInternalState(value);
  if (!hasOwn$4(state, 'source')) {
    state.source = TEMPLATE.join(typeof name == 'string' ? name : '');
  } return value;
};

// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
// eslint-disable-next-line no-extend-native -- required
Function.prototype.toString = makeBuiltIn$1(function toString() {
  return isCallable$9(this) && getInternalState$2(this).source || inspectSource$1(this);
}, 'toString');

var isCallable$8 = isCallable$h;
var definePropertyModule$2 = objectDefineProperty;
var makeBuiltIn = makeBuiltIn$2.exports;
var defineGlobalProperty$1 = defineGlobalProperty$3;

var defineBuiltIn$5 = function (O, key, value, options) {
  if (!options) options = {};
  var simple = options.enumerable;
  var name = options.name !== undefined ? options.name : key;
  if (isCallable$8(value)) makeBuiltIn(value, name, options);
  if (options.global) {
    if (simple) O[key] = value;
    else defineGlobalProperty$1(key, value);
  } else {
    try {
      if (!options.unsafe) delete O[key];
      else if (O[key]) simple = true;
    } catch (error) { /* empty */ }
    if (simple) O[key] = value;
    else definePropertyModule$2.f(O, key, {
      value: value,
      enumerable: false,
      configurable: !options.nonConfigurable,
      writable: !options.nonWritable
    });
  } return O;
};

var objectGetOwnPropertyNames = {};

var internalObjectKeys = objectKeysInternal;
var enumBugKeys = enumBugKeys$3;

var hiddenKeys = enumBugKeys.concat('length', 'prototype');

// `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
// eslint-disable-next-line es-x/no-object-getownpropertynames -- safe
objectGetOwnPropertyNames.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys(O, hiddenKeys);
};

var objectGetOwnPropertySymbols = {};

// eslint-disable-next-line es-x/no-object-getownpropertysymbols -- safe
objectGetOwnPropertySymbols.f = Object.getOwnPropertySymbols;

var getBuiltIn$1 = getBuiltIn$5;
var uncurryThis$9 = functionUncurryThis;
var getOwnPropertyNamesModule = objectGetOwnPropertyNames;
var getOwnPropertySymbolsModule$1 = objectGetOwnPropertySymbols;
var anObject$6 = anObject$a;

var concat$1 = uncurryThis$9([].concat);

// all object keys, includes non-enumerable and symbols
var ownKeys$1 = getBuiltIn$1('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule.f(anObject$6(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule$1.f;
  return getOwnPropertySymbols ? concat$1(keys, getOwnPropertySymbols(it)) : keys;
};

var hasOwn$3 = hasOwnProperty_1;
var ownKeys = ownKeys$1;
var getOwnPropertyDescriptorModule = objectGetOwnPropertyDescriptor;
var definePropertyModule$1 = objectDefineProperty;

var copyConstructorProperties$1 = function (target, source, exceptions) {
  var keys = ownKeys(source);
  var defineProperty = definePropertyModule$1.f;
  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!hasOwn$3(target, key) && !(exceptions && hasOwn$3(exceptions, key))) {
      defineProperty(target, key, getOwnPropertyDescriptor(source, key));
    }
  }
};

var fails$c = fails$k;
var isCallable$7 = isCallable$h;

var replacement = /#|\.prototype\./;

var isForced$1 = function (feature, detection) {
  var value = data[normalize(feature)];
  return value == POLYFILL ? true
    : value == NATIVE ? false
    : isCallable$7(detection) ? fails$c(detection)
    : !!detection;
};

var normalize = isForced$1.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced$1.data = {};
var NATIVE = isForced$1.NATIVE = 'N';
var POLYFILL = isForced$1.POLYFILL = 'P';

var isForced_1 = isForced$1;

var global$5 = global$e;
var getOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
var createNonEnumerableProperty$3 = createNonEnumerableProperty$5;
var defineBuiltIn$4 = defineBuiltIn$5;
var defineGlobalProperty = defineGlobalProperty$3;
var copyConstructorProperties = copyConstructorProperties$1;
var isForced = isForced_1;

/*
  options.target         - name of the target object
  options.global         - target is the global object
  options.stat           - export as static methods of target
  options.proto          - export as prototype methods of target
  options.real           - real prototype method for the `pure` version
  options.forced         - export even if the native feature is available
  options.bind           - bind methods to the target, required for the `pure` version
  options.wrap           - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe         - use the simple assignment of property instead of delete + defineProperty
  options.sham           - add a flag to not completely full polyfills
  options.enumerable     - export as enumerable property
  options.dontCallGetSet - prevent calling a getter on target
  options.name           - the .name of the function if it does not match the key
*/
var _export = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var FORCED, target, key, targetProperty, sourceProperty, descriptor;
  if (GLOBAL) {
    target = global$5;
  } else if (STATIC) {
    target = global$5[TARGET] || defineGlobalProperty(TARGET, {});
  } else {
    target = (global$5[TARGET] || {}).prototype;
  }
  if (target) for (key in source) {
    sourceProperty = source[key];
    if (options.dontCallGetSet) {
      descriptor = getOwnPropertyDescriptor(target, key);
      targetProperty = descriptor && descriptor.value;
    } else targetProperty = target[key];
    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    // contained in target
    if (!FORCED && targetProperty !== undefined) {
      if (typeof sourceProperty == typeof targetProperty) continue;
      copyConstructorProperties(sourceProperty, targetProperty);
    }
    // add a flag to not completely full polyfills
    if (options.sham || (targetProperty && targetProperty.sham)) {
      createNonEnumerableProperty$3(sourceProperty, 'sham', true);
    }
    defineBuiltIn$4(target, key, sourceProperty, options);
  }
};

var fails$b = fails$k;

var correctPrototypeGetter = !fails$b(function () {
  function F() { /* empty */ }
  F.prototype.constructor = null;
  // eslint-disable-next-line es-x/no-object-getprototypeof -- required for testing
  return Object.getPrototypeOf(new F()) !== F.prototype;
});

var hasOwn$2 = hasOwnProperty_1;
var isCallable$6 = isCallable$h;
var toObject$1 = toObject$3;
var sharedKey = sharedKey$3;
var CORRECT_PROTOTYPE_GETTER = correctPrototypeGetter;

var IE_PROTO = sharedKey('IE_PROTO');
var $Object$1 = Object;
var ObjectPrototype = $Object$1.prototype;

// `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof
// eslint-disable-next-line es-x/no-object-getprototypeof -- safe
var objectGetPrototypeOf = CORRECT_PROTOTYPE_GETTER ? $Object$1.getPrototypeOf : function (O) {
  var object = toObject$1(O);
  if (hasOwn$2(object, IE_PROTO)) return object[IE_PROTO];
  var constructor = object.constructor;
  if (isCallable$6(constructor) && object instanceof constructor) {
    return constructor.prototype;
  } return object instanceof $Object$1 ? ObjectPrototype : null;
};

var fails$a = fails$k;
var isCallable$5 = isCallable$h;
var isObject$1 = isObject$7;
var getPrototypeOf$1 = objectGetPrototypeOf;
var defineBuiltIn$3 = defineBuiltIn$5;
var wellKnownSymbol$9 = wellKnownSymbol$c;

var ITERATOR$2 = wellKnownSymbol$9('iterator');
var BUGGY_SAFARI_ITERATORS$1 = false;

// `%IteratorPrototype%` object
// https://tc39.es/ecma262/#sec-%iteratorprototype%-object
var IteratorPrototype$2, PrototypeOfArrayIteratorPrototype, arrayIterator;

/* eslint-disable es-x/no-array-prototype-keys -- safe */
if ([].keys) {
  arrayIterator = [].keys();
  // Safari 8 has buggy iterators w/o `next`
  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS$1 = true;
  else {
    PrototypeOfArrayIteratorPrototype = getPrototypeOf$1(getPrototypeOf$1(arrayIterator));
    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype$2 = PrototypeOfArrayIteratorPrototype;
  }
}

var NEW_ITERATOR_PROTOTYPE = !isObject$1(IteratorPrototype$2) || fails$a(function () {
  var test = {};
  // FF44- legacy iterators case
  return IteratorPrototype$2[ITERATOR$2].call(test) !== test;
});

if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype$2 = {};

// `%IteratorPrototype%[@@iterator]()` method
// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator
if (!isCallable$5(IteratorPrototype$2[ITERATOR$2])) {
  defineBuiltIn$3(IteratorPrototype$2, ITERATOR$2, function () {
    return this;
  });
}

var iteratorsCore = {
  IteratorPrototype: IteratorPrototype$2,
  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS$1
};

var defineProperty$2 = objectDefineProperty.f;
var hasOwn$1 = hasOwnProperty_1;
var wellKnownSymbol$8 = wellKnownSymbol$c;

var TO_STRING_TAG$3 = wellKnownSymbol$8('toStringTag');

var setToStringTag$2 = function (target, TAG, STATIC) {
  if (target && !STATIC) target = target.prototype;
  if (target && !hasOwn$1(target, TO_STRING_TAG$3)) {
    defineProperty$2(target, TO_STRING_TAG$3, { configurable: true, value: TAG });
  }
};

var IteratorPrototype$1 = iteratorsCore.IteratorPrototype;
var create$1 = objectCreate;
var createPropertyDescriptor$1 = createPropertyDescriptor$4;
var setToStringTag$1 = setToStringTag$2;
var Iterators$2 = iterators;

var returnThis$1 = function () { return this; };

var iteratorCreateConstructor = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
  var TO_STRING_TAG = NAME + ' Iterator';
  IteratorConstructor.prototype = create$1(IteratorPrototype$1, { next: createPropertyDescriptor$1(+!ENUMERABLE_NEXT, next) });
  setToStringTag$1(IteratorConstructor, TO_STRING_TAG, false);
  Iterators$2[TO_STRING_TAG] = returnThis$1;
  return IteratorConstructor;
};

var isCallable$4 = isCallable$h;

var $String$1 = String;
var $TypeError$3 = TypeError;

var aPossiblePrototype$1 = function (argument) {
  if (typeof argument == 'object' || isCallable$4(argument)) return argument;
  throw $TypeError$3("Can't set " + $String$1(argument) + ' as a prototype');
};

/* eslint-disable no-proto -- safe */

var uncurryThis$8 = functionUncurryThis;
var anObject$5 = anObject$a;
var aPossiblePrototype = aPossiblePrototype$1;

// `Object.setPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.setprototypeof
// Works with __proto__ only. Old v8 can't work with null proto objects.
// eslint-disable-next-line es-x/no-object-setprototypeof -- safe
var objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
  var CORRECT_SETTER = false;
  var test = {};
  var setter;
  try {
    // eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
    setter = uncurryThis$8(Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set);
    setter(test, []);
    CORRECT_SETTER = test instanceof Array;
  } catch (error) { /* empty */ }
  return function setPrototypeOf(O, proto) {
    anObject$5(O);
    aPossiblePrototype(proto);
    if (CORRECT_SETTER) setter(O, proto);
    else O.__proto__ = proto;
    return O;
  };
}() : undefined);

var $$5 = _export;
var call$6 = functionCall;
var FunctionName = functionName;
var isCallable$3 = isCallable$h;
var createIteratorConstructor = iteratorCreateConstructor;
var getPrototypeOf = objectGetPrototypeOf;
var setPrototypeOf = objectSetPrototypeOf;
var setToStringTag = setToStringTag$2;
var createNonEnumerableProperty$2 = createNonEnumerableProperty$5;
var defineBuiltIn$2 = defineBuiltIn$5;
var wellKnownSymbol$7 = wellKnownSymbol$c;
var Iterators$1 = iterators;
var IteratorsCore = iteratorsCore;

var PROPER_FUNCTION_NAME$2 = FunctionName.PROPER;
var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
var IteratorPrototype = IteratorsCore.IteratorPrototype;
var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
var ITERATOR$1 = wellKnownSymbol$7('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';

var returnThis = function () { return this; };

var iteratorDefine = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
  createIteratorConstructor(IteratorConstructor, NAME, next);

  var getIterationMethod = function (KIND) {
    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
    if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];
    switch (KIND) {
      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
    } return function () { return new IteratorConstructor(this); };
  };

  var TO_STRING_TAG = NAME + ' Iterator';
  var INCORRECT_VALUES_NAME = false;
  var IterablePrototype = Iterable.prototype;
  var nativeIterator = IterablePrototype[ITERATOR$1]
    || IterablePrototype['@@iterator']
    || DEFAULT && IterablePrototype[DEFAULT];
  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
  var CurrentIteratorPrototype, methods, KEY;

  // fix native
  if (anyNativeIterator) {
    CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
    if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
      if (getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
        if (setPrototypeOf) {
          setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
        } else if (!isCallable$3(CurrentIteratorPrototype[ITERATOR$1])) {
          defineBuiltIn$2(CurrentIteratorPrototype, ITERATOR$1, returnThis);
        }
      }
      // Set @@toStringTag to native iterators
      setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true);
    }
  }

  // fix Array.prototype.{ values, @@iterator }.name in V8 / FF
  if (PROPER_FUNCTION_NAME$2 && DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
    if (CONFIGURABLE_FUNCTION_NAME) {
      createNonEnumerableProperty$2(IterablePrototype, 'name', VALUES);
    } else {
      INCORRECT_VALUES_NAME = true;
      defaultIterator = function values() { return call$6(nativeIterator, this); };
    }
  }

  // export additional methods
  if (DEFAULT) {
    methods = {
      values: getIterationMethod(VALUES),
      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
      entries: getIterationMethod(ENTRIES)
    };
    if (FORCED) for (KEY in methods) {
      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
        defineBuiltIn$2(IterablePrototype, KEY, methods[KEY]);
      }
    } else $$5({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
  }

  // define iterator
  if (IterablePrototype[ITERATOR$1] !== defaultIterator) {
    defineBuiltIn$2(IterablePrototype, ITERATOR$1, defaultIterator, { name: DEFAULT });
  }
  Iterators$1[NAME] = defaultIterator;

  return methods;
};

var toIndexedObject = toIndexedObject$5;
var addToUnscopables$1 = addToUnscopables$2;
var Iterators = iterators;
var InternalStateModule = internalState;
var defineProperty$1 = objectDefineProperty.f;
var defineIterator = iteratorDefine;
var DESCRIPTORS$1 = descriptors;

var ARRAY_ITERATOR = 'Array Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState$1 = InternalStateModule.getterFor(ARRAY_ITERATOR);

// `Array.prototype.entries` method
// https://tc39.es/ecma262/#sec-array.prototype.entries
// `Array.prototype.keys` method
// https://tc39.es/ecma262/#sec-array.prototype.keys
// `Array.prototype.values` method
// https://tc39.es/ecma262/#sec-array.prototype.values
// `Array.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
// `CreateArrayIterator` internal method
// https://tc39.es/ecma262/#sec-createarrayiterator
var es_array_iterator = defineIterator(Array, 'Array', function (iterated, kind) {
  setInternalState(this, {
    type: ARRAY_ITERATOR,
    target: toIndexedObject(iterated), // target
    index: 0,                          // next index
    kind: kind                         // kind
  });
// `%ArrayIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
}, function () {
  var state = getInternalState$1(this);
  var target = state.target;
  var kind = state.kind;
  var index = state.index++;
  if (!target || index >= target.length) {
    state.target = undefined;
    return { value: undefined, done: true };
  }
  if (kind == 'keys') return { value: index, done: false };
  if (kind == 'values') return { value: target[index], done: false };
  return { value: [index, target[index]], done: false };
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values%
// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
// https://tc39.es/ecma262/#sec-createmappedargumentsobject
var values = Iterators.Arguments = Iterators.Array;

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables$1('keys');
addToUnscopables$1('values');
addToUnscopables$1('entries');

// V8 ~ Chrome 45- bug
if (DESCRIPTORS$1 && values.name !== 'values') try {
  defineProperty$1(values, 'name', { value: 'values' });
} catch (error) { /* empty */ }

// iterable DOM collections
// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
var domIterables = {
  CSSRuleList: 0,
  CSSStyleDeclaration: 0,
  CSSValueList: 0,
  ClientRectList: 0,
  DOMRectList: 0,
  DOMStringList: 0,
  DOMTokenList: 1,
  DataTransferItemList: 0,
  FileList: 0,
  HTMLAllCollection: 0,
  HTMLCollection: 0,
  HTMLFormElement: 0,
  HTMLSelectElement: 0,
  MediaList: 0,
  MimeTypeArray: 0,
  NamedNodeMap: 0,
  NodeList: 1,
  PaintRequestList: 0,
  Plugin: 0,
  PluginArray: 0,
  SVGLengthList: 0,
  SVGNumberList: 0,
  SVGPathSegList: 0,
  SVGPointList: 0,
  SVGStringList: 0,
  SVGTransformList: 0,
  SourceBufferList: 0,
  StyleSheetList: 0,
  TextTrackCueList: 0,
  TextTrackList: 0,
  TouchList: 0
};

// in old WebKit versions, `element.classList` is not an instance of global `DOMTokenList`
var documentCreateElement = documentCreateElement$2;

var classList = documentCreateElement('span').classList;
var DOMTokenListPrototype$1 = classList && classList.constructor && classList.constructor.prototype;

var domTokenListPrototype = DOMTokenListPrototype$1 === Object.prototype ? undefined : DOMTokenListPrototype$1;

var global$4 = global$e;
var DOMIterables = domIterables;
var DOMTokenListPrototype = domTokenListPrototype;
var ArrayIteratorMethods = es_array_iterator;
var createNonEnumerableProperty$1 = createNonEnumerableProperty$5;
var wellKnownSymbol$6 = wellKnownSymbol$c;

var ITERATOR = wellKnownSymbol$6('iterator');
var TO_STRING_TAG$2 = wellKnownSymbol$6('toStringTag');
var ArrayValues = ArrayIteratorMethods.values;

var handlePrototype = function (CollectionPrototype, COLLECTION_NAME) {
  if (CollectionPrototype) {
    // some Chrome versions have non-configurable methods on DOMTokenList
    if (CollectionPrototype[ITERATOR] !== ArrayValues) try {
      createNonEnumerableProperty$1(CollectionPrototype, ITERATOR, ArrayValues);
    } catch (error) {
      CollectionPrototype[ITERATOR] = ArrayValues;
    }
    if (!CollectionPrototype[TO_STRING_TAG$2]) {
      createNonEnumerableProperty$1(CollectionPrototype, TO_STRING_TAG$2, COLLECTION_NAME);
    }
    if (DOMIterables[COLLECTION_NAME]) for (var METHOD_NAME in ArrayIteratorMethods) {
      // some Chrome versions have non-configurable methods on DOMTokenList
      if (CollectionPrototype[METHOD_NAME] !== ArrayIteratorMethods[METHOD_NAME]) try {
        createNonEnumerableProperty$1(CollectionPrototype, METHOD_NAME, ArrayIteratorMethods[METHOD_NAME]);
      } catch (error) {
        CollectionPrototype[METHOD_NAME] = ArrayIteratorMethods[METHOD_NAME];
      }
    }
  }
};

for (var COLLECTION_NAME in DOMIterables) {
  handlePrototype(global$4[COLLECTION_NAME] && global$4[COLLECTION_NAME].prototype, COLLECTION_NAME);
}

handlePrototype(DOMTokenListPrototype, 'DOMTokenList');

var wellKnownSymbol$5 = wellKnownSymbol$c;

var TO_STRING_TAG$1 = wellKnownSymbol$5('toStringTag');
var test = {};

test[TO_STRING_TAG$1] = 'z';

var toStringTagSupport = String(test) === '[object z]';

var TO_STRING_TAG_SUPPORT = toStringTagSupport;
var isCallable$2 = isCallable$h;
var classofRaw = classofRaw$1;
var wellKnownSymbol$4 = wellKnownSymbol$c;

var TO_STRING_TAG = wellKnownSymbol$4('toStringTag');
var $Object = Object;

// ES3 wrong here
var CORRECT_ARGUMENTS = classofRaw(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (error) { /* empty */ }
};

// getting tag from ES6+ `Object.prototype.toString`
var classof$4 = TO_STRING_TAG_SUPPORT ? classofRaw : function (it) {
  var O, tag, result;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (tag = tryGet(O = $Object(it), TO_STRING_TAG)) == 'string' ? tag
    // builtinTag case
    : CORRECT_ARGUMENTS ? classofRaw(O)
    // ES3 arguments fallback
    : (result = classofRaw(O)) == 'Object' && isCallable$2(O.callee) ? 'Arguments' : result;
};

var classof$3 = classof$4;

var $String = String;

var toString$5 = function (argument) {
  if (classof$3(argument) === 'Symbol') throw TypeError('Cannot convert a Symbol value to a string');
  return $String(argument);
};

var anObject$4 = anObject$a;

// `RegExp.prototype.flags` getter implementation
// https://tc39.es/ecma262/#sec-get-regexp.prototype.flags
var regexpFlags$1 = function () {
  var that = anObject$4(this);
  var result = '';
  if (that.hasIndices) result += 'd';
  if (that.global) result += 'g';
  if (that.ignoreCase) result += 'i';
  if (that.multiline) result += 'm';
  if (that.dotAll) result += 's';
  if (that.unicode) result += 'u';
  if (that.unicodeSets) result += 'v';
  if (that.sticky) result += 'y';
  return result;
};

var call$5 = functionCall;
var hasOwn = hasOwnProperty_1;
var isPrototypeOf = objectIsPrototypeOf;
var regExpFlags = regexpFlags$1;

var RegExpPrototype$2 = RegExp.prototype;

var regexpGetFlags = function (R) {
  var flags = R.flags;
  return flags === undefined && !('flags' in RegExpPrototype$2) && !hasOwn(R, 'flags') && isPrototypeOf(RegExpPrototype$2, R)
    ? call$5(regExpFlags, R) : flags;
};

var PROPER_FUNCTION_NAME$1 = functionName.PROPER;
var defineBuiltIn$1 = defineBuiltIn$5;
var anObject$3 = anObject$a;
var $toString = toString$5;
var fails$9 = fails$k;
var getRegExpFlags = regexpGetFlags;

var TO_STRING = 'toString';
var RegExpPrototype$1 = RegExp.prototype;
var nativeToString = RegExpPrototype$1[TO_STRING];

var NOT_GENERIC = fails$9(function () { return nativeToString.call({ source: 'a', flags: 'b' }) != '/a/b'; });
// FF44- RegExp#toString has a wrong name
var INCORRECT_NAME = PROPER_FUNCTION_NAME$1 && nativeToString.name != TO_STRING;

// `RegExp.prototype.toString` method
// https://tc39.es/ecma262/#sec-regexp.prototype.tostring
if (NOT_GENERIC || INCORRECT_NAME) {
  defineBuiltIn$1(RegExp.prototype, TO_STRING, function toString() {
    var R = anObject$3(this);
    var pattern = $toString(R.source);
    var flags = $toString(getRegExpFlags(R));
    return '/' + pattern + '/' + flags;
  }, { unsafe: true });
}

// a string of all valid unicode whitespaces
var whitespaces$2 = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' +
  '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

var uncurryThis$7 = functionUncurryThis;
var requireObjectCoercible$3 = requireObjectCoercible$6;
var toString$4 = toString$5;
var whitespaces$1 = whitespaces$2;

var replace$1 = uncurryThis$7(''.replace);
var whitespace = '[' + whitespaces$1 + ']';
var ltrim = RegExp('^' + whitespace + whitespace + '*');
var rtrim = RegExp(whitespace + whitespace + '*$');

// `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation
var createMethod$1 = function (TYPE) {
  return function ($this) {
    var string = toString$4(requireObjectCoercible$3($this));
    if (TYPE & 1) string = replace$1(string, ltrim, '');
    if (TYPE & 2) string = replace$1(string, rtrim, '');
    return string;
  };
};

var stringTrim = {
  // `String.prototype.{ trimLeft, trimStart }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimstart
  start: createMethod$1(1),
  // `String.prototype.{ trimRight, trimEnd }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimend
  end: createMethod$1(2),
  // `String.prototype.trim` method
  // https://tc39.es/ecma262/#sec-string.prototype.trim
  trim: createMethod$1(3)
};

var PROPER_FUNCTION_NAME = functionName.PROPER;
var fails$8 = fails$k;
var whitespaces = whitespaces$2;

var non = '\u200B\u0085\u180E';

// check that a method works with the correct list
// of whitespaces and has a correct name
var stringTrimForced = function (METHOD_NAME) {
  return fails$8(function () {
    return !!whitespaces[METHOD_NAME]()
      || non[METHOD_NAME]() !== non
      || (PROPER_FUNCTION_NAME && whitespaces[METHOD_NAME].name !== METHOD_NAME);
  });
};

var $$4 = _export;
var $trim = stringTrim.trim;
var forcedStringTrimMethod = stringTrimForced;

// `String.prototype.trim` method
// https://tc39.es/ecma262/#sec-string.prototype.trim
$$4({ target: 'String', proto: true, forced: forcedStringTrimMethod('trim') }, {
  trim: function trim() {
    return $trim(this);
  }
});

var DESCRIPTORS = descriptors;
var uncurryThis$6 = functionUncurryThis;
var call$4 = functionCall;
var fails$7 = fails$k;
var objectKeys = objectKeys$2;
var getOwnPropertySymbolsModule = objectGetOwnPropertySymbols;
var propertyIsEnumerableModule = objectPropertyIsEnumerable;
var toObject = toObject$3;
var IndexedObject = indexedObject;

// eslint-disable-next-line es-x/no-object-assign -- safe
var $assign = Object.assign;
// eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
var defineProperty = Object.defineProperty;
var concat = uncurryThis$6([].concat);

// `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign
var objectAssign = !$assign || fails$7(function () {
  // should have correct order of operations (Edge bug)
  if (DESCRIPTORS && $assign({ b: 1 }, $assign(defineProperty({}, 'a', {
    enumerable: true,
    get: function () {
      defineProperty(this, 'b', {
        value: 3,
        enumerable: false
      });
    }
  }), { b: 2 })).b !== 1) return true;
  // should work with symbols and should have deterministic property order (V8 bug)
  var A = {};
  var B = {};
  // eslint-disable-next-line es-x/no-symbol -- safe
  var symbol = Symbol();
  var alphabet = 'abcdefghijklmnopqrst';
  A[symbol] = 7;
  alphabet.split('').forEach(function (chr) { B[chr] = chr; });
  return $assign({}, A)[symbol] != 7 || objectKeys($assign({}, B)).join('') != alphabet;
}) ? function assign(target, source) { // eslint-disable-line no-unused-vars -- required for `.length`
  var T = toObject(target);
  var argumentsLength = arguments.length;
  var index = 1;
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  var propertyIsEnumerable = propertyIsEnumerableModule.f;
  while (argumentsLength > index) {
    var S = IndexedObject(arguments[index++]);
    var keys = getOwnPropertySymbols ? concat(objectKeys(S), getOwnPropertySymbols(S)) : objectKeys(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) {
      key = keys[j++];
      if (!DESCRIPTORS || call$4(propertyIsEnumerable, S, key)) T[key] = S[key];
    }
  } return T;
} : $assign;

var $$3 = _export;
var assign = objectAssign;

// `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign
// eslint-disable-next-line es-x/no-object-assign -- required for testing
$$3({ target: 'Object', stat: true, arity: 2, forced: Object.assign !== assign }, {
  assign: assign
});

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

var fails$6 = fails$k;
var global$3 = global$e;

// babel-minify and Closure Compiler transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError
var $RegExp$2 = global$3.RegExp;

var UNSUPPORTED_Y$2 = fails$6(function () {
  var re = $RegExp$2('a', 'y');
  re.lastIndex = 2;
  return re.exec('abcd') != null;
});

// UC Browser bug
// https://github.com/zloirock/core-js/issues/1008
var MISSED_STICKY = UNSUPPORTED_Y$2 || fails$6(function () {
  return !$RegExp$2('a', 'y').sticky;
});

var BROKEN_CARET = UNSUPPORTED_Y$2 || fails$6(function () {
  // https://bugzilla.mozilla.org/show_bug.cgi?id=773687
  var re = $RegExp$2('^r', 'gy');
  re.lastIndex = 2;
  return re.exec('str') != null;
});

var regexpStickyHelpers = {
  BROKEN_CARET: BROKEN_CARET,
  MISSED_STICKY: MISSED_STICKY,
  UNSUPPORTED_Y: UNSUPPORTED_Y$2
};

var fails$5 = fails$k;
var global$2 = global$e;

// babel-minify and Closure Compiler transpiles RegExp('.', 's') -> /./s and it causes SyntaxError
var $RegExp$1 = global$2.RegExp;

var regexpUnsupportedDotAll = fails$5(function () {
  var re = $RegExp$1('.', 's');
  return !(re.dotAll && re.exec('\n') && re.flags === 's');
});

var fails$4 = fails$k;
var global$1 = global$e;

// babel-minify and Closure Compiler transpiles RegExp('(?<a>b)', 'g') -> /(?<a>b)/g and it causes SyntaxError
var $RegExp = global$1.RegExp;

var regexpUnsupportedNcg = fails$4(function () {
  var re = $RegExp('(?<a>b)', 'g');
  return re.exec('b').groups.a !== 'b' ||
    'b'.replace(re, '$<a>c') !== 'bc';
});

/* eslint-disable regexp/no-empty-capturing-group, regexp/no-empty-group, regexp/no-lazy-ends -- testing */
/* eslint-disable regexp/no-useless-quantifier -- testing */
var call$3 = functionCall;
var uncurryThis$5 = functionUncurryThis;
var toString$3 = toString$5;
var regexpFlags = regexpFlags$1;
var stickyHelpers$1 = regexpStickyHelpers;
var shared = shared$4.exports;
var create = objectCreate;
var getInternalState = internalState.get;
var UNSUPPORTED_DOT_ALL = regexpUnsupportedDotAll;
var UNSUPPORTED_NCG = regexpUnsupportedNcg;

var nativeReplace = shared('native-string-replace', String.prototype.replace);
var nativeExec = RegExp.prototype.exec;
var patchedExec = nativeExec;
var charAt$2 = uncurryThis$5(''.charAt);
var indexOf = uncurryThis$5(''.indexOf);
var replace = uncurryThis$5(''.replace);
var stringSlice$2 = uncurryThis$5(''.slice);

var UPDATES_LAST_INDEX_WRONG = (function () {
  var re1 = /a/;
  var re2 = /b*/g;
  call$3(nativeExec, re1, 'a');
  call$3(nativeExec, re2, 'a');
  return re1.lastIndex !== 0 || re2.lastIndex !== 0;
})();

var UNSUPPORTED_Y$1 = stickyHelpers$1.BROKEN_CARET;

// nonparticipating capturing group, copied from es5-shim's String#split patch.
var NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;

var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y$1 || UNSUPPORTED_DOT_ALL || UNSUPPORTED_NCG;

if (PATCH) {
  patchedExec = function exec(string) {
    var re = this;
    var state = getInternalState(re);
    var str = toString$3(string);
    var raw = state.raw;
    var result, reCopy, lastIndex, match, i, object, group;

    if (raw) {
      raw.lastIndex = re.lastIndex;
      result = call$3(patchedExec, raw, str);
      re.lastIndex = raw.lastIndex;
      return result;
    }

    var groups = state.groups;
    var sticky = UNSUPPORTED_Y$1 && re.sticky;
    var flags = call$3(regexpFlags, re);
    var source = re.source;
    var charsAdded = 0;
    var strCopy = str;

    if (sticky) {
      flags = replace(flags, 'y', '');
      if (indexOf(flags, 'g') === -1) {
        flags += 'g';
      }

      strCopy = stringSlice$2(str, re.lastIndex);
      // Support anchored sticky behavior.
      if (re.lastIndex > 0 && (!re.multiline || re.multiline && charAt$2(str, re.lastIndex - 1) !== '\n')) {
        source = '(?: ' + source + ')';
        strCopy = ' ' + strCopy;
        charsAdded++;
      }
      // ^(? + rx + ) is needed, in combination with some str slicing, to
      // simulate the 'y' flag.
      reCopy = new RegExp('^(?:' + source + ')', flags);
    }

    if (NPCG_INCLUDED) {
      reCopy = new RegExp('^' + source + '$(?!\\s)', flags);
    }
    if (UPDATES_LAST_INDEX_WRONG) lastIndex = re.lastIndex;

    match = call$3(nativeExec, sticky ? reCopy : re, strCopy);

    if (sticky) {
      if (match) {
        match.input = stringSlice$2(match.input, charsAdded);
        match[0] = stringSlice$2(match[0], charsAdded);
        match.index = re.lastIndex;
        re.lastIndex += match[0].length;
      } else re.lastIndex = 0;
    } else if (UPDATES_LAST_INDEX_WRONG && match) {
      re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
    }
    if (NPCG_INCLUDED && match && match.length > 1) {
      // Fix browsers whose `exec` methods don't consistently return `undefined`
      // for NPCG, like IE8. NOTE: This doesn't work for /(.?)?/
      call$3(nativeReplace, match[0], reCopy, function () {
        for (i = 1; i < arguments.length - 2; i++) {
          if (arguments[i] === undefined) match[i] = undefined;
        }
      });
    }

    if (match && groups) {
      match.groups = object = create(null);
      for (i = 0; i < groups.length; i++) {
        group = groups[i];
        object[group[0]] = match[group[1]];
      }
    }

    return match;
  };
}

var regexpExec$3 = patchedExec;

var $$2 = _export;
var exec$2 = regexpExec$3;

// `RegExp.prototype.exec` method
// https://tc39.es/ecma262/#sec-regexp.prototype.exec
$$2({ target: 'RegExp', proto: true, forced: /./.exec !== exec$2 }, {
  exec: exec$2
});

var $$1 = _export;
var $includes = arrayIncludes.includes;
var fails$3 = fails$k;
var addToUnscopables = addToUnscopables$2;

// FF99+ bug
var BROKEN_ON_SPARSE = fails$3(function () {
  return !Array(1).includes();
});

// `Array.prototype.includes` method
// https://tc39.es/ecma262/#sec-array.prototype.includes
$$1({ target: 'Array', proto: true, forced: BROKEN_ON_SPARSE }, {
  includes: function includes(el /* , fromIndex = 0 */) {
    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
  }
});

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables('includes');

var isObject = isObject$7;
var classof$2 = classofRaw$1;
var wellKnownSymbol$3 = wellKnownSymbol$c;

var MATCH$1 = wellKnownSymbol$3('match');

// `IsRegExp` abstract operation
// https://tc39.es/ecma262/#sec-isregexp
var isRegexp = function (it) {
  var isRegExp;
  return isObject(it) && ((isRegExp = it[MATCH$1]) !== undefined ? !!isRegExp : classof$2(it) == 'RegExp');
};

var isRegExp$1 = isRegexp;

var $TypeError$2 = TypeError;

var notARegexp = function (it) {
  if (isRegExp$1(it)) {
    throw $TypeError$2("The method doesn't accept regular expressions");
  } return it;
};

var wellKnownSymbol$2 = wellKnownSymbol$c;

var MATCH = wellKnownSymbol$2('match');

var correctIsRegexpLogic = function (METHOD_NAME) {
  var regexp = /./;
  try {
    '/./'[METHOD_NAME](regexp);
  } catch (error1) {
    try {
      regexp[MATCH] = false;
      return '/./'[METHOD_NAME](regexp);
    } catch (error2) { /* empty */ }
  } return false;
};

var $ = _export;
var uncurryThis$4 = functionUncurryThis;
var notARegExp = notARegexp;
var requireObjectCoercible$2 = requireObjectCoercible$6;
var toString$2 = toString$5;
var correctIsRegExpLogic = correctIsRegexpLogic;

var stringIndexOf = uncurryThis$4(''.indexOf);

// `String.prototype.includes` method
// https://tc39.es/ecma262/#sec-string.prototype.includes
$({ target: 'String', proto: true, forced: !correctIsRegExpLogic('includes') }, {
  includes: function includes(searchString /* , position = 0 */) {
    return !!~stringIndexOf(
      toString$2(requireObjectCoercible$2(this)),
      toString$2(notARegExp(searchString)),
      arguments.length > 1 ? arguments[1] : undefined
    );
  }
});

/**
 * This is a custom React Hook that returns a function that toggles the state and
 * thereby triggers either a reset or a submit event.
 *
 * @param useState - Call the React useState hook.
 * @returns The state, A function that can be called to trigger a reset or submit event.
 */

const useTrigger = () => {
  const [state, setState] = React.useState(false);
  return [state, () => {
    setState(!state);
  }];
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * This is a custom React hook that calls the the useEffect hook whenever the passed deps change
 * EXCEPT during initial render.
 *
 * @param effect - The callback function passed into the useEffect hook.
 * @param deps - states or props based on which the callback function should be conditionally called.
 */

const useNonInitialEffect = (effect, deps) => {
  const initialRender = React.useRef(true);
  React.useEffect(() => {
    let returned;

    if (initialRender.current) {
      initialRender.current = false;
    } else {
      returned = effect();
    }

    if (returned && typeof returned === "function") {
      return returned();
    }
  }, deps);
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * This removes the used props from passedProps.
 *
 * @param props - Props to be filtered.
 */
const filterPassedProps = props => {
  delete props.type;
  delete props.name;
  delete props.label;
  delete props.listen;
  delete props.autoFocus;
  delete props.readOnly;
  delete props.disabled;
  delete props.required;
  delete props.requiredErrorMessage;
  delete props.validation;
  delete props.value;
  delete props.placeholder;
  delete props.children;
  delete props.default;
  delete props.showPassword;
  delete props.hidePassword;
  delete props.width;
  delete props.placeholder;
  delete props.className;
  delete props.size;
  delete props.onClick;
  delete props.startIndex;
  delete props.endIndex;
  delete props.wrapper;
  delete props.wrapperProps;
  delete props.hidden;
  delete props.displayErrorOn;
  delete props.icon;
  return props;
};

/**
 * Password component
 * @param props - Props injected to the component.
 */

const Password = props => {
  const [isShow, setIsShow] = React.useState(false);
  const filteredProps = filterPassedProps(Object.assign({}, props));
  return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Input, Object.assign({}, filteredProps, {
    label: props.label,
    value: props.value,
    error: props.error,
    type: isShow ? "text" : props.type,
    placeholder: props.placeholder,
    name: props.name,
    width: props.width,
    onBlur: props.onBlur,
    onChange: props.onChange,
    icon: /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Popup, {
      trigger: /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Icon, {
        name: !isShow ? "eye" : "eye slash",
        disabled: !props.value,
        link: true,
        onClick: () => {
          setIsShow(!isShow);
        }
      }),
      position: "top center",
      content: !isShow ? props.showPassword : props.hidePassword,
      inverted: true,
      popper: /*#__PURE__*/React__default["default"].createElement("div", {
        style: {
          filter: "none"
        }
      })
    }),
    autoFocus: props.autoFocus || false,
    readOnly: props.readOnly,
    disabled: props.disabled,
    required: props.required
  }));
};

var NATIVE_BIND = functionBindNative;

var FunctionPrototype = Function.prototype;
var apply$1 = FunctionPrototype.apply;
var call$2 = FunctionPrototype.call;

// eslint-disable-next-line es-x/no-reflect -- safe
var functionApply = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND ? call$2.bind(apply$1) : function () {
  return call$2.apply(apply$1, arguments);
});

// TODO: Remove from `core-js@4` since it's moved to entry points

var uncurryThis$3 = functionUncurryThis;
var defineBuiltIn = defineBuiltIn$5;
var regexpExec$2 = regexpExec$3;
var fails$2 = fails$k;
var wellKnownSymbol$1 = wellKnownSymbol$c;
var createNonEnumerableProperty = createNonEnumerableProperty$5;

var SPECIES$1 = wellKnownSymbol$1('species');
var RegExpPrototype = RegExp.prototype;

var fixRegexpWellKnownSymbolLogic = function (KEY, exec, FORCED, SHAM) {
  var SYMBOL = wellKnownSymbol$1(KEY);

  var DELEGATES_TO_SYMBOL = !fails$2(function () {
    // String methods call symbol-named RegEp methods
    var O = {};
    O[SYMBOL] = function () { return 7; };
    return ''[KEY](O) != 7;
  });

  var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL && !fails$2(function () {
    // Symbol-named RegExp methods call .exec
    var execCalled = false;
    var re = /a/;

    if (KEY === 'split') {
      // We can't use real regex here since it causes deoptimization
      // and serious performance degradation in V8
      // https://github.com/zloirock/core-js/issues/306
      re = {};
      // RegExp[@@split] doesn't call the regex's exec method, but first creates
      // a new one. We need to return the patched regex when creating the new one.
      re.constructor = {};
      re.constructor[SPECIES$1] = function () { return re; };
      re.flags = '';
      re[SYMBOL] = /./[SYMBOL];
    }

    re.exec = function () { execCalled = true; return null; };

    re[SYMBOL]('');
    return !execCalled;
  });

  if (
    !DELEGATES_TO_SYMBOL ||
    !DELEGATES_TO_EXEC ||
    FORCED
  ) {
    var uncurriedNativeRegExpMethod = uncurryThis$3(/./[SYMBOL]);
    var methods = exec(SYMBOL, ''[KEY], function (nativeMethod, regexp, str, arg2, forceStringMethod) {
      var uncurriedNativeMethod = uncurryThis$3(nativeMethod);
      var $exec = regexp.exec;
      if ($exec === regexpExec$2 || $exec === RegExpPrototype.exec) {
        if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
          // The native String method already delegates to @@method (this
          // polyfilled function), leasing to infinite recursion.
          // We avoid it by directly calling the native @@method method.
          return { done: true, value: uncurriedNativeRegExpMethod(regexp, str, arg2) };
        }
        return { done: true, value: uncurriedNativeMethod(str, regexp, arg2) };
      }
      return { done: false };
    });

    defineBuiltIn(String.prototype, KEY, methods[0]);
    defineBuiltIn(RegExpPrototype, SYMBOL, methods[1]);
  }

  if (SHAM) createNonEnumerableProperty(RegExpPrototype[SYMBOL], 'sham', true);
};

var uncurryThis$2 = functionUncurryThis;
var fails$1 = fails$k;
var isCallable$1 = isCallable$h;
var classof$1 = classof$4;
var getBuiltIn = getBuiltIn$5;
var inspectSource = inspectSource$2;

var noop = function () { /* empty */ };
var empty = [];
var construct = getBuiltIn('Reflect', 'construct');
var constructorRegExp = /^\s*(?:class|function)\b/;
var exec$1 = uncurryThis$2(constructorRegExp.exec);
var INCORRECT_TO_STRING = !constructorRegExp.exec(noop);

var isConstructorModern = function isConstructor(argument) {
  if (!isCallable$1(argument)) return false;
  try {
    construct(noop, empty, argument);
    return true;
  } catch (error) {
    return false;
  }
};

var isConstructorLegacy = function isConstructor(argument) {
  if (!isCallable$1(argument)) return false;
  switch (classof$1(argument)) {
    case 'AsyncFunction':
    case 'GeneratorFunction':
    case 'AsyncGeneratorFunction': return false;
  }
  try {
    // we can't check .prototype since constructors produced by .bind haven't it
    // `Function#toString` throws on some built-it function in some legacy engines
    // (for example, `DOMQuad` and similar in FF41-)
    return INCORRECT_TO_STRING || !!exec$1(constructorRegExp, inspectSource(argument));
  } catch (error) {
    return true;
  }
};

isConstructorLegacy.sham = true;

// `IsConstructor` abstract operation
// https://tc39.es/ecma262/#sec-isconstructor
var isConstructor$1 = !construct || fails$1(function () {
  var called;
  return isConstructorModern(isConstructorModern.call)
    || !isConstructorModern(Object)
    || !isConstructorModern(function () { called = true; })
    || called;
}) ? isConstructorLegacy : isConstructorModern;

var isConstructor = isConstructor$1;
var tryToString = tryToString$2;

var $TypeError$1 = TypeError;

// `Assert: IsConstructor(argument) is true`
var aConstructor$1 = function (argument) {
  if (isConstructor(argument)) return argument;
  throw $TypeError$1(tryToString(argument) + ' is not a constructor');
};

var anObject$2 = anObject$a;
var aConstructor = aConstructor$1;
var isNullOrUndefined$1 = isNullOrUndefined$4;
var wellKnownSymbol = wellKnownSymbol$c;

var SPECIES = wellKnownSymbol('species');

// `SpeciesConstructor` abstract operation
// https://tc39.es/ecma262/#sec-speciesconstructor
var speciesConstructor$1 = function (O, defaultConstructor) {
  var C = anObject$2(O).constructor;
  var S;
  return C === undefined || isNullOrUndefined$1(S = anObject$2(C)[SPECIES]) ? defaultConstructor : aConstructor(S);
};

var uncurryThis$1 = functionUncurryThis;
var toIntegerOrInfinity = toIntegerOrInfinity$3;
var toString$1 = toString$5;
var requireObjectCoercible$1 = requireObjectCoercible$6;

var charAt$1 = uncurryThis$1(''.charAt);
var charCodeAt = uncurryThis$1(''.charCodeAt);
var stringSlice$1 = uncurryThis$1(''.slice);

var createMethod = function (CONVERT_TO_STRING) {
  return function ($this, pos) {
    var S = toString$1(requireObjectCoercible$1($this));
    var position = toIntegerOrInfinity(pos);
    var size = S.length;
    var first, second;
    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
    first = charCodeAt(S, position);
    return first < 0xD800 || first > 0xDBFF || position + 1 === size
      || (second = charCodeAt(S, position + 1)) < 0xDC00 || second > 0xDFFF
        ? CONVERT_TO_STRING
          ? charAt$1(S, position)
          : first
        : CONVERT_TO_STRING
          ? stringSlice$1(S, position, position + 2)
          : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
  };
};

var stringMultibyte = {
  // `String.prototype.codePointAt` method
  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
  codeAt: createMethod(false),
  // `String.prototype.at` method
  // https://github.com/mathiasbynens/String.prototype.at
  charAt: createMethod(true)
};

var charAt = stringMultibyte.charAt;

// `AdvanceStringIndex` abstract operation
// https://tc39.es/ecma262/#sec-advancestringindex
var advanceStringIndex$1 = function (S, index, unicode) {
  return index + (unicode ? charAt(S, index).length : 1);
};

var toPropertyKey = toPropertyKey$3;
var definePropertyModule = objectDefineProperty;
var createPropertyDescriptor = createPropertyDescriptor$4;

var createProperty$1 = function (object, key, value) {
  var propertyKey = toPropertyKey(key);
  if (propertyKey in object) definePropertyModule.f(object, propertyKey, createPropertyDescriptor(0, value));
  else object[propertyKey] = value;
};

var toAbsoluteIndex = toAbsoluteIndex$2;
var lengthOfArrayLike = lengthOfArrayLike$2;
var createProperty = createProperty$1;

var $Array = Array;
var max = Math.max;

var arraySliceSimple = function (O, start, end) {
  var length = lengthOfArrayLike(O);
  var k = toAbsoluteIndex(start, length);
  var fin = toAbsoluteIndex(end === undefined ? length : end, length);
  var result = $Array(max(fin - k, 0));
  for (var n = 0; k < fin; k++, n++) createProperty(result, n, O[k]);
  result.length = n;
  return result;
};

var call$1 = functionCall;
var anObject$1 = anObject$a;
var isCallable = isCallable$h;
var classof = classofRaw$1;
var regexpExec$1 = regexpExec$3;

var $TypeError = TypeError;

// `RegExpExec` abstract operation
// https://tc39.es/ecma262/#sec-regexpexec
var regexpExecAbstract = function (R, S) {
  var exec = R.exec;
  if (isCallable(exec)) {
    var result = call$1(exec, R, S);
    if (result !== null) anObject$1(result);
    return result;
  }
  if (classof(R) === 'RegExp') return call$1(regexpExec$1, R, S);
  throw $TypeError('RegExp#exec called on incompatible receiver');
};

var apply = functionApply;
var call = functionCall;
var uncurryThis = functionUncurryThis;
var fixRegExpWellKnownSymbolLogic = fixRegexpWellKnownSymbolLogic;
var anObject = anObject$a;
var isNullOrUndefined = isNullOrUndefined$4;
var isRegExp = isRegexp;
var requireObjectCoercible = requireObjectCoercible$6;
var speciesConstructor = speciesConstructor$1;
var advanceStringIndex = advanceStringIndex$1;
var toLength = toLength$2;
var toString = toString$5;
var getMethod = getMethod$2;
var arraySlice = arraySliceSimple;
var callRegExpExec = regexpExecAbstract;
var regexpExec = regexpExec$3;
var stickyHelpers = regexpStickyHelpers;
var fails = fails$k;

var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y;
var MAX_UINT32 = 0xFFFFFFFF;
var min = Math.min;
var $push = [].push;
var exec = uncurryThis(/./.exec);
var push = uncurryThis($push);
var stringSlice = uncurryThis(''.slice);

// Chrome 51 has a buggy "split" implementation when RegExp#exec !== nativeExec
// Weex JS has frozen built-in prototypes, so use try / catch wrapper
var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = !fails(function () {
  // eslint-disable-next-line regexp/no-empty-group -- required for testing
  var re = /(?:)/;
  var originalExec = re.exec;
  re.exec = function () { return originalExec.apply(this, arguments); };
  var result = 'ab'.split(re);
  return result.length !== 2 || result[0] !== 'a' || result[1] !== 'b';
});

// @@split logic
fixRegExpWellKnownSymbolLogic('split', function (SPLIT, nativeSplit, maybeCallNative) {
  var internalSplit;
  if (
    'abbc'.split(/(b)*/)[1] == 'c' ||
    // eslint-disable-next-line regexp/no-empty-group -- required for testing
    'test'.split(/(?:)/, -1).length != 4 ||
    'ab'.split(/(?:ab)*/).length != 2 ||
    '.'.split(/(.?)(.?)/).length != 4 ||
    // eslint-disable-next-line regexp/no-empty-capturing-group, regexp/no-empty-group -- required for testing
    '.'.split(/()()/).length > 1 ||
    ''.split(/.?/).length
  ) {
    // based on es5-shim implementation, need to rework it
    internalSplit = function (separator, limit) {
      var string = toString(requireObjectCoercible(this));
      var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
      if (lim === 0) return [];
      if (separator === undefined) return [string];
      // If `separator` is not a regex, use native split
      if (!isRegExp(separator)) {
        return call(nativeSplit, string, separator, lim);
      }
      var output = [];
      var flags = (separator.ignoreCase ? 'i' : '') +
                  (separator.multiline ? 'm' : '') +
                  (separator.unicode ? 'u' : '') +
                  (separator.sticky ? 'y' : '');
      var lastLastIndex = 0;
      // Make `global` and avoid `lastIndex` issues by working with a copy
      var separatorCopy = new RegExp(separator.source, flags + 'g');
      var match, lastIndex, lastLength;
      while (match = call(regexpExec, separatorCopy, string)) {
        lastIndex = separatorCopy.lastIndex;
        if (lastIndex > lastLastIndex) {
          push(output, stringSlice(string, lastLastIndex, match.index));
          if (match.length > 1 && match.index < string.length) apply($push, output, arraySlice(match, 1));
          lastLength = match[0].length;
          lastLastIndex = lastIndex;
          if (output.length >= lim) break;
        }
        if (separatorCopy.lastIndex === match.index) separatorCopy.lastIndex++; // Avoid an infinite loop
      }
      if (lastLastIndex === string.length) {
        if (lastLength || !exec(separatorCopy, '')) push(output, '');
      } else push(output, stringSlice(string, lastLastIndex));
      return output.length > lim ? arraySlice(output, 0, lim) : output;
    };
  // Chakra, V8
  } else if ('0'.split(undefined, 0).length) {
    internalSplit = function (separator, limit) {
      return separator === undefined && limit === 0 ? [] : call(nativeSplit, this, separator, limit);
    };
  } else internalSplit = nativeSplit;

  return [
    // `String.prototype.split` method
    // https://tc39.es/ecma262/#sec-string.prototype.split
    function split(separator, limit) {
      var O = requireObjectCoercible(this);
      var splitter = isNullOrUndefined(separator) ? undefined : getMethod(separator, SPLIT);
      return splitter
        ? call(splitter, separator, O, limit)
        : call(internalSplit, toString(O), separator, limit);
    },
    // `RegExp.prototype[@@split]` method
    // https://tc39.es/ecma262/#sec-regexp.prototype-@@split
    //
    // NOTE: This cannot be properly polyfilled in engines that don't support
    // the 'y' flag.
    function (string, limit) {
      var rx = anObject(this);
      var S = toString(string);
      var res = maybeCallNative(internalSplit, rx, S, limit, internalSplit !== nativeSplit);

      if (res.done) return res.value;

      var C = speciesConstructor(rx, RegExp);

      var unicodeMatching = rx.unicode;
      var flags = (rx.ignoreCase ? 'i' : '') +
                  (rx.multiline ? 'm' : '') +
                  (rx.unicode ? 'u' : '') +
                  (UNSUPPORTED_Y ? 'g' : 'y');

      // ^(? + rx + ) is needed, in combination with some S slicing, to
      // simulate the 'y' flag.
      var splitter = new C(UNSUPPORTED_Y ? '^(?:' + rx.source + ')' : rx, flags);
      var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
      if (lim === 0) return [];
      if (S.length === 0) return callRegExpExec(splitter, S) === null ? [S] : [];
      var p = 0;
      var q = 0;
      var A = [];
      while (q < S.length) {
        splitter.lastIndex = UNSUPPORTED_Y ? 0 : q;
        var z = callRegExpExec(splitter, UNSUPPORTED_Y ? stringSlice(S, q) : S);
        var e;
        if (
          z === null ||
          (e = min(toLength(splitter.lastIndex + (UNSUPPORTED_Y ? q : 0)), S.length)) === p
        ) {
          q = advanceStringIndex(S, q, unicodeMatching);
        } else {
          push(A, stringSlice(S, p, q));
          if (A.length === lim) return A;
          for (var i = 1; i <= z.length - 1; i++) {
            push(A, z[i]);
            if (A.length === lim) return A;
          }
          q = p = e;
        }
      }
      push(A, stringSlice(S, p));
      return A;
    }
  ];
}, !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC, UNSUPPORTED_Y);

const QueryParameters = props => {
  const {
    value,
    onChange
  } = props;
  const QUERY_PARAMETER_SEPARATOR = "&";
  const SPECIAL_CHARACTERS = [",", "&", "=", "?"];
  const [queryParamName, setQueryParamName] = React.useState("");
  const [queryParamValue, setQueryParamValue] = React.useState("");
  const [errorMessage, setErrorMessage] = React.useState("");
  const [queryParams, setQueryParams] = React.useState([]);
  /**
   * Build query parameter object from the given string form.
   *
   * @param queryParameter - Query parameter in the string form.
   */

  const buildQueryParameter = queryParameter => {
    return {
      name: queryParameter === null || queryParameter === void 0 ? void 0 : queryParameter.split("=")[0],
      value: queryParameter === null || queryParameter === void 0 ? void 0 : queryParameter.split("=")[1]
    };
  };
  /**
   * Build query parameter string value, from it's object form.
   */


  const buildQueryParameterString = queryParam => queryParam.name + "=" + queryParam.value;
  /**
   * Build query parameters string value, from it's object form.
   */


  const buildQueryParametersString = queryParams => {
    var _a;

    return (_a = queryParams === null || queryParams === void 0 ? void 0 : queryParams.map(buildQueryParameterString)) === null || _a === void 0 ? void 0 : _a.join("&");
  };
  /**
   * Trigger provided onChange handler with provided query parameters.
   *
   * @param queryParams - QueryParameters.
   * @param onChange - OnChange handler.
   */


  const fireOnChangeEvent = (queryParams, onChange) => {
    onChange({
      target: {
        value: buildQueryParametersString(queryParams)
      }
    });
  };
  /**
   * Update input field values for query parameter.
   *
   * @param queryParam - QueryParameter.
   */


  const updateQueryParameterInputFields = queryParam => {
    setQueryParamName(queryParam === null || queryParam === void 0 ? void 0 : queryParam.name);
    setQueryParamValue(queryParam === null || queryParam === void 0 ? void 0 : queryParam.value);
  };
  /**
   * Called when `initialValue` is changed.
   */


  React.useEffect(() => {
    var _a;

    if (isEmpty__default["default"](value)) {
      return;
    }

    setQueryParams((_a = value.split(QUERY_PARAMETER_SEPARATOR)) === null || _a === void 0 ? void 0 : _a.map(buildQueryParameter));
  }, [value]);
  /**
   * Called when `queryParams` is changed.
   */

  React.useEffect(() => {
    fireOnChangeEvent(queryParams, onChange);
  }, [queryParams]);
  /**
   * Enter button option.
   *
   * @param e - The keypress event.
   */

  const keyPressed = e => {
    const key = e.which || e.charCode || e.keyCode;

    if (key === 13) {
      handleQueryParameterAdd(e);
    }
  };

  const handleQueryParameterAdd = event => {
    event.preventDefault();

    if (isEmpty__default["default"](queryParamName) || isEmpty__default["default"](queryParamValue)) {
      return;
    }

    setErrorMessage("");
    let isError = false;
    SPECIAL_CHARACTERS.map(c => {
      if (queryParamValue.includes(c) || queryParamName.includes(c)) {
        setErrorMessage("Cannot include \"" + c + "\" as a query parameter.");
        isError = true;
      }
    });

    if (isError) {
      return;
    }

    const output = [{
      name: queryParamName,
      value: queryParamValue
    }];
    queryParams.forEach(function (queryParam) {
      const existing = output.filter(item => {
        return item.name == queryParam.name;
      });

      if (existing.length) {
        const existingIndex = output.indexOf(existing[0]);
        output[existingIndex].value = queryParam.value + " " + output[existingIndex].value;
      } else {
        output.push(queryParam);
      }
    });
    setQueryParams(output);
    updateQueryParameterInputFields({
      name: "",
      value: ""
    });
  };

  const handleLabelRemove = queryParameter => {
    if (isEmpty__default["default"](queryParameter)) {
      return;
    }

    setQueryParams(filter__default["default"](queryParams, queryParam => !isEqual__default["default"](queryParam, buildQueryParameter(queryParameter))));
  };

  return /*#__PURE__*/React__default["default"].createElement(React__default["default"].Fragment, null, /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Group, {
    inline: true,
    widths: "equal",
    unstackable: true
  }, /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Input, {
    fluid: true,
    value: queryParamName,
    focus: true,
    placeholder: "name",
    onChange: (event, data) => {
      setQueryParamName(data.value);
    },
    onKeyDown: keyPressed
  }), /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Input, {
    fluid: true,
    value: queryParamValue,
    focus: true,
    placeholder: "value",
    onChange: (event, data) => {
      setQueryParamValue(data.value);
    },
    onKeyDown: keyPressed
  }), /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Popup, {
    trigger: /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Button, {
      onClick: e => handleQueryParameterAdd(e),
      icon: "add",
      type: "button",
      disabled: false
    }),
    position: "top center",
    content: "Add key value pair",
    inverted: true,
    popper: /*#__PURE__*/React__default["default"].createElement("div", {
      style: {
        filter: "none"
      }
    })
  })), /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Message, {
    visible: errorMessage !== "",
    error: true,
    content: errorMessage
  }), queryParams && (queryParams === null || queryParams === void 0 ? void 0 : queryParams.map((eachQueryParam, index) => {
    const queryParameter = eachQueryParam.name + "=" + eachQueryParam.value;
    return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Label, {
      key: index
    }, queryParameter, /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Icon, {
      name: "delete",
      onClick: () => handleLabelRemove(queryParameter)
    }));
  })));
};

/**
 * OIDC Authenticator Scopes field component.
 *
 * @param props - Props injected to the component.
 * @returns Functional component.
 */

const Scopes = props => {
  const {
    value,
    defaultValue,
    ["data-componentid"]: componentId,
    error,
    onBlur,
    onChange
  } = props;
  const SCOPE_SEPARATOR = " ";
  const [scopeValue, setScopeValue] = React.useState("");
  const [scopes, setScopes] = React.useState([]);
  /**
    * Called when `initialValue` is changed.
    */

  React.useEffect(() => {
    var _a;

    if (isEmpty__default["default"](value)) {
      return;
    }

    setScopes((_a = value.split(SCOPE_SEPARATOR)) === null || _a === void 0 ? void 0 : _a.map(buildScope));
  }, [value]);
  /**
    * Called when `scopes` is changed.
    */

  React.useEffect(() => {
    fireOnChangeEvent(scopes, onChange);
  }, [scopes]);
  /**
    * Build scope object from the given string form.
    *
    * @param scope - Scope in the string form.
    * @returns Scope as an object.
    */

  const buildScope = scope => {
    return {
      value: scope
    };
  };
  /**
    * Build scope string value, from it's object form.
    */


  const buildScopeString = scope => scope.value;
  /**
    * Build scopes string value, from scopes object list.
    */


  const buildScopesString = scopes => {
    var _a;

    return (_a = scopes === null || scopes === void 0 ? void 0 : scopes.map(buildScopeString)) === null || _a === void 0 ? void 0 : _a.join(SCOPE_SEPARATOR);
  };
  /**
    * Trigger provided onChange handler with provided scopes.
    *
    * @param scopes - Scopes.
    * @param onChange - onChange handler.
    */


  const fireOnChangeEvent = (scopes, onChange) => {
    onChange({
      target: {
        value: buildScopesString(scopes)
      }
    });
  };
  /**
    * Update input field values for scope.
    *
    * @param scope - Scope.
    */


  const updateScopeInputFields = scope => {
    setScopeValue(scope === null || scope === void 0 ? void 0 : scope.value);
  };
  /**
    * Enter button option.
    * @param e - keypress event.
    */


  const keyPressed = e => {
    if (e.key === "Enter") {
      handleScopeAdd(e);
    }
  };

  const handleScopeAdd = event => {
    event.preventDefault();

    if (isEmpty__default["default"](scopeValue)) {
      return;
    }

    const output = [{
      value: scopeValue
    }];
    scopes.forEach(function (scope) {
      const existing = output.filter(item => {
        return item.value == scope.value;
      });

      if (existing.length) {
        return;
      } else {
        output.push(scope);
      }
    });
    setScopes(output);
    updateScopeInputFields({
      value: ""
    });
  };

  const handleLabelRemove = scopeParam => {
    if (isEmpty__default["default"](scopeParam)) {
      return;
    }

    setScopes(filter__default["default"](scopes, scope => !isEqual__default["default"](scope, buildScope(scopeParam))));
  };

  return /*#__PURE__*/React__default["default"].createElement(React__default["default"].Fragment, null, /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Group, {
    inline: true,
    widths: "equal",
    unstackable: true
  }, /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Input, {
    fluid: true,
    value: scopeValue,
    onBlur: onBlur,
    focus: true,
    onChange: (event, data) => {
      setScopeValue(data.value.trim());
    },
    onKeyDown: keyPressed,
    "data-componentid": componentId
  }), /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Popup, {
    trigger: /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Button, {
      onClick: e => handleScopeAdd(e),
      icon: "add",
      type: "button",
      disabled: false,
      "data-componentid": componentId + "-add-button"
    }),
    position: "top center",

    /** TODO : Add this value from a translation */
    content: "Add scope",
    inverted: true,
    popper: /*#__PURE__*/React__default["default"].createElement("div", {
      style: {
        filter: "none"
      }
    })
  })), /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Message, {
    visible: !isEmpty__default["default"](error),
    error: true,
    content: error
  }), scopes && (scopes === null || scopes === void 0 ? void 0 : scopes.map((eachScope, index) => {
    const scope = eachScope.value;

    if (scope == defaultValue) {
      return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Label, {
        key: index
      }, scope);
    } else {
      return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Label, {
        key: index
      }, scope, /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Icon, {
        name: "delete",
        onClick: () => handleLabelRemove(scope)
      }));
    }
  })));
};

/**
 * Copyright (c) 2019, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Type guard to check if an input element is a text field.
 *
 * @param toBeDetermined - Form field to be checked.
 */
const isTextField = toBeDetermined => {
  return toBeDetermined.type === "email" || toBeDetermined.type === "password" || toBeDetermined.type === "number" || toBeDetermined.type === "text" || toBeDetermined.type === "textarea";
};
/**
 * Type guard to check if an input element is of the type Radio.
 *
 * @param toBeDetermined - Form field to be checked.
 */

const isRadioField = toBeDetermined => {
  return toBeDetermined.type === "radio";
};
/**
 * Type guard to check if an input element is of the type Password.
 *
 * @param toBeDetermined - Form field to be checked.
 */

const isPasswordField = toBeDetermined => {
  return toBeDetermined.type === "password";
};
/**
 * Type guard to check if an input element is of the type Dropdown.
 *
 * @param toBeDetermined - Form field to be checked.
 */

const isDropdownField = toBeDetermined => {
  return toBeDetermined.type === "dropdown";
};
/**
 * Type guard to check if an input element is of the type Checkbox.
 *
 * @param toBeDetermined - Form field to be checked.
 */

const isCheckBoxField = toBeDetermined => {
  return toBeDetermined.type === "checkbox";
};
/**
 * Type guard to check if an input element is of the type Scopes.
 *
 * @param toBeDetermined - Form field to be checked.
 */

const isScopesField = toBeDetermined => {
  return toBeDetermined.type === "scopes";
};
/**
 * Type guard to check if an input element is of the type Query Parameters.
 *
 * @param toBeDetermined - Form field to be checked.
 */

const isQueryParamsField = toBeDetermined => {
  return toBeDetermined.type === "queryParams";
};
/**
 * Type guard to check if an input element is of the type Toggle.
 *
 * @param toBeDetermined - Form field to be checked.
 */

const isToggleField = toBeDetermined => {
  return toBeDetermined.type === "toggle";
};
/**
 * Type guard to check if an input element is of the type Submit.
 *
 * @param toBeDetermined - Form field to be checked.
 */

const isSubmitField = toBeDetermined => {
  return toBeDetermined.type === "submit";
};
/**
 * Type guard to check if an input element is of the type Reset.
 *
 * @param toBeDetermined - Form field to be checked.
 */

const isResetField = toBeDetermined => {
  return toBeDetermined.type === "reset";
};
/**
 * Type guard to check if an input element is of the type Button.
 *
 * @param toBeDetermined - Form field to be checked.
 */

const isButtonField = toBeDetermined => {
  return toBeDetermined.type === "button";
};
/**
 * Type guard to check if an input element is of the type Divider.
 *
 * @param toBeDetermined - Form field to be checked.
 */

const isDivider = toBeDetermined => {
  return toBeDetermined.type === "divider";
};
/**
 * Type guard to check if an input element is of the type Custom.
 *
 * @param toBeDetermined - Form field to be checked.
 */

const isCustomField = toBeDetermined => {
  return toBeDetermined.type === "custom";
};
/**
 * Checks if the field is an input/checkbox/dropdown/radio/password field.
 *
 * @param toBeDetermined - Form field to be checked.
 */

const isInputField = toBeDetermined => {
  return isTextField(toBeDetermined) || isCheckBoxField(toBeDetermined) || isDropdownField(toBeDetermined) || isRadioField(toBeDetermined) || isPasswordField(toBeDetermined) || isToggleField(toBeDetermined) || isQueryParamsField(toBeDetermined) || isScopesField(toBeDetermined);
};

/**
 * The enter key.
 */

const ENTER_KEY = "Enter";
/**
 * This produces a InnerField component.
 *
 * @param props - The props for the InnerField component.
 */

const InnerField = /*#__PURE__*/React__default["default"].forwardRef((props, ref) => {
  const {
    passedProps,
    formProps
  } = props;
  const formField = Object.assign({}, passedProps);
  const filteredProps = filterPassedProps(Object.assign({}, passedProps));
  const {
    checkError,
    handleBlur,
    handleChange,
    handleToggle,
    handleChangeCheckBox,
    handleReset,
    form
  } = formProps;
  const formFieldClasses = classNames__default["default"]({
    hidden: formField.hidden,
    ["read-only"]: formField.readOnly
  }, formField.className);
  /**
   * Generates a semantic Form element.
   *
   * @param inputField - The input field to be generated to a semantic Form element.
   */

  const formFieldGenerator = inputField => {
    var _a;

    const {
      isError,
      errorMessages
    } = checkError(inputField);

    if (isTextField(inputField)) {
      if (isPasswordField(inputField)) {
        return /*#__PURE__*/React__default["default"].createElement(Password, Object.assign({}, passedProps, {
          label: inputField.label !== "" ? inputField.label : null,
          width: inputField.width,
          error: isError ? {
            content: errorMessages.map((errorMessage, index) => {
              return /*#__PURE__*/React__default["default"].createElement("p", {
                key: index
              }, errorMessage);
            })
          } : false,
          type: inputField.type,
          placeholder: inputField.placeholder,
          name: inputField.name,
          value: form.get(inputField.name) || "",
          onBlur: event => {
            handleBlur(event, inputField.name);
          },
          onChange: event => {
            handleChange(event.currentTarget.value, inputField.name);
          },
          showPassword: inputField.showPassword,
          hidePassword: inputField.hidePassword,
          autoFocus: inputField.autoFocus || false,
          readOnly: inputField.readOnly,
          disabled: inputField.disabled,
          required: inputField.label ? inputField.required : false,
          onKeyPress: event => {
            event.key === ENTER_KEY && handleBlur(event, inputField.name);
          }
        }));
      } else if (inputField.type === "textarea") {
        return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.TextArea, Object.assign({}, filteredProps, {
          label: inputField.label !== "" ? inputField.label : null,
          width: inputField.width,
          error: isError ? {
            content: errorMessages.map((errorMessage, index) => {
              return /*#__PURE__*/React__default["default"].createElement("p", {
                key: index
              }, errorMessage);
            })
          } : false,
          type: inputField.type,
          placeholder: inputField.placeholder,
          name: inputField.name,
          value: ((_a = form.get(inputField.name)) === null || _a === void 0 ? void 0 : _a.toString()) || "",
          onBlur: event => {
            handleBlur(event, inputField.name);
          },
          onChange: event => {
            handleChange(event.target.value, inputField.name);
          },
          autoFocus: inputField.autoFocus || false,
          readOnly: inputField.readOnly,
          disabled: inputField.disabled,
          required: inputField.label ? inputField.required : false,
          onKeyPress: event => {
            event.key === ENTER_KEY && handleBlur(event, inputField.name);
          }
        }));
      } else {
        return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Input, Object.assign({}, filteredProps, {
          label: inputField.label !== "" ? inputField.label : null,
          width: inputField.width,
          error: isError ? {
            content: errorMessages.map((errorMessage, index) => {
              return /*#__PURE__*/React__default["default"].createElement("p", {
                key: index
              }, errorMessage);
            })
          } : false,
          type: inputField.type,
          placeholder: inputField.placeholder,
          name: inputField.name,
          value: form.get(inputField.name) || "",
          onBlur: event => {
            handleBlur(event, inputField.name);
          },
          onChange: event => {
            handleChange(event.target.value, inputField.name);
          },
          autoFocus: inputField.autoFocus || false,
          readOnly: inputField.readOnly,
          disabled: inputField.disabled,
          required: inputField.label ? inputField.required : false,
          onKeyPress: event => {
            event.key === ENTER_KEY && handleBlur(event, inputField.name);
          },
          onKeyDown: inputField.type === "number" ? event => {
            const isNumber = /^[0-9]$/i.test(event.key);
            const isAllowed = (event.key === "a" || event.key === "v" || event.key === "c" || event.key === "x") && (event.ctrlKey === true || event.metaKey === true) || event.key === "ArrowRight" || event.key == "ArrowLeft" || event.key === "Delete" || event.key === "Backspace";
            !isNumber && !isAllowed && event.preventDefault();
          } : () => {
            return;
          },
          onPaste: inputField.type === "number" ? event => {
            const data = event.clipboardData.getData("Text");
            const isNumber = /^[0-9]+$/i.test(data);
            !isNumber && event.preventDefault();
          } : () => {
            return;
          }
        }));
      }
    } else if (isRadioField(inputField)) {
      return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Group, {
        grouped: true
      }, inputField.label !== "" ? /*#__PURE__*/React__default["default"].createElement("label", null, inputField.label) : null, inputField.hint && /*#__PURE__*/React__default["default"].createElement(FieldHint, {
        hint: inputField.hint
      }), inputField.children.map((radio, index) => {
        const {
          hint,
          label,
          value
        } = radio,
              rest = __rest(radio, ["hint", "label", "value"]);

        const field = /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Field, {
          key: index
        }, /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Radio, Object.assign({}, filteredProps, {
          label: label,
          name: inputField.name,
          value: value,
          checked: form.get(inputField.name) === value,
          onChange: (event, {
            value
          }) => {
            if ((inputField === null || inputField === void 0 ? void 0 : inputField.onBefore) && !inputField.onBefore(event, value)) {
              return;
            }

            handleChange(value.toString(), inputField.name);
          },
          onBlur: event => {
            handleBlur(event, inputField.name);
          },
          autoFocus: inputField.autoFocus || false,
          readOnly: inputField.readOnly,
          disabled: inputField.disabled,
          onKeyPress: event => {
            event.key === ENTER_KEY && handleBlur(event, inputField.name);
          }
        }, rest)));

        if (hint && hint.content) {
          return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Popup, {
            key: `${index}-popup`,
            header: hint.header,
            content: hint.content,
            trigger: field,
            popper: /*#__PURE__*/React__default["default"].createElement("div", {
              style: {
                filter: "none"
              }
            })
          });
        } else {
          return field;
        }
      }));
    } else if (isDropdownField(inputField)) {
      return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Select, Object.assign({}, filteredProps, {
        label: inputField.label !== "" ? inputField.label : null,
        placeholder: inputField.placeholder,
        options: inputField.children,
        value: form.get(inputField.name),
        width: inputField.width,
        onChange: (event, {
          value
        }) => {
          handleChange(value.toString(), inputField.name);
        },
        onBlur: event => {
          handleBlur(event, inputField.name);
        },
        error: isError ? {
          content: errorMessages.map((errorMessage, index) => {
            return /*#__PURE__*/React__default["default"].createElement("p", {
              key: index
            }, errorMessage);
          })
        } : false,
        autoFocus: inputField.autoFocus || false,
        disabled: inputField.disabled,
        required: inputField.label ? inputField.required : false,
        onKeyPress: event => {
          event.key === ENTER_KEY && handleBlur(event, inputField.name);
        }
      }));
    } else if (isCheckBoxField(inputField)) {
      return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Group, {
        grouped: true
      }, inputField.label && inputField.required ? /*#__PURE__*/React__default["default"].createElement("div", {
        className: "required field"
      }, /*#__PURE__*/React__default["default"].createElement("label", null, inputField.label)) : /*#__PURE__*/React__default["default"].createElement("div", {
        className: "field"
      }, /*#__PURE__*/React__default["default"].createElement("label", null, inputField.label)), inputField.hint && /*#__PURE__*/React__default["default"].createElement(FieldHint, {
        hint: inputField.hint
      }), inputField.children.map((checkbox, index) => {
        var _a;

        const field = /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Field, {
          key: index
        }, /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Checkbox, Object.assign({}, filteredProps, {
          label: checkbox.label,
          name: inputField.name,
          value: checkbox.value,
          checked: form.get(inputField.name) && form.get(inputField.name).includes(checkbox.value),
          onChange: (event, {
            value
          }) => {
            handleChangeCheckBox(value.toString(), inputField.name);
          },
          onBlur: event => {
            handleBlur(event, inputField.name);
          },
          error: index === 0 ? isError ? {
            content: errorMessages.map((errorMessage, indexError) => {
              return /*#__PURE__*/React__default["default"].createElement("p", {
                key: indexError
              }, errorMessage);
            }),
            pointing: "left"
          } : false : isError,
          autoFocus: inputField.autoFocus || false,
          readOnly: inputField.readOnly || checkbox.readOnly,
          disabled: (_a = checkbox.disabled) !== null && _a !== void 0 ? _a : inputField.disabled,
          defaultChecked: inputField.defaultChecked,
          onKeyPress: event => {
            event.key === ENTER_KEY && handleBlur(event, inputField.name);
          }
        })));

        if (checkbox.hint && checkbox.hint.content) {
          return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Popup, {
            key: `${index}-popup`,
            header: checkbox.hint.header,
            content: checkbox.hint.content,
            trigger: field,
            popper: /*#__PURE__*/React__default["default"].createElement("div", {
              style: {
                filter: "none"
              }
            })
          });
        } else {
          return field;
        }
      }));
    } else if (isScopesField(inputField)) {
      return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Group, {
        grouped: true
      }, /*#__PURE__*/React__default["default"].createElement("label", null, inputField.label, inputField.label && inputField.required ? /*#__PURE__*/React__default["default"].createElement("span", {
        className: "ui text color red"
      }, "*") : null), /*#__PURE__*/React__default["default"].createElement(Scopes, {
        value: inputField.value,
        defaultValue: inputField.defaultValue,
        "data-componentid": inputField["data-testid"],
        error: isError ? errorMessages[0] : "",
        onBlur: event => {
          handleBlur(event, inputField.name);
        },
        onChange: event => {
          handleChange(event.target.value, inputField.name);
        }
      }));
    } else if (isQueryParamsField(inputField)) {
      return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Group, {
        grouped: true
      }, /*#__PURE__*/React__default["default"].createElement("label", null, inputField.label, inputField.label && inputField.required ? /*#__PURE__*/React__default["default"].createElement("span", {
        className: "ui text color red"
      }, "*") : null), /*#__PURE__*/React__default["default"].createElement(QueryParameters, {
        name: inputField.name,
        value: inputField.value,
        onChange: event => {
          handleChange(event.target.value, inputField.name);
        }
      }));
    } else if (isToggleField(inputField)) {
      return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Checkbox, Object.assign({}, filteredProps, {
        label: inputField.label,
        name: inputField.name,
        value: inputField.value,
        checked: form.get(inputField.name) === "true",
        onChange: () => {
          handleToggle(inputField.name);
        },
        onBlur: event => {
          handleBlur(event, inputField.name);
        },
        error: isError ? {
          content: errorMessages.map((errorMessage, indexError) => {
            return /*#__PURE__*/React__default["default"].createElement("p", {
              key: indexError
            }, errorMessage);
          }),
          pointing: "left"
        } : false,
        autoFocus: inputField.autoFocus || false,
        readOnly: inputField.readOnly,
        disabled: inputField.disabled,
        defaultChecked: inputField.defaultChecked,
        onKeyPress: event => {
          event.key === ENTER_KEY && handleBlur(event, inputField.name);
        }
      }));
    } else if (isSubmitField(inputField)) {
      return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Button, Object.assign({}, filteredProps, {
        primary: true,
        size: inputField.size,
        className: inputField.className,
        type: inputField.type,
        disabled: inputField.disabled ? inputField.disabled(form) : false
      }), inputField.icon && /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Icon, {
        name: inputField.icon
      }), inputField.value);
    } else if (isResetField(inputField)) {
      return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Button, Object.assign({}, filteredProps, {
        size: inputField.size,
        className: inputField.className,
        onClick: handleReset,
        disabled: inputField.disabled ? inputField.disabled(form) : false
      }), inputField.icon && /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Icon, {
        name: inputField.icon
      }), inputField.value);
    } else if (isButtonField(inputField)) {
      return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Button, Object.assign({}, filteredProps, {
        size: inputField.size,
        className: inputField.className,
        onClick: event => {
          event.preventDefault();
          inputField.onClick();
        },
        disabled: inputField.disabled ? inputField.disabled(form) : false
      }), inputField.icon && /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Icon, {
        name: inputField.icon
      }), inputField.value);
    } else if (isDivider(inputField)) {
      return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Divider, {
        hidden: inputField.hidden
      });
    } else if (isCustomField(inputField)) {
      return inputField.element;
    }
  };

  return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form.Field, {
    className: formFieldClasses
  }, /*#__PURE__*/React__default["default"].createElement("div", {
    ref: ref
  }, formFieldGenerator(formField)));
});
/**
 * A component that creates a text hint. Used mainly within the
 * form fields. To see usages see {@link Checkbox} and {@link Radio}
 * conditional rendering sections in {@link InnerField}.
 *
 * @param hint - The hint text.
 */

const FieldHint = ({
  hint
}) => {
  return /*#__PURE__*/React__default["default"].createElement("div", {
    className: "ui-hint"
  }, /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Icon, {
    color: "grey",
    floated: "left",
    name: "info circle"
  }), hint);
};

/**
 * This function generates a Group component.
 *
 * @param props - The children to be grouped.
 */

const InnerGroupFields = props => {
  const {
    wrapper,
    wrapperProps,
    children
  } = props;
  const Wrapper = wrapper;
  return /*#__PURE__*/React__default["default"].createElement(Wrapper, Object.assign({}, wrapperProps), children);
};

/**
 * Copyright (c) 2019, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * This component renders Form elements based on the provided `type` prop.
 *
 * @param props - The form field.
 */
// eslint-disable-next-line @typescript-eslint/no-unused-vars

const Field = /*#__PURE__*/React__default["default"].forwardRef((props, ref) => {
  return null;
});
/**
 * This component groups form elements together.
 *
 * @param props - The children to be grouped.
 */
// eslint-disable-next-line @typescript-eslint/no-unused-vars

const GroupFields = props => {
  return null;
};

/**
 * This is a Forms component
 */

const Forms = /*#__PURE__*/React__default["default"].forwardRef((props, ref) => {
  const {
    onSubmit,
    resetState,
    submitState,
    onChange,
    onSubmitError,
    onStaleChange,
    children
  } = props,
        rest = __rest(props, ["onSubmit", "resetState", "submitState", "onChange", "onSubmitError", "onStaleChange", "children"]); // This holds the values of the form fields


  const [form, setForm] = React.useState(new Map()); // This specifies if any of the fields in the form has been touched or not

  const [isPure, setIsPure] = React.useState(true); // Specifies if there is stale data.

  const [isStale, setIsStale] = React.useState(false); // This specifies if a field's value is valid or not

  const [validFields, setValidFields] = React.useState(new Map());
  const validFieldsRef = React.useRef(new Map()); // This specifies if a field has been touched or not

  const [touchedFields, setTouchedFields] = React.useState(new Map());
  const [modifyingFields, setModifyingFields] = React.useState(new Map()); // This specifies if the required fields are  filled or not

  const [requiredFields, setRequiredFields] = React.useState(new Map());
  const requiredFieldsRef = React.useRef(new Map()); // This specifies if the `Submit` method has been called or not

  const [isSubmitting, setIsSubmitting] = React.useState(false); // This specifies if the submit has been clicked or not.

  const [startSubmission, setStartSubmission] = React.useState(false);
  const initialValues = React.useRef(new Map()); // This specifies if a form field is currently validating or not.

  const [isValidating, setIsValidating] = React.useState(false);
  const isValidatingRef = React.useRef(false); // This holds all the form field components

  const formFields = [];
  const flatReactChildren = []; // The lock to be used by `initMutex`

  let locked = false;
  React.useEffect(() => {
    if (!onStaleChange) {
      return;
    }

    onStaleChange(isStale);
  }, [isStale]);
  /**
   * Calls the onChange prop
   */

  const propagateOnChange = formValue => {
    if (onChange && typeof onChange === "function") {
      onChange(isPure, formValue);
    }
  };
  /**
   * This function calls the listener prop of the field that is calling the `handleChange` function.
   *
   * @param name - The name of the field.
   * @param newForm - Form values.
   */


  const listener = (name, newForm) => {
    React__default["default"].Children.map(flatReactChildren, element => {
      if (element.props.name && element.props.name === name && element.props.listen && typeof element.props.listen === "function") {
        element.props.listen(newForm);
      }
    });
  };
  /**
   * Handler for the onChange event.
   *
   * @param value - New value.
   * @param name - The name of the field.
   */


  const handleChange = (value, name) => {
    const tempForm = new Map(form);
    const tempTouchedFields = new Map(touchedFields);
    const tempModifyingFields = new Map(modifyingFields);
    tempForm.set(name, value);
    tempTouchedFields.set(name, true);
    tempModifyingFields.set(name, true);
    listener(name, tempForm);
    propagateOnChange(tempForm);
    setForm(tempForm);
    setIsPure(false);
    setTouchedFields(tempTouchedFields);
    setModifyingFields(tempModifyingFields);
    setIsStale(true);
  };
  /**
   * This toggles the boolean value.
   *
   * @param name - Field name.
   */


  const handleToggle = name => {
    const tempForm = new Map(form);
    const tempTouchedFields = new Map(touchedFields);
    tempForm.set(name, tempForm.get(name) === "true" ? "false" : "true");
    tempTouchedFields.set(name, true);
    listener(name, tempForm);
    propagateOnChange(tempForm);
    setForm(tempForm);
    setIsPure(false);
    setTouchedFields(tempTouchedFields);
    setIsStale(true);
  };
  /**
   * Handler for the onChange event of checkboxes.
   *
   * @param value - New value.
   * @param name - The name of the field.
   */


  const handleChangeCheckBox = (value, name) => {
    const tempForm = new Map(form);
    const selectedItems = tempForm.get(name);
    const tempTouchedFields = new Map(touchedFields);
    let itemIndex = -1;
    selectedItems.forEach((item, index) => {
      if (item === value) {
        itemIndex = index;
      }
    });
    itemIndex === -1 ? selectedItems.push(value) : selectedItems.splice(itemIndex, 1);
    tempForm.set(name, selectedItems);
    tempTouchedFields.set(name, true);
    listener(name, tempForm);
    propagateOnChange(tempForm);
    setForm(tempForm);
    setIsPure(false);
    setTouchedFields(tempTouchedFields);
    setIsStale(true);
  };
  /**
   * This function checks if a form field is valid.
   *
   * @param name - The name of the field.
   * @param requiredFieldsParam - A map of required fields.
   * @param validFieldsParam - A map of valid fields.
   */


  const validate = (name, requiredFieldsParam, validFieldsParam) => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b, _c;

    const inputField = formFields.find(formField => {
      return isInputField(formField) && formField.name === name;
    });
    const value = form.get(name);

    if (isInputField(inputField) && !isRadioField(inputField) && inputField.required) {
      if (!isCheckBoxField(inputField) && !isToggleField(inputField)) {
        const tempForm = new Map(form);
        tempForm.set(name, (_b = (_a = tempForm.get(name)) === null || _a === void 0 ? void 0 : _a.toString()) === null || _b === void 0 ? void 0 : _b.trim());
        setForm(tempForm);
        value !== null && ((_c = value === null || value === void 0 ? void 0 : value.toString()) === null || _c === void 0 ? void 0 : _c.trim()) !== "" ? requiredFieldsParam.set(name, true) : requiredFieldsParam.set(name, false);
      } else if (isToggleField(inputField)) {
        value !== null && value !== "false" ? requiredFieldsParam.set(name, true) : requiredFieldsParam.set(name, false);
      } else {
        value !== null && value.length > 0 ? requiredFieldsParam.set(name, true) : requiredFieldsParam.set(name, false);
      }
    }

    const validation = {
      errorMessages: [],
      isValid: true
    };

    if ((isTextField(inputField) || isDropdownField(inputField) || isScopesField(inputField)) && inputField.validation && !(form.get(name) === null || form.get(name) === "")) {
      yield inputField.validation(form.get(name), validation, new Map(form));
    }

    validFieldsParam.set(name, {
      errorMessages: validation.errorMessages,
      isValid: validation.isValid
    });
  });
  /**
   * Handler for the onBlur event.
   *
   * @param event - Event object.
   * @param name - The name of the field.
   */


  const handleBlur = (event, name) => __awaiter(void 0, void 0, void 0, function* () {
    const tempRequiredFields = new Map(requiredFieldsRef.current);
    const tempValidFields = new Map(validFieldsRef.current);
    const tempModifyingFields = new Map(modifyingFields);
    const tempTouchedFields = new Map(touchedFields);
    isValidatingRef.current = true;
    tempModifyingFields.set(name, false);
    tempTouchedFields.set(name, true);
    setIsValidating(true);
    setTouchedFields(tempTouchedFields);
    yield validate(name, tempRequiredFields, tempValidFields);
    validFieldsRef.current = new Map(tempValidFields);
    requiredFieldsRef.current = new Map(tempRequiredFields);
    isValidatingRef.current = false;
    setIsValidating(false);
    setValidFields(tempValidFields);
    setRequiredFields(tempRequiredFields);
    setModifyingFields(tempModifyingFields);
  });
  /**
   * Initialize form.
   *
   * @param isReset - Whether reset or not.
   */


  const init = isReset => {
    const tempForm = new Map(form);
    const tempRequiredFields = new Map(requiredFieldsRef.current);
    const tempValidFields = new Map(validFieldsRef.current);
    const tempTouchedFields = new Map(touchedFields);
    const formFieldNames = new Set();
    formFields.forEach(inputField => {
      /**
       * Check if the element is an input element(an element that can hold a value)
       *      -\> Then:
       *          Check if the field has not been touched OR the reset button has been pressed
       *             OR enableReInitialize is true and the initial value has changed
       *          -\> Then:
       *              Check if the element has a value and the reset button has not been clicked
       *                  -\> Then:
       *                      Set the value of the element to the corresponding key in the FormValue map
       *                  -\> Else:
       *                      Check if the element is a (radio OR Dropdown) AND it has a default value
       *                          -\> Then:
       *                              Assign the default value to the corresponding FormValue key
       *                          -\> Else:
       *                              Check if the  element is checkbox
       *                                  -\> Then:
       *                                      Assign an empty array to the corresponding FormValue key
       *                                  -\> Else:
       *                                          Check if the element is a toggle
       *                                              -\> Then:
       *                                                  Assign false
       *                                              -\> Else:
       *                                                  Assign an empty string value to the
       *                                                  corresponding FormValue key
       */
      if (isInputField(inputField)) {
        if (!touchedFields.get(inputField.name) || isReset || inputField.enableReinitialize && initialValues.current.get(inputField.name) !== inputField.value) {
          inputField.value && !isReset ? tempForm.set(inputField.name, inputField.value) : (isRadioField(inputField) || isDropdownField(inputField)) && inputField.default ? tempForm.set(inputField.name, inputField.default) : isCheckBoxField(inputField) ? tempForm.set(inputField.name, []) : isToggleField(inputField) ? tempForm.set(inputField.name, "false") : tempForm.set(inputField.name, "");
          initialValues.current.set(inputField.name, inputField.value);
        }
        /**
         * \{
         *      \{
         *          If the value is an array check if its length is zero
         *          OR check if it the value is empty or false
         *      \} OR
         *      the reset button has been clicked
         * \} AND
         *          it is not a radio field AND
         *          the field is required
         *
         * Then: Set required to false
         * Else: Set required to true
         *
         */


        const value = tempForm.get(inputField.name);
        (!(value instanceof Array && value.length > 0 || !(value instanceof Array) && value.trim && !!value.trim()) || isReset) && !isRadioField(inputField) && inputField.required ? tempRequiredFields.set(inputField.name, false) : tempRequiredFields.set(inputField.name, true);

        if (!tempValidFields.has(inputField.name) || isReset) {
          tempValidFields.set(inputField.name, {
            errorMessages: [],
            isValid: true
          });
          tempTouchedFields.set(inputField.name, false);
        }

        formFieldNames.add(inputField.name);
      }
    });
    /**
     * This removes all the redundant elements from the passed Map object and returns the stripped Map object.
     *
     * @param iterable - A Map object which should have redundant elements removed
     * @param neededFields - A Set object containing the names of the needed fields
     *
     * @returns stripped Map object.
     */

    const removeRedundant = (iterable, neededFields) => {
      const tempIterable = new Map(iterable);
      iterable.forEach((value, key) => {
        if (!neededFields.has(key)) {
          tempIterable.delete(key);
        }
      });
      return tempIterable;
    };
    /**
     * In case an existing form field is dynamically removed, remove all its data.
     */


    const leanForm = removeRedundant(tempForm, formFieldNames);
    const leanRequiredFields = removeRedundant(tempRequiredFields, formFieldNames);
    const leanValidFields = removeRedundant(tempValidFields, formFieldNames);
    const leanTouchedFields = removeRedundant(tempTouchedFields, formFieldNames);
    /**
     * Touched should not change if it is a reset.
     */

    if (!isReset) {
      setTouchedFields(leanTouchedFields);
    }

    setForm(leanForm);
    validFieldsRef.current = leanValidFields;
    requiredFieldsRef.current = leanRequiredFields;
    setValidFields(leanValidFields);
    setRequiredFields(leanRequiredFields);
  };
  /**
   * This is a mutex that wraps the `init` function.
   * This prevents `init` from being called twice when reset is triggered.
   *
   * @param lock - A boolean value that specifies if the mutex should be locked or not.
   */


  const initMutex = lock => {
    if (locked) {
      locked = false;
    } else {
      if (lock) {
        locked = true;
        init(true);
      } else {
        init(false);
      }
    }
  };
  /**
   * Resets form.
   */


  const reset = () => {
    setIsSubmitting(false);
    initMutex(true);
  };
  /**
   * Handles reset button click.
   *
   * @param event - The button click event.
   */


  const handleReset = event => {
    event.preventDefault();
    reset();
    locked = false;
  };
  /**
   * Checks if all the required fields are filled
   */


  const checkRequiredFieldsFilled = () => {
    let requiredFilled = true;
    requiredFieldsRef.current.forEach(requiredFieldParam => {
      if (!requiredFieldParam) {
        requiredFilled = false;
      }
    });
    return requiredFilled;
  };
  /**
   * Checks if all the fields are validated
   */


  const checkValidated = () => {
    let isValidated = true;
    validFieldsRef.current.forEach(validField => {
      if (!validField.isValid) {
        isValidated = false;
      }
    });
    return isValidated;
  };

  React.useEffect(() => {
    if (startSubmission && !isValidatingRef.current) {
      if (checkRequiredFieldsFilled() && checkValidated()) {
        setStartSubmission(false);
        setIsSubmitting(false);
        onSubmit && onSubmit(form);
      } else {
        onSubmitError && onSubmitError(requiredFields, validFields);
        setIsSubmitting(true);
        setStartSubmission(false);
      }
    } else {
      if (startSubmission) {
        setIsSubmitting(true);
      }
    }
  }, [startSubmission, isValidating]);
  /**
   * This validates the form and calls the `onSubmit` prop function
   */

  const submit = () => {
    setStartSubmission(true);
  };
  /**
   * Handler for onSubmit event.
   *
   * @param event - The form submit event.
   */


  const handleSubmit = event => {
    event.preventDefault();
    setIsStale(false);
    submit();
  };
  /**
   * Checks if the field has any errors (required but not filled | not validated).
   *
   * @param inputField - The form field to be checked.
   */


  const checkError = inputField => {
    if (isInputField(inputField) && !isRadioField(inputField) && inputField.required && !requiredFields.get(inputField.name) && !modifyingFields.get(inputField.name) && (isSubmitting || touchedFields.get(inputField.name) && inputField.displayErrorOn === "blur")) {
      return {
        errorMessages: [inputField.requiredErrorMessage],
        isError: true
      };
    } else if ((isTextField(inputField) || isDropdownField(inputField) || isScopesField(inputField)) && validFields.get(inputField.name) && !modifyingFields.get(inputField.name) && !validFields.get(inputField.name).isValid && (isSubmitting || touchedFields.get(inputField.name) && inputField.displayErrorOn === "blur")) {
      return {
        errorMessages: validFields.get(inputField.name).errorMessages,
        isError: true
      };
    } else {
      return {
        errorMessages: [],
        isError: false
      };
    }
  };
  /**
   * Calls submit when submit is triggered externally
   */


  useNonInitialEffect(() => {
    submit();
  }, [submitState]);
  /**
   * Calls reset when reset is triggered externally
   */

  useNonInitialEffect(() => {
    reset();
  }, [resetState]);
  /**
   * Initializes the state of the from every time the passed formFields prop changes
   */

  React.useEffect(() => {
    initMutex(false);
  }, [children]);
  /**
   * Parses the children and
   * 1.passes form event handler functions as props to all the Field components.
   * 2.extracts the props of the Field components.
   *
   * @param elements - Children to be passed.
   * @param fields - The list of fields to be passed.
   */

  const parseChildren = (elements, fields) => {
    return React__default["default"].Children.map(elements, element => {
      if (element) {
        if (element.type === Field) {
          fields.push(element.props);
          flatReactChildren.push(element);
          return /*#__PURE__*/React__default["default"].createElement(InnerField, {
            formProps: {
              checkError,
              form,
              handleBlur,
              handleChange,
              handleChangeCheckBox,
              handleReset,
              handleToggle
            },
            passedProps: Object.assign({}, element.props),
            ref: element.ref
          });
        } else if (element.type === GroupFields) {
          return /*#__PURE__*/React__default["default"].createElement(InnerGroupFields, Object.assign(Object.assign({}, element.props), {
            children: parseChildren(element.props.children, fields)
          }));
        } else if (element.props && element.props.children && React__default["default"].Children.count(element.props.children) > 0) {
          return /*#__PURE__*/React__default["default"].createElement(element.type, Object.assign(Object.assign({}, element.props), {
            children: parseChildren(element.props.children, fields)
          }));
        } else {
          return element;
        }
      }
    });
  };

  const mutatedChildren = children ? [...parseChildren(children, formFields)] : null;
  return /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Ref, {
    innerRef: ref
  }, /*#__PURE__*/React__default["default"].createElement(semanticUiReact.Form, Object.assign({}, rest, {
    noValidate: true,
    onSubmit: handleSubmit
  }), mutatedChildren));
});
Forms.defaultProps = {
  resetState: false,
  submitState: false
};

exports.Field = Field;
exports.Forms = Forms;
exports.GroupFields = GroupFields;
exports.filterPassedProps = filterPassedProps;
exports.useNonInitialEffect = useNonInitialEffect;
exports.useTrigger = useTrigger;
