"use strict";
/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UninitializedI18nInstanceException = void 0;
const i18n_module_exception_1 = require("./i18n-module-exception");
/**
 * Exception class to handle un-initialized i18n instance.
 */
class UninitializedI18nInstanceException extends i18n_module_exception_1.I18nModuleException {
    /**
     * Constructor.
     * @param {string | Record<string, unknown>} stack - Stack trace.
     */
    constructor(stack) {
        super("The i18n module is not initialized.", stack);
    }
}
exports.UninitializedI18nInstanceException = UninitializedI18nInstanceException;
//# sourceMappingURL=uninitialized-i18n-instance-exception.js.map