/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Specifies where the session information should be stored.
 */
export declare enum Storage {
    /**
     * Stores the session information in the local storage
     */
    LocalStorage = "localStorage",
    /**
     * Store the session information in the session storage.
     */
    SessionStorage = "sessionStorage",
    /**
     * Store the session information in the web worker.
     */
    WebWorker = "webWorker",
    BrowserMemory = "browserMemory"
}
//# sourceMappingURL=storage.d.ts.map