/**
 * Copyright (c) 2019, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { Buffer } from "buffer";
import { AsgardeoAuthException } from "@asgardeo/auth-js";
import base64url from "base64url";
import sha256 from "fast-sha256";
import { createLocalJWKSet, jwtVerify } from "jose";
import randombytes from "randombytes";
export class SPACryptoUtils {
    /**
     * Get URL encoded string.
     *
     * @returns {string} base 64 url encoded value.
     */
    base64URLEncode(value) {
        return base64url.encode(value).replace(/\+/g, "-").replace(/\//g, "_").replace(/=/g, "");
    }
    base64URLDecode(value) {
        return base64url.decode(value).toString();
    }
    hashSha256(data) {
        return Buffer.from(sha256(new TextEncoder().encode(data)));
    }
    generateRandomBytes(length) {
        return randombytes(length);
    }
    verifyJwt(idToken, jwk, algorithms, clientID, issuer, subject, clockTolerance) {
        return jwtVerify(idToken, createLocalJWKSet({
            keys: [jwk]
        }), {
            algorithms: algorithms,
            audience: clientID,
            clockTolerance: clockTolerance,
            issuer: issuer,
            subject: subject
        }).then(() => {
            return Promise.resolve(true);
        }).catch((error) => {
            var _a;
            return Promise.reject(new AsgardeoAuthException("SPA-CRYPTO-UTILS-VJ-IV01", (_a = error === null || error === void 0 ? void 0 : error.reason) !== null && _a !== void 0 ? _a : JSON.stringify(error), `${error === null || error === void 0 ? void 0 : error.code} ${error === null || error === void 0 ? void 0 : error.claim}`));
        });
    }
}
//# sourceMappingURL=crypto-utils.js.map