/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { AsgardeoAuthClient, SESSION_STATE, STATE } from "@asgardeo/auth-js";
import { SPAHelper } from "../helpers";
import { HttpClient } from "../http-client";
import { MemoryStore } from "../stores";
import { SPACryptoUtils } from "../utils/crypto-utils";
export const WebWorkerCore = (config, getAuthHelper) => __awaiter(void 0, void 0, void 0, function* () {
    const _store = new MemoryStore();
    const _cryptoUtils = new SPACryptoUtils();
    const _authenticationClient = new AsgardeoAuthClient(_store, _cryptoUtils);
    yield _authenticationClient.initialize(config);
    const _spaHelper = new SPAHelper(_authenticationClient);
    const _authenticationHelper = getAuthHelper(_authenticationClient, _spaHelper);
    const _dataLayer = _authenticationClient.getDataLayer();
    const _httpClient = HttpClient.getInstance();
    const attachToken = (request) => __awaiter(void 0, void 0, void 0, function* () {
        const requestConfig = Object.assign({ attachToken: true }, request);
        if (requestConfig.attachToken) {
            if (requestConfig.shouldAttachIDPAccessToken) {
                request.headers = Object.assign(Object.assign({}, request.headers), { Authorization: `Bearer ${yield _authenticationHelper.getIDPAccessToken()}` });
            }
            else {
                request.headers = Object.assign(Object.assign({}, request.headers), { Authorization: `Bearer ${yield _authenticationHelper.getAccessToken()}` });
            }
        }
    });
    (_httpClient === null || _httpClient === void 0 ? void 0 : _httpClient.init) && (yield _httpClient.init(true, attachToken));
    const setHttpRequestStartCallback = (callback) => {
        (_httpClient === null || _httpClient === void 0 ? void 0 : _httpClient.setHttpRequestStartCallback) && _httpClient.setHttpRequestStartCallback(callback);
    };
    const setHttpRequestSuccessCallback = (callback) => {
        (_httpClient === null || _httpClient === void 0 ? void 0 : _httpClient.setHttpRequestSuccessCallback) && _httpClient.setHttpRequestSuccessCallback(callback);
    };
    const setHttpRequestFinishCallback = (callback) => {
        (_httpClient === null || _httpClient === void 0 ? void 0 : _httpClient.setHttpRequestFinishCallback) && _httpClient.setHttpRequestFinishCallback(callback);
    };
    const httpRequest = (requestConfig) => __awaiter(void 0, void 0, void 0, function* () {
        return yield _authenticationHelper.httpRequest(_httpClient, requestConfig);
    });
    const httpRequestAll = (requestConfigs) => __awaiter(void 0, void 0, void 0, function* () {
        return yield _authenticationHelper.httpRequestAll(requestConfigs, _httpClient);
    });
    const enableHttpHandler = () => {
        _authenticationHelper.enableHttpHandler(_httpClient);
    };
    const disableHttpHandler = () => {
        _authenticationHelper.disableHttpHandler(_httpClient);
    };
    const getAuthorizationURL = (params) => __awaiter(void 0, void 0, void 0, function* () {
        return _authenticationClient
            .getAuthorizationURL(params)
            .then((url) => __awaiter(void 0, void 0, void 0, function* () {
            var _a;
            const urlObject = new URL(url);
            const state = (_a = urlObject.searchParams.get(STATE)) !== null && _a !== void 0 ? _a : "";
            const pkce = yield _authenticationClient.getPKCECode(state);
            return { authorizationURL: url, pkce: pkce };
        }))
            .catch((error) => Promise.reject(error));
    });
    const startAutoRefreshToken = () => __awaiter(void 0, void 0, void 0, function* () {
        _spaHelper.clearRefreshTokenTimeout();
        _spaHelper.refreshAccessTokenAutomatically(_authenticationHelper);
        return;
    });
    const requestAccessToken = (authorizationCode, sessionState, pkce, state) => __awaiter(void 0, void 0, void 0, function* () {
        return yield _authenticationHelper.requestAccessToken(authorizationCode, sessionState, undefined, pkce, state);
    });
    const signOut = () => __awaiter(void 0, void 0, void 0, function* () {
        _spaHelper.clearRefreshTokenTimeout();
        return yield _authenticationClient.getSignOutURL();
    });
    const getSignOutURL = () => __awaiter(void 0, void 0, void 0, function* () {
        return yield _authenticationClient.getSignOutURL();
    });
    const requestCustomGrant = (config) => __awaiter(void 0, void 0, void 0, function* () {
        return yield _authenticationHelper.requestCustomGrant(config);
    });
    const refreshAccessToken = () => __awaiter(void 0, void 0, void 0, function* () {
        try {
            return yield _authenticationHelper.refreshAccessToken();
        }
        catch (error) {
            return Promise.reject(error);
        }
    });
    const revokeAccessToken = () => __awaiter(void 0, void 0, void 0, function* () {
        const timer = yield _spaHelper.getRefreshTimeoutTimer();
        return _authenticationClient
            .revokeAccessToken()
            .then(() => {
            _spaHelper.clearRefreshTokenTimeout(timer);
            return Promise.resolve(true);
        })
            .catch((error) => Promise.reject(error));
    });
    const getBasicUserInfo = () => __awaiter(void 0, void 0, void 0, function* () {
        return _authenticationHelper.getBasicUserInfo();
    });
    const getDecodedIDToken = () => __awaiter(void 0, void 0, void 0, function* () {
        return _authenticationHelper.getDecodedIDToken();
    });
    const getCryptoHelper = () => __awaiter(void 0, void 0, void 0, function* () {
        return _authenticationHelper.getCryptoHelper();
    });
    const getDecodedIDPIDToken = () => __awaiter(void 0, void 0, void 0, function* () {
        return _authenticationHelper.getDecodedIDPIDToken();
    });
    const getIDToken = () => __awaiter(void 0, void 0, void 0, function* () {
        return _authenticationHelper.getIDToken();
    });
    const getOIDCServiceEndpoints = () => __awaiter(void 0, void 0, void 0, function* () {
        return _authenticationHelper.getOIDCServiceEndpoints();
    });
    const getAccessToken = () => {
        return _authenticationHelper.getAccessToken();
    };
    const isAuthenticated = () => {
        return _authenticationHelper.isAuthenticated();
    };
    const setSessionState = (sessionState) => __awaiter(void 0, void 0, void 0, function* () {
        yield _dataLayer.setSessionDataParameter(SESSION_STATE, sessionState);
        return;
    });
    const updateConfig = (config) => __awaiter(void 0, void 0, void 0, function* () {
        yield _authenticationClient.updateConfig(config);
        return;
    });
    const getConfigData = () => __awaiter(void 0, void 0, void 0, function* () {
        return _dataLayer.getConfigData();
    });
    return {
        disableHttpHandler,
        enableHttpHandler,
        getAccessToken,
        getAuthorizationURL,
        getBasicUserInfo,
        getConfigData,
        getCryptoHelper,
        getDecodedIDPIDToken,
        getDecodedIDToken,
        getIDToken,
        getOIDCServiceEndpoints,
        getSignOutURL,
        httpRequest,
        httpRequestAll,
        isAuthenticated,
        refreshAccessToken,
        requestAccessToken,
        requestCustomGrant,
        revokeAccessToken,
        setHttpRequestFinishCallback,
        setHttpRequestStartCallback,
        setHttpRequestSuccessCallback,
        setSessionState,
        signOut,
        startAutoRefreshToken,
        updateConfig
    };
});
//# sourceMappingURL=worker-core.js.map