"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.RefForward = void 0;
var React = require("react");
var utils_1 = require("./utils");
var RefForward = /** @class */ (function (_super) {
    __extends(RefForward, _super);
    function RefForward() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.handleRefOverride = function (node) {
            var _a = _this.props, children = _a.children, innerRef = _a.innerRef;
            utils_1.handleRef(children.ref, node);
            utils_1.handleRef(innerRef, node);
            _this.currentNode = node;
        };
        return _this;
    }
    RefForward.prototype.componentDidUpdate = function (prevProps) {
        if (prevProps.innerRef !== this.props.innerRef) {
            utils_1.handleRef(this.props.innerRef, this.currentNode);
        }
    };
    RefForward.prototype.componentWillUnmount = function () {
        delete this.currentNode;
    };
    RefForward.prototype.render = function () {
        var children = this.props.children;
        return React.cloneElement(children, {
            ref: this.handleRefOverride,
        });
    };
    return RefForward;
}(React.Component));
exports.RefForward = RefForward;
