"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLib = exports.createWebApp = exports.createApp = exports.updateNxJson = exports.callRule = void 0;
const path_1 = require("path");
const testing_1 = require("@angular-devkit/schematics/testing");
const workspace_1 = require("@nrwl/workspace/src/utils/workspace");
const workspace_2 = require("@nrwl/workspace");
const devkit_1 = require("@nrwl/devkit");
const testRunner = new testing_1.SchematicTestRunner('@nrwl/react', (0, path_1.join)(__dirname, '../../../generators.json'));
testRunner.registerCollection('@nrwl/jest', (0, path_1.join)(__dirname, '../../../../jest/generators.json'));
testRunner.registerCollection('@nrwl/cypress', (0, path_1.join)(__dirname, '../../../../cypress/generators.json'));
testRunner.registerCollection('@nrwl/storybook', (0, path_1.join)(__dirname, '../../../../storybook/generators.json'));
function callRule(rule, tree) {
    return testRunner.callRule(rule, tree).toPromise();
}
exports.callRule = callRule;
function updateNxJson(tree, update) {
    const updated = update((0, workspace_2.readJsonInTree)(tree, '/nx.json'));
    tree.overwrite('/nx.json', JSON.stringify(updated));
}
exports.updateNxJson = updateNxJson;
function createApp(tree, appName) {
    const { fileName } = (0, devkit_1.names)(appName);
    tree.create(`/apps/${fileName}/src/main.tsx`, `import ReactDOM from 'react-dom';\n`);
    updateNxJson(tree, (json) => {
        json.projects[appName] = { tags: [] };
        return json;
    });
    return callRule((0, workspace_1.updateWorkspace)((workspace) => {
        workspace.projects.add({
            name: fileName,
            root: `apps/${fileName}`,
            projectType: 'application',
            sourceRoot: `apps/${fileName}/src`,
            targets: {},
        });
    }), tree);
}
exports.createApp = createApp;
function createWebApp(tree, appName) {
    const { fileName } = (0, devkit_1.names)(appName);
    tree.create(`/apps/${fileName}/src/index.ts`, `\n`);
    updateNxJson(tree, (json) => {
        json.projects[appName] = { tags: [] };
        return json;
    });
    return callRule((0, workspace_1.updateWorkspace)((workspace) => {
        workspace.projects.add({
            name: fileName,
            root: `apps/${fileName}`,
            projectType: 'application',
            sourceRoot: `apps/${fileName}/src`,
            targets: {},
        });
    }), tree);
}
exports.createWebApp = createWebApp;
function createLib(tree, libName) {
    const { fileName } = (0, devkit_1.names)(libName);
    tree.create(`/libs/${fileName}/src/index.ts`, `import React from 'react';\n`);
    updateNxJson(tree, (json) => {
        json.projects[libName] = { tags: [] };
        return json;
    });
    return callRule((0, workspace_1.updateWorkspace)((workspace) => {
        workspace.projects.add({
            name: fileName,
            root: `libs/${fileName}`,
            projectType: 'library',
            sourceRoot: `libs/${fileName}/src`,
            targets: {},
        });
    }), tree);
}
exports.createLib = createLib;
//# sourceMappingURL=testing.js.map