"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.configurationSchematic = exports.configurationGenerator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const run_tasks_in_serial_1 = require("@nrwl/workspace/src/utilities/run-tasks-in-serial");
const cypress_project_1 = require("../cypress-project/cypress-project");
const init_1 = require("../init/init");
const util_functions_1 = require("./util-functions");
const linter_1 = require("@nrwl/linter");
const utilities_1 = require("../../utils/utilities");
const versions_1 = require("../../utils/versions");
function configurationGenerator(tree, rawSchema) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const schema = normalizeSchema(rawSchema);
        const tasks = [];
        const { projectType, targets } = (0, devkit_1.readProjectConfiguration)(tree, schema.name);
        const { nextBuildTarget, compiler } = (0, utilities_1.findStorybookAndBuildTargetsAndCompiler)(targets);
        const initTask = yield (0, init_1.initGenerator)(tree, {
            uiFramework: schema.uiFramework,
        });
        tasks.push(initTask);
        (0, util_functions_1.createRootStorybookDir)(tree, schema.js, schema.tsConfiguration);
        (0, util_functions_1.createProjectStorybookDir)(tree, schema.name, schema.uiFramework, schema.js, schema.tsConfiguration, !!nextBuildTarget, compiler === 'swc');
        (0, util_functions_1.configureTsProjectConfig)(tree, schema);
        (0, util_functions_1.configureTsSolutionConfig)(tree, schema);
        (0, util_functions_1.updateLintConfig)(tree, schema);
        if (schema.uiFramework === '@storybook/angular') {
            (0, util_functions_1.addAngularStorybookTask)(tree, schema.name);
        }
        else {
            (0, util_functions_1.addStorybookTask)(tree, schema.name, schema.uiFramework);
        }
        if (schema.configureCypress) {
            if (projectType !== 'application') {
                const cypressTask = yield (0, cypress_project_1.cypressProjectGenerator)(tree, {
                    name: schema.name,
                    js: schema.js,
                    linter: schema.linter,
                    directory: schema.cypressDirectory,
                    standaloneConfig: schema.standaloneConfig,
                });
                tasks.push(cypressTask);
            }
            else {
                devkit_1.logger.warn('There is already an e2e project setup');
            }
        }
        if (nextBuildTarget && projectType === 'application') {
            tasks.push((0, devkit_1.addDependenciesToPackageJson)(tree, {}, {
                ['storybook-addon-next']: versions_1.storybookNextAddonVersion,
                ['storybook-addon-swc']: versions_1.storybookSwcAddonVersion,
            }));
        }
        else if (compiler === 'swc') {
            tasks.push((0, devkit_1.addDependenciesToPackageJson)(tree, {}, {
                ['storybook-addon-swc']: versions_1.storybookSwcAddonVersion,
            }));
        }
        yield (0, devkit_1.formatFiles)(tree);
        return (0, run_tasks_in_serial_1.runTasksInSerial)(...tasks);
    });
}
exports.configurationGenerator = configurationGenerator;
function normalizeSchema(schema) {
    const defaults = {
        configureCypress: true,
        linter: linter_1.Linter.TsLint,
        js: false,
    };
    return Object.assign(Object.assign({}, defaults), schema);
}
exports.default = configurationGenerator;
exports.configurationSchematic = (0, devkit_1.convertNxGenerator)(configurationGenerator);
//# sourceMappingURL=configuration.js.map