/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * This class will contain front end permissions which is required to
 * be passed on to the permission context and also while checking the
 * relvant permission is available when the show component is evaluvating.
 */
export class AccessControlConstants {
    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     *
     */
    /* eslint-disable @typescript-eslint/no-empty-function */
    constructor() { }
}
/**
 * Application Feature permisison
 */
AccessControlConstants.APPLICATION = "application";
/**
 * Application read permission
 */
AccessControlConstants.APPLICATION_READ = "application:read";
/**
 * Application write permission
 */
AccessControlConstants.APPLICATION_WRITE = "application:write";
/**
 * Application edit permission
 */
AccessControlConstants.APPLICATION_EDIT = "application:edit";
/**
 * Application delete permission
 */
AccessControlConstants.APPLICATION_DELETE = "application:delete";
/**
 * Identity provider feature permission
 */
AccessControlConstants.IDP = "identity_provider";
/**
 * Identity provider read permission
 */
AccessControlConstants.IDP_READ = "identity_provider:read";
/**
 * Identity provider write permission
 */
AccessControlConstants.IDP_WRITE = "identity_provider:write";
/**
 * Identity provider edit permission
 */
AccessControlConstants.IDP_EDIT = "identity_provider:edit";
/**
 * Identity provider delete permission
 */
AccessControlConstants.IDP_DELETE = "identity_provider:delete";
/**
 * Users feature permission
 */
AccessControlConstants.USER = "user";
/**
 * Users read permission
 */
AccessControlConstants.USER_READ = "user:read";
/**
 * Users write permission
 */
AccessControlConstants.USER_WRITE = "user:write";
/**
 * Users edit permission
 */
AccessControlConstants.USER_EDIT = "user:edit";
/**
 * Users delete permission
 */
AccessControlConstants.USER_DELETE = "user:delete";
/**
 * Group feature permission
 */
AccessControlConstants.GROUP = "group";
/**
 * Group read permission
 */
AccessControlConstants.GROUP_READ = "group:read";
/**
 * Group write permission
 */
AccessControlConstants.GROUP_WRITE = "group:write";
/**
 * Group edit permission
 */
AccessControlConstants.GROUP_EDIT = "group:edit";
/**
 * Group delete permission
 */
AccessControlConstants.GROUP_DELETE = "group:delete";
/**
 * Role feature permission
 */
AccessControlConstants.ROLE = "role";
/**
 * Role read permission
 */
AccessControlConstants.ROLE_READ = "role:read";
/**
 * Role write permission
 */
AccessControlConstants.ROLE_WRITE = "role:write";
/**
 * Role edit permission
 */
AccessControlConstants.ROLE_EDIT = "role:edit";
/**
 * Role delete permission
 */
AccessControlConstants.ROLE_DELETE = "role:delete";
/**
 * Attribute feature permission
 */
AccessControlConstants.ATTRIBUTE = "attribute";
/**
 * Attribute read permission
 */
AccessControlConstants.ATTRIBUTE_READ = "attribute:read";
/**
 * Attribute write permission
 */
AccessControlConstants.ATTRIBUTE_WRITE = "attribute:write";
/**
 * Attribute edit permission
 */
AccessControlConstants.ATTRIBUTE_EDIT = "attribute:edit";
/**
 * Attribute delete permission
 */
AccessControlConstants.ATTRIBUTE_DELETE = "attribute:delete";
/**
 * Branding feature permission
 */
AccessControlConstants.BRANDING = "branding";
/**
 * Branding read permission
 */
AccessControlConstants.BRANDING_READ = "branding:read";
/**
 * Branding write permission
 */
AccessControlConstants.BRANDING_WRITE = "branding:write";
/**
 * Branding edit permission
 */
AccessControlConstants.BRANDING_EDIT = "branding:edit";
/**
 * Branding delete permission
 */
AccessControlConstants.BRANDING_DELETE = "branding:delete";
/**
 * Scope feature permission
 */
AccessControlConstants.SCOPE = "scope";
/**
 * Scope read permission
 */
AccessControlConstants.SCOPE_READ = "scope:read";
/**
 * Scope write permission
 */
AccessControlConstants.SCOPE_WRITE = "scope:write";
/**
 * Scope edit permission
 */
AccessControlConstants.SCOPE_EDIT = "scope:edit";
/**
 * Scope delete permission
 */
AccessControlConstants.SCOPE_DELETE = "scope:delete";
/**
 * Full console scope
 */
AccessControlConstants.FULL_UI_SCOPE = "console:full";
/**
 * Secret Management Write/Create Scope.
 */
AccessControlConstants.SECRET_WRITE = "internal_secret_mgt_add";
/**
 * Secret Management Read Scope.
 */
AccessControlConstants.SECRET_READ = "internal_secret_mgt_view";
/**
 * Secret Management Edit/Update Scope.
 */
AccessControlConstants.SECRET_EDIT = "internal_secret_mgt_update";
/**
 * Secret Management Delete/Remove Scope.
 */
AccessControlConstants.SECRET_DELETE = "internal_secret_mgt_delete";
/**
 * User stores feature permission
 */
AccessControlConstants.USER_STORE = "userStores";
/**
 * User stores read permission
 */
AccessControlConstants.USER_STORE_READ = "userStores:read";
/**
 * User stores write permission
 */
AccessControlConstants.USER_STORE_WRITE = "userStores:write";
/**
 * User stores edit permission
 */
AccessControlConstants.USER_STORE_EDIT = "userStores:edit";
/**
 * User stores delete permission
 */
AccessControlConstants.USER_STORE_DELETE = "userStores:delete";
/**
 * Organization feature permission.
 */
AccessControlConstants.ORGANIZATION = "organization";
/**
 * Organization write permission.
 */
AccessControlConstants.ORGANIZATION_WRITE = "organization:write";
/**
 * Organization edit permission.
 */
AccessControlConstants.ORGANIZATION_EDIT = "organization:edit";
/**
 * Organization delete permission.
 */
AccessControlConstants.ORGANIZATION_DELETE = "organization:delete";
/**
 * Organization read permission.
 */
AccessControlConstants.ORGANIZATION_READ = "organization:read";
/**
 * Organization feature permission.
 */
AccessControlConstants.ORGANIZATION_ROLES = "organization_roles";
/**
 * Organization write permission.
 */
AccessControlConstants.ORGANIZATION_ROLES_WRITE = "organization_roles:write";
/**
 * Organization edit permission.
 */
AccessControlConstants.ORGANIZATION_ROLES_EDIT = "organization_roles:edit";
/**
 * Organization delete permission.
 */
AccessControlConstants.ORGANIZATION_ROLES_DELETE = "organization_roles:delete";
/**
 * Organization read permission.
 */
AccessControlConstants.ORGANIZATION_ROLES_READ = "organization_roles:read";
/**
 * Event configuration read permission
 */
AccessControlConstants.EVENT_CONFIG_READ = "internal_event_config_view";
/**
 * Event configuration write permission
 */
AccessControlConstants.EVENT_CONFIG_WRITE = "internal_event_config_update";
/**
 * EventConfig edit permission
 */
AccessControlConstants.EVENT_CONFIG_EDIT = "internal_event_config_update";
/**
 * EventConfig delete permission
 */
AccessControlConstants.EVENT_CONFIG_DELETE = "internal_event_config_update";
//# sourceMappingURL=access-control-constants.js.map