/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Class containing i18n module constants.
 */
export declare class I18nModuleConstants {
    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     *
     * @hideconstructor
     */
    private constructor();
    /**
     * Name of the i18n module.
     * @constant
     * @type {string}
     * @default
     */
    static readonly MODULE_NAME: string;
    /**
     * Common namespace.
     * @constant
     * @type {string}
     * @default
     */
    static readonly COMMON_NAMESPACE: string;
    /**
     * User portal namespace.
     * @constant
     * @type {string}
     * @default
     */
    static readonly MY_ACCOUNT_NAMESPACE: string;
    /**
     * Console portal namespace.
     * @constant
     * @type {string}
     * @default
     */
    static readonly CONSOLE_PORTAL_NAMESPACE: string;
    /**
     * Extensions namespace.
     * @constant
     * @type {string}
     * @default
     */
    static readonly EXTENSIONS_NAMESPACE: string;
    /**
     * Default fallback language.
     * @constant
     * @type {string}
     * @default
     */
    static readonly DEFAULT_FALLBACK_LANGUAGE: string;
    /**
     * Metadata file name.
     * @constant
     * @type {string}
     * @default
     */
    static readonly META_FILENAME: string;
}
